Ext.define('TextFooterWidgetModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'title', type:'string' },
        { name:'value', type:'string' },
		{ name:'unit', type:'string' },
		{ name:'unitText', type:'string' },
		{ name:'footer', type:'string' },
		{ name:'fun', type:'string' },
		{ name:'legend', type:'string' },
		{ name:'graphType', type:'number' },
		{ name:'changeTabView', type:'string' },
		{ name:'linkurl', type:'string' },
		{ name:'test_org', type:'string' },
		{ name:'measure_org', type:'string' },
		{ name:'handSymbol', type:'string' },
		{ name:'spikeClass', type:'string' },
		{ name:'spikeData', type:'string' },
		{ name:'valueArr'},
		{ name:'graphData' }
    ]
});

Ext.define('widgets.TextFooterGraph', {
		extend: 'Ext.container.Container',
		alias:'widget.textfootergraph',
		ui:'appflowtraffic',
		autoDestroy:true,
		data:'',
		id:'',
		store:null,
		items:[],
		updateData:function(data){
			var me = this;
			me.items.items[0].store.loadRawData(data);
			if(this.iftempDouble != null && this.iftempDouble)
			{
				if(!Ext.isEmpty(data) && !Ext.isEmpty(data.graphData) && !Ext.isEmpty(data.graphData.DataSetCount) && !Ext.isEmpty(data.graphData.DataSetArr))
				{
					if(data.graphData.DataSetCount != null && data.graphData.DataSetCount > 0)
					{
						for(var t=1;t<data.graphData.DataSetCount+1;t++)
						{
							var jsonData = getHighChartsJSONforTextFooterGraph(data,this.id,t-1);
							$('#graph-textfooter-'+t+'-'+this.id).highcharts(jsonData);
						}
					}							
				}
			}
			else
			{
				if(!Ext.isEmpty(data) && !Ext.isEmpty(data.graphData) && !Ext.isEmpty(data.graphData.DataSet) && Ext.isEmpty(data.graphData.DataSet[0].ERROR)){
					var jsonData = getHighChartsJSONforTextFooterGraph(data,me.id);
					$('#graph-textfooter'+me.id).highcharts(jsonData);
				}
			}
							
		},
		items:[],
		listeners:{
			'afterrender':function(e){
				try
				{
					var cyui = this.iftempDouble;
				}
				catch (e)
				{
					this.iftempDouble = false;
				}
				if(this.iftempDouble != null && this.iftempDouble)
				{
					textfooterTpl=new Ext.XTemplate(
						'<tpl for=".">',
						'<div class="widgetholders {handSymbol}" style="border:0px solid blue">',
							'<div class="s_box">',
								'<div class="fontStyleRobotRegular font_bold12 div_center " style="border:0px solid red !important;float:left;width:45%">',
								'<tpl if="state">',
									'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
									'<span data-qtip="{title}" style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;">{title}</ span></div>',
								'<tpl else>',
									'<span data-qtip="{title}" style="width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;line-height:14px">{title}</ span></div>',
								'</tpl>',								
								 '<div style="float:right;width:46%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:15px;text-align:right;display:inline-block;line-height:18px">{value}<span class="font_normal10" style="margin-left:3px;line-height:18px;text-align:left;vertical-align:top;">{footer}{unitText}</span></div></div>',
								 '<div style="clear:both"></div>',
						 '</div>',
							'<div class="b_box" onclick=\"loadView(\'{changeTabView}\',\'\',\'\',\'{test_org}\',\'{measure_org}\',\'{linkurl}\');\">',
							  '<div class="fontStyleRobotRegular font_bold13 title">',
								'<tpl if="state">',
									'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
									 '<span data-qtip="{title}" style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;">{title}</ span></div>',
								'<tpl else>',
									 '<span data-qtip="{title}" style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;">{title}</ span></div>',
								'</tpl>',
								'<tpl if="graphType !=&quot; &quot;">',
								'<div style="border:0px solid green !important;display:flex">',
									'<tpl for="valueArr">',										
										'<div class="d_m_t10" style="flex:1">',
											'<tpl if="xindex%2 === 0">',
												'<table class="chartLegendDivider" style="width:100%;margin:19px auto;border:0px solid blue"><tr>',
											'<tpl else>',
												'<table style="width:100%;margin:22px auto;border:0px solid green"><tr>',
											'</tpl>',
											'<tpl if="title !=&quot;s&quot;" || !=&quot;%&quot;">',
												'<tpl if="xindex%2 === 0">',
													'<div style="margin-left:15px;display:table;float:left" class="font_normal9 fontStyleRobotRegular grayColor"><span class="titleLine">{title}</ span></div>',
												'<tpl else>',
													'<div style="margin-left:20px;display:table;float:left" class="font_normal9 fontStyleRobotRegular grayColor"><span class="titleLine">{title}</ span></div>',
												'</tpl>',												
											'<tpl else>',
												'<div style="margin-left:35px;display:table;float:left" class="font_normal9 fontStyleRobotRegular grayColor"><span></ span></div>',
											'</tpl>',
											'<tpl if="xindex%2 === 0">',
												'<td style="text-align:center;position:relative;top:0px;padding-right:10px;padding-left:10px;">',
											'<tpl else>',
												'<td style="text-align:center;position:relative;top:0px;padding-right:10px;padding-left:20px;">',
											'</tpl>',		
											'<span class="fontStyleRobotRegular font_normal24">{value}</span>',
											'<tpl if="unitText !=&quot; &quot;">',
												'<span class="fontStyleRobotRegular font_normal19">{unitText}</span></td>',
											'<tpl else>',
												'<div class="font_normal12 legendLabel" style="text-align:center">{footer}</div></div>',
												'</div>',
											'</tpl>',
											'<tpl if="value !=&quot;-&quot;">',
												'<td><div id="graph-textfooter-{#}-'+this.id+'" class="appflow_rum_graph" style="width:100px;height:30px;position:relative;top:0px;"></div></td>',
											'<tpl else>',
												'<td><div id="graph-textfooter-{#}-'+this.id+'" class="appflow_rum_graph" style="width:100px;height:30px;position:relative;top:0px;"></div></td>',
											'</tpl>',
											'</div></tr></table>',
										'</div>',
									'</tpl>',
								'<tpl else>',
									'<div class="fontStyleRobotRegular font_normal24 d_m_t35" style="text-align:center">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></div>',
									'<div class="fontStyleRobotRegular font_normal12 legendLabel d_m_t15" style="text-align:center">{footer}</div>',
								'</tpl>',
							'</div>',	
						'</div>',
						'<tpl if="spikeClass">',
							'<tpl if="spikeClass != &quot;GOOD&quot;">',
								'<a href="javascript:openAlarmPopup(\'{test_org}\',\'{measure_org}\',\'{spikeClass}\',\'true\',\'{spikeData}\')"><div class="b_box" style="bottom:16px;position:absolute;border:0px solid green !important;float:left;"><div class="outerbox"><div id="triangle-bottomleft"></div><div class="stateBookmark_{spikeClass} boxShadow"><img style="width:16px;height:16px;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/component_icons/svg/state_white_{spikeClass}.svg" style="opacity:10" /><span class="fontStyleRobotRegular font_bold12" style="margin-left:5px">{spikeData}</span></div></div></div></div></a>',
							'<tpl else>',
								'<div class="b_box" style="cursor:default;bottom:16px;position:absolute;border:0px solid green !important;float:left;"><div class="outerbox"><div id="triangle-bottomleft"></div><div class="stateBookmark_{spikeClass} boxShadow"><img style="width:16px;height:16px;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/component_icons/svg/state_white_{spikeClass}.svg" style="opacity:10" /><span class="fontStyleRobotRegular font_bold12" style="margin-left:5px">{spikeData}</span></div></div></div></div>',
							'</tpl>',
						'</tpl>',
						'</tpl>'
					);
					var g_item1 = this.getDoubleTextFooterItem(this.data,this.num,this.id);
					this.add(g_item1);
				}
				else
				{
					textfooterTpl=new Ext.XTemplate(
						'<tpl for=".">',
						'<div class="widgetholders {handSymbol}" style="border:0px solid blue">',
							'<div class="s_box">',
								'<div class="fontStyleRobotRegular font_bold12 div_center " style="border:0px solid red !important;float:left;width:45%">',
								'<tpl if="state">',
									'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
									'<span data-qtip="{title}" style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;">{title}</ span></div>',
								'<tpl else>',
									'<span data-qtip="{title}" style="width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;line-height:14px">{title}</ span></div>',
								'</tpl>',
								
								 '<div style="float:right;width:46%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:15px;text-align:right;display:inline-block;line-height:18px">{value}<span class="font_normal10" style="margin-left:3px;line-height:18px;text-align:left;vertical-align:top;">{footer}{unitText}</span></div></div>',
								 '<div style="clear:both"></div>',
						 '</div>',
							'<div class="b_box" onclick=\"loadView(\'{changeTabView}\',\'\',\'\',\'{test_org}\',\'{measure_org}\',\'{linkurl}\');\">',
							  '<div class="fontStyleRobotRegular font_bold13 title">',
								'<tpl if="state">',
									'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
									 '<span data-qtip="{title}" style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;">{title}</ span></div>',
								'<tpl else>',
									 '<span data-qtip="{title}" style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;">{title}</ span></div>',
								'</tpl>',
								'<tpl if="graphType !=&quot; &quot;">',

									'<div class="d_m_t35"><table style="margin:22px auto;"><tr>',
									'<td style="text-align:center;position:relative;top:-11px;padding-right:10px;">',
										'<span class="fontStyleRobotRegular font_normal25">{value}</span>',
									'<tpl if="unitText !=&quot; &quot;">',
										'<span class="fontStyleRobotRegular font_normal19">{unitText}</span></td>',
									'<tpl else>',
										'</div>',
									'</tpl>',
										//'<div class="font_normal11 legendLabel" style="text-align:center">{legend}</div>',
									'<tpl if="value !=&quot;-&quot;">',
										//'<td style="width:50%;"><div id="graph-textfooter'+this.id+'" class="appflow_rum_graph" style="width:100px;height:30px;position:relative;top:-23px;"></div></td>',
										'<td><div id="graph-textfooter'+this.id+'" class="appflow_rum_graph" style="width:100px;height:30px;position:relative;top:-21px;"></div></td>',
									'<tpl else>',
										//'<td style="width:50%;"><div id="graph-textfooter'+this.id+'" class="appflow_rum_graph" style="width:100px;height:30px;position:relative;top:-23px;"></div></td>',
										'<td><div id="graph-textfooter'+this.id+'" class="appflow_rum_graph" style="width:100px;height:30px;position:relative;top:-21px;"></div></td>',
									'</tpl>',
									'</div></tr></table>',

								'<tpl else>',
									'<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></div>',
									'<div class="fontStyleRobotRegular font_normal12 legendLabel d_m_t15" style="text-align:center">{footer}</div>',
								'</tpl>',
							'</div>',
						'</div>',
						//'<div class="b_box" style="position:absolute;bottom:10px;border:1px solid green !important;float:left;width:95%;"><img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{spikeClass}" /><span style="margin-left: 15px !important;">{spikeData}</span></div>',
						'<tpl if="spikeClass">',
							'<tpl if="spikeClass != &quot;GOOD&quot;">',
								'<a href="javascript:openAlarmPopup(\'{test_org}\',\'{measure_org}\',\'{spikeClass}\',\'true\',\'{spikeData}\')"><div class="b_box" style="bottom:16px;position:absolute;border:0px solid green !important;float:left;"><div class="outerbox"><div id="triangle-bottomleft"></div><div class="stateBookmark_{spikeClass} boxShadow"><img style="width:16px;height:16px;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/component_icons/svg/state_white_{spikeClass}.svg" style="opacity:10" /><span class="fontStyleRobotRegular font_bold12" style="margin-left:5px">{spikeData}</span></div></div></div></div></a>',
							'<tpl else>',
								'<div class="b_box" style="cursor:default;bottom:16px;position:absolute;border:0px solid green !important;float:left;"><div class="outerbox"><div id="triangle-bottomleft"></div><div class="stateBookmark_{spikeClass} boxShadow"><img style="width:16px;height:16px;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/component_icons/svg/state_white_{spikeClass}.svg" style="opacity:10" /><span class="fontStyleRobotRegular font_bold12" style="margin-left:5px">{spikeData}</span></div></div></div></div>',
							'</tpl>',
						'</tpl>',
						'</tpl>'
					);
					var g_item1 = this.getTextFooterItem(this.data,this.num,this.id);
					this.add(g_item1);
				}				
			}
		},
		getDoubleTextFooterItem : function(data1,iid,CId){
			var item={
				xtype:'dataview',
				id:this.id+'_dataview',
				emptyText:'No Data found!',
				deferEmptyText:false,
				store: Ext.create('Ext.data.Store', {
					id:this.id+'_store',
					model:'TextFooterWidgetModel',
					autoLoad:true,
					data:data1
				}),
				tpl:textfooterTpl,
				autoDestroy:true,
				listeners:{
					viewready:function(x){
						var me = this;
						if(!Ext.isEmpty(data1) && !Ext.isEmpty(data1.graphData) && !Ext.isEmpty(data1.graphData.DataSetCount) && !Ext.isEmpty(data1.graphData.DataSetArr))
						{
							if(data1.graphData.DataSetCount != null && data1.graphData.DataSetCount > 0)
							{
								for(var t=1;t<data1.graphData.DataSetCount+1;t++)
								{
									var jsonData = getHighChartsJSONforTextFooterGraph(data1,CId,t-1);
									$('#graph-textfooter-'+t+'-'+CId).highcharts(jsonData);
								}
							}							
						}
					}
				}
			}
			return item;
		},	
		getTextFooterItem : function(data1,iid,CId){
			var item={
				xtype:'dataview',
				id:this.id+'_dataview',
				emptyText:'No Data found!',
				deferEmptyText:false,
				store: Ext.create('Ext.data.Store', {
					id:this.id+'_store',
					model:'TextFooterWidgetModel',
					autoLoad:true,
					data:data1
				}),
				tpl:textfooterTpl,
				autoDestroy:true,
				listeners:{
					viewready:function(x){
						var me = this;
						if(!Ext.isEmpty(data1) && !Ext.isEmpty(data1.graphData) && !Ext.isEmpty(data1.graphData.DataSet) && Ext.isEmpty(data1.graphData.DataSet[0].ERROR)){
							var jsonData = getHighChartsJSONforTextFooterGraph(data1,CId);
							$('#graph-textfooter'+CId).highcharts(jsonData); 
						}
					}
				}
			}
			return item;
		}		
 });
 /*
 .stateSymbol_HIGH, .stateSymbol_INTERMEDIATE, .stateSymbol_LOW, .stateSymbol_UNKNOWN, .stateSymbol_GOOD, .stateSymbol_GRAY
 */

function getHighChartsJSONforTextFooterGraph(Jdata,Cid,count){
	try
	{
		try
		{
			var columnData = Jdata.graphData.DataSet[0].data;
			if(columnData != null)
			{
				try
				{
					columnData = Jdata.graphData.DataSetArr[count].DataSet[0].data;	
				}
				catch (e)
				{
				}				
			}
		}
		catch (er)
		{
			columnData = Jdata.graphData.DataSetArr[count].DataSet[0].data;
		}
		var chartType = Jdata.graphType.toLowerCase();
		var dataArray = [];
		var lowVal = 0;
		var dynContWidth = 100;
		if(columnData.length <= 2)
			dynContWidth = columnData.length * 16;
		else if(columnData.length > 2 && columnData.length <= 5)
			dynContWidth = columnData.length * 13;
		else if(columnData.length % 2 == 0)
			dynContWidth = columnData.length * 8;
		else
			dynContWidth = columnData.length * 9;

		if(dynContWidth > 120)
			dynContWidth = 120;

		//dynContWidth = 100;
		try
		{
			if(count != undefined && count != null)
			{
				if(dynContWidth != undefined && dynContWidth != null && chartType.toUpperCase() == 'COLUMN')
					$("#graph-textfooter-"+count+""+Cid).css("width", dynContWidth);			
			}
			else
			{
				if(dynContWidth != undefined && dynContWidth != null && chartType.toUpperCase() == 'COLUMN')
					$("#graph-textfooter"+Cid).css("width", dynContWidth);
			}
		}
		catch (er)
		{
			if(dynContWidth != undefined && dynContWidth != null && chartType.toUpperCase() == 'COLUMN')
				$("#graph-textfooter"+Cid).css("width", dynContWidth);
		}		

		try
		{
			var maxVal = null;
			var colorVal = "#556ebc";
			for(var r = 0; r< columnData.length ;r++)
			{
				if(lowVal > columnData[r].y)
					lowVal = columnData[r].y;
				dataArray.push(columnData[r].y);
				colorVal = columnData[r].color;
			}
		}
		catch (e)
		{
		}
		
		var total = 0;
		var minpLength = 2;
		$.each(dataArray,function() {
			total += this;
		});
		if(total == 0)
		{
			maxVal = 1;
			if(chartType.toUpperCase() == 'AREA'){
				maxVal = 10;
				for(var t=0;t<dataArray.length;t++){
					dataArray[t] = 1;		
				}
			}
		}	
		if(total == dataArray.length)
		{
			maxVal = 1;
			if(chartType.toUpperCase() == 'AREA'){
				maxVal = 10;
				for(var t=0;t<dataArray.length;t++){
					dataArray[t] = 1;		
				}
			}
		}	
		var jsonData= 	{
			chart: {
				borderWidth:0,
				type: chartType,
				spacingBottom:0,
				spacingTop:0,
				spacingLeft:10,
				spacingRight:10,
				backgroundColor: null
			},
			tooltip: {
				enabled: false
			},
			credits: {
				enabled: false
			},
		    exporting: {
				enabled: false
			}, 
			title: 
			{
				text: ''
			},
			xAxis: {
				allowDecimals: false,
				visible: false,
				minorGridLineWidth: 0,
				minorTickLength: 0,
				tickLength: 0,
				lineColor: 'transparent',
				labels: {
					enabled: false
				},					
			},
			yAxis: {
				max:maxVal,
				minorGridLineWidth: 0,
				visible: false,
			    lineColor: 'transparent',
			    gridLineColor: 'transparent',
			    minorTickLength: 0,
			    tickLength: 0,           
				labels: {
					enabled: false
				}
			},
			labels: {
				enabled: false
            },
			plotOptions: {
				borderWidth:0,
				series: {
					point: {
						events: {
							mouseOver: function (e) {
							},
							mouseOut: function (e) {
							}
						}
					},
					 pointPadding: 0,
					 groupPadding: 0,
					 pointWidth: 4,
					 showInLegend: false
				},
				column: {
					 minPointLength: minpLength,
					borderWidth:0
				},
				area: {
					marker: {
						enabled: false,
						symbol: 'circle',
						states: {
							hover: {
								enabled: true
							}
						}
					}
				}
			},
			series: [{
				color:colorVal,
				lineColor:'transparent',
				crisp:false,
		        data: dataArray,				
			}]
		}	
	}
	catch (er)
	{
		jsonData = null;
	}
	return jsonData;
}
