Ext.define('TextHeatAlertModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'string' },
		{ name:'legend', type:'string' },
		{ name:'footer', type:'string' },
		{ name:'subfooter', type:'string' },
		{ name:'changeTabView', type:'string' },
		{ name:'linkurl', type:'string' },
		{ name:'test_org', type:'string' },
		{ name:'measure_org', type:'string' },
		{ name:'handSymbol', type:'string' },
		{ name:'spikeClass', type:'string' },
		{ name:'spikeData', type:'string' },
		{ name:'sessions'},
		{ name:'DataSet'},
		{ name:'data'},
		{ name:'graphID', type:'string' }
    ]
});
// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk
var TextHeatAlertModelTpl = new Ext.XTemplate(
	'<div class="widgetholders">',
    '<tpl for=".">',
	'<div class="s_box">',
		 '<div class="font_bold12 div_center trim_text" style="float:left;width:70%"><img style="vertical-align:sub" src="/final/images/clear.png" class="state_{state}" /> <span>{heading}</span></div>',
		 '<div style="float:right;width:30%" class="div_center"><div  class="font_bold18" style="text-align:right">{value}</div><div class="font_normal11 trim_text" style="vertical-align:top;text-align:right;width:100%"> {legend}</div></div>',
		 '<div style="clear:both"></div>',
		 '</div>',
        '<div class="b_box">',
		  '<div class="font_bold12"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span>{heading}</ span></div>',
		   '<div>',
			'<div style="float:left;margin-right:20px;margin-top:20px">',
			'<div class="font_normal31 d_m_t20" style="text-align:right">{value}</div>',
		    '<div class="font_normal11 legendLabel" style="text-align:center">{legend}</div>',
			'</div>',
			 '<div  style="text-align:center;width:40px;height:40px;float:left" id="uniquesessions-graph_"></div>',
			 //'<div style="clear:both"></div>',
			 '</div>',
			'<div class="sessions_legends">',
			'<table style="float:right;margin-right:0px">',
			'<tpl for="sessions">',
			'<tr><td style="padding-right:5px;padding-bottom:10px"><img  data-qtip="{y}%" data-qclass="yellowTip" style="vertical-align:sub" src="/final/images/clear.png" class="{name}" /></td><td class="font_normal11">{text}({value})</td></tr>',
			'</tpl>',
			'</table>',
			'</div>',
        '</div>',
    '</tpl>',
	'</div>'
);

Ext.define('widgets.TextHeatAlert', {
     extend: 'Ext.container.Container',
	alias:'widget.textheatalert',
	//cls:'widgetcon',
	ui:'uniqueSessions',
	autoDestroy:true,
	data:'',
	config: {
         data: null
    },
	width:250,
	store:null,
	items:[],
	updateData:function(data){
		var me = this;
		me.items.items[0].store.loadRawData(data);
		var measData = data.DataSet[0].data[0];
		updateHeatMap(measData,me.id);
	},
	listeners:{
		 'afterrender':function(e){
			TextHeatAlertModelTpl = new Ext.XTemplate(
				'<tpl for=".">',
				'<div class="widgetholders {handSymbol}" style="border:0px solid red;width:100%">',
					/*'<div class="s_box">',
					 '<div class="font_bold12 div_center trim_text" style="float:left;width:70%"><img style="vertical-align:sub" src="/final/images/clear.png" class="state_{state}" /> <span>{heading}</span></div>',
					 '<div style="float:right;width:30%" class="div_center"><div  class="font_bold18" style="text-align:right">{value}</div><div class="font_normal11 trim_text" style="vertical-align:top;text-align:right;width:100%"> {footer}</div></div>',
					 '<div style="clear:both"></div>',
					 '</div>',*/
					'<div class="s_box">',
						'<div class="fontStyleRobotRegular font_bold12 div_center trim_text" style="float:left;width:40%">',
							'<tpl if="state">',	
								'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'</tpl>',
							
						 '<div style="float:right;width:60%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:3px;text-align:right;display:inline-block;line-height:18px">{value}</div><div class="font_normal10" style="line-height:18px;display:inline-block;text-align:left;vertical-align:top;width:31px">{footer}</div></div>',
						 '<div style="clear:both"></div>',
					 '</div>',
					'<div class="b_box" onclick=\"loadView(\'{changeTabView}\',\'\',\'\',\'{test_org}\',\'{measure_org}\',\'{linkurl}\');\">',
					  '<div class="fontStyleRobotRegular font_bold13 title">',
							 '<tpl if="state">',	
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'<tpl else>',
									'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'</tpl>',
						'<table style="margin:15px auto;border:0px solid blue !important"><tr><td style="padding-right:15px">',
						'<tpl if="value!=&quot;-&quot;">',
							'<div class="fontStyleRobotRegular font_normal24 d_m_t5" style="border:0px solid grey;text-align:center;">{value}<span class="fontStyleRobotRegular font_normal19">s</span></div>',
							'<div class="fontStyleRobotRegular font_normal12 " style="border:0px solid red;text-align:center">{footer}</div>',
							'<div class="fontStyleRobotRegular font_normal12 legendLabel" style="border:0px solid red;text-align:center">{subfooter}</div>',
							'</div>',
						'<tpl else>',
								'<div class="fontStyleRobotRegular font_normal24 d_m_t5" style="border:0px solid grey;text-align:center;">{value}</div>',
						'</tpl>',
						'</td>',
						 //'<td  style="text-align:center;height:110px;width:100px;border:0px solid violet !important;" id="textdonutalert-graph_'+this.id+'"></td>',
						//'<td><table style="float:left;border:0px solid blue"><tr><td style="width:80px;vertical-align:top"><div id="mainSquareDiv" class="mainSquareDiv" style="margin-top:5px;width:80px;border:0px solid green;"></div><div class="font_normal11 legendLabel" style="border:0px solid red;text-align:center">Healthy 26%</div></td><td width="*" ></td></tr></tr></table></td>',
						'<td><table style="float:left;border:0px solid blue"><tr><td style="width:40px;vertical-align:top"><div id="mainSquareDiv'+this.id+'" class="mainSquareDiv" style="margin-top:5px;width:80px;border:0px solid green;"></div>',
					
						'</td></tr><tr><td >',
							/*'<tpl for="DataSet">',
								'<tpl if="tagvalue">',
									'<div class="font_normal11" style="border:0px solid red;margin-top:-10px">{tagvalue}</div>',
								'</tpl>',
							'</tpl>',	*/
						'</td></tr></table></td>',
						//'<td><table style="float:left;border:0px solid blue"><tr><td style="width:80px;vertical-align:top"><div id="mainSquareDiv" class="mainSquareDiv" style="height:80px !important;margin-top:5px;width:80px;border:0px solid green;">',
						//'<tpl for="DataSet">',	
							//'</div><div class="font_normal11 legendLabel" style="border:0px solid red;text-align:center">{tagvalue}</div></td><td width="*" ></td></tr></tr></table></td>',
						//'</tpl>',	
						//'<div style="clear:both"></div>',
						'<td>',
						'<div class="sessions_legends">',
						'<table style="float:right;margin-right:0px;border:0px solid indigo !important">',
						//'<tpl for="sessions">',
						'<tpl for="DataSet">',
							'<tpl for="data">',
								//'<tr><td style="padding:6px;"><img  data-qtip="{y}%" data-qclass="yellowTip" style="vertical-align:sub" src="/final/images/clear.png" class="{name}" /></td><td class="font_normal11">{text}({value})</td></tr>',
								//'<tr><td style="padding:6px;"><img  data-qtip="{value}" data-qclass="yellowTip" style="vertical-align:sub" src="/final/images/clear.png" class="{icon}" /></td><td class="font_normal11">{text}({value})</td></tr>',
							'</tpl>',
						'</tpl>',
						'</table>',
						'</div></td>',
						'</tr></table>',
					//'</div>',
				'</div>',
				//'<div class="b_box" style="position:absolute;bottom:10px;border:1px solid green !important;float:left;width:95%;"><img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{spikeClass}" /><span style="margin-left: 15px !important;">{spikeData}</span></div>',
				'<tpl if="spikeClass">',
					'<tpl if="spikeClass != &quot;GOOD&quot;">',
						'<div class="b_box" style="position:absolute;bottom:16px;border:0px solid green !important;float:left;"><div class="outerbox"><div id="triangle-bottomleft"></div><div class="stateBookmark_{spikeClass} boxShadow"><img style="width:16px;height:16px;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/component_icons/svg/state_white_{spikeClass}.svg" style="opacity:10" /><span class="fontStyleRobotRegular font_normal12"><a href="javascript:openAlarmPopup(\'{test_org}\',\'{measure_org}\',\'{spikeClass}\',\'true\',\'{spikeData}\')">{spikeData}</a></span></div></div></div></div>',
					'<tpl else>',
						'<div class="b_box" style="cursor:default;position:absolute;bottom:16px;border:0px solid green !important;float:left;"><div class="outerbox"><div id="triangle-bottomleft"></div><div class="stateBookmark_{spikeClass} boxShadow"><img style="width:16px;height:16px;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/component_icons/svg/state_white_{spikeClass}.svg" style="opacity:10" /><span class="fontStyleRobotRegular font_normal12">{spikeData}</span></div></div></div></div>',
					'</tpl>',
				'</tpl>',
				'</tpl>'
			);
			var g_item = this.getTextDonutAlertItem(this.data,this.id);
			this.add(g_item);
		}
	},
	getTextDonutAlertItem : function(datafrHeat,curId){

			var item={
				xtype:'dataview',
				store: Ext.create('Ext.data.Store', {
						model: 'TextHeatAlertModel',
						autoLoad:true,
						data:datafrHeat
					}),
				autoDestroy:true,
				tpl: TextHeatAlertModelTpl,
				listeners:{
					viewready:function(x){
						var jsonData = '';
						if(!Ext.isEmpty(datafrHeat) && Ext.isEmpty(datafrHeat.DataSet.Error))
						{
							try
							{
								var me = this;
								var measData = me.store.data.items[0].data.DataSet[0].data[0];
								updateHeatMap(measData,curId);
							}
							catch (er)
							{
							}
						}
					}
				}
			}
		return item;
	}
 });

function updateHeatMap(measdata1,idObj)
{
		//var mainDiv = jQuery('.mainSquareDiv'+idObj);
		var mainDiv = jQuery('#'+idObj+' .mainSquareDiv');
		var measData = measdata1;
		if(!Ext.isEmpty(measData))
		{
			if( !Ext.isEmpty(measData.GOOD) )
			{
				var satis = measData.GOOD;
				if( satis > 0 )
				{
					for(i=0; i<satis; i++){
						var goodDivVar = $('<div></div>').addClass('satisfiedDiv');
						mainDiv.append(goodDivVar);
					}
				}
			}
			
			
			if( !Ext.isEmpty(measData.INTERMEDIATE) )
			{
				var Toler = measData.INTERMEDIATE;
				if( Toler > 0 )
				{
					for(i=0; i<Toler; i++){
						var intermediateDivVar = $('<div></div>').addClass('toleratingDiv');
						mainDiv.append(intermediateDivVar);
					}
				}
			}

			if( !Ext.isEmpty(measData.LOW) )
			{
				var satis = measData.LOW;
				if( satis > 0 )
				{
					for(i=0; i<satis; i++){
						var lowDivVar = $('<div></div>').addClass('lowDiv');
						mainDiv.append(lowDivVar);
					}
				}
			}	

			if( !Ext.isEmpty(measData.HIGH) )
			{
				var frus = measData.HIGH;
				if( frus > 0 )
				{
					for(i=0; i<frus; i++){
						var highDivVar = $('<div></div>').addClass('frustratedDiv'); 
						mainDiv.append(highDivVar);
					}
				}
			}

			if( !Ext.isEmpty(measData.GREY) )
			{
				var grey = measData.GREY;
				if( grey > 0 )
				{
					for(i=0; i<grey; i++){
						var notrafficDivVar = $('<div></div>').addClass('notrafficDiv');
						mainDiv.append(notrafficDivVar);
					}
				}
			}

											
		}
		else
		{
			//var notraffic = measData.notraffic;
			//if( notraffic > 0 )
			{
				for(i=0; i<notraffic; i++){
					var notrafficDivVar = $('<div></div>').addClass('notrafficDiv');
					mainDiv.append(notrafficDivVar);
				}
			}
		}
	
 }