Ext.define('TierHealthWidgetModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'comptype', type:'string' },
        { name:'comptypename', type:'string' },
        { name:'linkurl', type:'string' },
        { name:'handSymbol', type:'string' },
        { name:'leng'},
        { name:'tierHealthArr'},
        { name:'title', type:'string' },
        { name:'len', type:'string' },
        { name:'classname', type:'string' },
        { name:'changeTabView', type:'string' },
		{ name:'comptypeCompListUrl', type:'string' },
		{ name:'compListUrl', type:'string' },
		{ name:'totalCompCnt', type:'string' },
    ]
});


Ext.define('widgets.TierHealth', {
		extend: 'Ext.container.Container',
		alias:'widget.tierhealth',
		ui:'appflowtraffic',
		autoDestroy:true,
		data:'',
		id:'',
		store:null,
		items:[],
		updateData:function(data){
			var me = this;
			me.items.items[0].store.loadRawData(data);
		},
		items:[],
		listeners:{
			'afterrender':function(e){
				
				var tierHealtData=e.data.tierHealthArr;
				var tierBarRight="border-right:1px solid #fff";
				for (var i=0;i<tierHealtData.length;i++)
				{
					if(i==(tierHealtData.length-1))
						tierBarRight="border-right:0px solid #fff";
				}
				dataTpl = new Ext.XTemplate(
					'<tpl for=".">',
						'<div style="padding-bottom:5px;">',
						'<div class="panelHeader font_normal15 fontStyleRobot" style="border: 0px solid grey; float: left; padding: 0px; left: 0px;margin:0px 0px 15px 10px;top:0px;height:20px;">{title}</div>',
						'<tpl for="tierHealthArr">',
						'<div style="border:0px solid blue;width:100%;padding:3px 10px 6px 10px;">',
						'<table cellspacing="0" width="100%" cellpadding="0" border="0" >',
						'<tbody>',
						'<tr>',
							'<td width="10%" ><div class="font_normal11 {handSymbol}" onclick=\"loadView(\'{changeTabView}\',\'{comptypename}\',\'\',\'\',\'\',\'{linkurl}\',\'true\');\" data-qtip="{comptype}" style="padding-right:15px;width:130px;white-space: nowrap;text-overflow: ellipsis;overflow:hidden;">{comptype}</div></td>',
							'<td><table width="100%"><tr>',
							'<tpl for="leng">',
								"<tpl if='len != \"0\"'>",
										//'<td class="{classname} font_normal10" style="text-align:center;border-right:0px solid #fff" width="{len}"><div style="font-size:11px !important;margin:2px;" class="font_normal11">{len}</div></td>',
										'<td class="{classname} font_normal10" style="text-align:center;'+tierBarRight+'" width="{len}"><div style="font-size:11px !important;margin:2px;" class="font_normal11">{len}</div></td>',

								'</tpl>',
							'</tpl>',
						'</tr></table></td>',
						'</tr>',
						'</tbody>', 
						'</table>', 
						'</div>',
						'</tpl>',
						'</div>',
					'</tpl>'
					);				
				var g_item = this.getTierHealthItem(this.data,this.num,this.id,this);
				this.add(g_item);
			}
		},
		getTierHealthItem : function(data1,iid,curId,me){
			var item={
					xtype : 'dataview',
					scroll : false,
					layout:{type:'vbox',align:'stretch'},
					flex : 1,
					store: Ext.create('Ext.data.Store', {
						//id:'text_model_id',
						id:this.id+'_store',
						model:'TierHealthWidgetModel',
						autoLoad:true,
						//data:data1['tierHealthArr']
						data:data1
					}),
					tpl : dataTpl,
					autoScroll : true,
					itemSelector : 'div.x-data-bar',
					emptyText : 'No Measures available'
				} 
			return item;
		}		
 });
