 Ext.define('OverviewModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'number' },
		{ name:'legend', type:'string' },
		{ name:'sessions' },
		{ name:'graphID', type:'string' }
    ]
});

Ext.create('Ext.data.Store', {
    id:'Overview_model_id',
    model: 'OverviewModel',
	autoLoad:true,
    data: [
        {  
			"state":"Healthy" ,
			"heading":"Sessions",
			"value":"24",
			"legend":"No.s",
			"sessions":[
				{"name":"desktop_session","y":8,"color": "#778bc9","text": "Desktop","value": "11"},	
				{"name":"tab_session","y":4,"color": "#4cb8ef","text": "Tablet","value": "4"},
				{"name":"moblie_session","y":12,"color": "#dc5d7f","text": "Mobile","value": "9" }
			]
		}
    
    ]
});

// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk
var OverviewTpl = new Ext.XTemplate(
	'<div class="widgetholders">',
    '<tpl for=".">',
	'<div class="s_box">',
		 '<div class="font_bold12 div_center trim_text" style="float:left;width:70%"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span>{heading}</span></div>',
		 '<div style="float:right;width:30%" class="div_center"><div  class="font_bold18" style="text-align:right">{value}</div><div class="font_normal11 trim_text" style="vertical-align:top;text-align:right;width:100%"> {legend}</div></div>',
		 '<div style="clear:both"></div>',
		 '</div>',
        '<div class="b_box">',
		  '<div class="font_bold12"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span>{heading}</ span></div>',
		   '<div>',
			'<div style="float:left">',
			'<div class="font_normal31 d_m_t20" style="text-align:right">{value}</div>',
		    '<div class="font_normal11 legendLabel" style="text-align:right">{legend}</div>',
			'</div>',
			 '<div  style="text-align:center;width:60px;height:60px;float:left" id="uniquesessions-graph"></div>',
			 //'<div style="clear:both"></div>',
			 '</div>',
			'<div class="sessions_legends">',
			'<table style="float:right;margin-right:0px">',
			'<tpl for="sessions">',
			'<tr><td style="padding-right:5px;padding-bottom:10px"><img  data-qtip="{y}%" data-qclass="yellowTip" style="vertical-align:sub" src="/final/images/clear.png" class="{name}" /></td><td class="font_normal11">{text}({value})</td></tr>',
			'</tpl>',
			'</table>',
			'</div>',
        '</div>',
    '</tpl>',
	'</div>'
);



 
 
 Ext.define('widgets.UxChartParentPanel', {
	 extend: 'Ext.panel.Panel',
     alias: 'widget.uxchartparentpanel',
	requires:['widgets.ChartPanel'],
	margin:'10 0 0 0',
	defaults:{
		columnWidth: 0.5,
		 height: 301
	 },
	layout:'column',
	manageOverflow:2,
	//items:[],
	config: {
         data: null
     },
     constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
     },
	initComponent: function() {
         var me = this,item=[];
		// @ render the chart panel
		//me.renderChart(me.data)
		//for(var p=0;p<7;p++)
		//	me.renderChart(p)
        me.callParent(arguments);
     },
	listeners:{
		 'afterrender':function(){
			 var margin="";

			for(var p=0;p<6;p++)
			 {

				if(p%2 == 0){
					margin = '0 8 8 0';
				}else{
					margin = '0 0 8 0';
				}
				
				
				this.renderChart(p, margin)	
			 }
		 },
	 },
	chartPanelObj:function(){
		return { xtype:'chartpanel'}
	 },
	renderDonutChartPanel:function(){
		
			var temp={
			xtype:'dataview',
			padding:5,
			store: Ext.data.StoreManager.lookup('Overview_model_id'),
			tpl: OverviewTpl,
			listeners:{
				viewready:function(x){
				var jsonData = {
        chart: {
			
            type: 'pie',
			spacingBottom: 0,
		spacingTop: 0,
		spacingLeft: 0,
		spacingRight: 0,
		width: 59,
		height:59,
		backgroundColor: null
        },
		tooltip: {
            enabled: false
        },

		title: {
		text: ''
	},exporting: {
		enabled: false
	},
				credits: {
		enabled: false
	},
        plotOptions: {
				
            pie: {
                borderColor: '#fff',
				showInLegend: false,
                innerSize: '99%',
				 dataLabels: {
                        enabled: false
                    },
                    showInLegend: false
            }
        },

        series: [{
           data: Ext.data.StoreManager.lookup('Overview_model_id').data.items[0].data.sessions
			}
		]
    }
   
				$('#uniquesessions-graph').highcharts(jsonData); 
					
				}
			}
		}	

		return temp;
	
	},
	renderChart:function(p, margin){

		var me = this,chartitemArry=[];
		//var itemJson ={"chartHeight":230,"xAxisLabel":["WIN7-32Bit [11.202]","WIN10 [9.199]","win2k12r2  [11.157]","WIN8-32Bit [11.158]","Win2008-32Bit [8.64]"],"fullViewURL":"/final/servlet/com.egurkha.monitor.DDTopview?host=VDI_115%3ANULL&compType=VmVdi_i_server&test=EsxGuestTest&measure=DATA_RECEIVED&real_measure=Data_received&module=System&width=880&height=320&from=fullview&mode=3D&graphdisplay=defaultView&fullview=true&monitorSkin=Light&msmt_host=192.168.9.94&port=NULL&isFromAnalysis=true&layer=VIRTUAL_GUESTS&starttime=01/11/2017&starthr=18&endtime=01/11/2017&endhr=19&time_line=1+hour&displayName=Network+data+received&isTimeout=false&priority=ALL&display=false&applyFusion=true&actualPriority=TOP&noOfInfos=5","DataSet":[{"data":[{"name":"WIN7-32Bit [11.202]","y":0.8594,"color":"#8399b0"},{"name":"WIN10 [9.199]","y":0.1328,"color":"#ffd95a"},{"name":"win2k12r2  [11.157]","y":0.1172,"color":"#a4ac91"},{"name":"WIN8-32Bit [11.158]","y":0.1094,"color":"#98d980"},{"name":"Win2008-32Bit [8.64]","y":0.0859,"color":"#d5b996"}],"showInLegend":false}],"name":"","chartType":"bar","title":"Network data received(Mbps)","chartCId":"vLGFC11","divId":"chartContainer11","fcId":"myChartId11","fullViewId":"11,this.event,1,analysisBargraph","maxChartType":"analysisBargraph","styles":{"title":{"FAMILY":"LucidaGrandeBold","WEIGHT":"Normal","SIZE":"12px","COLOR":"#c0c0c0"},"legendStyle":{"FAMILY":"LucidaGrandeRegular","WEIGHT":"Normal","SIZE":"10px","COLOR":"#c0c0c0"},"datalabel":{}}};
		var itemJson ={"chartHeight":230,"xAxisLabel":["WIN7-32Bit [11.202]","WIN10 [9.199]","win2k12r2  [11.157]","WIN8-32Bit [11.158]","Win2008-32Bit [8.64]"],"fullViewURL":"/final/servlet/com.egurkha.monitor.DDTopview?host=VDI_115%3ANULL&compType=VmVdi_i_server&test=EsxGuestTest&measure=DATA_RECEIVED&real_measure=Data_received&module=System&width=880&height=320&from=fullview&mode=3D&graphdisplay=defaultView&fullview=true&monitorSkin=Light&msmt_host=192.168.9.94&port=NULL&isFromAnalysis=true&layer=VIRTUAL_GUESTS&starttime=01/11/2017&starthr=18&endtime=01/11/2017&endhr=19&time_line=1+hour&displayName=Network+data+received&isTimeout=false&priority=ALL&display=false&applyFusion=true&actualPriority=TOP&noOfInfos=5","DataSet":[{"data":[{"name":"WIN7-32Bit [11.202]","y":0.8594,"color":"#8399b0"},{"name":"WIN10 [9.199]","y":0.1328,"color":"#ffd95a"},{"name":"win2k12r2  [11.157]","y":0.1172,"color":"#a4ac91"},{"name":"WIN8-32Bit [11.158]","y":0.1094,"color":"#98d980"},{"name":"Win2008-32Bit [8.64]","y":0.0859,"color":"#d5b996"}],"showInLegend":false}],"name":"","chartType":"bar","chartCId":"vLGFC11","divId":"chartContainer11","fcId":"myChartId11","fullViewId":"11,this.event,1,analysisBargraph","maxChartType":"analysisBargraph","styles":{"title":{"FAMILY":"LucidaGrandeBold","WEIGHT":"Normal","SIZE":"12px","COLOR":"#c0c0c0"},"legendStyle":{"FAMILY":"LucidaGrandeRegular","WEIGHT":"Normal","SIZE":"10px","COLOR":"#c0c0c0"},"datalabel":{}}};

		var legendItems ={
			xtype:'container',
			layout:'hbox',
			//margin:margin,
			flex:1,
			items:[
				{
					xtype:'container',
					flex:0.5,
					height:85,
					margin:'0 10 0 0',
					items:[ {
						xtype:'label',
						cls:'font_bold9 grayColor',
						text:'Last 5 Mins',
					},{
						xtype:'box',
						height:85,
						cls:"chartminmax",
						html:'<div ><div style="margin-top:7px;width:53%;float:left;text-align:center;border-right:1px solid #d9d9d9;"><div class="font_normal18" style="margin-top:15px">800</div><div class="font_normal12" >Logons</div></div><div style="width:40%;float:right;text-align:center;margin-top:5px"><div class="font_normal18" style="float:left;padding:10px 0 0 0">0.9</div><div class="font_normal12" style="padding:7px 0 0 0">avg</div><div class="crl"></div><div class="font_normal18" style="float:left;padding:10px 0 0 0">1.2</div><div class="font_normal12" style="padding:7px 0 0 0">max</div></div></div>'
					}]
				},
				{
					xtype:'container',
					flex:0.5,
					height:85,
					margin:'0 10 0 0',
					items:[ {
						xtype:'label',
						cls:'font_bold9 grayColor',
						text:'Last 5 Mins',
					},{
						xtype:'box',
						height:85,
						cls:"chartminmax",
						html:'<div ><div style="margin-top:7px;width:53%;float:left;text-align:center;border-right:1px solid #d9d9d9;"><div class="font_normal18" style="margin-top:15px">800</div><div class="font_normal12" >Logons</div></div><div style="width:40%;float:right;text-align:center;margin-top:5px"><div class="font_normal18" style="float:left;padding:10px 0 0 0">0.9</div><div class="font_normal12" style="padding:7px 0 0 0">avg</div><div class="crl"></div><div class="font_normal18" style="float:left;padding:10px 0 0 0">1.2</div><div class="font_normal12" style="padding:7px 0 0 0">max</div></div></div>'
					}]
				}
			]
		 };
		

		var newPanel = new Ext.Panel (
				{
				xtype:'panel',
				 ui: 'eg-x-panel',
				//layout: 'fit',
				border:false,
				//style:{'border':'2px solid red'},
				frame:false,
				margin:margin,
				padding:'10 20 10 20',
				//bodyPadding:'30 0 0 0',
				height:350,
				autoScroll:false,
				scroll:false,
				clickUrl:'/final/servlet/com.egurkha.monitor.DDTopview?host=esx_115%3ANULL&compType=VmEsx_i_server&test=EsxGuestTest&measure=CPU_USED&real_measure=Cpu_used&module=System&width=880&height=320&from=fullview&mode=3D&graphdisplay=defaultView&fullview=true&monitorSkin=Light&msmt_host=192.168.9.94&port=NULL&isFromAnalysis=true&layer=VIRTUAL_GUESTS&starttime=01/11/2017&starthr=16&endtime=01/11/2017&endhr=17&time_line=1+hour&displayName=Physical+CPU+utilization&isTimeout=false&priority=ALL&display=false&applyFusion=true&actualPriority=TOP&noOfInfos=5',
				html: '<div id="graphPanel" style="float:left;width:100%;height:100%"></div>',
				
				//chartData:data,
				title:'Logon Time <span>(in secs)</span>',

				//baseCls:'panelHeader',
				//measTitle:'',
				items:[legendItems,{
					xtype:'container',
					layout:'vbox',
					height:250,
					id:'newchart'+p,
					chartData:itemJson,
					listeners:{
					'resize': function(curInst){
						try
						{
							var panelWidth = ( $( window ).width() / 2 ) - 100;
							var heigth = Ext.getCmp('newchart'+p).getHeight();
							var width = Ext.getCmp('newchart'+p).getWidth();
							var graphPanelID=Ext.get("graphPanel");

							curInst.chartData['fromPage']='vlive';
							//curInst.chartData['measureTitle']=curInst.measTitle;
							curInst.chartData['tick']=false;
							curInst.chartData['isStateBar']=false;
							var barChart = {};							
							//barChart = jQuery.extend(true, {}, createBar(curInst.id,heigth-70,width-50), barChart);
							barChart = jQuery.extend(true, {}, createBarforCtx(curInst.id,heigth-70,width-50), barChart);
							barChart.setData(curInst.chartData,'','','bar');
							barChart.drawChart();
						}
						catch (err )
						{
							//Ext.getCmp(itemJson.chartCId).update(errHtml);
							console.log("err-==-=-",err)
						}
					},
				}
				}]
		 }
		 );
			//me.items = newPanel;

		 this.add(newPanel);
			
			//Ext.resumeLayouts(true);
	},
	renderChartas:function(data){
		var me = this,chartitemArry=[],margin="";
		if(!Ext.isEmpty(data)){
			 Ext.suspendLayouts();
			for (var i= 0; i <  data.length;i++ )
			{
					//legendPosition: 'bottom', // top,left, bottom and right
					//chartType: 'area', // pie,line,column,area -  chart type
					if(i%2 == 0){
						margin = '0 8 8 0';
					}else{
						margin = '0 2 8 0';
					}

					var barChartPanel = {};
					//gaugeChartObj = jQuery.extend(true, {}, getHighChartsGuageEnd(id,'',hegiht,width),gaugeChartObj);
					barChartPanel = jQuery.extend(true, {}, //getHighChartsBarInstanceForEndUserDashboard('barChart-'+obj.id,chartHeight,300), barChartPanel);
					getHighChartsBarInstanceForEndUserDashboard(this.id,(300),300), barChartPanel);
					barChartPanel.setData(xmlData,'','','bar');
					parent.chartObj=barChartPanel;
					parent.barChartHeight=300;
					barChartPanel.drawChart(); 


					chartitemArry.push(Ext.apply(me.chartPanelObj(), {
						"title": data[i].title,
						"data":data[i].data,
						margin:margin,
						tools:[
						{
							xtype:'label',
							text: data[i].chartHistory
						}
						],
						"chartType": data[i].chartType,
						"legendPosition": data[i].legendPosition
					}));

			}
			me.items = chartitemArry;
			Ext.resumeLayouts(true);
		}

	 }
 })