/**
 * Danish translation
 * By JohnF
 * 04-09-2007, 05:28 AM
 *
 * Extended and modified by Karl Krukow,
 * December, 2007.
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">Henter...</div>';
    }


    Ext.define("Ext.locale.da.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.da.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} markerede rȪkker"
    });

    Ext.define("Ext.locale.da.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "Luk denne fane"
    });

    Ext.define("Ext.locale.da.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "VȪrdien i dette felt er ugyldig"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.da.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "Henter..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december"];

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.monthNames[month].substring(0, 3);
        };

        Ext.Date.monthNumbers = {
            Jan: 0,
            Feb: 1,
            Mar: 2,
            Apr: 3,
            May: 4,
            Jun: 5,
            Jul: 6,
            Aug: 7,
            Sep: 8,
            Oct: 9,
            Nov: 10,
            Dec: 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["sȹndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lȹrdag"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "Fortryd",
            yes: "Ja",
            no: "Nej"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: 'kr',
            // Danish Krone
            dateFormat: 'd/m/Y'
        });
    }

    Ext.define("Ext.locale.da.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "I dag",
        minText: "Denne dato er fȹr den tidligst tilladte",
        maxText: "Denne dato er senere end den senest tilladte",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'NȪste mned (Ctrl + hȹjre piltast)',
        prevText: 'Forrige mned (Ctrl + venstre piltast)',
        monthYearText: 'VȪlg en mned (Ctrl + op/ned pil for at Ȫndre rstal)',
        todayTip: "{0} (mellemrum)",
        format: "d/m/y",
        startDay: 1
    });

    Ext.define("Ext.locale.da.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "Cancel"
    });

    Ext.define("Ext.locale.da.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Side",
        afterPageText: "af {0}",
        firstText: "Fȹrste side",
        prevText: "Forrige side",
        nextText: "NȪste side",
        lastText: "Sidste side",
        refreshText: "Opfrisk",
        displayMsg: "Viser {0} - {1} af {2}",
        emptyMsg: 'Der er ingen data at vise'
    });

    Ext.define("Ext.locale.da.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "Minimum lȪngden for dette felt er {0}",
        maxLengthText: "Maksimum lȪngden for dette felt er {0}",
        blankText: "Dette felt skal udfyldes",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.da.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "Mindste-vȪrdien for dette felt er {0}",
        maxText: "Maksimum-vȪrdien for dette felt er {0}",
        nanText: "{0} er ikke et tilladt nummer"
    });

    Ext.define("Ext.locale.da.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "Inaktiveret",
        disabledDatesText: "Inaktiveret",
        minText: "Datoen i dette felt skal vȪre efter {0}",
        maxText: "Datoen i dette felt skal vȪre fȹr {0}",
        invalidText: "{0} er ikke en tilladt dato - datoer skal angives i formatet {1}",
        format: "d/m/y",
        altFormats: "d/m/Y|d-m-y|d-m-Y|d/m|d-m|dm|dmy|dmY|d|Y-m-d"
    });

    Ext.define("Ext.locale.da.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "Henter..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'Dette felt skal vȪre en email adresse i formatet "xxx@yyy.zzz"',
            urlText: 'Dette felt skal vȪre en URL i formatet "http:/' + '/xxx.yyy"',
            alphaText: 'Dette felt kan kun indeholde bogstaver og "_" (understregning)',
            alphanumText: 'Dette felt kan kun indeholde bogstaver, tal og "_" (understregning)'
        });
    }

    Ext.define("Ext.locale.da.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'Indtast URL:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'Fed (Ctrl+B)',
                    //Can I change this to Ctrl+F?
                    text: 'Formater det markerede tekst med fed.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'Kursiv (Ctrl+I)',
                    //Ctrl+K
                    text: 'Formater det markerede tekst med kursiv.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'Understreg (Ctrl+U)',
                    text: 'Understreg det markerede tekst.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'Forstȹr tekst',
                    text: 'Forȹg fontstȹrrelsen.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'Formindsk tekst',
                    text: 'Formindsk fontstȹrrelsen.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'Farve for tekstfremhȪvelse',
                    text: 'Skift baggrundsfarve for det markerede tekst.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Skriftfarve',
                    text: 'Skift skriftfarve for det markerede tekst.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'Juster venstre',
                    text: 'Venstrestil tekst.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'Centreret',
                    text: 'Centrer tekst.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'Juster hȹjre',
                    text: 'Hȹjrestil tekst.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'Punktopstilling',
                    text: 'Pbegynd punktopstilling.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'Nummereret opstilling',
                    text: 'Pbegynd nummereret opstilling.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'Hyperlink',
                    text: 'Lav det markerede test til et hyperlink.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'Kildetekstredigering',
                    text: 'Skift til redigering af kildetekst.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.da.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "SortȨr stigende",
        sortDescText: "SortȨr faldende",
        lockText: "Ls kolonne",
        unlockText: "Fjern ls fra kolonne",
        columnsText: "Kolonner"
    });

    Ext.define("Ext.locale.da.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(Ingen)',
        groupByText: 'GruppȨr efter dette felt',
        showGroupsText: 'Vis i grupper' //should this be sort in groups?
    });

    Ext.define("Ext.locale.da.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "Navn",
        valueText: "VȪrdi",
        dateFormat: "j/m/Y"
    });

});
