/**
 * Japanese translation
 * By tyama
 * 04-08-2007, 05:49 AM
 *
 * update based on English Translations by Condor (8 Aug 2008)
 * By sakuro (30 Aug 2008)
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">...</div>';
    }

    Ext.define("Ext.locale.ja.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.ja.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} "
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.ja.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'];

        Ext.Date.getShortMonthName = function(month) {
            return "" + (month + 1);
        };

        Ext.Date.monthNumbers = {
            "1": 0,
            "2": 1,
            "3": 2,
            "4": 3,
            "5": 4,
            "6": 5,
            "7": 6,
            "8": 7,
            "9": 8,
            "10": 9,
            "11": 10,
            "12": 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, name.length - 1)];
            // or simply parseInt(name.substring(0, name.length - 1)) - 1
        };

        Ext.Date.dayNames = ["ц", "ꆢ", "", "", "", "憢", ""];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 1); // just remove "" suffix
        };

        Ext.Date.formatCodes.a = "(this.getHours() < 12 ? '' : 'ꅾ')";
        Ext.Date.formatCodes.A = "(this.getHours() < 12 ? '' : 'ꅾ')"; // no case difference
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "顃驃",
            yes: "",
            no: ""
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: ',',
            decimalSeparator: '.',
            currencySign: '\u00a5',
            // Japanese Yen
            dateFormat: 'Y/m/d'
        });
    }

    Ext.define("Ext.locale.ja.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "",
        minText: "褃фǅŅфփ",
        maxText: "褃фǅфփ",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: '톣 (⡃⭃+)',
        prevText: '솣 (⡃⭃+)',
        monthYearText: ' (⡃⭃+/)',
        todayTip: "{0} (頃܃⭃頃顃)",
        format: "Y/m/d",
        startDay: 0,
        ariaTitle: '{0}',
        ariaTitleDateFormat: 'Y\u5e74m\u6708d\u65e5',
        longDayFormat: 'Y\u5e74m\u6708d\u65e5',
        monthYearFormat: 'Y\u5e74m\u6708'
    });

    Ext.define("Ext.locale.ja.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "顃驃"
    });

    Ext.define("Ext.locale.ja.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "܃⭃",
        afterPageText: "/ {0}",
        firstText: "ǅꥃ܃⭃",
        prevText: "܃⭃",
        nextText: "܃⭃",
        lastText: "ǅ܃⭃",
        refreshText: "",
        displayMsg: "{2}  {0} - {1} ƈ",
        emptyMsg: 'փ⭃'
    });

    Ext.define("Ext.locale.ja.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "⭃⽃송փ"
    });

    Ext.define("Ext.locale.ja.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "⭃⽃ǅŅ {0} փ",
        maxLengthText: "⭃⽃ǅ {0} փ",
        blankText: "փ",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.ja.form.field.Number", {
        override: "Ext.form.field.Number",
        decimalSeparator: ".",
        decimalPrecision: 2,
        minText: "⭃⽃ǅŅ {0} փ",
        maxText: "⭃⽃ǅ {0} փ",
        nanText: "{0} "
    });

    Ext.define("Ext.locale.ja.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "",
        disabledDatesText: "",
        minText: "⭃⽃ф {0} щф܃Ń",
        maxText: "⭃⽃ф {0} хф܃Ń",
        invalidText: "{0} фх袃փ - х袅Ń{1}փ",
        format: "Y/m/d",
        altFormats: "y/m/d|m/d/y|m/d/Y|m-d-y|m-d-Y|m/d|m-d|md|mdy|mdY|d|Y-m-d"
    });

    Ext.define("Ext.locale.ja.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: '⭃⽃⼃頃"user@example.com"Ńх袃Ń',
            urlText: 'URL"http:/' + '/www.example.com"Ńх袃Ń',
            alphaText: '舺ƈ"_"փ',
            alphanumText: '舺ƈ"_"փ'
        });
    }

    Ext.define("Ext.locale.ja.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: '⬃鯃URLƅх袃Ń:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: '񬅡 (⡃⭃+B)',
                    text: '褃顃頃ƅ񬅡փ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: ' (⡃⭃+I)',
                    text: '褃顃頃Ɔփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: ' (⡃⭃+U)',
                    text: '褃顃頃܃ƅփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: '煡ƅ',
                    text: '騃鴃馃ƅŃփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: '煡ƅŃ',
                    text: '騃鴃馃ƅŃŃփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: '煡Ń⨃',
                    text: '褃顃頃֯뙃ƅ놢փ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: '煡',
                    text: '褃顃頃뙃ƅ놢փ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: '',
                    text: '顃頃ƅփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: '',
                    text: '顃頃Ƅփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: '',
                    text: '顃頃ƅփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'Ÿ熥톢',
                    text: 'Ÿ熥톢Ɖփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'Ÿ쇫熥톢',
                    text: 'Ÿ쇫熥톢Ɖփ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'Ń⭃⬃',
                    text: '褃顃頃ƃŃ⭃⬃鯃փ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: '黃⭃頇',
                    text: '黃⭃頇⭃膢փ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.ja.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "",
        sortDescText: "",
        columnsText: "齃⨃"
    });

    Ext.define("Ext.locale.ja.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '()',
        groupByText: '齃⨃闃⽃⭃',
        showGroupsText: '闃⽃⭃'
    });

    Ext.define("Ext.locale.ja.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "쇺",
        valueText: "",
        dateFormat: "Y/m/d"
    });

    Ext.define("Ext.locale.ja.form.field.Time", {
        override: "Ext.form.field.Time",
        minText: "⭃⽃ꩃ {0} щꩃ܃Ń",
        maxText: "⭃⽃ꩃ {0} хꩃ܃Ń",
        invalidText: "{0} ꩅх袃փ",
        format: "g:i A",
        altFormats: "g:ia|g:iA|g:i a|g:i A|h:i|g:i|H:i|ga|ha|gA|h a|g a|g A|gi|hi|gia|hia|g|H"
    });

    Ext.define("Ext.locale.ja.form.CheckboxGroup", {
        override: "Ext.form.CheckboxGroup",
        blankText: "闃⽃⭃놣ǄďƉ褃"
    });

    Ext.define("Ext.locale.ja.form.RadioGroup", {
        override: "Ext.form.RadioGroup",
        blankText: "闃⽃⭃돭Ɖ褃"
    });

});
