
/**
 * Serbian Cyrillic Translation
 * by olovic Vladan (cyrillic, utf8 encoding)
 * sr_RS (ex: sr_CS, sr_YU)
 * 12 May 2007
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">Ϲϗϙϗϭ...</div>';
    }

    Ext.define("Ext.locale.sr_RS.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.sr_RS.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} ϹϸϗϘϗϻϹ ϴϳϾϙϗ"
    });

    Ext.define("Ext.locale.sr_RS.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "ϗϙϾϹ Ͼϙ éϦϗϹý"
    });

    Ext.define("Ext.locale.sr_RS.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "ϻϴϴϻϗ ϙϴϳϻϾ ϻϹϴ ϗϙϹϩϻϗ"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.sr_RS.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "Ϲϗϙϗϭ..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["ϗϻϗ", "ϴϘϗ", "ϣϗ", "Ϲϩ", "ϣϗ", "ϻ", "ϩ", "ϙ", "ϴϴϭϘϗ", "ϤϦϾϘϗ", "ϥϾϙϴϭϘϗ", "ϴϴϭϘϗ"];

        Ext.Date.dayNames = ["ϥϴϳϴϗ", "ϖϾϻϴϳϴϗϦ", "ϾϗϦ", "ϴϳϗ", "ϺϴϙϗϦ", "ϖϴϗϦ", "ϘϾϗ"];
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: " ϴϳ",
            cancel: "ϤϳϗϻϹ",
            yes: "ϗ",
            no: "ϥϴ"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: '\u0414\u0438\u043d\u002e',
            // Serbian Dinar
            dateFormat: 'd.m.Y'
        });
    }

    Ext.define("Ext.locale.sr_RS.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "ϗϻϗ",
        minText: "ϗϭ ϴ Ϲϴϳ ϻϗϭϗϴ ϳϾϸϙϾϴϻϾ ϳϗϭϗ",
        maxText: "ϗϭ ϴ ϻϗϦϾϻ ϻϗϙϴҢϴ ϳϾϸϙϾϴϻϾ ϳϗϭϗ",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'ϩϴϳϴҢϹ ϭϴϴ (Control+ϴϻϾ)',
        prevText: 'ϖϴϾϳϻϹ ϭϴϴ (Control+ϢϴϙϾ)',
        monthYearText: 'ϸϗϘϴϹϴ ϭϴϴ (Control+Ͼϴ/Ͼϩϴ ϸϗ ϹϸϘϾ ϾϳϹϻϴ)',
        todayTip: "{0} (ϗϸϭϗϦϻϹϗ)",
        format: "d.m.y",
        startDay: 1
    });

    Ext.define("Ext.locale.sr_RS.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "ϗϻϗ",
        afterPageText: "Ͼϳ {0}",
        firstText: "ϖϙϗ ϗϻϗ",
        prevText: "ϖϴϾϳϻϗ ϗϻϗ",
        nextText: "ϩϴϳϴҢϗ ϗϻϗ",
        lastText: "ϖϾϩϴϳϗ ϗϻϗ",
        refreshText: "ϤϙϴϵϹ",
        displayMsg: "ϖϹϦϗϸϗϻϗ {0} - {1} Ͼϳ {2}",
        emptyMsg: 'ϥϴϭϗϭ ϗ ϹϦϗϸϗϹ'
    });

    Ext.define("Ext.locale.sr_RS.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "ϣϹϻϹϭϗϩϻϗ ϳϵϹϻϗ ϾϙϾ Ͼϗ ϴ {0}",
        maxLengthText: "ϣϗϦϹϭϗϩϻϗ ϳϵϹϻϗ ϾϙϾ Ͼϗ ϴ {0}",
        blankText: "ϖϾϴ ϴ ϾϘϗϙϴϸϻϾ",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.sr_RS.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "ϣϹϻϹϭϗϩϻϗ ϙϴϳϻϾ  Ͼ ϴ {0}",
        maxText: "ϣϗϦϹϭϗϩϻϗ ϙϴϳϻϾ  Ͼ ϴ {0}",
        nanText: "{0} ϻϹϴ ϗϙϹϩϗϻ ϘϾ"
    });

    Ext.define("Ext.locale.sr_RS.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "ϖϗϹϙϻϾ",
        disabledDatesText: "ϖϗϹϙϻϾ",
        minText: "ϗϭ  ϾϙϾϭ Ͼ ϭϾϗ ϘϹϹ ϻϗϦϾϻ {0}",
        maxText: "ϗϭ  ϾϙϾϭ Ͼ ϭϾϗ ϘϹϹ ϴ {0}",
        invalidText: "{0} ϻϹϴ ϗϙϹϩϗϻ ϳϗϭ - ϸϗϴϙϗϻϹ ϾϘϩϹϦ ϴ {1}",
        format: "d.m.y"
    });

    Ext.define("Ext.locale.sr_RS.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "Ϲϗϙϗϭ..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'ϤϙϾ Ͼϴ Ϲϙϗϗ e-mail ϗϳϴ ϹϦϹϙϾ  ϾϘϩϹϦ "korisnik@domen.com"',
            urlText: 'ϤϙϾ Ͼϴ Ϲϙϗϗ URL ϗϳϴ ϹϦϹϙϾ  ϾϘϩϹϦ "http:/' + '/www.domen.com"',
            alphaText: 'ϤϙϾ Ͼϴ ϭϾϵϴ ϗϳϵϗϹ ϹϦϹϙϾ ϩϾϙϗ Ϲ ϸϻϗϦ _',
            alphanumText: 'ϤϙϾ Ͼϴ ϭϾϵϴ ϗϳϵϗϹ ϗϭϾ ϩϾϙϗ, ϘϾϴϙϴ Ϲ ϸϻϗϦ _'
        });
    }

    Ext.define("Ext.locale.sr_RS.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "ϗҢϹ ϴϳϾϩϴϳ",
        sortDescText: "ϤϗϳϗҢϹ ϴϳϾϩϴϳ",
        lockText: "ϗϦϗ ϦϾϩϾϻ",
        unlockText: "ϤϦϗ ϦϾϩϾϻ",
        columnsText: "ϾϩϾϻϴ"
    });

    Ext.define("Ext.locale.sr_RS.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "ϥϗϸϹϙ",
        valueText: "ϴϳϻϾ",
        dateFormat: "d.m.Y"
    });

});
