/**
 * Swedish translation (utf8-encoding)
 * By Erik Andersson, Monator Technologies
 * 24 April 2007
 * Changed by Cariad, 29 July 2007
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);


    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">Laddar...</div>';
    }

    Ext.define("Ext.locale.sv_SE.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.sv_SE.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} markerade rad(er)"
    });

    Ext.define("Ext.locale.sv_SE.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "Stng denna flik"
    });

    Ext.define("Ext.locale.sv_SE.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "Vrdet i detta flt r inte tilltet"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.sv_SE.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "Laddar..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["januari", "februari", "mars", "april", "maj", "juni", "juli", "augusti", "september", "oktober", "november", "december"];

        Ext.Date.dayNames = ["sȵndag", "mndag", "tisdag", "onsdag", "torsdag", "fredag", "lȵrdag"];
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "Avbryt",
            yes: "Ja",
            no: "Nej"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: 'kr',
            // Swedish Krone
            dateFormat: 'Y-m-d'
        });
    }

    Ext.define("Ext.locale.sv_SE.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "Idag",
        minText: "Detta datum intrffar fȵre det tidigast tilltna",
        maxText: "Detta datum intrffar efter det senast tilltna",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'Nsta mnad (Ctrl + hȵgerpil)',
        prevText: 'Fȵregende mnad (Ctrl + vnsterpil)',
        monthYearText: 'Vlj en mnad (Ctrl + upptpil/nertpil fȵr att ndra rtal)',
        todayTip: "{0} (mellanslag)",
        format: "Y-m-d",
        startDay: 1
    });

    Ext.define("Ext.locale.sv_SE.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Sida",
        afterPageText: "av {0}",
        firstText: "Fȵrsta sidan",
        prevText: "Fȵregende sida",
        nextText: "Nsta sida",
        lastText: "Sista sidan",
        refreshText: "Uppdatera",
        displayMsg: "Visar {0} - {1} av {2}",
        emptyMsg: 'Det finns ingen data att visa'
    });

    Ext.define("Ext.locale.sv_SE.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "Minsta tilltna lngd fȵr detta flt r {0}",
        maxLengthText: "Stȵrsta tilltna lngd fȵr detta flt r {0}",
        blankText: "Detta flt r obligatoriskt",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.sv_SE.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "Minsta tilltna vrde fȵr detta flt r {0}",
        maxText: "Stȵrsta tilltna vrde fȵr detta flt r {0}",
        nanText: "{0} r inte ett tilltet nummer"
    });

    Ext.define("Ext.locale.sv_SE.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "Inaktiverad",
        disabledDatesText: "Inaktiverad",
        minText: "Datumet i detta flt mste intrffa efter {0}",
        maxText: "Datumet i detta flt mste intrffa fȵre {0}",
        invalidText: "{0} r inte ett tilltet datum - datum ska anges i formatet {1}",
        format: "Y-m-d"
    });

    Ext.define("Ext.locale.sv_SE.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "Laddar..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'Detta flt ska innehlla en e-post adress i formatet "anvndare@domn.se"',
            urlText: 'Detta flt ska innehlla en lnk (URL) i formatet "http:/' + '/www.domn.se"',
            alphaText: 'Detta flt fr bara innehlla bokstver och "_"',
            alphanumText: 'Detta flt fr bara innehlla bokstver, nummer och "_"'
        });
    }

    Ext.define("Ext.locale.sv_SE.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "Sortera stigande",
        sortDescText: "Sortera fallande",
        lockText: "Ls kolumn",
        unlockText: "Ls upp kolumn",
        columnsText: "Kolumner"
    });

    Ext.define("Ext.locale.sv_SE.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "Namn",
        valueText: "Vrde",
        dateFormat: "Y-m-d"
    });

});
