/**
 * Ukrainian translations for ExtJS (UTF-8 encoding)
 *
 * Original translation by zlatko
 * 3 October 2007
 *
 * Updated by dev.ashevchuk@gmail.com
 * 01.09.2009
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">ϗϙϗϻϗϵϴϻϻ...</div>';
    }

    Ext.define("Ext.locale.ukr.view.View", {
        override: "Ext.view.View",
        emptyText: "<ϖϾϾϵϻϾ>"
    });

    Ext.define("Ext.locale.ukr.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} ϾϘϗϻϹ ϳϦϙ"
    });

    Ext.define("Ext.locale.ukr.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "ϗϦϹϹ  ϙϦϩϗϳϦ"
    });

    Ext.define("Ext.locale.ukr.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "ϹϘϻϴ ϸϻϗϴϻϻ"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.ukr.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "ϗϙϗϻϗϵϴϻϻ..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["ϴϻ", "ϢϹϠ", "ϴϴϸϴϻ", "ϙϴϻ", "ϗϙϴϻ", "Ϻϴϙϴϻ", "ϢϹϴϻ", "ϴϴϻ", "ϴϴϴϻ", "Ͼϙϴϻ", "ϢϹϾϗϳ", "ϳϴϻ"];

        Ext.Date.dayNames = ["ϥϴϳϩ", "ϖϾϻϴϳϩϾϦ", "ϙϾϾϦ", "ϴϴϳϗ", "Ϻϴϙϴ", "ϖϻϹ", "ϘϾϗ"];
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "ϳϭϻϗ",
            yes: "ϗϦ",
            no: "ϥ"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: '\u20b4',
            // Ukranian Hryvnia
            dateFormat: 'd.m.Y'
        });
    }

    Ext.define("Ext.locale.ukr.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "ϾϾϳϻ",
        minText: "Ϫ ϳϗϗ ϭϴϻϗ ϸϗ ϭϻϭϗϩϻ ϳϾϹϭ ϳϗ",
        maxText: "Ϫ ϳϗϗ Ϙϩϗ ϸϗ ϭϗϦϹϭϗϩϻ ϳϾϹϭ ϳϗ",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'ϥϗϻϹϠ ϭ (Control+ϗϙϾ)',
        prevText: 'ϖϾϴϴϳϻϠ ϭ (Control+ϩϙϾ)',
        monthYearText: 'ϹϘ ϭ (Control+ϙϴ/ϻϹϸ ϳϩ ϙϹϘϾ ϾϦ)',
        todayTip: "{0} (ϖϾϘϩ)",
        format: "d.m.y",
        startDay: 1
    });

    Ext.define("Ext.locale.ukr.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "ϳϭϻϗ"
    });

    Ext.define("Ext.locale.ukr.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "ϾϻϦϗ",
        afterPageText: "ϸ {0}",
        firstText: "ϖϴϗ ϾϻϦϗ",
        prevText: "ϖϾϴϴϳϻ ϾϻϦϗ",
        nextText: "ϥϗϻϗ ϾϻϦϗ",
        lastText: "Ϥϗϻϻ ϾϻϦϗ",
        refreshText: "ϤϙϵϹϹ",
        displayMsg: "ϳϾϘϗϵϴϻϻ ϸϗϹϙ ϸ {0} Ͼ {1}, ϙϾϾ {2}",
        emptyMsg: 'ϗϻ ϳϩ ϙϳϾϘϗϵϴϻϻ ϙϳϻ'
    });

    Ext.define("Ext.locale.ukr.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "ϣϻϭϗϩϻϗ ϳϾϙϵϹϻϗ ϾϾ Ͼϩ {0}",
        maxLengthText: "ϣϗϦϹϭϗϩϻϗ ϳϾϙϵϹϻϗ ϾϾ Ͼϩ {0}",
        blankText: "Ϫϴ Ͼϩϴ  ϾϘϾϙϸϦϾϙϹϭ ϳϩ ϸϗϾϙϻϴϻϻ",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.ukr.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "ϻϗϴϻϻ  Ͼϭ Ͼϩ ϻϴ ϭϾϵϴ ϘϹ ϭϴϻϴ {0}",
        maxText: "ϻϗϴϻϻ  Ͼϭ Ͼϩ ϻϴ ϭϾϵϴ ϘϹ Ϙϩϴ {0}",
        nanText: "{0} ϻϴ  ϹϩϾϭ"
    });

    Ext.define("Ext.locale.ukr.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "ϥϴ ϳϾϻϾ",
        disabledDatesText: "ϥϴ ϳϾϻϾ",
        minText: "ϗϗ  Ͼϭ Ͼϩ ϾϙϹϻϻϗ ϘϹ Ϙϩϗ {0}",
        maxText: "ϗϗ  Ͼϭ Ͼϩ ϾϙϹϻϻϗ ϘϹ ϭϴϻϗ {0}",
        invalidText: "{0} ϹϘϻϗ ϳϗϗ - ϳϗϗ ϾϙϹϻϻϗ ϘϹ ϙϦϗϸϗϻϗ  Ͼϭϗ {1}",
        format: "d.m.y"
    });

    Ext.define("Ext.locale.ukr.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "ϗϙϗϻϗϵϴϻϻ..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'Ϫϴ Ͼϩϴ ϾϙϹϻϻϾ ϭϹϹ ϗϳϴ ϴϩϴϦϾϻϻϾ ϾϹ  Ͼϭϗ "user@example.com"',
            urlText: 'Ϫϴ Ͼϩϴ ϾϙϹϻϻϾ ϭϹϹ URL  Ͼϭϗ "http:/' + '/www.example.com"',
            alphaText: 'Ϫϴ Ͼϩϴ ϾϙϹϻϻϾ ϭϹϹ ϙϹϦϩϻϾ ϩϗϹϻϦ ϩϴϹ ϗ ϹϭϙϾϩ ϳϦϴϩϴϻϻ "_"',
            alphanumText: 'Ϫϴ Ͼϩϴ ϾϙϹϻϻϾ ϭϹϹ ϙϹϦϩϻϾ ϩϗϹϻϦ ϩϴϹ, ϹϹ ϗ ϹϭϙϾϩ ϳϦϴϩϴϻϻ "_"'
        });
    }

    Ext.define("Ext.locale.ukr.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'ϳ-ϩϗϦϗ ϙϙϴϳ ϗϳϴ:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'ϥϗϙϵϹϻϹϠ (Ctrl+B)',
                    text: 'ϾϘϹϹ ϻϗϙϵϹϻϹϭ ϙϹϳϩϴϻϹϠ ϴϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'Ϲϙ (Ctrl+I)',
                    text: 'ϾϘϹϹ ϦϹϙϾϭ ϙϹϳϩϴϻϹϠ ϴϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'ϖϳϦϴϩϴϻϹϠ (Ctrl+U)',
                    text: 'ϾϘϹϹ ϳϦϴϩϴϻϹϭ ϙϹϳϩϴϻϹϠ ϴϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'ϘϩϹϹ Ͼϸϭ',
                    text: 'ϘϩϹϹ Ͼϸϭ Ϲϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'ϭϴϻϹϹ Ͼϸϭ',
                    text: 'ϭϴϻϹϹ Ͼϸϭ Ϲϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'ϗϩϹϙϦϗ',
                    text: 'ϭϻϹϹ ϦϾϩ Ͼϻ ϳϩ ϙϹϳϩϴϻϾϾ ϴϦ ϗϘϾ ϗϘϸϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Ͼϩ ϴϦ',
                    text: 'ϭϻϹϹ ϦϾϩ ϙϹϳϩϴϻϾϾ ϴϦ ϗϘϾ ϗϘϸϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'ϹϙϻϹ ϴϦ Ͼ ϩϙϾϭ Ͼϩ',
                    text: 'Ϲϙϻϙϗϻϻ ϴϦ Ͼ ϩϙϾϭ Ͼϩ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'ϹϙϻϹ ϴϦ Ͼ ϴϻ',
                    text: 'Ϲϙϻϙϗϻϻ ϴϦ Ͼ ϴϻ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'ϹϙϻϹ ϴϦ Ͼ ϗϙϾϭ Ͼϩ',
                    text: 'Ϲϙϻϙϗϻϻ ϴϦ Ͼ ϗϙϾϭ Ͼϩ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'ϣϗϦϴϹ',
                    text: 'ϖϾϗϹ ϭϗϦϾϙϗϻϹϠ ϹϾϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'ϥϭϴϗ',
                    text: 'ϖϾϗϹ ϻϭϴϻϾϙϗϻϹϠ ϹϾϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'ϗϙϹϹ ϴϾϹϩϗϻϻ',
                    text: 'ϙϾϴϻϻ ϾϹϩϗϻϻ ϸ ϙϹϳϩϴϻϾϾ ϴϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'ϵϴϴϩϻϹϠ ϦϾϳ',
                    text: 'ϴϵϹϭ ϴϳϗϙϗϻϻ ϳϵϴϴϩϻϾϾ ϦϾϳ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.ukr.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "ϾϙϗϹ Ͼ ϸϾϗϻϻ",
        sortDescText: "ϾϙϗϹ Ͼ ϗϳϗϻϻ",
        lockText: "ϗϦϹϹ Ͼϙϴ",
        unlockText: "ϳϦϹϹ Ͼϙϴ",
        columnsText: "Ͼϙ"
    });

    Ext.define("Ext.locale.ukr.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "ϥϗϸϙϗ",
        valueText: "ϻϗϴϻϻ",
        dateFormat: "j.m.Y"
    });

});
