/**
 * Simplified Chinese translation
 * By DavidHu
 * 09 April 2007
 *
 * update by andy_ghg
 * 2009-10-22 15:00:57
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm),
        parseCodes;

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">ሻ...</div>';
    }

    Ext.define("Ext.locale.zh_CN.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.zh_CN.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "宅 {0} "
    });

    Ext.define("Ext.locale.zh_CN.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "燡"
    });

    Ext.define("Ext.locale.zh_CN.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "хǭ"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.zh_CN.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "ǅ..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["ǆ", "", "놣", "", "", "ࡆ", "↣", "ཆ", "", "", "ǆ", ""];

        Ext.Date.dayNames = ["", "", "", "", "", "", ""];

        Ext.Date.formatCodes.a = "(this.getHours() < 12 ? '' : '')";
        Ext.Date.formatCodes.A = "(this.getHours() < 12 ? '' : '')";

        parseCodes = {
            g: 1,
            c: "if (/()/i.test(results[{0}])) {\n"
                + "if (!h || h == 12) { h = 0; }\n"
                + "} else { if (!h || h < 12) { h = (h || 0) + 12; }}",
            s: "(|)",
            calcAtEnd: true
        };

        Ext.Date.parseCodes.a = Ext.Date.parseCodes.A = parseCodes;
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "",
            cancel: "",
            yes: "",
            no: "ɪ"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: ',',
            decimalSeparator: '.',
            currencySign: '\u00a5',
            // Chinese Yuan
            dateFormat: 'ymd'
        });
    }

    Ext.define("Ext.locale.zh_CN.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "",
        minText: "ц񺄦ĆǅŅц",
        //update
        maxText: "цńĆǅц",
        //update
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: ' (Ctrl+Right)',
        prevText: '脹 (Ctrl+Left)',
        monthYearText: '宅Ǆ (Control+Up/Down ц)',
        //update
        todayTip: "{0} (ᭉ)",
        format: "ymd",
        ariaTitle: '{0}',
        ariaTitleDateFormat: 'Y\u5e74m\u6708d\u65e5',
        longDayFormat: 'Y\u5e74m\u6708d\u65e5',
        monthYearFormat: 'Y\u5e74m\u6708',
        getDayInitial: function (value) {
            // Grab the last character
            return value.substr(value.length - 1);
        }
    });

    Ext.define("Ext.locale.zh_CN.picker.Month", {
        override: "Ext.picker.Month",
        okText: "",
        cancelText: ""
    });

    Ext.define("Ext.locale.zh_CN.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "",
        //update
        afterPageText: ", {0} ",
        //update
        firstText: "ǉ",
        prevText: "脹ǉ",
        //update
        nextText: "ǉ",
        lastText: "ǅĉ",
        refreshText: "긆",
        displayMsg: " {0} - {1}폭 {2} ",
        //update
        emptyMsg: '톣'
    });

    Ext.define("Ext.locale.zh_CN.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "шщ䆣ǅŉ {0} ",
        maxLengthText: "шщ䆣ǅ {0} ",
        blankText: "шщ",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.zh_CN.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "шщ䆣ǅŅǭ {0}",
        maxText: "шщ䆣ǅǭ {0}",
        nanText: "{0} ǭ"
    });

    Ext.define("Ext.locale.zh_CN.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "",
        disabledDatesText: "",
        minText: "шщц {0} ",
        maxText: "шщц {0} ",
        invalidText: "{0} ц - ᭅŏ {1}",
        format: "ymd"
    });

    Ext.define("Ext.locale.zh_CN.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "ሻ..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'шщɉ髄ǏᭅŅ鏭 "user@example.com"',
            urlText: 'шщURLǏᭅŅ鏭 "http:/' + '/www.example.com"',
            alphaText: 'шщŬ⻅ɽ舺ƅ_',
            //update
            alphanumText: 'шщŬ⻅ɽ舺ƅ,򗅡_' //update
        });
    }
    //add HTMLEditor's tips by andy_ghg
    Ext.define("Ext.locale.zh_CN.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'ስ:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: ' (Ctrl+B)',
                    text: '넹煡',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: ' (Ctrl+I)',
                    text: '넹煡',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'Ƈ (Ctrl+U)',
                    text: 'ֆǉ煡ᄹƇ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: '񺅡',
                    text: '񺅡Ÿ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'Ņ',
                    text: 'ŅŅŸ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'ф뙇禆熣',
                    text: '煡ĩņ캅뇼܄爫ǆ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: '',
                    text: '',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: '',
                    text: '煡',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: '',
                    text: '煡',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: '',
                    text: '煡',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'Ÿ',
                    text: 'ǅꢅŸ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'Ÿ',
                    text: 'ǅꢅŸ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'Ɉ',
                    text: 'ǉ熣Ɉ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: '兢',
                    text: 'ф䅻Ņė熣',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.zh_CN.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "",
        //update
        sortDescText: "ƅ",
        //update
        lockText: "܅",
        //update
        unlockText: "",
        //update
        columnsText: ""
    });

    Ext.define("Ext.locale.zh_CN.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "쇺",
        valueText: "ǭ",
        dateFormat: "ymd"
    });

});
