package org.apache.jsp.admin.AggregateUpdateTest.data;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.EgName;
import com.eg.EgUtils;
import com.eg.IniFile;
import com.eg.EgDiscInfo;
import com.eg.EgSpecsInfo;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.EgExternalInfo;
import com.eg.EgAggregateInfo;
import com.eg.MappingNameSorter;
import com.egurkha.EgConstants;
import com.egurkha.ini.IniUI;
import com.egurkha.util.StringUtils;
import java.util.List;
import java.util.TreeMap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import com.egurkha.admin.AuditLogThread;
import com.egurkha.admin.UpdateTestPeriod;
import com.egurkha.util.EgStackForBackButton;
import com.eg.EgRoleInfo;
import com.egurkha.UserRegistry;
import com.egurkha.User;
import com.eg.EgConfigFilesSync;
import java.util.*;
import net.sf.json.*;

public final class updateTestPeriodsJson_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


	response.setContentType("text/html;charset=UTF-8");
	JSONObject rootJson = new JSONObject();
	JSONObject commonObjectType = new JSONObject();
	JSONArray arrayType =new  JSONArray();
	JSONObject commonObjectName = new JSONObject();
	JSONArray arrayName =new  JSONArray();
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
	TreeMap reversePeriodMap = new TreeMap();
	if(!EgUtils.isNull((Object) testFormatPeriod))
	{
		for (int i=0;i<testFormatPeriod.length;i++)
		{
			String secondsStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
			reversePeriodMap.put(secondsStr, testFormatPeriod[i]);
		}
	}
	String operation = request.getParameter("operation");
	String sessionId = request.getParameter("sessid");
	operation = "update";
	User _user = UserRegistry.getInstance().getUser(sessionId,true);
	if(!StringUtils.isNull(operation) && operation.equalsIgnoreCase("update"))
	{
		String selectedTests = request.getParameter("selectedTests");
		if(!StringUtils.isNull(selectedTests))
		{
			/* code for auditlog starts */
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Aggregate Test Period");
			auditLogThread.setValue("Activity","Update Test Period");
			/* code for auditlog ends */
			StringTokenizer tokens = new StringTokenizer(selectedTests,"$");
			TreeMap map = new TreeMap();
			while(tokens.hasMoreTokens())
			{
				String information = (String) tokens.nextToken();
				String testPeriod = information.substring(information.lastIndexOf(":")+1);
				String previousTestPeriod = testPeriod.substring(testPeriod.lastIndexOf("|")+1);
				testPeriod = testPeriod.substring(0,testPeriod.lastIndexOf("|"));
				information = information.substring(0,information.lastIndexOf(":"));
				String testName = information.substring(information.lastIndexOf(":")+1);
				String componentName = information.substring(0,information.lastIndexOf(":"));
				if(map.containsKey(componentName))
				{
					TreeMap imap = (TreeMap) map.get(componentName);
					imap.put(testName,testPeriod);
					if(componentName.endsWith(":NULL"))
						componentName = componentName.substring(0,componentName.lastIndexOf(":"));
					auditLogThread.setCurrentValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(testPeriod));
					auditLogThread.setPreviousValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(previousTestPeriod));
				}
				else
				{
					TreeMap imap = new TreeMap();
					imap.put(testName,testPeriod);
					map.put(componentName,imap);
					if(componentName.endsWith(":NULL"))
						componentName = componentName.substring(0,componentName.lastIndexOf(":"));
					auditLogThread.setCurrentValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(testPeriod));
					auditLogThread.setPreviousValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(previousTestPeriod));
				}
			}

      egurkha.ServiceBean serviceBean = null;
      synchronized (request) {
        serviceBean = (egurkha.ServiceBean) _jspx_page_context.getAttribute("serviceBean", PageContext.REQUEST_SCOPE);
        if (serviceBean == null){
          serviceBean = new egurkha.ServiceBean();
          _jspx_page_context.setAttribute("serviceBean", serviceBean, PageContext.REQUEST_SCOPE);
        }
      }

			//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
			IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
			serviceBean.stopDiscovery();
			UpdateTestPeriod updateTestPeriod = new UpdateTestPeriod();
			updateTestPeriod.updateTestPeriod(map);
			serviceBean.startDiscovery("1");
			EgConfigFilesSync.releaseInstance(infraIni);

			/* code for auditlog starts */
			auditLogThread.setValue("Description","Aggregate tests periods have been updated");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}
	}
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	Vector serverTypes = aggregateInfo.getAggregateTypes();
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	Iterator itr1 = serverTypes.iterator();
	while(itr1.hasNext())
	{
		if(!listComponentTypes.contains(itr1.next()))
		{
			itr1.remove();
		}
	}
	for(int i=serverTypes.size()-1;i>=0;i--)
		if(discInfo.getAllServersOfType((String) serverTypes.get(i)).length==0)
			serverTypes.remove(i);
	String selectedServer = request.getParameter("selectedServer");
	if(StringUtils.isNull(selectedServer))
		selectedServer = "-1";
	TreeMap periodMap = new TreeMap();
	if(!EgUtils.isNull((Object) testFormatPeriod))
	{
		for (int i=0;i<testFormatPeriod.length;i++)
		{
			String secondsStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
			long seconds = Long.parseLong(secondsStr);
			periodMap.put(new Long(seconds), testFormatPeriod[i]);
		}
	}

	TreeMap localSettings = new TreeMap();
	String selectedComponent = request.getParameter("selectedComponent");
	if(StringUtils.isNull(selectedComponent))
		selectedComponent = "-1";
	String userLanguage = _user.getLanguage();
	//String userLanguage = null;
	if(userLanguage == null)
		userLanguage = IniUI.getInstance().getDefaultLanguage();
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList(serverTypes);
	serverList = sorter.getSortedCompTypeList(serverList);
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	String test_component = request.getParameter("test_component");
	String selectedTest = null;
	if(!StringUtils.isNull(test_component))
	{
		selectedTest = test_component.substring(0,test_component.indexOf(":"));
		selectedComponent = test_component.substring(test_component.indexOf(":")+1);
		selectedServer = selectedComponent.substring(0,selectedComponent.indexOf(":"));
	}
	if(serverList != null && serverList.size()>0)
	{
		commonObjectType.put("displayField",mappingInfo.getTextDescription("admin.common.Choose a component type"));
		commonObjectType.put("valueField","-1");
		arrayType.add(commonObjectType);
	}
	else
	{
		commonObjectType.put("displayField",mappingInfo.getTextDescription("admin.common.Not applicable"));
		commonObjectType.put("valueField","-1");
		arrayType.add(commonObjectType);
	}
	if(serverList != null && serverList.size()>1)
	{
		commonObjectType.put("displayField",mappingInfo.getTextDescription("admin.common.ALL"));
		commonObjectType.put("valueField","all");
		arrayType.add(commonObjectType);
	}
	for(int i=0;i<serverList.size();i++)
	{
		EgName nameObj = (EgName)serverList.get(i);
		String serverName = nameObj.getActualName();
		String displayName = nameObj.getLocalName();
		localSettings.put(serverName,displayName);

		commonObjectType.put("displayField",displayName);
		commonObjectType.put("valueField",serverName);
		arrayType.add(commonObjectType);
	}
	rootJson.put("ComponentTypeList",arrayType);
	if(serverList != null && serverList.size()>0)
	{
		commonObjectName.put("displayField",mappingInfo.getTextDescription("admin.common.Choose a component name"));
		commonObjectName.put("valueField","-1");
		arrayName.add(commonObjectName);
	}
	else
	{
		commonObjectName.put("displayField",mappingInfo.getTextDescription("admin.common.Not applicable"));
		commonObjectName.put("valueField","-1");
		arrayName.add(commonObjectName);

	}
	String componentNames[] = null;
	if(selectedServer.equalsIgnoreCase("all"))
	{
		Vector allComponents = new Vector();
		for(int i=serverTypes.size()-1;i>=0;i--)
		{
			String components[] = discInfo.getAllServersOfType(serverTypes.get(i).toString());
			if(components != null && components.length>0)
				allComponents.addAll(java.util.Arrays.asList(components));
		}
		Collections.sort(allComponents);
		componentNames = (String[])allComponents.toArray(new String[allComponents.size()]);
	}
	else
		componentNames = discInfo.getAllServersOfType(selectedServer);
	if(componentNames != null && componentNames.length>1)
	{
		commonObjectName.put("displayField",mappingInfo.getTextDescription("admin.common.ALL"));
		commonObjectName.put("valueField","all");
		arrayName.add(commonObjectName);
	}
	String disp = null;
	for(int i=0;i<componentNames.length;i++)
	{
		String componentName = componentNames[i];
		int firstIndex = componentName.indexOf(":");
		String compType = componentName.substring(0,firstIndex);
		String nickName = componentName.substring(firstIndex+1,componentName.lastIndexOf(":"));
		String groupName = mappingInfo.getComponentTypeDescription(compType);
		if(selectedServer.equalsIgnoreCase("all"))
		{
			commonObjectName.put("displayField",nickName);
			commonObjectName.put("valueField",componentName);
			commonObjectName.put("groupField",groupName);
			arrayName.add(commonObjectName);
		}
		else
		{
			commonObjectName.put("displayField",nickName);
			commonObjectName.put("valueField",componentName);
			commonObjectName.put("groupField",groupName);
			arrayName.add(commonObjectName);
		}
	}
	rootJson.put("ComponentNameList",arrayName);

	boolean showUpdateButton = false;
	JSONArray gridData2 = new JSONArray();
	JSONArray gridColumns = new JSONArray();
	if(!selectedComponent.equals("-1"))
	{
		UpdateTestPeriod updateTestPeriod = new UpdateTestPeriod();
		TreeMap details = new TreeMap();
		if(selectedComponent.equalsIgnoreCase("all"))
			updateTestPeriod.setComponentTestMapping(selectedServer,"all");
		else
			updateTestPeriod.setComponentTestMapping(selectedServer,selectedComponent);
		details = updateTestPeriod.getComponentTestMapping();
		Iterator detailsItr = details.keySet().iterator();
		int i=0;
		int columnCount = 0;
		while(detailsItr.hasNext())
		{
			JSONArray gridData = new JSONArray();
			showUpdateButton = true;
			String component = (String) detailsItr.next();
			String displayComponent = component.substring(component.indexOf(":")+1,component.lastIndexOf(":"));
			String localStr = (String) localSettings.get((String)component.substring(0,component.indexOf(":")));

			JSONObject gridCols = new JSONObject();
			gridCols.put("col_1",displayComponent);
			gridCols.put("col_2",component);
			gridCols.put("col_3","");
			gridColumns.add(gridCols);
			columnCount++;
			if(i==0)
			{
				i=1;
			}
			TreeMap innerDetails = (TreeMap) details.get(component);
			Iterator innerDetailsItr = innerDetails.keySet().iterator();
			ArrayList testList = new ArrayList(innerDetails.keySet());
			testList = sorter.getSortedTestList(testList);
			for(int c=0;c<testList.size();c++)
			{
				JSONObject testsForSelComponent1 = new JSONObject();
				EgName nameObj = (EgName)testList.get(c);
				String testName = nameObj.getActualName();
				String displayName = nameObj.getLocalName();
				String frequencyStr = (String) innerDetails.get(testName);
				String perviousFrequency = "";
				if(frequencyStr != null && frequencyStr.indexOf("#") > 0)
				{
					perviousFrequency= frequencyStr.substring(0,frequencyStr.indexOf("#"));
					frequencyStr = frequencyStr.substring(frequencyStr.indexOf("#")+1);
				}
				long frequency = Integer.parseInt(frequencyStr);

				String status = (selectedTest != null && testName.equals(selectedTest))?"checked":"";
				testsForSelComponent1.put("col_3",testName);
				testsForSelComponent1.put("col_1", displayName);
				Iterator itr = periodMap.keySet().iterator();
				JSONArray arrayTime1 = new JSONArray();
				String tmpStr = "";
				while(itr.hasNext())
				{
					JSONObject commonObjectTime1 = new JSONObject();
					Long seconds = (Long) itr.next();
					String display = (String) periodMap.get(seconds);
					String numeric = display.substring(0,display.indexOf(EgConstants.BLANK_SPACE));
					String str = "admin.common."+display.substring(display.indexOf(EgConstants.BLANK_SPACE)+1);
					String periods = numeric+" "+display.substring(display.indexOf(EgConstants.BLANK_SPACE)+1);
					if(seconds.longValue()<frequency)
						continue;

					if (tmpStr.length() == 0)
					{
						testsForSelComponent1.put("col_2",periods);
						tmpStr = periods;
					}
					commonObjectTime1.put("displayField",periods);
					commonObjectTime1.put("valueField",periods);
					arrayTime1.add(commonObjectTime1);
				}
				rootJson.put("TimePeriodList_"+columnCount+"_"+c,arrayTime1);
				gridData.add(testsForSelComponent1);
			}
			gridData2.add(gridData);
		}
	}
	rootJson.put("gridData2",gridData2);
	rootJson.put("gridColumns",gridColumns);
	if(request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/aggUpdateTestPeriod.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/aggUpdateTestPeriod.jsp");
	}
	out.println(rootJson.toString());

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
