package org.apache.jsp.admin.AutoTopology.data;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.egurkha.*;
import java.util.*;
import com.eg.EgDbAdapterTypeUI;
import egurkha.EgDbAdapterUI;
import egurkha.reporter.*;
import com.eg.*;
import java.util.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.EgDateInfo;
import com.eg.EgMappingInfo;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgInstallInfo;
import egurkha.EgCrawler;
import com.egurkha.EgConstants;
import com.egurkha.monitor.alarms.AlarmPriorities;
import com.egurkha.util.StringUtils;
import com.egurkha.ini.IniUI;
import com.egurkha.EgNewTopology;
import com.eg.TopoRhsComp;
import com.eg.IniFile;
import com.eg.EgConfigFilesSync;
import java.util.*;

public final class EgTopologyB_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	public boolean isNullOrEmpty(Object object)
	{
		try
		{
			if(object == null)
			{
				return true;
			}
			else if(object instanceof java.lang.String)
			{
				String string = (String) object;
				if (string.equals("") || string.equalsIgnoreCase("null"))
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.lang.StringBuffer)
			{
				String stringBuffer = (String)object.toString();
				if (stringBuffer.equals("") || stringBuffer.equals("null"))
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.StringTokenizer)
			{
				StringTokenizer st = (StringTokenizer) object;
				if (!st.hasMoreTokens())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.List)
			{
				List list =(List)object;
				if (list.isEmpty())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.Map)
			{
				Map map =(Map)object;
				if (map.isEmpty())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.Set)
			{
				Set set =(Set)object;
				if (set.isEmpty())
				{
					return true;
				}
				return false;
			}
			else
			{
				return false;
			}
		}
		catch (Exception e)
		{
			System.out.println("Execption in the method isNullOrEmpty @ /final/admin/EgTrackerA.jsp :"+e);
		}
		return false;
	}

	public boolean isNull(Object object)
	{
		if(object == null)
		{
			return true;
		}
		return false;
	}


	private String getTopologyString(String segmentName, String site , String phyTopology)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		EgCrawler strBean = new EgCrawler(iniFile);

		String str = null;

		if (phyTopology.equals("1"))
			str = strBean.getPhysicalTopology(segmentName);
		else
		{
			if (segmentName.equals("Independent_servers"))
			{
				str = strBean.getSiteString(site, site + "_INDEPENDENT");
			}
			else
			{
				str = strBean.getSiteString(site, segmentName);
			}
		}

		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
			newString = EgConstants.BLANK_SPACE;
		else
			newString = ap.getTopologyPriority(str, site);
		newString = sortTopoString(newString);
		return newString;
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr==null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i=0;i<topoToks.length ;i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs ="";
				String thisRhs ="";
				if(relation!=null && relation.length==2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation!=null && relation.length==1)
				{
					thisLhs = relation[0];
				}
				//System.out.println("! thisLhs:"+thisLhs);
				if (i==0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs)==-1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj!=null && finalLhs.indexOf(thisLhs)==-1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj==null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i=0;i<finalLhs.size() ;i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs!=null && !thisRhs.equals(""))
		{
			String [] toks = StringUtils.getTokens(thisRhs, ",");
			for (int i=0;i<toks.length ;i++ )
			{
				String thisStr = toks[i];
				TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
				result.add(rhsCmp);
				//System.out.println("$$$$$:"+rhsCmp.toString()+"\t"+thisLhs);
				if (!rhsCmp.toString().equals("null"))
				{
					h.put(rhsCmp.toString(), thisLhs);
				}
			}
		}
		return result;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/admin/AutoTopology/data/../../../admin/EgTrackerAJSON.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*****************************************************************************************************
*	Name		:	EgTopologyB.jsp
*	Purpose		:	To display the segment topology using Java Script & Raphael JS Library
******************************************************************************************************/


/*****************************************************************************************************
 *	Name			:	EgTrackerAJSON.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	EgDbAdapterUI egDbTracker = EgDbAdapterTypeUI.getObject();
	String dbTrackerStatus =egDbTracker.setConnection();
	if(dbTrackerStatus == null)
	{
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	else if(dbTrackerStatus != null && !dbTrackerStatus.equals("CONNECTED"))
	{
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	egDbTracker.releaseConnection(false);
	EgDbAdapterTypeUI.releaseObject(egDbTracker);
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	ErUserData UBean = null;
	String sessionID = null;
	UserRegistry registry = null;
	User _user = null;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String admin_Skin = null;
	String throughSchedule = request.getParameter("throughSchedule");
	if(throughSchedule == null) {
		throughSchedule = "";
	}
	if(throughSchedule.equalsIgnoreCase("true"))
	{
		String usr_Id_proc = request.getParameter("er_userid");
		String usr_Id = request.getParameter("eruserid");
		String userID = request.getParameter("userID");
		if(session!=null)
		{
			 UBean = (ErUserData) session.getAttribute("UBean");
			 if(throughSchedule.equalsIgnoreCase("true")) {
				 try
				 {
					if(UBean == null)
					{
						if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null"))
						{
							UBean = new ErUserData(usr_Id,false);
							usr_Id_proc = usr_Id;
						}
						else if(userID != null)
						{
							UBean = new ErUserData(userID,false);
							usr_Id_proc = userID;
						}
						else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null"))
						{
							UBean = new ErUserData(usr_Id_proc,false);
						}
						else
						{
							UBean = new ErUserData(usr_Id_proc,false);
						}

					}
				}
				catch(Throwable t)
				{
					t.printStackTrace();
				}
			}
			if(UBean != null)
			{
				registry = UserRegistry.getInstance();
				_user= registry.getUser(session.getId(),true);
				if(_user!=null)
				{
					id_u = _user.isIdDeletedWhileLoggedIn();
					if(id_u==false )
					{
						u_rs = _user.getLoginID();
						if(!User.isDefaultUser(u_rs))
						{
							u_v_till = UBean.getUserValidtill();
							l_accessed = session.getLastAccessedTime();
						}
					}
				}
				if(_user == null && usr_Id_proc!= null ) {
					try {
						_user = UBean.getUser(usr_Id_proc);
						registry.setUser(session.getId(), _user, false);
						System.out.println("Setting user object. user admin skin : " + _user.getAdminSkin());
					} catch(Exception ex) {
						System.out.println("Setting user object failed");
						ex.printStackTrace();
					}
				}
			}
		}
	}
	else
	{
		if(session!=null)
		{
			sessionID = session.getId();
			registry = UserRegistry.getInstance();
			//_user = registry.getUser(sessionID);
			_user = registry.getUser(sessionID,true);
			if(_user!=null)
			{
				id_u = _user.isIdDeletedWhileLoggedIn();
				if(id_u == false)
				{
					u_rs =  _user.getLoginID();
					if(!User.isDefaultUser(u_rs))
					{
						ErUserData er = _user.getReporterData();
						u_v_till = er.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
		}
	}

	if(session == null || _user == null)
	{
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	else if(id_u== true)
	{
		throw new Exception("<customerror>user-deleted</customerror>");
	}
	else if (u_v_till < l_accessed)
	{
		throw new Exception("<customerror>user-timedout</customerror>");
	}
	else
	{
		if(request.getQueryString()!=null)
		{
			String Module_Name=request.getParameter("moduleName");
			if(Module_Name!=null && Module_Name.equalsIgnoreCase("ADMIN"))
			{
				String strQueryURI = request.getRequestURI();
				String strQueryString = request.getQueryString();
				if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
					(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1))
				{
					session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
				}
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("MONITOR"))
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("REPORTER"))
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("CONFIGURATION"))
			{
				session.setAttribute("Page_IdentifierC",request.getRequestURI()+"?"+request.getQueryString());
			}
			else
			{
				String strQueryURI = request.getRequestURI();
				String strQueryString = request.getQueryString();
				if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
					(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1))
				{
					session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
				}
			}
		}
		else
		{
			String strQueryURI = request.getRequestURI();
			String strQueryString = request.getQueryString();
			if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
				(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1))
			{
				session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
			}
		}
	}
	if (_user!=null)
	{
		String trackerUserLang = _user.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
		_user.setUserLanguageAndSkins();
		admin_Skin = _user.getAdminSkin();
	}
	String script_src = "script_item_"+trackerLanguage+".js";
	EgMappingInfo _mapping = new EgMappingInfo(trackerLanguage);



try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	String ua = request.getHeader( "User-Agent" );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );

	String segmentName = request.getParameter("segment");
	String zoomLevel = request.getParameter("zoom");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");
	String color = "A0A0A0";
	String dark = "150517";

	if(zoomLevel == null)
	{
		zoomLevel = "100";
	}
	boolean isFull = false;
	if(view!=null && view.equals("full"))
		isFull = true;

	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	if(site == null)
		site = "egurkha.physical.topology";

	String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/js_topology.ini";
	IniFile jsTopoIniObj  = EgConfigFilesSync.getInstance(iniFileName);
	String subjectName = segmentName;
	if(segmentName!=null && segmentName.equals("Independent_servers"))
	{
		subjectName = site+ ":"+segmentName;
	}
	String[] allLines = jsTopoIniObj.getLinesUnderSubject(subjectName);
	String iniZoom = jsTopoIniObj.getValue(subjectName,"zoom");
	if(iniZoom != null && iniZoom.length() > 0 )
	{
		zoomLevel = iniZoom;
	}
	EgConfigFilesSync.releaseInstance(jsTopoIniObj);

	boolean isPosition = false;
	StringBuffer positionBuffer = new StringBuffer();
	if(allLines!=null)
	{
		List positionList = Arrays.asList(allLines);
		positionBuffer.append(positionList.toString().substring(1,positionList.toString().indexOf("]")));
		isPosition = true;
	}

	if(defaultPos !=null && defaultPos.equals("true"))
		isPosition = false;


      out.write("<html>\n<head>\n\n<title>");
      out.print(segmentName);
      out.write("</title>\n<script src=\"/final/scripts/map.js\" type=\"text/javascript\" charset=\"utf-8\"></script>\n<script src=\"/final/scripts/raphael.js\" type=\"text/javascript\" charset=\"utf-8\"></script>\n<script src=\"/final/scripts/raphael.zoom.js\" type=\"text/javascript\" charset=\"utf-8\"></script>\n<!-- <link rel=\"stylesheet\" type=\"text/css\" href=\"../../admin/extjs/resources/css/ext-all.css\" />\n<script type=\"text/javascript\" src=\"../../admin/extjs/ext-all.js\"></script> -->\n\n<link rel=\"stylesheet\" type=\"text/css\" href=\"../../eg_styles/adminstyle_");
      out.print(admin_Skin);
      out.write("_singlebyte.css\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"../../eg_styles/adminstyle_");
      out.print(admin_Skin);
      out.write(".css\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"../../eg_styles/eg_adminstyle.css\" />\n<script type=\"text/javascript\">\n\nfunction bringToFront(obj)\n{\n\tif (!document.getElementsByTagName)\n\t\treturn;\n\tvar divs = getAbsoluteDivs();  \n\tvar max_index = 0;  \n\tvar cur_index;  \n\tfor (i = 0; i < divs.length; i++)\n\t{\n\t\tvar item = divs[i];\n\t\tif (item == obj || item.style.zIndex == '')\n\t\t\tcontinue;\n\t\tcur_index = parseInt(item.style.zIndex);\n\t\tif (max_index < cur_index)\n\t\t{\n\t\t\tmax_index = cur_index;\n\t\t}\n\t}\n\t\tobj.style.zIndex = max_index + 1;\n}\n\nfunction getAbsoluteDivs()  \n{\n\tvar arr = new Array();\n\tvar all_divs = document.body.getElementsByTagName(\"DIV\");\n\tvar j = 0;\n\tfor (i = 0; i < all_divs.length; i++)\n\t\tif (all_divs.item(i).style.position=='absolute')\n\t\t{\n\t\t\tarr[j] = all_divs.item(i);\n\t\t\tj++;\n\t}\n\treturn arr;\n}\n\nfunction hideLoadImage ()\n{\n\tvar loading_image = parent.document.getElementById(\"loading_image\");\n\tif (loading_image != null)\n\t{\n\t\tloading_image.style.visibility = \"hidden\";\n\t\tloading_image.style.display = \"none\";\n");
      out.write("\t}\n}\n\nfunction getXMLObject()  //XML OBJECT\n{\n\tvar xmlHttp = false;\n\ttry \n\t{\n\t\txmlHttp = new ActiveXObject(\"Msxml2.XMLHTTP\");\n\t}\n\tcatch (e) \n\t{\n\t\ttry \n\t\t{\n\t\t\txmlHttp = new ActiveXObject(\"Microsoft.XMLHTTP\");\n\t\t}\n\t\tcatch (e2) \n\t\t{\n\t\t\txmlHttp = false;\n\t\t}\n\t}\n\tif (!xmlHttp && typeof XMLHttpRequest != 'undefined') \n\t{\n\t\txmlHttp = new XMLHttpRequest();\n\t}\n\treturn xmlHttp;\n}\n\nvar xmlhttp;\nfunction savePositions(str)\n{\n\tvar segmentname ='");
      out.print(segmentName);
      out.write("';\n\tif(segmentname == 'Independent_servers')\n\t{\n\t\tvar siteName = '");
      out.print(site);
      out.write("';\n\t\tsegmentname = siteName+\":\"+segmentname;\n\t}\n\tvar url = \"/final/servlet/com.eg.SegmentPositionServlet\";\n\tvar zoomHidden = document.getElementById(\"zoom\").value;\n\tvar params;\n\tif(str == 'save')\n\t{\n\t\tvar keys = compPosition.listKeys();\n\t\tparams =\"action=\"+str+\"&segment=\"+segmentname+\"&total=\"+keys.length+\"&zoom=\"+zoomHidden;\n\t\tfor(var k=0;k<keys.length;k++)\n\t\t{\n\t\t\tvar key = keys[k];\n\t\t\tvar val = compPosition.get(key);\n\t\t\tparams = params+\"&key\"+k+\"=\"+key+\"&val\"+k+\"=\"+val;\n\t\t}\n\t}\n\telse if (str == 'zoom')\n\t{\n\t\tparams = \"action=\"+str+\"&segment=\"+segmentname+\"&zoom=\"+zoomHidden;\n\t}\n\telse if(str == 'delete')\n\t{\n\t\tparams = \"action=\"+str+\"&segment=\"+segmentname;\n\t}\n\n\txmlhttp = new getXMLObject();\n\tif(xmlhttp)\n\t{\n\t\txmlhttp.open(\"POST\",url,true);\n\t\txmlhttp.onreadystatechange  = function()\n\t\t{\n\t\t\tif (xmlhttp.readyState == 4) \n\t\t\t{\n\t\t\t\tif(xmlhttp.status == 200) \n\t\t\t\t{\n\t\t\t\t\tif(str == 'save')\n\t\t\t\t\t{\n\t\t\t\t\t\tshowDivs('positionDiv');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse \n\t\t\t\t{\n\t\t\t\t\talert(\"Error occured. Please try again ....\");\n\t\t\t\t}\n\t\t\t}\n\t\t}\n");
      out.write("\t\txmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');\n\t\txmlhttp.send(params);\n\t}\n}\n\nfunction resetPositions()\n{\n\tvar segmentname ='");
      out.print(segmentName);
      out.write("';\n\tvar site ='");
      out.print(site);
      out.write("';\n\tvar phyTopo = '");
      out.print(phyTopology);
      out.write("';\n\tvar zoom = document.getElementById('zoom').value;\n\tvar isfull = '");
      out.print(isFull);
      out.write("';\n\tvar myUrl = \"EgTopologyB.jsp?segment=\"+encodeURIComponent(segmentname)+\"&default=true&zoom=\"+zoom+\"&site=\"+encodeURIComponent(site)+\"&physical_topology=\"+phyTopo;\n\tif(isfull == 'true')\n\t\tmyUrl = myUrl + \"&view=full\";\n\t//window.location.href = myUrl;\n\tsetTimeout(function(){\n\t\twindow.location = myUrl;\n\t}, 0);\n}\n\n\nfunction hideDivs(divId)\n{\n\tvar show_div = document.getElementById(divId);\n\tif(show_div!=null)\n\t{\n\t\tshow_div.style.display=\"none\";\n\t}\n}\n\nfunction showDivs(divId)\n{\n\tvar show_div = document.getElementById(divId);\n\tif(show_div!=null)\n\t{\n\t\tshow_div.style.display = 'block';\n\t\tshow_div.style.position = 'absolute';\n\t\tbringToFront(show_div);\n\t}\n}\n\nfunction openBigDiv()\n{\n\tvar mySegment = '");
      out.print(segmentName);
      out.write("';\n\tvar site ='");
      out.print(site);
      out.write("';\n\tvar phyTopo = '");
      out.print(phyTopology);
      out.write("';\n\tvar myUrl = \"EgTopologyB.jsp?segment=\"+encodeURIComponent(mySegment)+\"&view=full&site=\"+encodeURIComponent(site)+\"&physical_topology=\"+phyTopo;\n\tnewwindow=window.open(myUrl,'Topology','width='+screen.width+',height='+screen.height+', status=yes,scrollbars=no,resizable=yes');\n\tif (window.focus) {newwindow.focus()}\n\t\treturn false;\n}\n\n</script>\n<egui:skin ui=\"admin\"/>\n</head>\n");

	String finalTopoStr = getTopologyString(segmentName , site , phyTopology);
	String conPath = request.getContextPath();
	String contextPath = request.getContextPath()+"/admin/eg_images/";

	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs =	iniUI.getValue("TOPOLOGY_OPTIONS","Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS","Column_space");
	iniUI =  null;
	int rowspace = 50;
	int colspace = 50;
	try
	{
		if(rs!=null) rowspace = Integer.parseInt(rs);
	}
	catch(Exception e){
	}

	try
	{
		if(cs!=null) colspace = Integer.parseInt(cs);
	}
	catch(Exception e){
	}
	//Get row & column spacing from eg_ui.ini .... (End)

	EgNewTopology egNewTopo= new EgNewTopology(finalTopoStr,rowspace,colspace);
	ArrayList postionArrList = egNewTopo.getOutputValues();

	int divHeight = egNewTopo.getHeight();
	int divWidth  = egNewTopo.getWidth();

	StringBuffer outPutBuffer = new StringBuffer();
	if(postionArrList!=null)
	{
		outPutBuffer.append(postionArrList.toString().substring(1,postionArrList.toString().indexOf("]")));
	}


      out.write("<body leftmargin=\"0\" topmargin=\"0\" marginwidth=\"0\" marginheight=\"0\" class=\"topoBg\">\n<form name=\"topologyForm\" id=\"topologyForm\" style=\"margin:0px;padding:0px;\">\n<!-- Zoom DIV  -->\n<div id=\"ZoomDiv\" name=\"ZoomDiv\" style=\"visibility:visible;display:block;left:20px;top:6px;width:200px;border:0px solid #ff0000; position:absolute;z-Index:100;\">\n\n\t<table border=\"0\" bordercolor=\"green\" cellpadding=\"0\" cellspacing=\"0\" >\n\t\t<tr>\n\t\t\t<td class=\"attach_left_curve\"><img src=\"/final/monitor/eg_images/spacer.gif\" width=\"4px\" border=\"0px\"></td>\n\t\t\t<td height=\"24px\" class=\"attach_bg\" align=\"left\" valign=\"middle\">\n\t\t\t\t<table  border=\"0\" cellspacing=\"0\" cellpadding=\"3\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td><a href=\"javascript:void(0);\" class=\"topo_zoomOutImg\" title=\"Zoom out\" onclick=\"javascript:setZoomLevel('1');\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"21\" height=\"19\" border=\"0\"></a></td>\n\n\t\t\t\t\t\t<td valign=\"top\" style=\"padding:0px;margin:0px\"><input type=\"text\" name=\"zoomTxt\" id=\"zoomTxt\" value=\"100%\" size=\"5\" class=\"linesquare\" readonly=\"readonly\" disabled=\"disabled\" style=\"margin-top:3px\"></td>\n");
      out.write("\n\t\t\t\t\t\t<td><a href=\"javascript:void(0);\" class=\"topo_zoomInImg\" title=\"Zoom in\" onclick=\"javascript:setZoomLevel('-1');\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"21\" height=\"19\" border=\"0\"></a></td>\n\n\t\t\t\t\t\t<td class=\"topo_divide\" ><img src=\"/final/admin/eg_images/spacer.gif\" width=\"2\" height=\"19\" border=\"0\"></td>\n");

	if(isFull)
	{

      out.write("<td><a href=\"javascript:void(0);\" class=\"topo_newwindowImg\" name='maxImage' id='maxImage' onclick=\"javascript:self.close();\" title=\"Close\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"21\" height=\"19\" border=\"0\"></a></td>\n");

	}
	else
	{

      out.write("<td><a href=\"javascript:void(0);\" class=\"topo_newwindowImg\" name='maxImage' id='maxImage' onclick=\"javascript:openBigDiv();\" title=\"New window\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"21\" height=\"19\" border=\"0\"></a></td>\n");

	}

      out.write("<td><a href=\"javascript:void(0);\" class=\"topo_saveImg\" onclick=\"javascript:savePositions('save');\" title=\"Save position\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"21\" height=\"19\" border=\"0\"></a></td>\n\n\t\t\t\t\t\t<td><a href=\"javascript:void(0);\" class=\"topo_resetImg\" onclick=\"javascript:resetPositions();\" title=\"Reset position\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"21\" height=\"19\" border=\"0\"></a></td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t\t<td class=\"attach_right_curve\"><img src=\"/final/monitor/eg_images/spacer.gif\" width=\"4px\"  border=\"0px\"></td>\n\t\t</tr>\n\t</table>\n</div>\n\n");

	if(isFull)
	{
		String full_style = "width:100%;height:100%;border:0px solid #ff0000;position:absolute;top:0px;left:0px;";
		if(isMSIE)
		{
			full_style = "width:100%;height:100%;border:0px solid #ff0000;position:absolute;top:0px;left:0px;";
		}

      out.write("<div id=\"container\" class=\"div_scroll\" style=\"");
      out.print(full_style);
      out.write('"');
      out.write('>');
      out.write('\n');

	}
	else
	{

      out.write("<div id=\"container\" class=\"div_scroll\" style=\"width:100%;height:100%;border:0px solid blue\">\n");

	}

      out.write("<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" >\n\t\t<tr>\n\t\t\t<td >\n\t\t\t\t<div  id=\"paper\"  name=\"paper\" style=\"width:100%;height:100%;z-index:10;border:0px solid green\"></div>\n\t\t\t</td>\n\t\t</tr>\n\t</table>\n\t</div>\n\n\t<div id=\"positionDiv\" name = \"positionDiv\" style=\"display:none;left:50px;top:50px;width:193px;height:80px;border:0px solid #ff0000; position:absolute;z-Index:150\">\n\n\t<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" height=\"100%\">\n\t\t<tr>\n\t\t\t<td class=\"alert_topleft\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"7\" height=\"7\"></td>\n\t\t\t<td class=\"alert_topbg\" width=\"100%\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"1\" height=\"7\"></td>\n\t\t\t<td class=\"alert_topright\" ><img src=\"/final/admin/eg_images/spacer.gif\" width=\"13\" height=\"7\"></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"alert_leftbg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"7\" height=\"1\"></td>\n\t\t\t<td class=\"eg_morelight\" height=\"100%\">\n\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"100%\"> \n");
      out.write("\t\t\t\t\t\t\t<table cellpadding=\"2\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td  align=\"center\" class=\"eg_75bold\"></td>\n\t\t\t\t\t\t\t\t\t<td align=\"right\">\n\t\t\t\t\t\t\t\t\t\t<div style=\"display:block;text-align:right\"><a id=\"closeLink\" class=\"mouse\" onclick=\"hideDivs('positionDiv');\"><img src=\"/final/admin/eg_images/winclose.gif\" border=\"1\" class=\"mouse\" title=\"close\"></a>\n\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"center\" nowrap width=\"160\" valign=\"top\"  style=\"padding:4px\"><egui:intnl text='admin.zone.Component positions are saved successfully'/><br>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td  align=\"center\" nowrap width=\"160\" valign=\"top\"  style=\"padding:4px\"><input type=\"button\" class=\"eg_lightbutton \" name=\"okButton\" id=\"okButton\" value=\"OK\" onclick=\"javascript:hideDivs('positionDiv');\"style=\"padding-left:4px;padding-right:4px\">\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t\t<td class=\"alert_rightbg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"13\" height=\"1\"></td>\n");
      out.write("\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"alert_bottomleft\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"7\" height=\"7\"></td>\n\t\t\t<td class=\"alert_bottombg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"1\" height=\"14\"></td>\n\t\t\t<td class=\"alert_bottomright\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"13\" height=\"14\"></td>\n\t\t</tr>\n\t</table>\n\t</div>\n\n<script type=\"text/javascript\">\n\nvar zom = parseInt('");
      out.print(zoomLevel);
      out.write("')/100;\nvar width = 916;\nvar height = 520;\n\nif('");
      out.print(isFull);
      out.write("' == 'true')\n{\n\twidth = screen.width;\n\theight = screen.height;\n}\n\nvar gifWidth = 50*zom;\nvar gifHeight = 50*zom;\n\nvar userWidth = 72*zom;\nvar userHeight = 72*zom;\n\n\nvar el;\nvar componentStateMap = new Map; \nvar compPosition = new Map;\nvar mainComponent = new Array();\nvar connectionArr = new Array();\nvar arr = new Array();\nvar allCompNames = new Array();\n\nvar compIndexMap = new Map();\nvar topostring ='");
      out.print(finalTopoStr);
      out.write("';\nvar positionString ='");
      out.print(outPutBuffer);
      out.write("';\nvar iniMaxW = 0;\nvar iniMaxH = 0;\n\nr = Raphael(\"paper\", width, height);\nr.initZoom();\n\n// Zoom supports from 10% to 150%\nfunction setZoomLevel(val)\n{\n\tvar zoomTxt = document.getElementById(\"zoomTxt\").value;\n\tvar zoomHidden = document.getElementById(\"zoom\").value;\n\n\tif(val == '1') //\tZoomIn\n\t{\n\t\tvar zInt = parseInt(zoomHidden);\n\t\tif(zInt >10)\n\t\t{\n\t\t\tzInt = zInt - 10;\n\t\t\tzInt = zInt.toFixed();\n\t\t\tdocument.getElementById(\"zoom\").value = zInt;\n\t\t\tdocument.getElementById(\"zoomTxt\").value = zInt +\"%\";\n\t\t\tsetZoom(zInt / 100);\n\t\t}\n\t}\n\telse if(val == '-1') //ZoomOut\n\t{\n\t\tvar zInt = parseInt(zoomHidden);\n\t\tif(zInt < 150)\n\t\t{\n\t\t\tzInt = zInt + 10;\n\t\t\tzInt = zInt.toFixed();\n\t\t\tdocument.getElementById(\"zoom\").value = zInt;\n\t\t\tdocument.getElementById(\"zoomTxt\").value = zInt +\"%\";\n\t\t\tsetZoom(zInt / 100);\n\t\t}\n\t}\n\tsavePositions(\"zoom\");\n}\n\nfunction setZoom(zoom)\n{\n\tvar holderDiv = document.getElementById(\"paper\");\n\tvar holderH = document.getElementById(\"paper\").clientHeight;\n\tvar holderW = document.getElementById(\"paper\").clientWidth;\n");
      out.write("\tzom = zoom;\n\tvar regW = holderW>iniMaxW?holderW:iniMaxW;\n\tvar regH = holderH>iniMaxH?holderH:iniMaxH;\n\tif(regW < 916) regW = 916;\n\tif(regH < 512) regH = 512;\n\tholderDiv.style.width = regW;\n\tholderDiv.style.height = regH;\n\tif(zoom <=1)\n\t{\n\t\tr.setSize(regW, regH);\n\t}\n\telse\n\t{\n\t\tr.setSize(1.2*regW*zoom,regH*zoom);\n\t}\n\tr.setZoom(zoom);\n\tdocument.getElementById(\"zoomTxt\").value = (zom * 100).toFixed() +\"%\";\n\tif(parent.document.getElementById(\"zoomValue\")!=null)\n\t\tparent.document.getElementById(\"zoomValue\").value= (zom * 100).toFixed();\n}\n\nsetZoom(zom);\n\nfunction resizePaperDiv(w, h)\n{\n\tvar intW = w;\n\tvar intH = h;\n\tvar resize = \"false\";\n\n\tvar holderDiv = document.getElementById(\"paper\");\n\tvar holderH = document.getElementById(\"paper\").clientHeight;\n\tvar holderW = document.getElementById(\"paper\").clientWidth;\n\t\n\tif(intW > 916)\n\t{\n\t\tresize = \"true\";\n\t}\n\telse\n\t{\n\t\tintW = 916;\n\t}\n\n\tif(intH > 520)\n\t{\n\t\tresize =\"true\";\n\t}\n\telse\n\t{\n\t\tintH = 520;\n\t}\n\tif(resize == \"true\")\n\t{\n\t\tr.setSize(intW*zom,intH*zom);\n\t}\n}\n\nfunction getMapDetails(posString)\n");
      out.write("{\n\tvar changeHeight = '");
      out.print(divHeight);
      out.write("';\n\tvar changeWidth = '");
      out.print(divWidth);
      out.write("';\n\n\tvar intW = parseInt(changeWidth);\n\tvar intH = parseInt(changeHeight);\n\tresizePaperDiv(intW, intH);\n\n\t// Get Positions from ini File (Begin) , if it is already saved.\n\tvar position = '");
      out.print(isPosition);
      out.write("';\n\tvar iniPositionArr = new Array();\n\tvar iniMap = new Map();\n\tif(position == 'true')\n\t{\n\t\tvar allvec = '");
      out.print(positionBuffer.toString());
      out.write("';\n\t\tiniPositionArr = allvec.split(\", \");\n\t}\n\n\tfor(var i=0; i<iniPositionArr.length;i++)\n\t{\n\t\tvar arrElement =  iniPositionArr[i];\n\t\tvar iniMapKey =  arrElement.substring(0,arrElement.indexOf(\"=\"));\n\t\tvar iniMapValue = arrElement.substring(arrElement.indexOf(\"=\")+1);\n\t\tiniMap.put(iniMapKey,iniMapValue);\n\t}\n\t// Get Positions from ini File (End)  \n\t\n\tvar tokens = posString.split(\", \");\n\tvar compInd = 0;\n\tvar resize = \"false\";\n\tiniMaxW = intW;\n\tiniMaxH = intH;\n\n\tfor(var i=0; i<tokens.length;i++)\n\t{\n\t\tvar tokvalue = tokens[i];\n\t\tvar key = tokvalue.substring(0,tokvalue.indexOf(\"=\"));\n\t\tvar rhs = tokvalue.substring(tokvalue.indexOf(\"=\")+1);\n\n\t\tif(key.indexOf(\":\")==0)\n\t\t{\n\t\t\tkey = 'egurkha.physical.topology';\n\t\t}\n\n\t\tif(iniMap.contains(key)) // Load Position from INI File......\n\t\t{\n\t\t\tvar iniXY  = iniMap.get(key);\n\t\t\tvar iniX = parseInt(iniXY.substring(0,iniXY.indexOf(\"#\")));\n\t\t\tvar iniY = parseInt(iniXY.substring(iniXY.indexOf(\"#\")+1));\n\n\t\t\tif(iniX >= iniMaxW)\n\t\t\t{\n\t\t\t\tresize = \"true\";\n\t\t\t\tiniMaxW = iniX + 200;\n\t\t\t}\n");
      out.write("\n\t\t\tif(iniY >=iniMaxH)\n\t\t\t{\n\t\t\t\tresize = \"true\";\n\t\t\t\tiniMaxH = iniY + 100;\n\t\t\t}\n\t\t\t\n\t\t\tif(key == 'egurkha.physical.topology') // User Image\n\t\t\t{\n\t\t\t\tarr.push(r.image('");
      out.print(contextPath);
      out.write("'+'imguser_72.png', iniX*zom, iniY*zom , userWidth , userHeight).attr({title :\"User\"}));\n\t\t\t\tcompPosition.put(key,iniX*zom+\"#\"+iniY*zom);\n\t\t\t}\n\t\t\telse\t// Other components....\n\t\t\t{\n\t\t\t\tvar comptype = key.substring(0,key.indexOf(\":\")); \n\t\t\t\tvar comptip = key.substring(key.indexOf(\":\")+1);\n\t\t\t\tif(comptip.indexOf(\":NULL\")>0)\n\t\t\t\t\tcomptip = comptip.substring(0,comptip.indexOf(\":NULL\"));\n\t\t\t\tvar compImage=\"\";\n\t\t\t\tif(comptype!=null && (comptype.match(\"_ex$\")==\"_ex\" || (comptype.indexOf(\"Agg_\")==0)))\n\t\t\t\t{\n\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath);
      out.write("'+comptype+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({title : comptip});\n\t\t\t\t}\n\t\t\t\telse\n\t\t\t\t{\n\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath);
      out.write("'+comptype+'.gif', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({title : comptip});\n\t\t\t\t}\n\t\t\t\tarr.push(compImage);\n\t\t\t\tcompPosition.put(key, iniX*zom+\"#\"+iniY*zom);\n\t\t\t}\n\t\t}\n\t\telse\n\t\t{\n\t\t\tif(key == 'egurkha.physical.topology') //User\n\t\t\t{\n\t\t\t\tvar xy = rhs;\n\t\t\t\tvar xPos = parseInt(xy.substring(0,xy.indexOf(\"#\")));\n\t\t\t\tvar yPos = parseInt(xy.substring(xy.indexOf(\"#\")+1));\n\t\t\t\tarr.push(r.image('");
      out.print(contextPath);
      out.write("'+'imguser_72.png', xPos*zom, yPos*zom , userWidth , userHeight).attr({title :\"User\"}));\n\t\t\t\tcompPosition.put(key, xPos*zom+\"#\"+yPos*zom);\n\t\t\t}\n\t\t\telse\n\t\t\t{\n\t\t\t\tvar xy = rhs;\n\t\t\t\tvar xPos = parseInt(xy.substring(0,xy.indexOf(\"#\")));\n\t\t\t\tvar ystate = xy.substring(xy.indexOf(\"#\")+1);\n\t\t\t\tvar yPos = parseInt(ystate.substring(0,ystate.indexOf(\"#\")));\n\t\t\t\tvar state = xy.substring(xy.lastIndexOf(\"#\")+1);\n\n\t\t\t\tvar comptype = key.substring(0,key.indexOf(\":\")); \n\t\t\t\tvar comptip = key.substring(key.indexOf(\":\")+1);\n\t\t\t\tif(comptip.indexOf(\":NULL\")>0)\n\t\t\t\t\tcomptip = comptip.substring(0,comptip.indexOf(\":NULL\"));\n\t\t\t\tvar compImage=\"\";\n\t\t\t\tif(comptype!=null && (comptype.match(\"_ex$\")==\"_ex\" || comptype.indexOf(\"Agg_\")==0))\n\t\t\t\t{\n\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath);
      out.write("'+ comptype+'.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({title : comptip});\n\t\t\t\t}\n\t\t\t\telse\n\t\t\t\t{\n\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath);
      out.write("'+ comptype+'.gif', xPos*zom, yPos*zom  , gifWidth , gifHeight).attr({title : comptip});\n\t\t\t\t}\n\t\t\t\tarr.push(compImage);\n\t\t\t\tcompPosition.put(key, xPos*zom+\"#\"+yPos*zom);\n\t\t\t\tcomponentStateMap.put(key,state);\n\t\t\t}\n\t\t}\n\t\tcompIndexMap.put(key,compInd);\n\t\tcompInd = compInd + 1;\n\t}\n\n\t/*for(var i = 0; i++ < compPosition.size; compPosition.next())\n\t{\n\t\talert(compPosition.hash(compPosition.key()) + ' >> ' + compPosition.value() +\"    \"+i);\n\t}*/\n\n\tif(resize == \"true\")\n\t{\n\t\tresizePaperDiv(iniMaxW, iniMaxH);\n\t}\n\t// Creating connections between components.......\n\tcreateConnections(topostring);\n}\n\nfunction createConnections(topostr)\n{\n\tvar tokens = topostr.split(\"|\");\n\tfor(var i = 0;i<tokens.length;i++)\n\t{\n\t\tvar tokvalue = tokens[i];\n\t\tvar lhs = tokvalue.substring(0,tokvalue.indexOf(\"=\"));\n\t\tvar rhs = tokvalue.substring(tokvalue.indexOf(\"=\")+1);\n\n\t\tvar key = lhs;\n\n\t\tif(i==0)\n\t\t{\n\t\t\tkey = \"egurkha.physical.topology\";\n\t\t}\n\t\tvar lhsInd = compIndexMap.get(key);\n\t\tif(rhs != 'null')\n\t\t{\n\t\t\tvar rhsArr = rhs.split(\",\");\n\t\t\tfor(var j=0;j<rhsArr.length;j++)\n");
      out.write("\t\t\t{\n\t\t\t\tvar element = rhsArr[j];\n\t\t\t\telement = element.substring(0,element.lastIndexOf(\":\"));\n\t\t\t\tvar LorN = element.substring(element.lastIndexOf(\":\")+1);\n\t\t\t\telement = element.substring(0,element.lastIndexOf(\":\"));\n\t\t\t\tvar elementInd = compIndexMap.get(element);\n\t\t\t\tconnectionArr.push(lhsInd+\":\"+LorN+\">\"+elementInd);\n\t\t\t}\n\t\t}\n\t}\n}\n\nfunction newDrawMethod()\n{\n\treturn this.arr;\n}\n\nwindow.onload = mainFunction;\n\nfunction mainFunction ()\n{\n\tgetMapDetails(positionString);\n\tvar key;\n\tvar thisIndex;\n\tvar statesrc;\n\tvar dragger = function () {\n\t\t\t\t\t\t\t\t//alert(this.attr(\"src\")+\"   \"+this.attr(\"title\"));\n\t\t\t\t\t\t\t\tvar src = this.attr(\"src\");\n\t\t\t\t\t\t\t\tvar title = this.attr(\"title\");\n\t\t\t\t\t\t\t\tif(title.indexOf(\":\") < 0)\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\ttitle = title+\":NULL\";\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif (src.indexOf(\".gif\")>0)\n\t\t\t\t\t\t\t\t\tsrc = src.substring(src.lastIndexOf(\"/\")+1,src.indexOf(\".gif\"));\n\t\t\t\t\t\t\t\telse if (src.indexOf(\".png\")>0)\n\t\t\t\t\t\t\t\t\tsrc = src.substring(src.lastIndexOf(\"/\")+1,src.indexOf(\".png\"));\n\n\t\t\t\t\t\t\t\tif(src == 'imguser_72')\n\t\t\t\t\t\t\t\t\tkey =\"egurkha.physical.topology\";\n");
      out.write("\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tkey = src+\":\"+title;\n\t\t\t\t\t\t\t\tthisIndex = compIndexMap.get(key);\n\n\t\t\t\t\t\t\t\tif(this.type == \"image\")\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\tthis.ox = this.attr(\"x\");\n\t\t\t\t\t\t\t\t\tthis.oy = this.attr(\"y\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(thisIndex >0)\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\tstatesrc = stateCircle[thisIndex].attr('src');\n\t\t\t\t\t\t\t\t\tstateCircle[thisIndex].remove();\n\t\t\t\t\t\t\t\t\tcompNames[thisIndex].remove();\n\t\t\t\t\t\t\t\t}\n\t},\n\tmove = function (dx, dy) {\n\t\t\t\t\t\t\t\tif(this.type == \"image\")\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\tvar att =  {x: this.ox + dx, y: this.oy + dy};\n\t\t\t\t\t\t\t\t\tthis.attr(att);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tfor (var i = connections.length; i--;) {\n\t\t\t\t\t\t\t\t\tr.connection('#");
      out.print(color);
      out.write("',connections[i]);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tr.safari();\n\t},\n\tup = function () {\n\t\t\t\t\t\tcompPosition.put(key,this.attr(\"x\")+\"#\"+this.attr(\"y\"));\n\t\t\t\t\t\tif(key!=\"egurkha.physical.topology\")\n\t\t\t\t\t\t{\n\t\t\t\t\t\t\tstateCircle[thisIndex] = r.image(statesrc,this.attr(\"x\"),this.attr(\"y\"),50*zom,50*zom);\n\t\t\t\t\t\t\tstateCircle[thisIndex].toBack();\n\t\t\t\t\t\t\tvar textstr = this.attr(\"title\");\n\t\t\t\t\t\t\tif(textstr.length > 15)\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\tvar mid ;\n\t\t\t\t\t\t\t\tif(textstr.length % 2 == 0)\n\t\t\t\t\t\t\t\t\tmid = textstr.length / 2;\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tmid = (textstr.length + 1) / 2;\n\t\t\t\t\t\t\t\ttextstr = textstr.substring(0,mid)+\"\\n\"+textstr.substring(mid);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tcompNames[thisIndex] = r.text(this.attr(\"x\")+20*zom ,this.attr(\"y\") + 60*zom , textstr).attr({\"font-size\" : 11*zom});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbeatFunction(shapes, compNames , thisIndex,connections);\n\t},\n\tconnections = [],\n\tshapes = newDrawMethod(),\n\tstateCircle = drawStateCircles(),\n\tcompNames = drawCompNames();\n\tfor (var i = 0, ii = shapes.length; i < ii; i++) \n\t{\n\t\tshapes[i].attr({cursor: \"move\"});\n");
      out.write("\t\tshapes[i].drag(move, dragger, up);\n\t\tbeatFunction(shapes, compNames, i, connections);\n\t}\n\n\tfor(var k=0;k<connectionArr.length;k++)\n\t{\n\t\tvar link = connectionArr[k];\n\t\tvar lorn = link.substring(link.indexOf(\":\")+1, link.indexOf(\">\"));\n\t\tvar ind1 = link.substring(0,link.indexOf(\":\"));\n\t\tvar ind2 = link.substring(link.indexOf(\">\")+1);\n\t\tconnections.push(r.connection('#");
      out.print(color);
      out.write("',shapes[ind1], shapes[ind2], \"#");
      out.print(color);
      out.write("\",\"#");
      out.print(color);
      out.write("|1\",lorn)); \n\t}\n\thideLoadImage();\n\t//if('");
      out.print(isFull);
      out.write("' == 'true')\n\t//{\n\t\tsetZoom(zom);\n\t//}\n}\n\n\nfunction beatFunction(shapesObj,compNamesObj, index, connectionObj)\n{\n\tshapesObj[index].mouseover (function (event) {\n\t\tfor(var k=0;k<connectionArr.length;k++)\n\t\t{\n\t\t\tvar link = connectionArr[k];\n\t\t\tvar lorn = link.substring(link.indexOf(\":\")+1, link.indexOf(\">\"));\n\t\t\tvar ind1 = link.substring(0,link.indexOf(\":\"));\n\t\t\tvar ind2 = link.substring(link.indexOf(\">\")+1);\n\n\t\t\tif(ind1 == index || ind2 == index)\n\t\t\t{\n\t\t\t\tif(connectionObj[k]!=null)\n\t\t\t\t{\n\t\t\t\t\tconnectionObj[k].line.toFront();\n\t\t\t\t\tconnectionObj[k].tri.toFront();\n\t\t\t\t\tconnectionObj[k].line.animate({'stroke' : '#");
      out.print(dark);
      out.write("', 'stroke-width' : 2*zom},500);\n\t\t\t\t\tconnectionObj[k].tri.animate({'stroke' : '#");
      out.print(dark);
      out.write("','fill' : '#");
      out.print(dark);
      out.write("', 'stroke-width' : 2*zom},500);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\tshapesObj[index].mouseout (function (event){\n\t\tfor(var k=0;k<connectionArr.length;k++)\n\t\t{\n\t\t\tvar link = connectionArr[k];\n\t\t\tvar lorn = link.substring(link.indexOf(\":\")+1, link.indexOf(\">\"));\n\t\t\tvar ind1 = link.substring(0,link.indexOf(\":\"));\n\t\t\tvar ind2 = link.substring(link.indexOf(\">\")+1);\n\n\t\t\tif(ind1 == index || ind2 == index)\n\t\t\t{\n\t\t\t\tif(connectionObj[k]!=null)\n\t\t\t\t{\n\t\t\t\t\tconnectionObj[k].line.toBack();\n\t\t\t\t\tconnectionObj[k].tri.toBack();\n\t\t\t\t\tconnectionObj[k].line.animate({'stroke' : '#");
      out.print(color);
      out.write("', 'stroke-width' : 1*zom},500);\n\t\t\t\t\tconnectionObj[k].tri.animate({'stroke' : '#");
      out.print(color);
      out.write("','fill' : '#");
      out.print(color);
      out.write("', 'stroke-width' : 1*zom},500);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n}\n\nfunction drawCompNames ()\n{\n\treturn allCompNames;\n}\n\nfunction drawStateCircles()\n{\n\tvar cirArr = new Array();\n\tvar keys = compPosition.listKeys();\n\tfor(var k=0;k<keys.length;k++)\n\t{\n\t\tif(k==0)\n\t\t{\n\t\t\tcirArr.push(\"egurkha.physical.topology\");\n\t\t\tallCompNames.push(\"egurkha.physical.topology\");\n\t\t\tcontinue;\n\t\t}\n\t\tvar key = keys[k];\n\t\tvar val = compPosition.get(key);\n\t\tvar xpoint = parseInt(val.substring(0,val.indexOf(\"#\")));\n\t\tvar ypoint = parseInt(val.substring(val.indexOf(\"#\")+1));\n\n\t\tvar scir = r.image('");
      out.print(contextPath);
      out.write("'+'server_gray.gif',xpoint,ypoint,gifWidth,gifHeight);\n\t\tscir.toBack();\n\t\tcirArr.push(scir);\n\t\tvar compName = key.substring(key.indexOf(\":\")+1);\n\t\tif(compName.indexOf(\":NULL\") > 0)\n\t\t\tcompName = compName.substring(0,compName.indexOf(\":NULL\"));\n\t\tvar textstr = compName;\n\t\tif(compName.length > 22)\n\t\t{\n\t\t\tvar mid ;\n\t\t\tif(textstr.length % 2 == 0)\n\t\t\t\tmid = textstr.length / 2;\n\t\t\telse\n\t\t\t\tmid = (textstr.length + 1) / 2;\n\t\t\ttextstr = compName.substring(0,mid)+\"\\n\"+compName.substring(mid);\n\t\t}\n\t\tallCompNames.push(r.text(xpoint+20*zom,ypoint+60*zom,textstr).attr({\"font-size\" : 11*zom}));\n\t}\n\treturn cirArr;\n}\n\n</script>\n<input type=\"hidden\" name=\"zoom\" id=\"zoom\" value='");
      out.print(zoomLevel);
      out.write("'>\n\n</form>\n</body>\n</html>\n\n");

}
catch(Exception e)
{
	System.out.println("Exception in EgTopologyB.jsp....");
	e.printStackTrace();
}

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
