package org.apache.jsp.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.egurkha.*;
import java.util.*;
import com.eg.EgDbAdapterTypeUI;
import egurkha.EgDbAdapterUI;
import egurkha.reporter.*;
import com.egurkha.*;
import java.util.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.EgDateInfo;
import com.eg.EgMappingInfo;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import egurkha.config.EcUtils;
import java.util.*;
import com.eg.IniFile;
import com.eg.EgGroupInfo;
import com.eg.MappingNameSorter;
import com.eg.EgName;
import com.eg.EgInstallInfo;
import com.egurkha.EgConstants;
import com.egurkha.monitor.alarms.AlarmPriorities;
import com.egurkha.util.StringUtils;
import com.egurkha.ini.IniUI;
import com.egurkha.EgNewTopology;
import com.eg.TopoRhsComp;
import com.eg.EgConfigFilesSync;
import com.eg.eGComponentCategory;
import com.eg.EgTesterInfo;

public final class EgAutoTopologyMainPageExt_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	String disableF5 = "false";


	public boolean isNullOrEmpty(Object object)
	{
		try
		{
			if(object == null)
			{
				return true;
			}
			else if(object instanceof java.lang.String)
			{
				String string = (String) object;
				if (string.equals("") || string.equalsIgnoreCase("null"))
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.lang.StringBuffer)
			{
				String stringBuffer = (String)object.toString();
				if (stringBuffer.equals("") || stringBuffer.equals("null"))
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.StringTokenizer)
			{
				StringTokenizer st = (StringTokenizer) object;
				if (!st.hasMoreTokens())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.List)
			{
				List list =(List)object;
				if (list.isEmpty())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.Map)
			{
				Map map =(Map)object;
				if (map.isEmpty())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.Set)
			{
				Set set =(Set)object;
				if (set.isEmpty())
				{
					return true;
				}
				return false;
			}
			else
			{
				return false;
			}
		}
		catch (Exception e)
		{
			System.out.println("Execption in the method isNullOrEmpty @ /final/admin/EgTrackerA.jsp :"+e);
		}
		return false;
	}

	public boolean isNull(Object object)
	{
		if(object == null)
		{
			return true;
		}
		return false;
	}


	boolean isPreExists = false;


	/*
		This method returns, list of New & Unmanaged components form the given segment name
	*/
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		//ArrayList newList = new ArrayList();
		//ArrayList unmanageList = new ArrayList();

		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		/*if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);*/
		result.put("NEW" , newSet);
		result.put("UNMANAGE" , unmanageSet);
		return result;
	}

	private String getTopologyString(String segmentName, String site , String phyTopology)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		//EgCrawler strBean = new EgCrawler(iniFile);
		String str = null;
		if (phyTopology.equals("1"))
		{
			String[] lines = iniFile.getLinesUnderSubject(segmentName);
			if(lines!=null)
			{
				//str = strBean.getPhysicalTopology(segmentName ,lines);
				str = getPhysicalTopology(segmentName ,lines);
			}
		}
		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
			newString = EgConstants.BLANK_SPACE;
		else
			//newString = str; //ap.getTopologyPriority(str, site);
			newString = ap.getTopologyPriority(str, site);
		newString = sortTopoString(newString);
		return newString;
	}

	public String getPhysicalTopology(String s_segment, String[] lines)
	{
		if(lines==null)
			return "";
		StringBuffer s_pt = new StringBuffer("Web_site:egurkha.physical.topology=");
		try
		{
			String[] s_var = null;
			ArrayList valList = new ArrayList();
			Hashtable myHt = new Hashtable();
			String state = "NO";
			if (s_segment != null && (!s_segment.equals("null")))
			{
				//s_subject = s_segment;
				for(int i=0;i<lines.length;i++)
				{
					String thisLine = lines[i];
					String thisvar = thisLine.substring(0,thisLine.indexOf("="));
					String thisval = thisLine.substring(thisLine.indexOf("=")+1);
					valList.add(thisvar);
					myHt.put(thisvar,thisval);
				}
				s_var = (String []) valList.toArray (new String [valList.size ()]);
			}
			if (s_var == null || s_var.length < 1)
			{
				return "";
			}
			//setConnection();
			Vector v_com =  new Vector(); //getAllValues(s_subject, s_var, "NO");

			//Get All Values (Begin)
			for (int q = 0; q < s_var.length; q++)
			{
				String thisVar = s_var[q];
				if (thisVar.startsWith("#"))
				{
					continue;
				}
				String s_temp = (String) myHt.get(thisVar);
				if (s_temp.indexOf(",") > 0)
				{
					StringTokenizer st = new StringTokenizer(s_temp, ",");
					while (st.hasMoreTokens())
					{
						if (state.equals("YES"))
						{
							v_com.addElement(st.nextToken());
						}
						else
						{
							String ss = st.nextToken();
							v_com.addElement(ss.substring(0, ss.lastIndexOf(":")));
						}
					}
				}
				else if (!s_temp.equals("null"))
				{
					if (state.equals("YES"))
					{
						v_com.addElement(s_temp);
					}
					else
					{
						v_com.addElement(s_temp.substring(0, s_temp.lastIndexOf(":")));
					}
				}
			}
			//Get All Values (End)

			Vector v_unAssgnList=new Vector();
			StringBuffer s_fline = new StringBuffer();
			int maxCount = s_var.length;

			for (int j = 0; j < maxCount; j++)
			{
				if (s_var[j].startsWith("#"))
					continue;

				if (!v_com.contains(s_var[j]))
				{
					//s_fline.append(s_var[j] +":N:"+ getState(s_var[j], "NULL") +",");
					s_fline.append(s_var[j] +":N:"+ "GOOD" +",");
					v_unAssgnList.add(s_var[j]);
				}
			}
			if (s_fline.toString().endsWith(","))
			{
				int bufferLength = s_fline.length();
				s_fline.delete(bufferLength-1, bufferLength);
			}

			s_pt.append(s_fline.toString());

			while(v_unAssgnList.size()>0)
			{
				String s_key = (String)v_unAssgnList.get(0);
				String s_val = (String) myHt.get(s_key);
				if (s_val==null || s_val=="")			//if there cud be any issue with end component of topology node
					s_val = "null";

				s_pt.append("|" + s_key + "=");

				if(!s_val.equalsIgnoreCase("null"))
				{
					if(s_val.indexOf(",") > -1)
					{
						StringTokenizer st = new StringTokenizer(s_val,",");
						while(st.hasMoreTokens())
						{
							String s_token= st.nextToken().trim();
							String s_comp=s_token.substring(0, s_token.lastIndexOf(":"));
							s_pt.append(s_token + ":" + "GOOD");
							if (st.hasMoreTokens())
								s_pt.append(",");
							if(!v_unAssgnList.contains(s_comp)) v_unAssgnList.add(s_comp);
						}
					}
					else
					{
						String s_comp = s_val.substring(0, s_val.lastIndexOf(":"));
						s_pt.append(s_val +":"+"GOOD");
						if(!v_unAssgnList.contains(s_comp)) v_unAssgnList.add(s_comp);
					}
				}
				else
				{
					s_pt.append("null");
				}
				v_unAssgnList.removeElementAt(0);
			}
			//releaseConnection(false);
		}
		catch (Exception e)
		{
			System.out.println("Exception in getPhysicalTopology............");
			e.printStackTrace();
			//releaseConnection(true);
			return "";
		}
		return s_pt.toString();
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr==null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i=0;i<topoToks.length ;i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs ="";
				String thisRhs ="";
				if(relation!=null && relation.length==2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation!=null && relation.length==1)
				{
					thisLhs = relation[0];
				}
				//System.out.println("! thisLhs:"+thisLhs);
				if (i==0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs)==-1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj!=null && finalLhs.indexOf(thisLhs)==-1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj==null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i=0;i<finalLhs.size() ;i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs!=null && !thisRhs.equals(""))
		{
			String [] toks = StringUtils.getTokens(thisRhs, ",");
			for (int i=0;i<toks.length ;i++ )
			{
				String thisStr = toks[i];
				TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
				if(rhsCmp != null)
				{
					result.add(rhsCmp);
					//System.out.println("$$$$$:"+rhsCmp.toString()+"\t"+thisLhs+""+i);
					if (rhsCmp.toString() != null && !rhsCmp.toString().equals("null"))
					{
						h.put(rhsCmp.toString(), thisLhs);
					}
				}
			}
		}
		return result;
	}

	public Hashtable getSegmentComps(String segment)
	{
		Hashtable result = new Hashtable();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");

		String[] thisSegVar = autoTopoIniFile.getVariables(segment);
		if(thisSegVar!=null && thisSegVar.length > 0)
		{
			for(int k=0;k<thisSegVar.length;k++)
			{
				String varName = thisSegVar[k];
				String thisServerType = varName.substring(0,varName.indexOf(":"));
				String compName =  varName.substring(varName.indexOf(":")+1);

				if(result.containsKey(thisServerType))
				{
					ArrayList tmpList = (ArrayList) result.get(thisServerType);
					if(!tmpList.contains(compName))
					{
						tmpList.add(compName);
						result.put(thisServerType,tmpList);
					}
				}
				else
				{
					ArrayList tmpList =new ArrayList();
					tmpList.add(compName);
					result.put(thisServerType,tmpList);
				}

				String thisSegValue = autoTopoIniFile.getValue(segment, varName);
				StringTokenizer st = new StringTokenizer(thisSegValue,",");
				while(st.hasMoreTokens())
				{
					String thistoken = st.nextToken();
					if(thistoken!=null && thistoken.equals("null"))
						continue;
					String thiscomp = thistoken.substring(0,thistoken.lastIndexOf(":"));
					
					String this_server_type = thiscomp.substring(0,thiscomp.indexOf(":"));
					String this_compname = thiscomp.substring(thiscomp.indexOf(":")+1);
					if(result.containsKey(this_server_type))
					{
						ArrayList tmpList = (ArrayList) result.get(this_server_type);
						if(!tmpList.contains(this_compname))
						{
							tmpList.add(this_compname);
							result.put(this_server_type,tmpList);
						}
					}
					else
					{
						ArrayList tmpList =new ArrayList();
						tmpList.add(this_compname);
						result.put(this_server_type,tmpList);
					}
				}
			}
		}
		return result;
	}

	private Hashtable getGroupDetails(EgGroupInfo egGroupInfo)
	{
		// Collect Group Details, if Group Exists
		Hashtable result = new Hashtable();
		List groupList = new ArrayList();
		String[] groupComponents = egGroupInfo.getAllComponentsFromGroups();
		if(groupComponents!=null && groupComponents.length > 0)
		{
			for(int k=0;k<groupComponents.length;k++)
			{
				String groupVariable = groupComponents[k];
				String groupValue = egGroupInfo.getValue("GROUP_DETAILS", groupVariable);
				result.put(groupVariable , groupValue);
			}
		}
		return result;
	}

	public Hashtable getStartCompsFromTopoAuto(ArrayList allZoneCompList)
	{
		Hashtable result = new Hashtable();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String autoSubject = "Topo_Auto";
		String[] autoVar = autoTopoIniFile.getVariables(autoSubject);
		EgGroupInfo egGroupInfo = new EgGroupInfo();

		Hashtable groupTable = getGroupDetails(egGroupInfo);
		boolean isGroupExists = false;
		if(groupTable!=null && groupTable.size() > 0)
			isGroupExists = true;

		for(int k=0;k<autoVar.length;k++)
		{
			String varName = autoVar[k];
			String valName = autoTopoIniFile.getValue(autoSubject,varName);

			/*ArrayList deletedList = getDeletedComponents(varName,"null");
			if(deletedList!=null && deletedList.contains(varName))
				continue;*/

			if(allZoneCompList.contains(varName))
				continue;

			StringTokenizer st = new StringTokenizer(valName,",");
			boolean isValid = false;
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();

				/*ArrayList deletedListVal = getDeletedComponents("null",tok);	
				String val=tok;
				if(tok.endsWith(":L") || tok.endsWith(":N"))
					val = tok.substring(0,tok.lastIndexOf(":"));
				if(deletedListVal!=null && deletedListVal.contains(val))
					continue;*/

				tok = tok.substring(0,tok.lastIndexOf(":"));
				if(!allZoneCompList.contains(tok))
				{
					isValid = true;
					break;
				}
			}

			if(isValid)
			{
				String thisServerType = "";
				String compName = "";

				if(isGroupExists && groupTable.containsKey(varName))
				{
					String groupName = (String) groupTable.get(varName);
					boolean checkFlag = checkFunction(valName, groupName, egGroupInfo);
					if(checkFlag)
					{
						thisServerType = "Group";
						compName = groupName+":"+"NULL";
					}
				}
				else
				{
					thisServerType = varName.substring(0,varName.indexOf(":"));
					compName =  varName.substring(varName.indexOf(":")+1);
				}

				if(thisServerType.equals(""))
					continue;

				if(result.containsKey(thisServerType))
				{
					ArrayList tmpList = (ArrayList) result.get(thisServerType);
					if(!tmpList.contains(compName))
					{
						tmpList.add(compName);
						result.put(thisServerType,tmpList);
					}
				}
				else
				{
					ArrayList tmpList =new ArrayList();
					tmpList.add(compName);
					result.put(thisServerType,tmpList);
				}
			}
		}
		return result;
	}

	private boolean checkFunction(String valueString, String groupName , EgGroupInfo egGroupInfo)
	{
		boolean flag = false;
		StringTokenizer strTokenizer = new StringTokenizer(valueString,",");
		ArrayList groupCompList = egGroupInfo.getAllComponentsUnderGroup(groupName);
		while(strTokenizer.hasMoreTokens())
		{
			String val = strTokenizer.nextToken();
			val = val.substring(0,val.lastIndexOf(":"));
			if(!groupCompList.contains(val))
			{
				flag = true;
				break;
			}
		}
		return flag;
	}

	public ArrayList getDeletedComponents(String variable,String lineValue)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		ArrayList deletedList = new ArrayList();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();
		Set deletedSet = new TreeSet();

		if(variable!=null && !variable.equals("null") && !variable.equals(""))
		{
			String varName = variable;
			StringTokenizer stz = new StringTokenizer(varName,":");
			int count = stz.countTokens();

			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
			String deletedValue = disIniFile.getValue(thisCompName,varName);

			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else if(unmanageValue!=null && unmanageValue.length() > 0)	// Check for unmanage component
			{
				unmanageSet.add(varName);
			}
			else
			{
				boolean isOracle= false;
				if(count == 4)
					isOracle = true;
				
				if(!isOracle)
				{
					if(deletedValue==null || deletedValue.length()==0)
					{
						deletedSet.add(varName);
					}
				}
				else if(isOracle)
				{
					String variable2 = varName.substring(0,varName.lastIndexOf(":"));
					String deletedVals = disIniFile.getValue(thisCompName,variable2);
					String newvals = disIniFile.getValue(thisCompName,newstr+variable2);
					String unmanageVals = disIniFile.getValue(thisCompName,unmanagestr+variable2);
					if((newvals==null || newvals.length()==0)&&(unmanageVals==null || unmanageVals.length()==0))
					{
						if((deletedVals==null || deletedVals.length()==0) && (deletedValue==null || deletedValue.length()==0))
						{
							deletedSet.add(varName);
						}
					}
				}
			}
		}

		if(lineValue!=null && !lineValue.equals("") && !lineValue.equals("null"))
		{
			String valName = lineValue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				StringTokenizer str = new StringTokenizer(tmpvar,":");
				int cnt = str.countTokens();

				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				String unmanageVal = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
				String deletedVal = disIniFile.getValue(tmpcompname,tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else if(unmanageVal!=null && unmanageVal.length() > 0)
				{
					unmanageSet.add(tmpvar);
				}
				else
				{
					boolean isOracle= false;
					if(cnt == 4)
						isOracle = true;
					
					if(!isOracle)
					{
						if(deletedVal==null || deletedVal.length()==0)
						{
							deletedSet.add(tmpvar);
						}
					}
					else if(isOracle)
					{
						String variable1 = tmpvar.substring(0,tmpvar.lastIndexOf(":"));
						String newvals = disIniFile.getValue(tmpcompname,newstr+variable1);
						String unmanageVals = disIniFile.getValue(tmpcompname,unmanagestr+variable1);
						String deletedVals = disIniFile.getValue(tmpcompname,variable1);
						if((newvals==null || newvals.length()==0)&&(unmanageVals==null || unmanageVals.length()==0))
						{
							if((deletedVals==null || deletedVals.length()==0) && (deletedVal==null || deletedVal.length()==0))
							{
								deletedSet.add(tmpvar);
							}
						}
					}
				}
			}
		}

		if(deletedSet!=null && deletedSet.size() > 0)
		{
			deletedList = new ArrayList(deletedSet);
		}

		return deletedList;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/admin/EgTrackerA.jsp");
  }

  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody;
  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.release();
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.release();
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"EgProbs.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*************************************************************************************************/
/*                 Name          : EgAutoMainPage.jsp                                            */
/*                 Purpose       : This page is used to create Java script Auto Topology         */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	String filename = request.getRequestURI();
	if(filename.indexOf("aggDispServer.jsp")>=0 || filename.indexOf("aggNewServer.jsp")>=0 || filename.indexOf("EgAggregateTree.jsp")>=0)
	{
		disableF5="true";
	}
	String strCsrfToken = "";
	String strEncodedUrl = response.encodeURL(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
	if (strEncodedUrl != null)
	{
		int idx_A = strEncodedUrl.indexOf("?");
		if (idx_A != -1)
		{
			String queryString = strEncodedUrl.substring(idx_A+1);
			HashMap hashMapParameters = EcUtils.parseQueryString(queryString);
			if (hashMapParameters != null && hashMapParameters.containsKey("com.eg.CSRF_NONCE"))
			{
				strCsrfToken = (String)hashMapParameters.get("com.eg.CSRF_NONCE");
			}
		}
	}

	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");

      out.write("<script language=\"JavaScript1.2\">\n\n\t/** To Disable Right Click */\n\tvar message=\"\";\n\tfunction clickIE()\n\t{\n\t\tif(document.all)\n\t\t{\n\t\t\t(message);return false;\n\t\t}\n\t}\n\t\n\tfunction clickNS(e)\n\t{\n\t\tif(document.layers||(document.getElementById&&!document.all))\n\t\t{\n\t\t\tif(e.which==2||e.which==3)\n\t\t\t{\n\t\t\t\t(message);return false;\n\t\t\t}\n\t\t}\n\t}\n\t\n\tif('");
      out.print(RightClikMode);
      out.write("'=='production')\n\t{\n\t\tif (document.layers)\n\t\t{\n\t\t\tdocument.captureEvents(Event.MOUSEDOWN);document.onmousedown=clickNS;\n\t\t}\n\t\telse\n\t\t{\n\t\t\tdocument.onmouseup=clickNS;document.oncontextmenu=clickIE;\n\t\t}\n\t\tdocument.oncontextmenu=new Function(\"return false\")\n\t}\n\n\t/**  To disable drag and selection */\n\tvar alltables = document.getElementsByTagName(\"body\");\n\tif ('");
      out.print(SelectionMode);
      out.write("' == 'production') {\n\t\twindow.onload = function() {\n\t\t\tfunction disableSelection(element) {\n\t\t\t\telement.onselectstart = function() {\n\t\t\t\t\treturn false;\n\t\t\t\t};\n\t\t\t\telement.unselectable = \"on\";\n\t\t\t\telement.style.MozUserSelect = \"none\";\n\t\t\t\telement.style.cursor = \"default\";\n\t\t\t}\n\n\t\t\tfor (var i = 0; i < alltables.length; i++) {\n\n\t\t\t\tdisableSelection(alltables[i]); //disable text selection within all tables on the page\n\t\t\t}\n\n\t\t}\n\t}\n\nfunction callWindow(opt)\n{\n\tvar topWindow = window;\n\twhile(topWindow.parent!=topWindow ||  topWindow.opener!=null)\n\t{\n\t\tmainWindow = topWindow;\n\t\ttopWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);\n\t}\n\tif(topWindow.location.pathname!=\"/\")\n\t{\n\t\tmainWindow=topWindow;\n\t}\n\tvar requestFrom = '");
      out.print(request.getParameter("reqFrom"));
      out.write("';\n\tif (requestFrom != null && requestFrom == 'clsTrial')\n\t{\n\t\tmainWindow.location.href=\"/final/servlet/com.egurkha.Logout?reqFrom=clsTrial&errmsg=\"+opt;\n\t}\n\telse\n\t{\n\t\tmainWindow.location.href=\"/final/servlet/com.egurkha.Logout?errmsg=\"+opt;\n\t}\n\tmainWindow.focus();\n}\n</script>\n\n");

	EgDbAdapterUI egDbTracker = EgDbAdapterTypeUI.getObject();
	String dbTrackerStatus =egDbTracker.setConnection();
	if(dbTrackerStatus == null)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(1);\n\t\t</script>\n");

		return;
	}
	else if(dbTrackerStatus != null && !dbTrackerStatus.equals("CONNECTED"))
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(1);\n\t\t</script>\n");

		return;
	}
	egDbTracker.releaseConnection(false);
	EgDbAdapterTypeUI.releaseObject(egDbTracker);
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	String sessionID = null;
	UserRegistry registry = null;
	User _user = null;
	boolean id_u = false;
	String u_rs = null;
	String userLogos = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String admin_Skin = null;
	if(session!=null)
	{
		sessionID = session.getId();
		registry = UserRegistry.getInstance();
		//_user = registry.getUser(sessionID);
		_user = registry.getUser(sessionID,true);
		if(_user!=null)
		{
			id_u = _user.isIdDeletedWhileLoggedIn();
			if(id_u == false)
			{
				u_rs =  _user.getLoginID();
				userLogos = _user.getUserLogo();

				trackerUI.set_loginID(u_rs);
				trackerUI.set_userLogo(userLogos);

				if(!User.isDefaultUser(u_rs))
				{
					ErUserData er = _user.getReporterData();
					u_v_till = er.getUserValidtill();
					l_accessed = session.getLastAccessedTime();
				}
			}
		}
	}
	if(session == null || _user ==null)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(1);\n\t\t</script>\n");

		return;
	}
	else if(id_u== true)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(2);\n\t\t</script>\n");

		return;
	}
	else if (u_v_till < l_accessed)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(3);\n\t\t</script>\n");

		return;
	}
	else
	{
		String entry= request.getParameter("entry");
		if(entry!=null)
		{
			boolean isAdmin   = entry.equalsIgnoreCase("admin");
			boolean isMonitor = entry.equalsIgnoreCase("monitor");
			boolean isReport  = entry.equalsIgnoreCase("reporter");
			boolean isConfig  = entry.equalsIgnoreCase("config");
			if(isAdmin)
			{
				String queryURI = request.getRequestURI();
				String queryString = request.getQueryString();
				if (queryURI != null && queryURI.indexOf("EgDiscServers.jsp") != -1)
				{
					queryURI = "/final/admin/EgChangePorts.jsp";
					queryString = "from=HmcSettings";
				}
				//session.setAttribute("Page_IdentifierA",request.getRequestURI()+"?"+request.getQueryString());
				session.setAttribute("Page_IdentifierA",queryURI+"?"+queryString);
			}
			if(isMonitor)
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
			if(isReport)
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
			if(isConfig)
			{
				session.setAttribute("Page_IdentifierC",request.getRequestURI()+"?"+request.getQueryString());
			}
		}
		else
		{
			String queryURI = request.getRequestURI();
			String queryString = request.getQueryString();
			if (queryURI != null && queryURI.indexOf("EgDiscServers.jsp") != -1)
			{
				queryURI = "/final/admin/EgChangePorts.jsp";
				queryString = "from=HmcSettings";
			}
			//session.setAttribute("Page_IdentifierA",request.getRequestURI()+"?"+request.getQueryString());
			session.setAttribute("Page_IdentifierA",queryURI+"?"+queryString);
		}
	}
	if (_user!=null)
	{
		String trackerUserLang = _user.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
		_user.setUserLanguageAndSkins();
		admin_Skin = _user.getAdminSkin();
	}
	String script_src = "script_item_"+trackerLanguage+".js";
	EgMappingInfo _mapping = new EgMappingInfo(trackerLanguage);
	
	   //Variable to be used for Time zone support  in javascript code

		String currentDateFormatForJS = trackerUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String mgrDateFormat = currentDateFormatForJS;
		String dateFormatNew = mgrDateFormat;
		if(currentDateFormatForJS!=null && currentDateFormatForJS.indexOf("MMM") >= 0)
		{
			for(int i=0; i < currentDateFormatForJS.length();i++)
			{
				if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
				{
					currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
				}
			}
		}
		String dateFormatForDatePicker=(String)_user.getUserDateFormat();
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}

      out.write("<script>\n\tvar dateFormatForTimeline = '");
      out.print(dateFormatNew);
      out.write("';\n\tvar settings='");
      out.print(_mapping.getTextDescription("monitor.common.Settings"));
      out.write("';\n\tvar toolData='");
      out.print(_mapping.getTextDescription("monitor.common.Data"));
      out.write("';\n\tvar toolCSV='");
      out.print(_mapping.getTextDescription("monitor.common.CSV"));
      out.write("';\n\tvar toolSave ='");
      out.print(_mapping.getTextDescription("monitor.common.SAVE"));
      out.write("';\n\tvar toolMail='");
      out.print(_mapping.getTextDescription("reporter.common.MAIL"));
      out.write("';\n\tvar toolPrint='");
      out.print(_mapping.getTextDescription("reporter.common.PRINT"));
      out.write("';\n\tvar timelineLbl='");
      out.print(_mapping.getTextDescription("monitor.common.Timeline"));
      out.write("';\n\tvar hrLbl='");
      out.print(_mapping.getTextDescription("monitor.common.Hr"));
      out.write("';\n\tvar Tolbl='");
      out.print(_mapping.getTextDescription("monitor.common.To"));
      out.write("';\n\tvar fromLbl='");
      out.print(_mapping.getTextDescription("monitor.history.From"));
      out.write("';\n\tvar graphLbl='");
      out.print(_mapping.getTextDescription("monitor.summary.Graph"));
      out.write("';\ndocument.onkeydown = fkey;\nfunction fkey(e){\n  e = e || window.event;\n      \n  if (e.which == 116 || e.keyCode == 82 && e.ctrlKey) { //116 = F5\n  \tif('");
      out.print(disableF5);
      out.write("'=='false')\n\t{\n\t\twindow.parent.refreshEgIndexPage();\n\t}\n\treturn false;\n  }\n}\n\t\n</script>\n\n\n");
      egurkha.ZoneInfoBean zoneinfo = null;
      synchronized (_jspx_page_context) {
        zoneinfo = (egurkha.ZoneInfoBean) _jspx_page_context.getAttribute("zoneinfo", PageContext.PAGE_SCOPE);
        if (zoneinfo == null){
          zoneinfo = new egurkha.ZoneInfoBean();
          _jspx_page_context.setAttribute("zoneinfo", zoneinfo, PageContext.PAGE_SCOPE);
        }
      }

try
{
	//System.out.println("TEST 123");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	
	String topologySkin=_user.getAdminSkin();
	String bgColor = "";
	String compNameColor="";
	String fontFamily="LucidaGrandeRegular";
	String fontFamilyBold="LucidaGrandeBold";
	String mouseOverLineColor = "";
	String mouseOverTextColor="";
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	IniFile udTests=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	if(topologySkin!=null && topologySkin.equalsIgnoreCase("Dark"))
	{
		bgColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","BgColor");
		compNameColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","MouseOverTextColor");
	}
	else
	{
		bgColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","BgColor");
		compNameColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","MouseOverTextColor");
	}

	EgGroupInfo groupInfo = new EgGroupInfo();
	ArrayList thisZoneComponents = new ArrayList();	// Contains all components from the given zone.
	ArrayList allZoneComponents = new ArrayList();	// Contains all components from all Zones Except the selected Zone
	String zone = request.getParameter("zone");
	String segmentName = request.getParameter("segment");
	//out.println("segment name"+segmentName);
	String zoomLevel = request.getParameter("zoom");
	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");
	String link = request.getParameter("link");
	String isAddFlag = request.getParameter("isAddFlag");
	boolean isRecflag = false;
	if(isAddFlag!=null && isAddFlag.equals("true"))
	{
		isRecflag = true;
	}
	boolean isFull = false;
	if(view!=null && view.equals("full"))
		isFull = true;

	String modify = request.getParameter("modify");
	//out.println("modify::"+modify);
	boolean modifySegment=false;
	boolean showComponents=true;
	if(modify!=null && modify.equals("modifySegment"))
		modifySegment = true;
	
	String fromAutoCompType = request.getParameter("fromAutoCompType");
	if(fromAutoCompType==null)
		fromAutoCompType = "false";
	if(modifySegment)
	{
		EgTesterInfo testsInfo = new EgTesterInfo("manager");
		boolean flag = testsInfo.isTopoDiscoveryEnabled();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String[] varArray = autoTopoIniFile.getVariables("Topo_Auto");
		boolean isTopoEntry = false;
		if(varArray!=null && varArray.length > 0)
			isTopoEntry = true;

		if(flag && isTopoEntry)
			showComponents = true;
		else
			showComponents = false;
	}
	
	String dragFn = request.getParameter("enableDrag");
	boolean dragEnabled = false;
	if(dragFn!=null && dragFn.equalsIgnoreCase("true"))
		dragEnabled=true;

	String hlc_type = request.getParameter("hlcomptype");	// High_Lighted_CompType
	String hlc = request.getParameter("hlcomp");			// High_Lighted_Comp
	if(hlc_type == null) 
	{
		hlc_type = request.getParameter("frmcomptype");
	}
	if(hlc == null)
	{
		hlc = request.getParameter("frmcompname");
	}
	
	String color = "A0A0A0";
	String dark = "150517";
	if(zoomLevel == null) zoomLevel = "100";
	if(phyTopology == null) phyTopology = "1";
	if(site == null) site = "egurkha.physical.topology";
	boolean isEntry = false;
	
	String conPath = request.getContextPath();
	//String contextPath = request.getContextPath()+"/admin/eg_images/";
	String contextPath1 = request.getContextPath()+"/images/component_icons/";
	String contextPath = request.getContextPath()+"/images/"+topologySkin+"/component_icons/";
	String ICImagePath=request.getContextPath()+"/images/"+topologySkin+"/ic_images/";
	String finalTopoStr = new String();

	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1")){
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;
	}

	Hashtable tmpHt = groupInfo.getAllComponentsUnderZone();
	if(tmpHt!=null && tmpHt.size() > 0)
	{
		if(isZone && tmpHt.containsKey(zone)){
			tmpHt.remove(zone);
		}
		ArrayList valList = new ArrayList(tmpHt.values());
		for(int k=0;k<valList.size();k++)
		{
			ArrayList tmpList = (ArrayList) valList.get(k);
			allZoneComponents.addAll(tmpList);
		}
	}

/* New Coding Starts here */
	String comptype = request.getParameter("comptype");
	if(comptype==null) comptype="";
	String compname = request.getParameter("compname");
	if(compname==null) compname="";
	StringBuffer  compDataStr = new StringBuffer();
	String action = request.getParameter("action");
	if(action!=null && action.equals("show"))
	{
		IniFile autoTopoIni1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		compDataStr.append(comptype+":"+compname);
		compDataStr.append(",");
		compDataStr.append(autoTopoIni1.getValue("Topo_Auto",comptype+":"+compname));
	}
	else if(action!=null && action.equals("addlink"))
	{
		if(compname !=null && compname.indexOf(",") > -1)
		{
			StringTokenizer stk = new StringTokenizer(compname, ",");
			while(stk.hasMoreTokens())
			{
				compDataStr.append(comptype+":"+stk.nextToken());
				compDataStr.append(",");
			}
		}
		else
		{
			compDataStr.append(comptype+":"+compname);
		}
	}
	String comparisonString = compDataStr.toString();
	Hashtable compList = getStartCompsFromTopoAuto(allZoneComponents);
	Hashtable segmentCompTable = getSegmentComps(segmentName);
	//out.println("segmentCompTable"+segmentCompTable.size());
	//Remove segment components from compList...(Begin)
	if(segmentCompTable!=null && segmentCompTable.size() > 0)
	{
		Set myKeys = segmentCompTable.keySet();
		Iterator myItr = myKeys.iterator();
		while(myItr.hasNext())
		{
			String myKey  = (String) myItr.next();
			ArrayList totalList = (ArrayList) compList.get(myKey);
			if(totalList!=null && totalList.size() > 0)
			{
				ArrayList myList = (ArrayList) segmentCompTable.get(myKey);
				if(myList!=null && myList.size() > 0)
				{
					boolean remove = false;
					for(int k=0;k<myList.size();k++)
					{
						String thisString = (String) myList.get(k);
						int index = totalList.indexOf(thisString);
						if(index >= 0)
						{
							totalList.remove(index);
							remove = true;
						}
					}
					if(remove)
					{
						if(totalList.size() > 0)
							compList.put(myKey, totalList);
						else
							compList.remove(myKey);
					}
				}
			}
		}
	}
	//Remove segment components from compList...(End)

	ArrayList serverTypes = new ArrayList();
	ArrayList compNames = new ArrayList(); 
	if(compList!=null && compList.size() > 0)
	{
		Set compTypeSet = compList.keySet();
		if(compTypeSet!=null && compTypeSet.size() > 0)
		{
			serverTypes = new ArrayList(compTypeSet);
			Collections.sort(serverTypes);
		}
		if(comptype!=null && comptype.length() > 0)
		{
			compNames = (ArrayList) compList.get(comptype);
			if(compNames!=null)
				Collections.sort(compNames);
		}
	}
/* New Coding Ends here */
	
	// For Save position
	String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/js_topology.ini";
	IniFile jsTopoIniObj  = EgConfigFilesSync.getInstance(iniFileName);
	String subjectName = segmentName;
	if(segmentName!=null && segmentName.equals("Independent_servers"))
	{
		subjectName = site+ ":"+segmentName;
	}
	String[] allLinesjs = jsTopoIniObj.getLinesUnderSubject(subjectName);
	String iniZoom = jsTopoIniObj.getValue(subjectName,"zoom");
	if(iniZoom != null && iniZoom.length() > 0 )
	{
		zoomLevel = iniZoom;
	}
	EgConfigFilesSync.releaseInstance(jsTopoIniObj);

	boolean isPosition = false;
	StringBuffer positionBuffer = new StringBuffer();
	if(allLinesjs!=null)
	{
		List positionList = Arrays.asList(allLinesjs);
		positionBuffer.append(positionList.toString().substring(1,positionList.toString().indexOf("]")));
		isPosition = true;
	}
	
	if(defaultPos !=null && defaultPos.equals("true"))
		isPosition = false;

	String loginID = _user.getLoginID();

	//Delete Previous INCOMPLETE_SEGMENT if any exists"
	String INCOMPLETE_SEGMENT = "INCOMPLETE_SEGMENT";
	String SESSION_DETAILS = "SESSION_DETAILS";
	String iniFileNameAuto = EgInstallInfo.getInstallDir()+"/manager/config/eg_autotopology.ini";
	IniFile autoTopologyIni  = EgConfigFilesSync.getInstance(iniFileNameAuto,true);
	Vector sessionVariables = autoTopologyIni.getVariables(SESSION_DETAILS, false);
	if(sessionVariables!=null && sessionVariables.size() > 0)
	{
		// Delete Previous invalid session details & its corresponding segments
		for(int k=0;k<sessionVariables.size();k++)
		{
			String thisVariable = (String) sessionVariables.get(k);
			boolean isValid = registry.isSessionValid(thisVariable);
			if(isValid)
				continue;

			String sessionValue = autoTopologyIni.getValue(SESSION_DETAILS, thisVariable);
			autoTopologyIni.deleteValue(SESSION_DETAILS, thisVariable);
			StringTokenizer myTokenizer = new StringTokenizer(sessionValue,",");
			while(myTokenizer.hasMoreTokens())
			{
				String thisToken = myTokenizer.nextToken();
				autoTopologyIni.deleteValue(INCOMPLETE_SEGMENT, thisToken);
				autoTopologyIni.deleteSubject(thisToken);
			}
		}
		autoTopologyIni.saveFile();
	}
	//Check if the segment is already used by any other user, If "yes" Dn't allow 
	Vector varVec = autoTopologyIni.getVariables(INCOMPLETE_SEGMENT, false);
	boolean proceed = false;
	if(varVec!=null && varVec.contains(segmentName))
	{
		String inCompleteValue = autoTopologyIni.getValue(INCOMPLETE_SEGMENT, segmentName);
		String createdUser = inCompleteValue.substring(0,inCompleteValue.indexOf(":"));
		String createdSessId = inCompleteValue.substring(inCompleteValue.indexOf(":")+1);
		if(createdUser.equals(loginID) && createdSessId.equals(sessionID))
		{
			proceed = true;
		}
		else
		{
			proceed = false;
		}
	}
	else
	{
		String valueString = loginID+":"+sessionID;
		String previous_segment = autoTopologyIni.getValue(SESSION_DETAILS,sessionID);
		if(previous_segment!=null && previous_segment.length() > 0)
		{
			if(segmentName!=null && segmentName.length() > 0){
				previous_segment = previous_segment +","+segmentName;
				autoTopologyIni.setValue(SESSION_DETAILS,sessionID,previous_segment);
			}
		}
		else
		{
			autoTopologyIni.setValue(SESSION_DETAILS,sessionID,segmentName);
		}
		autoTopologyIni.setValue(INCOMPLETE_SEGMENT,segmentName,valueString);
		proceed = true;
	}
	autoTopologyIni.saveFile();
	EgConfigFilesSync.releaseInstance(autoTopologyIni);

	// To Remover Previous session entries
	session.removeAttribute("AllLinesInSegment");
	session.removeAttribute("sessionGroupTable");
	session.removeAttribute("GroupCompHashtable");
	session.removeAttribute("zoneLines");
	session.removeAttribute("THISSEGMENT");
	String from = request.getParameter("fromPage");
	if(from==null) from="";
	if(from!=null && from.equals("modifySegment"))
	{
		String iniFilePath= EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		
		String autoiniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_autotopology.ini";
		IniFile autoTopoIni1  = EgConfigFilesSync.getInstance(autoiniFileName,true);
		
		String[] topoLines = iniFile.getLinesUnderSubject(segmentName);
		String[] autoTopoLines = autoTopoIni1.getLinesUnderSubject(segmentName);
		
		if(topoLines!=null && topoLines.length>0)
		{
			if(autoTopoLines==null)
			{			
				for(int k=0;k<topoLines.length;k++)
				{
					String line = topoLines[k];
					String lineVar = line.substring(0,line.indexOf("="));
					String lineVal = line.substring(line.indexOf("=")+1);
					autoTopoIni1.setValue(segmentName , lineVar , lineVal);
				}			
			}
			else if(autoTopoLines!=null && autoTopoLines.length>0)
			{
				autoTopoIni1.deleteSubject(segmentName);
				for(int k=0;k<topoLines.length;k++)
				{
					String line = topoLines[k];
					String lineVar = line.substring(0,line.indexOf("="));
					String lineVal = line.substring(line.indexOf("=")+1);
					autoTopoIni1.setValue(segmentName , lineVar , lineVal);
				}			
			}
			autoTopoIni1.saveFile();
		}
		EgConfigFilesSync.releaseInstance(autoTopoIni1);
	}
	

      out.write("<html>\n<head>\n<title>Auto Topology Generation</title>\n");
      if (_jspx_meth_egui_005fskin_005f0(_jspx_page_context))
        return;
      out.write("<head>\n<style type=\"text/css\">\n.myContextMenu .x-menu-body {\n    background: #fff;\n    padding: 1;\n}\n\n.myContextMenu ul {\n    padding: 0;\n    margin: 0;\n    text-align: center;\n}\n\n.myContextMenu ul li {\n    list-style-type: none;\n}\n\n.myContextMenu ul li:nth-child(odd) {\n    background-color: #e6e6e6;\n}\n\n.myContextMenu a:hover {\n    background-color: #ccf;\n}\n\n.myContextMenu a {\n    text-decoration: none;\n    color: #000;\n    display: block;\n    padding: .5em 0;\n}\n.DisableCheckBox{\n\topacity:0.3\n}\n</style>\n<script src=\"/final/scripts/map.js\" type=\"text/javascript\" charset=\"utf-8\"></script>\n<script src=\"/final/scripts/raphael.js\" type=\"text/javascript\" charset=\"utf-8\"></script>\n<script src=\"/final/scripts/raphael.zoom.js\" type=\"text/javascript\" charset=\"utf-8\"></script>\n");
      if (_jspx_meth_egui_005fskin_005f1(_jspx_page_context))
        return;
      out.write("<script type=\"text/javascript\" src=\"/final/extjs/ext-all.js\"></script>\n<script language=\"JavaScript1.2\" src=\"/final/jquery/jquery.js\"></script>\n\n\n<script type=\"text/javascript\">\n\n\nvar $j = jQuery.noConflict();\n\n$j(document).ready(function(){\n\t// call it onload\n\t//centerBottom(\"#legendDiv\");\n\t// assure that it gets called when the page resizes\n\n\t//alignZoomDiv('#ZoomDiv');\n\n\t$j(window).resize(function(){\n\t\t//centerBottom('#legendDiv');\n\t\t//alignZoomDiv('#ZoomDiv');\n\t});\n\n\n\t/*   JQuery Drag & Drop Functionality  (Begin)   */\n\t$j.globalVars = {\n\t\t//originalTop: 0,\n\t\t//originalLeft: 0,\n\t\tmaxHeight: $j(window).height(),\n\t\tmaxWidth:  $j(window).width()\n\t};\n\n\t/*$j( \"#groupDiv\" ).draggable({ \n\t\tcancel: \"tr.ui-widget-header-temp\",\n\t\tcursor: \"move\",\n\t\tscroll: false,\n\t\t//iframeFix: false,\n\t\t//snapMode: \"both\", \n\t\t//opacity: 0.35,\n\t\tcontainment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]\n\t\t//containment: \"parent\",\n\t\t//stop: handleDragStop\n\t});*/\n\t/*   JQuery Drag & Drop Functionality  (End)   */\n");
      out.write("});\n\n//creating slider\n\nExt.onReady(function(){\n\n\tsetSlider();\n\n});\n\n\nfunction setSlider()\n{\n\t\n\tExt.define('AlwaysVisibleTip', {\n\t\textend: 'Ext.slider.Tip',\n\t\tid:'mytip',\n\t\tcls: 'yellowTip',\n\t\tinit: function(slider) {\n\t\t\tvar me = this;\n\n\t\t\tme.callParent(arguments);\n\t\t\tslider.removeListener('dragend', me.hide);\n\t\t\tslider.on({\n\t\t\t\tscope: me,\n\t\t\t\tchange: me.onSlide,\n\t\t\t\tafterrender: {\n\t\t\t\t\tfn: function() {\n\t\t\t\t\t\tme.onSlide(slider, null, slider.thumbs[0]);\n\t\t\t\t\t\ttip_hide_task.delay(2000);\n\n\n\t\t\t\t\t},\n\t\t\t\t\tdelay: 100\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n\n\tvar tip_hide_task = new Ext.util.DelayedTask(function(){\n\t\tif (Ext.getCmp('mytip') != undefined)\n\t\t{\n\t\t  Ext.getCmp('mytip').hide();\n\t\t}\n\t});\n\n\tExt.create(\"Ext.form.Panel\", {\n\t//width:108,\n\trenderTo: Ext.getBody(),\n\tbaseCls:'emptyCls',\n\theight:210,\n\tborder:0,\n\tplain:true,\n\tbodyStyle:{'background':'transparent'},\n\tstyle:{'position':'absolute','top':'10px','left':'10px','background':'transparent'},\n\titems: [\n\t\t{\n\t\t\txtype: 'container',\n\t\t\titems: [{\n\t\t\t\txtype: 'button',\n\t\t\t\tcls:'zoomInbt',\n");
      out.write("\t\t\t\twidth:18,\n\t\t\t\theight:18,\n\t\t\t  handler: function() {\n\t\t\t\tvar sliderValue=Ext.getCmp('sliderSingle').getValue();\n\t\t\t\tsliderValue=parseInt(sliderValue);\n\t\t\t\tif(sliderValue<150)\n\t\t\t\t{\n\t\t\t\t\tsliderValue=sliderValue+10;\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\tif(sliderValue>150)\n\t\t\t\t{\n\t\t\t\t\tsliderValue=150;\n\t\t\t\t}\n\t\t\t\tExt.getCmp('sliderSingle').setValue(sliderValue);\n\t\t\t\ttip_hide_task.delay(2000);\n\t\t\t\tsetZoomLevel(sliderValue);\n\t\t\t  }\n\t\t\t   \n\t\t\t},\n\t\t\tExt.create('Ext.slider.Single', {\n\t\t\thideLabel: true,\n\t\t\tid:'sliderSingle',\n\t\t\tuseTips: false,\n\t\t\tanimate: false,\n\t\t\tplugins: [Ext.create('AlwaysVisibleTip')],\n\t\t\theight: 118,\n\t\t\tvalue: '");
      out.print(zoomLevel);
      out.write("',\n\t\t\tvertical: true,\n\t\t\tminValue: 10,\n\t\t\tmaxValue: 150,\n\t\t\tlisteners : {\n\t\t\t\t\n\t\t\t\t\t'changecomplete' : function( slider, e, eOpts )\n\t\t\t\t\t{\n\t\t\t\t\t\tvar sliderValue=Ext.getCmp('sliderSingle').getValue();\n\t\t\t\t\t\tsetZoomLevel(sliderValue);\n\t\t\t\t\t\t\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}), \n\t\t\t{\n\t\t\t\txtype: 'button',\n\t\t\t\twidth:18,\n\t\t\t\theight:18,\n\t\t\t\tstyle:{'margin-top':'-6px'},\n\t\t\t\tcls:'zoomOutbt',\n\t\t\t  handler: function() {\n\t\t\t\t\tvar sliderValue=Ext.getCmp('sliderSingle').getValue();\n\t\t\t\t\tsliderValue=parseInt(sliderValue);\n\t\t\t\t\tif(sliderValue>10)\n\t\t\t\t\t{\n\t\t\t\t\t\tsliderValue=sliderValue-10;\n\t\t\t\t\t}\n\t\t\t\t\tif(sliderValue<10)\n\t\t\t\t\t{\n\t\t\t\t\t\tsliderValue=10;\n\t\t\t\t\t}\n\t\t\t\t  Ext.getCmp('sliderSingle').setValue(sliderValue);\n\t\t\t\t  tip_hide_task.delay(2000);\n\t\t\t\t  setZoomLevel(sliderValue);\n\t\t\t  }\n\t\t\t}\n        ]\n    }]\n   });\n}\n\nfunction alignToolsDiv(selector)\n{\n\tvar toolLeft = $j(window).width() - 180;\n\t$j(selector).css({\n\t\t'left': toolLeft\n\t});\n}\n\nfunction alignZoomDiv(selector)\n{\n\tvar zoomLeft = $j(window).width() - 250;\n\t$j(selector).css({\n\t\t'left': zoomLeft\n");
      out.write("\t});\n}\n\nfunction centerBottom(selector) {\n    var newTop =   $j(window).height() - $j(selector).height();\n    var newLeft = ($j(window).width()  - $j(selector).width()) / 2;\n    $j(selector).css({\n        'position': 'absolute',\n        'left': newLeft,\n        'top': newTop - 33\n    });\n}\n\nfunction hideDivs(divId)\n{\n\t\n\t$j(\"#\"+divId).hide(\"slow\");\n\tExt.getCmp('ExtMenu').hide();\n}\n\n/*\tContext Menu  scripts (Begin) */\nvar ie = document.all\nvar ns6 = document.getElementById&&!document.all\nvar isMenu = false ;\nvar menuSelObj = null ;\nvar overpopupmenu = false;\nfunction mouseSelect(e)\n{\n\tvar obj = ns6 ? e.target.parentNode : event.srcElement.parentElement;\n\tif( isMenu ){\n\t\tif( overpopupmenu == false ){\n\t\t\tisMenu = false ;\n\t\t\toverpopupmenu = false;\n\t\t\tdocument.getElementById('menudiv').style.display = \"none\" ;\n\t\t\treturn true ;\n\t\t}\n\t\treturn true ;\n\t}\n\treturn false;\n}\n\nfunction ItemSelMenu(e, compstatus)\n{\n\tvar\tobj = ns6 ? e.target.parentNode : event.srcElement.parentElement;\n\tmenuSelObj = obj ;\n\tif (ns6){\n\t\tdocument.getElementById('menudiv').style.left = e.clientX+document.body.scrollLeft;\n");
      out.write("\t\tdocument.getElementById('menudiv').style.top = e.clientY+document.body.scrollTop;\n\t}\n\telse{\n\t\tdocument.getElementById('menudiv').style.pixelLeft = event.clientX+document.body.scrollLeft;\n\t\tdocument.getElementById('menudiv').style.pixelTop = event.clientY+document.body.scrollTop;\n\t}\n\tdocument.getElementById('menudiv').style.display = \"\";\n\tisMenu = true;\n\n\tvar thisTitle = document.getElementById('h_title').value;\n\tvar thisSrc = document.getElementById('h_src').value;\n\tvar usesRow = document.getElementById('usesRow');\n\tvar removeRow = document.getElementById('removeRow');\n\tvar manageRow = document.getElementById('manageRow');\n\tvar groupRow = document.getElementById('groupRow');\n\tvar unGroup = document.getElementById('unGroup');\n\tvar groupCreate = document.getElementById('groupCreate');\n\t\n\tif(compstatus == \"NEW\" || compstatus == \"UNMANAGE\"){\n\t\tgroupRow.style.display = 'none';\n\t\tunGroup.style.display = 'none';\n\t\t//groupCreate.style.display = 'none';\n\t\tif(usesRow.style.display == 'none') usesRow.style.display = '';\n");
      out.write("\t\tif(removeRow.style.display == 'none') removeRow.style.display = '';\n\t\tif(manageRow.style.display == 'none') manageRow.style.display = '';\n\t}\n\telse if(compstatus == \"MANAGED\"){\n\t\tmanageRow.style.display ='none';\n\t\tgroupCreate.style.display = 'none';\n\t\tif(usesRow.style.display == 'none') usesRow.style.display = '';\n\t\tif(removeRow.style.display == 'none') removeRow.style.display = '';\n\n\t\t//If the component is Group\n\t\tif(thisSrc.indexOf(\"Group.png\") > 0){\n\t\t\tgroupRow.style.display ='';\n\t\t\tunGroup.style.display ='';\n\t\t}\n\t\telse{\n\t\t\tgroupRow.style.display = 'none';\n\t\t\tunGroup.style.display = 'none';\n\t\t\tif(groupCreate.style.display == 'none') groupCreate.style.display = '';\n\t\t}\n\t}\n\t/*else if(compstatus == \"UNKNOWN\"){\n\t\tmanageRow.style.display ='none';\n\t\tgroupRow.style.display = 'none';\n\t\tif(usesRow.style.display == 'none') usesRow.style.display = '';\n\t\tif(removeRow.style.display == 'none') removeRow.style.display = '';\n\t}*/\n\telse if(compstatus == \"User\"){\n\t\tusesRow.style.display = 'none';\n\t\tremoveRow.style.display = 'none';\n");
      out.write("\t\tmanageRow.style.display = 'none';\n\t\tgroupRow.style.display = 'none';\n\t\tunGroup.style.display = 'none';\n\t\tgroupCreate.style.display = 'none';\n\t}\n\t//$j(\"#connectDiv\").hide(\"slow\");\n\treturn false ;\n}\ndocument.oncontextmenu = new Function(\"return false\");\n\nfunction getAbsoluteDivs(){\n\t\n\tvar arr = new Array();\n\tvar all_divs = document.body.getElementsByTagName(\"DIV\");\n\tvar j = 0;\n\tfor (i = 0; i < all_divs.length; i++)\n\t\tif (all_divs.item(i).style.position=='absolute'){\n\t\t\tarr[j] = all_divs.item(i);\n\t\t\tj++;\n\t\t}\n\treturn arr;\n}\n\nfunction bringToFront(obj){\n\t\n\tif (!document.getElementsByTagName)\n\t\treturn;\n\tvar divs = getAbsoluteDivs();\n\tvar max_index = 0;  \n\tvar cur_index;\n\n\tfor (i = 0; i < divs.length; i++){\n\t\tvar item = divs[i];\n\t\tif (item == obj || item.style.zIndex == '')\n\t\t\tcontinue;\n\t\tcur_index = parseInt(item.style.zIndex);\n\t\tif (max_index < cur_index){\n\t\t\tmax_index = cur_index;\n\t\t}\n\t}\n\tobj.style.zIndex = max_index + 1;\n}\n\nfunction refreshPage()\n{\n\tvar thiszone= document.getElementById(\"zone\").value;\n\tvar thissegment = document.getElementById(\"segment\").value;\n");
      out.write("\tvar zoomValue = document.getElementById(\"zoom\").value;\n\tvar enableDrag = '';\n\t//\n\tdocument.getElementById('container').style.height = documentView.getHeight()+\"px\";  \n\tdocument.getElementById('container').style.width = documentView.getWidth()+\"px\";  \n\t//\n\tif($j('#dragCheckbx').is(':checked'))\n\t{\n\t\tenableDrag = 'true';\n\t}\n\telse\n\t{\n\t\tenableDrag = 'false';\n\t}\n\tvar modify=\"");
      out.print(modify);
      out.write("\";\n\tvar myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+zoomValue+\"&enableDrag=\"+encodeURI(enableDrag)+\"&modify=\"+encodeURI(modify);\n\tsetTimeout(function(){ window.location = myUrl;}, 0);\n}\n\nfunction RemoveFunction(myAction)\n{\n\tvar myUrl = getServletUrl(myAction);\n\tdoFunction(myUrl, myAction);\n}\n\n\nfunction reloadMainPage(servertype , servername )\n{\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar zoomValue = $j(\"#zoom\").attr(\"value\");\n\tvar enableDrag = '';\n\tif($j('#dragCheckbx').is(':checked'))\n\t{\n\t\tenableDrag = 'true';\n\t}\n\telse\n\t{\n\t\tenableDrag = 'false';\n\t}\n\tvar modify=\"");
      out.print(modify);
      out.write("\";\n\tvar myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+encodeURI(zoomValue)+\"&enableDrag=\"+encodeURI(enableDrag);//+\"&modify=\"+encodeURI(modify);\n\tif(servername==null)\n\t{\n\t\tif(servertype == \"-1\"){\n\t\t\tvar sname = document.getElementById(\"servernames\");\n\t\t\tsname.length = 1;\n\t\t\talert('");
      if (_jspx_meth_egui_005fintnl_005f0(_jspx_page_context))
        return;
      out.write("');\n\t\t\treturn;\n\t\t}\n\t\telse{\n\t\t\tvar comptype = servertype;\n\t\t\tmyUrl = myUrl +\"&comptype=\"+encodeURI(comptype);\n\t\t\tsetTimeout(function(){ window.location = myUrl;}, 0);\n\t\t}\n\t}\n\tif(servertype==null)\n\t{\n\t\tif(servername == \"-1\"){\n\t\t\talert('");
      if (_jspx_meth_egui_005fintnl_005f1(_jspx_page_context))
        return;
      out.write("');\n\t\t\treturn;\n\t\t}\n\t\telse{\n\t\t\tshowTopology();\n\t\t}\n\t}\n}\n\n/*function hide_centered_box(id)\n{\n\tvar closediv = document.getElementById(id);\n\tif (closediv != null){\n\t\tclosediv.style.display='none';\n\t}\n\telse{\n\t\tclosediv = parent.document.getElementById(id);\n\t\tif(closediv!=null){\n\t\t\tclosediv.style.display='none';\n\t\t}\n\t}\n}*/\n\nfunction showTopology()\n{\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\n\tvar thiscomptype='';\n\tvar thiscompname='';\n\tif(document.getElementById(\"servertypes\")!=null && document.getElementById(\"servernames\")!=null)\n\t{\n\t\tthiscomptype = document.getElementById(\"servertypes\").value;\n\t\tthiscompname = document.getElementById(\"servernames\").value;\n\t}\n\n\tif(thiscomptype==\"-1\"){\n\t\talert('");
      if (_jspx_meth_egui_005fintnl_005f2(_jspx_page_context))
        return;
      out.write("');\n\t\treturn;\n\t}\n\tif(thiscompname==\"-1\"){\n\t\talert('");
      if (_jspx_meth_egui_005fintnl_005f3(_jspx_page_context))
        return;
      out.write("');\n\t\treturn;\n\t}\n\tvar url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(thissegment)+'&zone='+encodeURI(thiszone)+'&comptype='+encodeURI(thiscomptype)+'&compname='+encodeURI(thiscompname)+\"&action=show\";\n\tdoFunction(url, \"show\");\n}\n\nfunction OpenConnectUsesDiv(link)\n{\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar comptitle = $j(\"#h_title\").attr(\"value\");\n\tvar compsrc = $j(\"#h_src\").attr(\"value\");\n\tvar zoom = $j(\"#zoom\").attr(\"value\");\n\tif(link.length == 0 )\n\t\tlink = 'uses';\n\t$j(\"#lorn\").attr({\"value\" : link});\n\tvar frmcomptype=\"\";\n\tvar frmcompname=comptitle;\n\n\tif(comptitle.indexOf(\":\") < 0)\n\t\tfrmcompname = comptitle+\":NULL\";\n\tif (compsrc.indexOf(\".gif\")>0)\n\t\tfrmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\telse if (compsrc.indexOf(\".png\")>0)\n\t\tfrmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\n\tvar bw = new lib_bwcheck();\n\tvar modify='");
      out.print(modify);
      out.write("';\n\tvar href = \"/final/admin/EgAutoCompTypes.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&link=\"+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+\"&modifySegment=\"+encodeURI(modify);\n\n\tvar connectTitle = '");
      if (_jspx_meth_egui_005fintnl_005f4(_jspx_page_context))
        return;
      out.write("';\n\tif(link == 'connect')\n\t\tconnectTitle = '");
      if (_jspx_meth_egui_005fintnl_005f5(_jspx_page_context))
        return;
      out.write("';\n\twindow.parent.$j(\"#connectTitle\").text(connectTitle);\n\n\tvar maxInd = maxIndex();\n\twindow.parent.$j(\"#connectDiv\").css({\"display\":\"block\" , \"position\":\"absolute\" });\n\twindow.parent.$j(\"#connectDiv\").css({\"z-index\":maxInd+1});\n\twindow.parent.$j(\"#connectDiv\").show('slow');\n\twindow.parent.$j(\"#innerConnectDiv\").load(href);\n\t//$j(\"#menudiv\").hide(\"slow\"); //Close the menu Div..\n}\n\nvar mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {\n    selType: 'checkboxmodel',\n\tmode: 'MULTI',\n\tcheckOnly: true,  \n\trenderer : function(val, meta, record, rowIndex, colIndex, store,view){\n\t\tif( record.get('Checked')== \"checked\")\n\t\t{  \n\t\t\tExt.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);\n\t\t}\n\t\tif( record.get('Disabled')=='disabled')\n\t\t{    \n\t\t\tmeta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';\n\t\t\treturn '<div class=\"' + Ext.baseCSSPrefix + 'grid-row-checker DisableCheckBox\">&#160;</div>';\n\t\t}\n\t\telse\n\t\t{\n\t\t\tmeta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';\n");
      out.write("\t\t\treturn '<div class=\"' + Ext.baseCSSPrefix + 'grid-row-checker\">&#160;</div>';\n\t\t}\n\t},\n\tselectAll: function(){\n       \n        var rowIndex=0;\n        while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {\n            var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);\n            if (record.get('Disabled')=='disabled'){\n                Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);\n            }\n            else {\n                Ext.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);\n            }\n            rowIndex++;\n        }\n\t\tvar view   = Ext.getCmp('gridDisplay').getView();\n\t\tvar headerCt = view.headerCt;\n\t\tvar hdSelectStatus = this.selected.getCount() === this.store.getCount();\n\t\tvar checkHd  = headerCt.child('gridcolumn[isCheckerHd]');\n\t\tif (checkHd) {\n                checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');          \n        }\n    },\n\tdeselectAll: function(){\n       \n        var rowIndex=0;\n        while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {\n");
      out.write("            var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);\n            Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);           \n            rowIndex++;\n        }\n\t\tvar view   = Ext.getCmp('gridDisplay').getView();\n\t\tvar headerCt = view.headerCt;\n\t\tvar hdSelectStatus = this.selected.getCount() === this.store.getCount();\n\t\tvar checkHd  = headerCt.child('gridcolumn[isCheckerHd]');\n\t\tif (checkHd) {            \n             checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');            \n        }\n    }\n});\n/*function OpenUsesDiv()\n{\n\tvar win = Ext.create('Ext.Window', {\n\t\trequires:['Ext.grid.*',\n\t\t\t'Ext.ux.CheckColumn'],\n\t\trenderTo: Ext.getBody(),\n\t\tid : 'usesConnects',\n\t\ttitle: 'Uses',\n\t\twidth: 330,\n\t\theight: 360, \n\t\tx: 40,\n\t\ty: 60,\n\t\tautoScroll: true,\n\t\tmodal: true,\n\t\tcloseAction: 'destroy',\n\t\titems: [\n\t\t\t{\n\t\t\t\txtype: 'container',\n\t\t\t\tlayout: {\n\t\t\t\t\ttype: 'vbox',\n\t\t\t\t\talign: 'center',\n\t\t\t\t\tpack: 'center'\n\t\t\t\t},\n\t\t\t\titems: [\n\t\t\t\t\t{\n\t\t\t\t\t\txtype: 'combobox',\n\t\t\t\t\t\tcls: 'whitedropdown',\n");
      out.write("\t\t\t\t\t\tid:'typeOfComp',\n\t\t\t\t\t\tname:'typeOfComp',\n\t\t\t\t\t\tdisplayField:'displayField',\n\t\t\t\t\t\tvalueField:'valueField',\n\t\t\t\t\t\tqueryMode: 'local',\n\t\t\t\t\t\temptyText:'--Select--',\n\t\t\t\t\t\tparent:this,\n\t\t\t\t\t\tselectOnFocus:true,\n\t\t\t\t\t\tlabelStyle: 'white-space: nowrap;',\n\t\t\t\t\t\t/*store:new Ext.data.Store({\n\t\t\t\t\t\t\tfields: ['displayField','valueField'],\n\t\t\t\t\t\t\tdata: []\n\t\t\t\t\t\t}),*/\n\t\t\t\t\t\t/*store: ['Managed Components','New Components','Unmanaged Components'],\n\t\t\t\t\t\tdefaultValue: 'Managed Components',\n\t\t\t\t\t\tmargin: '10 0 0 0',\n\t\t\t\t\t\twidth:250,\n\t\t\t\t\t\tlisteners: {\n\t\t\t\t\t\t\tselect: function(combo, record, index) {\n\t\t\t\t\t\t\t  loadComponentType(combo.getValue());\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t  }\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\txtype: 'combobox',\n\t\t\t\t\t\tcls: 'whitedropdown',\n\t\t\t\t\t\tid:'compTypeCombo',\n\t\t\t\t\t\tname:'compTypeCombo',\n\t\t\t\t\t\tdisplayField:'displayField',\n\t\t\t\t\t\tvalueField:'valueField',\n\t\t\t\t\t\tqueryMode: 'local',\n\t\t\t\t\t\temptyText:'--Select--',\n\t\t\t\t\t\tparent:this,\n\t\t\t\t\t\tselectOnFocus:true,\n\t\t\t\t\t\tlabelStyle: 'white-space: nowrap;',\n\t\t\t\t\t\tstore:new Ext.data.Store({\n");
      out.write("\t\t\t\t\t\t\tfields: ['displayField','valueField'],\n\t\t\t\t\t\t\tdata: []\n\t\t\t\t\t\t}),\n\t\t\t\t\t\tmargin: '10 0 0 0',\n\t\t\t\t\t\twidth:250,\n\t\t\t\t\t\tlisteners: {\n\t\t\t\t\t\t\tselect: function(combo, record, index) {\n\t\t\t\t\t\t\t  loadComponentNames(combo.getValue());\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\txtype: 'container',\n\t\t\t\t\t\tid: 'NoComponentPresent',\n\t\t\t\t\t\thidden:true,\n\t\t\t\t\t\tlayout: {\n\t\t\t\t\t\t\ttype: 'vbox',\n\t\t\t\t\t\t\tpack: 'center',\n\t\t\t\t\t\t\talign: 'center'\n\t\t\t\t\t\t},\n\t\t\t\t\t\titems: [\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\txtype: 'label',\n\t\t\t\t\t\t\t\thtml: '<table><tr><td align=\"center\" height=\"150\"><table><tr><td align=\"center\"><img src=\"/final/admin/eg_images/exclamation-icon.gif\"></td></tr><tr><td align=\"center\">'+'No Components found!'+'</td></tr></table></td></tr></table>'\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t]\n\t\t\t\t\t},\n\t\t\t\t]\n\t\t\t},\n\t\t\t{\n\t\t\t\txtype: 'container',\n\t\t\t\tlayout: {\n\t\t\t\t\ttype: 'hbox',\n\t\t\t\t\talign: 'center',\n\t\t\t\t\tpack: 'center'\n\t\t\t\t},\n\t\t\t\titems: [\n\t\t\t\t{\n\t\t\t\t\txtype: 'grid',\n\t\t\t\t\tid: 'gridDisplay',\n\t\t\t\t\t//hidden:true,\n\t\t\t\t\tstore:new Ext.data.Store(\n\t\t\t\t\t{\n\t\t\t\t\t\tfields: ['Checked','Disabled','CheckboxValue','isZoneComp','isGroupType','isGroupName','Componentname'],\n");
      out.write("\t\t\t\t\t\t data:[]\n\t\t\t\t\t}),\n\t\t\t\t\t/*selModel: {\n\t\t\t\t\t\tselType: 'checkboxmodel',\n\t\t\t\t\t\tmode: 'MULTI',\n\t\t\t\t\t\tcheckOnly: true\n\t\t\t\t\t},*/\n\t\t\t\t\t/*selModel:mySelectionModel,\n\t\t\t\t\tlisteners : {\n\t\t\t\t\t\tbeforeselect: function(selModel, record, index) {\n\t\t\t\t\t\t\tif (record.get('Disabled')=='disabled') {\n\t\t\t\t\t\t\t\t return false;  \n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\trowclick : function (in_this, rowIndex, e) {\n\t\t\t\t\t\t\tvar record = in_this.getStore().getAt(rowIndex);\n\t\t\t\t\t\t\tif (record.get('Disabled')=='disabled'){\n\t\t\t\t\t\t\t\tin_this.getSelectionModel().deselectRow(rowIndex);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\tselectionchange : function()\n\t\t\t\t\t\t{\n\t\t\t\t\t\t\t//var selectedRows = Ext.getCmp('gridDisplay').getSelectionModel().getStore().getAt(index);\n\t\t\t\t\t\t\t//var CheckboxValue = record.get('CheckboxValue');\n\t\t\t\t\t\t\t//var isChecked = Ext.getCmp('gridDisplay').getSelectionModel().isChecked();\n\t\t\t\t\t\t\t//alert(selectedRows);\n\t\t\t\t\t\t\t//\n\n\t\t\t\t\t\t\tvar store = Ext.getCmp('gridDisplay').getStore();\n\t\t\t\t\t\t\tvar selModel = Ext.getCmp('gridDisplay').getSelectionModel();\n\t\t\t\t\t\t\tvar selectedRecord = selModel.getSelection();\n");
      out.write("\t\t\t\t\t\t\tfor (var i=0; i<=selectedRecord.length-1; i++) {\n\t\t\t\t\t\t\t\t//alert(selectedRecord[i].get('CheckboxValue'));\n\t\t\t\t\t\t\t\taddOrRemoveComponents(selectedRecord[i].get('CheckboxValue'),'');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t//addOrRemoveComponents(CheckboxValue,isChecked);\n\n\t\t\t\t\t\t\t/*var store = Ext.getCmp('gridDisplay').getStore();\n\t\t\t\t\t\t\tvar selModel = Ext.getCmp('gridDisplay').getSelectionModel();\n\t\t\t\t\t\t\tvar selectedRecord = selModel.getLastSelected();\n\t\t\t\t\t\t\talert(\"SelectedRecord >>> \"+selectedRecord.get('CheckboxValue'));\n\t\t\t\t\t\t\tvar recordIndex = store.indexOf(selectedRecord);\n\t\t\t\t\t\t\t*/\n\t\t\t\t\t\t\t\n\t\t\t\t\t/*\t},\n\t\t\t\t\t\tdeselectAll: function(){\n\t\t\t\t\t\t\talert(\"deselectall\");\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\t\t\t\t\tautoScroll: true,\n\t\t\t\t\tmargin: '10 0 0 0',\n\t\t\t\t\tcolumns: {\n\t\t\t\t\t\tdefaults: {\n\t\t\t\t\t\t\tsortable: true,\n\t\t\t\t\t\t\thideable: false,\n\t\t\t\t\t\t\tmenuDisabled: true,\n\t\t\t\t\t\t\tdraggable: false,\n\t\t\t\t\t\t\tresizable: false\n\t\t\t\t\t\t},\n\t\t\t\t\t\titems: [\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\ttext: 'List of components',\n\t\t\t\t\t\t\t\tdataIndex: 'Componentname',\n\t\t\t\t\t\t\t\tid: 'DispComponentname',\n\t\t\t\t\t\t\t\twidth:300\n");
      out.write("\t\t\t\t\t\t\t}\n\t\t\t\t\t\t]\n\t\t\t\t\t}\n\t\t\t\t}]\n\t\t\t}\n\t\t]\n\t}); \n\twin.show();\n\tExt.getCmp('typeOfComp').setValue('Managed Components');\n\tloadComponentType('Managed Components');\n}*/\nfunction OpenUsesDivForParam()\n{\n\tvar link = 'uses';\n\tvar thiszone = document.getElementById('zone').value;\t\t//$j(\"#zone\").attr(\"value\");\n\tvar thissegment = document.getElementById('segment').value; //$j(\"#segment\").attr(\"value\");\n\tvar comptitle = document.getElementById('h_title').value;\t//$j(\"#h_title\").attr(\"value\");\n\tvar compsrc = document.getElementById('h_src').value;\t\t//$j(\"#h_src\").attr(\"value\");\n\tvar zoom = document.getElementById('zoom').value;\t\t\t//$j(\"#zoom\").attr(\"value\");\n\tif(link.length == 0 )\n\t\tlink = 'uses';\n\t//$j(\"#lorn\").attr({\"value\" : link});\n\tdocument.getElementById('lorn').value= link;\n\tvar frmcomptype=\"\";\n\tvar frmcompname=comptitle;\n\n\tif(comptitle.indexOf(\":\") < 0)\n\t\tfrmcompname = comptitle+\":NULL\";\n\t//if (compsrc.indexOf(\".gif\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\t//else if (compsrc.indexOf(\".png\")>0)\n");
      out.write("\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\tfrmcomptype=compsrc;\n\tvar modify='");
      out.print(modify);
      out.write("';\n\tvar href = \"segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&link=\"+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+\"&modifySegment=\"+encodeURI(modify);\n\twindow.parent.OpenUsesDiv(href,'Uses');\n}\n\nfunction OpenConnectsDivForParam()\n{\n\t\n\tvar link = 'connect';\n\tvar thiszone = document.getElementById('zone').value;\t\t//$j(\"#zone\").attr(\"value\");\n\tvar thissegment = document.getElementById('segment').value; //$j(\"#segment\").attr(\"value\");\n\tvar comptitle = document.getElementById('h_title').value;\t//$j(\"#h_title\").attr(\"value\");\n\tvar compsrc = document.getElementById('h_src').value;\t\t//$j(\"#h_src\").attr(\"value\");\n\tvar zoom = document.getElementById('zoom').value;\t\t\t//$j(\"#zoom\").attr(\"value\");\n\tif(link.length == 0 )\n\t\tlink = 'connect';\n\t//$j(\"#lorn\").attr({\"value\" : link});\n\tdocument.getElementById('lorn').value= link;\n\tvar frmcomptype=\"\";\n\tvar frmcompname=comptitle;\n\n\tif(comptitle.indexOf(\":\") < 0)\n\t\tfrmcompname = comptitle+\":NULL\";\n");
      out.write("\t//if (compsrc.indexOf(\".gif\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\t//else if (compsrc.indexOf(\".png\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\t\tfrmcomptype=compsrc;\n\tvar modify='");
      out.print(modify);
      out.write("';\n//\tvar href = \"segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&link=\"+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+\"&modifySegment=\"+encodeURI(modify);\nvar href = \"zone=\"+encodeURI(thiszone)+\"&link=\"+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+\"&modifySegment=\"+encodeURI(modify);\n\t\n\twindow.parent.OpenUsesDiv(href,'Connects');\n}\n\nfunction MyRemoveFunction()\n{\n\tvar myServletUrl = getServletUrl('remove');\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar zoomValue = $j(\"#zoom\").attr(\"value\");\n\tvar modify=\"");
      out.print(modify);
      out.write("\";\n\tvar myJspUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+encodeURI(zoomValue)+\"&modify=\"+encodeURI(modify);\n\twindow.parent.RemoveFunction(myServletUrl,myJspUrl);\n}\n\nfunction OpenManageSingleDiv()\n{\n\t/*var thissegment = $j(\"#segment\").attr(\"value\");\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\n\tvar urlToDisplay ='';\n\tvar comptitle = $j(\"#h_title\").attr(\"value\");\n\tvar compsrc = $j(\"#h_src\").attr(\"value\");\n\tvar compstatus = $j(\"#h_status\").attr(\"value\"); \n\tvar servertype='';\n\tif (compsrc.indexOf(\".gif\")>0)\n\t\tservertype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\telse if (compsrc.indexOf(\".png\")>0)\n\t\tservertype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\tvar urlToDisplay = \"EgNewServer.jsp?server=new&compstatus=\"+ encodeURI(compstatus)+\"&serverType=\"+encodeURI(servertype)+\"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&comptitle=\"+encodeURI(comptitle)+\"&topoSegName=\"+encodeURI(thissegment);*/\n");
      out.write("\twindow.parent.OpenManageDiv();\n}\nfunction unGroupFunction()\n{\n\tvar mode = 'delete';\n\tvar thistitle = $j(\"#h_title\").attr(\"value\");\n\t//var thiszone= $j(\"#zone\").attr(\"value\");\n\tvar thiszone=\"-1\";\n\tvar fromPage = 'autoMainPage';\n\tvar zoneString = $j(\"#zoneString\").attr(\"value\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar zoomValue = $j(\"#zoom\").attr(\"value\");\n\tvar modify=\"");
      out.print(modify);
      out.write("\";\n\n//\tvar url = '/final/admin/Egconfiggroupp.jsp?mode='+encodeURI(mode)+'&deleteGroups='+encodeURI(thistitle)+'&thiszone='+encodeURI(thiszone)+'&fromPage='+encodeURI(fromPage)+'&zoneString='+encodeURI(zoneString);\nvar url = '/final/admin/Egconfiggroupp.jsp?mode='+encodeURI(mode)+'&deleteGroups='+encodeURI(thistitle)+'&thiszone='+encodeURI(thiszone)+'&fromPage='+encodeURI(fromPage)+'&zoneString='+encodeURI(zoneString)+'&segment='+encodeURI(thissegment);\n\tvar httpObj = parent.createRequestObject();\n\tvar params = \"\";\n\tvar tempurl = \"\";\n\tif (url.indexOf(\"?\") > -1){\n\t\tparams=url.substring(url.indexOf(\"?\")+1);\n\t\ttempurl=url.substring(0,url.indexOf(\"?\"));\n\t}\n\telse{\n\t\ttempurl=url;\n\t}\n\thttpObj.open('POST',tempurl,true);\n\thttpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');\n\t//httpObj.setRequestHeader('Content-length',params.length);\n\t//httpObj.setRequestHeader('Connection','close');\n\thttpObj.onreadystatechange = function() {\n\t\tif (httpObj.readyState == 4 && httpObj.status == 200)\n\t\t{\n\t\t\tvar myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+encodeURI(zoomValue)+\"&modify=\"+encodeURI(modify);\n");
      out.write("\t\t\twindow.parent.UnGroupFunction(myUrl);\n\t\t}\n\t}\n\thttpObj.send(params);\n}\n\nfunction loadComponentType(comboValue)\n{\n\t\n\tvar link = 'uses';\n\tvar choice='';\n\tif(comboValue=='Managed Components')\n\t\tchoice = 'managedComp';\n\telse if(comboValue=='New Components')\n\t\tchoice = 'newComp';\n\telse if(comboValue=='Unmanaged Components')\n\t\tchoice = 'unManagedComp';\n\n\tvar thiszone = document.getElementById('zone').value;\t\t//$j(\"#zone\").attr(\"value\");\n\tvar thissegment = document.getElementById('segment').value; //$j(\"#segment\").attr(\"value\");\n\tvar comptitle = document.getElementById('h_title').value;\t//$j(\"#h_title\").attr(\"value\");\n\tvar compsrc = document.getElementById('h_src').value;\t\t//$j(\"#h_src\").attr(\"value\");\n\tvar zoom = document.getElementById('zoom').value;\t\t\t//$j(\"#zoom\").attr(\"value\");\n\tif(link.length == 0 )\n\t\tlink = 'uses';\n\t//$j(\"#lorn\").attr({\"value\" : link});\n\tdocument.getElementById('lorn').value= link;\n\tvar frmcomptype=\"\";\n\tvar frmcompname=comptitle;\n\n\tif(comptitle.indexOf(\":\") < 0)\n\t\tfrmcompname = comptitle+\":NULL\";\n");
      out.write("\t//if (compsrc.indexOf(\".gif\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\t//else if (compsrc.indexOf(\".png\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\tfrmcomptype = compsrc;\n\tvar bw = new lib_bwcheck();\n\tvar modify='");
      out.print(modify);
      out.write("';\n\tvar href = \"AutoTopology/data/MainPageCompTypesJson.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&link=\"+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+\"&modifySegment=\"+encodeURI(modify)+\"&choice=\"+choice;\n\tExt.Ajax.request({\n\t\t\turl: href,\n\t\t\tmethod: 'POST',\n\t\t\tasync: false,\n\t\t\tsuccess: function( response )\n\t\t\t{\n\t\t\t\tif ( response.status == 200 && !Ext.isEmpty( response.responseText ))\n\t\t\t\t{\n\t\t\t\t\tvar jsonText = response.responseText;\n\t\t\t\t\tvar mypublicJSON = Ext.decode( jsonText );\n\t\t\t\t\tvar count = mypublicJSON['Total'];\n\t\t\t\t\tif(count == 0)\n\t\t\t\t\t{\n\t\t\t\t\t\tExt.getCmp('NoComponentPresent').show();\n\t\t\t\t\t\tExt.getCmp('compTypeCombo').hide();\n\t\t\t\t\t\tExt.getCmp('gridDisplay').hide();\n\t\t\t\t\t}\n\t\t\t\t\telse\n\t\t\t\t\t{\n\t\t\t\t\t\tExt.getCmp('NoComponentPresent').hide();\n\t\t\t\t\t\tExt.getCmp('compTypeCombo').show();\n\t\t\t\t\t\tExt.getCmp('gridDisplay').show();\n\t\t\t\t\t}\n\t\t\t\t\tExt.getCmp('compTypeCombo').getStore().loadRawData(mypublicJSON['ComponentTypes']);\n");
      out.write("\t\t\t\t\tExt.getCmp('compTypeCombo').setValue(mypublicJSON['SelectedCompType']);\n\t\t\t\t\tloadComponentNames(mypublicJSON['SelectedCompType']);\n\t\t\t\t}\n\t\t\t}\n\t});\n}\nfunction loadComponentNames(comboValue)\n{\n\tvar thiszone = document.getElementById('zone').value;\n\tvar thissegment = document.getElementById('segment').value;\n\tvar comptitle = document.getElementById('h_title').value;\n\tvar compsrc = document.getElementById('h_src').value;\t\n\tvar choiceValue = Ext.getCmp('typeOfComp').getValue();\n\tvar choice='';\n\tif(choiceValue=='Managed Components')\n\t\tchoice = 'managedComp';\n\telse if(choiceValue=='New Components')\n\t\tchoice = 'newComp';\n\telse if(choiceValue=='Unmanaged Components')\n\t\tchoice = 'unManagedComp';\n\n\tvar frmcomptype=\"\";\n\tvar frmcompname=comptitle;\n\n\tif(comptitle.indexOf(\":\") < 0)\n\t\tfrmcompname = comptitle+\":NULL\";\n\t//if (compsrc.indexOf(\".gif\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\t//else if (compsrc.indexOf(\".png\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n");
      out.write("\tfrmcomptype = compsrc;\n\tvar url = 'Segment/data/EgAutoCompNamesJson.jsp?comptype='+encodeURI(comboValue)+\"&zone=\"+encodeURI(thiszone)+\"&segment=\"+encodeURI(thissegment)+\"&choice=\"+encodeURI(choice)+\"&frmcomptype=\"+encodeURI(frmcomptype)+\"&frmcompname=\"+encodeURI(frmcompname);\n\tExt.Ajax.request({\n\t\t\turl: url,\n\t\t\tmethod: 'POST',\n\t\t\tasync: false,\n\t\t\tsuccess: function( response )\n\t\t\t{\n\t\t\t\tif ( response.status == 200 && !Ext.isEmpty( response.responseText ))\n\t\t\t\t{\n\t\t\t\t\tvar jsonText = response.responseText;\n\t\t\t\t\tvar mypublicJSON = Ext.decode( jsonText );\n\t\t\t\t\tExt.getCmp('gridDisplay').getStore().loadRawData(mypublicJSON['CompNameGridValues']);\n\t\t\t\t}\n\t\t\t}\n\t});\n}\nfunction addOrRemoveComponents(cbValue,isChecked)\n{\n\t\n\tvar thissegment = document.getElementById(\"segment\").value;\n\tvar thiszone= document.getElementById(\"zone\").value;\n\tvar comptitle = document.getElementById('h_title').value;\n\tvar compsrc = document.getElementById('h_src').value;\t\n\tvar thiscomptype = Ext.getCmp('compTypeCombo').getValue();\n\tvar thiscompname = cbValue;\n");
      out.write("\tvar link = 'uses';\n\tvar frmcomptype=\"\";\n\tvar frmcompname=comptitle;\n\n\tif(comptitle.indexOf(\":\") < 0)\n\t\tfrmcompname = comptitle+\":NULL\";\n\t//if (compsrc.indexOf(\".gif\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\t//else if (compsrc.indexOf(\".png\")>0)\n\t\t//frmcomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\t\tfrmcomptype = compsrc;\n\tvar action = 'addlink';\n\t/*if(isChecked){\n\t\taction = 'addlink';\n\t}\n\telse{\n\t\taction = 'removelink';\n\t}*/\n\tvar url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(thissegment)+'&zone='+encodeURI(thiszone)+'&comptype='+encodeURI(thiscomptype)+'&compname='+encodeURI(thiscompname)+'&link='+encodeURI(link)+'&action='+encodeURI(action)+\"&frmcompname=\"+encodeURI(frmcompname)+\"&frmcomptype=\"+encodeURI(frmcomptype);\n\t//loadPage(url, null, action);\n\tExt.Ajax.request({\n\t\t\turl: url,\n\t\t\tmethod: 'POST',\n\t\t\tasync: false,\n\t\t\tsuccess: function( response )\n\t\t\t{\n\t\t\t\tif ( response.status == 200)\n\t\t\t\t{\n\t\t\t\t\tvar zoom = '100';\n");
      out.write("\t\t\t\t\tvar myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment) +\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+encodeURI(zoom)+\"&hlcomp=\"+encodeURI(frmcompname)+\"&hlcomptype=\"+encodeURI(frmcomptype)+\"&modify=false\"+\"&fromAutoCompType=true\";\n\t\t\t\t\twindow.parent.refreshTopologyDiv(myUrl);\n\t\t\t\t\t/*Ext.getCmp('topologyPanel').setVisible(true);\n\t\t\t\t\tExt.getCmp('topologyFrame').setVisible(true);\n\t\t\t\t\tExt.getCmp('topologyFrame').update('<iframe src=\"' + myUrl+ '\" style=\"width:945px\" height=\"600\"></iframe>');*/\n\t\t\t\t}\n\t\t\t}\n\t});\n}\n\nfunction getServletUrl(action)\n{\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(thissegment)+'&zone='+encodeURI(thiszone);\n\tif(action == 'clearall'){\n\t\turl = url + \"&action=\"+encodeURI(action);\n\t}\n\telse{\n\t\tvar comptitle = $j(\"#h_title\").attr(\"value\");\n\t\tvar compsrc = $j(\"#h_src\").attr(\"value\");\n\t\tvar thiscomptype = compsrc;\n\t\tvar thiscompname = comptitle;\n");
      out.write("\t\tif(comptitle.indexOf(\":\") < 0)\n\t\t\tthiscompname = thiscompname+\":NULL\";\n\t\t//if (compsrc.indexOf(\".gif\")>0)\n\t\t\t//thiscomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\t\t//else if (compsrc.indexOf(\".png\")>0)\n\t\t\t//thiscomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\t\tthiscomptype = compsrc;\n\t\turl = url + '&comptype='+encodeURI(thiscomptype)+'&compname='+encodeURI(thiscompname)+\"&action=\"+encodeURI(action);\n\t}\n\treturn url;\n}\n\nfunction doFunction(url, action)\n{\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar thiscomptype='';\n\tvar thiscompname='';\n\tif(document.getElementById(\"servertypes\")!=null && document.getElementById(\"servernames\")!=null)\n\t{\n\t\tthiscomptype = document.getElementById(\"servertypes\").value;\n\t\tthiscompname = document.getElementById(\"servernames\").value;\n\t}\n\tvar zoomValue = $j(\"#zoom\").attr(\"value\");\n\tvar enableDrag = '';\n\tif($j('#dragCheckbx').is(':checked'))\n\t{\n\t\tenableDrag = 'true';\n");
      out.write("\t}\n\telse\n\t{\n\t\tenableDrag = 'false';\n\t}\n\tvar modify=\"");
      out.print(modify);
      out.write("\";\n\n\tvar httpObj = parent.createRequestObject();\n\tvar params = \"\";\n\tvar tempurl = \"\";\n\tif (url.indexOf(\"?\") > -1){\n\t\tparams=url.substring(url.indexOf(\"?\")+1);\n\t\ttempurl=url.substring(0,url.indexOf(\"?\"));\n\t}\n\telse{\n\t\ttempurl=url;\n\t}\n\thttpObj.open('POST',tempurl,true);\n\thttpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');\n\thttpObj.setRequestHeader('Content-length',params.length);\n\thttpObj.setRequestHeader('Connection','close');\n\thttpObj.onreadystatechange = function() {\n\t\tif (httpObj.readyState == 4 && httpObj.status == 200)\n\t\t{\n\t\t\tvar myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+encodeURI(zoomValue)+\"&enableDrag=\"+encodeURI(enableDrag)+\"&modify=\"+encodeURI(modify);\n\t\t\tif(action == 'show'){\n\t\t\t\tmyUrl = myUrl + \"&comptype=\"+encodeURI(thiscomptype) + \"&compname=\"+encodeURI(thiscompname);\n\t\t\t}\n\t\t\tsetTimeout(function(){window.location = myUrl;}, 0);\n\t\t}\n\t}\n\thttpObj.send(params);\n}\n\n// Set height and width based on window screen size\n");
      out.write("documentView ={\n\t\tgetObject: function(){\n\t\t\tif(typeof( window.innerWidth) == 'number'){//Firefox\n\t\t\t\tthis.height = window.innerHeight;\n\t\t\t\tthis.width = window.innerWidth;\n\t\t\t\tthis.fireFox = true;\n\t\t\t}\n\t\t\telse if( document.documentElement && ( document.documentElement.clientWidth\n\t\t\t\t|| document.documentElement.clientHeight )){//IE 6 + in 'standards compliant mode'\n\t\t\t\tthis.height = document.documentElement.clientHeight;\n\t\t\t\tthis.width = document.documentElement.clientWidth;\n\t\t\t\tthis.ie = true;\n\t\t\t}\n\t\t\telse if(document.body && document.body.clientHeight){ //IE 4 compatible\n\t\t\t\tthis.height = document.body.clientHeight;\n\t\t\t\tthis.width = document.body.clientWidth;\n\t\t\t\tthis.ie = true;\n\t\t\t}\n\t\t\treturn this;\n\t\t},\n\t\tgetHeight: function(){\n\t\t\treturn this.getObject().height;\n\t\t},\n\t\tgetWidth: function(){\n\t\t\treturn this.getObject().width;\n\t\t},\n\t\tisIE: function(){\n\t\t\t\treturn this.getObject().ie;\n\t\t},\n\t\tisFireFox: function(){\n\t\t\t\treturn this.getObject().fireFox;\n\t\t}\n};\n\nfunction pageHeightWidth()\n{\n\tvar containerDiv = document.getElementById(\"container\");\n");
      out.write("\tif (containerDiv!=null){\n\t\t//containerDiv.style.height = documentView.getHeight()- 60;\n\t\t//containerDiv.style.width = documentView.getWidth()- 8;\n\t\tif('");
      out.print(isFull);
      out.write("' == 'true')\n\t\t{\n\t\t\t$j(\"#container\").height(documentView.getHeight()- 10);\n\t\t\t$j(\"#container\").width(documentView.getWidth()- 0);\n\t\t}\n\t\telse if('");
      out.print(isFull);
      out.write("' == 'false')\n\t\t{\n\t\t\t//$j(\"#container\").height(documentView.getHeight()- 60);\n\t\t\t$j(\"#container\").height(documentView.getHeight());\n\t\t\t$j(\"#container\").width(documentView.getWidth()- 0);\n\t\t}\n\t}\n\tvar toolBoxOnOff = parent.document.getElementById(\"toolBoxOnOff\");\n\tif(toolBoxOnOff!=null){\n\t\tvar onoffval = toolBoxOnOff.value;\n\t\tif(onoffval == 'on'){\n\t\t\tshowToolsDiv();\n\t\t}\n\t}\n\n}\n\nwindow.onresize=pageHeightWidth;\n\nfunction overImage(obj){\n\tobj.className=\"tree_over_border tree_font\";\n}\n\nfunction outImage(obj){\n\tobj.className=\"eg_whitebg tree_font\";\n}\n\nfunction ShowGroupDetails()\n{\n\t/*var thistitle = $j(\"#h_title\").attr(\"value\"); // GroupName\n\tvar href = 'EgTopologyGroupPage.jsp?title='+thistitle;\n\tvar maxInd = maxIndex();\n\twindow.parent.$j(\"#groupDiv\").css({\"display\":\"block\" , \"position\":\"absolute\" });\n\twindow.parent.$j(\"#groupDiv\").css({\"z-index\":maxInd+1});\n\twindow.parent.$j(\"#groupDiv\").show('slow');\n\twindow.parent.$j('#innerGroupDiv').load(href);\n\t$j(\"#menudiv\").hide(\"slow\"); //Close the menu Div..*/\n\t\n\t/*var thistitle = document.getElementById('h_title').value;\n");
      out.write("\tvar win = Ext.create('Ext.Window', {\n\t\trequires:['Ext.grid.*'],\n\t\trenderTo: Ext.getBody(),\n\t\tid : 'groupdetails',\n\t\ttitle: 'Group Details',\n\t\twidth: 500,\n\t\theight: 300, \n\t\tx: 40,\n\t\ty: 60,\n\t\tautoScroll: true,\n\t\tmodal: true,\n\t\tcloseAction: 'destroy',\n\t\titems: [\n\t\t\t{\n\t\t\t\txtype: 'component',\n\t\t\t\thtml: '<center><img src=\"/final/admin/eg_images/info2.gif\" valign=\"middle\">&nbsp&nbsp'+'Hosts associated with '+thistitle+'</center>',\n\t\t\t\tstyle: {\n\t\t\t\t\tbackground: '#f3f5fa',\n\t\t\t\t\tfontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',\n\t\t\t\t\tfontSize: '9px'\n\t\t\t\t},\n\t\t\t\theight: 25,\n\t\t\t\tpadding: 5\n\t\t\t},\n\t\t\t{\n\t\t\t\txtype: 'container',\n\t\t\t\tlayout: {\n\t\t\t\t\ttype: 'hbox',\n\t\t\t\t\talign: 'center',\n\t\t\t\t\tpack: 'center'\n\t\t\t\t},\n\t\t\t\titems: [\n\t\t\t\t{\n\t\t\t\t\txtype: 'grid',\n\t\t\t\t\tid: 'gridDisplay',\n\t\t\t\t\tstore:new Ext.data.Store(\n\t\t\t\t\t{\n\t\t\t\t\t\tfields: ['Hostname','Portno','Componenttype'],\n\t\t\t\t\t\t data:[]\n\t\t\t\t\t}),\n\t\t\t\t\tautoScroll: true,\n\t\t\t\t\tmargin: '10 0 0 10',\n\t\t\t\t\tcolumns: {\n\t\t\t\t\t\tdefaults: {\n\t\t\t\t\t\t\tsortable: true,\n\t\t\t\t\t\t\thideable: false,\n\t\t\t\t\t\t\tmenuDisabled: true,\n");
      out.write("\t\t\t\t\t\t\tdraggable: false,\n\t\t\t\t\t\t\tresizable: false\n\t\t\t\t\t\t},\n\t\t\t\t\t\titems: [\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\ttext: 'Host / nick name',\n\t\t\t\t\t\t\t\tdataIndex: 'Hostname',\n\t\t\t\t\t\t\t\tid: 'DispHostname',\n\t\t\t\t\t\t\t\twidth: 100\n\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\ttext: 'Port',\n\t\t\t\t\t\t\t\tdataIndex: 'Portno',\n\t\t\t\t\t\t\t\tid: 'DispPortno',\n\t\t\t\t\t\t\t\tflex:1\n\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\ttext: 'Component type',\n\t\t\t\t\t\t\t\tdataIndex: 'Componenttype',\n\t\t\t\t\t\t\t\tid: 'DispComponenttype',\n\t\t\t\t\t\t\t\twidth:300\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t]\n\t\t\t\t\t}\n\t\t\t\t}]\n\t\t\t}\n\t\t]\n\t}); \n\twin.show();\n\tvar url = 'Segment/data/EgTopologyGroupPageJson.jsp?title='+thistitle;\n\t\tExt.Ajax.request({\n\t\t\turl: url,\n\t\t\tmethod: 'POST',\n\t\t\tasync: false,\n\t\t\tsuccess: function( response )\n\t\t\t{\n\t\t\t\tif ( response.status == 200 && !Ext.isEmpty( response.responseText ))\n\t\t\t\t{\n\t\t\t\t\tvar jsonText = response.responseText;\n\t\t\t\t\tvar mypublicJSON = Ext.decode( jsonText );\n\t\t\t\t\tExt.getCmp('gridDisplay').show();\n\t\t\t\t\tExt.getCmp('gridDisplay').getStore().loadRawData(mypublicJSON['GroupDetails']);\n\t\t\t\t}\n\t\t\t}\n\t\t});*/\n\tvar thistitle = document.getElementById('h_title').value;\n");
      out.write("\twindow.parent.showGroupDetails(thistitle);\n}\n\nfunction createGroup()\n{\n\tvar thistitle = $j(\"#h_title\").attr(\"value\");\n\tvar compsrc = $j(\"#h_src\").attr(\"value\");\n\tvar segment = $j(\"#segment\").attr(\"value\");\n\t//var zone = $j(\"#zone\").attr(\"value\");\n\tvar zone=\"-1\";\n\tvar src = compsrc;\n\tvar compstatus = $j(\"#h_status\").attr(\"value\"); \n\tvar zoomValue = $j(\"#zoom\").attr(\"value\");\n\tvar modify = '");
      out.print(modify);
      out.write("';\n\n\t//if (compsrc.indexOf(\".gif\")>0)\n\t\t//src = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\t//else if (compsrc.indexOf(\".png\")>0)\n\t\t//src = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\t\tzone=\"-1\";\n\tvar href = 'thiscomp='+encodeURI(thistitle)+'&src='+encodeURI(src)+'&segment='+encodeURI(segment)+'&zone='+encodeURI(zone)+'&status='+encodeURI(compstatus)+'&fromPage='+'automainPage'+'&zoom='+encodeURI(zoomValue)+\"&modify=\"+encodeURI(modify);\n\twindow.parent.CreateGroup(href);\n\t/*var maxInd = maxIndex();\n\twindow.parent.$j('#innerGroupDiv').html(\"\");\n\tvar divId = window.parent.document.getElementById(\"innerGroupDiv\");\n\tdivId.innerHTML = \"<table width='100%' border='0' bgcolor='white' height='300px'><tr><td align=center valign=bottom><img src=/final/admin/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top></td></tr></table>\";\n\twindow.parent.$j(\"#groupDiv\").css({\"display\":\"block\" , \"position\":\"absolute\" });\n\twindow.parent.$j(\"#groupDiv\").css({\"z-index\":maxInd+1});\n");
      out.write("\twindow.parent.$j(\"#groupDiv\").show('slow');\n\twindow.parent.$j('#innerGroupDiv').load(href);\n\t$j(\"#menudiv\").hide(\"slow\"); //Close the menu Div..*/\n}\n\nfunction maxIndex()\n{\n\tvar index_highest = 0;\n\t$j('div').each(function(){\n\t\tvar index_current = parseInt($j(this).css(\"z-index\"), 10);\n\t\tif(index_current > index_highest) {\n\t\t\tindex_highest = index_current;\n\t\t}\n\t});\n\treturn index_highest.toString();\n}\n\n/*function showComponentsFromThis(comptitle , compsrc)\n{\n\tvar thiscomptype = compsrc;\n\tvar thiscompname = comptitle;\n\n\tif(comptitle.indexOf(\":\") < 0)\n\t\tthiscompname = thiscompname+\":NULL\";\n\tif (compsrc.indexOf(\".gif\")>0)\n\t\tthiscomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\telse if (compsrc.indexOf(\".png\")>0)\n\t\tthiscomptype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\n\tvar thiszone= document.getElementById(\"zone\").value;\n\tvar thissegment = document.getElementById(\"segment\").value;\n\n\tvar guideDiv = parent.document.getElementById(\"guideDiv\");\n\tvar guideFrame = parent.document.getElementById(\"guideFrame\");\n");
      out.write("\tvar bw = new lib_bwcheck();\n\tvar href = \"EgTopologyHelp.jsp?comptype=\"+encodeURI(thiscomptype)+\"&compname=\"+encodeURI(thiscompname)+\"&segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone);\n\t//var menuDiv = document.getElementById(\"menudiv\");\n\tif(guideDiv!=null)\n\t{\n\t\tguideFrame.src = href;\n\t\tguideDiv.style.textAlign = 'right';\n\t\tguideDiv.style.padding = '0px';\n\t\tguideDiv.style.padding = '0px';\n\t\tguideDiv.style.display = 'block';\n\t\tguideDiv.style.position = 'absolute';\n\t\tbringToFront(guideDiv);\n\t\t//hide_centered_box('menudiv');\t\t//Close the menu Div..\n\t}\n}*/\n\nfunction showToolsDiv()\n{\n\tvar toolsDiv = document.getElementById(\"toolsDiv\");\n\tvar toolBoxOnOff = parent.document.getElementById(\"toolBoxOnOff\");\n\tif(toolsDiv!=null)\n\t{\n\t\tif(toolsDiv.style.display == 'block')\n\t\t{\n\t\t\ttoolsDiv.style.display = \"none\";\n\t\t\t$j(\"#toolsDiv\").hide(\"slow\");\n\t\t\ttoolBoxOnOff.value=\"off\";\n\t\t}\n\t\telse\n\t\t{\n\t\t\ttoolsDiv.style.display = 'block';\n\t\t\ttoolsDiv.style.position = 'absolute';\n\t\t\tbringToFront(toolsDiv);\n\t\t\ttoolBoxOnOff.value = \"on\";\n");
      out.write("\t\t}\n\t\t$j(\"#menudiv\").hide(\"slow\");\n\t\talignToolsDiv('#toolsDiv');\n\t}\n}\n\nfunction OpenManageAllDiv(val)\n{\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\t\n\tvar enableDrag = '';\n\tif($j('#dragCheckbx').is(':checked'))\n\t{\n\t\tenableDrag = 'true';\n\t}\n\telse\n\t{\n\t\tenableDrag = 'false';\n\t}\n\n\tvar title = '");
      if (_jspx_meth_egui_005fintnl_005f6(_jspx_page_context))
        return;
      out.write("';\n\tif(val == 'save')\n\t\ttitle = '");
      if (_jspx_meth_egui_005fintnl_005f7(_jspx_page_context))
        return;
      out.write("';\n\tif(val == 'saveAs')\n\t\ttitle = '");
      if (_jspx_meth_egui_005fintnl_005f8(_jspx_page_context))
        return;
      out.write("';\n\n\twindow.parent.$j(\"#manageAllDivTitle\").text(title);\n\tvar urlToDisplay ='';\n\tif(val == 'all'){\n\t\turlToDisplay =\"EgAutoManagePage.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&enableDrag=\"+encodeURI(enableDrag);\n\t}\n\telse if(val == 'save'){\n\t\turlToDisplay =\"EgAutoManagePage.jsp?segment=\"+encodeURI(thissegment)+\"&action=\"+val+\"&zone=\"+encodeURI(thiszone)+\"&enableDrag=\"+encodeURI(enableDrag);\n\t}\n\telse if(val== 'saveAs')\n\t{\n\t\turlToDisplay =\"EgAutoManagePage.jsp?segment=\"+encodeURI(thissegment)+\"&action=\"+val+\"&zone=\"+encodeURI(thiszone)+\"&enableDrag=\"+encodeURI(enableDrag);\n\t\t//return;\n\t}\n\n\tvar maxInd = maxIndex();\n\twindow.parent.$j(\"#manageAllDiv\").css({\"display\":\"block\" , \"position\":\"absolute\" });\n\twindow.parent.$j(\"#manageAllDiv\").css({\"z-index\":maxInd+1});\n\twindow.parent.$j(\"#manageAllDiv\").show('slow');\n\twindow.parent.$j('#innerManageAllDiv').load(urlToDisplay);\n\t$j(\"#menudiv\").hide(\"slow\"); //Close the menu Div..\n}\n\nfunction OpenManageDiv(val)\n{\n\t//var manageDiv = parent.document.getElementById(\"manageDiv\");\n");
      out.write("\tvar manageFrame = parent.document.getElementById(\"manageFrame\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar thiszone = $j(\"#zone\").attr(\"value\");\n\n\t//var bw = new lib_bwcheck();\n\tvar urlToDisplay ='';\n\tif(val == 'single'){\n\t\tvar comptitle = $j(\"#h_title\").attr(\"value\");\n\t\tvar compsrc = $j(\"#h_src\").attr(\"value\");\n\t\tvar compstatus = $j(\"#h_status\").attr(\"value\"); \n\t\tvar servertype='';\n\t\tif (compsrc.indexOf(\".gif\")>0)\n\t\t\tservertype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".gif\"));\n\t\telse if (compsrc.indexOf(\".png\")>0)\n\t\t\tservertype = compsrc.substring(compsrc.lastIndexOf(\"/\")+1,compsrc.indexOf(\".png\"));\n\t\turlToDisplay = \"EgNewServer.jsp?server=new&compstatus=\"+ encodeURI(compstatus)+\"&serverType=\"+encodeURI(servertype)+\"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&comptitle=\"+encodeURI(comptitle)+\"&topoSegName=\"+encodeURI(thissegment);\n\t}\n\t/*else if(val == 'all'){\n\t\turlToDisplay =\"EgAutoManagePage.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone);\n");
      out.write("\t}\n\telse if(val == 'save'){\n\t\turlToDisplay =\"EgAutoManagePage.jsp?segment=\"+encodeURI(thissegment)+\"&action=\"+val+\"&zone=\"+encodeURI(thiszone);\n\t}*/\n\n\tvar maxInd = maxIndex();\n\twindow.parent.$j(\"#manageDiv\").css({\"display\":\"block\" , \"position\":\"absolute\" });\n\twindow.parent.$j(\"#manageDiv\").css({\"z-index\":maxInd+1});\n\twindow.parent.$j(\"#manageDiv\").show('slow');\n\tmanageFrame.src = urlToDisplay;\n\t$j(\"#menudiv\").hide(\"slow\"); //Close the menu Div..\n\n\t/*if(manageDiv!=null)\n\t{\n\t\tvar divWidth = manageDiv.style.width;\n\t\tvar divHeight = manageDiv.style.height;\n\t\tmanageFrame.src = urlToDisplay;\n\t\tmanageDiv.style.textAlign = 'right';\n\t\tmanageDiv.style.padding = '0px';\n\t\tmanageDiv.style.padding = '0px';\n\t\tmanageDiv.style.background=\"white\";\n\t\tmanageDiv.style.display = 'block';\n\t\tmanageDiv.style.position = 'absolute';\n\t\tbringToFront(manageDiv);\n\t\t$j(\"#menudiv\").hide(\"slow\");\t//Close the menu Div..\n\t}*/\n\t\n}\n\nfunction showSettings()\n{\n\tvar maxInd = maxIndex();\n\tvar href = \"/final/admin/EgTopologySettings.jsp\";\n\twindow.parent.$j(\"#settingsDiv\").css({\"display\":\"block\" , \"position\":\"absolute\" });\n");
      out.write("\twindow.parent.$j(\"#settingsDiv\").css({\"z-index\":maxInd+1});\n\twindow.parent.$j(\"#settingsDiv\").show('slow');\n\twindow.parent.$j(\"#innerSettingDiv\").load(href);\n\t$j(\"#menudiv\").hide(\"slow\"); //Close the menu Div..\n}\n\nfunction setZoomLevel(val)\n{\n\t//This is a Dummy function, used to avoid java script error. Original Function is defined inside Body\n}\n\nfunction unGroup()\n{\n\tvar mode = 'delete';\n\tvar thistitle = $j(\"#h_title\").attr(\"value\");\n\tvar thiszone= $j(\"#zone\").attr(\"value\");\n\tvar fromPage = 'autoMainPage';\n\tvar zoneString = $j(\"#zoneString\").attr(\"value\");\n\tvar thissegment = $j(\"#segment\").attr(\"value\");\n\tvar zoomValue = $j(\"#zoom\").attr(\"value\");\n\tvar enableDrag = '';\n//\tif($j('#dragCheckbx').is(':checked'))\n//\t{\n//\t\tenableDrag = 'true';\n//\t}\n//\telse\n//\t{\n//\t\tenableDrag = 'false';\n//\t}\n\tvar modify=\"");
      out.print(modify);
      out.write("\";\n\n\tvar url = '/final/admin/Egconfiggroupp.jsp?mode='+encodeURI(mode)+'&deleteGroups='+encodeURI(thistitle)+'&thiszone='+encodeURI(thiszone)+'&fromPage='+encodeURI(fromPage)+'&zoneString='+encodeURI(zoneString);\n\tvar httpObj = parent.createRequestObject();\n\tvar params = \"\";\n\tvar tempurl = \"\";\n\tif (url.indexOf(\"?\") > -1){\n\t\tparams=url.substring(url.indexOf(\"?\")+1);\n\t\ttempurl=url.substring(0,url.indexOf(\"?\"));\n\t}\n\telse{\n\t\ttempurl=url;\n\t}\n\thttpObj.open('POST',tempurl,true);\n\thttpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');\n\thttpObj.setRequestHeader('Content-length',params.length);\n\thttpObj.setRequestHeader('Connection','close');\n\thttpObj.onreadystatechange = function() {\n\t\tif (httpObj.readyState == 4 && httpObj.status == 200)\n\t\t{\n\t\t\tvar myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+encodeURI(zoomValue)+\"&enableDrag=\"+encodeURI(enableDrag)+\"&modify=\"+encodeURI(modify);\n\t\t\tsetTimeout(function(){window.location = myUrl;}, 0);\n");
      out.write("\t\t}\n\t}\n\thttpObj.send(params);\n}\n\nfunction getXMLObject()  //XML OBJECT\n{\n\tvar xmlHttp = false;\n\ttry \n\t{\n\t\txmlHttp = new ActiveXObject(\"Msxml2.XMLHTTP\");\n\t}\n\tcatch (e) \n\t{\n\t\ttry \n\t\t{\n\t\t\txmlHttp = new ActiveXObject(\"Microsoft.XMLHTTP\");\n\t\t}\n\t\tcatch (e2) \n\t\t{\n\t\t\txmlHttp = false;\n\t\t}\n\t}\n\tif (!xmlHttp && typeof XMLHttpRequest != 'undefined') \n\t{\n\t\txmlHttp = new XMLHttpRequest();\n\t}\n\treturn xmlHttp;\n}\nvar xmlhttp;\nfunction savePositions(str)\n{\n\tvar segmentname ='");
      out.print(segmentName);
      out.write("';\n\tif(segmentname == 'Independent_servers')\n\t{\n\t\tvar siteName = '");
      out.print(site);
      out.write("';\n\t\tsegmentname = siteName+\":\"+segmentname;\n\t}\n\tvar url = \"/final/servlet/com.eg.SegmentPositionServlet\";\n\tvar zoomHidden = document.getElementById(\"zoom\").value;\n\tvar params;\n\tif(str == 'save')\n\t{\n\t\tvar keys = compPosition.listKeys();\n\t\tparams =\"action=\"+str+\"&segment=\"+segmentname+\"&total=\"+keys.length+\"&zoom=\"+zoomHidden;\n\t\tfor(var k=0;k<keys.length;k++)\n\t\t{\n\t\t\tvar key = keys[k];\n\t\t\tvar val = compPosition.get(key);\n\t\t\tparams = params+\"&key\"+k+\"=\"+key+\"&val\"+k+\"=\"+val;\n\t\t}\n\t}\n\telse if (str == 'zoom')\n\t{\n\t\tparams = \"action=\"+str+\"&segment=\"+segmentname+\"&zoom=\"+zoomHidden;\n\t}\n\telse if(str == 'delete')\n\t{\n\t\tparams = \"action=\"+str+\"&segment=\"+segmentname;\n\t}\n\n\txmlhttp = new getXMLObject();\n\tif(xmlhttp)\n\t{\n\t\txmlhttp.open(\"POST\",url,true);\n\t\txmlhttp.onreadystatechange  = function()\n\t\t{\n\t\t\tif (xmlhttp.readyState == 4) \n\t\t\t{\n\t\t\t\tif(xmlhttp.status == 200) \n\t\t\t\t{\n\t\t\t\t\tif(str == 'save')\n\t\t\t\t\t{\n\t\t\t\t\t\t//showDivs('positionDiv');\n\t\t\t\t\t\tExt.Msg.alert(\"Segment\",\"Component positions have been saved successfully\");\n\t\t\t\t\t}\n\t\t\t\t}\n");
      out.write("\t\t\t\telse \n\t\t\t\t{\n\t\t\t\t\tExt.Msg.alert(\"Segment\",\"Error occured. Please try again ....\");\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\txmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');\n\t\txmlhttp.send(params);\n\t}\n}\nfunction showDivs(divId)\n{\n\tvar show_div = document.getElementById(divId);\n\tif(show_div!=null)\n\t{\n\t\tshow_div.style.display = 'block';\n\t\tshow_div.style.position = 'absolute';\n\t\tbringToFront(show_div);\n\t}\n}\n\nfunction resetPositions()\n{\n\tvar segmentname ='");
      out.print(segmentName);
      out.write("';\n\tvar site ='");
      out.print(site);
      out.write("';\n\tvar phyTopo = '");
      out.print(phyTopology);
      out.write("';\n\tvar zoom = document.getElementById('zoom').value;\n\tvar isfull = '");
      out.print(isFull);
      out.write("';\n\tvar modify = '");
      out.print(modify);
      out.write("';\n\tvar zone = '");
      out.print(zone);
      out.write("';\n\tvar compname='");
      out.print(compname);
      out.write("';\n\tvar comptype='");
      out.print(comptype);
      out.write("';\n\tvar hlcomptype = '");
      out.print(hlc_type);
      out.write("';\t// High_Lighted_CompType\n\tvar hlcomp = '");
      out.print(hlc);
      out.write("';\n\tvar enableDrag = '';\n\tif($j('#dragCheckbx').is(':checked'))\n\t{\n\t\tenableDrag = 'true';\n\t}\n\telse\n\t{\n\t\tenableDrag = 'false';\n\t}\n\tdocument.getElementById('container').style.height = documentView.getHeight()+\"px\";  \n\tdocument.getElementById('container').style.width = documentView.getWidth()+\"px\"; \n\tvar myUrl = \"EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURIComponent(segmentname)+\"&default=true&zoom=\"+zoom+\"&site=\"+encodeURIComponent(site)+\"&physical_topology=\"+phyTopo+\"&modify=\"+modify+\"&zone=\"+zone+\"&compname=\"+compname+\"&comptype=\"+comptype+\"&hlcomptype=\"+hlcomptype+\"&hlcomp=\"+hlcomp+\"&enableDrag=\"+enableDrag;\n\t\n\tif(isfull == 'true')\n\t\tmyUrl = myUrl + \"&view=full\";\n\t//window.location.href = myUrl;\n\tsetTimeout(function(){\n\t\twindow.location = myUrl;\n\t}, 0);\n}\n\nfunction openBigDiv()\n{\n\tvar mySegment = '");
      out.print(segmentName);
      out.write("';\n\tvar site ='");
      out.print(site);
      out.write("';\n\tvar phyTopo = '");
      out.print(phyTopology);
      out.write("';\n\tvar zoom = document.getElementById('zoom').value;\n\tvar isfull = '");
      out.print(isFull);
      out.write("';\n\tvar modify = '");
      out.print(modify);
      out.write("';\n\tvar zone = '");
      out.print(zone);
      out.write("';\n\tvar compname='");
      out.print(compname);
      out.write("';\n\tvar comptype='");
      out.print(comptype);
      out.write("';\n\tvar hlcomptype = '");
      out.print(hlc_type);
      out.write("';\t// High_Lighted_CompType\n\tvar hlcomp = '");
      out.print(hlc);
      out.write("';\t\n\tvar enableDrag = '';\n\tif($j('#dragCheckbx').is(':checked'))\n\t{\n\t\tenableDrag = 'true';\n\t}\n\telse\n\t{\n\t\tenableDrag = 'false';\n\t}\n\tvar myUrl = \"EgAutoTopologyMainPageExt.jsp?index=main&segment=\"+encodeURIComponent(mySegment)+\"&view=full&site=\"+encodeURIComponent(site)+\"&physical_topology=\"+phyTopo+\"&modify=\"+modify+\"&zone=\"+zone;//+\"&compname=\"+compname+\"&comptype=\"+comptype+\"&hlcomptype=\"+hlcomptype+\"&hlcomp=\"+hlcomp+\"&enableDrag=\"+enableDrag;\n\tnewwindow=window.open(myUrl,'Topology','width='+screen.width+',height='+screen.height+', status=yes,scrollbars=no,resizable=yes');\n\tif (window.focus) {newwindow.focus()}\n\t\treturn false;\n}\n\nfunction EnableOrDisableDrag()\n{\n\tvar thiszone= document.getElementById(\"zone\").value;\n\tvar thissegment = document.getElementById(\"segment\").value;\n\tvar zoomValue = document.getElementById(\"zoom\").value;\n\tvar modify=\"");
      out.print(modify);
      out.write("\";\n\n\tif($j('#dragCheckbx').is(':checked'))\n\t{\n\t\t//document.getElementById('dragLink').innerHTML=\"Drag On\";\n\t\tvar myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+zoomValue+\"&enableDrag=true\"+\"&modify=\"+encodeURI(modify);\n\t\tsetTimeout(function(){ window.location = myUrl;}, 0);\n\t}\n\telse\n\t{\n\t\t\n\t\t//hideDivs('toolsDiv');\n\t\tshowDivs('alertSavePositionDiv');\n\t\t//document.getElementById('dragLink').innerHTML=\"Drag Off\";\n\t\t//var myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+zoomValue+\"&enableDrag=false\";\n\t\t//setTimeout(function(){ window.location = myUrl;}, 0);\n\t}\n}\n\nfunction hideAndRefreshDivs(divId)\n{\n\t$j(\"#\"+divId).hide(\"slow\");\n\tvar thiszone= document.getElementById(\"zone\").value;\n\tvar thissegment = document.getElementById(\"segment\").value;\n\tvar zoomValue = document.getElementById(\"zoom\").value;\n\tvar enableDrag = '';\n\tif($j('#dragCheckbx').is(':checked'))\n\t{\n\t\tenableDrag = 'true';\n");
      out.write("\t}\n\telse\n\t{\n\t\tenableDrag = 'false';\n\t}\n\tvar modify=\"");
      out.print(modify);
      out.write("\";\n\tvar myUrl = \"/final/admin/EgAutoTopologyMainPageExt.jsp?segment=\"+encodeURI(thissegment)+\"&zone=\"+encodeURI(thiszone)+\"&zoom=\"+zoomValue+\"&modify=\"+encodeURI(modify); //+\"&enableDrag=\"+enableDrag;\n\tsetTimeout(function(){ window.location = myUrl;}, 0);\n}\n\n</script>\n</head>\n");

	finalTopoStr = getTopologyString(segmentName , site , phyTopology);
	//out.println("finalTopoStr :"+finalTopoStr);
	if(finalTopoStr.trim().equals("="))
	{
		finalTopoStr="Web_site:egurkha.physical.topology=null";
		
	}
	//out.println(""+finalTopoStr);
	//finalTopoStr="Web_site:egurkha.physical.topology=null";
	String sessionString = (String) session.getAttribute("THISSEGMENT");
	if(sessionString!=null && sessionString.length() > 0){
		session.setAttribute("THISSEGMENT",finalTopoStr);
	}
	else{
		session.setAttribute("THISSEGMENT",finalTopoStr);
	}
	
	// For UNDO -------> Starts

	Hashtable grpCompHash = groupInfo.getGroupCompHash();
	Hashtable sessGrpCompHash = (Hashtable)session.getAttribute("GroupCompHashtable");
	session.setAttribute("sessionGroupTable",(Hashtable)sessGrpCompHash);
	session.setAttribute("GroupCompHashtable",(Hashtable)grpCompHash);
	
	String grpFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini";
	IniFile groupIni = new IniFile(grpFilePath);
	String zoneString="";
	if(isZone)
	{
		String[] zoneLines = groupIni.getLinesUnderSubject("ZONE_DETAILS");
		String[] sessZone = (String[])session.getAttribute("zoneLines");
		if(sessZone!=null)
		{
			StringBuffer result = new StringBuffer();
			for (int i = 0; i < sessZone.length; i++) {
				result.append( sessZone[i] );
				result.append(" ");
			}
			zoneString = result.toString();
		}
		session.setAttribute("zoneLines",(String[])zoneLines);
	}

	String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
	IniFile autoTopoIni = new IniFile(iniFilePath);
	String[] allLines = autoTopoIni.getLinesUnderSubject(segmentName);
	String asString="";
	String[] sesAllLines = (String[])session.getAttribute("AllLinesInSegment");
	if(sesAllLines!=null )
	{
		StringBuffer result = new StringBuffer();
		for (int i = 0; i < sesAllLines.length; i++) {
			result.append( sesAllLines[i] );
			result.append(" ");
		}
		asString = result.toString();
	}

	if(sesAllLines!=null && sesAllLines.length > 0){
		isPreExists = true;
	}
	else{
		isPreExists = false;
	}

	session.setAttribute("AllLinesInSegment",allLines);
	
	// For UNDO --------> Ends

	ArrayList postionArrList = null;
	int divHeight = 100;
	int divWidth  = 100;
	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs =	iniUI.getValue("TOPOLOGY_OPTIONS","Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS","Column_space");
	int rowspace = 50;
	int colspace = 50;
	try{
		if(rs!=null) rowspace = Integer.parseInt(rs);
		if(cs!=null) colspace = Integer.parseInt(cs);
	}
	catch(Exception e){
		rowspace = 50;
		colspace = 50;
	}
	//Get row & column spacing from eg_ui.ini .... (End)
	if(finalTopoStr!=null && finalTopoStr.trim().length() > 1)
	{
		EgNewTopology egNewTopo= new EgNewTopology(finalTopoStr,rowspace,colspace);
		postionArrList = egNewTopo.getOutputValues();
		divHeight = egNewTopo.getHeight();
		divWidth  = egNewTopo.getWidth();
		isEntry = true;
	}
	StringBuffer outPutBuffer = new StringBuffer();
	if(postionArrList!=null){
		outPutBuffer.append(postionArrList.toString().substring(1,postionArrList.toString().indexOf("]")));
	}
	

	////getting data from eg_lang_US.ini file
	//ArrayList tokeList = new ArrayList();
	//for(int i=0;i<postionArrList.size();i++)
	//{
		//String key =(String)postionArrList.get(i);
		
		//StringTokenizer tokenizer = new StringTokenizer(key,",");
		//String tokenVal=tokenizer.nextToken();
		//tokeList.add(tokenVal);
	//}
	//ArrayList keyList= new ArrayList();
	//for(int i=0;i<tokeList.size();i++)
	//{
		//String t_key=(String)tokeList.get(i);
		//String key = t_key.substring(0,t_key.indexOf("="));
		//keyList.add(key);
		
	//}

	//StringBuffer pnameBuffer = new StringBuffer();
	//ArrayList valueList = new ArrayList();
	//boolean isName = true;
	//String delim="";
	//String val="";
	//for(int i=1;i<keyList.size();i++)
	//{
		//delim="=";
		//String key1=(String)keyList.get(i);
		//String keyValue=key1.substring(0,key1.indexOf(":"));
		//String keyinValue="";
		//if(keyValue.indexOf("Agg_")==0)
		//{
			//keyinValue=keyValue.substring(4);
			
		//}
		//else
		//{
			//keyinValue=keyValue;
		//}
		//String value=_mapping.getComponentTypeDescription(keyinValue);
		
			//val+=(keyinValue+":"+value+""+delim);
		////delim="=";
		
	//}
	
	//valueList.add(val);
	
	//if(valueList.size()>0)
	//{
		
		//pnameBuffer.append(valueList.toString().substring(1,valueList.toString().indexOf("]")));
		
		//isName=true;
	//}
	//end
	boolean isName = true;
	String compCategoryMapping="";
	String pnameBuffer="";
	eGComponentCategory compCategoryObj = eGComponentCategory.getInstance();
	for(int i=0;i<postionArrList.size();i++)
	{
		String line=(String)postionArrList.get(i);
		StringTokenizer tokenizer = new StringTokenizer(line,",");
		String var=tokenizer.nextToken();
		if(var.startsWith("egurkha.physical.topology"))
			continue;
		String comp_Type=var.substring(0,var.indexOf(":"));
		String category  ="";
		if(comp_Type.equals("Group"))
		{
			category="group";
		}
		else if(comp_Type.endsWith("_ex"))
		{
			category = udTests.getValue("COMP_DISPLAYIMAGE_NICK",comp_Type);
		}
		else if(comp_Type.toLowerCase().startsWith("agg_"))
		{
			category="AGGREGATES";
		}
		else
		{
			category=compCategoryObj.getCategoryforCompType(comp_Type);
		}
		compCategoryMapping+=(comp_Type+":"+category+"=");
		if(comp_Type.indexOf("Agg_")==0)
		{
			comp_Type=comp_Type.substring(4);
		}
		String value=_mapping.getComponentTypeDescription(comp_Type);
		pnameBuffer+=(comp_Type+":"+value+"=");
		
	}
	if(compCategoryMapping.endsWith("="))
	{
		compCategoryMapping=compCategoryMapping.substring(0,compCategoryMapping.lastIndexOf("="));
	}
	if(pnameBuffer.endsWith("="))
	{
		pnameBuffer=pnameBuffer.substring(0,pnameBuffer.lastIndexOf("="));
	}
	
	// ...... List of new & unmanage components (Begin)...........................//
	TreeSet newCompList = new TreeSet();
	TreeSet unManageList = new TreeSet();
	StringBuffer newCompBuffer = new StringBuffer();
	StringBuffer unManageBuffer = new StringBuffer();
	if(isEntry)
	{
		Hashtable resultTable = getUnmanageAndNewComponents(segmentName);
		newCompList = (TreeSet) resultTable.get("NEW");
		unManageList = (TreeSet) resultTable.get("UNMANAGE");
		if(newCompList!=null && newCompList.size() > 0)
			newCompBuffer.append(newCompList.toString().substring(1,newCompList.toString().indexOf("]")));
		if(unManageList!=null && unManageList.size() > 0)
			unManageBuffer.append(unManageList.toString().substring(1,unManageList.toString().indexOf("]")));
	}
	// ...... List of new & unmanage components (End)...........................//

	String popup_topright = isMSIE6?"popup_topright_noshade":"popup_topright";
	String popup_rightbg = isMSIE6?"popup_rightbg_noshade":"popup_rightbg";
	String popup_bottomleft = isMSIE6?"popup_bottomleft_noshade":"popup_bottomleft";
	String popup_bottombg = isMSIE6?"popup_bottombg_noshade":"popup_bottombg";
	String popup_bottomright = isMSIE6?"popup_bottomright_noshade":"popup_bottomright";

      out.write("<input type=\"hidden\" id=\"h_previous\" name=\"h_previous\" value=\"");
      out.print(isPreExists);
      out.write("\">\n<input type=\"hidden\" id=\"h_title\" name=\"h_title\" value=\"\">\n<input type=\"hidden\" id=\"h_src\" name=\"h_src\" value=\"\">\n<input type=\"hidden\" id=\"h_status\" name=\"h_status\" value=\"\">\n<input type=\"hidden\" id=\"lorn\" name=\"lorn\" value=\"\">\n<input type=\"hidden\" id=\"asString\" name=\"asString\" value=\"");
      out.print(asString);
      out.write("\">\n<input type=\"hidden\" id=\"zoneString\" name=\"zoneString\" value=\"");
      out.print(zoneString);
      out.write("\">\n<input type=\"hidden\" id=\"link\" name=\"link\" value=\"");
      out.print(link);
      out.write("\">\n<input type=\"hidden\" id=\"site\" name=\"site\" value=\"");
      out.print(site);
      out.write("\">\n\n\n<!-- <body onLoad=\"javascript:pageHeightWidth();\" onclick=\"javascript:hideDivs('menudiv');\" > -->\n<body style=\"overflow:hidden;\"  class=\"adminTopologyBg\">\n<!---------------------POPUP MENU-------------------------->\n<div id=\"menudiv\" style=\"position:absolute;display:none;top:0px;left:0px;z-index:10000;\" onmouseover=\"javascript:overpopupmenu=true;\" onmouseout=\"javascript:overpopupmenu=false;\">\n<table border=\"0\" style=\"width:120px;\" class=\"tree_border\" cellpadding=\"0\" cellspacing=\"0\">\n\t<tr>\n\t\t<td rowspan=\"5\" width=\"16px\" class=\"tree_bgimage\"></td>\n\t\t<td>\n\t\t\t<table width=\"100%\" cellpadding=\"4\" cellspacing=\"0\" border=\"0\">\n\t\t\t\t<tr id=\"manageRow\" name=\"manageRow\"  onclick=\"javascript:OpenManageDiv('single');\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Manage\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\"><a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f9(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr id=\"usesRow\" name=\"usesRow\"  onclick=\"javascript:OpenConnectUsesDiv('uses');\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Uses\"  onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\" ><a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f10(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr id=\"connectRow\" name=\"connectRow\" onclick=\"javascript:OpenConnectUsesDiv('connect');\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Connect\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\"> <a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f11(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr id=\"removeRow\" name=\"removeRow\" onclick=\"javascript:RemoveFunction('remove');\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Remove\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\" ><a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f12(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr id=\"groupRow\" name=\"groupRow\" onclick=\"javascript:ShowGroupDetails();\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Group\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\" ><a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f13(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr id=\"groupCreate\" name=\"groupCreate\" onclick=\"javascript:createGroup();\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"GCreate\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\" > <a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f14(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr id=\"unGroup\" name=\"unGroup\" onclick=\"javascript:unGroup();\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"uGroup\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\" > <a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f15(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n</div>\n\n<div id=\"toolsDiv\" name=\"toolsDiv\" style=\"display:none;left:805px;top:33px;position:absolute;border:0px solid #ff0000;z-index:500;\" onmouseover=\"javascript:overpopupmenu=true;\" onmouseout=\"javascript:overpopupmenu=false;\">\n<table border=\"0\" style=\"width:160px;\" class=\"tree_border\" cellpadding=\"0\" cellspacing=\"0\">\n\t<tr>\n\t\t<td rowspan=\"4\" width=\"16px\" class=\"tree_bgimage\"></td>\n\t\t<td>\n\t\t\t<table width=\"100%\" cellpadding=\"4\" cellspacing=\"0\" border=\"0\">\n\t\t\t\t<tr onclick=\"javascript:OpenManageAllDiv('all');\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Manageall\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\"> <a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f16(_jspx_page_context))
        return;
      out.write("</a> </td>\n\t\t\t\t</tr>\n\t\t\t\t<tr onclick=\"javascript:OpenManageAllDiv('save');\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Uses\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\"><a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f17(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr onclick=\"javascript:OpenManageAllDiv('saveAs');\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Uses\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\"><a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f18(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"eg_treelink\" height=\"2px\"><hr></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr onclick=\"javascript:refreshPage();\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Refresh\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\"><a class=\"eg_adminlink\">");
      if (_jspx_meth_egui_005fintnl_005f19(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr onclick=\"javascript:RemoveFunction('clearall');\">\n\t\t\t\t\t<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Refresh\" onmouseover=\"javascript:overImage(this);\" onmouseout=\"javascript:outImage(this);\"><a class=\"eg_adminlink\" >");
      if (_jspx_meth_egui_005fintnl_005f20(_jspx_page_context))
        return;
      out.write("</a></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"eg_treelink\" height=\"2px\"><hr></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr id=\"dragRow\">\n\t\t\t\t\t");

						String checked="";
						String dragString="Drag On";
						if(dragEnabled)
						{
							checked="checked";
						}
					
      out.write("<td class=\"eg_treelink eg_whitebg tree_font\" id=\"Drag\">\n\t\t\t\t\t\t");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f21 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f21.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f21.setParent(null);
      // /admin/EgAutoTopologyMainPageExt.jsp(2462,6) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f21.setText("admin.common."+dragString);
      int _jspx_eval_egui_005fintnl_005f21 = _jspx_th_egui_005fintnl_005f21.doStartTag();
      if (_jspx_th_egui_005fintnl_005f21.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f21);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f21);
      out.write("<input type=\"checkbox\" id=\"dragCheckbx\" name=\"dragCheckbx\" onclick=\"javascript:EnableOrDisableDrag();\" ");
      out.print(checked);
      out.write("/>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n</div>\n\n\n<!-- Legend DIV  -->\n");

	//if(!isFull)
	{

      out.write("<div id=\"legendDiv\" name=\"legendDiv\" style=\"visibility:visible;display:block;left:180px;top:8px;width:520px; position:absolute;z-Index:100;padding:4px\" class=\"font_normal11 linesquare eg_subheadbg\">\n\t<div style=\"float:left;margin-right:10px;\"><img src=\"/final/admin/eg_images/icon_new_component.png;\" style=\"vertical-align:middle\" hspace=\"4px\">");
      if (_jspx_meth_egui_005fintnl_005f22(_jspx_page_context))
        return;
      out.write("</div>\n\n\t<div style=\"float:left;margin-right:10px\"><img src=\"/final/admin/eg_images/icon_unmanaged_component.png\" style=\"vertical-align:middle\" hspace=\"4px\">");
      if (_jspx_meth_egui_005fintnl_005f23(_jspx_page_context))
        return;
      out.write("</div>\n\n\t<!--<div style=\"float:left;margin-right:10px\"><img src=\"/final/admin/eg_images/icon_managed_component.png\" style=\"vertical-align:middle\" hspace=\"4px\">");
      if (_jspx_meth_egui_005fintnl_005f24(_jspx_page_context))
        return;
      out.write("</div>-->\n\n\t<div style=\"float:left;margin-right:10px\"><img src=\"/final/admin/eg_images/icon_recently_component.png\" style=\"vertical-align:middle\" hspace=\"4px\">");
      if (_jspx_meth_egui_005fintnl_005f25(_jspx_page_context))
        return;
      out.write("</div>\n</div>\n");

	}

      out.write("<div id=\"positionDiv\" name=\"positionDiv\" style=\"display:none;right:30px;top:45px;width:300px;height:50px;border:0px solid #ff0000; position:absolute;\">\n\t<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n\t\t<tr>\n\t\t\t<td class=\"pop2_lefttop_curve\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"11\"></td>\n\t\t\t<td class=\"pop2_top_bg\" width=\"100%\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"2\" height=\"11\"></td>\n\t\t\t<td class=\"pop2_righttop_curve\" ><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"11\"></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"pop2_left_bg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"50px\"></td>\n\t\t\t<td class=\"eg_whitebg\" align=\"center\">\n\t\t\t\t<div style=\"height:50px;border:1px solid black;\">\n\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"4\" align=\"center\" width=\"100%\">\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"center\" nowrap valign=\"top\"  style=\"padding:4px\">");
      if (_jspx_meth_egui_005fintnl_005f26(_jspx_page_context))
        return;
      out.write("<br>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr align=\"center\">\n\t\t\t\t\t\t\t<td><input type=\"button\" class=\"eg_lightbutton\" name=\"okButton\" id=\"okButton\" value=\" OK \" onclick=\"javascript:hideAndRefreshDivs('positionDiv');\"style=\"padding-left:4px;padding-right:4px\"></td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t\t<td class=\"pop2_right_bg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"50px\"></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"pop2_leftbottom_curve\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"11\"></td>\n\t\t\t<td class=\"pop2_bottom_bg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"2\" height=\"11\"></td>\n\t\t\t<td class=\"pop2_rightbottom_curve\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"11\"></td>\n\t\t</tr>\n\t</table>\n</div>\n\n\n<div id=\"alertSavePositionDiv\" name=\"alertSavePositionDiv\" style=\"display:none;right:30px;top:45px;width:300px;height:100px;border:0px solid #ff0000; position:absolute;\">\n\t<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n\t\t<tr>\n\t\t\t<td class=\"pop2_lefttop_curve\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"11\"></td>\n");
      out.write("\t\t\t<td class=\"pop2_top_bg\" width=\"100%\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"2\" height=\"11\"></td>\n\t\t\t<td class=\"pop2_righttop_curve\" ><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"11\"></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"pop2_left_bg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"50px\"></td>\n\t\t\t<td class=\"eg_whitebg\" align=\"center\">\n\t\t\t\t<div style=\"height:50px;border:1px solid black;\">\n\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"100%\">\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td align=\"center\" nowrap valign=\"top\" style=\"padding:4px\" >");
      if (_jspx_meth_egui_005fintnl_005f27(_jspx_page_context))
        return;
      out.write("<br>\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr align=\"center\">\n\t\t\t\t\t\t\t<td><input type=\"button\" class=\"eg_lightbutton\" name=\"okButton\" id=\"okButton\" value=\" SAVE \" onclick=\"javascript:savePositions('save');javascript:hideDivs('alertSavePositionDiv');\">\n\t\t\t\t\t\t\t<input type=\"button\" class=\"eg_lightbutton\" name=\"cancelButton\" id=\"cancelButton\" value=\" CANCEL \" onclick=\"javascript:hideAndRefreshDivs('alertSavePositionDiv');\">\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t\t<td class=\"pop2_right_bg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"50px\"></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"pop2_leftbottom_curve\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"11\"></td>\n\t\t\t<td class=\"pop2_bottom_bg\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"2\" height=\"11\"></td>\n\t\t\t<td class=\"pop2_rightbottom_curve\"><img src=\"/final/admin/eg_images/spacer.gif\" width=\"11\" height=\"11\"></td>\n\t\t</tr>\n\t</table>\n</div>\n\n\n<div id=\"mainDiv\" name=\"mainDiv\">\n<table border=\"0\" align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" >\n");
      out.write("\t<input type=\"hidden\" id=\"zone\" name=\"zone\" value=\"");
      out.print(zone);
      out.write("\">\n\t<input type=\"hidden\" id=\"segment\" name=\"segment\" value=\"");
      out.print(segmentName);
      out.write("\">\n\t<tr>\n\t\t<td width=\"100%\" align=\"center\" height=\"100%\" valign=\"top\" >\n\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"4\" width=\"100%\" border=\"0\" >\n\t\t\t\t<tr>\n\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\">\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td class=\"topoBg linesquare\" >\n\t\t\t\t\t\t\t\t\t<div id=\"container\" class=\"div_scroll\" style=\"width:100%;height100%;border:0px solid red;overflow:auto\">\n\n");

	//isEntry=true;							
								
	if(isEntry)
	{

      out.write("<div id=\"paper\" name=\"paper\" style=\"width:100%;height:100%;z-index:10;border:0px solid green;\">\n\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t</div>\n<script type=\"text/javascript\">\n\n   //disable right click\n    \n//end \nvar zom = parseInt('");
      out.print(zoomLevel);
      out.write("')/100;\n//document.getElementById('container').style.width = documentView.getWidth()+\"px\";  \n//document.getElementById('container').style.height = documentView.getHeight()+\"px\";  \n\n//var width = 1265;\n//var height = 865;\n//var width = screen.width;\n//var height = screen.height;\n\nvar width = 916;\nvar height = 520;\n\nvar gifWidth = 48*zom;\nvar gifHeight = 48*zom;\nvar userWidth = 48*zom;\nvar userHeight = 48*zom;\nvar newWidth = 19*zom;\nvar newHeight =  18*zom;\nvar rectShape ='';\n\nvar el;\nvar newUnmanageMap = new Map;\nvar compPosition = new Map;\nvar connectionArr = new Array();\nvar eGComps = new Array();\n//var stateCircles = new Array();\nvar allCompNames = new Array();\nvar newUnmanageLables = new Array();\nvar compLables = new Map();\n\nvar compIndexMap = new Map();\nvar topostring ='");
      out.print(finalTopoStr);
      out.write("';\nvar sessionstring = '");
      out.print(sessionString);
      out.write("';\nvar positionString ='");
      out.print(outPutBuffer);
      out.write("';\nvar newcompstring = '");
      out.print(newCompBuffer);
      out.write("';\nvar unmanagerstring ='");
      out.print(unManageBuffer);
      out.write("';\nvar isFlag ='");
      out.print(isRecflag);
      out.write("';\nvar comparisonString ='");
      out.print(comparisonString);
      out.write("';\nvar iniMaxW = 0;\nvar iniMaxH = 0;\n// addding\n\nvar egtop_iniMap = new Map();\nvar alltpNames = new Array();\n//end\n//r = Raphael(\"paper\", width, height);\nr = Raphael(\"paper\", width, height);\nr.initZoom();\nvar compCategoryMapping='");
      out.print(compCategoryMapping);
      out.write("';\nvar compGroupMap = new Map();\nr.customAttributes.CompType = function (compType) {\n\t\treturn {CompType : compType};\n};\n//Zoom supports from 10% to 150%\nfunction setZoomLevel(zoomHidden)\n{\n\tvar zInt = parseInt(zoomHidden);\n\tzInt = zInt.toFixed();\n\tdocument.getElementById(\"zoom\").value = zInt;\n\tsetZoom(zInt / 100);\n\tsavePositions(\"zoom\");\n}\n\nfunction setZoom(zoom)\n{\n\tvar holderDiv = document.getElementById(\"paper\");\n\tvar holderH = document.getElementById(\"paper\").clientHeight;\n\tvar holderW = document.getElementById(\"paper\").clientWidth;\n\tzom = zoom;\n\tvar regW = holderW>iniMaxW?holderW:iniMaxW;\n\tvar regH = holderH>iniMaxH?holderH:iniMaxH;\n\t//if(regW < 916) regW = 916;\n\tif(regW < 916) regW = 850;\n\t//if(regH < 512) regH = 512;\n\tif(regH < 512) regH = 320;\n\tvar winHeight='';\n\tif('");
      out.print(isFull);
      out.write("' == 'true')\n\t{\n\t\twinHeight = documentView.getHeight()- 10;\n\t}\n\telse\n\t{\n\t\twinHeight = documentView.getHeight()- 60;\n\t}\n\tvar winWidth = documentView.getWidth()- 8;\n\n\tif(regH < winHeight)\n\t\tregH = winHeight;\n\tif(regW < winWidth)\n\t\tregW = winWidth;\n\tholderDiv.style.width = regW;\n\tholderDiv.style.height = regH;\n\tif(zoom <=1)\n\t{\n\t\tr.setSize(regW, regH);\n\t}\n\telse\n\t{\n\t\tr.setSize(1.2*regW*zoom,regH*zoom);\n\t}\n\tr.setZoom(zoom);\n\t\n\tif(parent.document.getElementById(\"zoomValue\")!=null)\n\t\tparent.document.getElementById(\"zoomValue\").value= (zom * 100).toFixed();\n\t\n}\n\nsetZoom(zom);\n\nfunction resizePaperDiv(w, h)\n{\n\t\n\tvar intW = w;\n\tvar intH = h;\n\tvar resize = \"false\";\n\tvar holderDiv = document.getElementById(\"paper\");\n\tvar holderH = document.getElementById(\"paper\").clientHeight;\n\tvar holderW = document.getElementById(\"paper\").clientWidth;\n\tif(intW > 916){\n\t\tresize = \"true\";\n\t}\n\telse{\n\t\tintW = 850;\n\t}\n\n\tif(intH > 520){\n\t\tresize =\"true\";\n\t}\n\telse{\n\t\tintH = 320;\n\t}\n\tvar winHeight='';\n\tif('");
      out.print(isFull);
      out.write("' == 'true')\n\t{\n\t\twinHeight = documentView.getHeight()- 10;\n\t}\n\telse\n\t{\n\t\twinHeight = documentView.getHeight()- 60;\n\t}\n\tvar winWidth = documentView.getWidth()- 8;\n\tif(intH < winHeight)\n\t\tintH = winHeight;\n\tif(intW < winWidth)\n\t\tintW = winWidth;\n\tif(resize == \"true\"){\n\t\tr.setSize(intW*zom,intH*zom);\n\t}\n}\n\nfunction getMapDetails(posString, newcomString, unmanageString)\n{\n\t\n\tvar changeHeight = '");
      out.print(divHeight);
      out.write("';\n\tvar changeWidth = '");
      out.print(divWidth);
      out.write("';\n\tvar intW = parseInt(changeWidth);\n\tvar intH = parseInt(changeHeight);\n\tresizePaperDiv(intW, intH);\n\t\n\t// Get Positions from ini File (Begin) , if it is already saved.\n\tvar position = '");
      out.print(isPosition);
      out.write("';\n\tvar iniPositionArr = new Array();\n\tvar iniMap = new Map();\n\tif(position == 'true')\n\t{\n\t\tvar allvec = '");
      out.print(positionBuffer.toString());
      out.write("';\n\t\tiniPositionArr = allvec.split(\", \");\n\t}\n\n\tfor(var i=0; i<iniPositionArr.length;i++)\n\t{\n\t\tvar arrElement =  iniPositionArr[i];\n\t\tvar iniMapKey =  arrElement.substring(0,arrElement.indexOf(\"=\"));\n\t\tvar iniMapValue = arrElement.substring(arrElement.indexOf(\"=\")+1);\n\t\tiniMap.put(iniMapKey,iniMapValue);\n\t}\n\t// Get Positions from ini File (End)  \n\t//adding Data\n\t\t\n\t\tvar isname = '");
      out.print(isName);
      out.write("';\n\t\tvar inidataArr = new Array();\n\t\tif(isname=='true')\n\t\t{\n\t\t\tvar positionName = '");
      out.print(pnameBuffer.toString());
      out.write("';\n\t\t\tinidataArr=positionName.split(\"=\");\n\t\t}\n\t\tfor(var i=0;i<inidataArr.length;i++)\n\t\t{\n\t\t\tvar arrElement =  inidataArr[i];\n\t\t\t\n\t\t\tvar iniMapKey =  arrElement.substring(0,arrElement.indexOf(\":\"));\n\t\t\tvar iniMapValue = arrElement.substring(arrElement.indexOf(\":\")+1);\n\t\t\t\n\t\t\tegtop_iniMap.put(iniMapKey,iniMapValue);\n\t\t\t\n\t\t\t\n\t\t}\n\t//end\n\tvar compGrpArr = new Array();\n\tif(compCategoryMapping!=null )\n\t{\n\t\tcompGrpArr=compCategoryMapping.split(\"=\")\n\t\tfor(var i=0;i<compGrpArr.length;i++)\n\t\t{\n\t\t\tvar arrElement =  compGrpArr[i];\n\t\t\tvar iniMapKey =  arrElement.substring(0,arrElement.indexOf(\":\"));\n\t\t\tvar iniMapValue = arrElement.substring(arrElement.indexOf(\":\")+1);\n\t\t\tcompGroupMap.put(iniMapKey,iniMapValue);\n\t\t}\n\t}\n\t//Store new comp details ....(Begin)\n\tif(newcomString!=null && newcomString.length > 0)\n\t{\n\t\tvar tmptokens = newcomString.split(\", \");\n\t\tfor(var i=0; i<tmptokens.length;i++)\n\t\t{\n\t\t\tvar tokvalue = tmptokens[i];\n\t\t\tnewUnmanageMap.put(tokvalue,\"NEW\");\n\t\t}\n\t}\n\t//Store new comp details ....(End)\n\t//Store UnManager Comp Details (Start)\n");
      out.write("\tif(unmanageString!=null && unmanageString.length > 0)\n\t{\n\t\tvar tmptokens = unmanageString.split(\", \");\n\t\tfor(var i=0; i<tmptokens.length;i++)\n\t\t{\n\t\t\tvar tokvalue = tmptokens[i];\n\t\t\tnewUnmanageMap.put(tokvalue,\"UNMANAGE\");\n\t\t}\n\t}\n\t//Store UnManager Comp Details (End)\n\n\tvar tokens = posString.split(\", \");\n\tvar compInd = 0;\n\tvar resize = \"false\";\n\tiniMaxW = intW;\n\tiniMaxH = intH;\n\n\tfor(var i=0; i<tokens.length;i++)\n\t{\n\t\tvar tokvalue = tokens[i];\n\t\tvar key = tokvalue.substring(0,tokvalue.indexOf(\"=\"));\n\t\tvar rhs = tokvalue.substring(tokvalue.indexOf(\"=\")+1);\n\n\t\tif(key.indexOf(\":\")==0){\n\t\t\tkey = 'egurkha.physical.topology';\n\t\t}\n\t\tif(iniMap.contains(key)) // Load Position from INI File......\n\t\t{\n\t\t\tvar iniXY  = iniMap.get(key);\n\t\t\tvar iniX = parseInt(iniXY.substring(0,iniXY.indexOf(\"#\")));\n\t\t\tvar iniY = parseInt(iniXY.substring(iniXY.indexOf(\"#\")+1));\n\n\t\t\tif(iniX >= iniMaxW)\n\t\t\t{\n\t\t\t\tresize = \"true\";\n\t\t\t\tiniMaxW = iniX + 200;\n\t\t\t}\n\n\t\t\tif(iniY >=iniMaxH)\n\t\t\t{\n\t\t\t\tresize = \"true\";\n\t\t\t\tiniMaxH = iniY + 100;\n\t\t\t}\n\t\t\t\n\t\t\tif(key == 'egurkha.physical.topology') // User Image\n");
      out.write("\t\t\t{\n\t\t\t\teGComps.push(r.image('");
      out.print(contextPath);
      out.write("'+'user_image.png', iniX*zom, iniY*zom , userWidth , userHeight).attr({\"CompType\":\"user_image\",title :\"User\"}));\n\t\t\t\tcompPosition.put(key,iniX*zom+\"#\"+iniY*zom);\n\t\t\t}\n\t\t\telse\t// Other components....\n\t\t\t{\n\t\t\t\tvar comptype = key.substring(0,key.indexOf(\":\")); \n\t\t\t\tvar compCategory=compGroupMap.get(comptype);\n\t\t\t\tvar comptip = key.substring(key.indexOf(\":\")+1);\n\t\t\t\tif(comptip.indexOf(\":NULL\")>0)\n\t\t\t\t\tcomptip = comptip.substring(0,comptip.indexOf(\":NULL\"));\n\t\t\t\tvar compImage=\"\";\n\t\t\t\tif(comptype!=null && (comptype.match(\"_ex$\")==\"_ex\" || (comptype.indexOf(\"Agg_\")==0)))\n\t\t\t\t{\n\t\t\t\t\tif(comptype == 'Group')\n\t\t\t\t\t{\t\n\t\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath1);
      out.write("'+'group.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({\"CompType\":comptype,title : comptip});\n\t\t\t\t\t}\n\t\t\t\t\t//else if(comptype.indexOf(\"Agg_\")==0)\n\t\t\t\t\t//{\n\t\t\t\t\t\t//compImage = r.image('");
      out.print(contextPath);
      out.write("'+'aggregate.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({title : comptip});\n\t\t\t\t\t//}\n\t\t\t\t\telse if(comptype.match(\"_ex$\")==\"_ex\")\n\t\t\t\t\t{\n\t\t\t\t\t\tcompImage = r.image('");
      out.print(ICImagePath);
      out.write("'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({\"CompType\":comptype,title : comptip});\n\t\t\t\t\t}\n\t\t\t\t\telse\n\t\t\t\t\t{\n\t\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath);
      out.write("'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({\"CompType\":comptype,title : comptip});\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse\n\t\t\t\t{\n\t\t\t\t\tif(comptype == 'Group')\n\t\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath1);
      out.write("'+'group.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({\"CompType\":comptype,title : comptip});\n\t\t\t\t\telse\n\t\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath);
      out.write("'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({\"CompType\":comptype,title : comptip});\n\t\t\t\t}\n\t\t\t\teGComps.push(compImage);\n\t\t\t\tcompPosition.put(key, iniX*zom+\"#\"+iniY*zom);\n\t\t\t}\n\t\t}\n\t\telse\n\t\t{\n\t\t\tif(key == 'egurkha.physical.topology') //User\n\t\t\t{\n\t\t\t\tvar xy = rhs;\n\t\t\t\tvar xPos = parseInt(xy.substring(0,xy.indexOf(\"#\")));\n\t\t\t\tvar yPos = parseInt(xy.substring(xy.indexOf(\"#\")+1));\n\n\t\t\t\tvar userImage = r.image('");
      out.print(contextPath);
      out.write("'+'user_image.png', xPos*zom, yPos*zom , userWidth , userHeight).attr({\"CompType\":\"user_image\",title :\"User\"});\n\n\t\t\t\t//If User is highlighted , Draw BOX .... (Begin)\n\t\t\t\tif('");
      out.print(hlc_type);
      out.write("' == 'user_image' && '");
      out.print(hlc);
      out.write("' == 'User')\n\t\t\t\t{\n\t\t\t\t\trectShape = r.rect (userImage.attr(\"x\")-5*zom, userImage.attr(\"y\")-5*zom, userImage.attr('width')+10*zom,userImage.attr('height')+5*zom).attr({\n\t\t\t\t\t\t\"stroke-width\": 2, \n\t\t\t\t\t\t\"stroke\" : '#");
      out.print(dark);
      out.write("'\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\t//If User is highlighted , Draw BOX .... (End)\n\t\t\t\teGComps.push(userImage);\n\t\t\t\t//stateCircles.push(\"egurkha.physical.topology\");\n\t\t\t\t//allCompNames.push(\"egurkha.physical.topology\");\n\t\t\t\tcompPosition.put(key, xPos*zom+\"#\"+yPos*zom);\n\t\t\t}\n\t\t\telse\n\t\t\t{\n\t\t\t\tvar xy = rhs;\n\t\t\t\tvar xPos = parseInt(xy.substring(0,xy.indexOf(\"#\")));\n\t\t\t\tvar ystate = xy.substring(xy.indexOf(\"#\")+1);\n\t\t\t\tvar yPos = parseInt(ystate.substring(0,ystate.indexOf(\"#\")));\n\t\t\t\tvar state = xy.substring(xy.lastIndexOf(\"#\")+1);\n\n\t\t\t\tvar comptype = key.substring(0,key.indexOf(\":\")); \n\t\t\t\tvar compCategory=compGroupMap.get(comptype);\n\t\t\t\tvar comptip = key.substring(key.indexOf(\":\")+1);\n\t\t\t\tif(comptip.indexOf(\":NULL\")>0)\n\t\t\t\t\tcomptip = comptip.substring(0,comptip.indexOf(\":NULL\"));\n\n\t\t\t\tvar coX = xPos*zom;\n\t\t\t\tvar coY = yPos*zom;\n\t\t\t\tvar compImage='';\n\t\t\t\t// Component Image (Begin)\n\t\t\t\tif(comptype == 'Group')\n\t\t\t\t{\n\t\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath1);
      out.write("'+'group.png', coX, coY , gifWidth , gifHeight).attr({\"CompType\":comptype,title : comptip});\n\t\t\t\t}\n\t\t\t\t//else if(comptype.indexOf(\"Agg_\")==0)\n\t\t\t\t//{\n\t\t\t\t\t//compImage = r.image('");
      out.print(contextPath);
      out.write("aggregate.png', coX, coY , gifWidth , gifHeight).attr({title : comptip});\n\t\t\t\t//}\n\t\t\t\telse if(comptype.match(\"_ex$\")==\"_ex\")\n\t\t\t\t{\n\t\t\t\t\tcompImage = r.image('");
      out.print(ICImagePath);
      out.write("'+compCategory+'.png', coX, coY , gifWidth , gifHeight).attr({\"CompType\":comptype,title : comptip});\n\t\t\t\t}\n\t\t\t\telse\n\t\t\t\t{\n\t\t\t\t\tcompImage = r.image('");
      out.print(contextPath);
      out.write("'+compCategory+'.png', coX, coY , gifWidth , gifHeight).attr({\"CompType\":comptype,title : comptip});\n\t\t\t\t}\n\t\t\t\t//If this is highlighted comp, Draw BOX .... (Begin)\n\t\t\t\tif('");
      out.print(hlc_type);
      out.write("' == comptype && '");
      out.print(hlc);
      out.write("' == comptip)\n\t\t\t\t{\n\t\t\t\t\trectShape = r.rect (compImage.attr(\"x\")-5*zom, compImage.attr(\"y\")-5*zom, compImage.attr('width')+10*zom,compImage.attr('height')+5*zom).attr({\n\t\t\t\t\t\t\"stroke-width\": 2, \n\t\t\t\t\t\t\"stroke\" : '#");
      out.print(dark);
      out.write("'\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\t//If this is highlighted comp, Draw BOX .... (End)\n\t\t\t\teGComps.push(compImage);\n\t\t\t\t// Component Image (End)\n\n\t\t\t\t// State Image (Begin)\n\t\t\t\t\n\t\t\t\tcompPosition.put(key, xPos*zom+\"#\"+yPos*zom);\n\t\t\t\t// State Image (End)\n\n\t\t\t\t//Component Name (Begin)\n\t\t\t\tvar textstr = comptip;\n\t\t\t\tif(comptip.length > 22)\n\t\t\t\t{\n\t\t\t\t\tvar mid ;\n\t\t\t\t\tif(textstr.length % 2 == 0)\n\t\t\t\t\t\tmid = textstr.length / 2;\n\t\t\t\t\telse\n\t\t\t\t\t\tmid = (textstr.length + 1) / 2;\n\t\t\t\t\ttextstr = comptip.substring(0,mid)+\"\\n\"+comptip.substring(mid);\n\t\t\t\t}\n\t\t\t\tvar tX = parseInt(coX);\n\t\t\t\tvar tY = parseInt(coY);\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t\tcompIndexMap.put(key,compInd);\n\t\tcompInd = compInd + 1;\n\t}\n\n\tif(resize == \"true\"){\n\t\tresizePaperDiv(iniMaxW, iniMaxH);\n\t}\n\t// Creating connections between components.......\n\tcreateConnections(topostring);\n\t//setZoomLevel('1');\n\t//setZoomLevel('-1');\n}\n\nfunction createConnections(topostr)\n{\n\tvar tokens = topostr.split(\"|\");\n\tfor(var i = 0;i<tokens.length;i++)\n\t{\n\t\tvar tokvalue = tokens[i];\n\t\tvar lhs = tokvalue.substring(0,tokvalue.indexOf(\"=\"));\n");
      out.write("\t\tvar rhs = tokvalue.substring(tokvalue.indexOf(\"=\")+1);\n\t\tvar key = lhs;\n\n\t\tif(i==0){\n\t\t\tkey = \"egurkha.physical.topology\";\n\t\t}\n\t\tvar lhsInd = compIndexMap.get(key);\n\t\tif(rhs != 'null')\n\t\t{\n\t\t\tvar rhsArr = rhs.split(\",\");\n\t\t\tfor(var j=0;j<rhsArr.length;j++)\n\t\t\t{\n\t\t\t\tvar element = rhsArr[j];\n\t\t\t\telement = element.substring(0,element.lastIndexOf(\":\"));\n\t\t\t\tvar LorN = element.substring(element.lastIndexOf(\":\")+1);\n\t\t\t\telement = element.substring(0,element.lastIndexOf(\":\"));\n\t\t\t\tvar elementInd = compIndexMap.get(element);\n\t\t\t\tconnectionArr.push(lhsInd+\":\"+LorN+\">\"+elementInd);\n\t\t\t}\n\t\t}\n\t}\n}\n\nfunction drawComponents(){\n\treturn this.eGComps;\n}\nfunction drawimgNames ()\n{\n\treturn alltpNames;\n}\n\nwindow.onload = mainFunction;\n\nfunction mainFunction ()\n{\n\tif(\"");
      out.print(isEntry);
      out.write("\" == \"true\")\n\t{\n\t\tgetMapDetails(positionString, newcompstring, unmanagerstring);\n\t\tvar key;\n\t\tvar thisIndex;\n\t\tvar statesrc;\n\t\tvar newUnmanageSrc;\n\t\tvar newUnmanageLabelMap = new Map();\n\n\t\tif(\"");
      out.print(dragEnabled);
      out.write("\" == \"true\")\n\t\t{\n\t\t\tvar dragger = function () {\n\t\t\t\t\t\t\t\t//alert(this.attr(\"src\")+\"   \"+this.attr(\"title\"));\n\t\t\t\t\t\t\t\tvar src = this.attr(\"src\");\n\t\t\t\t\t\t\t\tvar title = this.attr(\"title\");\n\t\t\t\t\t\t\t\tif(title.indexOf(\":\") < 0)\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\ttitle = title+\":NULL\";\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif (src.indexOf(\".gif\")>0)\n\t\t\t\t\t\t\t\t\tsrc = src.substring(src.lastIndexOf(\"/\")+1,src.indexOf(\".gif\"));\n\t\t\t\t\t\t\t\telse if (src.indexOf(\".png\")>0)\n\t\t\t\t\t\t\t\t\tsrc = src.substring(src.lastIndexOf(\"/\")+1,src.indexOf(\".png\"));\n\n\t\t\t\t\t\t\t\tif(src == 'user_image')\n\t\t\t\t\t\t\t\t\tkey =\"egurkha.physical.topology\";\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tkey = src+\":\"+title;\n\t\t\t\t\t\t\t\tthisIndex = compIndexMap.get(key);\n\n\t\t\t\t\t\t\t\tif(this.type == \"image\")\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\tthis.ox = this.attr(\"x\");\n\t\t\t\t\t\t\t\t\tthis.oy = this.attr(\"y\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(thisIndex >0)\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\tstatesrc = stateCircles[thisIndex].attr('src');\n\t\t\t\t\t\t\t\t\tstateCircles[thisIndex].remove();\n\t\t\t\t\t\t\t\t\tcompNames[thisIndex].remove();\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\tvar value = compLabelMap.get(key); // Key:Raphael Object\n");
      out.write("\t\t\t\t\t\t\t\t\tvar newUnArray = new Array();\n\t\t\t\t\t\t\t\t\tif(value!=undefined)\n\t\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\t\tfor(var k=0;k<value.length;k++)\n\t\t\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\t\t\tvar imgObj = value[k];\n\t\t\t\t\t\t\t\t\t\t\tnewUnmanageSrc = imgObj.attr('src');\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\tnewUnArray.push(newUnmanageSrc);\n\t\t\t\t\t\t\t\t\t\t\tnewUnmanageLabelMap.put(key,newUnArray); // Key:image Name\n\t\t\t\t\t\t\t\t\t\t\timgObj.remove();\n\t\t\t\t\t\t\t\t\t\t\t//newImage[k].remove();\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\tif(rectShape!='')\n\t\t\t\t\t\t\t\t\t\trectShape.remove();\n\t\t\t\t\t\t\t\t}\n\t\t\t},\n\t\t\tmove = function (dx, dy) {\n\t\t\t\t\t\t\t\t\tif(this.type == \"image\")\n\t\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\t\tvar att =  {x: this.ox + dx, y: this.oy + dy};\n\t\t\t\t\t\t\t\t\t\tthis.attr(att);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tfor (var i = connections.length; i--;) {\n\t\t\t\t\t\t\t\t\t\tr.connection('#");
      out.print(color);
      out.write("',connections[i]);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tr.safari();\n\t\t\t},\n\t\t\tup = function () {\n\t\t\t\t\t\t\tcompPosition.put(key,this.attr(\"x\")+\"#\"+this.attr(\"y\"));\n\t\t\t\t\t\t\tif(key!=\"egurkha.physical.topology\")\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\tstateCircles[thisIndex] = r.image(statesrc,this.attr(\"x\"),this.attr(\"y\"),50*zom,50*zom);\n\t\t\t\t\t\t\t\tstateCircles[thisIndex].toBack();\n\t\t\t\t\t\t\t\tvar textstr = this.attr(\"title\");\n\t\t\t\t\t\t\t\tif(textstr.length > 15)\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\tvar mid ;\n\t\t\t\t\t\t\t\t\tif(textstr.length % 2 == 0)\n\t\t\t\t\t\t\t\t\t\tmid = textstr.length / 2;\n\t\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\t\tmid = (textstr.length + 1) / 2;\n\t\t\t\t\t\t\t\t\ttextstr = textstr.substring(0,mid)+\"\\n\"+textstr.substring(mid);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tcompNames[thisIndex] = r.text(this.attr(\"x\")+20*zom ,this.attr(\"y\") + 60*zom , textstr).attr({\"font-size\" : 11*zom});\n\t\t\t\t\t\t\t\tvar mapValue = newUnmanageLabelMap.get(key);\n\t\t\t\t\t\t\t\tif(mapValue!=undefined && mapValue!=null)\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\tvar arrValue = new Array();\n\t\t\t\t\t\t\t\t\tfor(var k=0;k<mapValue.length;k++)\n\t\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\t\tvar link = mapValue[k];\n\t\t\t\t\t\t\t\t\t\tif(link=='");
      out.print(contextPath);
      out.write("'+'icon_new_component.png')\n\t\t\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\t\t\tnewImage[k] = r.image(link,this.attr(\"x\")-5*zom,this.attr(\"y\")-8*zom,newWidth,newHeight);\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\telse if(link=='");
      out.print(contextPath);
      out.write("'+'icon_unmanaged_component.png')\n\t\t\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\t\t\tnewImage[k] = r.image(link,this.attr(\"x\"),this.attr(\"y\")+22*zom,newWidth,newHeight);\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\telse if(link=='");
      out.print(contextPath);
      out.write("'+'icon_recently_component.png')\n\t\t\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\t\t\tnewImage[k] = r.image(link,this.attr(\"x\")+30*zom,this.attr(\"y\")-8*zom,newWidth,newHeight);\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\tarrValue.push(newImage[k]);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tcompLabelMap.put(key,arrValue);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\tif(rectShape!='')\n\t\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\t\t/*rectShape.remove();\n\t\t\t\t\t\t\t\t\trectShape.toBack();\n\t\t\t\t\t\t\t\t\trectShape = r.rect (this.attr(\"x\")-5*zom, this.attr(\"y\")-5*zom, this.attr('width')+10*zom,this.attr('height')+5*zom).attr({\n\t\t\t\t\t\t\t\t\t\t\"stroke-width\": 2, \n\t\t\t\t\t\t\t\t\t\t\"stroke\" : '#");
      out.print(dark);
      out.write("'\n\t\t\t\t\t\t\t\t\t});*/\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbeatFunction(shapes, compNames , thisIndex,connections);\n\t\t\t},\n\n\t\t\tconnections = [],\n\t\t\tshapes = drawComponents(),\n\t\t\tstateCircles = drawStateCircles(),\n\t\t\tcompNames = drawCompNames(),\n\t\t\tnewImage = drawNewLabels(),\n\t\t\tcompLabelMap = getCompLabels();\n\t\t\t\n\t\t\tvar menu = showExtMenu();\n\t\t\tfor (var i = 0, ii = shapes.length; i < ii; i++){\n\t\t\t\t//beatFunction(shapes, i, connections, compNames);\n\t\t\t\t/*shapes[i].hover(function () {\n\t\t\t\tthis.stop().animate({'scale' : '1.2 1.2'}, 500);\n\t\t\t\t},  function () {\n\t\t\t\t\tthis.stop().attr({'scale' : '1 1'});\n\t\t\t\t});*/\n\t\t\t\tshapes[i].attr({cursor: \"move\"});\n\t\t\t\tshapes[i].drag(move, dragger, up);\n\t\t\t\tbeatFunction(shapes, compNames, i, connections,menu);\n\t\t\t}\n\n\t\t\tfor(var k=0;k<connectionArr.length;k++)\n\t\t\t{\n\t\t\t\tvar link = connectionArr[k];\n\t\t\t\tvar lorn = link.substring(link.indexOf(\":\")+1, link.indexOf(\">\"));\n\t\t\t\tvar ind1 = link.substring(0,link.indexOf(\":\"));\n\t\t\t\tvar ind2 = link.substring(link.indexOf(\">\")+1);\n\t\t\t\tconnections.push(r.connection('#");
      out.print(color);
      out.write("',shapes[ind1], shapes[ind2], \"#");
      out.print(color);
      out.write("\",\"#");
      out.print(color);
      out.write("|1\",lorn)); \n\t\t\t}\n\t\t}\n\t\telse\n\t\t{\n\t\t\tvar menu = showExtMenu();\n\t\t\tvar connections = [],\n\t\t\tshapes = drawComponents(),\n\t\t\tstateCircle = drawStateCircles(),\n\t\t\tcompNames = drawCompNames(),\n\t\t\tnewImage = drawNewLabels();\n\t\t\tfor (var i = 0, ii = shapes.length; i < ii; i++){\n\t\t\t\tbeatFunction(shapes, compNames ,i, connections,menu );\n\t\t\t\t/*shapes[i].hover(function () {\n\t\t\t\tthis.stop().animate({'scale' : '1.2 1.2'}, 500);\n\t\t\t\t},  function () {\n\t\t\t\t\tthis.stop().attr({'scale' : '1 1'});\n\t\t\t\t});*/\n\t\t\t}\n\n\t\t\tfor(var k=0;k<connectionArr.length;k++)\n\t\t\t{\n\t\t\t\tvar link = connectionArr[k];\n\t\t\t\tvar lorn = link.substring(link.indexOf(\":\")+1, link.indexOf(\">\"));\n\t\t\t\tvar ind1 = link.substring(0,link.indexOf(\":\"));\n\t\t\t\tvar ind2 = link.substring(link.indexOf(\">\")+1);\n\t\t\t\tconnections.push(r.connection('#");
      out.print(color);
      out.write("',shapes[ind1], shapes[ind2], \"#");
      out.print(color);
      out.write("\",\"#");
      out.print(color);
      out.write("|1\",lorn)); \n\t\t\t}\n\t\t}\n\t}\n\tpageHeightWidth();\n}\n\nfunction beatFunction(shapesObj,compNamesObj, index, connectionObj,menu)\n{\n\tshapesObj[index].mouseover (function (event) {\n\t\tfor(var k=0;k<connectionArr.length;k++)\n\t\t{\n\t\t\tvar link = connectionArr[k];\n\t\t\tvar lorn = link.substring(link.indexOf(\":\")+1, link.indexOf(\">\"));\n\t\t\tvar ind1 = link.substring(0,link.indexOf(\":\"));\n\t\t\tvar ind2 = link.substring(link.indexOf(\">\")+1);\n\n\t\t\tif(ind1 == index || ind2 == index)\n\t\t\t{\n\t\t\t\tif(connectionObj[k]!=null)\n\t\t\t\t{\n\t\t\t\t\t//connectionObj[k].line.toFront();\n\t\t\t\t\t//connectionObj[k].tri.toFront();\n\t\t\t\t\tconnectionObj[k].line.animate({'stroke' : '#");
      out.print(dark);
      out.write("', 'stroke-width' : 2*zom},500);\n\t\t\t\t\tconnectionObj[k].tri.animate({'stroke' : '#");
      out.print(dark);
      out.write("','fill' : '#");
      out.print(dark);
      out.write("', 'stroke-width' : 2*zom},500);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\tshapesObj[index].mouseout (function (event){\n\t\tfor(var k=0;k<connectionArr.length;k++)\n\t\t{\n\t\t\tvar link = connectionArr[k];\n\t\t\tvar lorn = link.substring(link.indexOf(\":\")+1, link.indexOf(\">\"));\n\t\t\tvar ind1 = link.substring(0,link.indexOf(\":\"));\n\t\t\tvar ind2 = link.substring(link.indexOf(\">\")+1);\n\n\t\t\tif(ind1 == index || ind2 == index)\n\t\t\t{\n\t\t\t\tif(connectionObj[k]!=null)\n\t\t\t\t{\n\t\t\t\t\t//connectionObj[k].line.toBack();\n\t\t\t\t\t//connectionObj[k].tri.toBack();\n\t\t\t\t\tconnectionObj[k].line.animate({'stroke' : '#");
      out.print(color);
      out.write("', 'stroke-width' : 1*zom},500);\n\t\t\t\t\tconnectionObj[k].tri.animate({'stroke' : '#");
      out.print(color);
      out.write("','fill' : '#");
      out.print(color);
      out.write("', 'stroke-width' : 1*zom},500);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\tshapesObj[index].mousedown (function (event){\n\t\t\n\t\tvar isShow = false;\n\t\tvar isDiv = false;\n\t\tvar browser = navigator.appName;\n\t\t//$j(\"#menudiv\").hide(\"slow\");\n\t\tif(browser == \"Microsoft Internet Explorer\"){\t\t// Browser\tLeft Click\tMiddle Click\tRight Click\n\t\t\tif(event.button == 2)\t\t\t\t\t\t\t// Firefox\t\t0\t\t\t1\t\t\t\t2\n\t\t\t\tisShow = true;\t\t\t\t\t\t\t\t//\tIE\t\t\t1\t\t\t4\t\t\t\t2\n\t\t\telse if(event.button == 1)\n\t\t\t\tisDiv = true;\n\t\t}\n\t\telse{\n\t\t\tif(event.button == 2)\n\t\t\t\tisShow = true;\n\t\t\telse if(event.button == 0)\n\t\t\t\tisDiv = true;\n\t\t}\n\t\t//var src = this.attr(\"src\");\n\t\tvar src = this.attr(\"CompType\");\n\t\tvar title = this.attr(\"title\");\n\t\tvar status =\"MANAGED\";\n\t\t//if(isShow || isDiv)\n\t\t//{\n\t\t\tif(src.indexOf(\"Unknown_server\") < 0){\n\t\t\t\tvar comptype = '';\n\t\t\t\t//if (src.indexOf(\".gif\")>0)\n\t\t\t\t\t//first = src.substring(src.lastIndexOf(\"/\")+1,src.indexOf(\".gif\"));\n\t\t\t\t//else if (src.indexOf(\".png\")>0)\n\t\t\t\t//{\n\t\t\t\t\t//first = src.substring(src.lastIndexOf(\"/\")+1,src.indexOf(\".png\"));\n\t\t\t\t//}\n\t\t\t\tfirst =src;\n");
      out.write("\t\t\t\tvar second = title;\n\t\t\t\tif(title.indexOf(\":\") < 0)\n\t\t\t\t\tsecond = second+\":\"+\"NULL\";\n\t\t\t\tvar key = first +\":\"+ second;\n\t\t\t\tvar newstr = newUnmanageMap.get(key);\n\t\t\t\tif(newstr!=null)\n\t\t\t\t{\n\t\t\t\t\tif(newstr == 'NEW')\n\t\t\t\t\t{\n\t\t\t\t\t\tstatus = \"NEW\";\n\t\t\t\t\t}\n\t\t\t\t\telse if(newstr == 'UNMANAGE')\n\t\t\t\t\t{\n\t\t\t\t\t\tstatus = \"UNMANAGE\";\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\telse{\n\t\t\t\tstatus =\"UNKNOWN\";\n\t\t\t}\n\t\t\tdocument.getElementById('h_title').value = title;\n\t\t\tdocument.getElementById('h_src').value = src;\n\t\t\tdocument.getElementById('h_status').value = status;\n\t\t\t\n\t\t\tif(title == 'User')\n\t\t\t\tstatus = \"User\";\n\t\t//}\n\n\t\tif(\"");
      out.print(dragEnabled);
      out.write("\" == \"false\" && '");
      out.print(isFull);
      out.write("' == 'false'){\n\t\t\tif(rectShape!='')\n\t\t\t\trectShape.remove();\n\t\t\trectShape = r.rect (this.attr(\"x\")-5*zom, this.attr(\"y\")-5*zom, this.attr('width')+10*zom,this.attr('height')+5*zom).attr({\n\t\t\t\t\"stroke-width\": 0, \n\t\t\t\t\"stroke\" : '#");
      out.print(dark);
      out.write("'\n\t\t\t});\n\t\t\trectShape.toBack();\n\t\t\tif(isShow){\n\t\t\t\t//ItemSelMenu(event, status);\n\t\t\t}\n\t\t\t//var p_link = $j(\"#lorn\").attr(\"value\");\n\t\t\t//OpenConnectUsesDiv(p_link);\n\n\t\t\t//Ext Js\n\t\t\t//Ext.getCmp('ExtMenu').setVisible(true);\n\t\t\tExt.each(shapesObj[index], function(raphaelElement) \n\t\t\t{\n\t\t\t\tExt.fly(raphaelElement.node).on('click',function(e) \n\t\t\t\t{\n\t\t\t\t\twindow.parent.nameCheck();\n\t\t\t\t\te.stopEvent();\n\t\t\t\t\tmenu.showAt(e.getXY());\n\t\t\t\t\tExt.getCmp('ExtMenu').setHeight(130);\n\t\t\t\t\tif(status == \"NEW\" || status == \"UNMANAGE\")\n\t\t\t\t\t{\n\t\t\t\t\t\tExt.getCmp('ExtMenu').setHeight(150);\n\t\t\t\t\t\tExt.getCmp('grouprow').setVisible(false);\n\t\t\t\t\t\tExt.getCmp('ungrouprow').setVisible(false);\n\t\t\t\t\t\t\n\t\t\t\t\t\tif(!Ext.getCmp('usesrow').isVisible()) \n\t\t\t\t\t\t\tExt.getCmp('usesrow').setVisible(true);\n\t\t\t\t\t\tif(!Ext.getCmp('removerow').isVisible()) \n\t\t\t\t\t\t\tExt.getCmp('removerow').setVisible(true);\n\t\t\t\t\t\tif(!Ext.getCmp('managerow').isVisible()) \n\t\t\t\t\t\t\tExt.getCmp('managerow').setVisible(true);\n\t\t\t\t\t\tif(!Ext.getCmp('groupcreate').isVisible()) \n\t\t\t\t\t\t\tExt.getCmp('groupcreate').setVisible(true);\n");
      out.write("\t\t\t\t\t}\n\t\t\t\t\telse if(status == \"MANAGED\")\n\t\t\t\t\t{\n\t\t\t\t\t\tExt.getCmp('managerow').setVisible(false);\n\t\t\t\t\t\tExt.getCmp('groupcreate').setVisible(false);\n\t\t\t\t\t\tif(!Ext.getCmp('usesrow').isVisible()) \n\t\t\t\t\t\t\tExt.getCmp('usesrow').setVisible(true);\n\t\t\t\t\t\tif(!Ext.getCmp('removerow').isVisible()) \n\t\t\t\t\t\t\tExt.getCmp('removerow').setVisible(true);\n\n\t\t\t\t\t\t//If the component is Group\n\t\t\t\t\t\tif(raphaelElement.attr('src').indexOf(\"group.png\") > 0){\n\t\t\t\t\t\t\tExt.getCmp('grouprow').setVisible(true);\n\t\t\t\t\t\t\tExt.getCmp('ungrouprow').setVisible(true);\n\t\t\t\t\t\t\tExt.getCmp('ExtMenu').setHeight(150);\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse{\n\t\t\t\t\t\t\tExt.getCmp('grouprow').setVisible(false);\n\t\t\t\t\t\t\tExt.getCmp('ungrouprow').setVisible(false);\n\t\t\t\t\t\t\tif(!Ext.getCmp('groupcreate').isVisible()) \n\t\t\t\t\t\t\t\tExt.getCmp('groupcreate').setVisible(true);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\telse if(status == \"User\"){\n\t\t\t\t\t\tExt.getCmp('usesrow').hide();\n\t\t\t\t\t\tExt.getCmp('removerow').hide();\n\t\t\t\t\t\tExt.getCmp('managerow').hide();\n\t\t\t\t\t\tExt.getCmp('grouprow').hide();\n\t\t\t\t\t\tExt.getCmp('ungrouprow').hide();\n");
      out.write("\t\t\t\t\t\tExt.getCmp('groupcreate').hide();\n\t\t\t\t\t\tExt.getCmp('ExtMenu').setHeight(50);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\t\t}\n\t});\n\n}\n\n//EXTJS Menu\nfunction showExtMenu()\n{\n\tvar menu = Ext.create('Ext.menu.Menu', {\n            width: 150,\n            height: 130,\n            margin: '0 0 0 0',\n            floating: true,  // usually you want this set to True (default)\n           // renderTo: Ext.getBody(),  // usually rendered by it's containing component\n\t\t\tid:'ExtMenu',\n\t\t\t//z-index:10,\n\t\t\thidden:true,\n            items: [\n\t\t\t\t{\n\t\t\t\t\tid:'managerow',\n\t\t\t\t\ttext:'Manage',\n\t\t\t\t\thidden:true,\n\t\t\t\t\thandler:OpenManageSingleDiv\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid:'usesrow',\n                    text: 'Uses',\n\t\t\t\t\thandler: OpenUsesDivForParam\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid:'connectsrow',\n\t\t\t\t\ttext: 'Connects',\n\t\t\t\t\thandler: OpenConnectsDivForParam\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid:'removerow',\n                    text: 'Remove',\n\t\t\t\t\thandler: MyRemoveFunction\n\t\t\t\t}\n\t\t\t\t\t,\n\t\t\t\t{\n\t\t\t\t\tid:'grouprow',\n                    text: 'Details',\n\t\t\t\t\thandler: ShowGroupDetails\n\t\t\t\t},\n\t\t\t\t{\n");
      out.write("\t\t\t\t\tid:'groupcreate',\n                    text: 'Add To Group',\n\t\t\t\t\thandler: createGroup\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid:'ungrouprow',\n\t\t\t\t\ttext:'Ungroup',\n\t\t\t\t\thandler: unGroupFunction\n\t\t\t\t}\n\t\t\t]\n    }); \n\treturn menu;\n}\nfunction onItemClick()\n{\n\tExt.getCmp('managerow').setVisible(true);\n}\n\nfunction OpenConnectsDiv()\n{\n\tExt.getCmp('managerow').setVisible(true);\n}\n\nfunction drawCompNames (){\n\treturn allCompNames;\n}\nfunction drawimgNames ()\n{\n\treturn alltpNames;\n}\nfunction getCompLabels(){\n\treturn compLables;\n}\n\nfunction drawStateCircles()\n{\n\tvar cirArr = new Array();\n\t\n\tvar keys = compPosition.listKeys();\n\tfor(var k=0;k<keys.length;k++)\n\t{\n\t\tif(k==0)\n\t\t{\n\t\t\tcirArr.push(\"egurkha.physical.topology\");\n\t\t\tallCompNames.push(\"egurkha.physical.topology\");\n\t\t\talltpNames.push(\"egurkha.physical.topology\");\n\t\t\tcontinue;\n\t\t}\n\t\tvar key = keys[k];\n\t\tvar val = compPosition.get(key);\n\t\tvar xpoint = parseInt(val.substring(0,val.indexOf(\"#\")));\n\t\tvar ypoint = parseInt(val.substring(val.indexOf(\"#\")+1));\n\n\t\t//var scir = r.image('");
      out.print(contextPath);
      out.write("'+'server_gray.png',xpoint,ypoint,gifWidth,gifHeight);\n\t\t\n\t\t//scir.toBack();\n\t\t//cirArr.push(scir);\n\t\tvar isnew = newUnmanageMap.get(key);\n\t\tif(isnew!=null)\n\t\t{\n\t\t\tif(isnew == \"NEW\"){\n\t\t\t\tvar newimg = r.image('/final/admin/eg_images/'+'icon_new_component.png',xpoint-5*zom,ypoint-8*zom,newWidth,newHeight);\n\t\t\t\tnewUnmanageLables.push(newimg);\n\t\t\t\t\n\t\t\t\tvar add = new Array();\n\t\t\t\tadd.push(newimg);\n\t\t\t\tcompLables.put(key,add);\n\t\t\t}\n\t\t\telse if(isnew == \"UNMANAGE\"){\n\t\t\t\tvar unmanageimg = r.image('/final/admin/eg_images/'+'icon_unmanaged_component.png',xpoint,ypoint+22*zom,newWidth,newHeight)\n\t\t\t\tnewUnmanageLables.push(unmanageimg);\n\n\t\t\t\tvar add = new Array();\n\t\t\t\tadd.push(unmanageimg);\n\t\t\t\tcompLables.put(key,add);\n\t\t\t}\t\t\t\n\t\t}\n\t\telse\n\t\t{\n\t\t\tnewUnmanageLables.push(\"noimg\");\n\t\t}\n\t\tvar latest = \"\";\n\t\t//if(sessionstring.indexOf(key) < 0)\n\t\tif(comparisonString != null && comparisonString.indexOf(key) > -1 && isFlag)\n\t\t{\n\t\t\tif(\"");
      out.print(modifySegment);
      out.write("\" == \"false\" || \"");
      out.print(fromAutoCompType);
      out.write("\" == \"true\")\n\t\t\t{\n\t\t\t\tlatest = r.image('/final/admin/eg_images/'+'icon_recently_component.png',xpoint+30*zom,ypoint-8*zom,newWidth,newHeight);\n\t\t\t\tnewUnmanageLables.push(latest);\n\t\t\t\t\n\t\t\t\tvalue = compLables.get(key);\n\t\t\t\tif(value!=undefined && value!=null)\n\t\t\t\t{\n\t\t\t\t\tvalue.push(latest);\n\t\t\t\t\tcompLables.put(key,value);\n\t\t\t\t}\n\t\t\t\telse\n\t\t\t\t{\n\t\t\t\t\tvar add = new Array();\n\t\t\t\t\tadd.push(latest);\n\t\t\t\t\tcompLables.put(key,add);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\t//getting component name\n\t\tvar textMsg;\n\t\t\n\t\tvar msg=key.substring(0,key.indexOf(\":\"));\n\t\t//alert(msg);\n\t\tif(msg.indexOf('Agg_') == 0) {\n\t\t\tmsg=msg.substring(4);\n\t\t\ttextMsg=egtop_iniMap.get(msg);\n\t\t\ttextMsg=textMsg+\" \"+\"Aggregate\";\n\t\t}\n\t\telse\n\t\t{\n\t\t\ttextMsg=egtop_iniMap.get(msg);\n\t\t}\n\t\tvar compTextName=textMsg;\n\t\tvar typeFlag=false;\n\t\tif(textMsg.length > 22)\n\t\t{\n\t\t\tvar midval ;\n\t\t\tif(compTextName.length % 2 == 0)\n\t\t\t\tmidval = compTextName.length / 2;\n\t\t\telse\n\t\t\t\tmidval = (compTextName.length + 1) / 2;\n\t\t\tcompTextName = textMsg.substring(0,midval)+\"\\n\"+textMsg.substring(midval);\n\t\t\ttypeFlag=true;\n");
      out.write("\t\t}\n\t\t\n\t\t//end\n\t\tvar compName = key.substring(key.indexOf(\":\")+1);\n\t\tif(compName.indexOf(\":NULL\") > 0)\n\t\t\tcompName = compName.substring(0,compName.indexOf(\":NULL\"));\n\t\tvar textstr = compName;\n\t\tvar compFlag=false;\n\t\tif(compName.length > 22)\n\t\t{\n\t\t\tvar mid ;\n\t\t\tif(textstr.length % 2 == 0)\n\t\t\t\tmid = textstr.length / 2;\n\t\t\telse\n\t\t\t\tmid = (textstr.length + 1) / 2;\n\t\t\ttextstr = compName.substring(0,mid)+\"\\n\"+compName.substring(mid);\n\t\t\tcompFlag=true;\n\t\t}\n\t\t/*if((textMsg.length > 22) || (compName.length > 22))\n\t\t{\n\t\t\talltpNames.push(r.text(xpoint+29*zom,ypoint+63*zom,compTextName).attr({\"font-size\" : 11*zom,'font-weight': 'bold',\"font-family\":\"Tahoma\"}));\n\t\t}\n\t\telse\n\t\t{\n\t\t\talltpNames.push(r.text(xpoint+29*zom,ypoint+56*zom,compTextName).attr({\"font-size\" : 11*zom,'font-weight': 'bold',\"font-family\":\"Tahoma\"}));\n\t\t}\n\t\tif((textMsg.length > 22) || (compName.length > 22))\n\t\t{\n\t\t\tallCompNames.push(r.text(xpoint+29*zom,ypoint+92*zom,textstr).attr({\"font-size\" : 11*zom}));\n\t\t}\n\t\telse\n\t\t{\n\t\t\tallCompNames.push(r.text(xpoint+29*zom,ypoint+72*zom,textstr).attr({\"font-size\" : 11*zom}));\n");
      out.write("\t\t}*/\n\t\tif(!typeFlag && !compFlag ) //1 1\n\t\t{\n\t\t\talltpNames.push(r.text(xpoint+23*zom,ypoint+55*zom,compTextName).attr({\"font-size\" : 10*zom,\"fill\": \"");
      out.print(compNameColor);
      out.write("\",\"font-family\":\"");
      out.print(fontFamilyBold);
      out.write("\"}));\n\n\t\t\tallCompNames.push(r.text(xpoint+23*zom,ypoint+70*zom,textstr).attr({\"font-size\" : 10*zom , \"fill\": \"");
      out.print(compNameColor);
      out.write("\", \"font-family\":\"");
      out.print(fontFamily);
      out.write("\"}));\n\t\t}\n\t\telse if(!typeFlag && compFlag) // 1 2\n\t\t{\n\t\t\talltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,compTextName).attr({\"font-size\" : 10*zom,\"fill\": \"");
      out.print(compNameColor);
      out.write("\",\"font-family\":\"");
      out.print(fontFamilyBold);
      out.write("\"}));\n\n\t\t\tallCompNames.push(r.text(xpoint+23*zom,ypoint+80*zom,textstr).attr({\"font-size\" : 10*zom , \"fill\": \"");
      out.print(compNameColor);
      out.write("\", \"font-family\":\"");
      out.print(fontFamily);
      out.write("\"}));\n\t\t}\n\t\telse if(typeFlag && !compFlag) // 2 1\n\t\t{\n\t\t\talltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,compTextName).attr({\"font-size\" : 10*zom,\"fill\": \"");
      out.print(compNameColor);
      out.write("\",\"font-family\":\"");
      out.print(fontFamilyBold);
      out.write("\"}));\n\n\t\t\tallCompNames.push(r.text(xpoint+23*zom,ypoint+80*zom,textstr).attr({\"font-size\" : 10*zom , \"fill\": \"");
      out.print(compNameColor);
      out.write("\", \"font-family\":\"");
      out.print(fontFamily);
      out.write("\"}));\n\t\t}\n\t\telse if(typeFlag && compFlag) // 2 2\n\t\t{\n\t\t\talltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,compTextName).attr({\"font-size\" : 10*zom,\"fill\": \"");
      out.print(compNameColor);
      out.write("\",\"font-family\":\"");
      out.print(fontFamilyBold);
      out.write("\"}));\n\n\t\t\tallCompNames.push(r.text(xpoint+23*zom,ypoint+88*zom,textstr).attr({\"font-size\" : 10*zom , \"fill\": \"");
      out.print(compNameColor);
      out.write("\", \"font-family\":\"");
      out.print(fontFamily);
      out.write("\"}));\n\t\t}\n\t\t\n\t}\n\treturn cirArr;\n}\n\nfunction drawNewLabels()\n{\n\treturn newUnmanageLables;\n}\n\n</script>\n");

	}


      out.write("</div> \n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\n\n<input type=\"hidden\" name=\"zoom\" id=\"zoom\" value='");
      out.print(zoomLevel);
      out.write("'>\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n</div>\n</body>\n</html>\n\n");

}
catch(Exception e){
	System.out.println("Exception in EgAutoMainPage.jsp....");
	e.printStackTrace();
}

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }

  private boolean _jspx_meth_egui_005fskin_005f0(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:skin
    com.egurkha.tags.Skin _jspx_th_egui_005fskin_005f0 = (com.egurkha.tags.Skin) _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.get(com.egurkha.tags.Skin.class);
    _jspx_th_egui_005fskin_005f0.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fskin_005f0.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(406,0) name = ui type = null reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fskin_005f0.setUi("admin");
    int _jspx_eval_egui_005fskin_005f0 = _jspx_th_egui_005fskin_005f0.doStartTag();
    if (_jspx_th_egui_005fskin_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f0);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f0);
    return false;
  }

  private boolean _jspx_meth_egui_005fskin_005f1(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:skin
    com.egurkha.tags.Skin _jspx_th_egui_005fskin_005f1 = (com.egurkha.tags.Skin) _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.get(com.egurkha.tags.Skin.class);
    _jspx_th_egui_005fskin_005f1.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fskin_005f1.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(446,0) name = ui type = null reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fskin_005f1.setUi("admin");
    int _jspx_eval_egui_005fskin_005f1 = _jspx_th_egui_005fskin_005f1.doStartTag();
    if (_jspx_th_egui_005fskin_005f1.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f1);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f1);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f0(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f0 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f0.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f0.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(824,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f0.setText("admin.server.Please select a type of component");
    int _jspx_eval_egui_005fintnl_005f0 = _jspx_th_egui_005fintnl_005f0.doStartTag();
    if (_jspx_th_egui_005fintnl_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f0);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f0);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f1(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f1 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f1.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f1.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(836,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f1.setText("admin.server.Please select a component");
    int _jspx_eval_egui_005fintnl_005f1 = _jspx_th_egui_005fintnl_005f1.doStartTag();
    if (_jspx_th_egui_005fintnl_005f1.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f1);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f1);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f2(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f2 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f2.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f2.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(873,9) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f2.setText("admin.server.Please select a type of component");
    int _jspx_eval_egui_005fintnl_005f2 = _jspx_th_egui_005fintnl_005f2.doStartTag();
    if (_jspx_th_egui_005fintnl_005f2.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f2);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f2);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f3(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f3 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f3.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f3.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(877,9) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f3.setText("admin.server.Please select a component");
    int _jspx_eval_egui_005fintnl_005f3 = _jspx_th_egui_005fintnl_005f3.doStartTag();
    if (_jspx_th_egui_005fintnl_005f3.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f3);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f3);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f4(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f4 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f4.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f4.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(908,21) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f4.setText("admin.server.Uses");
    int _jspx_eval_egui_005fintnl_005f4 = _jspx_th_egui_005fintnl_005f4.doStartTag();
    if (_jspx_th_egui_005fintnl_005f4.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f4);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f4);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f5(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f5 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f5.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f5.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(910,18) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f5.setText("admin.server.Connects");
    int _jspx_eval_egui_005fintnl_005f5 = _jspx_th_egui_005fintnl_005f5.doStartTag();
    if (_jspx_th_egui_005fintnl_005f5.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f5);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f5);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f6(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f6 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f6.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f6.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(1808,14) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f6.setText("admin.server.Manage Discovered / Unmanaged  Components");
    int _jspx_eval_egui_005fintnl_005f6 = _jspx_th_egui_005fintnl_005f6.doStartTag();
    if (_jspx_th_egui_005fintnl_005f6.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f6);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f6);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f7(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f7 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f7.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f7.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(1810,11) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f7.setText("admin.server.Save Segment");
    int _jspx_eval_egui_005fintnl_005f7 = _jspx_th_egui_005fintnl_005f7.doStartTag();
    if (_jspx_th_egui_005fintnl_005f7.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f7);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f7);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f8(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f8 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f8.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f8.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(1812,11) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f8.setText("admin.server.Save Segment as");
    int _jspx_eval_egui_005fintnl_005f8 = _jspx_th_egui_005fintnl_005f8.doStartTag();
    if (_jspx_th_egui_005fintnl_005f8.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f8);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f8);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f9(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f9 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f9.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f9.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2399,168) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f9.setText("admin.server.Manage");
    int _jspx_eval_egui_005fintnl_005f9 = _jspx_th_egui_005fintnl_005f9.doStartTag();
    if (_jspx_th_egui_005fintnl_005f9.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f9);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f9);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f10(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f10 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f10.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f10.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2402,168) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f10.setText("admin.server.Uses");
    int _jspx_eval_egui_005fintnl_005f10 = _jspx_th_egui_005fintnl_005f10.doStartTag();
    if (_jspx_th_egui_005fintnl_005f10.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f10);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f10);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f11(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f11 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f11.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f11.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2405,170) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f11.setText("admin.server.Connect");
    int _jspx_eval_egui_005fintnl_005f11 = _jspx_th_egui_005fintnl_005f11.doStartTag();
    if (_jspx_th_egui_005fintnl_005f11.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f11);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f11);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f12(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f12 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f12.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f12.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2408,169) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f12.setText("admin.server.Remove");
    int _jspx_eval_egui_005fintnl_005f12 = _jspx_th_egui_005fintnl_005f12.doStartTag();
    if (_jspx_th_egui_005fintnl_005f12.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f12);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f12);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f13(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f13 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f13.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f13.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2411,168) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f13.setText("admin.server.Details");
    int _jspx_eval_egui_005fintnl_005f13 = _jspx_th_egui_005fintnl_005f13.doStartTag();
    if (_jspx_th_egui_005fintnl_005f13.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f13);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f13);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f14(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f14 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f14.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f14.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2414,171) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f14.setText("admin.server.Group");
    int _jspx_eval_egui_005fintnl_005f14 = _jspx_th_egui_005fintnl_005f14.doStartTag();
    if (_jspx_th_egui_005fintnl_005f14.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f14);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f14);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f15(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f15 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f15.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f15.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2417,170) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f15.setText("admin.server.Ungroup");
    int _jspx_eval_egui_005fintnl_005f15 = _jspx_th_egui_005fintnl_005f15.doStartTag();
    if (_jspx_th_egui_005fintnl_005f15.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f15);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f15);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f16(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f16 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f16.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f16.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2432,172) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f16.setText("admin.server.Manage all");
    int _jspx_eval_egui_005fintnl_005f16 = _jspx_th_egui_005fintnl_005f16.doStartTag();
    if (_jspx_th_egui_005fintnl_005f16.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f16);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f16);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f17(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f17 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f17.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f17.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2435,166) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f17.setText("admin.server.Save topology");
    int _jspx_eval_egui_005fintnl_005f17 = _jspx_th_egui_005fintnl_005f17.doStartTag();
    if (_jspx_th_egui_005fintnl_005f17.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f17);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f17);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f18(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f18 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f18.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f18.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2438,166) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f18.setText("admin.server.Save topology as");
    int _jspx_eval_egui_005fintnl_005f18 = _jspx_th_egui_005fintnl_005f18.doStartTag();
    if (_jspx_th_egui_005fintnl_005f18.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f18);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f18);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f19(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f19 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f19.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f19.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2444,169) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f19.setText("admin.server.Refresh");
    int _jspx_eval_egui_005fintnl_005f19 = _jspx_th_egui_005fintnl_005f19.doStartTag();
    if (_jspx_th_egui_005fintnl_005f19.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f19);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f19);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f20(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f20 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f20.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f20.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2447,170) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f20.setText("admin.server.Clear all");
    int _jspx_eval_egui_005fintnl_005f20 = _jspx_th_egui_005fintnl_005f20.doStartTag();
    if (_jspx_th_egui_005fintnl_005f20.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f20);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f20);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f22(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f22 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f22.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f22.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2479,145) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f22.setText("admin.server.Discovered Component");
    int _jspx_eval_egui_005fintnl_005f22 = _jspx_th_egui_005fintnl_005f22.doStartTag();
    if (_jspx_th_egui_005fintnl_005f22.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f22);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f22);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f23(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f23 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f23.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f23.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2481,149) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f23.setText("admin.server.Unmanaged Component");
    int _jspx_eval_egui_005fintnl_005f23 = _jspx_th_egui_005fintnl_005f23.doStartTag();
    if (_jspx_th_egui_005fintnl_005f23.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f23);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f23);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f24(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f24 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f24.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f24.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2483,151) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f24.setText("admin.server.Managed Component");
    int _jspx_eval_egui_005fintnl_005f24 = _jspx_th_egui_005fintnl_005f24.doStartTag();
    if (_jspx_th_egui_005fintnl_005f24.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f24);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f24);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f25(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f25 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f25.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f25.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2485,148) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f25.setText("admin.server.Recently Added");
    int _jspx_eval_egui_005fintnl_005f25 = _jspx_th_egui_005fintnl_005f25.doStartTag();
    if (_jspx_th_egui_005fintnl_005f25.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f25);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f25);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f26(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f26 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f26.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f26.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2503,66) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f26.setText("admin.zone.Component positions have been saved successfully");
    int _jspx_eval_egui_005fintnl_005f26 = _jspx_th_egui_005fintnl_005f26.doStartTag();
    if (_jspx_th_egui_005fintnl_005f26.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f26);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f26);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f27(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f27 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f27.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f27.setParent(null);
    // /admin/EgAutoTopologyMainPageExt.jsp(2536,67) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f27.setText("admin.zone.Do you want to save the component position?");
    int _jspx_eval_egui_005fintnl_005f27 = _jspx_th_egui_005fintnl_005f27.doStartTag();
    if (_jspx_th_egui_005fintnl_005f27.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f27);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f27);
    return false;
  }
}
