package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.supermanager.*;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import com.egurkha.ini.*;
import com.egurkha.monitor.alarms.AlarmPriorities;
import com.egurkha.monitor.remotecontrol.PreAgentInfo;
import com.egurkha.util.HtmlUtils;
import com.eg.EgStateManager;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgURLEncoder;
import java.util.*;
import com.eg.EgServicesInfo;
import com.eg.EgDiscInfo;
import com.eg.EgManagersIniForManager;
import com.eg.EgManagerInfo;
import com.eg.EgURLEncoder;
import com.eg.EgURLDecoder;
import com.eg.EgMappingInfo;
import net.sf.json.JSONObject;
import net.sf.json.JSONArray;

public final class ControlAgentsJson_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	//String[] options = {" Running agents", "Agents in Control mode", "Agents in Normal mode"};
	String[] options = {"Control", "Waiting","Normal"};

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgMonitorTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("application/json;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*********************************************************************************************************
*	Name				:	ControlAgents.jsp
*	Version				:	eG 3.0
*	Purpose				:	Displays the agents in various modes - CONTROL, WAITING, NORMAL.
*	Creation Date	:	14/07/2000
*	Author				:	Arun / Anitha
*	Last Modified		:	10/09/2003	John		eG 3.0 Modifications
								22/09/2003	Arun		Uses IniUI.getRemoteControlMessages to display a message if agents in the
																specified mode are not found.
								26/09/2003	John		eG 3.0 Layout & Footer Include
********************************************************************************************************/


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String mgrDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	boolean isMobileCall=false;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;	
	String fromMobile=request.getParameter("fromMobile");
	String isFromMenu=request.getParameter("isFromMenu");
	String dateFormatForDatePicker ="";

	User u_ser = null;
	EgMappingInfo mappingInfo = null;
	String trackerLanguage = trackerUI.getDefaultLanguage();
	/**
			 Operation - Mobile check
			 Purpose - Support for accessing the manager via mobile.
			 Author - Praveen 8/4/2014
	**/
	if (fromMobile!=null&&fromMobile.equals("yes"))
	{
		String uname=request.getParameter("uname");
		isMobileCall=true;
		try
		{
			ErUserData userData = new ErUserData(uname,false);
			if(userData!=null)
			{
				u_ser=userData.usr;
				if(u_ser==null)
				{
					u_ser = userData.getUser(uname);
				}
				if(u_ser!=null)
				{
					String userLang = u_ser.getLanguage();
					if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
					{
						trackerLanguage=userLang;
					}
					mappingInfo = new EgMappingInfo(trackerLanguage);
				}
			}
		}
		catch(Throwable t)
		{
			t.printStackTrace();
		}
	} // Ends here
	else
	{
		if(session.getAttribute("sessionId_SM") != null)
		{
			from_sm = true;
			sessionId_sm = (String)session.getAttribute("sessionId_SM");
		}
		if(session!=null)
		{
			if(from_sm)
			{
				u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
			}
			else
			{
				u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
			}
			if(u_ser!=null)
			{
				id_u = u_ser.isIdDeletedWhileLoggedIn();
				if(id_u == false)
				{
					u_rs =  u_ser.getLoginID();
					if(!User.isDefaultUser(u_rs))
					{
						ErUserData er = u_ser.getReporterData();
						u_v_till = er.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
		}
		if ( session != null || u_ser != null )
		{
			String smartValue=request.getParameter("smart");
			String page_help=request.getRequestURI();
			if(isFromMenu != null && isFromMenu.trim().length() > 0 && smartValue==null || (smartValue!=null && smartValue.trim().length()==0) )
			{
				if(!(page_help.endsWith("EgPrintGraph.jsp") || page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")))
					session.setAttribute("Page_IdentifierM", request.getRequestURI());
			}
		}

		if (u_ser!=null)
		{
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
			String trackerUserLang = u_ser.getLanguage();
			if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
			{
				trackerLanguage=trackerUserLang;
			}
		}
		mappingInfo = new EgMappingInfo(trackerLanguage);
		if(u_ser != null)
		{
			dateFormatForDatePicker = (String)u_ser.getUserDateFormat();
		}
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}

		if(session == null || u_ser == null)
		{
			throw new Exception("<customerror>user-session-invalid</customerror>");
		}
		else if(id_u== true)
		{
			throw new Exception("<customerror>user-deleted</customerror>");
		}
		else if (u_v_till < l_accessed)
		{
			throw new Exception("<customerror>user-timedout</customerror>");
		}
	}


	int tot=0;
	int m=0;
	//String s_userid = (String) session.getValue("sess_userid");
	UserRegistry ur=UserRegistry.getInstance();
	User user = ur.getUser(session.getId());
	boolean hasAllCompAccess = user.getUserRole().hasAllComponentAccess();
	//System.out.println("Ctrl Agents		__  "+request.getQueryString());

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);



try
{
	List dispAgents  = (List)request.getAttribute("displayAgents");

	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();

	String agentMode = request.getParameter("agentMode");

	if (agentMode == null || agentMode.length() == 0 || agentMode.equalsIgnoreCase("null"))
	{
		agentMode = options[0];
	}

	String selectedAgentIp = request.getParameter("agentIP");
	if (selectedAgentIp == null || selectedAgentIp.equalsIgnoreCase("null"))
	{
		selectedAgentIp = "";
	}
	else
	{
		selectedAgentIp = EgURLDecoder.decode(selectedAgentIp,"UTF-8");
	}


	//Get the vector of agents not running
	List agentsRunning = PreAgentInfo.getRunningAgents();
	Vector agentsNotRunning = EgStateManager.notRunningAgents;
	List agentsWaiting = new LinkedList();
	List controlAgents = new LinkedList();
	List normalAgents = new LinkedList();

	IniFile iniControls = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_controls.ini");
	String[] currentCtrlAgents = iniControls.getVariables("CURRENT_CONTROLS");

	if(currentCtrlAgents != null &&  currentCtrlAgents.length > 0)
	{
		for(int i=0;i<currentCtrlAgents.length;i++)
		{
			String mode = iniControls.getValue(PreAgentInfo.CURRENT_CONTROLS, currentCtrlAgents[i]);
			if(agentsRunning.contains(currentCtrlAgents[i]))
			{
				if(mode.equalsIgnoreCase("false"))
				{
					controlAgents.add(currentCtrlAgents[i]);
					agentsRunning.remove(currentCtrlAgents[i]);
				}
				else if(mode.equalsIgnoreCase("true"))
				{
					agentsWaiting.add(currentCtrlAgents[i]);
					agentsRunning.remove(currentCtrlAgents[i]);
				}
			}
		}
	}

	if(agentsRunning != null && agentsRunning.size() > 0 )
	{
		normalAgents = agentsRunning;
	}


	List displayAgents;
	if (agentMode.equalsIgnoreCase(options[0]))
	{//Control agents
		displayAgents = (List)controlAgents;
	}
	else if (agentMode.equalsIgnoreCase(options[2]))
	{//Normal agents
		displayAgents = (List)normalAgents;
	}
	else //if (agentMode.equals(options[1]))
	{//Waiting agents
		displayAgents = (List)agentsWaiting;
	}

	Vector displayNew = new Vector();
	if(!hasAllCompAccess)
	{
		List user_servers = new Vector(user.getServers(true));

		for(int i=0;i<user_servers.size();i++)
		{
			StringTokenizer st = new StringTokenizer((String)user_servers.get(i),":");
			if(st.countTokens() > 1)
				user_servers.set(i,st.nextToken());
		}
		displayAgents.retainAll(user_servers);
	}
	if(dispAgents != null && dispAgents.size() > 0)
	{
		displayAgents = dispAgents;
	}
	session.setAttribute("form","main");

	JSONObject json = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject pageParams = new JSONObject();

	screenLabels.put("monitor.remotecontrol.Agent mode",mappingInfo.getTextDescription("monitor.remotecontrol.Agent mode"));
	screenLabels.put("monitor.remotecontrol.Agent IP",mappingInfo.getTextDescription("monitor.remotecontrol.Agent IP")+" / "+mappingInfo.getTextDescription("monitor.remotecontrol.Nick name"));
	JSONArray comboArr = new JSONArray();
	for(int i=0;i<options.length;i++)
	{
		JSONObject jOpt = new JSONObject();
		jOpt.put("displayField",mappingInfo.getTextDescription("monitor.remotecontrol."+options[i].trim()));
		jOpt.put("valueField",options[i].trim());
		if(options[i].equals(agentMode))
		{
			pageParams.put("selectedAgentMode",agentMode);
		}
		comboArr.add(jOpt);
	}
	json.put("comboArr",comboArr);									
	String errMessage = request.getParameter("errMessage");
	if (errMessage != null && !errMessage.equals("") && !errMessage.equals("null"))
	{
		String mgrIp = request.getParameter("mgrIp");
		if(errMessage.equalsIgnoreCase("NO_AGENT")){
			if(mgrIp != null && !mgrIp.equals("") && !mgrIp.equals("null")){
				errMessage = "The agent "+selectedAgentIp+" is reporting to "+mgrIp;
			}
			else{
				errMessage = "No agents found for the current search";
			}
		}											
		json.put("errorMsg",mappingInfo.getTextDescription("monitor.remotecontrol."+errMessage));
	}
	else
	{//Display the agent here
		String agentIP="";
		int size = displayAgents.size();
		if (size == 0)
		{
			String errmsg=ui.getRemoteControlMessage(agentMode);
			if(errmsg.indexOf(".")>-1)
			{
				errmsg=errmsg.substring(0,errmsg.indexOf("."));
			}
			json.put("errorMsg",mappingInfo.getTextDescription("monitor.remotecontrol."+errmsg));
		}
		JSONArray agentInfoJson = new JSONArray();
		for (int i=0; i<size; i++ )
		{
			agentIP = (String)displayAgents.get(i);
			agentMode=PreAgentInfo.getAgentMode(agentIP);

			if(agentMode == null)
			{
				agentMode = PreAgentInfo.NORMAL_MODE;
			}
			String urlForRemoteCtrlACtivity = "/final/monitor/DispAgentInfo.jsp?firstCall=true&agentIP="+EgURLEncoder.encode(agentIP,"UTF-8")+"&agentMode="+agentMode;
			
			String tmpIP =agentIP;
		/*	while(tmpIP.length() > 30)
			{
				out.println(tmpIP.substring(0,30) + "<br>");
				tmpIP =tmpIP.substring(30,tmpIP.length());
			}*/
			JSONObject rowData = new JSONObject();
			rowData.put("displayAgentName",tmpIP);
			rowData.put("toolTip",agentIP);
			rowData.put("remoteCtrlUrl",urlForRemoteCtrlACtivity);
			agentInfoJson.add(rowData);
		}
		if(agentInfoJson!=null && !agentInfoJson.isEmpty())
		{
			json.put("agentInfoJson",agentInfoJson);
			json.put("errorMsg","-");
		}
	}
	json.put("pageParams",pageParams);
	json.put("screenLabels",screenLabels);
	response.setContentType("application/json;chartset=UTF-8");
	response.getWriter().write(json.toString());
	if(request.getQueryString()!=null)
		session.setAttribute("monitorLastSession","/final/monitor/ControlAgents.jsp?"+request.getQueryString());
	else
		session.setAttribute("monitorLastSession","/final/monitor/ControlAgentsp.jsp");

	session.removeAttribute("displayAgents");
	session.setAttribute("displayAgents",displayAgents);
}
catch(Throwable t)
{
	t.printStackTrace();
}

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
