package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import com.eg.EgDateInfo;
import com.egurkha.EgTimeZoneConverter;
import java.util.TimeZone;
import java.util.Calendar;
import com.egurkha.util.DateUtil;
import egurkha.config.EcUtils;
import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgDbAdapterTypeUI;
import egurkha.*;
import com.egurkha.*;
import com.egurkha.ini.*;
import com.egurkha.util.*;
import java.sql.*;
import java.util.*;
import java.io.*;
import com.eg.EgInstallInfo;

public final class EgCurrentStatus_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


//int badCount = 0;
//int unknownCount =0;
	private int[] getStateCounts(ResultSet rs, ArrayList servers, ArrayList sites)
	{
		//Hashtable ht = new Hashtable();
		int [] count = new int[2];
		int badCount = 0;
		int unknownCount =0;
		boolean found = false;

		try
		{

			if(rs != null)
			{
				while(rs.next())
				{
					// site cname ctype state
					String site = rs.getString(1);
					String ctype = rs.getString(2);
					String cname = rs.getString(3);
					String state = rs.getString(4);
					String s = "'"+ctype+':'+cname+"'";
					if (servers.size()>0 && !servers.contains(s))
						continue;
					if (sites.size()>0 && !sites.contains("'"+site+"'"))
						continue;
					found = true;					
					if (EgConfigInfo.isBad(state))
						badCount ++;	
					else
						unknownCount ++;
				}
			}
			if(!found) // ht == null || ht.size() == 0)
			{
				count[0] = 0;
				count[1] = 0;
				return count;
			}
			count[0] = badCount;
			count[1] = unknownCount;
			return count;
		}
		catch(Exception e)
		{
			return null;
		}
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgLoginTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"EgErrorSmall.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/**
 *	Displays the current status of the servers being monitored
 *
 *	@author		Arun Jayaprakash
 *	@version	3.0
 *
 *	@modified
 *		17/10/2003	Arun	Set default % for good measures to zero
 *		28/10/2003	Arun	Uses IniUI for headings
 *		03/10/2003	Arun	Fixed bug where badMeasures would take the count of the last BAD state measure
 *							available in the database instead of all BAD state (H/I/L) measures
 *		04/10/2003	Arun	<meta> tag uses eg_ui.ini for refresh time
 *		05/11/2003	Arun	Fixed negative percentages for GOOD and 100+ percentages for UNKNOWN measures
 *							Known issue : Disabled tests might increase the count of measures while 
 *							querying MetaTest table initially
 *		13/05/2004	Arun	Clubbing of multiple components into a single alarm will not show up in 
 *							Unresolved problems
 */


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	String strCsrfToken = "";
	String strEncodedUrl = response.encodeURL(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
	if(strEncodedUrl != null)
	{
		int idx_A = strEncodedUrl.indexOf("?");
		if (idx_A != -1)
		{
			String queryString = strEncodedUrl.substring(idx_A+1);
			HashMap hashMapParameters = EcUtils.parseQueryString(queryString);
			if (hashMapParameters != null && hashMapParameters.containsKey("com.eg.CSRF_NONCE"))
			{
				strCsrfToken = (String)hashMapParameters.get("com.eg.CSRF_NONCE");
			}
		}
	}

	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	IniFile reportIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_report.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String strYaxisBasedOnData = reportIni.getValue("CHART_TYPE","YaxisBasedOnData");
	boolean isYaxisBasedOnData=false;
	if(strYaxisBasedOnData!=null && (strYaxisBasedOnData.equalsIgnoreCase("yes") || strYaxisBasedOnData.equalsIgnoreCase("true")))
		isYaxisBasedOnData = true;

	if(!request.getRequestURI().endsWith("EgMonitorHome.jsp"))
	{

      out.write("<script>\n\t\t\tfunction openWindow(path,name,winOptions)\n\t\t\t{\n\t\t\t\tvar win;\n\t\t\t\tvar obj = window.parent;\n\t\t\t\tif(window==window.parent)\n\t\t\t\t\tobj =window.opener;\n\t\t\t\tif(obj.openWindow!=null)\n\t\t\t\t\twin = obj.openWindow(path,name,winOptions);\n\t\t\t\telse\n\t\t\t\t\twin= window.open(path,name,winOptions);\n\t\t\t\treturn win;\n\t\t\t}\n\t\t</script>\n");

	}

      out.write("<script>\n\n\t/** To Disable Right Click */\n\tvar message=\"\";\n\tfunction clickIE(){if(document.all){(message);return false;}}\n\tfunction clickNS(e){if(document.layers||(document.getElementById&&!document.all)){\n\tif(e.which==2||e.which==3){(message);return false;}}}\n\tif('");
      out.print(RightClikMode);
      out.write("'=='production')\n\t{\n\t\tif (document.layers){document.captureEvents(Event.MOUSEDOWN);document.onmousedown=clickNS;}\n\t\telse{document.onmouseup=clickNS;document.oncontextmenu=clickIE;}\n\t\tdocument.oncontextmenu=new Function(\"return false\")\n\t}\n\n\n\t/**  To disable drag and selection */\n\tvar alltables = document.getElementsByTagName(\"body\");\n\tif ('");
      out.print(SelectionMode);
      out.write("' == 'production') {\n\t\twindow.onload = function() {\n\t\t\tfunction disableSelection(element) {\n\t\t\t\telement.onselectstart = function() {\n\t\t\t\t\treturn false;\n\t\t\t\t};\n\t\t\t\telement.unselectable = \"on\";\n\t\t\t\telement.style.MozUserSelect = \"none\";\n\t\t\t\telement.style.cursor = \"default\";\n\t\t\t}\n\n\t\t\tfor (var i = 0; i < alltables.length; i++) {\n\n\t\t\t\tdisableSelection(alltables[i]); //disable text selection within all tables on the page\n\t\t\t}\n\n\t\t}\n\t}\n\n\tfunction callWindow(opt)\n\t{\n\t\tvar topWindow = window;\n\t\twhile(topWindow.parent!=topWindow ||  topWindow.opener!=null)\n\t\t{\n\t\t\tmainWindow = topWindow;\n\t\t\ttopWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);\n\t\t}\n\t\tif(topWindow.location.pathname!=\"/\")\n\t\t\tmainWindow=topWindow;\n\t\tmainWindow.location.href=\"/final/servlet/com.egurkha.Logout?errmsg=\"+opt;\n\t\tmainWindow.focus();\n\t}\n</script>\n\n");

	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	String productionMode = trackerUI.getValue("UI_MIGRATION","SenchaProductionMode");
	User u_ser = null;
	boolean id_u = false;
	String u_rs = null;
	String userLogos = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;
	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		sessionId_sm = (String)session.getAttribute("sessionId_SM");
	}
	if(session!=null)
	{
		if(from_sm)
		{
			u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
		}
		else
		{
			u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
		if(u_ser!=null)
		{

			id_u = u_ser.isIdDeletedWhileLoggedIn();
			if(id_u == false)
			{
				u_rs =  u_ser.getLoginID();
				userLogos = u_ser.getUserLogo();

				trackerUI.set_loginID(u_rs);
				trackerUI.set_userLogo(userLogos);

				if(!User.isDefaultUser(u_rs))
				{
					ErUserData er = u_ser.getReporterData();
					u_v_till = er.getUserValidtill();
					l_accessed = session.getLastAccessedTime();
				}
			}
		}
	}
	if(session == null || u_ser ==null)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(1);\n\t\t</script>\n");

			return;
	}
	else if(id_u== true)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(2);\n\t\t</script>\n");

			return;
	}
	else if (u_v_till < l_accessed)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\t\tcallWindow(3);\n\t\t\t</script>\n");

			return;
	}
	else
	{
		String smartValue=request.getParameter("smart");
		String site=request.getParameter("site");
		String servicename=request.getParameter("servicename");
		String page_help=request.getRequestURI();
		if((servicename==null || servicename.trim().length()==0) && (site==null || site.trim().length()==0))
		{
		if(smartValue==null || (smartValue!=null && smartValue.trim().length()==0))
		{
			if(!(page_help.endsWith("EgPrintGraph.jsp") || 
				page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")||(page_help.indexOf("Egprintdata.jsp")>-1)))
			{
				session.setAttribute("Page_IdentifierM", request.getRequestURI());
				if(page_help!=null && page_help.endsWith("componentMeasureTabSet.jsp"))
				{
					session.setAttribute("Page_IdentifierMP", request.getRequestURI());
				}
			}
			}
		}
	}

	String timezoneOffsetValue ="";
	EgDateInfo tracker_tdateInfo = new EgDateInfo();
	TimeZone tracker_tz = null;
	if (u_ser!=null)
	{
		u_ser.setUserLanguageAndSkins();
		monitor_Skin  = u_ser.getMonitorSkin();
		String trackerUserLang = u_ser.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}

		Calendar cal = Calendar.getInstance();
		java.util.Date local_date = new java.util.Date(tracker_tdateInfo.egetUTCDate());
		cal.setTime(local_date);
		cal.setTimeZone(tracker_tdateInfo.getRealTimeZone());
		String temp1 = (cal.get(cal.MONTH)+1) + "/" + cal.get(cal.DAY_OF_MONTH) + "/" +cal.get(cal.YEAR);
		String mgr_time = cal.get(cal.HOUR_OF_DAY)+":"+cal.get(cal.MINUTE)+":"+cal.get(cal.SECOND);
		String trac_currentDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String dispDate = DateUtil.changeDateFormat(temp1,"MM/dd/yyyy",trac_currentDateFormat);
		EgTimeZoneConverter tracker_timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+mgr_time,u_ser);
		tracker_tz = tracker_timeZoneConverter.getTimeZone();

		long timezoneinMins = (Math.abs((tracker_tz.getRawOffset() / (60 * 1000))));
		long daylighttime = (tracker_tz.getDSTSavings() / (60 * 1000));
		timezoneOffsetValue = String.valueOf(Math.abs(timezoneinMins-daylighttime));

		

		Calendar cal3 = GregorianCalendar.getInstance(tracker_tz);
		int offsetInMillis = tracker_tz.getOffset(cal3.getTimeInMillis());
		int offsetmin = 0;
		if(offsetInMillis<0)
			offsetmin =(Math.abs(offsetInMillis)/1000)/60;
		else
			offsetmin = (offsetInMillis/1000)/60;
		String offset = String.valueOf(offsetmin);
		
		//if(offsetInMillis>0)
		//{
			if(tracker_tz.getRawOffset()>=0)
				timezoneOffsetValue="-"+offset;
			else
				timezoneOffsetValue="+"+offset;
		//}
		//else
			//timezoneOffsetValue = (offsetInMillis >= 0 ? "+" : "-") + offset;
	}
	else
	{
		tracker_tz = tracker_tdateInfo.getRealTimeZone();

		long timezoneinMins = (Math.abs((tracker_tz.getRawOffset() / (60 * 1000))));
		long daylighttime = (tracker_tz.getDSTSavings() / (60 * 1000));
		timezoneOffsetValue = String.valueOf(Math.abs(timezoneinMins-daylighttime));
		
		if(tracker_tz.getRawOffset()>=0)
			timezoneOffsetValue="-"+timezoneOffsetValue;
		else
			timezoneOffsetValue="+"+timezoneOffsetValue;
	}

		String  script_src="script_item_"+trackerLanguage+".js";
		String uiFileTemp = "eg_ui.ini";
		String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
		
		EgMappingInfo trackerMappingInfo = new EgMappingInfo(trackerLanguage);

		//Variable to be used in javascript code
		String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String mgrDateFormat = currentDateFormatForJS;
		String dateFormatNew = mgrDateFormat;
		if(currentDateFormatForJS.indexOf("MMM") >= 0)
		{
			for(int i=0; i < currentDateFormatForJS.length();i++)
			{
				if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
				{
					currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
				}
			}
		}

		String dateFormatForDatePicker=(String)u_ser.getUserDateFormat();
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}
		IniUI egui_temp = IniUI.getInstance();
		String  strer_modeInTracker="2D";
		

      out.write("<script>\n\tvar strSkin='");
      out.print(monitor_Skin);
      out.write("';\n\tvar isYaxisBasedOnData=");
      out.print(isYaxisBasedOnData);
      out.write(";\n\tvar netRow = ( strSkin == 'Light' )?'netRow loaded':'darkRow loaded';\n\tvar pageListRow = ( strSkin == 'Light' )?'pageRow':'darkPageRow';\n\tvar netCol = ( strSkin == 'Light' )?'netCol':'darkNetCol';\n\tvar netSummaryRow = ( strSkin == 'Light' )?'netSummaryRow':'darkNetSummaryRow';\n\tvar netSummaryRow = ( strSkin == 'Light' )?'netRow tabView':'darkNetRow darkTabView';\n\tvar netFullHrefLabel = ( strSkin == 'Light' )?'netFullHrefLabel':'netFullHrefLabel';\n\tvar er_modeInTracker='");
      out.print(strer_modeInTracker);
      out.write("'\n\tvar dateFormatForTimeline = '");
      out.print(dateFormatNew);
      out.write("';\n\tvar settings='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Settings"));
      out.write("';\n\tvar toolData='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Data"));
      out.write("';\n\tvar toolCSV='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.CSV"));
      out.write("';\n\tvar toolSave ='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.SAVE"));
      out.write("';\n\tvar toolMail='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.MAIL"));
      out.write("';\n\tvar toolPrint='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.PRINT"));
      out.write("';\n\tvar timelineLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Timeline"));
      out.write("';\n\tvar hrLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Hr"));
      out.write("';\n\tvar minLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Min"));
      out.write("';\n\tvar Tolbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.To"));
      out.write("';\n\tvar fromLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.history.From"));
      out.write("';\n\tvar graphLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.summary.Graph"));
      out.write("';\n\n\t// For Highcharts - UTC - timezoneOffset\n\tvar timeZoneOffsetVal='");
      out.print(timezoneOffsetValue);
      out.write("';\n\t//-----end-----\n\tdocument.onkeydown = fkey;\n\nfunction fkey(e){\n  e = e || window.event;\n\t  if (e.which == 116 || (e.keyCode == 82 && e.ctrlKey)) { //116 = F5\n\t\t\ttry\n\t\t\t{\n\t\t\t\twindow.parent.refreshEgIndexPage();\t\n\t\t\t}\n\t\t\tcatch (e)\n\t\t\t{\n\t\t\t\ttry{\n\t\t\t\t\twindow.parent.parent.refreshEgIndexPage();\t\n\t\t\t\t}\n\t\t\t\tcatch (e)\n\t\t\t\t{\n\t\t\t\t\twindow.opener.refreshEgIndexPage();\n\t\t\t\t}\n\t\t\t}\n\t return false;\n\t\t\n\t}\n }\n\n</script>\n\n\n\n\n\n\n\n\n\n");

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);

	IniUI ui = (IniUI)IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgDashboard");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	boolean allComp = userRole.hasAllComponentAccess();

	int badMeasures = 0;
	int unknownMeasures = 0;
	int measureCount = 0;
	int alarmCount = 0;

	double gMeasurePct = 0.0d; //Set by default to 0, so that zero measures will show 0% health
	double bMeasurePct = 0.0d;
	double uMeasurePct = 0.0d;

	List alarms = null;
	String servers = null;
	String sites = null;
	String tests = null;
	ArrayList al_components=null;

	List userServers = user.getServers(false);
	if (userServers.size() > 0)
	{
		measureCount = user.getMeasuresCount();
		Map testNames = user.getTests();

		List serversWithHost = Server.getServersWithHostSystem(userServers, true, false);
		List list = new LinkedList();
		list.addAll(user.getSites());
		list.addAll(user.getServices());
		list.add("NULL");
		
		if (!allComp)
		{
			servers = StringUtils.getArrayAsString(serversWithHost.toArray(), '\'');
			al_components=new ArrayList();
			StringBuffer sb_components=new StringBuffer();
			for (int i=0;i<serversWithHost.size();i++)
			{
				if (i>0 && (i%250== 0))
				{
					String hostname=sb_components.toString();
					al_components.add(hostname);
					sb_components=new StringBuffer();
				}
				
				if (i==0 || sb_components.length()==0)
				{
					sb_components.append("'").append(serversWithHost.get(i)).append("'");
				}else
				{
					sb_components.append(",'").append(serversWithHost.get(i)).append("'");
				}
				
			}
			if (sb_components.length()>0)
			{
				al_components.add(sb_components.toString());
			}
			sites = StringUtils.getArrayAsString(list.toArray(), '\'');
		}
		tests = StringUtils.getArrayAsString(testNames.keySet().toArray(), '\'');
		ArrayList serverList = new ArrayList();
		if (!allComp)
		{
			StringTokenizer st1 = new StringTokenizer(servers, ",");
			while (st1.hasMoreTokens())
			{				
				serverList.add(st1.nextToken().trim());
			}
		}
		ArrayList siteList = new ArrayList();
		if (!allComp)
		{
			StringTokenizer st3 = new StringTokenizer(sites, ",");						
			while (st3.hasMoreTokens())
			{
				siteList.add(st3.nextToken().trim());
			}
		}

		EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();
		egDb.setConnection();

		ResultSet rs = null;
		try
		{
			//badCount = 0;
			//unknownCount =0;
			if (allComp)
			{
				rs = egDb.getStateForMeasures("", "");
				//if (rs.next())	//it is called once again in getStateCounts
				{
					int [] measCount = getStateCounts(rs, serverList, siteList);
					
					if(measCount != null)
					{
						badMeasures = measCount[0];
						unknownMeasures = measCount[1];
					}
				}
				rs.close();
				rs = null;
			//}
				if (measureCount < (unknownMeasures+badMeasures))
				{
					//Update measureCount
					int newCount = egDb.getRealMeasuresCount(servers, sites);
					measureCount += newCount;
					user.setMeasuresCount(measureCount);
					registry.updateUser(user);
				}
			}else
			{
				int newCount=0;
				rs = egDb.getStateForMeasures ("",""); // servers and sites are dummy
				//if (rs.next())	//it is called once again in getStateCounts
				{
					int [] measCount = getStateCounts(rs, serverList, siteList);
					if(measCount != null)
					{
						badMeasures = measCount[0];
						unknownMeasures = measCount[1];
					}
				}
				rs.close();
				rs = null;
				if (measureCount < (unknownMeasures+badMeasures))
				{
					for (int i=0;i<al_components.size();i++)
					{
						String strserver=(String)al_components.get(i);
						newCount += egDb.getRealMeasuresCount(strserver, sites);
					}
					measureCount += newCount;
					//Update measureCount
					user.setMeasuresCount(measureCount);
					registry.updateUser(user);
				}
			}
			rs = egDb.getAllAlarms(user.getServerTypes());
			alarms = egDb.getResultSetAsList(rs);
			rs.close();
			egDb.releaseConnection(false);
		}
		catch(SQLException se)
		{
			se.printStackTrace();
			if (rs != null)
			{
				rs.close();
			}

			egDb.releaseConnection(true);
			if (alarms == null)
			{
				alarms = new LinkedList();
			}
		}
		EgDbAdapterTypeUI.releaseObject(egDb);


		if (!user.isSuperMonitor())
		{
			/*
			 * Filter out components that this user does not monitor
			 */
			List remove = new LinkedList();
			//List serversWithoutType = Server.getServersWithHostSystem(userServers, true, true);
			List serversWithType = Server.getServersWithHostSystem(userServers, true, false);
			for (Iterator i=alarms.iterator(); i.hasNext(); )
			{
				String[] row = (String[])i.next();
				String[] compNames = StringUtils.getTokens(row[0], "/");
				String compType = row[1];
				boolean found = false;
				for (int a=0; a<compNames.length; a++)
				{
					//if (serversWithoutType.indexOf(compNames[a]) > -1)
					if (serversWithType.indexOf(compType+":"+compNames[a]) > -1)
					{
						found = true;
						break;
					}
				}

				if (!found)
				{
					remove.add(row);
				}
			}

			if (remove.size() > 0)
			{
				alarms.removeAll(remove);
			}
	
			// new change to check if test is something we care about
			alarmCount = 0;
			for (int x=0; x<alarms.size(); x++)
			{
				String[] s = (String[]) alarms.get(x);
				if (s == null || s.length < 4)
					continue;
				String desc = s[3];
				StringTokenizer st = new StringTokenizer (desc,EgConstants.COMMA);
				int c = st.countTokens();
				boolean found = false;
				for (int r=0; r<c; r++)
				{
					String ndesc = st.nextToken();
					StringTokenizer st2 = new StringTokenizer (ndesc,"|");
					if (st2.countTokens() < 3)
						continue;
					st2.nextToken(); // ignore site
					st2.nextToken(); // ignore info
					String t = st2.nextToken();
					if (testNames != null && testNames.containsKey(t))
					{
						found = true;
						break;
					}
				}
				if (found) 
					alarmCount ++;
			}
		}
		else
			alarmCount = alarms.size();
		if (measureCount > 0)
		{
			double factor = 100.0d/measureCount;
			gMeasurePct = MathUtils.round((measureCount - unknownMeasures - badMeasures) * factor, 2);
			uMeasurePct = MathUtils.round(unknownMeasures * factor, 2);
			bMeasurePct = MathUtils.round(badMeasures * factor, 2);
		}
	}

      out.write("<html>\n<head>\n<title>");
      out.print(ui.getDashboardHeading(IniUI.CURRENT_STATUS));
      out.write("</title>\n<link rel=\"stylesheet\" href=\"/final/monitor/eg_styles/eg_monitorstyle.css\" />\n<!--meta http-equiv=\"refresh\" content=\"");
      out.print(refreshTime);
      out.write(";url=EgCurrentStatus.jsp\"-->\n</head>\n<body topmargin=\"0\" marginheight=\"0\" leftmargin=\"0\" marginwidth=\"0\" id=\"eg_innerbg\">\n<table width=\"100%\" height=\"131\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n<tr>\n<td width=\"100%\" valign=\"top\">\n<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" >\n\t<tr>\n\t\t<td width=\"100%\" id=\"eg_cellbgmedium\" height=\"22\">\n\t\t\t<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td  nowrap width=\"145\">&nbsp;");
      out.print(ui.getDashboardHeading(IniUI.TOTAL_MEASUREMENTS));
      out.write("</td>\n\t\t\t\t\t<td  nowrap width=\"20\" align=\"center\">:</td>\n\t\t\t\t\t<td  width=\"100%\" style=\"font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;\">");
      out.print(measureCount);
      out.write("</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td width=\"100%\" class=\"cell_border\" bgcolor=\"#E7E7E7\" height=\"22\" valign=\"top\">\n\t\t\t<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"0\" height=\"100%\">\n\t\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<span  style=\"text-align:center;width:100%; border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-left:3px;padding-right:0px;padding-top:0px;\">\n\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"20\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td  nowrap width=\"80\"  >&nbsp;");
      out.print(ui.getDashboardHeading(IniUI.PCT_ABNORMAL));
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td id=\"HIGHalarms\"  width=\"100%\" background=\"eg_images/eg_layout/abnormal.gif\">&nbsp;<font face=\"Arial,Verdana\" style=\"font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;\">");
      out.print(bMeasurePct);
      out.write("%</font></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span  style=\"text-align:center;width:100%;border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-left:3px;padding-right:0px;padding-top:0px\">\n\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"20\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td  nowrap width=\"80\">&nbsp;");
      out.print(ui.getDashboardHeading(IniUI.PCT_UNKNOWN));
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td id=\"UNKNOWNalarms\" width=\"100%\">&nbsp;<font face=\"Arial,Verdana\" style=\"font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;\">");
      out.print(uMeasurePct);
      out.write("%</font></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td style=\"padding-right:3px\">\n\t\t\t\t\t<span  style=\"text-align:center;width:100%;border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-left:0px;padding-right:0px;padding-top:0px\">\n\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"20\">\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td  nowrap width=\"70\">&nbsp;");
      out.print(ui.getDashboardHeading(IniUI.PCT_HEALTHY));
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t<td id=\"GOODalarms\" width=\"100%\">&nbsp;<font face=\"Arial,Verdana\" style=\"font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;\">");
      out.print(gMeasurePct);
      out.write("%</font></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t</span>\t\n\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td width=\"100%\" class=\"cell_border\" bgcolor=\"#E7E7E7\" height=\"26\">\n\t\t\t<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"26\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td  nowrap width=\"145\">&nbsp;");
      out.print(ui.getDashboardHeading(IniUI.OPEN_ALARMS));
      out.write("</td>\n\t\t\t\t\t<td  nowrap width=\"20\" align=\"center\">:</td>\n\t\t\t\t\t<td width=\"100%\" style=\"font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;\">");
      out.print(alarmCount);
      out.write("</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\n");

	if (alarmCount > 0)
	{
		DateTimeTokenizer dtt = new DateTimeTokenizer();
		dtt.setDateFormat(DateTimeTokenizer._YMD);
		dtt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
		dtt.setTimeFormat(DateTimeTokenizer.HMS);

		java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		EgDateInfo egDate = new EgDateInfo();
		sdf.setTimeZone(egDate.getRealTimeZone());
		java.util.Date now = new java.util.Date(egDate.egetDateUS());
		dtt.setEndDateTime(sdf.format(now));
		
		long totalDuration = 0l;
		long maxDuration = dtt.getDateDifference();
		
		for (Iterator i=alarms.iterator(); i.hasNext(); )
		{
			String[] row = (String[])i.next();
			dtt.setStartDateTime(row[5]);

			long difference = dtt.getDateDifference();
			maxDuration = Math.max(maxDuration, difference);
			totalDuration += difference;
		}


      out.write("<tr>\n\t\t<td  class=\"cell_border\" bgcolor=\"#E7E7E7\"  align=\"center\" height=\"26\" >\n\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"26\" width=\"100%\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td nowrap  width=\"145\">&nbsp;");
      out.print(ui.getDashboardHeading(IniUI.AVERAGE_DURATION));
      out.write("</td>\n\t\t\t\t\t<td nowrap width=\"20\" align=\"center\">:</td>\n\t\t\t\t\t<td width=\"100%\" style=\"font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;\">");
      out.print(DateTimeTokenizer.getTimeDifference(totalDuration/alarmCount));
      out.write("</td></tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td bgcolor=\"#E7E7E7\"  class=\"cell_border\" height=\"25\" >\n\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"  height=\"25\"  width=\"100%\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td nowrap width=\"145\">&nbsp;");
      out.print(ui.getDashboardHeading(IniUI.MAXIMUM_DURATION));
      out.write("</td>\n\t\t\t\t\t<td nowrap width=\"20\" align=\"center\">:</td>\n\t\t\t\t\t<td width=\"100%\" style=\"font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;\">");
      out.print(DateTimeTokenizer.getTimeDifference(maxDuration));
      out.write("</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n");

	}

      out.write("</table>\n<td>\n</tr>\n</table>\n</body>\n</html>\n\n\n\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
