package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import com.eg.EgDateInfo;
import com.egurkha.EgTimeZoneConverter;
import java.util.TimeZone;
import java.util.Calendar;
import com.egurkha.util.DateUtil;
import egurkha.config.EcUtils;
import java.sql.*;
import java.util.*;
import java.io.*;
import com.egurkha.*;
import com.egurkha.ini.*;
import com.egurkha.monitor.alarms.AlarmPriorities;
import com.egurkha.util.*;
import com.eg.EgAlarmTable;
import com.eg.EgDbAdapterTypeUI;
import com.eg.EgDiscInfo;
import com.eg.EgTopoInfo;
import egurkha.*;
import com.eg.EgGroupInfo;
import com.eg.EgTablesInfo;

public final class EgIndependentServers_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgLoginTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"EgErrorSmall.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*********************************************************************************************************
*	File name			:	EgIndependentServers.jsp
*	Purpose				:	Shows independent servers associated to the currently logged in user.
*	Version				:	eG 4.0
*	Author				:	Sandhya Kollath
*	Creation Date	:	05/12/2001
*	Last Date			:	03/03/2003	Arun	Reflect priorities of BAD states 
*							21/03/2003	Arun	Redid server-layout code. Fixed bug in the layout
*							17/06/2003	Arun	Changed search mechanism to follow that in EgMonitorOperations
*							10/09/2003	Arun	Server names do not show :NULL
*							13/10/2003	Arun	Modified to use User/UserRegistry
*							28/10/2003	John	Fixed the description cell width
*							04/10/2003	Arun	Fixed the compName truncation bug
*							05/12/2003	Arun	Fixed state inconsistency for Site-associated servers 
*							31/05/2006  James Thomas modified this file to display selected servers of a user
*********************************************************************************************************/


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	String strCsrfToken = "";
	String strEncodedUrl = response.encodeURL(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
	if(strEncodedUrl != null)
	{
		int idx_A = strEncodedUrl.indexOf("?");
		if (idx_A != -1)
		{
			String queryString = strEncodedUrl.substring(idx_A+1);
			HashMap hashMapParameters = EcUtils.parseQueryString(queryString);
			if (hashMapParameters != null && hashMapParameters.containsKey("com.eg.CSRF_NONCE"))
			{
				strCsrfToken = (String)hashMapParameters.get("com.eg.CSRF_NONCE");
			}
		}
	}

	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	IniFile reportIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_report.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String strYaxisBasedOnData = reportIni.getValue("CHART_TYPE","YaxisBasedOnData");
	boolean isYaxisBasedOnData=false;
	if(strYaxisBasedOnData!=null && (strYaxisBasedOnData.equalsIgnoreCase("yes") || strYaxisBasedOnData.equalsIgnoreCase("true")))
		isYaxisBasedOnData = true;

	if(!request.getRequestURI().endsWith("EgMonitorHome.jsp"))
	{

      out.write("<script>\n\t\t\tfunction openWindow(path,name,winOptions)\n\t\t\t{\n\t\t\t\tvar win;\n\t\t\t\tvar obj = window.parent;\n\t\t\t\tif(window==window.parent)\n\t\t\t\t\tobj =window.opener;\n\t\t\t\tif(obj.openWindow!=null)\n\t\t\t\t\twin = obj.openWindow(path,name,winOptions);\n\t\t\t\telse\n\t\t\t\t\twin= window.open(path,name,winOptions);\n\t\t\t\treturn win;\n\t\t\t}\n\t\t</script>\n");

	}

      out.write("<script>\n\n\t/** To Disable Right Click */\n\tvar message=\"\";\n\tfunction clickIE(){if(document.all){(message);return false;}}\n\tfunction clickNS(e){if(document.layers||(document.getElementById&&!document.all)){\n\tif(e.which==2||e.which==3){(message);return false;}}}\n\tif('");
      out.print(RightClikMode);
      out.write("'=='production')\n\t{\n\t\tif (document.layers){document.captureEvents(Event.MOUSEDOWN);document.onmousedown=clickNS;}\n\t\telse{document.onmouseup=clickNS;document.oncontextmenu=clickIE;}\n\t\tdocument.oncontextmenu=new Function(\"return false\")\n\t}\n\n\n\t/**  To disable drag and selection */\n\tvar alltables = document.getElementsByTagName(\"body\");\n\tif ('");
      out.print(SelectionMode);
      out.write("' == 'production') {\n\t\twindow.onload = function() {\n\t\t\tfunction disableSelection(element) {\n\t\t\t\telement.onselectstart = function() {\n\t\t\t\t\treturn false;\n\t\t\t\t};\n\t\t\t\telement.unselectable = \"on\";\n\t\t\t\telement.style.MozUserSelect = \"none\";\n\t\t\t\telement.style.cursor = \"default\";\n\t\t\t}\n\n\t\t\tfor (var i = 0; i < alltables.length; i++) {\n\n\t\t\t\tdisableSelection(alltables[i]); //disable text selection within all tables on the page\n\t\t\t}\n\n\t\t}\n\t}\n\n\tfunction callWindow(opt)\n\t{\n\t\tvar topWindow = window;\n\t\twhile(topWindow.parent!=topWindow ||  topWindow.opener!=null)\n\t\t{\n\t\t\tmainWindow = topWindow;\n\t\t\ttopWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);\n\t\t}\n\t\tif(topWindow.location.pathname!=\"/\")\n\t\t\tmainWindow=topWindow;\n\t\tmainWindow.location.href=\"/final/servlet/com.egurkha.Logout?errmsg=\"+opt;\n\t\tmainWindow.focus();\n\t}\n</script>\n\n");

	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	String productionMode = trackerUI.getValue("UI_MIGRATION","SenchaProductionMode");
	User u_ser = null;
	boolean id_u = false;
	String u_rs = null;
	String userLogos = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;
	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		sessionId_sm = (String)session.getAttribute("sessionId_SM");
	}
	if(session!=null)
	{
		if(from_sm)
		{
			u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
		}
		else
		{
			u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
		if(u_ser!=null)
		{

			id_u = u_ser.isIdDeletedWhileLoggedIn();
			if(id_u == false)
			{
				u_rs =  u_ser.getLoginID();
				userLogos = u_ser.getUserLogo();

				trackerUI.set_loginID(u_rs);
				trackerUI.set_userLogo(userLogos);

				if(!User.isDefaultUser(u_rs))
				{
					ErUserData er = u_ser.getReporterData();
					u_v_till = er.getUserValidtill();
					l_accessed = session.getLastAccessedTime();
				}
			}
		}
	}
	if(session == null || u_ser ==null)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(1);\n\t\t</script>\n");

			return;
	}
	else if(id_u== true)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(2);\n\t\t</script>\n");

			return;
	}
	else if (u_v_till < l_accessed)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\t\tcallWindow(3);\n\t\t\t</script>\n");

			return;
	}
	else
	{
		String smartValue=request.getParameter("smart");
		String site=request.getParameter("site");
		String servicename=request.getParameter("servicename");
		String page_help=request.getRequestURI();
		if((servicename==null || servicename.trim().length()==0) && (site==null || site.trim().length()==0))
		{
		if(smartValue==null || (smartValue!=null && smartValue.trim().length()==0))
		{
			if(!(page_help.endsWith("EgPrintGraph.jsp") || 
				page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")||(page_help.indexOf("Egprintdata.jsp")>-1)))
			{
				session.setAttribute("Page_IdentifierM", request.getRequestURI());
				if(page_help!=null && page_help.endsWith("componentMeasureTabSet.jsp"))
				{
					session.setAttribute("Page_IdentifierMP", request.getRequestURI());
				}
			}
			}
		}
	}

	String timezoneOffsetValue ="";
	EgDateInfo tracker_tdateInfo = new EgDateInfo();
	TimeZone tracker_tz = null;
	if (u_ser!=null)
	{
		u_ser.setUserLanguageAndSkins();
		monitor_Skin  = u_ser.getMonitorSkin();
		String trackerUserLang = u_ser.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}

		Calendar cal = Calendar.getInstance();
		java.util.Date local_date = new java.util.Date(tracker_tdateInfo.egetUTCDate());
		cal.setTime(local_date);
		cal.setTimeZone(tracker_tdateInfo.getRealTimeZone());
		String temp1 = (cal.get(cal.MONTH)+1) + "/" + cal.get(cal.DAY_OF_MONTH) + "/" +cal.get(cal.YEAR);
		String mgr_time = cal.get(cal.HOUR_OF_DAY)+":"+cal.get(cal.MINUTE)+":"+cal.get(cal.SECOND);
		String trac_currentDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String dispDate = DateUtil.changeDateFormat(temp1,"MM/dd/yyyy",trac_currentDateFormat);
		EgTimeZoneConverter tracker_timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+mgr_time,u_ser);
		tracker_tz = tracker_timeZoneConverter.getTimeZone();

		long timezoneinMins = (Math.abs((tracker_tz.getRawOffset() / (60 * 1000))));
		long daylighttime = (tracker_tz.getDSTSavings() / (60 * 1000));
		timezoneOffsetValue = String.valueOf(Math.abs(timezoneinMins-daylighttime));

		

		Calendar cal3 = GregorianCalendar.getInstance(tracker_tz);
		int offsetInMillis = tracker_tz.getOffset(cal3.getTimeInMillis());
		int offsetmin = 0;
		if(offsetInMillis<0)
			offsetmin =(Math.abs(offsetInMillis)/1000)/60;
		else
			offsetmin = (offsetInMillis/1000)/60;
		String offset = String.valueOf(offsetmin);
		
		//if(offsetInMillis>0)
		//{
			if(tracker_tz.getRawOffset()>=0)
				timezoneOffsetValue="-"+offset;
			else
				timezoneOffsetValue="+"+offset;
		//}
		//else
			//timezoneOffsetValue = (offsetInMillis >= 0 ? "+" : "-") + offset;
	}
	else
	{
		tracker_tz = tracker_tdateInfo.getRealTimeZone();

		long timezoneinMins = (Math.abs((tracker_tz.getRawOffset() / (60 * 1000))));
		long daylighttime = (tracker_tz.getDSTSavings() / (60 * 1000));
		timezoneOffsetValue = String.valueOf(Math.abs(timezoneinMins-daylighttime));
		
		if(tracker_tz.getRawOffset()>=0)
			timezoneOffsetValue="-"+timezoneOffsetValue;
		else
			timezoneOffsetValue="+"+timezoneOffsetValue;
	}

		String  script_src="script_item_"+trackerLanguage+".js";
		String uiFileTemp = "eg_ui.ini";
		String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
		
		EgMappingInfo trackerMappingInfo = new EgMappingInfo(trackerLanguage);

		//Variable to be used in javascript code
		String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String mgrDateFormat = currentDateFormatForJS;
		String dateFormatNew = mgrDateFormat;
		if(currentDateFormatForJS.indexOf("MMM") >= 0)
		{
			for(int i=0; i < currentDateFormatForJS.length();i++)
			{
				if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
				{
					currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
				}
			}
		}

		String dateFormatForDatePicker=(String)u_ser.getUserDateFormat();
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}
		IniUI egui_temp = IniUI.getInstance();
		String  strer_modeInTracker="2D";
		

      out.write("<script>\n\tvar strSkin='");
      out.print(monitor_Skin);
      out.write("';\n\tvar isYaxisBasedOnData=");
      out.print(isYaxisBasedOnData);
      out.write(";\n\tvar netRow = ( strSkin == 'Light' )?'netRow loaded':'darkRow loaded';\n\tvar pageListRow = ( strSkin == 'Light' )?'pageRow':'darkPageRow';\n\tvar netCol = ( strSkin == 'Light' )?'netCol':'darkNetCol';\n\tvar netSummaryRow = ( strSkin == 'Light' )?'netSummaryRow':'darkNetSummaryRow';\n\tvar netSummaryRow = ( strSkin == 'Light' )?'netRow tabView':'darkNetRow darkTabView';\n\tvar netFullHrefLabel = ( strSkin == 'Light' )?'netFullHrefLabel':'netFullHrefLabel';\n\tvar er_modeInTracker='");
      out.print(strer_modeInTracker);
      out.write("'\n\tvar dateFormatForTimeline = '");
      out.print(dateFormatNew);
      out.write("';\n\tvar settings='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Settings"));
      out.write("';\n\tvar toolData='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Data"));
      out.write("';\n\tvar toolCSV='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.CSV"));
      out.write("';\n\tvar toolSave ='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.SAVE"));
      out.write("';\n\tvar toolMail='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.MAIL"));
      out.write("';\n\tvar toolPrint='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.PRINT"));
      out.write("';\n\tvar timelineLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Timeline"));
      out.write("';\n\tvar hrLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Hr"));
      out.write("';\n\tvar minLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Min"));
      out.write("';\n\tvar Tolbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.To"));
      out.write("';\n\tvar fromLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.history.From"));
      out.write("';\n\tvar graphLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.summary.Graph"));
      out.write("';\n\n\t// For Highcharts - UTC - timezoneOffset\n\tvar timeZoneOffsetVal='");
      out.print(timezoneOffsetValue);
      out.write("';\n\t//-----end-----\n\tdocument.onkeydown = fkey;\n\nfunction fkey(e){\n  e = e || window.event;\n\t  if (e.which == 116 || (e.keyCode == 82 && e.ctrlKey)) { //116 = F5\n\t\t\ttry\n\t\t\t{\n\t\t\t\twindow.parent.refreshEgIndexPage();\t\n\t\t\t}\n\t\t\tcatch (e)\n\t\t\t{\n\t\t\t\ttry{\n\t\t\t\t\twindow.parent.parent.refreshEgIndexPage();\t\n\t\t\t\t}\n\t\t\t\tcatch (e)\n\t\t\t\t{\n\t\t\t\t\twindow.opener.refreshEgIndexPage();\n\t\t\t\t}\n\t\t\t}\n\t return false;\n\t\t\n\t}\n }\n\n</script>\n\n\n\n\n\n\n\n\n\n");

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);

	String showAllComponents = request.getParameter("showAllComponents");
	EgTablesInfo tablesInfo=null;

      out.write("<html>\n<head>\n<title> &nbsp; eG Manager &nbsp; ? &nbsp; Independent Components &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>\n<meta name=\"Author\" content=\"John Williams\" />\n<link rel=\"stylesheet\" href=\"eg_styles/eg_monitorstyle.css\" />\n<meta http-equiv=\"refresh\" content=\"100;url=EgIndependentServers.jsp?");
      out.print(request.getQueryString());
      out.write("\">\n<script language=\"JavaScript1.2\" src=\"eg_scripts/eg_validate.js\"></script>\n<script language=\"JavaScript1.2\">\nfunction valform()\n{\n\tvar thisForm = document.showservers;\n\tvar servertype = thisForm.servertype.options[thisForm.servertype.options.selectedIndex].value;\n\tvar servername = thisForm.servername.value;\n\n\tvar sub = checkspecial(thisForm.servername,\"`~!@#$%^&*()+={}[]|\\\\;\\\"\\'<>,?\\/\");\n\tif(sub)\n\t{\n\t\t//when servername is '192.168.10.12 and 192.168.10.13', replace space by '*'\n\t\tfor(var x=0;x<servername.length;x++)\n\t\t{\n\t\t\tif(servername.charAt(x) == ' ')\n\t\t\t{\n\t\t\t\tservername = servername.replace(' ','*');\n\t\t\t}\n\t\t}\n\t\tif(servername == \"\")\n\t\t{\n\t\t\twindow.location.href = \"EgIndependentServers.jsp?stype=\" + servertype + \"&flag=type&segment=\"+seg+\"&service=\"+ser+\"&showAllComponents=");
      out.print(showAllComponents);
      out.write("\";\n\t\t}\n\t\telse\n\t\t{\n\t\t\twindow.location.href = \"EgIndependentServers.jsp?stype=\" + servertype + \"&sname=\" + servername + \"&flag=both&segment=\"+seg+\"&service=\"+ser+\"&showAllComponents=");
      out.print(showAllComponents);
      out.write("\"\n\t\t}\n\t}\n\telse\n\t{\n\t\tthisForm.servername.focus();\n\t}\n}\n</script>\n</head>\n<body topmargin=\"0\" marginheight=\"0\" leftmargin=\"0\" marginwidth=\"0\" id=\"eg_innerbg\">\n<!-- ");
      egurkha.EgAspLite egasp = null;
      synchronized (_jspx_page_context) {
        egasp = (egurkha.EgAspLite) _jspx_page_context.getAttribute("egasp", PageContext.PAGE_SCOPE);
        if (egasp == null){
          egasp = new egurkha.EgAspLite();
          _jspx_page_context.setAttribute("egasp", egasp, PageContext.PAGE_SCOPE);
        }
      }
      out.write(" -->\n");
      egurkha.ConfigSiteBean sitebean = null;
      synchronized (_jspx_page_context) {
        sitebean = (egurkha.ConfigSiteBean) _jspx_page_context.getAttribute("sitebean", PageContext.PAGE_SCOPE);
        if (sitebean == null){
          sitebean = new egurkha.ConfigSiteBean();
          _jspx_page_context.setAttribute("sitebean", sitebean, PageContext.PAGE_SCOPE);
        }
      }

	boolean excludeCompSeg = showAllComponents==null || showAllComponents.equals("false");

	int minServers = EgConstants.MIN_SERVERS_FOR_SEARCH;

	AlarmPriorities ap = AlarmPriorities.getInstance();
	List v_comp_type_name = new Vector();
	List indServers = new Vector();
	Vector v_comp_type = new Vector();

	//String s_userid = (String) session.getAttribute("sess_userid");
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String s_userid = user.getLoginID();

	String s_org_sname = "";
	String s_qry = "";
	String s_conn = "";
	boolean showservers = true;
	boolean checkflag = true;
	ResultSet rs = null;

	//Variables declared for CA change
	StringTokenizer st = null;
	String comp_type = "";
	String comp_name = "";
	String server = null;
	String state = "";
	String s_tmp_state = "";
	String box_name = "";
	String val = "";
	String hostName = "";
	String portNo = "";
	String sid = "";

	//New code : Box_name from UniCenter
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	Hashtable ipmap = discInfo.getNickIpMap();
	box_name = request.getParameter("box");

	if(box_name != null && !box_name.equals("null") && !box_name.equals(""))
	{
		v_comp_type_name.clear();
		Vector v_allServers = discInfo.getAllManagedComponents();
		for(int i=0; i<v_allServers.size(); i++)
		{
			val = (String)v_allServers.get(i);
			st = new StringTokenizer(val,",");
			int tokCount = st.countTokens();

			comp_type = st.nextToken();
			st.nextToken();
			comp_name = st.nextToken();
			portNo = st.nextToken();
			if(tokCount > 4)
			{
				sid = st.nextToken();
				hostName = comp_name + ":" + portNo + ":" + sid;
				server = comp_type + ":" + comp_name + ":" + portNo + ":" + sid;
			}
			else
			{
				hostName = comp_name + ":" + portNo;
				server = comp_type + ":" + comp_name + ":" + portNo;
			}

			if(box_name.equals(comp_name))
			{
				if(!v_comp_type_name.contains(server))
					v_comp_type_name.add(server);
			}
		}
	}
	else
	{
		v_comp_type_name.clear();
		//v_comp_type_name.addAll(user.getIndServers());
		//out.println("user.getIndServers():"+user.getIndServers());
		//out.println("<br>user.getServers(true):"+user.getServers(false));
		//add components from associated services, segments and zones
//		v_comp_type_name.addAll(user.getServers(false));

		String selected_segments = request.getParameter("selected_segments");

		if(selected_segments!=null && selected_segments.length() > 0 )
		{
			v_comp_type_name.clear();
	
			if(selected_segments.indexOf("[") >= 0)
			selected_segments=selected_segments.substring(1,selected_segments.length()-1);

			StringTokenizer stt=new StringTokenizer(selected_segments,",");

			while(stt.hasMoreTokens())
			v_comp_type_name.add((String)stt.nextToken().trim());	
		}
		else
		{
			v_comp_type_name.addAll(user.getServers(false));
		}
		if (excludeCompSeg)
		{
			/*
			List segList = user.getSegments();
			Iterator segI = segList.iterator();
			EgTopoInfo topoInfo = new EgTopoInfo("manager");
			while (segI.hasNext())
			{
				String thisSegment = (String)segI.next();
				String [] thisVar = topoInfo.getVariables(thisSegment);
				if (thisVar!=null)
					v_comp_type_name.addAll(Arrays.asList(thisVar));
			}
			*/
			EgTopoInfo topoInfo = new EgTopoInfo("manager");
			String [] segCmps = topoInfo.getVariables("PHYSICAL_TOPOLOGY");
			if (segCmps!=null)
				v_comp_type_name.removeAll(Arrays.asList(segCmps));
		}else
		{
			List segs = user.getSegments();
			Iterator segsI = segs.iterator();
			EgGroupInfo groupInfo = new EgGroupInfo();
			EgTopoInfo topoInfo = new EgTopoInfo("manager");
			while (segsI.hasNext())
			{
				String thisSeg = (String) segsI.next();
				Vector segAss = topoInfo.getAssociatesForSegment(thisSeg, 2);
				if (segAss!=null)
				{
					Iterator assI = segAss.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}
			}

			List sers =  user.getServices();
			Iterator sersI = sers.iterator();
			while (sersI.hasNext())
			{
				String thisSeg = (String) sersI.next();
				Vector segAss = topoInfo.getAssociatesForSite(thisSeg);
				if (segAss!=null)
				{
					Iterator assI = segAss.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}
			}

			List sites = user.getSites();
			Iterator sitesI = sites.iterator();
			while (sitesI.hasNext())
			{
				String thisSeg = (String) sitesI.next();
				Vector segAss = topoInfo.getAssociatesForSite(thisSeg);
				if (segAss!=null)
				{
					Iterator assI = segAss.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}
			}


			List zones = user.getZones();
			Iterator zonesI = zones.iterator();
			while (zonesI.hasNext())
			{
				String thisZone = (String) zonesI.next();
				ArrayList segCmps = groupInfo.getAllSegmentComponentsUnderZone(thisZone);
				if (segCmps!=null)
				{
					Iterator assI = segCmps.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}

				ArrayList serCmps = groupInfo.getAllServiceComponentsUnderZone(thisZone);
				if (serCmps!=null)
				{
					Iterator assI = serCmps.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}
			}
		}

//		if(s_userid.equals("supermonitor"))
//		{
//			UserScope us = new UserScope();
//			v_comp_type_name = us.getIndependentServers();
//		}
//		else
//		{
//			v_comp_type_name = egasp.userServerInfo(s_userid,true);
//
//			//New code
//			Vector v_user_segs = egasp.getUserSegments(s_userid);
//			ArrayList a_user_all_seg_servs = sitebean.getServersForSegments(v_user_segs,2);
//			String s_seg_serv = "";
//			for(int k=0;k < a_user_all_seg_servs.size();k++)
//			{
//				s_seg_serv = (String)a_user_all_seg_servs.get(k);
//				if(v_comp_type_name.contains(s_seg_serv))
//				{
//					int idx = v_comp_type_name.indexOf(s_seg_serv);
//					if(idx > -1)
//					{
//						v_comp_type_name.remove(idx);
//					}
//				}
//			}
//			//End of new code
//			egasp.releaseConnection(false);
//		}
	}

	String s_flag = request.getParameter("flag");
	String s_sname = request.getParameter("sname");
	String s_stype = request.getParameter("stype");
	if (StringUtils.isNull(s_flag))
	{
		/*
		 * Direct entry into the page
		 */
		indServers.addAll(v_comp_type_name);
	}
	else
	{
		/*
		 * Entry through search button in the page
		 */
		boolean allServers = s_stype.equals("AllServers");
		if (s_flag.equalsIgnoreCase("both"))
		{
			List searchKey = Arrays.asList(StringUtils.getTokens(s_sname, "*"));
			for (Iterator i=v_comp_type_name.iterator(); i.hasNext(); )
			{
				server = (String)i.next();
				String serverType = Server.getServerType(server);
				String serverName = StringUtils.replace(Server.getServerName(server),":NULL","");

				for (int a=0; a<searchKey.size(); a++)
				{
					String key = (String)searchKey.get(a);
					String thisHostName = serverName.indexOf(":")==-1?serverName:serverName.substring(0, serverName.indexOf(":"));
					
					String thisIp=(String)ipmap.get(thisHostName);
					System.out.println("&"+serverName+"\t"+thisIp);
					if (thisIp==null)
						thisIp="";
					//if (serverName.indexOf(key) > -1)
					if (serverName.toLowerCase().indexOf(key) > -1 || thisIp.indexOf(key) > -1)
					{
						if (allServers)
						{
							indServers.add(server);
						}
						else
						{
							if (serverType.equals(s_stype))
							{
								indServers.add(server);
							}
						}
					}
				}
			}
		}
		else //if (s_flag.equalsIgnoreCase("type"))
		{
			if (allServers)
			{
				indServers.addAll(v_comp_type_name);
			}
			else
			{
				for (Iterator i=v_comp_type_name.iterator(); i.hasNext(); )
				{
					server = (String)i.next();
					String serverType = Server.getServerType(server);
					if (serverType.equals(s_stype))
					{
						indServers.add(server);
					}
				}
			}
		}
	}

	// Remove Duplicate Entries from indServers - new fix kk
	String s_tmp1 = "";
	String s_tmp2 = "";
	for(int i=0;i < indServers.size();i++)
	{
		s_tmp1 = (String)indServers.get(i);
		for(int j=i+1;j < indServers.size();j++)
		{
			s_tmp2 = (String)indServers.get(j);
			if(s_tmp1.equals(s_tmp2))
			{
				indServers.remove(j);
				i=0;
			}
		}
	}

	//if(indServers.size() > 12)
	if(indServers.size() > minServers)
	{
		showservers = false;
	}
	else if(s_flag != null)
	{
		showservers = false;
	}

	List serversWithState = new LinkedList();
	tablesInfo = new EgTablesInfo("manager");
	ArrayList siteServers = discInfo.getSiteServers();
	for (Iterator i=indServers.iterator(); i.hasNext(); )
	{
		server = (String)i.next();

		List row = new LinkedList();
		row.add(server);

		String serverType = Server.getServerType(server);
		/*
		 * The state of the WEB_TRANSACTIONS and WEB_SITE layers should not be considered for 
		 * Site-associated servers when coming through the segments or independent servers pages.
		 */
		if (siteServers.indexOf(serverType) > -1)
		{
			ArrayList layers = tablesInfo.getLayersForComponent(serverType);
			if ((layers.indexOf("WEB_SITE") > -1) || (layers.indexOf("WEB_TRANSACTIONS") > -1))
			{
				row.add(ap.getAlarmPriority(Server.getServerName(server), serverType, "NULL"));
			}
			else
			{
				row.add(ap.getAlarmPriority(Server.getServerName(server), serverType));
			}
		}
		else
		{
			row.add(ap.getAlarmPriority(Server.getServerName(server), serverType));
		}

		serversWithState.add(row);
	}

	Collections.sort(serversWithState, new Sorter(AlarmPriorities.getStatesOrder(), true));

      out.write("<form name=\"showservers\" method=\"post\" action=\"javascript:valform();\">\n");

	if(!showservers)
	{

      out.write("<table align=\"center\" cellspacing=\"6\" cellpadding=\"2\" border=\"0\"><tr><td align=\"center\">\n\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\">\n\t\t\t<tr>\n\t\t\t\t<td id=\"eg_cellbgmedium\">\n\t\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"2\" height=\"32\" border=\"0\">\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<th class=\"eg_bodybg\" id=\"eg_darktextbold\" nowrap=\"nowrap\"><font id=\"eg_color3\">&nbsp;Type</font></th>\n\t\t\t\t\t\t\t<td class=\"eg_bodybg\" nowrap=\"nowrap\">\n\t\t\t\t\t\t\t\t<select name=\"servertype\">\n");

								if(s_stype != null && (s_stype.equals("AllServers")))
								{

      out.write("<option value=\"AllServers\" selected>All Components</option>\n");

								}
								else
								{

      out.write("<option value=\"AllServers\">All Components</option>\n");

								}
								v_comp_type.clear();
								Collections.sort(v_comp_type_name,String.CASE_INSENSITIVE_ORDER);
								for(int i=0;i< v_comp_type_name.size();i++)
								{
									String s_serv_type_name = (String)v_comp_type_name.get(i);	
									String s_serv_type = s_serv_type_name.substring(0,s_serv_type_name.indexOf(":"));
									if(!v_comp_type.contains(s_serv_type))
									{
										v_comp_type.add(s_serv_type);
									}
								}
								for(int i=0; i<v_comp_type.size(); i++)
								{
									if(s_stype != null && (!s_stype.equals("")))
									{
										if(s_stype.equals((String)v_comp_type.get(i)))
										{

      out.write("<option value=\"");
      out.print((String)v_comp_type.get(i));
      out.write("\" selected>");
      out.print((String)v_comp_type.get(i));
      out.write("</option>\n");

										}
										else
										{

      out.write("<option value=\"");
      out.print((String)v_comp_type.get(i));
      out.write('"');
      out.write('>');
      out.print((String)v_comp_type.get(i));
      out.write("</option>\n");

										}
									}
									else
									{

      out.write("<option value=\"");
      out.print((String)v_comp_type.get(i));
      out.write('"');
      out.write('>');
      out.print((String)v_comp_type.get(i));
      out.write("</option>\n");

									}
								}

      out.write("</select>\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t<th class=\"eg_bodybg\" id=\"eg_darktextbold\" nowrap=\"nowrap\"><font id=\"eg_color3\">&nbsp; IP/Hostname</font></th>\n\t\t\t\t\t\t\t<td class=\"eg_bodybg\"><input type=\"text\" name=\"servername\" size=\"12\" style=\"width: 180px;\" value=\"");
      out.print(s_org_sname);
      out.write("\" maxlength=\"128\" class=\"eg_11\"></td>\n\t\t\t\t\t\t\t<td class=\"eg_bodybg\"><input type=\"button\" onClick=\"javascript:valform();\" value=\"SEARCH\" name=\"searchbutton\" id=\"eg_darkbutton\"></td>\n\t\t\t\t\t\t\t<td class=\"eg_bodybg\" id=\"eg_blankspace\" width=\"2\" nowrap=\"nowrap\">&nbsp;</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</table>\n\t\t</td>\n\t\t<td><p style=\"line-height:16px; font-size: 10px;\"><sup>* </sup>You can search using any character of your component.&nbsp; Multiple search strings should be separated using a blank space.</p></td></tr></table>\n\t<br />\n");

	}

      out.write("<table align=\"center\" cellspacing=\"2\" cellpadding=\"3\" width=\"100%\" border=\"0\">\n<!--JSP BACKGROUND/IMAGE FOR SERVER STARTS HERE-->\n");

		int size = serversWithState.size();
		if(size > 0)
		{
			if(showservers | checkflag)
			{
				int count = 0;					//Counts number of cells drawn so far
				int maxPerRow = 5;				//Maximum cells per row
				
				int rows = size/maxPerRow;		//Minimum number of rows in the table
				if (size % maxPerRow > 0)
				{
					rows++;						//If empty cells have to be drawn, that means an extra row
				}
				int emptyCount = Math.abs(size - (maxPerRow * rows));
				int width = 100/maxPerRow;		//By default width = 20
				if (size < maxPerRow)
				{
					width = 100 / size;
				}
				for (Iterator i=serversWithState.iterator(); i.hasNext(); )
				{
					if (count == 0)
					{//Start new row
						out.print("<tr>");
					}

					List row = (List)i.next();
					server = (String)row.get(0);
					state = (String)row.get(1);

					comp_type = Server.getServerType(server);
					comp_name = Server.getServerName(server);

					String compName = null;
					if (comp_name!=null)
					{
						if (comp_name.endsWith(EgConstants.NULL_PORT))
						{
							compName = Server.getServerNameWithoutPort(comp_name, false);
						}
						else
						{
							compName = comp_name;
						}
					}else
					{
						continue;
					}

      out.write("<td width=\"");
      out.print(width);
      out.write("%\" align=\"center\" height=\"90\" valign=\"top\" nowrap=\"nowrap\" id=\"eg_blackcontent\">\n\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"36\" height=\"36\" border=\"0\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td id=\"");
      out.print(state);
      out.write("border\" align=\"center\" valign=\"middle\" width=\"36\" height=\"36\" nowrap background=\"eg_images/eg_layout/");
      out.print(state);
      out.write("big.gif\">\n\t\t\t\t\t\t<a href=\"/final/servlet/com.eg.EgDashboardController?from=list&site=NULL&qctr=0&host=");
      out.print(comp_name);
      out.write("&comptype=");
      out.print(comp_type);
      out.write("\" target=\"eg_operations\"><img src=\"eg_images/eg_layout/eg_icons/");
      out.print(comp_type);
      out.write(".gif\" border=\"0\" alt=\"");
      out.print(comp_type);
      out.write("\" align=\"center\" width=\"30\" height=\"30\" hspace=\"0\" vspace=\"0\"></a>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n");

					while (compName.length() > 20)
					{
						out.print(compName.substring(0, 20));
						out.print("<br>");
						compName = compName.substring(20);
					}
					if (compName.length() <= 20)
					{
						out.print(compName);
					}

      out.write("</td>\n");

					count++;
					size--;

					if ((maxPerRow == count) || (size == 0))
					{//End of the row
						if ((rows > 1) && (size == 0))
						{//Only if rows are more than 1. Otherwise the cells will be center-aligned by default
							for (int a=0; a<emptyCount; a++)
							{
								out.print("<td nowrap=\"nowrap\" width=\"");
								out.print(width);
								out.println("%\">&nbsp;</td>");
							}
						}
						out.print("</tr>");
						count = 0;
					}
				}//End of for (Iterator...)
			}
		}
		else
		{

      out.write("<table cellspacing=\"0\" cellpadding=\"50\" align='center' height=\"60%\" border=\"0\">\n");

			if(s_flag != null && s_org_sname.equals(""))
			{

      out.write("<tr>\n\t\t\t<th id=\"eg_alert\">\n");

				out.println("No matching independent components found for the above search.");

      out.write("</th>\n\t\t</tr>\n");

			}
			else if(s_flag != null && !s_org_sname.equals(""))
			{

      out.write("<tr>\n\t\t\t<th id=\"eg_alert\">\n");

				out.println("No matching independent components found for the above ");
				if(s_org_sname.length() > 20)
				{
					out.println("<br>");
				}
				out.println(" \""); 
				while(s_org_sname.length() > 60)
				{
					out.println(s_org_sname.substring(0,60) + "<br>");
					s_org_sname = s_org_sname.substring(60,s_org_sname.length());
				}
				if(s_org_sname.length() <= 60)
				{
					out.println(s_org_sname);
				}
				out.println("\" search.");

      out.write("</th>\n\t\t</tr>\n");

			}
			else
			{

      out.write("<tr>\n\t\t\t<th id=\"eg_alert\">\n");

				IniUI ui = (IniUI)IniUI.getInstance();
				out.println(ui.getConfigMessage(s_userid, IniUI.NO_SERVERS));

      out.write("</th>\n\t\t</tr>\n\t</table>\n");

			}
		}

	v_comp_type_name.clear();
	v_comp_type.clear();
	indServers.clear();

      out.write("</table>\n</form>\n</body>\n</html>\n\n\n\n\n\n\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
