package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.supermanager.*;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import com.egurkha.monitor.EgServerDashboardModel;
import com.egurkha.monitor.EgServerDashBoardDAO;
import com.egurkha.monitor.MonitorDAOFactory;
import com.eg.EgSpecsInfo;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgDbInfo;
import com.eg.EgTablesInfo;
import com.eg.EgDisableInfo;
import com.eg.EgMappingInfo;
import egurkha.reporter.ErUtils;
import com.egurkha.monitor.EgFusionChartUtil;
import com.egurkha.monitor.EgGraphsUtil;
import java.text.SimpleDateFormat;
import com.eg.EgURLEncoder;
import com.egurkha.util.MathUtils;
import com.eg.EgTablesInfo;
import com.egurkha.util.StringUtils;
import com.eg.supermanager.*;
import net.sf.json.*;

public final class EgNetflowDashboardJSON_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgMonitorTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("application/json; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String mgrDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	boolean isMobileCall=false;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;	
	String fromMobile=request.getParameter("fromMobile");
	String isFromMenu=request.getParameter("isFromMenu");
	String dateFormatForDatePicker ="";

	User u_ser = null;
	EgMappingInfo mappingInfo = null;
	String trackerLanguage = trackerUI.getDefaultLanguage();
	/**
			 Operation - Mobile check
			 Purpose - Support for accessing the manager via mobile.
			 Author - Praveen 8/4/2014
	**/
	if (fromMobile!=null&&fromMobile.equals("yes"))
	{
		String uname=request.getParameter("uname");
		isMobileCall=true;
		try
		{
			ErUserData userData = new ErUserData(uname,false);
			if(userData!=null)
			{
				u_ser=userData.usr;
				if(u_ser==null)
				{
					u_ser = userData.getUser(uname);
				}
				if(u_ser!=null)
				{
					String userLang = u_ser.getLanguage();
					if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
					{
						trackerLanguage=userLang;
					}
					mappingInfo = new EgMappingInfo(trackerLanguage);
				}
			}
		}
		catch(Throwable t)
		{
			t.printStackTrace();
		}
	} // Ends here
	else
	{
		if(session.getAttribute("sessionId_SM") != null)
		{
			from_sm = true;
			sessionId_sm = (String)session.getAttribute("sessionId_SM");
		}
		if(session!=null)
		{
			if(from_sm)
			{
				u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
			}
			else
			{
				u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
			}
			if(u_ser!=null)
			{
				id_u = u_ser.isIdDeletedWhileLoggedIn();
				if(id_u == false)
				{
					u_rs =  u_ser.getLoginID();
					if(!User.isDefaultUser(u_rs))
					{
						ErUserData er = u_ser.getReporterData();
						u_v_till = er.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
		}
		if ( session != null || u_ser != null )
		{
			String smartValue=request.getParameter("smart");
			String page_help=request.getRequestURI();
			if(isFromMenu != null && isFromMenu.trim().length() > 0 && smartValue==null || (smartValue!=null && smartValue.trim().length()==0) )
			{
				if(!(page_help.endsWith("EgPrintGraph.jsp") || page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")))
					session.setAttribute("Page_IdentifierM", request.getRequestURI());
			}
		}

		if (u_ser!=null)
		{
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
			String trackerUserLang = u_ser.getLanguage();
			if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
			{
				trackerLanguage=trackerUserLang;
			}
		}
		mappingInfo = new EgMappingInfo(trackerLanguage);
		if(u_ser != null)
		{
			dateFormatForDatePicker = (String)u_ser.getUserDateFormat();
		}
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}

		if(session == null || u_ser == null)
		{
			throw new Exception("<customerror>user-session-invalid</customerror>");
		}
		else if(id_u== true)
		{
			throw new Exception("<customerror>user-deleted</customerror>");
		}
		else if (u_v_till < l_accessed)
		{
			throw new Exception("<customerror>user-timedout</customerror>");
		}
	}


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);


try
{
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		ArrayList managerIds=null;
		String hostname = request.getParameter("hostName");
		if(hostname != null && hostname.trim().length()>0)
		{
			if(hostname.indexOf(":")>-1)
			{
				hostname = hostname.substring(0,hostname.indexOf(":"));
			}
			managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
		}
		if(managerIds != null && !managerIds.isEmpty())
		{
			SmSessionData smsData = new SmSessionData(session.getId(),managerIds);
			EgThreadLocal egtl = new EgThreadLocal();
			egtl.set(smsData);
		}
	}
	JSONObject rootJson = new JSONObject();
	JSONObject hiddens = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject dialChartValues = new JSONObject();
	JSONObject GridValues = new JSONObject();

	String compType=request.getParameter("compType");
	String compName=request.getParameter("hostName");
	String tab=request.getParameter("tab");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	String blockType = request.getParameter("blockType");
	String ciscoSelectedType = request.getParameter("ciscoSelectedType");
	String options[] = {"overview", "protocols", "flows"}, dispVal = "";
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	String hostName="";
	String portNo="";
	String sid="";
	String site="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
		{
			portNo=st.nextToken();
		}

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	String defaultPieGraphDuration=iniobj.getValue("Default_PieGraph_Duration","duration");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgServerDashboardModel model=new EgServerDashboardModel();
	
	MonitorDAOFactory monitorfactory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorfactory.getServerDashBoardDAO();
	ErUtils  erutils=new  ErUtils();

	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDisableInfo disableInfo = new EgDisableInfo("manager");
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgGraphsUtil graphUtil=new EgGraphsUtil(trackerLanguage);
	
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	Vector runingTestList=model.getRunningTest(compName,compType,tab);
	ArrayList getExcludedTest = disableInfo.getExcludedTestsForComponent(compName, compType);



	JSONObject overviewObj = new JSONObject();

	String overviewDialGraphs=iniobj.getValue(compType,"Network_Overview_DialGraphs");
	
	Vector dialGraphtests=model.getTokensAsVector(overviewDialGraphs,",");
	double defaultDialGraphWidth=200;  // default dial graph width for calculation
	double defaultDialGraphHeight=125;  // default dial graph height for calculation
	double dialGraphWidth=240;  
	double dialGraphHeight=125;
	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
	double defaultGauageOuterRadius=69; // default dial graph width for calculation
	double defaultGaugeXPos=90; // default dial graph Gauge X position for calculation
	double defaultGaugeYPos=93; // default dial graph Gauge Y position for calculation 
	String gauageOuterRadius="50";
	String gaugeXPos="90";
	String gaugeYPos="93";
	dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
	dialGraphWidth=MathUtils.round(dialGraphWidth,0);
	dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
	dialGraphHeight=MathUtils.round(dialGraphHeight,0);
	double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
	double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
	gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
	double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
	double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
	double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
	gaugeXPos=erutils.round(gaugeXPosInDouble,0);
	double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
	gaugeYPos=erutils.round(gaugeYPosInDouble,0);
	double defaultLedGraphWidth=140;  // default led graph width for calculation
	double defaultLedGraphHeight=85;  // default led graph height for calculation
	double ledGraphWidth=140;  
	double ledGraphHeight=95;
	double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
	double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;
	double defaultLedGap=1; // default led graph gap for calculation
	double defaultLedSize=1; // default led graph size for calculation
	String ledGap="1";
	String ledSize="1";
	ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
	ledGraphWidth=MathUtils.round(ledGraphWidth,0);
	ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
	ledGraphHeight=MathUtils.round(ledGraphHeight,0);
	double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
	double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
	ledGap=erutils.round(ledGapInDouble,0);
	double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
	double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
	ledSize=erutils.round(ledSizeInDouble,0);
	double defaultChartLeftMargin=42;
	double defaultChartRightMargin=25;
	String chartLeftMargin="42";
	String chartRightMargin="25";
	double chartLeftMarginToDefaultWidthInPercent=defaultChartLeftMargin/defaultLedGraphWidth;
	double ledLeftMarginInDouble=ledGraphWidth*chartLeftMarginToDefaultWidthInPercent;
	chartLeftMargin=erutils.round(ledLeftMarginInDouble,0);
	double chartRightMarginToDefaultWidthInPercent=defaultChartRightMargin/defaultLedGraphWidth;
	double ledRightMarginInDouble=ledGraphWidth*chartRightMarginToDefaultWidthInPercent;
	chartRightMargin=erutils.round(ledRightMarginInDouble,0);
	double pieChartDivHeight = dialGraphHeight+30;
	
	dialChartValues.put("pieChartDivHeight",pieChartDivHeight);
	int dialChartNoMeasuresCount=0;
	String iniEntries = iniobj.getValue(compType,"Netflow_dial");
	
	ArrayList colorCodes = new ArrayList();
	String dialColor = iniobj.getValue("Dashboard_Graph_colors","Netflow_Dial_colors");
	StringTokenizer stT=new StringTokenizer(dialColor,",");
	while(stT.hasMoreTokens())
	{
		String colorCode=stT.nextToken();			
		colorCodes.add(colorCode);
	}
		
	JSONArray ciscoArray =new JSONArray();
	boolean isAnyTestExcludedOrDisabledForDial = false;
	if(iniEntries != null && iniEntries.length() > 0)
	{
		String isDialNeeded=iniobj.getValue("Dashboard_Settings","UseDial");
		String isThresholdNeed=iniobj.getValue("Dashboard_Settings","ApplyThreshold");

		StringTokenizer st=new StringTokenizer(iniEntries,",");
		int dialChartCount=0;
		int i=0;
		ArrayList dialmeasuresNAList = new ArrayList();
		while(st.hasMoreTokens())
		{
			JSONObject ciscoObj=new JSONObject();
			String testWithMeasure=st.nextToken();
			String d_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
			String d_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
			if(enabledTests!=null && !enabledTests.contains(d_test)) {
				isAnyTestExcludedOrDisabledForDial = true;
				continue;
			}
			if(getExcludedTest != null && getExcludedTest.contains(d_test)) {
				isAnyTestExcludedOrDisabledForDial = true;
				continue;
			}
			String msmtHost=(String)allMsmtHosts.get(d_test);
			String measureValue="";
			String measureForDB=dbInfo.getColumnForMeasure(d_test,d_measure);

			String dial_measureMapping=iniobj.getValue("Dashboard_Dial_mapping",testWithMeasure);

			if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
				dial_measureMapping=mappingInfo.getMeasureDescription(d_test,d_measure);

			String tooltip=dial_measureMapping;

			String unit=tablesInfo.getUnitForMeasure(d_test,d_measure);
			if((unit!=null) && (unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage")))
				unit="%";
			long stime=System.currentTimeMillis();
			Vector testInfos=dashboardDAO.getDescriptorsForTest(compName,compType,d_test,tab);
			long ltime=System.currentTimeMillis();
			String key=compName+":"+portNo+":"+d_test+":"+msmtHost;
			String oneMsmtTime=dashboardDAO.getMeasureLastMsmtTime(key);
			
			if(msmtHost==null)
				msmtHost="";

			boolean isFullView=false;
			Vector infos=(Vector)allTestInfos.get(d_test);
			Vector infosForCutOffFactor = new Vector();
			if(model.isTestHasCutOffFactor(d_test))
			{
				if(infos!=null && !infos.isEmpty())
				{
					for(int d=0;d<infos.size();d++)
					{
						String infoForDial=(String)infos.get(d);
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,d_test,msmtHost,infoForDial);
						if(!isTestExceededCutOffFactor)
						{
							if(infosForCutOffFactor!=null && !infosForCutOffFactor.contains(infoForDial))
							{
								infosForCutOffFactor.add(infoForDial);
							}
						}
					}
				}
				if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
				{
					infos=infosForCutOffFactor;
				}
			}
			if(infos!=null && !infos.isEmpty() && infos.size()>1)
			{
				isFullView=true;
			}
			String info=fusionChart.getInfoForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed);

			if(info!=null && info.indexOf("+")!=-1)
				info=info.substring(info.indexOf("+")+1);
			info=StringUtils.replace(info, "+", "|plus|");

			Vector dialChartAttributes=new Vector();
			dialChartAttributes.add("clickURL='javascript:wayToLayerModel(&apos;dialUrl"+dialChartCount+"&apos;)'");  // To avoid drilldown url problem in Doublebyte. We have to create one HIDDEN element and the url to be stored there
			dialChartAttributes.add("fillAngle='60'");
			dialChartAttributes.add("majorTMNumber='6'");
			dialChartAttributes.add("majorTMHeight='8'");
			dialChartAttributes.add("majorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMHeight='4'");
			dialChartAttributes.add("minorTMNumber='6'");
			dialChartAttributes.add("majorTMThickness='1'");
			dialChartAttributes.add("markerRadius='30'");
			dialChartAttributes.add("showGaugeBorder='0'");
			dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
			dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
			dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
			dialChartAttributes.add("gaugeInnerRadius='0'");
			dialChartAttributes.add("formatNumberScale='0'");
			dialChartAttributes.add("displayValueDistance='0'");
			dialChartAttributes.add("decimalPrecision='2'");
			dialChartAttributes.add("tickMarkDecimalPrecision='2'");
			dialChartAttributes.add("tickValueDistance='14'");
			dialChartAttributes.add("pivotRadius='6'");
			dialChartAttributes.add("showPivotBorder='1'");
			dialChartAttributes.add("pivotBorderColor='000000'");
			dialChartAttributes.add("pivotBorderThickness='5'");
			dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
			dialChartAttributes.add("paletteThemeColor='ffffff'");
			dialChartAttributes.add("pivotFillType='linear'");
			dialChartAttributes.add("showToolTip='1'");
			dialChartAttributes.add("chartLeftMargin='0'");
			dialChartAttributes.add("chartRightMargin='0'");
			dialChartAttributes.add("chartBottomMargin='0'");
			dialChartAttributes.add("baseFontColor='000000'");
			dialChartAttributes.add("adjustTM='0'");
			dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("borderAlpha='0'");
			dialChartAttributes.add("bgAlpha='_alpha'");

			dialChartAttributes.add("showToolTipShadow='1'");
			dialChartAttributes.add("toolTipBgColor='ffffff'");
			dialChartAttributes.add("toolTipBorderColor='555555'");
			dialChartAttributes.add("exportEnabled='0'");
			dialChartAttributes.add("exportAction='download'");
			dialChartAttributes.add("exportAtClient='0'");
			dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			
			String layerName=dashboardDAO.getLayerForTest(compType,d_test,d_measure);

			String compTypeForAlarm=compType;
			if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
				compTypeForAlarm="Host_system";

			String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,d_test+"-"+info,d_measure);

			String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=cisco_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+d_test+"-"+info+"&tstate="+measureState+"&msmt_host=&backNav=cmpDashboard";

			String dialXMLData="";
			String colorCode = "";
			if(compType!=null && compType.equals("NetflowDevice") && colorCodes!=null && colorCodes.size()>0)
			{
				colorCode = (String)colorCodes.get(i);
			}
			if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
			{
				dialXMLData=graphUtil.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight,layerPageUrl,colorCode);
			}
			else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
			{
				Vector jvmChartAttributes=new Vector();
				jvmChartAttributes.add("clickURL='javascript:wayToLayerModel(&apos;dialUrl"+dialChartCount+"&apos;)'");
				jvmChartAttributes.add("upperLimit='100'");
				jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
				jvmChartAttributes.add("bgAlpha='0,0'");
				jvmChartAttributes.add("showBorder='0'");
				jvmChartAttributes.add("adjustTM='0'");
				jvmChartAttributes.add("lowerLimit='0'");
				jvmChartAttributes.add("decimals='2'");
				jvmChartAttributes.add("showValue='0'");
				jvmChartAttributes.add("majorTMNumber='5'");
				jvmChartAttributes.add("majorTMColor='000000'");
				jvmChartAttributes.add("majorTMHeight='5'");
				jvmChartAttributes.add("minorTMNumber='2'");
				jvmChartAttributes.add("minorTMColor='000000'");
				jvmChartAttributes.add("minorTMHeight='2'");
				jvmChartAttributes.add("majorTMThickness='1'");
				jvmChartAttributes.add("decimalPrecision='0'");
				jvmChartAttributes.add("ledGap='"+ledGap+"'");
				jvmChartAttributes.add("ledSize='"+ledSize+"'");
				jvmChartAttributes.add("tickValueDistance='2'");
				jvmChartAttributes.add("tickMarkDistance='1'");
				jvmChartAttributes.add("tickValueStep='1'");
				jvmChartAttributes.add("tickValueDecimals='8'");
				jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
				jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
				jvmChartAttributes.add("chartTopMargin='21'");
				jvmChartAttributes.add("chartBottomMargin='20'");
				jvmChartAttributes.add("baseFontSize ='9'");
				jvmChartAttributes.add("showToolTip='1'");
				jvmChartAttributes.add("baseFontColor  ='000000'");
				jvmChartAttributes.add("annRenderDelay='1.7'");
				jvmChartAttributes.add("exportEnabled='0'");
				jvmChartAttributes.add("exportAction='download'");
				jvmChartAttributes.add("exportAtClient='0'");
				jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

				dialXMLData=graphUtil.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"000000",true,ledGraphWidth,ledGraphHeight,defaultLedGraphWidth,defaultLedGraphHeight,layerPageUrl,"");
			}
			if(dialXMLData !=null && !dialXMLData.equals(""))
			{
				String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+d_test+"&measure="+d_measure+"&msmtHost="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&tab="+tab;

				ciscoObj.put("tooltip",tooltip);
				ciscoObj.put("unit",unit);
				ciscoObj.put("dial_measureMapping",dial_measureMapping);
				if(isFullView)
				{
					ciscoObj.put("moreDescriptorUrl",moreDescriptorUrl);
				}
				if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
				{
					ciscoObj.put("dialXMLData",dialXMLData);
					ciscoObj.put("dialGraphWidth",dialGraphWidth);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					ciscoObj.put("moreDescriptorUrl",moreDescriptorUrl);
					ciscoObj.put("FusionChartsURL","/final/FusionCharts/swf/AngularGauge.swf");
				}
				else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
				{
					ciscoObj.put("dialXMLData",dialXMLData);
					ciscoObj.put("dialGraphHeight",ledGraphHeight);
					ciscoObj.put("dialGraphWidth",ledGraphWidth);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					ciscoObj.put("FusionChartsURL","/final/FusionCharts/swf/VLED.swf");
				}
				hiddens.put("dialUrl"+dialChartCount, layerPageUrl);
				dialChartCount++;
				ciscoArray.add(ciscoObj);
			}
			i++;
			
		}
		dialChartValues.put("dialChartValues",ciscoArray);
		for (int na=1;na < dialmeasuresNAList.size()+1;na++)
		{
			if(dialmeasuresNAList.size()==i)
			{
				String NAlistdata = (String)dialmeasuresNAList.get(na-1);
				String dial_measureMapping = NAlistdata.substring(0,NAlistdata.indexOf("#"));
				String unit = NAlistdata.substring(NAlistdata.indexOf("#")+1,NAlistdata.indexOf("$"));
				String tooltip = NAlistdata.substring(NAlistdata.indexOf("$")+1);
				int temCount=(++dialChartCount)%5;
				dialChartCount--;

				rootJson.put("DIAL_TITLE",mappingInfo.getTextDescription("monitor.dashboard.Dial Graph"));
				rootJson.put("NoMeasure",mappingInfo.getTextDescription("monitor.dashboard.No measures available!"));
				dialChartNoMeasuresCount++;
					int tempCount=(++dialChartCount)%5;
					dialChartCount--;
					break;
				}
			}
		}
		double defaultTableWidth=950;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);

		String interfaceEntries = iniobj.getValue(compType,"Netflow_Interface");
		boolean isTestEnabledOrIncluded = false;
		if(interfaceEntries!=null && interfaceEntries.length() > 0)
		{
			StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");
			StringBuffer infosToAreaChart=new StringBuffer();
			Map mapData=new HashMap();
			ArrayList units=new ArrayList();
			units.add("-");
			String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&blockType=CiscoComparisionTable&tab=Network";
			StringBuffer measureColumn=new StringBuffer();
			String fullviewTest="";
			String fullviewMsmtHost="";
			String interfaceCount_fullview="";
			String selectedTimeline=request.getParameter("selectedTimeline");

			if(StringUtils.isNull(selectedTimeline))
				selectedTimeline="1 hour";
			int imgcnt=0;
			int stColPos=1;
			int endColPos=5;
			List headers=new ArrayList();
			headers.add("Interface");
			while(stoken.hasMoreTokens())
			{
				String testMeasure=stoken.nextToken();
				String interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
				String interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);
				String measureForDB=dbInfo.getColumnForMeasure(interface_test,interface_measure);
				String msmthost=(String)allMsmtHosts.get(interface_test);
				String excludedInfos=iniobj.getValue("INFOS_TO_BE_OMITTED",testMeasure);
				String interfaces_Count=iniobj.getValue("Interfaces","MaxInterfaces");
				String iniheader=iniobj.getValue(compType,testMeasure);
				headers.add(iniheader);
				fullviewTest=interface_test;
				fullviewMsmtHost=msmthost;
				interfaceCount_fullview=interfaces_Count;
				measureColumn.append(measureForDB);
				if(stoken.hasMoreTokens())
					measureColumn.append(",");
				//newly added
				
				StringTokenizer infos=new StringTokenizer(excludedInfos,",");
				Vector excluded_infos=new Vector();
				
				if(enabledTests!=null && !enabledTests.contains(interface_test))
					continue;
				if(getExcludedTest != null && getExcludedTest.contains(interface_test))
					continue;
				isTestEnabledOrIncluded = true;
				while(infos.hasMoreTokens())
				{
						excluded_infos.add("+"+infos.nextToken());
				}
				Vector filtered_infos=new Vector();
				Vector currentValues = null;
					
				if(measureForDB.equalsIgnoreCase("AVAILABILITY")){
					currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,interface_test,measureForDB,msmthost,"",true,interfaces_Count);//newly added

				}
				else {
					currentValues=(Vector)dashboardDAO.getInfosForInterfaceTest(hostName,portNo,interface_test,measureForDB,msmthost,"",true,selectedTimeline,"",interfaces_Count);//newly added
				}
				String tableName = iniobj.getValue("Dashboard_GraphTitle_Mapping",testMeasure);
				String defaultInfo="";
				String unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
				
				units.add(unit);

				if(currentValues!=null && currentValues.size()>0)
				{
					for(int i=0;i<currentValues.size();i=i+2)
					{
						String interfaceInfo=(String)currentValues.get(i);
						String value=(String)currentValues.get(i+1);
						if(!excluded_infos.contains(interfaceInfo))
						{
								filtered_infos.add(interfaceInfo);
								filtered_infos.add(value);
						}
					}
				}
				if(filtered_infos!=null && filtered_infos.size()>0)
				{
					for(int i=0;i<filtered_infos.size();i=i+2)
					{
						String interfaceInfo=(String)filtered_infos.get(i);
						String value=(String)filtered_infos.get(i+1);
						if(mapData!=null && mapData.containsKey(interfaceInfo))
						{
							ArrayList existingList=(ArrayList)mapData.get(interfaceInfo);
							existingList.add(value);
							mapData.put(interfaceInfo,existingList);
						}
						else
						{
							ArrayList valueList=new ArrayList();
							valueList.add(value);
							mapData.put(interfaceInfo,valueList);
						}
					}
				}
			}

			comparisonTableFullViewURL+="&test="+fullviewTest+"&measure="+measureColumn.toString()+"&msmtHost="+fullviewMsmtHost+"&interfaces_Count="+interfaceCount_fullview+"&fromInterface=true&headerList="+headers+"&inilookup=Cisco_Interface";

			String Interfaces = mappingInfo.getTextDescription("monitor.title.Network Interfaces Summary");
			GridValues.put("MAIN_TITLE",Interfaces);
			GridValues.put("comparisonTableFullViewURL",comparisonTableFullViewURL);
			if(adminPermission==true)
			{
				GridValues.put("comparisonTableFullViewURL",comparisonTableFullViewURL);
			}		
			JSONObject gridColumns=new JSONObject();
			if(mapData!=null && !mapData.isEmpty())
			{			
				endColPos=headers.size();
				for(int j=0;j<headers.size();j++)
				{
					String h_unit=(String)units.get(j);
					if(h_unit.equals("-"))
						h_unit="";
					if(j==0)
					{
						gridColumns.put("COLUMNam_"+j,(String)headers.get(j));
					}
					else
					{
						gridColumns.put("COLUMNam_"+j,(String)headers.get(j)+"  ("+h_unit+")");
					}
					imgcnt++;
				}
				Iterator itr=mapData.keySet().iterator();
				endColPos=5;

				int k=0;
				JSONArray  stateJson=new JSONArray();
				while(itr.hasNext())
				{
					String info=(String)itr.next();
					infosToAreaChart.append(info);
					if(itr.hasNext())
						infosToAreaChart.append(",");
					String text = mappingInfo.getTextDescription(StringUtils.replace(info, "+", ""));
					text = text.substring(0, text.length() - 1);

					ArrayList values=(ArrayList)mapData.get(info);
					JSONObject jsonObj=new JSONObject();
					if(values!=null && values.size()>0)
					{
						jsonObj.put("COLUMN_0",text);
						for(int i=0;i<values.size();i++)
						{
							String val=(String)values.get(i);
							if(val.startsWith("-"))
								val="-";
							if(i==0)
							{
								String measVal = dbInfo.formatValue(val);
								String img="";
								if(measVal.equals("100"))
								{
									img = "iconRight";
								}
								else
								{
									img="iconWrong";
								}
								jsonObj.put("COLUMN_"+(i+1),img);
								}
							else
							{
								jsonObj.put("COLUMN_"+(i+1),val);
							}
						}
						stateJson.add(jsonObj);	
					}				
					k++;
				}
				GridValues.put("STATE_VALUES",stateJson);			
			}
			else
			{
				gridColumns.put("Interface_NOMes",mappingInfo.getTextDescription("monitor.common.No measures available!"));
			}
			GridValues.put("COLUMN_VALUES",gridColumns);

			String passingInfo=infosToAreaChart.toString();
			String url="/final/monitor/EgNetflowDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&mappingName=abc&blockType=areaChart&infosToArea="+infosToAreaChart;
			String areaChartURL = "/final/monitor/EgNetflowDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=areaChart&infosToArea="+infosToAreaChart+"&ciscoSelectedType="+ciscoSelectedType;
			
			String defaultAreaGraphDuration=iniobj.getValue("Default_AreaGraph_Duration","duration");
			String protocolsURL = "/final/monitor/EgNetflowDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=Protocols&infosToArea="+infosToAreaChart+"&ciscoSelectedType="+ciscoSelectedType+"&timeline="+defaultAreaGraphDuration;

			String interFace_view = request.getParameter("interfaceToView");
			String infosToArea=request.getParameter("infosToArea");			

			String flowsURL = "/final/monitor/EgNetflowDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=Flows&infosToArea="+infosToAreaChart+"&ciscoSelectedType="+ciscoSelectedType;

			if(interFace_view!=null && interFace_view!=""){
				flowsURL += "&interfaceToView="+interFace_view;
				protocolsURL += "&interfaceToView="+interFace_view;
			}
			
			String timeline = request.getParameter("timeline");			
			if(StringUtils.isNull(timeline))
				timeline = defaultPieGraphDuration;
			flowsURL +="&timeline="+timeline;
			
			ErReportHelper er_helper = new ErReportHelper();
			int maxInfo = er_helper.getMaxInfos("INFOS","Showtop");
			String showVal = request.getParameter("show");			
			if(StringUtils.isNull(showVal))
			showVal = "TOP - "+maxInfo;
			flowsURL +="&show="+showVal;
			JSONArray selectedTimelineArray = new JSONArray();
			String[] dateChoice={"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","Any"};
			List datelist=Arrays.asList(dateChoice);
			JSONArray timelineJson=new JSONArray();
			for(int i=0;i<datelist.size();i++)
			{
				JSONObject tmJson=new JSONObject();
				String element=(String)datelist.get(i);
				String selected="";
				if(element.equals("1 hour"))
					selected="selected";
				tmJson.put("displayField",element);
				tmJson.put("valueField",element);
				timelineJson.add(tmJson);		
			}
			
			if(StringUtils.isNull(selectedTimeline))
				selectedTimeline="1 hour";
			selectedTimelineArray.add(selectedTimeline);
			rootJson.put("TIMELINE_VALUES",timelineJson);
			rootJson.put("selectedTimeline",selectedTimelineArray);
			rootJson.put("GRID_DATA",GridValues);
			rootJson.put("AREACHART_URL",areaChartURL);
			rootJson.put("protocolsURL",protocolsURL);
			rootJson.put("flowsURL",flowsURL);
		}
	
		String requestData = ErUtils.prepareQueryString(request.getParameterMap());		
		if(requestData!=null)
		{
			if(session!=null)
			{
				session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+requestData+"&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&graphType=&toDashBoardLayer=true");
				session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
			}
		}
		else
		{
			if(session!=null)
			{
				session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true&ciscoSelectedType="+ciscoSelectedType);
				session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
			}
		}
		rootJson.put("hiddens", hiddens);
		rootJson.put("OVERVIEW", overviewObj);	
		rootJson.put("FUSION-CHART",dialChartValues);	
		if(isAnyTestExcludedOrDisabledForDial){
			rootJson.put("DIAL_MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled")+"!");
		}
		rootJson.put("NET_TAB_NoGraphTitle", mappingInfo.getTextDescription("monitor.dashboard.Availability/Network Traffic"));

		out.println(rootJson.toString());
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}


    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
