package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.supermanager.*;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import net.sf.json.*;
import egurkha.EgDbAdapterUI;
import com.eg.EgDbAdapterTypeUI;
import com.eg.supermanager.*;
import java.util.*;
import java.sql.*;
import java.text.*;
import java.io.*;
import com.egurkha.RUMHelper;

public final class EgRUMTopology_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	DecimalFormat percentFormat = new DecimalFormat("#.##");

	private String name = "USER_NAME";
	private String guid = "GUID";
	private String country = "COUNTRY";
	private String region = "REGION";
	private String countryCode = "COUNTRY_CODE";
	private String city = "CITY";
	private String rumUserExp = "RUM_USER_EXP";
	private String rumUserExpKey = "RUM_USER_EXPERIENCE";
	private String requestDate = "REQUEST_DATE";
	private String url = "URL";
	private String pagetype = "PAGETYPE";
	private String referrer = "REFERRER";
	private String ip = "IP";
	private String gatewayIp = "GATEWAY_IP";
	private String device = "DEVICE";
	private String os = "OS";
	private String errorMessage = "ERROR_MESSAGE";
	private String errorMsgCount = "ERROR_MSG_COUNT";
	private String requestTimeZone = "REQUEST_TIME_ZONE";
	private String sessionid = "SESSIONID";
	private String slowUrlThreshold = "SLOW_URL_THRESHOLD";
	private String browserName = "BROWSER";
	private String browserNameKey = "NAME";
	private String browserVersion = "BROWSER_VERSION";
	private String browserVersionKey = "VERSION";
	private String pageLoadTime = "PAGE_LOAD_TIME";
	private String frontEndTime = "FRONT_END_TIME";
	private String firstByteTime = "FIRST_BYTE_TIME";
	private String pageRenderTime = "PAGE_RENDER_TIME";
	private String documentReadyTime = "DOCUMENT_READY_TIME";
	private String documentDownloadTime = "DOCUMENT_DOWNLOAD_TIME";
	private String documentProcessingTime = "DOCUMENT_PROCESSING_TIME";
	private String serverConnectionTime = "SERVER_CONNECTION_TIME";
	private String dnsLookupTime = "DNSLOOKUPTIME";
	private String tcpConnectTime = "TCPCONNECTTIME";
	private String responseAvailableTime = "RESPONSE_AVAILABLE_TIME";
	private String redirectOrAppCacheKey = "REDIRECT_OR_APPCACHE";
	private String browserPercentageKey = "BROWSER_PERCENTAGE";
	private String networkPercentageKey = "NETWORK_PERCENTAGE";
	private String backendPercentageKey = "BACKEND_PERCENTAGE";
	private String contentDownloadPercentageKey = "CONTENT_DOWNLOAD_PERCENTAGE";
	private String valueKey = "value";
	private String legendKey = "legend";
	private String colorKey = "color";
	private String browserColor_Light = "#409fb4";
	private String networkColor_Light = "#24384b";
	private String backendColor_Light = "#f1be5c";
	private String contentDwnlColor_Light = "#e57e73";

	private String browserColor_Dark = "#d6b088";
	private String networkColor_Dark = "#7c9ac9";
	private String backendColor_Dark = "#c998b4";
	private String contentDwnlColor_Dark = "#8f8483";
	
	public Hashtable getRumMeasures(String rumQuery,HttpSession session) { 
		ResultSet rs = null;
		Hashtable resultRumList = new Hashtable();
		EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
		try{
			String s_status = egDb.setConnection();
			if(s_status.equals("CONNECTED")){
				if(EgInstallInfo.isSuperManager)
				{
					Object obj = session.getAttribute("sm_mgr_ids");
					if(obj != null && obj instanceof ArrayList)
					{
						ArrayList managerIDs = (ArrayList)obj;
						SmSessionData smsData = new SmSessionData(session.getId(),(ArrayList)managerIDs);
						EgThreadLocal egtl = new EgThreadLocal();
						egtl.set(smsData);
						new SMDateTimeConverter(managerIDs);
					}
				}
				rs = egDb.dbselect(rumQuery);
			}
			ResultSetMetaData metaData = rs.getMetaData();
			int noOfColumns = metaData.getColumnCount();
			while(rs.next()){
				for (int i = 1; i <=noOfColumns ; i++ ) {
					String columnName = metaData.getColumnName(i);
					resultRumList.put(columnName,rs.getString(i));
				}
			}
		}
		catch (Exception e){
			e.printStackTrace();
		}
		finally{
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		return resultRumList;
	}

	public JSONObject rumJsonBuild(String monitor_Skin, Hashtable rumDataTable,  EgMappingInfo mappingInfo, Hashtable rumResourceDataTable){

		String lbl_Name = mappingInfo.getTextDescription("monitor.rumtopology.USER_NAME");
		String lbl_Guid = mappingInfo.getTextDescription("monitor.rumtopology.GUID");
		String lbl_Country = mappingInfo.getTextDescription("monitor.rumtopology.COUNTRY");
		String lbl_Region = mappingInfo.getTextDescription("monitor.rumtopology.REGION");
		String lbl_CountryCode = mappingInfo.getTextDescription("monitor.rumtopology.COUNTRY_CODE");
		String lbl_City = mappingInfo.getTextDescription("monitor.rumtopology.CITY");
		String lbl_RumUserExp = mappingInfo.getTextDescription("monitor.rumtopology.RUM_USER_EXP");
		String lbl_RumUserExpKey = mappingInfo.getTextDescription("monitor.rumtopology.RUM_USER_EXPERIENCE");
		String lbl_RequestDate = mappingInfo.getTextDescription("monitor.rumtopology.REQUEST_DATE");
		String lbl_Url = mappingInfo.getTextDescription("monitor.rumtopology.URL");
		String lbl_Pagetype = mappingInfo.getTextDescription("monitor.rumtopology.PAGETYPE");
		String lbl_Referrer = mappingInfo.getTextDescription("monitor.rumtopology.REFERRER");
		String lbl_Ip = mappingInfo.getTextDescription("monitor.rumtopology.IP");
		String lbl_GatewayIp = mappingInfo.getTextDescription("monitor.rumtopology.GATEWAY_IP");
		String lbl_Device = mappingInfo.getTextDescription("monitor.rumtopology.DEVICE");
		String lbl_Os = mappingInfo.getTextDescription("monitor.rumtopology.OS");
		String lbl_ErrorMessage = mappingInfo.getTextDescription("monitor.rumtopology.ERROR_MESSAGE");
		String lbl_RequestTimeZone = mappingInfo.getTextDescription("monitor.rumtopology.REQUEST_TIME_ZONE");
		String lbl_Sessionid = mappingInfo.getTextDescription("monitor.rumtopology.SESSIONID");
		String lbl_SlowUrlThreshold = mappingInfo.getTextDescription("monitor.rumtopology.SLOW_URL_THRESHOLD");
		String lbl_BrowserName = mappingInfo.getTextDescription("monitor.rumtopology.BROWSER");
		String lbl_BrowserNameKey = mappingInfo.getTextDescription("monitor.rumtopology.NAME");
		String lbl_BrowserVersion = mappingInfo.getTextDescription("monitor.rumtopology.BROWSER_VERSION");
		String lbl_BrowserVersionKey = mappingInfo.getTextDescription("monitor.rumtopology.VERSION");
		String lbl_PageLoadTime = mappingInfo.getTextDescription("monitor.rumtopology.PAGE_LOAD_TIME");
		String lbl_FrontEndTime = mappingInfo.getTextDescription("monitor.rumtopology.FRONT_END_TIME");
		String lbl_PageRenderTime = mappingInfo.getTextDescription("monitor.rumtopology.PAGE_RENDER_TIME");
		String lbl_DocumentReadyTime = mappingInfo.getTextDescription("monitor.rumtopology.DOCUMENT_READY_TIME");
		String lbl_DocumentDownloadTime = mappingInfo.getTextDescription("monitor.rumtopology.DOCUMENT_DOWNLOAD_TIME");
		String lbl_DocumentProcessingTime = mappingInfo.getTextDescription("monitor.rumtopology.DOCUMENT_PROCESSING_TIME");
		String lbl_ServerConnectionTime = mappingInfo.getTextDescription("monitor.rumtopology.SERVER_CONNECTION_TIME");
		String lbl_DnsLookupTime = mappingInfo.getTextDescription("monitor.rumtopology.DNSLOOKUPTIME");
		String lbl_TcpConnectTime = mappingInfo.getTextDescription("monitor.rumtopology.TCPCONNECTTIME");
		String lbl_ResponseAvailableTime = mappingInfo.getTextDescription("monitor.rumtopology.RESPONSE_AVAILABLE_TIME");
		String lbl_RedirectOrAppCacheKey = mappingInfo.getTextDescription("monitor.rumtopology.REDIRECT_OR_APPCACHE");
		String lbl_BrowserPercentageKey = mappingInfo.getTextDescription("monitor.rumtopology.BROWSER_PERCENTAGE");
		String lbl_NetworkPercentageKey = mappingInfo.getTextDescription("monitor.rumtopology.NETWORK_PERCENTAGE");
		String lbl_BackendPercentageKey = mappingInfo.getTextDescription("monitor.rumtopology.BACKEND_PERCENTAGE");
		String lbl_ContentDownloadPercentageKey = mappingInfo.getTextDescription("monitor.rumtopology.CONTENT_DOWNLOAD_PERCENTAGE");
		
		
		JSONObject rootJson = new JSONObject();
		JSONObject allJson = new JSONObject();
		JSONObject userJson = new JSONObject();
		JSONObject networkJson = new JSONObject();
		JSONObject backendJson = new JSONObject();
		JSONObject contentDownloadJson = new JSONObject();
		JSONObject browserJson = new JSONObject();
		JSONObject headerJson = new JSONObject();
		JSONObject otherJson = new JSONObject();
		JSONObject browserObj = new JSONObject();
		JSONObject networkObj = new JSONObject();
		JSONObject backendObj = new JSONObject();
		JSONObject contentDwlObj = new JSONObject();
		JSONObject mappingNameObj = new JSONObject();
		JSONArray pieCharArray = new JSONArray();
		JSONArray gridData = new JSONArray();
		
		if(rumResourceDataTable != null && rumResourceDataTable.size() > 0)
		{
			for(int m = 0; m <= rumResourceDataTable.size()-1; m++)
			{
				String key = "resource"+m;
				ArrayList resourceList = (ArrayList) rumResourceDataTable.get(key);
				if(resourceList != null && resourceList.size()>0)
				{
					JSONObject tmpObj = new JSONObject();
					tmpObj.put("Resource_Name",resourceList.get(0));
					tmpObj.put("Resource_Domain",resourceList.get(1));
					tmpObj.put("Resource_Type",resourceList.get(2));
					//tmpObj.put("Resource_Time",resourceList.get(3));
					long rescTime = Long.valueOf(resourceList.get(3).toString());
					tmpObj.put("Resource_Time",rescTime);
					gridData.add(tmpObj);
				}
			}
			rootJson.put("gridData", gridData);
		}
		double totalTime = Double.parseDouble((String)rumDataTable.get(pageLoadTime));
		double browserTime = Double.parseDouble((String)rumDataTable.get(pageRenderTime));
		double backendTime = Double.parseDouble((String)rumDataTable.get(responseAvailableTime));
		double contentDownloadTime = Double.parseDouble((String)rumDataTable.get(documentReadyTime));
		double networkTime = Double.parseDouble((String)rumDataTable.get(serverConnectionTime));
		double dnsTime = Double.parseDouble((String)rumDataTable.get(dnsLookupTime));
		double tcpTime = Double.parseDouble((String)rumDataTable.get(tcpConnectTime));
		double redirectOrAppCache = networkTime - (dnsTime+tcpTime);
		double docDwnldTime = Double.parseDouble((String)rumDataTable.get(documentDownloadTime));
		double docprsngTime = Double.parseDouble((String)rumDataTable.get(documentProcessingTime));
		double slowUrlThrsld = Double.parseDouble((String)rumDataTable.get(slowUrlThreshold));
		double ajaxBackendTime = Double.parseDouble((String)rumDataTable.get(firstByteTime));
		double browserPercentage = 0.0d;
		double networkPercentage = 0.0d;
		double backendPercentage = 0.0d;
		double contentDownloadPercentage = 0.0d;
		String errorMsgValue = (String)rumDataTable.get(errorMessage);
		String pageTypeReq = (String)rumDataTable.get(pagetype);

		if (pageTypeReq != null && pageTypeReq.equalsIgnoreCase("Ajax")) { 
			 backendPercentage = Double.parseDouble(percentFormat.format((ajaxBackendTime/totalTime)*100));
			 contentDownloadPercentage = Double.parseDouble(percentFormat.format((docDwnldTime/totalTime)*100));
			 browserPercentage = Double.parseDouble(percentFormat.format((docprsngTime/totalTime)*100));
		} else {
			 browserPercentage = Double.parseDouble(percentFormat.format((browserTime/totalTime)*100));
			 networkPercentage = Double.parseDouble(percentFormat.format((networkTime/totalTime)*100));
			 backendPercentage = Double.parseDouble(percentFormat.format((backendTime/totalTime)*100));
			 contentDownloadPercentage = Double.parseDouble(percentFormat.format((contentDownloadTime/totalTime)*100));
		}

		userJson.put(name,"");
		userJson.put(pageLoadTime,Math.round(totalTime));
		userJson.put(city,rumDataTable.get(city));
		userJson.put(region,rumDataTable.get(region));
		userJson.put(country,rumDataTable.get(country));
		userJson.put(countryCode,rumDataTable.get(countryCode));
		userJson.put(os,rumDataTable.get(os));
		userJson.put(ip,rumDataTable.get(ip));
		userJson.put(gatewayIp,"-");
		userJson.put(device,rumDataTable.get(device));
		userJson.put(rumUserExpKey,rumDataTable.get(rumUserExp));
		if(errorMsgValue != null && errorMsgValue != "-" && errorMsgValue.length() > 1)
		{
			//userJson.put(errorMessage,rumDataTable.get(errorMessage));
			int errorCount = 0;
			String finalErrorMsg = "";
			StringTokenizer st = new StringTokenizer(errorMsgValue,"]");
			while (st.hasMoreElements()) {
				String errorMsg = ((String) st.nextElement())+"]";
				if (errorMsg.startsWith(",")) {
					errorMsg = errorMsg.substring(1);
				}
				finalErrorMsg = finalErrorMsg+"<div>"+errorMsg+"</div>";
				errorCount = errorCount + 1;
			}
			userJson.put(errorMessage,finalErrorMsg);
			userJson.put(errorMsgCount,errorCount);
		}
		networkJson.put(serverConnectionTime,Math.round(networkTime));
		networkJson.put(lbl_DnsLookupTime,Math.round(dnsTime));
		networkJson.put(lbl_TcpConnectTime,Math.round(tcpTime));
		networkJson.put(lbl_RedirectOrAppCacheKey,Math.round(redirectOrAppCache));
		if (pageTypeReq != null && pageTypeReq.equalsIgnoreCase("Ajax")) {
			backendJson.put(responseAvailableTime,Math.round(ajaxBackendTime));
			contentDownloadJson.put(documentReadyTime, Math.round(docDwnldTime));
			browserJson.put(pageRenderTime,Math.round(docprsngTime));
		} else {
			backendJson.put(responseAvailableTime,Math.round(backendTime));
			contentDownloadJson.put(documentReadyTime, Math.round(contentDownloadTime));
			browserJson.put(pageRenderTime,Math.round(browserTime));
		}
		contentDownloadJson.put(lbl_DocumentDownloadTime,Math.round(docDwnldTime));
		contentDownloadJson.put(lbl_DocumentProcessingTime,Math.round(docprsngTime));
		browserJson.put(browserName,rumDataTable.get(browserName));
		browserJson.put(browserVersionKey,rumDataTable.get(browserVersion));
		browserJson.put(pagetype,rumDataTable.get(pagetype));
		browserJson.put(referrer,rumDataTable.get(referrer));
		headerJson.put(url,rumDataTable.get(url));
		headerJson.put(requestDate,rumDataTable.get(requestDate));
		headerJson.put(requestTimeZone,rumDataTable.get(requestTimeZone));
		otherJson.put(slowUrlThreshold,Math.round(slowUrlThrsld));
		
		networkObj.put(valueKey,networkPercentage);
		networkObj.put(legendKey,networkPercentageKey);
		
		backendObj.put(valueKey,backendPercentage);
		backendObj.put(legendKey,backendPercentageKey);
		
		contentDwlObj.put(valueKey,contentDownloadPercentage);
		contentDwlObj.put(legendKey,contentDownloadPercentageKey);

		browserObj.put(valueKey,browserPercentage);
		browserObj.put(legendKey,browserPercentageKey);
		
		if(monitor_Skin.equals("Dark"))
		{
			networkObj.put(colorKey,networkColor_Dark);
			backendObj.put(colorKey,backendColor_Dark);
			contentDwlObj.put(colorKey,contentDwnlColor_Dark);
			browserObj.put(colorKey,browserColor_Dark);
		}
		else
		{
			networkObj.put(colorKey,networkColor_Light);
			backendObj.put(colorKey,backendColor_Light);
			contentDwlObj.put(colorKey,contentDwnlColor_Light);
			browserObj.put(colorKey,browserColor_Light);
		}
		if (!pageTypeReq.equalsIgnoreCase("Ajax")) {
			pieCharArray.add(networkObj);
		}
		pieCharArray.add(backendObj);
		pieCharArray.add(contentDwlObj);
		pieCharArray.add(browserObj);


		// Mapping Name Json Code Starts Here
		mappingNameObj.put(name,lbl_Name);
		mappingNameObj.put(guid,lbl_Guid);
		mappingNameObj.put(country,lbl_Country);
		mappingNameObj.put(region,lbl_Region);
		mappingNameObj.put(countryCode,lbl_CountryCode);
		mappingNameObj.put(rumUserExp,lbl_RumUserExp);
		mappingNameObj.put(rumUserExpKey,lbl_RumUserExpKey);
		mappingNameObj.put(requestDate,lbl_RequestDate);
		mappingNameObj.put(url,lbl_Url);
		mappingNameObj.put(pagetype,lbl_Pagetype);
		mappingNameObj.put(referrer,lbl_Referrer);
		mappingNameObj.put(ip,lbl_Ip);
		mappingNameObj.put(gatewayIp,lbl_GatewayIp);
		mappingNameObj.put(device,lbl_Device);
		mappingNameObj.put(os,lbl_Os);
		mappingNameObj.put(errorMessage,lbl_ErrorMessage);
		mappingNameObj.put(requestTimeZone,lbl_RequestTimeZone);
		mappingNameObj.put(sessionid,lbl_Sessionid);
		mappingNameObj.put(slowUrlThreshold,lbl_SlowUrlThreshold);
		mappingNameObj.put(browserName,lbl_BrowserName);
		mappingNameObj.put(browserNameKey,lbl_BrowserNameKey);
		mappingNameObj.put(browserVersion,lbl_BrowserVersion);
		mappingNameObj.put(browserVersionKey,lbl_BrowserVersionKey);
		mappingNameObj.put(pageLoadTime,lbl_PageLoadTime);
		mappingNameObj.put(frontEndTime,lbl_FrontEndTime);
		mappingNameObj.put(pageRenderTime,lbl_PageRenderTime);
		mappingNameObj.put(documentReadyTime,lbl_DocumentReadyTime);
		mappingNameObj.put(documentDownloadTime,lbl_DocumentDownloadTime);
		mappingNameObj.put(documentProcessingTime,lbl_DocumentProcessingTime);
		mappingNameObj.put(serverConnectionTime,lbl_ServerConnectionTime);
		mappingNameObj.put(dnsLookupTime,lbl_DnsLookupTime);
		mappingNameObj.put(tcpConnectTime,lbl_TcpConnectTime);
		mappingNameObj.put(responseAvailableTime,lbl_ResponseAvailableTime);
		mappingNameObj.put(redirectOrAppCacheKey,lbl_RedirectOrAppCacheKey);
		mappingNameObj.put(browserPercentageKey,lbl_BrowserPercentageKey);
		mappingNameObj.put(networkPercentageKey,lbl_NetworkPercentageKey);
		mappingNameObj.put(backendPercentageKey,lbl_BackendPercentageKey);
		mappingNameObj.put(contentDownloadPercentageKey,lbl_ContentDownloadPercentageKey);
		// Mapping Name Json Code Ends Here

		allJson.put("skin",monitor_Skin);
		allJson.put("user_Info",userJson);
		allJson.put("network_Info",networkJson);
		allJson.put("backend_Info",backendJson);
		allJson.put("contentDownload_Info",contentDownloadJson);
		allJson.put("browser_Info",browserJson);
		allJson.put("header_Info",headerJson);
		allJson.put("other_Info",otherJson);
		allJson.put("pieChart_Info",pieCharArray);
		allJson.put("mappingName_Info",mappingNameObj);
		rootJson.put("rumTopology",allJson);

		//System.out.println("RootJson Result is : "+rootJson);
		return rootJson;
	}


  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgMonitorTracker.jsp");
  }

  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.release();
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String mgrDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	boolean isMobileCall=false;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;	
	String fromMobile=request.getParameter("fromMobile");
	String isFromMenu=request.getParameter("isFromMenu");
	String dateFormatForDatePicker ="";

	User u_ser = null;
	EgMappingInfo mappingInfo = null;
	String trackerLanguage = trackerUI.getDefaultLanguage();
	/**
			 Operation - Mobile check
			 Purpose - Support for accessing the manager via mobile.
			 Author - Praveen 8/4/2014
	**/
	if (fromMobile!=null&&fromMobile.equals("yes"))
	{
		String uname=request.getParameter("uname");
		isMobileCall=true;
		try
		{
			ErUserData userData = new ErUserData(uname,false);
			if(userData!=null)
			{
				u_ser=userData.usr;
				if(u_ser==null)
				{
					u_ser = userData.getUser(uname);
				}
				if(u_ser!=null)
				{
					String userLang = u_ser.getLanguage();
					if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
					{
						trackerLanguage=userLang;
					}
					mappingInfo = new EgMappingInfo(trackerLanguage);
				}
			}
		}
		catch(Throwable t)
		{
			t.printStackTrace();
		}
	} // Ends here
	else
	{
		if(session.getAttribute("sessionId_SM") != null)
		{
			from_sm = true;
			sessionId_sm = (String)session.getAttribute("sessionId_SM");
		}
		if(session!=null)
		{
			if(from_sm)
			{
				u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
			}
			else
			{
				u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
			}
			if(u_ser!=null)
			{
				id_u = u_ser.isIdDeletedWhileLoggedIn();
				if(id_u == false)
				{
					u_rs =  u_ser.getLoginID();
					if(!User.isDefaultUser(u_rs))
					{
						ErUserData er = u_ser.getReporterData();
						u_v_till = er.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
		}
		if ( session != null || u_ser != null )
		{
			String smartValue=request.getParameter("smart");
			String page_help=request.getRequestURI();
			if(isFromMenu != null && isFromMenu.trim().length() > 0 && smartValue==null || (smartValue!=null && smartValue.trim().length()==0) )
			{
				if(!(page_help.endsWith("EgPrintGraph.jsp") || page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")))
					session.setAttribute("Page_IdentifierM", request.getRequestURI());
			}
		}

		if (u_ser!=null)
		{
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
			String trackerUserLang = u_ser.getLanguage();
			if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
			{
				trackerLanguage=trackerUserLang;
			}
		}
		mappingInfo = new EgMappingInfo(trackerLanguage);
		if(u_ser != null)
		{
			dateFormatForDatePicker = (String)u_ser.getUserDateFormat();
		}
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}

		if(session == null || u_ser == null)
		{
			throw new Exception("<customerror>user-session-invalid</customerror>");
		}
		else if(id_u== true)
		{
			throw new Exception("<customerror>user-deleted</customerror>");
		}
		else if (u_v_till < l_accessed)
		{
			throw new Exception("<customerror>user-timedout</customerror>");
		}
	}


	response.setContentType("text/html;charset=UTF-8");
	String comesFrom = request.getParameter("comesFrom");
	
	if(comesFrom!=null && comesFrom.equalsIgnoreCase("mydashboard"))
	{
		String myDashboardTheme = request.getParameter("myDashboardTheme");
		if(!com.egurkha.util.StringUtils.isNull(myDashboardTheme) && !myDashboardTheme.equalsIgnoreCase(monitor_Skin))
		{
			monitor_Skin=myDashboardTheme;
		}
	}

      out.write("<!DOCTYPE html>\n<html id=\"rumBTM\">\n\t<head>\n\t\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n\t\t<meta charset=\"utf-8\">\n\t\t<meta name=\"viewport\" content=\"width=device-width\"/>\n\t\t<title>RUM Topology</title>\n\t\n<script>\n\tvar isMyDashboard='");
      out.print(comesFrom);
      out.write("';\n\tif(isMyDashboard!=null && isMyDashboard==\"MyDashboard\")\n\t{\n\t\tvar strSkin='");
      out.print(monitor_Skin);
      out.write("';\n\t\tif(strSkin!=null && strSkin=='Dark')\n\t\t{\n\t\t\tdocument.write('<link rel=\"stylesheet\" href=\"/final/resources/css/ext-eg.css\"  media=\"all\"/>');\n\t\t\tdocument.write('<link rel=\"stylesheet\" href=\"/final/styles/eGDarkTheme.css\" media=\"all\" />');\n\t\t\tdocument.write('<link rel=\"stylesheet\" href=\"/final/styles/eGDarkThemeIcons.css\"  media=\"all\" />');\n\t\t}\n\t\telse\n\t\t{\n\t\t\tdocument.write('<link rel=\"stylesheet\" href=\"/final/resources/css/ext-eg.css\"  media=\"all\"/>');\n\t\t\tdocument.write('<link rel=\"stylesheet\" href=\"/final/styles/eGLightTheme.css\" media=\"all\" />');\n\t\t\tdocument.write('<link rel=\"stylesheet\" href=\"/final/styles/eGLightThemeIcons.css\"  media=\"all\" />');\n\t\t}\n\t}\n\telse\n\t{\t\n\t\tdocument.write('");
      if (_jspx_meth_egui_005fskin_005f0(_jspx_page_context))
        return;
      out.write("');\n\t}\n</script>\t\t\n\n\t\t<script type=\"text/javascript\" src=\"/final/extjs/ext-all.js\"></script>\n\t\t<script type=\"text/javascript\" src=\"/final/scripts/jquery-1.8.2.min.js\"></script>\n\t\t<!-- script src=\"/final/scripts/d3.min.js\" script -->\n\t\t<script src=\"/final/Highcharts/js/highstock.js\"></script>\n\t\t<script src=\"/final/Highcharts/js/modules/exporting.js\"></script>\n\t</head>\n\t<body>\n");

	
	String rumGuid = request.getParameter("rumGuid");
	String testName = request.getParameter("testName");
	//String rumGuid = "01605428-b2e2-4e3b-9e53-4e9193660ec0-1458105847642";
	JSONObject jsonResult = new JSONObject();

	String rumQuery  = "SELECT  distinct GUID , APPLICATION_NAME , COUNTRY , REGION , CITY , COUNTRY_CODE , RUM_USER_EXP , REQUEST_DATE , URL , PAGETYPE , REFERRER , IP, DEVICE ,OS , ERROR_MESSAGE, REQUEST_TIME_ZONE, SESSIONID, SLOW_URL_THRESHOLD, BROWSER, BROWSER_VERSION , PAGE_LOAD_TIME, FRONT_END_TIME , PAGE_RENDER_TIME , DOCUMENT_READY_TIME, DOCUMENT_DOWNLOAD_TIME ,DOCUMENT_PROCESSING_TIME ,SERVER_CONNECTION_TIME , DNSLOOKUPTIME, TCPCONNECTTIME, RESPONSE_AVAILABLE_TIME, FIRST_BYTE_TIME FROM RUM_DETAILS WHERE guid ='"+rumGuid+"'";

	Hashtable rumDataTable = getRumMeasures(rumQuery,session);

	String rumResourceQuery = "SELECT GUID ,RESOURCE_DETAILS FROM RUM_RESOURCE_DETAILS WHERE guid ='"+rumGuid+"'";
	Hashtable rumResourceDataTable = RUMHelper.getRumResourceDetails(rumResourceQuery);
	if (rumResourceDataTable != null && rumResourceDataTable.containsKey("resource0")) {
		rumResourceDataTable.remove("resource0");
	}
	jsonResult = rumJsonBuild(monitor_Skin, rumDataTable, mappingInfo, rumResourceDataTable);
	//System.out.println("------------------- "+jsonResult);
	
      out.write("<script>\n\t\tvar data = ");
      out.print(jsonResult);
      out.write(";\n\t</script>\n\t<script src=\"/final/monitor/eg_scripts/RUMtopologygraph.js\"></script>\n\t</body>\n<html>");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }

  private boolean _jspx_meth_egui_005fskin_005f0(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:skin
    com.egurkha.tags.Skin _jspx_th_egui_005fskin_005f0 = (com.egurkha.tags.Skin) _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.get(com.egurkha.tags.Skin.class);
    _jspx_th_egui_005fskin_005f0.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fskin_005f0.setParent(null);
    // /monitor/EgRUMTopology.jsp(405,18) name = ui type = null reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fskin_005f0.setUi("monitor");
    int _jspx_eval_egui_005fskin_005f0 = _jspx_th_egui_005fskin_005f0.doStartTag();
    if (_jspx_th_egui_005fskin_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f0);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f0);
    return false;
  }
}
