package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.*;
import java.util.Map.Entry;
import java.io.*;
import com.egurkha.*;
import com.egurkha.monitor.EgServerDashboardModel;
import com.egurkha.monitor.EgDashBoardModel;
import com.egurkha.util.*;
import com.eg.*;
import com.egurkha.monitor.VmDashboardHelper;
import com.eg.EgMappingInfo;
import com.eg.EgURLEncoder;
import com.eg.IniFile;
import egurkha.reporter.ErUserData;
import com.eg.EgExternalInfo;
import com.egurkha.ini.*;
import net.sf.json.*;
import java.text.*;
import java.math.*;
import com.eg.supermanager.*;

public final class endUserDashboardData_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	private static DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');

        df.applyPattern("#.##");
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingSize(0);
	}

	private static DecimalFormat df2 = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
        DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
        dfs2.setDecimalSeparator('.');

        df2.applyPattern("#.####");
        df2.setDecimalFormatSymbols(dfs2);
        df2.setGroupingSize(0);
	}

	private static DecimalFormat df3 = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
        DecimalFormatSymbols dfs3 = new DecimalFormatSymbols();
        dfs3.setDecimalSeparator('.');

        df3.applyPattern("#");
        df3.setDecimalFormatSymbols(dfs3);
        df3.setGroupingSize(0);
	}

	public static String formatDbValue(String measure)
	{
		String value="";
		try
		{
			/*
				* Check the indexOf "e", For avoid Exponent or Scientific Notation in a String, 
				Because of Address and other String field changed like double data type value
				when we use Double.parseDouble, Its wrong, So put this fix.

				* The real double value not affected because of this change. its shown as per db..

				* changed by Saravanan.A on 31-1-2012.
			*/

			/*
				* Double parsing have problem when double value range exceed, So used BigDecimal instead of Double parsing.

				* changed by Saravanan.A on 15-2-2012.
			*/

			String measure_lower=null;
			if(measure!=null && measure.length()>0)
				measure_lower=measure.toLowerCase().trim();
			
			if(measure_lower!=null && measure_lower.indexOf("e")>-1)
			{
				try
				{
					BigDecimal bigDecRef = new BigDecimal(measure);
					value=df2.format(bigDecRef);
				}
				catch(Exception eee)
				{
					value=measure;
				}
			}
			else
			{
				//double val=Double.parseDouble(measure);
				//value = df.format(val);

				BigDecimal bigDecRef = new BigDecimal(measure);
				value = df.format(bigDecRef);
				double xxx=bigDecRef.doubleValue();
				if(xxx>=100.0)
				{
					value = df3.format(bigDecRef);
				}
				else if(xxx>=1 && xxx<100)
				{
					value = df.format(bigDecRef);
				}
				else
				{
					value=df2.format(bigDecRef);
				}

			}
		}catch(Exception e)
		{
			value=measure;
		}
		return value;
	}



	public void writeLog(String content,boolean isDebugEnabledField,int logFileSizeField)
	{
		if(isDebugEnabledField)
		{
			boolean append = true;
				try
				{
					String path = EgInstallInfo.getInstallDir()+ "/manager/logs/userExpDashBoard.txt";
					File f = new File(path); 
					if(f.exists())
					{
						int size = new FileInputStream(f).available();
						if(size>(1024*1024*logFileSizeField))
						{
							append = false;
							content = "";
						}
					}
					PrintWriter pw = new PrintWriter(new FileWriter(path,append));
					pw.write(new java.util.Date()+" endUserDashboardData.jsp "+content);
					pw.write("\n");
					pw.flush();
					pw.close();
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
		}
	}

	public static String getConvertDays(String Value,EgDashBoardModel egDashboard)
	{
		String dateDiff="";
		String currentValue=Value;
		try
		{
			if(currentValue!=null && !currentValue.trim().equals(""))
			{
				long minutes=0;
				int seconds=0;
				if(currentValue!=null && currentValue.indexOf(".")>0)
				{
					minutes=Long.parseLong(currentValue.substring(0,currentValue.indexOf(".")));
					if(currentValue.substring(currentValue.indexOf(".")+1).length()>2)
					{
						seconds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1,currentValue.indexOf(".")+3));
					}
					else
					{
						seconds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1));
					}
				}
				else
				{
					minutes=Long.parseLong(currentValue);
				}
				long valueInSecond=(minutes*60)+seconds;
				dateDiff=egDashboard.getDateDifferenceStringforUptime(valueInSecond);
			}
			else
			{
				dateDiff=currentValue;
			}
		}
		catch(Exception eeew)
		{
			dateDiff=currentValue;
		}

		return dateDiff;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"EgProbsM.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/********************************************************************************************************
*	Name			:	endUserDashboardData.jsp
*	Purpose			:	This is the main page for End User Dashboard
*	Version			:	eG 5.6.5 and Above
*	Creation Date		:	30/01/2014
*	Authtor			:	Vinoth Kumar P V, Saravanan.A
*	Design			:	Vijay and Jaiwin
*******************************************************************************************************/


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");


try
{
	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		ArrayList managerIds = null;
		String currentSession = session.getId();
		if(EgManagersInfo.sessionManagerMap.containsKey(currentSession))
		{
			managerIds = (ArrayList)EgManagersInfo.sessionManagerMap.get(currentSession);
		}
		if(managerIds == null || managerIds.isEmpty())
		{
			EgManagersInfo mgrsInfo = EgManagersInfo.getInstance();
			if(!mgrsInfo.getReportingManagers().isEmpty())
			{
				managerIds = new ArrayList(mgrsInfo.getReportingManagers().keySet());
			}
		}
		if(managerIds != null && !managerIds.isEmpty())
		{
			SmSessionData smsData = new SmSessionData(currentSession,managerIds);
			EgThreadLocal egtl = new EgThreadLocal();
			egtl.set(smsData);
		}
	}
	/* This is for SuperManager - ends */
	UserRegistry registry = UserRegistry.getInstance();
	User user = null; //registry.getUser(session.getId());

	String fromMenuStr = request.getParameter("fromMenu");
	boolean isFromMenu=false;
	if(fromMenuStr!=null && (fromMenuStr.equalsIgnoreCase("true") || fromMenuStr.equalsIgnoreCase("yes")))
	{
		isFromMenu=true;
	}

	if(isFromMenu)
	{
		user = registry.getUser(session.getId(),true);
	}
	else
	{
		user = registry.getUser(session.getId());
	}

	JSONObject jsonRoot = new JSONObject();
	EgUserRole userRole = null;
	boolean isAllCompAccess=false;
	boolean isDataManagerLogin=false;
	String userName = "admin";

	String file = "eg_endUserDetails.ini";
	String dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile ini = new IniFile(dir + file);

	boolean isDebugEnabled = false;
	int logFileSize = 30;

	String browserType = request.getHeader("User-Agent");

	String userExpLogging = ini.getValue("Logging","enableLogging");
	if(userExpLogging!=null && (userExpLogging.equalsIgnoreCase("true") || userExpLogging.equalsIgnoreCase("yes")))
		isDebugEnabled = true;

	if(isDebugEnabled){
		String fileSize = ini.getValue("Logging","fileSize");
		try{
			if(fileSize != null && fileSize.trim().length() > 0)
				logFileSize = Integer.parseInt(fileSize);

		}catch(Exception e){
			logFileSize = 30;
		}
	}

	String strEGManagerUser=ini.getValue("END_USER_DASHBOARD_SETTINGS","eGManagerUser");
	strEGManagerUser=(strEGManagerUser==null || strEGManagerUser.trim().length()==0)?"false":strEGManagerUser;
	boolean isEGManagerUser = strEGManagerUser.equalsIgnoreCase("true")?true:false;
	
	String userType = request.getParameter("userType");
	if(user==null && (!isFromMenu))
	{
		String login_user ="";
		if(isEGManagerUser)
			login_user = request.getParameter("user");

		userName=(login_user==null || login_user.trim().length()==0)?"admin":login_user;
		ErUserData userData = new ErUserData(userName,false);
		if(userData==null)
		{
			userName="admin";
			userData = new ErUserData(userName,false);
			user = userData.usr;
		}
		else if(userData!=null)
		{
			user = userData.usr;
		}

		if(user!=null)
		{
			userRole = user.getUserRole();
			isAllCompAccess = userRole.hasAllComponentAccess();
		}
	}
	else if(user!=null)
	{
		userName = user.getLoginID();
		userRole = user.getUserRole();
		isAllCompAccess = userRole.hasAllComponentAccess();
		isDataManagerLogin = true;
	}

	writeLog(" ::::::::::::::::::::::::::::::::::::::::::::STARTS::::::::::::::::::::::::::::::::::::::::::::::::: ",isDebugEnabled,logFileSize);
	writeLog(" userName  "+userName,isDebugEnabled,logFileSize);
	StringBuffer buf = new StringBuffer();
	IniUI ui = IniUI.getInstance();
	IniFile egEx = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_external.ini");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDbInfo Dbdata = new EgDbInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();
	EgServerDashboardModel dashboardModel = new EgServerDashboardModel();
	EgDashBoardModel  egDashboard=new  EgDashBoardModel();
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		user.setUserLanguageAndSkins();
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String monitor_Skin = user.getMonitorSkin();
	VmDashboardHelper vmDashHelper=new VmDashboardHelper(user);
	List VmsList = new ArrayList();
	EgList egList=new EgList();
	String noOfInfoToDisplay = ""+10;
	EgList vdiDesktopsList= new EgList();
	int vdiDesktopsListTotalCount=0;
	int groupByUserCount = 0;
	Hashtable finalDesktopVmsHash=new Hashtable();
	Hashtable infosCompHash=new Hashtable();
	ArrayList infolist = new ArrayList();
	ArrayList dbinfolist = new ArrayList();

	List resTypeList = new LinkedList();
	List resCnameList = new LinkedList();
	List resCompsList = new LinkedList();
	List resNickList = new LinkedList();
	List resPortList = new LinkedList();

	Hashtable typeCompInfoHash=new Hashtable();
	Hashtable componentsInfo = new Hashtable();
	Hashtable measuresInfo = new Hashtable();
	Hashtable measureValues = new Hashtable();
	Hashtable user_count_hash = new Hashtable();
	ArrayList groupByUserKeys = new ArrayList();
	Hashtable finalGroupByUserTab = new Hashtable();
	Hashtable groupByUser = new Hashtable();
	String maxUser="";
	List componentTypeList=new ArrayList();
	List measureList = new ArrayList();
	String desktopUserName = request.getParameter("username");
	
	String searchString = (desktopUserName!=null && !desktopUserName.equalsIgnoreCase("") && desktopUserName.length()>0)?desktopUserName:request.getParameter("searchString");
	searchString=(searchString==null || searchString.trim().length()==0)?"":searchString;

	String priority = request.getParameter("priority");
	priority=(priority==null || priority.trim().length()==0)?"ALL":priority;
	String tmp_priority=priority;

	String vdiType = request.getParameter("vdiType");
	vdiType=(vdiType==null || vdiType.trim().length()==0)?"":vdiType;

	String orderBy =request.getParameter("orderBy");
	orderBy=(orderBy==null || orderBy.trim().length()==0)?"desc":orderBy;
	if(orderBy==null || orderBy.trim().length()==0 || orderBy.equalsIgnoreCase("null"))
	{
		orderBy="desc";
	}
	
	String aduserFilter = request.getParameter("aduserFilter");
	if(aduserFilter != null)
		aduserFilter=  com.egurkha.util.StringUtils.replace(aduserFilter,"|eq|","=");
	
	boolean defaultAdCase = false;
	if(aduserFilter != null && aduserFilter.equalsIgnoreCase("default")){
		aduserFilter ="All";
		defaultAdCase = true;
	}

	String enableBackButton = request.getParameter("enableBackButton");
	enableBackButton=(enableBackButton==null || enableBackButton.trim().length()==0)?"false":enableBackButton;

	String orderByColumnName = request.getParameter("orderByColumn");
	String columnDispName = request.getParameter("columnDispName");
	String pageNoReq = request.getParameter("pageNo");
	if(pageNoReq==null || pageNoReq.trim().length()==0)
		pageNoReq = "0";

	int pageNo = Integer.parseInt(pageNoReq);
	userType = request.getParameter("userType");
	String searchFrom = request.getParameter("searchFrom");
	if(userType==null || userType.trim().length()==0)
		userType = request.getParameter("usertype");
	userType=(userType==null || userType.trim().length()==0)?"VDI":userType;
	boolean isEndUserOverview = false;
	String endUserDashOverview = request.getParameter("endUserDashOverview");
	endUserDashOverview = (endUserDashOverview==null || endUserDashOverview.trim().length()==0)?"":endUserDashOverview;
	if(endUserDashOverview!=null && endUserDashOverview.trim().length()>0 && (endUserDashOverview.equalsIgnoreCase("true")||endUserDashOverview.equalsIgnoreCase("yes")))
		isEndUserOverview = true;
	boolean isFromUEDSort = false;
	String fromuedsort = request.getParameter("isfromuedsort");
	fromuedsort = (fromuedsort==null || fromuedsort.trim().length()==0)?"":fromuedsort;
	if(fromuedsort!=null && fromuedsort.trim().length()>0 && (fromuedsort.equalsIgnoreCase("true")||fromuedsort.equalsIgnoreCase("yes")))
		isFromUEDSort = true;
	String overviewSearchStr = request.getParameter("overviewsearchstr");
	overviewSearchStr = (overviewSearchStr==null || overviewSearchStr.trim().length()==0)?"":overviewSearchStr;
	String isFromUEDOverview = request.getParameter("isfromuedoverview");
	isFromUEDOverview = (isFromUEDOverview==null || isFromUEDOverview.trim().length()==0)?"":isFromUEDOverview;
	//finalDesktopVmsHash = (Hashtable)vmDashHelper.getVmDesktopsForTheComponent(searchString,priority,vdiType);

	String showUserLocations = ini.getValue("GEO_LOCATION_SETTINGS",userType+":ShowUserLocations");
	String strSeparator = ini.getValue("GEO_LOCATION_SETTINGS",userType+":Separator");
	String strReplaceSep = ini.getValue("GEO_LOCATION_SETTINGS",userType+":ReplaceSeparatorTo");
	showUserLocations = (showUserLocations==null || showUserLocations.trim().length()==0)?"":showUserLocations;
	boolean isShowUserLocation = false;
	if(showUserLocations!=null && showUserLocations.trim().length()>0 && (showUserLocations.equalsIgnoreCase("true") || showUserLocations.equalsIgnoreCase("yes")))
	{
		isShowUserLocation = true;
	}
	String col_Type = request.getParameter("columnType");
	String showSeparateFilters = ini.getValue("LOC_USER_DESKTOP_METRICS",userType+":showSeparateFilters");
	boolean isShowSeparateFilters = (isShowUserLocation && showSeparateFilters!=null && showSeparateFilters.equalsIgnoreCase("true"))?true:false;
	String strUDSortByAllValue=ini.getValue("END_USER_DASHBOARD_SETTINGS","SortByAllMeasureValue");
	strUDSortByAllValue=(strUDSortByAllValue==null || strUDSortByAllValue.trim().length()==0)?"false":strUDSortByAllValue;
	boolean isUDSortByAllValue = (strUDSortByAllValue.equalsIgnoreCase("true") || strUDSortByAllValue.equalsIgnoreCase("yes"))?true:false;

	String strMValueOrder=ini.getValue("END_USER_DASHBOARD_SETTINGS","SortByAllMeasureValueOrder");
	strMValueOrder=(strMValueOrder==null || strMValueOrder.trim().length()==0)?"asc":strMValueOrder;
	
	String decimalFormatMeasure = ini.getValue("USER_DESKTOP_METRICS_DECIMAL_FORMAT_MEASURES",userType);
	ArrayList decimalFormatTestMeasureList = new ArrayList();
	if(decimalFormatMeasure!=null && decimalFormatMeasure.length()>0)
	{
		decimalFormatTestMeasureList = StringUtils.egTokenizer(decimalFormatMeasure,",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
	}

	String convertToDaysMeasure = ini.getValue("USER_DESKTOP_METRICS_CONVERT_TO_DAYS_MEASURES",userType);
	ArrayList convertToDaysTestMeasureList = new ArrayList();
	if(convertToDaysMeasure!=null && convertToDaysMeasure.trim().length()>0)
	{
		convertToDaysTestMeasureList = StringUtils.egTokenizer(convertToDaysMeasure,",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
	}
	Hashtable finalEndUserDatas = (Hashtable)vmDashHelper.getEndUserDatas(userType);
	Hashtable infoResHash = new Hashtable();
	Hashtable dataResHash = new Hashtable();
	Hashtable fullInfoHash = new Hashtable();
	boolean orderByCol_flag=false;
	boolean isDataAvailable = false;
	int measuresCount = 0;
	if(!EgInstallInfo.isSuperManager && finalEndUserDatas!=null && finalEndUserDatas.size()>0)
	{
		infoResHash = (Hashtable)finalEndUserDatas.get("users");
		dataResHash = (Hashtable)finalEndUserDatas.get("usersDetails");
	}

	if(orderByColumnName!=null && orderByColumnName.trim().length()>0 && !orderByColumnName.equalsIgnoreCase("null"))
	{
		tmp_priority="ALL";
		orderByCol_flag=true;
	}
	else if(isUDSortByAllValue)
	{
		tmp_priority="ALL";
	}
	String showFilterNames = ""; 
	if(isShowSeparateFilters)
	{
		IniFile filter_ini = new IniFile(dir + file,true);
		String metrics = ini.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
		if(metrics == null || metrics.trim().length() == 0)
			metrics = ini.getValue("USER_DESKTOP_METRICS","DEFAULT_"+userType);
		ArrayList metricsList = new ArrayList();
		if(metrics != null && metrics.trim().length()>0){
			metricsList = com.egurkha.util.StringUtils.egTokenizer(metrics, ",", true,false,true);
		}
		String comboNames = new String();
		if(metricsList != null && metricsList.size()>0){
			int val_count = 0;
			for(int i=0;i<metricsList.size();i++){
				String met = (String)metricsList.get(i);
				if(met == null || met.trim().length() == 0)
					continue;
				ArrayList check = com.egurkha.util.StringUtils.egTokenizer(met, ":", true,false,true);
				if(check != null && check.size() ==2){
					String geoCheck = (String)check.get(0);
					String geoCheckValue = (String)check.get(1);
					if(geoCheck != null && geoCheck.trim().length()>0)
					{
						if(geoCheck.equalsIgnoreCase("GeoDetails"))
						{
							ArrayList valList = com.egurkha.util.StringUtils.egTokenizer(geoCheckValue, "~$~", true,false,true);
							if((valList != null && valList.size() ==2) && val_count<2){
								val_count++; 
								comboNames = comboNames + (String)valList.get(0)+",";
							}
						}
					}
				}
			}
			if(comboNames!=null && comboNames.trim().length()>0 && comboNames.lastIndexOf(",")>-1)
				comboNames = comboNames.substring(0,comboNames.lastIndexOf(","));
			showFilterNames = comboNames;
		}
	}
	String groupByStr = ini.getValue("LOC_USER_DESKTOP_METRICS",userType+":GroupBy");
	ArrayList groupByList = new ArrayList();
	if(groupByStr!=null && groupByStr.trim().length()>0)
	{
		groupByList = StringUtils.egTokenizer(groupByStr,",",false,true,true);		//param 3-->includeEmpty,4-->unique,5-->trim
	}
	String filterFlag = request.getParameter("filterFlag");
	ArrayList filterInfo = null;
	Hashtable filterInfoHash = null;
	String filterBy = request.getParameter("filterBy");
	String searchFilter = request.getParameter("searchFilter");
	String nextSearch = request.getParameter("nextSearch");
	String priorityFilter = request.getParameter("priorityFilter");
	priorityFilter = (priorityFilter==null || priorityFilter.trim().length()==0||priorityFilter.equalsIgnoreCase("NULL"))?"All":priorityFilter;
	String searchFilDispTxt = request.getParameter("searchFilDispTxt");
	String nextSearchFilDispTxt = request.getParameter("nextSearchFilDispTxt");
	Hashtable statesList = null;

	if(filterFlag != null && filterFlag.equals("true"))
	{
		filterInfo = new ArrayList();
		filterInfoHash =  new Hashtable();
		Hashtable InfoSession = (Hashtable)session.getAttribute("InfoSession");
		Hashtable InfoFilterSession = (Hashtable)session.getAttribute("InfoFilterSession");
		Hashtable geoLocMapInfos = (Hashtable)session.getAttribute("geoLocMapInfos");
		filterInfoHash.put("filterBy",filterBy);
		filterInfoHash.put("searchFilter",searchFilter);
		filterInfoHash.put("nextSearch",nextSearch);
		filterInfoHash.put("priorityFilter",priorityFilter);
		if(InfoSession == null)
			InfoSession = new Hashtable();
		filterInfoHash.put("InfoSession",InfoSession);
		if(InfoFilterSession == null)
			InfoFilterSession = new Hashtable();
		filterInfoHash.put("InfoFilterSession",InfoFilterSession);
		if(geoLocMapInfos == null)
			geoLocMapInfos = new Hashtable();
		filterInfoHash.put("geoLocMapInfos",geoLocMapInfos);

		List temp_listZone = user.getZones();
		ArrayList notZoneList = new ArrayList();
		if(temp_listZone != null && temp_listZone.size() > 0){
			for(int l=0;l<temp_listZone.size();l++){
				String zone1 = (String) temp_listZone.get(l);
				List temp_zoneComps = groupInfo.getAllComponentsUnderZone(zone1,true);
				if(temp_zoneComps != null && temp_zoneComps.size() > 0){
					for(int p=0;p<temp_zoneComps.size();p++){
						String compType = (String)temp_zoneComps.get(p);
						notZoneList.add(compType);
					}
				}
			}
		}
		filterInfoHash.put("notZoneList",notZoneList);
	}
	if(searchFrom!=null && !searchFrom.equals("") && searchFrom.equalsIgnoreCase("InsideEndUserDashboard"))
	{
		String searchStringData = request.getParameter("searchStringData");
		desktopUserName = searchStringData;
		searchString = searchStringData;
		if(infoResHash!=null && infoResHash.size()>0)
		{
			writeLog(" vmDashHelper {getAllUsersDesktopsForUED} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getAllUsersDesktopsForUED(searchString,tmp_priority,userType,vdiType,pageNo,infoResHash,searchFrom,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getAllUsersDesktopsForUED} Method call out ",isDebugEnabled,logFileSize);
		}
		else
		{
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getVmDesktopsForTheComponentForGenericEUD(searchStringData,tmp_priority,userType,vdiType,pageNo,searchFrom,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call out ",isDebugEnabled,logFileSize);
		}
	}
	else
	{
		if(infoResHash!=null && infoResHash.size()>0)
		{
			writeLog(" vmDashHelper {getAllUsersDesktopsForUED} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getAllUsersDesktopsForUED(searchString,tmp_priority,userType,vdiType,pageNo,infoResHash,null,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getAllUsersDesktopsForUED} Method call out ",isDebugEnabled,logFileSize);
		}
		else if(isEndUserOverview || isFromUEDSort)
		{
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getVmDesktopsForTheComponentForGenericEUD(null,tmp_priority,userType,vdiType,pageNo,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call out ",isDebugEnabled,logFileSize);
		}
		else
		{
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getVmDesktopsForTheComponentForGenericEUD(searchString,tmp_priority,userType,vdiType,pageNo,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call out ",isDebugEnabled,logFileSize);
		}
	}

	String adFilter = "";
	ArrayList adFilterKeys = new ArrayList();
	Hashtable userRelatedAd = new Hashtable();

	if(finalDesktopVmsHash!=null && finalDesktopVmsHash.size()>0)
	{
		vdiDesktopsList = (EgList)finalDesktopVmsHash.get("EgList");
		vdiDesktopsListTotalCount = (Integer)finalDesktopVmsHash.get("EgListCount");
		statesList = (Hashtable)finalDesktopVmsHash.get("statesList");
		infosCompHash = (Hashtable)finalDesktopVmsHash.get("INFOS_COMP");
		Hashtable tmp_CTHash = (Hashtable)finalDesktopVmsHash.get("TYPE_COMP_INFO");
		typeCompInfoHash = tmp_CTHash;
		infolist = (ArrayList)finalDesktopVmsHash.get("INFOS");
		dbinfolist = (ArrayList)finalDesktopVmsHash.get("DBINFOS");

		resTypeList = (List)finalDesktopVmsHash.get("CTYPE");
		componentTypeList = resTypeList;
		resCnameList = (List)finalDesktopVmsHash.get("CNAME");
		resCompsList = (List)finalDesktopVmsHash.get("COMPS");
		resNickList = (List)finalDesktopVmsHash.get("NICKS");
		resPortList = (List)finalDesktopVmsHash.get("PORTS");

		fullInfoHash = (Hashtable)finalDesktopVmsHash.get("FULLINFOS");
		maxUser = (String)finalDesktopVmsHash.get("MAX_USER");
		user_count_hash = (Hashtable)finalDesktopVmsHash.get("MAX_USER_HASH");

		if(finalDesktopVmsHash.containsKey("adFilter"))
			adFilter = (String)finalDesktopVmsHash.get("adFilter");
		if(finalDesktopVmsHash.containsKey("adFilterKeys"))
			adFilterKeys = (ArrayList)finalDesktopVmsHash.get("adFilterKeys");
		if(finalDesktopVmsHash.containsKey("userRelatedAd"))
			userRelatedAd = (Hashtable)finalDesktopVmsHash.get("userRelatedAd");
		if(finalDesktopVmsHash.containsKey("groupByUserKeys"))
			groupByUserKeys = (ArrayList)finalDesktopVmsHash.get("groupByUserKeys");
		if(groupByUserKeys==null||groupByUserKeys.size()==0)
			isEndUserOverview = false;
	}

	String inner_header="";
	String header_display="";
	String header_display_icon="";
	String is_Header_DispName=ini.getValue("END_USER_DASHBOARD_SETTINGS","ShowUserCountInUI");
	String skipDesktopsForVDI = ini.getValue("END_USER_DASHBOARD_SETTINGS","SkipDesktopsForVDI");
	if(is_Header_DispName!=null && (is_Header_DispName.equalsIgnoreCase("true") || is_Header_DispName.equalsIgnoreCase("yes")))
	{
		if(!isEndUserOverview && vdiDesktopsListTotalCount>0)
		{
			//header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" (Total users: "+vdiDesktopsListTotalCount+")");
			if(userType!=null && userType.equals("ESX"))
			{
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Performance Metrics for VMs (Total VMs : "+vdiDesktopsListTotalCount+")");
			}
			else if(userType!=null && userType.equalsIgnoreCase("VDI"))
			{
				String countHeader = (skipDesktopsForVDI!=null && skipDesktopsForVDI.equalsIgnoreCase("true"))?"Unique Users":"Unique Users/Desktops";
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
			}
			else
			{
				String countHeader = "Unique Users";
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
			}
			jsonRoot.put("header_display",header_display);

			if(priorityFilter==null || priorityFilter.trim().length()==0 || priorityFilter.equalsIgnoreCase("NULL"))
			{
				jsonRoot.put("isShowLocColumn",isShowUserLocation);
			}
		}
		else if(isEndUserOverview)
		{
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By Location for")+" "+userType;
			jsonRoot.put("header_display",header_display);
		}
	}
	else
	{
		if(!isEndUserOverview )
		{
			if(userType!=null && userType.equals("ESX"))
			{
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Performance Metrics for VMs");
			}
			else
			{
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
			}
			jsonRoot.put("header_display",header_display);

			if(vdiDesktopsListTotalCount==0 || priorityFilter==null || priorityFilter.trim().length()==0 || priorityFilter.equalsIgnoreCase("NULL"))
			{
				jsonRoot.put("isShowLocColumn",isShowUserLocation);
			}
		}
		else if(isEndUserOverview)
		{
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By Location for")+" "+userType;
			jsonRoot.put("header_display",header_display);
		}
	}

	if(vdiType != null && vdiType.indexOf(":") != -1)
		vdiType = vdiType.substring(0,vdiType.indexOf(":"));
	
	Hashtable TotalMeasureInfo = new Hashtable();
	session.removeAttribute("InfoSession");
	session.removeAttribute("InfoFilterSession");
	JSONArray fil = new JSONArray();
	//TotalMeasureInfo = vmDashHelper.getAllDesktopVmsMeasureData(finalDesktopVmsHash);
	if(searchFrom==null || searchFrom.trim().length()==0)
	{
		if(dataResHash!=null && dataResHash.size()>0 && ((vdiDesktopsList!=null && vdiDesktopsList.size()>0 && vdiDesktopsListTotalCount>0)||(groupByUserKeys!=null && groupByUserKeys.size()>0)))
		{
			TotalMeasureInfo=(Hashtable)dataResHash.clone();
		}
		else if((vdiDesktopsList!=null && vdiDesktopsList.size()>0 && vdiDesktopsListTotalCount>0)||(groupByUserKeys!=null && groupByUserKeys.size()>0))
		{
			//TotalMeasureInfo = vmDashHelper.getAllDesktopVmsMeasureDataForGenericEUD(finalDesktopVmsHash,userType);
			TotalMeasureInfo = vmDashHelper.getAllDesktopVmsMeasureDataForGenericEUD(finalDesktopVmsHash,userType,userName);
		}
		if(TotalMeasureInfo != null && TotalMeasureInfo.containsKey("InfoSession") && TotalMeasureInfo.containsKey("InfoFilterSession")){
			Hashtable geoMapInfo = (Hashtable)TotalMeasureInfo.get("InfoSession");
			Hashtable InfoFilterSession = (Hashtable)TotalMeasureInfo.get("InfoFilterSession");
			Hashtable geoLocMapInfos = (Hashtable)TotalMeasureInfo.get("geoLocMapInfos");

			TotalMeasureInfo.remove("InfoSession");
			TotalMeasureInfo.remove("InfoFilterSession");
			TotalMeasureInfo.remove("geoLocMapInfos");
			//TotalMeasureInfo.remove("statesList");

			if(geoMapInfo != null && geoMapInfo.size() > 0)
			{
				Iterator it = geoMapInfo.entrySet().iterator();
				while(it.hasNext()){
					Entry en = (Entry)it.next();
					Set set = (HashSet)en.getValue();
					ArrayList list = new ArrayList(set);
					if(list != null && list.size() > 0)
						fil.add((String)en.getKey());
				}
				session.setAttribute("InfoSession",geoMapInfo);
				session.setAttribute("tmpInfoSession",geoMapInfo);
				session.setAttribute("geoLocMapInfos",geoLocMapInfos);
				session.setAttribute("statesList",statesList);
			}
			if(InfoFilterSession != null && InfoFilterSession.size() > 0)
				session.setAttribute("InfoFilterSession",InfoFilterSession);
		}
		if(TotalMeasureInfo!=null && TotalMeasureInfo.containsKey("finalGroupByUserTab"))
		{
			finalGroupByUserTab = (Hashtable) TotalMeasureInfo.get("finalGroupByUserTab");
		}
		if(orderByColumnName!=null && orderByColumnName.trim().length()>0 && !orderByColumnName.equalsIgnoreCase("null"))
		{
			if(col_Type!=null && col_Type.trim().length()>0 && (!col_Type.equalsIgnoreCase("NULL")))
			{
				if(isFromUEDSort)
				{
					groupByUserKeys = (ArrayList)vmDashHelper.getSortedListForUEDOverview(groupByUserKeys,TotalMeasureInfo,"enduseroverview",orderByColumnName,orderBy,col_Type);
				}
				else
				{
					vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,TotalMeasureInfo,"virtual",orderByColumnName,orderBy,col_Type);
				}
			}
			else
			{
				if(orderByColumnName.equalsIgnoreCase("HOST"))
				{
					vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,orderByColumnName,null,orderBy);
				}
				else
				{
					vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,TotalMeasureInfo,"virtual",orderByColumnName,orderBy);
				}
			}
			if(priority!=null && !priority.equalsIgnoreCase("ALL"))
			{
				vdiDesktopsList = vmDashHelper.getSubList(vdiDesktopsList,priority,pageNo);
			}
		}
		else if(isUDSortByAllValue)
		{
			vdiDesktopsList=vmDashHelper.getAllMeasureValueBasedSortedList(vdiDesktopsList,TotalMeasureInfo,userType,strMValueOrder);
			if(priority!=null && !priority.equalsIgnoreCase("ALL"))
			{
				vdiDesktopsList = vmDashHelper.getSubList(vdiDesktopsList,priority,pageNo);
			}
		}
	}
	if(groupByUserKeys!=null && groupByUserKeys.size()>0)
		groupByUserCount = groupByUserKeys.size();

	if(desktopUserName!=null && !desktopUserName.equalsIgnoreCase("") && desktopUserName.length()>0 && vdiDesktopsList.size()>0)
	{
		EgService tempServ = (EgService)vdiDesktopsList.get(0);
		String tempDesktopComponent = tempServ.getName();
		String tempDesktopState = tempServ.getState().getName();
		String tempDesktopName = "";
		String tempComp = "";
		String tempCompValue = "";
		String tempCompName = "";
		String tempCompNameWithOutPort = "";

		if(tempDesktopComponent!=null && tempDesktopComponent.indexOf("^")>-1){
			tempDesktopName = tempDesktopComponent.substring(0,tempDesktopComponent.indexOf("^"));
			tempComp = tempDesktopComponent.substring(tempDesktopComponent.indexOf("^")+1);
		}

		if(tempComp!=null && tempComp.indexOf(":")>-1){
			tempCompValue = tempComp.substring(0,tempComp.indexOf(":"));
			tempCompName = tempComp.substring(tempComp.indexOf(":")+1);
		}

		if(tempCompName!=null && tempCompName.indexOf(":")>-1){
			tempCompNameWithOutPort = tempCompName.substring(0,tempCompName.indexOf(":"));
		}

		String tempMsmtHost = "";
		String ctype_layer=ini.getValue("USER_DESKTOP_LAYERS",tempCompValue);
		ctype_layer=(ctype_layer==null || ctype_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_layer;
		ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer);
		if(arr!=null && arr.size()>0)
		{
			boolean flag=true;
			for (int t=0;t<arr.size();t++)
			{
				String insideviewTest=(String) arr.get(t);
				if(insideviewTest!=null && insideviewTest.trim().length()>0)
				{
					List tempAgents=egExternalInfo.getAgentsFor(insideviewTest.trim(),tempCompValue,tempCompNameWithOutPort);

					if(tempAgents!=null && tempAgents.size()>0)
					{
						tempMsmtHost=(String)tempAgents.get(0);
						flag=false;
						break;
					}
				}
			}

			if(flag)
				tempMsmtHost=tempCompNameWithOutPort;
		}
		else
			tempMsmtHost=tempCompNameWithOutPort;

		String temp_url_desktopName=com.egurkha.util.StringUtils.replace(tempDesktopName, "\\", "\\");

		String url = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+tempCompName+"&comptype="+tempCompValue+"&info=*"+temp_url_desktopName+"&compName="+tempCompName+":"+tempCompValue+"&componentName="+tempCompNameWithOutPort+"&msmt_host="+tempMsmtHost+"&user="+userName+"&searchString="+searchString+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType+"&enableBackButton="+enableBackButton+"&directEndDetail=true";

		if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
		{
			url=url+"&fromMenu="+fromMenuStr;
		}
		if(filterBy!=null && filterBy.trim().length()>0)
		{
			url=url+"&filterBy="+filterBy;
		}
		if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
		{
			url=url+"&priorityFilter="+priorityFilter;
		}
		jsonRoot.put("REDIRECT",true);
		jsonRoot.put("REDIRECT_URL",url);
	}
	else if(desktopUserName!=null && desktopUserName.trim().length()>0 && (vdiDesktopsList==null || vdiDesktopsList.size()==0))
	{
		String url = "/final/monitor/endUserDashboardDetailsData.jsp?comp=&comptype=&info=*"+desktopUserName+"&compName=&componentName=&msmt_host=&user="+userName+"&searchString="+searchString+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType+"&enableBackButton="+enableBackButton+"&directEndDetail=true";

		if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
		{
			url=url+"&fromMenu="+fromMenuStr;
		}
		
		if(filterBy!=null && filterBy.trim().length()>0)
		{
			url=url+"&filterBy="+filterBy;
		}
		if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
		{
			url=url+"&priorityFilter="+priorityFilter;
		}
		jsonRoot.put("REDIRECT",true);
		jsonRoot.put("REDIRECT_URL",url);
	}
	else if(TotalMeasureInfo!=null && TotalMeasureInfo.size()>0)
	{
		if(adFilter != null && aduserFilter != null)
		{
			buf.append("<egui:skin ui=\"monitor\"/>");
			buf.append("<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"  height=\"auto\">");
				buf.append("<tr>");
					buf.append("<td width=\"100%\" valign=\"top\" height=\"100%\">");
						buf.append("<div class=\"uxTable\">");
							buf.append("<table class=\"x-grid-table x-grid-table-resizer uxTableOuter\" style=\"width:100%;table-layout:auto !important\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"  valign=\"top\" >");
								buf.append("<thead>");
									buf.append("<tr class=\"x-grid-row  x-grid-row-alt\" >");
									if(!orderByCol_flag)
									{
										//buf.append("<td align=\"center\"  wrap onclick=\"javascript:sortByMeasure('','"+orderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  style=\"padding:3px;width:240px\"><table class=\"uxInnerTable\"><tr><td>"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+"</td><td><div class='uxSortTop'> <img id=\"sortImg\" src=\"/final/images/Dark/grid_sort_top.png\"/></div></td></tr></table> </td>");

										buf.append("<td align=\"left\"  wrap onclick=\"javascript:sortByMeasure('','"+orderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  style=\"padding:6px 3px 3px 10px !important;width:240px;\"><table class=\"uxInnerTable\"><tr><td>"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+"</td></tr></table> </td>");
									}
									else
									{
										buf.append("<td align=\"left\"  wrap onclick=\"javascript:sortByMeasure('','"+orderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  style=\"padding:6px 3px 3px 10px !important;width:240px\">"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+ "</td>");
									}

									if(orderByColumnName!=null && orderByColumnName.equalsIgnoreCase("Host"))
									{
										String nextOrderBy="desc";
										String sortImgurl="/final/images/Dark/grid_sort_top.png";

										if(orderBy!=null && orderBy.equals("desc"))
										{
											nextOrderBy="asc";
											sortImgurl="/final/images/Dark/grid_sort_down.png";
										}
										else if(orderBy!=null && orderBy.equals("asc"))
										{
											nextOrderBy="desc";
											sortImgurl="/final/images/Dark/grid_sort_top.png";
										}

										buf.append("<td align=\"left\"  wrap onclick=\"javascript:sortByMeasure('Host','"+nextOrderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  style=\"padding:6px 3px 3px 10px !important;width:180px\"><table class=\"uxInnerTable\"><tr><td>"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Host")+"</td><td><div class='uxSortTop'> <img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
									else
									{
										buf.append("<td align=\"left\"  wrap onclick=\"javascript:sortByMeasure('Host','"+orderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  style=\"padding:6px 3px 3px 10px !important;width:180px\">"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Host")+ "</td>");
									}
			String widthOfTheHead="";
			String strVdiHostCombo=ini.getValue("END_USER_DASHBOARD_SETTINGS","showVdiHostCombo");
			strVdiHostCombo=(strVdiHostCombo==null || strVdiHostCombo.trim().length()==0)?"false":strVdiHostCombo;

			boolean showVdiHostCombo = "true".equalsIgnoreCase(strVdiHostCombo)?true:false;
			boolean isSkipVal = false;
			ArrayList skippedColumns = new ArrayList();
			String measures=null;
			String measuresD=null;
			String measuresT=null;
			if(userName!=null && userName.trim().length()>0)
			{
				measures = ini.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
			}
		
			if(measures==null || measures.trim().length()==0)
			{
				measuresD = ini.getValue("USER_DESKTOP_METRICS","DEFAULT_"+userType);
				measuresT = ini.getValue("USER_DESKTOP_METRICS",userType);
				if(measuresD != null && measuresD.trim().length() > 0)
				{
					measures = measuresD;
				}
				else
				{
					measures = measuresT;
				}
			}
			String[] measureArray = measures.split(",");
			ArrayList displayColsList = new ArrayList();
			ArrayList validColsList = new ArrayList();
			Hashtable sameLabelHash = new Hashtable();
			measuresCount = measureArray.length;
			int colCount=measuresCount+2;
			/*String cellWidth="180px";
			try
			{
				if(colCount>0 && colCount<=3)
				{
					cellWidth="400px";
				}
				else if(colCount>3 && colCount<=5)
				{
					cellWidth="370px";
				}
				else if(colCount==6)
				{
					cellWidth="330px";
				}
				else if(colCount==7)
				{
					cellWidth="280px";
				}
				else if(colCount==8)
				{
					cellWidth="240px";
				}
				else if(colCount>8 && colCount<=11)
				{
					cellWidth="200px";
				}
				else
				{
					cellWidth="190px";
				}
			}
			catch(Exception e)
			{
				cellWidth="180px";
			}*/

			for(int x=0;x<measureArray.length;x++)
			{
				String tempValue = measureArray[x];
				String tempTest = "";
				String tempMeasure = "";
				String tempDispName = "";
				String tempLocColName = "";
				String locKeyName = "";
				String colName = "";
				ArrayList locColumnsList = null;
				StringTokenizer valTokens = new StringTokenizer(tempValue,":");
				int count = valTokens.countTokens();
				boolean isDDDColumn = false;
				boolean isLocColumn = false;
				boolean isTestColumn = false;
				String meas ="";
				if (valTokens.hasMoreTokens())
				{
					if(count==3)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isTestColumn=true;
					}
					else if(count==2)
					{
						if(isShowUserLocation)
						{
							tempTest = valTokens.nextToken();
							tempMeasure = valTokens.nextToken();
							//tempDispName = mappingInfo.getMeasureDescription(tempTest,tempMeasure);
							isLocColumn = true;
							meas = "NONE";

							ArrayList tmpMeasureList = new ArrayList(); 
							tmpMeasureList = StringUtils.egTokenizer(tempMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
							if(tmpMeasureList!=null && tmpMeasureList.size()>0)
							{
								int meaListSize=tmpMeasureList.size();
								if(meaListSize==1)
								{
									tempDispName = tempMeasure;
									tempLocColName = tempMeasure;
								}
								else if(meaListSize>1)
								{
									tempLocColName = (String)tmpMeasureList.get(0);
									tempDispName = (String)tmpMeasureList.get(1);
								}
							}
						}
					}
					else if(count==5)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						colName = valTokens.nextToken();
						meas = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isDDDColumn = true;
					}
				}

				if(isTestColumn || isDDDColumn || isLocColumn)
				{
					if(displayColsList!=null && displayColsList.contains(tempDispName))
					{
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}

						continue;
					}

					String unitForMeasure="";
					String meaUnit="";
					if(isDDDColumn && meas!=null && meas.trim().length()>0 && (!meas.equalsIgnoreCase("NONE")&&!meas.equalsIgnoreCase("DATE")))
					{
						unitForMeasure = "("+meas+")";
					}
					else if(!isDDDColumn && !isLocColumn)
					{
						String unitVal=tablesInfo.getUnitForMeasure(tempTest,tempMeasure.trim());

						if(unitVal!=null && unitVal.trim().length()>0)
						{
							unitForMeasure="&nbsp;("+unitVal+")";

							meaUnit=unitVal;
						}
					}

					if(unitForMeasure!=null && unitForMeasure.indexOf("MB")>-1)
						unitForMeasure ="&nbsp;(GB)";

					if(tempDispName!=null && tempDispName.equalsIgnoreCase("Status"))
					{
						unitForMeasure="";
					}
					else if(tempDispName!=null && (tempDispName.equalsIgnoreCase("Disk Used") || tempDispName.equalsIgnoreCase("Used Space")))
					{
						unitForMeasure="("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
					}

					String orderByColumn = "";
					if(isLocColumn)
					{
						//orderByColumn = tempDispName;
						orderByColumn = tempLocColName;
						//orderByColumnName = tempDispName;
					}
					else if (isDDDColumn)
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest+"_DDD",colName);
					}
					else
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure); 
					}

					if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(tempTest+":"+tempMeasure))
					{
						unitForMeasure="";
					}

					if(orderByColumn!=null && orderByColumn.trim().length()>0 && orderByColumnName!=null && orderByColumnName.trim().length()>0 && orderByColumnName.equalsIgnoreCase(orderByColumn))
					{
						String nextOrderBy="desc";
						//String sortImgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
						String sortImgurl="/final/images/Dark/grid_sort_top.png";
						
						if(orderBy!=null && orderBy.equals("desc"))
						{
							nextOrderBy="asc";
							//sortImgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
							sortImgurl="/final/images/Dark/grid_sort_down.png";
						}
						else if(orderBy!=null && orderBy.equals("asc"))
						{
							nextOrderBy="desc";
							sortImgurl="/final/images/Dark/grid_sort_top.png";
						}

						if(isDDDColumn || isLocColumn)
						{
							if(isLocColumn)
							{
								if((unitForMeasure==null || unitForMeasure.equals(""))&& (meas!=null && !meas.equalsIgnoreCase("DATE")))
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+nextOrderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
								else
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+nextOrderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
							}
							else
							{
								if((unitForMeasure==null || unitForMeasure.equals(""))&& (meas!=null && !meas.equalsIgnoreCase("DATE")))
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
								else
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
							}
						}
						else
						{
							if(meaUnit!=null && (meaUnit.trim().equals("%") || meaUnit.trim().equalsIgnoreCase("percent") || meaUnit.trim().equalsIgnoreCase("percentage")))
							{
								if(unitForMeasure==null || unitForMeasure.equals(""))
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn\" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
								else
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div  class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
							}
							else
							{
								if(tempDispName!=null && tempDispName.length()<13)
								{
									if(unitForMeasure==null || unitForMeasure.equals(""))
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:100px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
									else
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:100px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div  class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
								}
								else
								{
									if(unitForMeasure==null || unitForMeasure.equals(""))
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:130px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
									else
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:130px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div  class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
								}
							}
						}
					}
					else
					{
						if(isDDDColumn || isLocColumn)
						{
							if(isLocColumn)
							{
								if((unitForMeasure==null || unitForMeasure.equals("")) && (meas!=null && !meas.equalsIgnoreCase("DATE")))
								{
											buf.append("<td align=\"left\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+orderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\">"+tempDispName+" </td>");
								}
								else
								{
											buf.append("<td align=\"left\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+orderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\">"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
								}
							}
							else
							{
								if((unitForMeasure==null || unitForMeasure.equals("")) && (meas!=null && !meas.equalsIgnoreCase("DATE")))
								{
											buf.append("<td align=\"left\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\">"+tempDispName+" </td>");
								}
								else
								{
											buf.append("<td align=\"left\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn\" style=\"padding:6px 3px 3px 10px !important;width:140px\">"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
								}
							}
						}
						else
						{
							if(meaUnit!=null && (meaUnit.trim().equals("%") || meaUnit.trim().equalsIgnoreCase("percent") || meaUnit.trim().equalsIgnoreCase("percentage")))
							{
								if(unitForMeasure==null || unitForMeasure.equals(""))
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn\" style=\"padding:3px;width:140px\">"+tempDispName+" </td>");
								}
								else
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\">"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
								}
							}
							else
							{
								if(tempDispName!=null && tempDispName.length()<13)
								{
									if(unitForMeasure==null || unitForMeasure.equals(""))
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:100px\"> "+tempDispName+" </td>");
									}
									else
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:100px\"> "+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
									}
								}
								else
								{
									if(unitForMeasure==null || unitForMeasure.equals(""))
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:130px\"> "+tempDispName+" </td>");
									}
									else
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:130px\"> "+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
									}
								}
							}
						}
					}
					if(displayColsList!=null && tempDispName!=null && !displayColsList.contains(tempDispName))
					{
						displayColsList.add(tempDispName);
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
					}
					if(validColsList!=null && tempValue!=null && !validColsList.contains(tempValue)) 
						validColsList.add(tempValue);
				}
			}

			if(validColsList!=null && validColsList.size()>0)
			{
				measureArray = new String[validColsList.size()];
				int yy=0;
				for(int y=0;y<validColsList.size();y++)
				{
					String tempValue1 = (String)validColsList.get(y);
					if(tempValue1!=null && tempValue1.trim().length()>0)
					{
						measureArray[yy++]=tempValue1;
					}
				}
			}
								buf.append("</tr>");
							buf.append("</thead>");
							buf.append("<tbody>");
			EgService serv = null;
			int desktopsSize = (vdiDesktopsList!=null && vdiDesktopsList.size()>0)?vdiDesktopsList.size():0;
			Hashtable desktopHtml = new Hashtable();
			ArrayList deskTopList = new ArrayList();
			int deskColWidth=-1;
			int hostColWidth=-1;
			int continueCount = 0;
			for(int i=0;i<desktopsSize;i++)
			{
				StringBuffer bufRow = new StringBuffer();
				serv = (EgService)vdiDesktopsList.get(i);
				String trBackground = "eg_lightlight";
				if(i%2==0)
					trBackground = "eg_whitebg";

				String desktopComponent = serv.getName();
				String desktopState = serv.getState().getName();
				String desktopName = "";
				String comp = "";
				String compValue = "";
				String compName = "";
				String compNameWithOutPort = "";
				
				if(desktopComponent!=null && desktopComponent.indexOf("^")>-1)
				{
					desktopName = desktopComponent.substring(0,desktopComponent.indexOf("^"));
					comp = desktopComponent.substring(desktopComponent.indexOf("^")+1);
				}
				deskTopList.add(desktopName);
				if(comp!=null && comp.indexOf(":")>-1)
				{
					compValue = comp.substring(0,comp.indexOf(":"));
					compName = comp.substring(comp.indexOf(":")+1);
				}
				if(compName!=null && compName.indexOf(":")>-1)
				{
					compNameWithOutPort = compName.substring(0,compName.indexOf(":"));
				}
				measureValues = (Hashtable)TotalMeasureInfo.get(comp);
				String msmtHost = "";
				String ctype_layer=ini.getValue("USER_DESKTOP_LAYERS",compValue);
				ctype_layer=(ctype_layer==null || ctype_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_layer;
				ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer);
				if(arr!=null && arr.size()>0)
				{
					boolean flag=true;
					for (int t=0;t<arr.size();t++)
					{
						String insideviewTest=(String) arr.get(t);
						if(insideviewTest!=null && insideviewTest.trim().length()>0)
						{
							List agents=egExternalInfo.getAgentsFor(insideviewTest.trim(),compValue,compNameWithOutPort);

							if(agents!=null && agents.size()>0)
							{
								msmtHost=(String)agents.get(0);
								flag=false;
								break;
							}
						}
					}

					if(flag)
						msmtHost=compNameWithOutPort;
				}
				else
					msmtHost=compNameWithOutPort;

				String tempHostType = compValue;
				String url_desktopName=com.egurkha.util.StringUtils.replace(desktopName, "\\", "\\");
				String url = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compValue+"&info=*"+EgURLEncoder.encode(url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(compName+":"+compValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(compNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType;

				if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
				{
					url=url+"&fromMenu="+fromMenuStr;
				}

				if(filterBy!=null && filterBy.trim().length()>0)
				{
					url=url+"&filterBy="+filterBy;
				}
				if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
				{
					url=url+"&priorityFilter="+priorityFilter;
				}

				String link ="";
				if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0)
				{
					link = "/final/servlet/com.eg.EgDashboardController?site=NULL"+"&from=list&comptype="+EgURLEncoder.encode(compValue,"UTF-8")+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=LayerModel";
				}
				else
				{
					link = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compValue+"&info=*"+EgURLEncoder.encode(url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(compName+":"+compValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(compNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType;
				}
				if(filterBy!=null && filterBy.trim().length()>0)
				{
					link=link+"&filterBy="+filterBy;
				}
				if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
				{
					link=link+"&priorityFilter="+priorityFilter;
				}
				String disp_desktopName=desktopName;
				//if(disp_desktopName!=null && disp_desktopName.length()>30)
					//disp_desktopName=disp_desktopName.substring(0,30)+"..";

				String strName = compName;
				if (strName.endsWith(EgConstants.NULL_PORT) && (strName.indexOf(EgConstants.NULL_PORT) > -1))
				{
					strName = Server.getServerNameWithoutPort(strName, false);
				}

				String disp_StrName = strName;

				String imgPadding="";

				if (browserType.indexOf("Chrome")>-1)
				{
					imgPadding="padding:2px 6px 5px 5px";
				}
				else
				{
					imgPadding="padding:2px 6px 2px 5px";
				}

				if(disp_StrName!=null && disp_StrName.length()>22)
					disp_StrName=disp_StrName.substring(0,22)+"..";

									bufRow.append("<tr class=\"x-grid-row  x-grid-row-alt\" style=\"background:none\">");
										bufRow.append("<td style=\"border:none\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  nowrap width=\"10%\">");
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\" borderColor=\"red\">");
												bufRow.append("<tr style=\"background:none !important\">");
													bufRow.append("<td style=\"padding-left:3px\">");

														bufRow.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/images/spacer.gif\" class=\"eud_"+desktopState+"\"></div>");

				int tmp_deskCol_Len=0;
				if(desktopName!=null && desktopName.length()>0)
				{
					tmp_deskCol_Len=desktopName.length();
				}
				if(tmp_deskCol_Len>deskColWidth)
					deskColWidth=tmp_deskCol_Len;
				
				String deskCellWidth="150px";
				if(deskColWidth>15 && deskColWidth<30)
				{
					deskCellWidth="190px";
				}
				else if(deskColWidth>=30)
				{
					deskCellWidth="240px";
				}
				
				int tmp_hostColWidth=0;
				if(strName!=null && strName.length()>0)
				{
					tmp_hostColWidth=strName.length();
				}
				if(tmp_hostColWidth>hostColWidth)
					hostColWidth=tmp_hostColWidth;

				String hostCellWidth="100px";
				if(hostColWidth>15 && hostColWidth<40)
				{
					hostCellWidth="150px";
				}
				else if(hostColWidth>=40)
				{
					hostCellWidth="200px";
				}

													bufRow.append("</td>");
													bufRow.append("<td nowrap>");
														bufRow.append("<div style=\"font-size:11px;float:left;position:relative;visibility:visible;text-align:left;width:"+deskCellWidth+";\"><a class=\"eg_monlink\" href=\"javascript:void(0);\" onClick=\"javascript:goToDetails('"+url+"');\" data-qtip=\""+desktopName+"\" data-qclass=\"yellowTip\" ><div style=\"padding-top:4px;width:200px;text-align:left;overflow:hidden;text-overflow:ellipsis;\">"+disp_desktopName+"</div></a> </div>");
													bufRow.append("</td>");
												bufRow.append("</tr>");
											bufRow.append("</table>");
										bufRow.append("</td>");
										bufRow.append("<td style=\"border:none;padding-left:8px;\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  nowrap width=\"10%\">");
											bufRow.append("<div style=\"float:left;position:relative;visibility:visible;text-align:left;width:"+hostCellWidth+";\"><a class=\"mouse\" href=\"javascript:void(0);\" onClick=\"javascript:goToDetails('"+link+"');\" data-qtip=\""+strName+"\" data-qclass=\"yellowTip\" ><div style=\"padding-top:4px;width:160px;text-align:left;overflow:hidden;text-overflow:ellipsis;\">"+disp_StrName+"</div></a> </div>");
										bufRow.append("</td>");

				measureList = Arrays.asList(measureArray);
				if(measureValues!=null && measureValues.size()>0)
				{
					String ctype_out_layer=ui.getValue("Layer_for_ComponentType",compValue);
					ctype_out_layer=(ctype_out_layer==null || ctype_out_layer.trim().length()==0)?"VIRTUAL_GUESTS":ctype_out_layer;
					ArrayList listOfTest=(ArrayList)tablesInfo.getTestsForLayer(ctype_out_layer,compValue);

					int p=0;
					String info_to_lower=desktopName;
					while(p<measureList.size())
					{
						String keyForList=(String)measureList.get(p);
						String keyMeasure="";
						String keyOrgMeasure="";
						String keyTest="";
						String keydisplayMeasure="";
						StringTokenizer valTokens = new StringTokenizer(keyForList,":");
						int tokCount = valTokens.countTokens();
						boolean isDDDTestColumn = false;
						boolean isLocationColumn = false;

						if(tokCount==5)
							isDDDTestColumn = true;
						else if(tokCount==2)
							isLocationColumn = true;

						String orgColName = "";
						String funcName = "";
						String dispName = "";
						String tempDispName = "";
						String locKeyName = "";
						String Value="";
						String units="";
						
						ArrayList keyMeasureList = null; 
						ArrayList locMeasuresList = new ArrayList(); 
						
						if(isDDDTestColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
									if(orgColName!=null && orgColName.indexOf(":")>-1)
									{
										funcName=orgColName.substring(orgColName.indexOf(":")+1);
										orgColName = orgColName.substring(0,orgColName.indexOf(":"));

										if(funcName!=null && funcName.indexOf(":")>-1)
										{
											dispName=funcName.substring(funcName.indexOf(":")+1);
											funcName = funcName.substring(0,funcName.indexOf(":"));
										}
									}
								}
							}

							if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && !listOfTest.contains(keyTest) && dispName!=null)
							{
								ArrayList tmpArry=(ArrayList)sameLabelHash.get(dispName);
								if(tmpArry!=null && tmpArry.size()>0)
								{
									for(int kk=0;kk<tmpArry.size();kk++)
									{
										keyForList =(String)tmpArry.get(kk);

										if(keyForList!=null && keyForList.indexOf(":")>-1)
										{
											keyTest=keyForList.substring(0,keyForList.indexOf(":"));
											keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
											if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
											{
												orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
												keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
												if(orgColName!=null && orgColName.indexOf(":")>-1)
												{
													funcName=orgColName.substring(orgColName.indexOf(":")+1);
													orgColName = orgColName.substring(0,orgColName.indexOf(":"));

													if(funcName!=null && funcName.indexOf(":")>-1)
													{
														dispName=funcName.substring(funcName.indexOf(":")+1);
														funcName = funcName.substring(0,funcName.indexOf(":"));
													}
												}
											}
										}

										if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && listOfTest.contains(keyTest))
										{
											break;
										}
									}
								}
							}

							String colKeyName = Dbdata.getColumnForMeasure(keyTest+"_DDD",orgColName);
							String tmpK = colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort;
							Value=(String)measureValues.get(colKeyName+"^"+info_to_lower+"^"+compNameWithOutPort);
							if(Value==null)
							{
								Value=(String)measureValues.get(colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
							}
						}
						else if(isShowUserLocation && isLocationColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest = keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure = keyForList.substring(keyForList.indexOf(":")+1);
							}

							funcName ="NONE";

							if(keyMeasure!=null && keyMeasure.trim().length()>0)
							{
								keyMeasureList = StringUtils.egTokenizer(keyMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(keyMeasureList!=null && keyMeasureList.size()>0)
								{
									int meaListSize=keyMeasureList.size();
									if(meaListSize==1)
									{
										locKeyName = (String)keyMeasureList.get(0);
									}
									else if(meaListSize>1)
									{
										locKeyName = (String)keyMeasureList.get(0);
									}

									Value=(String)measureValues.get(locKeyName+"^"+info_to_lower+"^"+compNameWithOutPort);

									if(Value==null)
									{
										Value=(String)measureValues.get(locKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
									}

									if(meaListSize==1 && strSeparator!=null && strSeparator.trim().length()>0 && strReplaceSep!=null && strReplaceSep.trim().length()>0 && Value!=null && !Value.equals("-"))
									{
										Value = com.egurkha.util.StringUtils.replace(Value,strSeparator,strReplaceSep);
									}
								}
							}
						}
						else
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									keydisplayMeasure=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure=keyMeasure.substring(0,keyMeasure.indexOf(":"));
								}
							}
							units=tablesInfo.getUnitForMeasure(keyTest,keyMeasure);
							keyOrgMeasure = keyMeasure;
							keyMeasure = Dbdata.getColumnForMeasure(keyTest,keyMeasure);
							if(specsInfo.isTestRelevantForServer(compValue,keyTest))
							{
								Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
								if(Value==null){
									Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
								}
							}
						}

						//if((Value==null || Value.trim().length()==0) && compValue!=null && compValue.equals("Xen_desktop_server"))
						if(Value==null || Value.trim().length()==0)
						{
							if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
							{
								ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(tokenList!=null && tokenList.size()==2)
								{
									info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
								}
							}
							Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
							if(Value==null)
							{
								Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
							}
						}
						
						String mes_state="";
						String mes_name="";
						String total_spc="0";

						if(Value!=null && Value.indexOf("^")>-1)
						{
							mes_state=Value.substring(Value.indexOf("^")+1);
							if(mes_state!=null && mes_state.indexOf("^")>-1)
							{
								mes_name=mes_state.substring(mes_state.indexOf("^")+1);
								mes_state=mes_state.substring(0,mes_state.indexOf("^"));
								if(mes_name!=null && mes_name.indexOf("^")>-1)
								{
									total_spc=mes_name.substring(mes_name.indexOf("^")+1);
									mes_name=mes_name.substring(0,mes_name.indexOf("^"));
								}
							}
							Value=Value.substring(0,Value.indexOf("^"));
						}
						else if(Value==null)
						{
							Value="-";
							mes_name=keyMeasure;
							mes_state="GOOD";
						}

						boolean sameLabelFlag=false;
						if(sameLabelHash!=null && sameLabelHash.size()>0 && keydisplayMeasure!=null && sameLabelHash.containsKey(keydisplayMeasure))
						{
							ArrayList tmpArry=(ArrayList)sameLabelHash.get(keydisplayMeasure);
							if(tmpArry!=null && tmpArry.size()>0 && keyForList!=null && tmpArry.contains(keyForList))
								tmpArry.remove(keyForList);

							if(tmpArry!=null && tmpArry.size()>0)
							{
								sameLabelFlag=true;
								if(!dashboardModel.isTestActive(compValue, compName, keyTest, "custom"))
									Value="-";
							}
						}

						if((Value==null || Value.equals("-")) && sameLabelFlag && (sameLabelHash!=null && sameLabelHash.size()>0 && sameLabelHash.containsKey(keydisplayMeasure)))
						{
							ArrayList tmpArry=(ArrayList)sameLabelHash.get(keydisplayMeasure);
							if(tmpArry!=null && tmpArry.size()>0)
							{
								if(tmpArry.contains(keyForList))
									tmpArry.remove(keyForList);

								for(int kk=0;kk<tmpArry.size();kk++)
								{
									keyForList =(String)tmpArry.get(kk);
									String tmp_keyTest=null;
									String tmp_keyMeasure=null;
									String tmp_keydisplayMeasure=null;
									if(keyForList!=null && keyForList.indexOf(":")>-1)
									{
										tmp_keyTest=keyForList.substring(0,keyForList.indexOf(":"));
										tmp_keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
										if(tmp_keyMeasure!=null && tmp_keyMeasure.indexOf(":")>-1)
										{
											tmp_keydisplayMeasure=tmp_keyMeasure.substring(tmp_keyMeasure.indexOf(":")+1);
											tmp_keyMeasure=tmp_keyMeasure.substring(0,tmp_keyMeasure.indexOf(":"));
										}
									}
									
									String tmp_units=tablesInfo.getUnitForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_keyOrgMeasure = tmp_keyMeasure;
									tmp_keyMeasure = Dbdata.getColumnForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_Value=null;
									if(specsInfo.isTestRelevantForServer(compValue,tmp_keyTest))
									{
										tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
										if(tmp_Value==null){
											tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
										}
									}

									if(tmp_Value==null || tmp_Value.trim().length()==0)
									{
										if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
										{
											ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
											if(tokenList!=null && tokenList.size()==2)
											{
												info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
											}
										}
										tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
										if(tmp_Value==null)
										{
											tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
										}
									}

									if(tmp_Value!=null && tmp_Value.indexOf("^")>-1)
									{
										String tmp_mes_state=tmp_Value.substring(tmp_Value.indexOf("^")+1);
										String tmp_total_spc=null;
										String tmp_mes_name=null;
										if(tmp_mes_state!=null && tmp_mes_state.indexOf("^")>-1)
										{
											tmp_mes_name=tmp_mes_state.substring(tmp_mes_state.indexOf("^")+1);
											tmp_mes_state=tmp_mes_state.substring(0,tmp_mes_state.indexOf("^"));
											if(tmp_mes_name!=null && tmp_mes_name.indexOf("^")>-1)
											{
												total_spc=tmp_mes_name.substring(tmp_mes_name.indexOf("^")+1);
												tmp_mes_name=tmp_mes_name.substring(0,tmp_mes_name.indexOf("^"));
											}
										}
										tmp_Value=tmp_Value.substring(0,tmp_Value.indexOf("^"));

										if(tmp_Value!=null && !tmp_Value.trim().equals("-"))
										{
											keyTest=tmp_keyTest;
											keyMeasure=tmp_keyMeasure;
											Value=tmp_Value;
											total_spc= tmp_total_spc;
											mes_name=tmp_mes_name;
											mes_state=tmp_mes_state;
											break;
										}
									}
								}
							}
						}

						widthOfTheHead="60";
						if(units!=null && units.equals("%"))
							widthOfTheHead="150";
						
						String orgValue="0.0";
						try
						{
							if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}
								Value=String.valueOf(Value);
							}
							else if(Value!=null && Value.trim().length()>0  && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}
								Value=String.valueOf(Value);
							}
						}
						catch(Exception ee)
						{
							Value=Value;
							orgValue=Value;
						}
						if(mes_state!=null && mes_state.length()>0 && mes_state.equalsIgnoreCase("NONE"))
						{
							mes_state="GOOD";
						}
						else if(mes_state!=null && mes_state.trim().length()==0)
						{
							mes_state="GOOD";
						}
						if(Value.equalsIgnoreCase("on"))
						{
							bufRow.append("<td style=\"border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn\"><img  src=\"/final/monitor/eg_images/yes2.gif\"></td>"); 
						}
						else if(Value.equalsIgnoreCase("off"))
						{
							bufRow.append("<td style=\"border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn\"><img  src=\"/final/monitor/eg_images/no2.gif\"></td>");
						}
						else
						{
							String measuresLink = "";
							if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
							{
								String layerName = tablesInfo.getRelevantLayer(compValue,keyTest,keyOrgMeasure);
								layerName=(layerName==null || layerName.trim().length()==0)?ctype_layer:layerName;
								
								String infoKey = compValue+":"+compName+":"+keyTest+":"+info_to_lower;
								HashSet infosSet = null;
								if(fullInfoHash!=null && fullInfoHash.size()>0)
									infosSet = (HashSet)fullInfoHash.get(infoKey);
								ArrayList infosList = null;
								if(infosSet!=null && infosSet.size()>0)
									infosList = new ArrayList(infosSet);
								String info_name = "";
								if(infosList!=null && infosList.size()>1)
								{
									for(int is=0;is<infosList.size();is++)
									{
										String tmpInfo = (String)infosList.get(is);
										if(tmpInfo!=null && (tmpInfo.endsWith(":Summary") || tmpInfo.endsWith(":Total")))
										{
											info_name = tmpInfo;
											break;
										}
									}
									if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
									{
										info_name = (String)infosList.get(0);
									}
								}
								else if(infosList!=null && infosList.size()==1)
								{
									info_name = (String)infosList.get(0);
								}
								if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
								{
									info_name = "+" + info_to_lower;
								}
								measuresLink = "/final/monitor/EgSiteInfraView.jsp?qctr=2"+"&site=NULL"+"&fromalarm=0"+"&newWindow=false"+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comptype="+compValue+"&layer="+layerName+"&test="+keyTest+"-"+EgURLEncoder.encode(info_name,"UTF-8")+"&tstate="+mes_state+"&toDashBoardLayer=true";

								if(filterBy!=null && filterBy.trim().length()>0)
								{
									measuresLink=measuresLink+"&filterBy="+filterBy;
								}
								if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
								{
									measuresLink=measuresLink+"&priorityFilter="+priorityFilter;
								}
							}

							if(mes_name!=null)
							{
								if(Value!=null && !Value.equals("-"))
								{
									try
									{
										double fillColorValue=Double.parseDouble(orgValue);
										if(units!=null && units.equals("MB"))
										{
											//units = "GB";
											fillColorValue=fillColorValue/1024.0;
										}
										Value=String.valueOf(fillColorValue);
										//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
										{
											if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
											}
											else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value = getConvertDays(Value,egDashboard);
											}
											else
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
											}
										}
										else
										{
											Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										}
									}
									catch(Exception ee)
									{
										Value=String.valueOf(orgValue);
									}

									if(isDDDTestColumn || isLocationColumn)
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
											bufRow.append("<td align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding-left:8px;padding-top:7px;border:none\">");
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\"  style=\"table-layout:auto;font-size:11px;margin-top:-5px\" border=\"0\" borderColor=\"blue\" align=\"left\">");
										}
										else
										{
											//bufRow.append("<td  align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding-right:10px;padding-top:7px;border:none\">");
											bufRow.append("<td  align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding-left:8px;padding-right:8px;padding-top:7px;border:none\">");
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\"  style=\"table-layout:auto;font-size:11px;margin-top:-5px\" border=\"0\" borderColor=\"blue\" align=\"right\">");
										}
									}
									else
									{
											//bufRow.append("<td  align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn\"  style=\"padding-right:10px;padding-top:7px;border:none\">");
											bufRow.append("<td  align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn\"  style=\"padding-left:8px;padding-right:8px;padding-top:7px;border:none\">");
											//bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\"  style=\"table-layout:auto;font-size:11px;margin-top:-5px\" border=\"0\" borderColor=\"blue\" align=\"right\">");
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\"  style=\"table-layout:auto;font-size:11px;margin-top:-5px\" border=\"0\" borderColor=\"blue\" align=\"center\">");
									}
												bufRow.append("<tr style=\"background:none !important\">");
									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
											{
													bufRow.append("<td class=\"mouse\" align=\"left\" style=\"text-align:left;\"  >");
											}
											else
											{
													bufRow.append("<td class=\"mouse\" align=\"right\" style=\"text-align:right;\"  >");
											}
										}
										else
										{
													bufRow.append("<td class=\"mouse\" align=\"right\" onClick=\"javascript:goToDetails('"+measuresLink+"');\">");
										}
									}
									else
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
											{
												bufRow.append("<td align=\"left\" style=\"text-align:left;\">");
											}
											else
											{
												bufRow.append("<td align=\"right\" style=\"text-align:right;\">");
											}
										}
										else
										{
												bufRow.append("<td align=\"right\">");
										}
									}
								}
								else
								{
									if(isDDDTestColumn || isLocationColumn)
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
											bufRow.append("<td  style=\"padding-left:8px;border:none;text-align:left;\" align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \" >");
											if(Value.trim().equalsIgnoreCase("-"))
											{
												bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
											}else
											{
												bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"left\">");
											}
										}
										else
										{
											bufRow.append("<td  style=\"border:none;text-align:left;\" align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn\" >");
												bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"right\">");
										}
									}
									else
									{
										//bufRow.append("<td  style=\"border:none;padding-right:8px;\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn\" >");
										bufRow.append("<td  style=\"border:none;padding-right:8px;padding-left:8px;padding-right:8px;\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn\" >");

										boolean usage =true;
										if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
										{
											usage =false;
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
										}
										else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
										{
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
										}
										else
										{
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
										}
									}

									bufRow.append("<tr style=\"background:none !important\">");

									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											bufRow.append("<td align=\"left\" style=\"padding-right:10px;text-align:left;\">");
										}
										else
										{
											if(!Value.trim().equalsIgnoreCase("-"))
												bufRow.append("<td class=\"mouse\" align=\"left\" style=\"padding-right:10px\" onClick=\"javascript:goToDetails('"+measuresLink+"');\">");
										}
									}
									else
									{
										bufRow.append("<td align=\"left\" style=\"padding-right:10px\">");
									}
								}
							}
							else
							{
								bufRow.append("<td  style=\"padding-top:4px;border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn\" >");
									bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"right\">");
										bufRow.append("<tr style=\"background:none !important\">");

											if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
											{
												if(isDDDTestColumn || isLocationColumn)
												{
													bufRow.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
												}
												else
												{
													bufRow.append("<td class=\"mouse\" align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" >");
												}
											}
											else
											{
												bufRow.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
											}
							}
							Value = formatDbValue(Value);
							//bufRow.append(Value+"</td>");
							if(isDDDTestColumn||isLocationColumn)
							{
								if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
								{
									bufRow.append("<td style=\"text-align:left;\">");
								}
								else
								{
									bufRow.append("<td style=\"text-align:right;padding-left:5px;\">");
								}
							}
							else
							{
								if(!Value.trim().equalsIgnoreCase("-"))
									bufRow.append("<td style=\"text-align:right;padding-left:0px;\" >");
							}
							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
								{
									usage = false;
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value1 = (fillColorValue*100)/columnWidth;
													bufRow.append("<div onClick=\"javascript:goToDetails('"+measuresLink+"');\" class=\"prog_border mouse\">");
														//bufRow.append("<tr`>");
															//bufRow.append("<td align=\"left\" width=\"100%\" height=\"6\" //class=\"prog_line\">");
																//bufRow.append("<div style=\"width:"+value1+"% !important;display:block;z-index:25000;height:6px\" class =\"progress_"+mes_state+"\"  height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
																bufRow.append("<div style=\"width:"+value1+"% !important;display:block;z-index:25000;height:6px\" class =\"bar12_"+mes_state+"\"  height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
																		//bufRow.append("<div width=\"100%\" style=\"border:0px solid yellow;display:block;z-index:25000;height:6px\"></div>");
																bufRow.append("</div>");
															//bufRow.append("</td>");
														//bufRow.append("</tr>");
													bufRow.append("</div>");
								}
								else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
								{
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value2 = (fillColorValue*100)/columnWidth;

													bufRow.append("<div onClick=\"javascript:goToDetails('"+measuresLink+"');\" class=\"prog_border mouse\">");
														//bufRow.append("<tr`>");
															//bufRow.append("<td align=\"left\" width=\"100%\" height=\"6\" //class=\"prog_line\">");
																//bufRow.append("<div style=\"width:"+value2+"% !important;display:block;z-index:25000;height:6px\" class =\"progress_"+mes_state+"\"  height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
																bufRow.append("<div style=\"width:"+value2+"% !important;display:block;z-index:25000;height:6px\" class =\"bar12_"+mes_state+"\"  height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
																		//bufRow.append("<div width=\"100%\" style=\"border:0px solid yellow;display:block;z-index:25000;height:6px\"></div>");
																bufRow.append("</div>");
															//bufRow.append("</td>");
														//bufRow.append("</tr>");
													bufRow.append("</div>");
								}
							}
												bufRow.append("</td>");

							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								if(isDDDTestColumn || isLocationColumn)
								{
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
													bufRow.append("<td style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap\"  >"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
													bufRow.append("<td style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap\"  >"+Value+"</td>");
									}
									else
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
													bufRow.append("<td style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap\"  data-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><div style=\"width:120px;text-align:left;overflow:hidden;text-overflow:ellipsis;white-space:nowrap\">"+Value+"</div></td>");
										}
										else
										{
													bufRow.append("<td style=\"text-align:right;padding-left:3px;width:42px;white-space:nowrap\"  data-qtip=\""+Value+"\" data-qclass=\"yellowTip\" ><div style=\"width:120px;text-align:left;overflow:hidden;text-overflow:ellipsis;\">"+Value+"</div></td>");
										}
									}
								}
								else
								{
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
													bufRow.append("<td class=\"mouse\" style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap\" onClick=\"javascript:goToDetails('"+measuresLink+"');\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
													bufRow.append("<td class=\"mouse\" style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap\" onClick=\"javascript:goToDetails('"+measuresLink+"');\">"+Value+"</td>");
									}
									else
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
													//bufRow.append("<td class=\"mouse\" style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\" ><div style=\"margin-top:-4px;float:left;display:table-cell\" class=\"stateTick_"+mes_state+"\"><img  src=\"/final/images/clear.png\" border=\"0\" /></div><div style=\"padding-top:1px;display:table-cell;float:left;\">"+Value+"</div></td>");
													bufRow.append("<td class=\"mouse\" style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\" ><table border='0'><tr style='background:none !important'><td><img  class=\"stateSymbol_"+mes_state+"\" src=\"/final/images/clear.png\" border=\"0\" style=\"vertical-align:bottom\"/></td><td>"+Value+"</td></tr></table></td>");
										}
										else
										{
													//bufRow.append("<td class=\"mouse\" style=\"text-align:right;padding-left:3px;padding-right:30px;1width:42px;white-space:nowrap\" onClick=\"javascript:goToDetails('"+measuresLink+"');\">"+Value+"</td>");
													bufRow.append("<td class=\"mouse\" style=\"text-align:center;width:42px;white-space:nowrap\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" ata-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><table border='0'><tr style='background:none !important'><td><img class=\"stateSymbol_"+mes_state+"\" src=\"/final/images/clear.png\" border=\"0\" style=\"vertical-align:bottom\"/></td><td style=\"white-space:nowrap;\">"+Value+"</td></tr></table></td>");
										}
									}
								}
							}
							else
							{
								if(isDDDTestColumn || isLocationColumn)
								{
									bufRow.append("<td style=\"text-align:center;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
								}
								else
								{
									boolean usage =true;
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
										bufRow.append("<td style=\"text-align:center;width:42px;padding-right:30px;white-space:nowrap\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
										//bufRow.append("<td style=\"text-align:center;width:42px;padding-right:30px;white-space:nowrap\">"+Value+"</td>");
										bufRow.append("<td style=\"text-align:center;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else
									{
										if(Value.trim().equalsIgnoreCase("-")){
											bufRow.append("<td style=\"text-align:center;width:42px;white-space:nowrap\">"+Value+"</td>");
										}else{
											bufRow.append("<td style=\"text-align:right;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
										}
									}
								}
							}
											bufRow.append("</tr>");
										bufRow.append("</table>");
									bufRow.append("</td>");
						}
						p++;
					}
				}
				else
				{
					int p=0;
					while(p<measureList.size())
					{
						//bufRow.append("<td style=\"font-size:11px;text-align:right;width:20px;padding-right:10px;!important\" align=\"right\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\">-</td>"); 
						bufRow.append("<td  style=\"padding-top:4px;border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn \" >");
							bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"right\">");
								bufRow.append("<tr style=\"background:none !important\">");
									//bufRow.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
									//bufRow.append("</td>");
									bufRow.append("<td style=\"text-align:right;padding-right:15px;width:20px;\">");
									bufRow.append("-</td>");
								bufRow.append("</tr>");
							bufRow.append("</table>");
						bufRow.append("</td>");
						p++;
					}
				}
				bufRow.append("</tr>");
				desktopHtml.put(desktopName,bufRow.toString());
			}

			Hashtable formation = new Hashtable();
			ArrayList defaultList = new ArrayList();
			for(int p=0;p<deskTopList.size();p++){
				String deskName = (String)deskTopList.get(p);
				if(userRelatedAd != null && userRelatedAd.containsKey("+"+deskName)  ){
					ArrayList adList = (ArrayList)userRelatedAd.get("+"+deskName);
					for(int m=0;m<adList.size();m++){
						String adName = (String)adList.get(m);

						if(formation.containsKey(adName)){
							ArrayList userList = (ArrayList)formation.get(adName);
							userList.add(deskName);
							formation.put(adName,userList);
						}else{
							ArrayList userL = new ArrayList();
							userL.add(deskName);
							formation.put(adName,userL);
						}
					}
				}
				else if(userRelatedAd != null && userRelatedAd.containsKey(deskName)){
					ArrayList adList = (ArrayList)userRelatedAd.get(deskName);
					for(int m=0;m<adList.size();m++){
						String adName = (String)adList.get(m);

						if(formation.containsKey(adName)){
							ArrayList userList = (ArrayList)formation.get(adName);
							userList.add(deskName);
							formation.put(adName,userList);
						}else{
							ArrayList userL = new ArrayList();
							userL.add(deskName);
							formation.put(adName,userL);
						}
					}
				}
				else{
					defaultList.add(deskName);
				}
			}

			String cellPadding="";

			if (browserType.indexOf("Chrome")>-1)
			{
				cellPadding="padding-top:8px !important";
			}
			else if (browserType.indexOf("Mozilla")>-1)
			{
				cellPadding="padding-top:6px !important";
			}
			else
			{
				cellPadding="padding-top:4px ";
			}

			boolean checkCase=false;
			if(formation != null && formation.size() > 0 && !defaultAdCase )
			{
				Iterator it = formation.entrySet().iterator();
				if(aduserFilter == null || aduserFilter.trim().length() == 0)
					aduserFilter="All";
				while(it.hasNext())
				{
					Entry entry = (Entry)it.next();
					String key = (String)entry.getKey();
					ArrayList value = (ArrayList)entry.getValue();

					if(!aduserFilter.equalsIgnoreCase("All") ){
						if(!aduserFilter.equals(key))
							continue;
					}
					if(value != null && value.size() > 0)
					{
						checkCase = true;
						buf.append("<tr  style='background:none;width:30px' ><td colspan='"+(colCount)+"'><div class=\"uxAdGroupHead\" style=\"width:100%;"+cellPadding+"\"  ><div class=\"iconUxAdGroup\" style=\"float:left;margin-left:3px;margin-right:4px;margin-top:-1px\"></div><div>"+key+"  ("+value.size()+")</div>"+" </div></td></tr>");
						
						for(int q=0;q<value.size();q++){
							String usName = (String)value.get(q);
							if(desktopHtml != null && desktopHtml.containsKey(usName)){
								String html = (String)desktopHtml.get(usName);
								buf.append(html);
							}
						}
						buf.append("<tr><td colspan='"+(colCount)+"' class=\"uxBlankCell\" >&nbsp;</td></tr>");
					}
				}
			}
			
			if(aduserFilter.equalsIgnoreCase("All") ){
				if(defaultList != null && defaultList.size() > 0){
					checkCase = true;
					buf.append("<tr  style='background:none;width:30px' ><td colspan='"+(colCount)+"'   ><div class=\"uxAdGroupHead\" style=\"width:100%;"+cellPadding+"\"  ><div class=\"iconLoginUser\" style=\"float:left;margin-left:3px;margin-right:4px;margin-top:-4px\"></div><div> Default  ("+defaultList.size()+")</div>"+" </div></td></tr>");

					for(int i=0;i<defaultList.size();i++){
						String defaultdesName = (String)defaultList.get(i);
						if(desktopHtml != null && desktopHtml.containsKey(defaultdesName)){
							String html = (String)desktopHtml.get(defaultdesName);
							buf.append(html);
						}
					}
				}
			}
								buf.append("</tbody>");
							buf.append("</table>");
						buf.append("</div>");
					buf.append("</td>");
				buf.append("</tr>");
			buf.append("</table>");
			isDataAvailable = true;
			if(!checkCase){
				buf.delete(0, buf.length());

				buf.append("<table border=\"0\" width=\"100%\" height=\"100%\" bordercolor=\"green\">");
					buf.append("<tr style=\"background:none\">");
						buf.append("<td align=\"center\" width=\"100%\"  height=\"100%\" class=\"commonErrorMsgText\" >");
							buf.append("<img src = \"/final/images/spacer.gif\" class=\"iconExclamation\" lign = \"center\" border = \"0\"  vspace = \"10\"/>");
							buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found"));
						buf.append("</td>");
					buf.append("</tr>");
				buf.append("</table>");
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
				jsonRoot.put("header_display",header_display);
				isDataAvailable = false;
			}

			int pageLimit = 0;
			try
			{
				pageLimit = Integer.parseInt(priority);
			}
			catch(Exception e)
			{
				pageLimit = vdiDesktopsListTotalCount;
			}
			if(vdiDesktopsListTotalCount>pageLimit)
			{
				int pages = vdiDesktopsListTotalCount/pageLimit;
				if(vdiDesktopsListTotalCount%pageLimit!=0)
					pages +=1;

				buf.append("<form id=\"pagination\" name=\"pagination\">");
					buf.append("<table border=\"0\" style=\"margin:5px 0 0 7px;padding:3px\" class=\"uxPageText\">");
						buf.append("<tr>");
						if(pageNo>1)
						{
							buf.append("<td>");
								//buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage("+1+");return false;\" name=\"First\" id=\"First\"><< First</button>");
								buf.append("<img data-qtip=\"First Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+1+","+pages+");return false;\" class=\"uxpagingtoolbar-first\"/>");
							buf.append("</td>");

							buf.append("<td style=\"padding-right:10px\">");
								//buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage("+(pageNo-1)+");return false;\" name=\"Previous\" id=\"Previous\">< Previous</button>");
									buf.append("<img data-qtip=\"Previous Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+(pageNo-1)+","+pages+");return false;\" class=\"uxpagingtoolbar-prev\"/>");
							buf.append("</td>");
						}
						buf.append("<td style=\"padding-right:3px\">");
							buf.append("Page");
						buf.append("</td>");
						buf.append("<td>");
						int currPage = pageNo;
						if(currPage==0)currPage++;
							buf.append("<input style=\"width:35px;margin-right:2px\" class=\"uxTextbox\" type=\"text\" name=\"pageNo\" id=\"pageNo\" value=\""+currPage+"\" onKeyDown=\"javascript:if((event.keyCode=='13') || (event.keyCode=='32')){goToPage(this.form.pageNo.value,"+pages+");return false;}else{return true;}\">");
						buf.append("</td>");
						buf.append("<td style=\"display:none;padding-right:15px\">");
							buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage(this.form.pageNo.value,"+pages+");return false;\" name=\"Go\" id=\"Go\">Go</button>");
						buf.append("</td>");
						buf.append("<td style=\"padding-right:3px;padding-top:0px\">");
							buf.append("of "+pages);
						buf.append("</td>");

						/*for(int pageCount=1;pageCount<=pages;pageCount++)
						{
							if(pageNo==pageCount)
								buf.append("<td class=\"uxPageCount\" >");
							else
								buf.append("<td >");
								
								buf.append("<a href=\"javascript:void(0);\" onClick=\"javascript:goToPage("+pageCount+");\">"+pageCount+"</a>");
							buf.append("</td>");
						}*/

						if(pageNo!=pages)
						{
							if(pageNo==0)
								pageNo = 1;

							buf.append("<td style=\"padding-left:10px\">");
								//buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage("+(pageNo+1)+");return false;\" name=\"First\" id=\"First\">Next ></button>");
								buf.append("<img data-qtip=\"Next Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+(pageNo+1)+","+pages+");return false;\" class=\"uxpagingtoolbar-next\"/>");
							buf.append("</td>");
							if(vdiDesktopsListTotalCount>pageLimit)
							{
								buf.append("<td>");
									//buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage("+pages+");return false;\" name=\"Last\" id=\"Last\">Last >></button>");
									buf.append("<img data-qtip=\"Last Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+pages+","+pages+");return false;\" class=\"uxpagingtoolbar-last\"/>");
								buf.append("</td>");
							}
						}

						buf.append("</tr>");
					buf.append("</table>");
				buf.append("</form>");
			}
			jsonRoot.put("GRID_DATA",buf.toString());
			jsonRoot.put("FIlTER",fil);
			jsonRoot.put("isDataAvail",isDataAvailable);
		}
		else if(isEndUserOverview||isFromUEDSort)
		{
			boolean isPriority = false;
			boolean isAllRow = false;
			int locCount = 0;

			String statenames[] = {"HIGH","INTERMEDIATE","LOW","UNKNOWN","GOOD"};
			ArrayList searchUserKeys = new ArrayList();
			if(priority!=null && !priority.equalsIgnoreCase("ALL"))
			{
				groupByUserKeys = (ArrayList)vmDashHelper.getUEDSubList(groupByUserKeys,priority,pageNo);
				isPriority = true;
			}
			if((!isFromUEDSort) && vmDashHelper!=null && TotalMeasureInfo!=null)
				groupByUserKeys = (ArrayList)vmDashHelper.getSortedListForUEDOverview(groupByUserKeys,TotalMeasureInfo,"enduseroverview","Health",orderBy,"Health");
			if(searchString!=null && searchString.trim().length()>0 && !searchString.equalsIgnoreCase("null") && !searchString.equalsIgnoreCase("all"))
			{
				if(groupByUserKeys!=null && groupByUserKeys.size()>0)
				{
					int groupByUserKeysSize = groupByUserKeys.size();
					for(int s=0;s<groupByUserKeysSize;s++)
					{
						String search_key = (String)groupByUserKeys.get(s);
						String search_str = "";
						if(search_key!=null && search_key.trim().length()>0 && !search_key.equalsIgnoreCase("null") && search_key.indexOf("~$~")>-1)
						{
							search_str = search_key.substring(0,search_key.indexOf("~$~"));
						}
						else
						{
							search_str = search_key;
						}
						if(search_str!=null && search_str.trim().length()>0 && !search_str.equalsIgnoreCase("null") && (search_str.trim().toLowerCase().indexOf(searchString.trim().toLowerCase())>-1) && !searchUserKeys.contains(search_key))
							searchUserKeys.add(search_key); 
					}
					groupByUserKeys = searchUserKeys;
				}
			}
			else if(searchString!=null && searchString.trim().length()>0 && searchString.equalsIgnoreCase("all"))
			{
				searchUserKeys.add("All"); 
				groupByUserKeys = searchUserKeys;
			}
			else
			{
				groupByUserKeys.add(0,"All");
				isAllRow = true;
			}
			if(groupByUserKeys!=null && groupByUserKeys.size()>0)
			{
				locCount = groupByUserKeys.size();
				if(isAllRow)
					locCount = locCount - 1;
			}
			String grpByStr = ini.getValue("LOC_USER_DESKTOP_METRICS","Header:"+userType);
			if(grpByStr!=null && grpByStr.trim().length()>0 && !grpByStr.equalsIgnoreCase("null"))
			{
				if(grpByStr.indexOf(":")>-1 && grpByStr.indexOf(",")>-1)
					grpByStr = grpByStr.substring(grpByStr.indexOf(":")+1,grpByStr.indexOf(","));
			}
			if(locCount>0 && (searchString!=null && !searchString.equalsIgnoreCase("all")))
			{
				String tmpGrpByStr = "";
				if(grpByStr!=null && grpByStr.trim().length()>0 && grpByStr.equalsIgnoreCase("City"))
					tmpGrpByStr = "Cities";
				else if(grpByStr!=null && grpByStr.trim().length()>0 && grpByStr.equalsIgnoreCase("Country"))
					tmpGrpByStr = "Countries";
				else
					tmpGrpByStr = grpByStr;
				if(userType!=null && userType.trim().length()>0 && (userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7")))
					header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By "+grpByStr+" for")+" "+userType+" (Total "+tmpGrpByStr+": "+locCount+")";
				else
					header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience By "+grpByStr+" for")+" "+userType+" (Total "+tmpGrpByStr+": "+locCount+")";
				jsonRoot.put("header_display",header_display);
			}
			else
			{
				if(userType!=null && userType.trim().length()>0 && (userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7")))
					header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By "+grpByStr+" for")+" "+userType;
				else
					header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience By "+grpByStr+" for")+" "+userType;
				jsonRoot.put("header_display",header_display);
			}
			if(groupByUserKeys!=null && groupByUserKeys.size()>0 &&  finalGroupByUserTab!=null && finalGroupByUserTab.size()>0)
			{
				buf.append("<egui:skin ui=\"monitor\"/>");
				buf.append("<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"  height=\"auto\">");
					buf.append("<tr>");
						buf.append("<td width=\"100%\" valign=\"top\" height=\"100%\">");
							buf.append("<div class=\"uxTable\">");
								buf.append("<table class=\"x-grid-table x-grid-table-resizer uxTableOuter\" style=\"width:100%;table-layout:auto !important\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"  valign=\"top\" >");
									buf.append("<thead>");
										buf.append("<tr class=\"x-grid-row  x-grid-row-alt\" >");

						String measures=null;
						if(userName!=null && userName.trim().length()>0)
						{
							measures = ini.getValue("LOC_USER_DESKTOP_METRICS","Header:"+userType);
						}
						
						String[] measureArray = measures.split(",");
						measuresCount = measureArray.length;
						int colCount = measuresCount+1;
						
						for(int x=0;x<measureArray.length;x++)
						{
							String tempValue = measureArray[x];
							String tempTest = "";
							String function_name = "";
							String tempMeasure = "";
							String tempLocColName = "";
							String tempDispName = "";
							String locKeyName = "";
							String colName = "";
							ArrayList locColumnsList = null;
							StringTokenizer valTokens = new StringTokenizer(tempValue,":");
							int count = valTokens.countTokens();
							boolean isDDDColumn = false;
							boolean isLocColumn = false;
							boolean isTestColumn = false;
							String meas ="";
							if(valTokens.hasMoreTokens())
							{
								if(count==2)
								{
									tempLocColName = valTokens.nextToken();
									tempDispName = valTokens.nextToken();
									isLocColumn = true;
									meas = "NONE";
								}
								else if(count==4)
								{
									tempTest = valTokens.nextToken();
									tempMeasure = valTokens.nextToken();
									tempDispName = valTokens.nextToken();
									meas = valTokens.nextToken();
									isDDDColumn = true;
								}
							}
							if(isDDDColumn ||isLocColumn)
							{
								String unitForMeasure="";
								String meaUnit="";
								if(isDDDColumn && meas!=null && meas.trim().length()>0)
								{
									unitForMeasure = "("+meas+")";
								}
								String orderByColumn = "";
								if(isLocColumn)
								{
									orderByColumn = tempLocColName;
								}
								else if(isDDDColumn)
								{
									orderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure);	
								}
								if(isFromUEDSort && (orderByColumn!=null && orderByColumn.trim().length()>0 && orderByColumnName!=null && orderByColumnName.trim().length()>0 && orderByColumnName.equalsIgnoreCase(orderByColumn)))
								{
									String nextOrderBy="desc";
									String sortImgurl="/final/images/Dark/grid_sort_top.png";
									
									if(orderBy!=null && orderBy.equals("desc"))
									{
										nextOrderBy="asc";
										sortImgurl="/final/images/Dark/grid_sort_down.png";
									}
									else if(orderBy!=null && orderBy.equals("asc"))
									{
										nextOrderBy="desc";
										sortImgurl="/final/images/Dark/grid_sort_top.png";
									}
									if(isDDDColumn || isLocColumn)
									{
										if(isLocColumn)
										{
											if(tempDispName!=null && tempDispName.trim().length()>0 && tempDispName.equals("Health"))
											{
												buf.append("<td align=\"center\" wrap class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
											}
											else if(tempLocColName!=null && tempLocColName.trim().length()>0 && tempLocColName.equalsIgnoreCase("Total_Users"))
											{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+nextOrderBy+"','"+tempDispName+"','Total_Users');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
											}
											else
											{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+nextOrderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
											}
										}
										else
										{
											if((unitForMeasure==null || unitForMeasure.equals("")))
											{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
											}
											else
											{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
											}
										}
									}
								}
								else
								{
									if(isDDDColumn || isLocColumn)
									{
										if(isLocColumn)
										{
											if(tempDispName!=null && tempDispName.trim().length()>0 && tempDispName.equals("Health"))
											{
												buf.append("<td align=\"center\" wrap class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:150px\">"+tempDispName+"</td>");
											}
											else if(tempLocColName!=null && tempLocColName.trim().length()>0 && tempLocColName.equalsIgnoreCase("Total_Users"))
											{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+orderBy+"','"+tempDispName+"','Total_Users');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:150px\">"+tempDispName+" </td>");
											}
											else
											{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+orderBy+"','"+tempLocColName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:150px\">"+tempDispName+" </td>");
											}
										}
										else
										{
											if((unitForMeasure==null || unitForMeasure.equals("")))
											{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"','Total_Users');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\"> "+tempDispName+" </td>");
											}
											else
											{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\"> "+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
											}
										}
									}
								}
							}
						}
						buf.append("</tr>");
						buf.append("</thead>");
						buf.append("<tbody>");

								measureList = Arrays.asList(measureArray);
								int groupByUserKeysSize = groupByUserKeys.size();
								int measureListSize = 0;
								for(int k=0;k<groupByUserKeysSize;k++)
								{
									String usrMeasKey = (String)groupByUserKeys.get(k);
									if(measureList!=null && measureList.size()>0)
									{
										buf.append("<tr class=\"x-grid-row  x-grid-row-alt\" style=\"background:none\">");
										measureListSize = measureList.size();
										for(int m=0;m<measureListSize;m++)
										{
											String header_str = (String)measureList.get(m);
											String searchFilterVal = (String)measureList.get(0);
											if(searchFilterVal!=null && searchFilterVal.trim().length()>0 && searchFilterVal.indexOf(":")>-1)
												searchFilterVal = searchFilterVal.substring(0,searchFilterVal.indexOf(":"));
											String header_key = "";
											String header_disp = "";
											if(header_str!=null && header_str.trim().length()>0 && header_str.indexOf(":")>-1)
											{
												StringTokenizer hTok = new StringTokenizer(header_str.trim(),":");
												if(hTok.countTokens()==4)
												{
													String h_test = hTok.nextToken();
													String h_meas = hTok.nextToken();
													String h_disp = hTok.nextToken();
													String h_fun = hTok.nextToken();
													header_key = Dbdata.getColumnForMeasure(h_test,h_meas);
												}
												else
												{
													header_key = header_str.substring(0,header_str.indexOf(":"));
												}
											}
											String Value = "";
											String nextSearchVal = "";
											if(finalGroupByUserTab!=null && finalGroupByUserTab.size()>0 && finalGroupByUserTab.containsKey(usrMeasKey+"_"+header_key))
											{
												String measure_val = ""; 
												HashMap state_map = new HashMap();
												if(header_key!=null && header_key.trim().length()>0 && header_key.equals("Health"))
												{
													state_map = (HashMap)finalGroupByUserTab.get(usrMeasKey+"_"+header_key);
													if(usrMeasKey!=null && usrMeasKey.trim().length()>0 && searchFilterVal!=null && finalGroupByUserTab.containsKey(usrMeasKey+"_"+searchFilterVal))
													{
														nextSearchVal = (String)finalGroupByUserTab.get(usrMeasKey+"_"+searchFilterVal);
													}
													if(isShowSeparateFilters)
													{
														if(usrMeasKey!=null && usrMeasKey.indexOf("~$~")>-1)
														{
															String groupKey1 = "";
															if(groupByList!=null && groupByList.size()>0)
																groupKey1 = (String)groupByList.get(0);
															String filName1 =  "";
															if(showFilterNames!=null && showFilterNames.indexOf(",")>-1)
															{
																filName1 = showFilterNames.substring(0,showFilterNames.indexOf(","));
																if(filName1!=null && groupKey1!=null && filName1.equalsIgnoreCase(groupKey1))
																{
																	searchFilterVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
																	
																	String tmpNextSearchVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
																	if(tmpNextSearchVal!=null && tmpNextSearchVal.indexOf("~$~")==-1)
																		nextSearchVal = tmpNextSearchVal;
																	else
																		nextSearchVal = tmpNextSearchVal.substring(tmpNextSearchVal.indexOf("~$~")+3);
																}
																else
																{
																	nextSearchVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
																
																	String tmpSearchFilterVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
																	if(tmpSearchFilterVal!=null && tmpSearchFilterVal.indexOf("~$~")==-1)
																		searchFilterVal = tmpSearchFilterVal;
																	else
																		searchFilterVal = tmpSearchFilterVal.substring(tmpSearchFilterVal.indexOf("~$~")+3);
																}
															}

															/*if(usrMeasKey!=null && usrMeasKey.indexOf("~$~")>-1)
															{
																searchFilterVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
																nextSearchVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
															}
															else if(usrMeasKey!=null && usrMeasKey.equalsIgnoreCase("All"))
															{
																searchFilterVal = usrMeasKey;
																nextSearchVal = usrMeasKey;
															}*/
														}
														else if(usrMeasKey!=null && (usrMeasKey.equalsIgnoreCase("All")||usrMeasKey.indexOf("~$~")==-1))
														{
															searchFilterVal = usrMeasKey;
															nextSearchVal = usrMeasKey;
														}
													}
													StringBuffer htmlStr = new StringBuffer();
													htmlStr.append("<div class=\"healthviewgridbar\" style=\"margin-top:-2px\"><div style=\"margin-top:-2px;width:100%;\" class=\"outer12\">");
													if(state_map!=null && state_map.size()>0 && statenames!=null && statenames.length>0)
													{
														for(int n=0;n<statenames.length;n++)
														{
															String state_constant = statenames[n];
															if(state_map.containsKey(state_constant))
															{
																String state_val = (String)state_map.get(state_constant);
																if(state_val!=null && state_val.trim().length()>0 && state_val.indexOf("^|^")>-1)
																{
																	String user_per = state_val.substring(0,state_val.indexOf("^|^"));
																	String cnt = state_val.substring(state_val.indexOf("^|^")+3);
																	
																	String drillDownLink = "/final/monitor/endUserDashboard.jsp?access=allusers&user="+EgURLEncoder.encode(userName,"UTF-8")+"&userType="+userType+"&priority="+priority+"&filterFlag=true&filterBy=All&searchFilter="+searchFilterVal+"&nextSearch="+nextSearchVal+"&fromMenu=true&vdiType="+vdiType+"&enableBackButton=true&isfromuedoverview=true"+"&overviewsearchstr="+EgURLEncoder.encode(searchString,"UTF-8")+"&priorityFilter="+state_constant;

																	htmlStr.append("<a class=\"mouse\" href=\"javascript:void(0);\" onClick=\"javascript:goToDetails('"+drillDownLink+"');\" data-qclass=\"yellowTip\"><div id=\""+state_constant+"_bg\" style=\"color:#fff;width:"+user_per+"%;height:14px;padding-top:2px;\" class=\"innerLeftRight12\">"+cnt+"</div></a>");
																}
															}
														}
													}
													htmlStr.append("</div><div style=\"clear:both\"></div></div>"); 
													if(htmlStr!=null)
														buf.append("<td class=\"x-grid-cell\" style=\"text-align:right;padding-left:3px;padding:4px 4px 1px 4px;width:42px;text-overflow:ellipsis;white-space:nowrap;\"><div style=\"text-align:left;text-overflow:ellipsis;white-space:nowrap\">"+htmlStr.toString()+"</div></td>");
												}
												else
												{
													if(groupByList!=null && groupByList.size()>0 && groupByList.contains(header_key))
													{
														Value = (String)finalGroupByUserTab.get(usrMeasKey+"_"+header_key);
														if(Value==null||Value.trim().length()==0||Value.equals("-5.0000")||Value.equalsIgnoreCase("null"))
															Value = "-";
														String orgValue="0.0";
														try
														{
															if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
															{
																orgValue=Value;
																Value = String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
																//Value=String.valueOf(Value);
															}
															else if(Value!=null && Value.trim().length()>0  && Double.parseDouble(Value)>0)
															{
																orgValue=Value;
																Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
																//Value = String.valueOf(Value);
															}
														}
														catch(Exception ee)
														{
															Value = Value;
															orgValue = Value;
														}
														if(Value==null||Value.trim().length()==0||Value.equals("-5.0000")||Value.equalsIgnoreCase("null"))
															Value = "-";
														if(isShowSeparateFilters)
														{
														
															/*if(usrMeasKey!=null && usrMeasKey.indexOf("~$~")>-1)
															{
																searchFilterVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
																nextSearchVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
															}
															else if(usrMeasKey!=null && (usrMeasKey.equalsIgnoreCase("All")||usrMeasKey.indexOf("~$~")==-1))
															{
																searchFilterVal = usrMeasKey;
																nextSearchVal = usrMeasKey;
															}*/

															String groupKey1 = "";
															if(groupByList!=null && groupByList.size()>0)
																groupKey1 = (String)groupByList.get(0);
															String filName1 =  "";
															if(usrMeasKey!=null && usrMeasKey.indexOf("~$~")>-1)
															{
																if(showFilterNames!=null && showFilterNames.indexOf(",")>-1)
																{
																	filName1 = showFilterNames.substring(0,showFilterNames.indexOf(","));
																	if(filName1!=null && groupKey1!=null && filName1.equalsIgnoreCase(groupKey1))
																	{
																		searchFilterVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
																		String tmpNextSearchVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
																		if(tmpNextSearchVal!=null && tmpNextSearchVal.indexOf("~$~")==-1)
																			nextSearchVal = tmpNextSearchVal;
																		else
																			nextSearchVal = tmpNextSearchVal.substring(tmpNextSearchVal.indexOf("~$~")+3);
																	}
																	else
																	{
																		nextSearchVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
																		
																		String tmpSearchFilterVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
																		if(tmpSearchFilterVal!=null && tmpSearchFilterVal.indexOf("~$~")==-1)
																			searchFilterVal = tmpSearchFilterVal;
																		else
																			searchFilterVal = tmpSearchFilterVal.substring(tmpSearchFilterVal.indexOf("~$~")+3);
																	}
																}
															}
															else if(usrMeasKey!=null && (usrMeasKey.equalsIgnoreCase("All")||usrMeasKey.indexOf("~$~")==-1))
															{
																searchFilterVal = usrMeasKey;
																nextSearchVal = usrMeasKey;
															}
														}
														else
														{
															searchFilterVal = header_key;
															nextSearchVal = Value;
														
														
													
														}
													
														String drillDownLink = "/final/monitor/endUserDashboard.jsp?access=allusers&user="+EgURLEncoder.encode(userName,"UTF-8")+"&userType="+userType+"&priority="+priority+"&filterFlag=true&filterBy=All&searchFilter="+searchFilterVal+"&nextSearch="+nextSearchVal+"&fromMenu=true"+"&vdiType="+vdiType+"&enableBackButton=true&isfromuedoverview=true"+"&overviewsearchstr="+EgURLEncoder.encode(searchString,"UTF-8")+"&priorityFilter=All";
													
														buf.append("<td onclick=\"javascript:goToDrillDown('"+drillDownLink+"');\"  class=\"x-grid-cell\" style=\"cursor:pointer;text-align:right;padding-left:3px;padding:4px 0 1px 6px;width:42px;text-overflow:ellipsis;white-space:nowrap;\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><div style=\"cursor:pointer;width:120px;text-align:left;padding-left:10px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap\">"+Value+"</div></td>");
													}
													else
													{
														Value = (String)finalGroupByUserTab.get(usrMeasKey+"_"+header_key);
														if(Value==null||Value.trim().length()==0||Value.equals("-5.0000")||Value.equalsIgnoreCase("null"))
															Value = "-";
														buf.append("<td class=\"x-grid-cell\" style=\"text-align:center !important;padding-right:8px;padding:4px 0 1px 6px;width:42px;text-overflow:ellipsis;white-space:nowrap;\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\">"+Value+"</td>");
													}
												}
											}
											else
											{
												if(Value==null||Value.trim().length()==0||Value.equals("-5.0000")||Value.equalsIgnoreCase("null"))
													Value = "-";
												buf.append("<td class=\"x-grid-cell\" style=\"text-align:center !important;padding-right:8px;padding:4px 0 1px 6px;width:42px;text-overflow:ellipsis;white-space:nowrap;\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\">"+Value+"</td>");
											}
										}
									}
									else
									{
										int p=0;
										int measureListSize1 = 0;
										if(measureList!=null)
											measureListSize1 = measureList.size();
										while(p<measureListSize1)
										{
											String keyForList=(String)measureList.get(p);
											StringTokenizer valTokens = new StringTokenizer(keyForList,":");
											int tokCount = valTokens.countTokens();
											boolean isDDDTestColumn = false;
											boolean isLocationColumn = false;

											if(tokCount==4)
												isDDDTestColumn = true;
											else if(tokCount==2)
												isLocationColumn = true;

											buf.append("<td  style=\"padding-top:4px;border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-last\" >");
											if(isDDDTestColumn || isLocationColumn)
											{
												buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"left\">");
											}
											else
											{
												buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"right\">");
											}
											buf.append("<tr style=\"background:none !important\">");

											if(isDDDTestColumn || isLocationColumn)
											{
												buf.append("<td style=\"text-align:center;padding-left:23px;padding-right:38px;width:42px;white-space:nowrap;\">-</td>");
											}
											else
											{
												buf.append("<td style=\"text-align:right;padding-left:3px;padding-right:38px;width:42px;white-space:nowrap;\">-</td>");
											}
											buf.append("</tr>");
											buf.append("</table>");
											buf.append("</td>");
											p++;
										}
									}
									buf.append("</tr>");
								}
								buf.append("</tbody>");
								buf.append("</table>");
							buf.append("</div>");
						buf.append("</td>");
					buf.append("</tr>");
				buf.append("</table>");

				int pageLimit = 0;
				try
				{
					pageLimit = Integer.parseInt(priority);
				}
				catch(Exception e)
				{
					pageLimit = groupByUserCount;
				}
				if(groupByUserCount>pageLimit)
				{
					int pages = groupByUserCount/pageLimit;
					if(groupByUserCount%pageLimit!=0)
						pages +=1;

						buf.append("<form id=\"pagination\" name=\"pagination\">");
						buf.append("<table border=\"0\" style=\"margin:5px 0 0 7px;padding:3px\" class=\"uxPageText\">");
							buf.append("<tr>");
							if(pageNo>1)
							{
								buf.append("<td>");
								buf.append("<img data-qtip=\"First Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+1+","+pages+");return false;\" class=\"uxpagingtoolbar-first\"/>");
								buf.append("</td>");

								buf.append("<td style=\"padding-right:10px\">");
								buf.append("<img data-qtip=\"Previous Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+(pageNo-1)+","+pages+");return false;\" class=\"uxpagingtoolbar-prev\"/>");
								buf.append("</td>");
							}
							buf.append("<td style=\"padding-right:3px\">");
								buf.append("Page");
							buf.append("</td>");
							buf.append("<td>");
							int currPage = pageNo;
							if(currPage==0)currPage++;
								buf.append("<input style=\"width:35px;margin-right:2px\" class=\"uxTextbox\" type=\"text\" name=\"pageNo\" id=\"pageNo\" value=\""+currPage+"\" onKeyDown=\"javascript:if((event.keyCode=='13') || (event.keyCode=='32')){goToPage(this.form.pageNo.value,"+pages+");return false;}else{return true;}\">");
							buf.append("</td>");
							buf.append("<td style=\"display:none;padding-right:15px\">");
								buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage(this.form.pageNo.value,"+pages+");return false;\" name=\"Go\" id=\"Go\">Go</button>");
							buf.append("</td>");
							buf.append("<td style=\"padding-right:3px;padding-top:0px\">");
								buf.append("of "+pages);
							buf.append("</td>");

							if(pageNo!=pages)
							{
								if(pageNo==0)
									pageNo = 1;

								buf.append("<td style=\"padding-left:10px\">");
									buf.append("<img data-qtip=\"Next Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+(pageNo+1)+","+pages+");return false;\" class=\"uxpagingtoolbar-next\"/>");
								buf.append("</td>");
								if(groupByUserCount>pageLimit)
								{
									buf.append("<td>");
										buf.append("<img data-qtip=\"Last Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+pages+","+pages+");return false;\" class=\"uxpagingtoolbar-last\"/>");
									buf.append("</td>");
								}
							}
							buf.append("</tr>");
						buf.append("</table>");
					buf.append("</form>");
				}
				isDataAvailable = true;
			}
			else
			{
				int col_span=measureList.size();
				buf.append("<table border=\"0\" width=\"100%\" height=\"100%\" bordercolor=\"green\">");
					buf.append("<tr style=\"background:none\">");
						buf.append("<td align=\"center\" width=\"100%\" colspan=\""+col_span+"\" height=\"100%\" class=\"commonErrorMsgText\" >");
							buf.append("<img src = \"/final/images/spacer.gif\" class=\"iconExclamation\" lign = \"center\" border = \"0\"  vspace = \"10\"/>");
							buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found"));
						buf.append("</td>");
					buf.append("</tr>");
				buf.append("</table>");
				isDataAvailable = false;
			}
			jsonRoot.put("GRID_DATA",buf.toString());
			jsonRoot.put("FIlTER",fil);
			jsonRoot.put("isDataAvail",isDataAvailable);
		}
		else if((!isEndUserOverview) && (!isFromUEDSort))
		{
			buf.append("<egui:skin ui=\"monitor\"/>");
			buf.append("<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"  height=\"auto\">");
				buf.append("<tr>");
					buf.append("<td width=\"100%\" valign=\"top\" height=\"100%\">");
						buf.append("<div class=\"uxTable\">");
							buf.append("<table class=\"x-grid-table x-grid-table-resizer uxTableOuter\" style=\"width:100%;table-layout:auto !important\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"  valign=\"top\" >");
								buf.append("<thead>");
									buf.append("<tr class=\"x-grid-row  x-grid-row-alt\" >");
									if(!orderByCol_flag)
									{
										//buf.append("<td align=\"center\"  wrap onclick=\"javascript:sortByMeasure('','"+orderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  style=\"padding:3px;width:240px\"><table class=\"uxInnerTable\"><tr><td>"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+"</td><td><div class='uxSortTop'> <img id=\"sortImg\" src=\"/final/images/Dark/grid_sort_top.png\"/></div></td></tr></table> </td>");

										buf.append("<td align=\"left\"  wrap onclick=\"javascript:sortByMeasure('','"+orderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  style=\"padding:6px 3px 3px 10px !important;width:240px;\"><table align=\"left\" class=\"uxInnerTable\"><tr><td >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+"</td></tr></table> </td>");
									}
									else
									{
										buf.append("<td align=\"left\"  wrap onclick=\"javascript:sortByMeasure('','"+orderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn\"  style=\"padding:6px 3px 3px 10px !important;width:240px\">"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+ "</td>");
									}

									if(orderByColumnName!=null && orderByColumnName.equalsIgnoreCase("Host"))
									{
										String nextOrderBy="desc";
										String sortImgurl="/final/images/Dark/grid_sort_top.png";
										
										if(orderBy!=null && orderBy.equals("desc"))
										{
											nextOrderBy="asc";
											sortImgurl="/final/images/Dark/grid_sort_down.png";
										}
										else if(orderBy!=null && orderBy.equals("asc"))
										{
											nextOrderBy="desc";
											sortImgurl="/final/images/Dark/grid_sort_top.png";
										}

										buf.append("<td align=\"left\"  wrap onclick=\"javascript:sortByMeasure('Host','"+nextOrderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn\"  style=\"padding:6px 3px 3px 10px !important;width:180px\"><table class=\"uxInnerTable\"><tr><td>"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Host")+"</td><td><div  class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div> </td></tr></table></td>");
									}
									else
									{
										buf.append("<td align=\"left\"  wrap onclick=\"javascript:sortByMeasure('Host','"+orderBy+"','');\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding:6px 3px 3px 10px !important;width:180px\">"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Host")+ "</td>");
									}

			String widthOfTheHead="";
			String strVdiHostCombo=ini.getValue("END_USER_DASHBOARD_SETTINGS","showVdiHostCombo");
			strVdiHostCombo=(strVdiHostCombo==null || strVdiHostCombo.trim().length()==0)?"false":strVdiHostCombo;

			boolean showVdiHostCombo = "true".equalsIgnoreCase(strVdiHostCombo)?true:false;
			boolean isSkipVal = false;
			ArrayList skippedColumns = new ArrayList();
			String measures=null;
			String measuresD=null;
			String measuresT=null;
			if(userName!=null && userName.trim().length()>0)
			{
				measures = ini.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
			}
		
			if(measures==null || measures.trim().length()==0)
			{
				measuresD = ini.getValue("USER_DESKTOP_METRICS","DEFAULT_"+userType);
				measuresT = ini.getValue("USER_DESKTOP_METRICS",userType);
				if(measuresD != null && measuresD.trim().length() > 0)
				{
					measures = measuresD;
				}
				else
				{
					measures = measuresT;
				}
			}
			String[] measureArray = measures.split(",");
			ArrayList displayColsList = new ArrayList();
			ArrayList validColsList = new ArrayList();
			Hashtable sameLabelHash = new Hashtable();
			measuresCount = measureArray.length;
			int colCount=measuresCount+1;

			for(int x=0;x<measureArray.length;x++)
			{
				String tempValue = measureArray[x];
				String tempTest = "";
				String tempMeasure = "";
				String tempLocColName = "";
				String tempDispName = "";
				String locKeyName = "";
				String colName = "";
				ArrayList locColumnsList = null;
				StringTokenizer valTokens = new StringTokenizer(tempValue,":");
				int count = valTokens.countTokens();
				boolean isDDDColumn = false;
				boolean isLocColumn = false;
				boolean isTestColumn = false;
				String meas ="";
				if (valTokens.hasMoreTokens())
				{
					if(count==3)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isTestColumn=true;
					}
					else if(count==2)
					{
						if(isShowUserLocation)
						{
							tempTest = valTokens.nextToken();
							tempMeasure = valTokens.nextToken();
							//tempDispName = mappingInfo.getMeasureDescription(tempTest,tempMeasure);
							isLocColumn = true;
							meas = "NONE";

							ArrayList tmpMeasureList = new ArrayList(); 
							tmpMeasureList = StringUtils.egTokenizer(tempMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
							if(tmpMeasureList!=null && tmpMeasureList.size()>0)
							{
								int meaListSize=tmpMeasureList.size();
								if(meaListSize==1)
								{
									tempDispName = tempMeasure;
									tempLocColName = tempMeasure;
								}
								else if(meaListSize>1)
								{
									tempLocColName = (String)tmpMeasureList.get(0);
									tempDispName = (String)tmpMeasureList.get(1);
								}
							}
						}
					}
					else if(count==5)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						colName = valTokens.nextToken();
						meas = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isDDDColumn = true;
					}
				}

				if(isTestColumn || isDDDColumn || isLocColumn)
				{
					if(displayColsList!=null && displayColsList.contains(tempDispName))
					{
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}

						continue;
					}

					String unitForMeasure="";
					String meaUnit="";
					if(isDDDColumn && meas!=null && meas.trim().length()>0 && (!meas.equalsIgnoreCase("NONE")&&!meas.equalsIgnoreCase("DATE")))
					{
						unitForMeasure = "("+meas+")";
					}
					else if(!isDDDColumn && !isLocColumn)
					{
						String unitVal=tablesInfo.getUnitForMeasure(tempTest,tempMeasure.trim());

						if(unitVal!=null && unitVal.trim().length()>0)
						{
							unitForMeasure="&nbsp;("+unitVal+")";

							meaUnit = unitVal;
						}
					}

					if(unitForMeasure!=null && unitForMeasure.indexOf("MB")>-1)
						unitForMeasure ="&nbsp;(GB)";

					if(tempDispName!=null && tempDispName.equalsIgnoreCase("Status"))
					{
						unitForMeasure="";
					}
					else if(tempDispName!=null && (tempDispName.equalsIgnoreCase("Disk Used") || tempDispName.equalsIgnoreCase("Used Space")))
					{
						unitForMeasure="("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
					}

					String orderByColumn = "";
					if(isLocColumn)
					{
						//orderByColumn = tempDispName;
						orderByColumn = tempLocColName;
						//orderByColumnName = tempDispName;
					}
					else if (isDDDColumn)
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest+"_DDD",colName);
					}
					else
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure); 
					}

					if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(tempTest+":"+tempMeasure))
					{
						unitForMeasure="";
					}

					if(orderByColumn!=null && orderByColumn.trim().length()>0 && orderByColumnName!=null && orderByColumnName.trim().length()>0 && orderByColumnName.equalsIgnoreCase(orderByColumn))
					{
						String nextOrderBy="desc";
						//String sortImgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
						String sortImgurl="/final/images/Dark/grid_sort_top.png";
						
						if(orderBy!=null && orderBy.equals("desc"))
						{
							nextOrderBy="asc";
							//sortImgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
							sortImgurl="/final/images/Dark/grid_sort_down.png";
						}
						else if(orderBy!=null && orderBy.equals("asc"))
						{
							nextOrderBy="desc";
							sortImgurl="/final/images/Dark/grid_sort_top.png";
						}

						if(isDDDColumn || isLocColumn)
						{
							if(isLocColumn)
							{
								if((unitForMeasure==null || unitForMeasure.equals(""))&& (meas!=null && !meas.equalsIgnoreCase("DATE")))
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+nextOrderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
								else
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+nextOrderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
							}
							else
							{
								if((unitForMeasure==null || unitForMeasure.equals(""))&& (meas!=null && !meas.equalsIgnoreCase("DATE")))
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
								else
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
							}
						}
						else
						{
							if(meaUnit!=null && (meaUnit.equals("%") || meaUnit.equalsIgnoreCase("percent") || meaUnit.equalsIgnoreCase("percentage")))
							{
								if(unitForMeasure==null || unitForMeasure.equals(""))
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
								else
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:3px;width:140px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div  class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
								}
							}
							else
							{
								if(tempDispName!=null && tempDispName.length()<13)
								{
									if(unitForMeasure==null || unitForMeasure.equals(""))
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:100px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
									else
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:100px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div  class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
								}
								else
								{
									if(unitForMeasure==null || unitForMeasure.equals(""))
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:130px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</td><td><div class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
									else
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+nextOrderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:130px\"><table class=\"uxInnerTable\"><tr><td>"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td><td><div  class=\"uxSortTop\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/></div></td></tr></table></td>");
									}
								}
							}
						}
					}
					else
					{
						if(isDDDColumn || isLocColumn)
						{
							if(isLocColumn)
							{
								if((unitForMeasure==null || unitForMeasure.equals("")) && (meas!=null && !meas.equalsIgnoreCase("DATE")))
								{
											buf.append("<td align=\"left\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+orderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\">"+tempDispName+" </td>");
								}
								else
								{
											buf.append("<td align=\"left\" wrap onclick=\"javascript:sortByDDMeasure('"+tempLocColName+"','"+orderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\">"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
								}
							}
							else
							{
								if((unitForMeasure==null || unitForMeasure.equals("")) && (meas!=null && !meas.equalsIgnoreCase("DATE")))
								{
											buf.append("<td align=\"left\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"','NONE');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\"> "+tempDispName+" </td>");
								}
								else
								{
											buf.append("<td align=\"left\" wrap onclick=\"javascript:sortByDDMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"','"+meas+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn \" style=\"padding:6px 3px 3px 10px !important;width:140px\"> "+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
								}
							}
						}
						else
						{
							if(meaUnit!=null && (meaUnit.trim().equals("%") || meaUnit.trim().equalsIgnoreCase("percent") || meaUnit.trim().equalsIgnoreCase("percentage")))
							{
								if(unitForMeasure==null || unitForMeasure.equals(""))
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn\" style=\"padding:3px;width:140px\">"+tempDispName+" </td>");
								}
								else
								{
											buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn\" style=\"padding:3px;width:140px\">"+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
								}
							}
							else
							{
								if(tempDispName!=null && tempDispName.length()<13)
								{
									if(unitForMeasure==null || unitForMeasure.equals(""))
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:100px\"> "+tempDispName+" </td>");
									}
									else
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:100px\"> "+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
									}
								}
								else
								{
									if(unitForMeasure==null || unitForMeasure.equals(""))
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:130px\"> "+tempDispName+" </td>");
									}
									else
									{
												buf.append("<td align=\"center\" wrap onclick=\"javascript:sortByMeasure('"+orderByColumn+"','"+orderBy+"','"+tempDispName+"');\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" style=\"padding:3px;width:130px\"> "+tempDispName+"</br><span style=\"text-transform:capitalize !important\">"+unitForMeasure+"</span></td>");
									}
								}
							}
						}
					}
					if(displayColsList!=null && tempDispName!=null && !displayColsList.contains(tempDispName))
					{
						displayColsList.add(tempDispName);
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
					}
					if(validColsList!=null && tempValue!=null && !validColsList.contains(tempValue))
						validColsList.add(tempValue);
				}
			}

			if(validColsList!=null && validColsList.size()>0)
			{
				measureArray = new String[validColsList.size()];
				int yy=0;
				for(int y=0;y<validColsList.size();y++)
				{
					String tempValue1 = (String)validColsList.get(y);
					if(tempValue1!=null && tempValue1.trim().length()>0)
					{
						measureArray[yy++]=tempValue1;
					}
				}
			}
								buf.append("</tr>");
							buf.append("</thead>");
							buf.append("<tbody>");
			EgService serv = null;
			int desktopsSize = (vdiDesktopsList!=null && vdiDesktopsList.size()>0)?vdiDesktopsList.size():0;
			int deskColWidth=-1;
			int hostColWidth=-1;
			int continueCount = 0;
			for(int i=0;i<desktopsSize;i++)
			{
				serv = (EgService)vdiDesktopsList.get(i);
				String trBackground = "eg_lightlight";
				if(i%2==0)
					trBackground = "eg_whitebg";

				String desktopComponent = serv.getName();
				String desktopState = serv.getState().getName();
				String desktopName = "";
				String comp = "";
				String compValue = "";
				String compName = "";
				String compNameWithOutPort = "";
				
				if(desktopComponent!=null && desktopComponent.indexOf("^")>-1)
				{
					desktopName = desktopComponent.substring(0,desktopComponent.indexOf("^"));
					comp = desktopComponent.substring(desktopComponent.indexOf("^")+1);
				}

				if(comp!=null && comp.indexOf(":")>-1)
				{
					compValue = comp.substring(0,comp.indexOf(":"));
					compName = comp.substring(comp.indexOf(":")+1);
				}
				if(compName!=null && compName.indexOf(":")>-1)
				{
					compNameWithOutPort = compName.substring(0,compName.indexOf(":"));
				}
				measureValues = (Hashtable)TotalMeasureInfo.get(comp);
				String msmtHost = "";
				String ctype_layer=ini.getValue("USER_DESKTOP_LAYERS",compValue);
				ctype_layer=(ctype_layer==null || ctype_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_layer;
				ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer);
				if(arr!=null && arr.size()>0)
				{
					boolean flag=true;
					for (int t=0;t<arr.size();t++)
					{
						String insideviewTest=(String) arr.get(t);
						if(insideviewTest!=null && insideviewTest.trim().length()>0)
						{
							List agents=egExternalInfo.getAgentsFor(insideviewTest.trim(),compValue,compNameWithOutPort);

							if(agents!=null && agents.size()>0)
							{
								msmtHost=(String)agents.get(0);
								flag=false;
								break;
							}
						}
					}

					if(flag)
						msmtHost=compNameWithOutPort;
				}
				else
					msmtHost=compNameWithOutPort;

				String tempHostType = compValue;
				String url_desktopName=com.egurkha.util.StringUtils.replace(desktopName, "\\", "\\");
				String url = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compValue+"&info=*"+EgURLEncoder.encode(url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(compName+":"+compValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(compNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType+"&desktopState="+desktopState+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&filterFlag="+filterFlag+"&searchFilter="+searchFilter+"&nextSearch="+nextSearch;

				if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
				{
					url=url+"&fromMenu="+fromMenuStr;
				}

				if(filterBy!=null && filterBy.trim().length()>0)
				{
					url=url+"&filterBy="+filterBy;
				}
				if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
				{
					url=url+"&priorityFilter="+priorityFilter;
				}
				String link ="";
				if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0)
				{
					link = "/final/servlet/com.eg.EgDashboardController?site=NULL"+"&from=list&comptype="+EgURLEncoder.encode(compValue,"UTF-8")+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=LayerModel"+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&filterFlag="+filterFlag+"&searchFilter="+searchFilter+"&nextSearch="+nextSearch;
				}
				else
				{
					link = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compValue+"&info=*"+EgURLEncoder.encode(url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(compName+":"+compValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(compNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType+"&desktopState="+desktopState+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&filterFlag="+filterFlag+"&searchFilter="+searchFilter+"&nextSearch="+nextSearch;
				}

				if(filterBy!=null && filterBy.trim().length()>0)
				{
					link=link+"&filterBy="+filterBy;
				}
				if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
				{
					link=link+"&priorityFilter="+priorityFilter;
				}
				String disp_desktopName=desktopName;
				//if(disp_desktopName!=null && disp_desktopName.length()>30)
					//disp_desktopName=disp_desktopName.substring(0,30)+"..";

				String strName = compName;
				if (strName.endsWith(EgConstants.NULL_PORT) && (strName.indexOf(EgConstants.NULL_PORT) > -1))
				{
					strName = Server.getServerNameWithoutPort(strName, false);
				}

				String disp_StrName = strName;
				if(disp_StrName!=null && disp_StrName.length()>22)
					disp_StrName=disp_StrName.substring(0,22)+"..";

									buf.append("<tr class=\"x-grid-row  x-grid-row-alt\" style=\"background:none\">");
										buf.append("<td style=\"border:none\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\"  nowrap width=\"10%\">");
											buf.append("<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\" borderColor=\"red\">");
												buf.append("<tr style=\"background:none !important\">");
													buf.append("<td style=\"padding-left:3px\">");

														buf.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/images/spacer.gif\" class=\"eud_"+desktopState+"\"></div>");

				int tmp_deskCol_Len=0;
				if(desktopName!=null && desktopName.length()>0)
				{
					tmp_deskCol_Len=desktopName.length();
				}
				if(tmp_deskCol_Len>deskColWidth)
					deskColWidth=tmp_deskCol_Len;
				
				String deskCellWidth="150px";
				if(deskColWidth>15 && deskColWidth<30)
				{
					deskCellWidth="190px";
				}
				else if(deskColWidth>=30)
				{
					deskCellWidth="240px";
				}
				
				int tmp_hostColWidth=0;
				if(strName!=null && strName.length()>0)
				{
					tmp_hostColWidth=strName.length();
				}
				if(tmp_hostColWidth>hostColWidth)
					hostColWidth=tmp_hostColWidth;
				
				String hostCellWidth="100px";
				if(hostColWidth>15 && hostColWidth<40)
				{
					hostCellWidth="150px";
				}
				else if(hostColWidth>=40)
				{
					hostCellWidth="200px";
				}

													buf.append("</td>");
													buf.append("<td nowrap>");
														buf.append("<div style=\"font-size:11px;float:left;position:relative;visibility:visible;text-align:left;width:"+deskCellWidth+"\"><a class=\"eg_monlink\" href=\"javascript:void(0);\" onClick=\"javascript:goToDetails('"+url+"');\" data-qtip=\""+desktopName+"\" data-qclass=\"yellowTip\" ><div style=\"padding-top:4px;text-align:left;overflow:hidden;text-overflow:ellipsis;\">"+disp_desktopName+"</div></a> </div>");

													buf.append("</td>");
												buf.append("</tr>");
											buf.append("</table>");
										buf.append("</td>");
										buf.append("<td style=\"border:none;padding-left:8px;\" class=\"x-grid-cell x-grid-cell-gridcolumn\"  nowrap width=\"10%\">");
											buf.append("<div style=\"float:left;position:relative;visibility:visible;text-align:left;width:"+hostCellWidth+";\"><a class=\"mouse\" href=\"javascript:void(0);\" onClick=\"javascript:goToDetails('"+link+"');\"  data-qtip=\""+strName+"\" data-qclass=\"yellowTip\" ><div style=\"padding-top:4px;text-align:left;overflow:hidden;text-overflow:ellipsis;\">"+disp_StrName+"</div></a> </div>");
										buf.append("</td>");

				measureList = Arrays.asList(measureArray);
				if(measureValues!=null && measureValues.size()>0)
				{
					String ctype_out_layer=ui.getValue("Layer_for_ComponentType",compValue);
					ctype_out_layer=(ctype_out_layer==null || ctype_out_layer.trim().length()==0)?"VIRTUAL_GUESTS":ctype_out_layer;
					ArrayList listOfTest=(ArrayList)tablesInfo.getTestsForLayer(ctype_out_layer,compValue);

					int p=0;
					String info_to_lower=desktopName;
					while(p<measureList.size())
					{
						String keyForList=(String)measureList.get(p);
						String keyMeasure="";
						String keyOrgMeasure="";
						String keyTest="";
						String keydisplayMeasure="";
						StringTokenizer valTokens = new StringTokenizer(keyForList,":");
						int tokCount = valTokens.countTokens();
						boolean isDDDTestColumn = false;
						boolean isLocationColumn = false;

						if(tokCount==5)
							isDDDTestColumn = true;
						else if(tokCount==2)
							isLocationColumn = true;

						String orgColName = "";
						String funcName = "";
						String dispName = "";
						String tempDispName = "";
						String locKeyName = "";
						String Value="";
						String units="";
						
						ArrayList keyMeasureList = null; 
						ArrayList locMeasuresList = new ArrayList(); 
						
						if(isDDDTestColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
									if(orgColName!=null && orgColName.indexOf(":")>-1)
									{
										funcName=orgColName.substring(orgColName.indexOf(":")+1);
										orgColName = orgColName.substring(0,orgColName.indexOf(":"));

										if(funcName!=null && funcName.indexOf(":")>-1)
										{
											dispName=funcName.substring(funcName.indexOf(":")+1);
											funcName = funcName.substring(0,funcName.indexOf(":"));
										}
									}
								}
							}

							if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && !listOfTest.contains(keyTest) && dispName!=null)
							{
								ArrayList tmpArry=(ArrayList)sameLabelHash.get(dispName);
								if(tmpArry!=null && tmpArry.size()>0)
								{
									for(int kk=0;kk<tmpArry.size();kk++)
									{
										keyForList =(String)tmpArry.get(kk);

										if(keyForList!=null && keyForList.indexOf(":")>-1)
										{
											keyTest=keyForList.substring(0,keyForList.indexOf(":"));
											keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
											if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
											{
												orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
												keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
												if(orgColName!=null && orgColName.indexOf(":")>-1)
												{
													funcName=orgColName.substring(orgColName.indexOf(":")+1);
													orgColName = orgColName.substring(0,orgColName.indexOf(":"));

													if(funcName!=null && funcName.indexOf(":")>-1)
													{
														dispName=funcName.substring(funcName.indexOf(":")+1);
														funcName = funcName.substring(0,funcName.indexOf(":"));
													}
												}
											}
										}

										if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && listOfTest.contains(keyTest))
										{
											break;
										}
									}
								}
							}

							String colKeyName = Dbdata.getColumnForMeasure(keyTest+"_DDD",orgColName);
							String tmpK = colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort;
							Value=(String)measureValues.get(colKeyName+"^"+info_to_lower+"^"+compNameWithOutPort);
							if(Value==null)
							{
								Value=(String)measureValues.get(colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
							}
						}
						else if(isShowUserLocation && isLocationColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest = keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure = keyForList.substring(keyForList.indexOf(":")+1);
							}

							funcName ="NONE";

							if(keyMeasure!=null && keyMeasure.trim().length()>0)
							{
								keyMeasureList = StringUtils.egTokenizer(keyMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(keyMeasureList!=null && keyMeasureList.size()>0)
								{
									int meaListSize=keyMeasureList.size();
									if(meaListSize==1)
									{
										locKeyName = (String)keyMeasureList.get(0);
									}
									else if(meaListSize>1)
									{
										locKeyName = (String)keyMeasureList.get(0);
									}

									Value=(String)measureValues.get(locKeyName+"^"+info_to_lower+"^"+compNameWithOutPort);

									if(Value==null)
									{
										Value=(String)measureValues.get(locKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
									}

									if(meaListSize==1 && strSeparator!=null && strSeparator.trim().length()>0 && strReplaceSep!=null && strReplaceSep.trim().length()>0 && Value!=null && !Value.equals("-"))
									{
										Value = com.egurkha.util.StringUtils.replace(Value,strSeparator,strReplaceSep);
									}
								}
							}
						}
						else
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									keydisplayMeasure=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure=keyMeasure.substring(0,keyMeasure.indexOf(":"));
								}
							}
							units=tablesInfo.getUnitForMeasure(keyTest,keyMeasure);
							keyOrgMeasure = keyMeasure;
							keyMeasure = Dbdata.getColumnForMeasure(keyTest,keyMeasure);
							if(specsInfo.isTestRelevantForServer(compValue,keyTest))
							{
								Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
								if(Value==null){
									Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
								}
							}
						}

						//if((Value==null || Value.trim().length()==0) && compValue!=null && compValue.equals("Xen_desktop_server"))
						if(Value==null || Value.trim().length()==0)
						{
							if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
							{
								ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(tokenList!=null && tokenList.size()==2)
								{
									info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
								}
							}
							Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
							if(Value==null)
							{
								Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
							}
						}
						
						String mes_state="";
						String mes_name="";
						String total_spc="0";

						if(Value!=null && Value.indexOf("^")>-1)
						{
							mes_state=Value.substring(Value.indexOf("^")+1);
							if(mes_state!=null && mes_state.indexOf("^")>-1)
							{
								mes_name=mes_state.substring(mes_state.indexOf("^")+1);
								mes_state=mes_state.substring(0,mes_state.indexOf("^"));
								if(mes_name!=null && mes_name.indexOf("^")>-1)
								{
									total_spc=mes_name.substring(mes_name.indexOf("^")+1);
									mes_name=mes_name.substring(0,mes_name.indexOf("^"));
								}
							}
							Value=Value.substring(0,Value.indexOf("^"));
						}
						else if(Value==null)
						{
							Value="-";
							mes_name=keyMeasure;
							mes_state="GOOD";
						}

						boolean sameLabelFlag=false;
						if(sameLabelHash!=null && sameLabelHash.size()>0 && keydisplayMeasure!=null && sameLabelHash.containsKey(keydisplayMeasure))
						{
							ArrayList tmpArry=(ArrayList)sameLabelHash.get(keydisplayMeasure);

							if(tmpArry!=null && tmpArry.size()>0 && keyForList!=null && tmpArry.contains(keyForList))
								tmpArry.remove(keyForList);

							if(tmpArry!=null && tmpArry.size()>0)
							{
								sameLabelFlag=true;
								if(!dashboardModel.isTestActive(compValue, compName, keyTest, "custom"))
									Value="-";
							}
						}

						if((Value==null || Value.equals("-")) && sameLabelFlag && (sameLabelHash!=null && sameLabelHash.size()>0 && sameLabelHash.containsKey(keydisplayMeasure)))
						{
							ArrayList tmpArry=(ArrayList)sameLabelHash.get(keydisplayMeasure);

							if(tmpArry!=null && tmpArry.size()>0 && keyForList!=null && tmpArry.contains(keyForList))
								tmpArry.remove(keyForList);

							if(tmpArry!=null && tmpArry.size()>0)
							{
								for(int kk=0;kk<tmpArry.size();kk++)
								{
									keyForList =(String)tmpArry.get(kk);
									String tmp_keyTest=null;
									String tmp_keyMeasure=null;
									String tmp_keydisplayMeasure=null;
									if(keyForList!=null && keyForList.indexOf(":")>-1)
									{
										tmp_keyTest=keyForList.substring(0,keyForList.indexOf(":"));
										tmp_keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
										if(tmp_keyMeasure!=null && tmp_keyMeasure.indexOf(":")>-1)
										{
											tmp_keydisplayMeasure=tmp_keyMeasure.substring(tmp_keyMeasure.indexOf(":")+1);
											tmp_keyMeasure=tmp_keyMeasure.substring(0,tmp_keyMeasure.indexOf(":"));
										}
									}
									
									String tmp_units=tablesInfo.getUnitForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_keyOrgMeasure = tmp_keyMeasure;
									tmp_keyMeasure = Dbdata.getColumnForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_Value=null;
									if(specsInfo.isTestRelevantForServer(compValue,tmp_keyTest))
									{
										tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
										if(tmp_Value==null){
											tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
										}
									}

									if(tmp_Value==null || tmp_Value.trim().length()==0)
									{
										if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
										{
											ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
											if(tokenList!=null && tokenList.size()==2)
											{
												info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
											}
										}
										tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
										if(tmp_Value==null)
										{
											tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
										}
									}

									if(tmp_Value!=null && tmp_Value.indexOf("^")>-1)
									{
										String tmp_mes_state=tmp_Value.substring(tmp_Value.indexOf("^")+1);
										String tmp_total_spc=null;
										String tmp_mes_name=null;
										if(tmp_mes_state!=null && tmp_mes_state.indexOf("^")>-1)
										{
											tmp_mes_name=tmp_mes_state.substring(tmp_mes_state.indexOf("^")+1);
											tmp_mes_state=tmp_mes_state.substring(0,tmp_mes_state.indexOf("^"));
											if(tmp_mes_name!=null && tmp_mes_name.indexOf("^")>-1)
											{
												total_spc=tmp_mes_name.substring(tmp_mes_name.indexOf("^")+1);
												tmp_mes_name=tmp_mes_name.substring(0,tmp_mes_name.indexOf("^"));
											}
										}
										tmp_Value=tmp_Value.substring(0,tmp_Value.indexOf("^"));

										if(tmp_Value!=null && !tmp_Value.trim().equals("-"))
										{
											keyTest=tmp_keyTest;
											keyMeasure=tmp_keyMeasure;
											Value=tmp_Value;
											total_spc= tmp_total_spc;
											mes_name=tmp_mes_name;
											mes_state=tmp_mes_state;
											break;
										}
									}
								}
							}
						}

						widthOfTheHead="60";
						if(units!=null && units.equals("%")) 
							widthOfTheHead="150";
						
						String orgValue="0.0";
						try
						{
							if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}

								Value=String.valueOf(Value);
							}
							else if(Value!=null && Value.trim().length()>0  && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}

								Value=String.valueOf(Value);
							}
						}
						catch(Exception ee)
						{
							Value=Value;
							orgValue=Value;
						}
						if(mes_state!=null && mes_state.length()>0 && mes_state.equalsIgnoreCase("NONE"))
						{
							mes_state="GOOD";
						}
						else if(mes_state!=null && mes_state.trim().length()==0)
						{
							mes_state="GOOD";
						}
						if(Value.equalsIgnoreCase("on"))
						{
							buf.append("<td style=\"border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn \"><img  src=\"/final/monitor/eg_images/yes2.gif\"></td>"); 
						}
						else if(Value.equalsIgnoreCase("off"))
						{
							buf.append("<td style=\"border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn\"><img  src=\"/final/monitor/eg_images/no2.gif\"></td>");
						}
						else
						{
							String measuresLink = "";
							if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
							{
								String layerName = tablesInfo.getRelevantLayer(compValue,keyTest,keyOrgMeasure);
								layerName=(layerName==null || layerName.trim().length()==0)?ctype_layer:layerName;
								
								String infoKey = compValue+":"+compName+":"+keyTest+":"+info_to_lower;
								HashSet infosSet = null;
								if(fullInfoHash!=null && fullInfoHash.size()>0)
									infosSet = (HashSet)fullInfoHash.get(infoKey);
								ArrayList infosList = null;
								if(infosSet!=null && infosSet.size()>0)
									infosList = new ArrayList(infosSet);
								String info_name = "";
								if(infosList!=null && infosList.size()>1)
								{
									for(int is=0;is<infosList.size();is++)
									{
										String tmpInfo = (String)infosList.get(is);
										if(tmpInfo!=null && (tmpInfo.endsWith(":Summary") || tmpInfo.endsWith(":Total")))
										{
											info_name = tmpInfo;
											break;
										}
									}
									if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
									{
										info_name = (String)infosList.get(0);
									}
								}
								else if(infosList!=null && infosList.size()==1)
								{
									info_name = (String)infosList.get(0);
								}
								if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
								{
									info_name = "+" + info_to_lower;
								}
								measuresLink = "/final/monitor/EgSiteInfraView.jsp?qctr=2"+"&site=NULL"+"&fromalarm=0"+"&newWindow=false"+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comptype="+compValue+"&layer="+layerName+"&test="+keyTest+"-"+EgURLEncoder.encode(info_name,"UTF-8")+"&tstate="+mes_state+"&toDashBoardLayer=true";
								if(filterBy!=null && filterBy.trim().length()>0)
								{
									measuresLink=measuresLink+"&filterBy="+filterBy;
								}
								if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
								{
									measuresLink=measuresLink+"&priorityFilter="+priorityFilter;
								}
							}

							if(mes_name!=null)
							{
								if(Value!=null && !Value.equals("-"))
								{
									try
									{
										double fillColorValue=Double.parseDouble(orgValue);
										if(units!=null && units.equals("MB"))
										{
											//units = "GB";
											fillColorValue=fillColorValue/1024.0;
										}
										Value=String.valueOf(fillColorValue);
										//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
										{
											if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
											}
											else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value = getConvertDays(Value,egDashboard);
											}
											else
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
											}
										}
										else
										{
											Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										}

									}
									catch(Exception ee)
									{
										Value=String.valueOf(orgValue);
									}

									if(isDDDTestColumn || isLocationColumn)
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
											buf.append("<td align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding-left:8px;padding-top:7px;border:none\">");
											buf.append("<table cellspacing=\"0\" cellpadding=\"0\"  style=\"table-layout:auto;font-size:11px;margin-top:-5px\" border=\"0\" borderColor=\"blue\" align=\"left\">");
										}
										else
										{
											//buf.append("<td  align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding-right:10px;padding-top:7px;border:none\">");
											buf.append("<td  align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding-right:8px;padding-right:8px;padding-top:7px;border:none\">");
											buf.append("<table cellspacing=\"0\" cellpadding=\"0\"  style=\"table-layout:auto;font-size:11px;margin-top:-5px\" border=\"0\" borderColor=\"blue\" align=\"right\">");
										}
									}
									else
									{
											//buf.append("<td  align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding-right:10px;padding-top:7px;border:none\">");
											buf.append("<td  align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn \"  style=\"padding-left:8px;padding-right:8px;padding-top:7px;border:none\">");
											buf.append("<table cellspacing=\"0\" cellpadding=\"0\"  style=\"table-layout:auto;font-size:11px;margin-top:-5px\" border=\"0\" borderColor=\"blue\" align=\"center\">");
									}
												buf.append("<tr style=\"background:none !important\">");
									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
											{
													buf.append("<td class=\"mouse\" align=\"left\" style=\"text-align:left;\" >");
											}
											else
											{
													buf.append("<td class=\"mouse\" align=\"right\" style=\"text-align:right;\"  >");
											}
										}
										else
										{
													buf.append("<td class=\"mouse\" align=\"right\" onClick=\"javascript:goToDetails('"+measuresLink+"');\">");
										}
									}
									else
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
											{
												buf.append("<td align=\"left\" style=\"text-align:left;\">");
											}
											else
											{
												buf.append("<td align=\"right\" style=\"text-align:right;\">");
											}
										}
										else
										{
												buf.append("<td align=\"right\">");
										}
									}
								}
								else
								{
									if(isDDDTestColumn || isLocationColumn)
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
											buf.append("<td  style=\"padding-left:8px;border:none;text-align:left;\" align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \" >");
											if(Value.trim().equalsIgnoreCase("-"))
											{
												buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
											}
											else
											{
												buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"left\">");
											}
										}
										else
										{
											buf.append("<td  style=\"border:none;text-align:left;\" align=\"left\" class=\"x-grid-cell x-grid-cell-gridcolumn \" >");
												buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
										}
									}
									else
									{
										//buf.append("<td  style=\"border:none;padding-right:8px;\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn \" >");
										buf.append("<td  style=\"border:none;padding-left:8px;padding-right:8px;\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn \" >");

										boolean usage =true;
										if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
										{
											usage =false;
											buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
										}
										else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
										{
											buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
										}
										else
										{
											buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
										}
									}

									buf.append("<tr style=\"background:none !important\">");

									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											buf.append("<td align=\"left\" style=\"padding-right:10px;text-align:left;\">");
										}
										else
										{
											if(!Value.trim().equalsIgnoreCase("-"))
												buf.append("<td class=\"mouse\" align=\"left\" style=\"padding-right:10px\" onClick=\"javascript:goToDetails('"+measuresLink+"');\">");
										}
									}
									else
									{
										buf.append("<td align=\"left\" style=\"padding-right:10px\">");
									}
								}
							}
							else
							{
								buf.append("<td  style=\"padding-top:4px;border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-last\" >");
									buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"right\">");
										buf.append("<tr style=\"background:none !important\">");

											if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
											{
												if(isDDDTestColumn || isLocationColumn)
												{
													buf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
												}
												else
												{
													buf.append("<td class=\"mouse\" align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" >");
												}
											}
											else
											{
												buf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
											}
							}
							Value = formatDbValue(Value);
							//buf.append(Value+"</td>");
							if(isDDDTestColumn||isLocationColumn)
							{
								if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
								{
									buf.append("<td style=\"text-align:left;\">");
								}
								else
								{
									buf.append("<td style=\"text-align:right;padding-left:5px;\">");
								}
							}
							else
							{
								if(!Value.trim().equalsIgnoreCase("-"))
									buf.append("<td style=\"text-align:right;padding-left:0px;\" >");
							}
							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
								{
									usage = false;
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value1 = (fillColorValue*100)/columnWidth;
													buf.append("<div onClick=\"javascript:goToDetails('"+measuresLink+"');\" class=\"prog_border mouse\">");
														//buf.append("<tr`>");
															//buf.append("<td align=\"left\" width=\"100%\" height=\"6\" //class=\"prog_line\">");
																//buf.append("<div style=\"width:"+value1+"% !important;display:block;z-index:25000;height:6px\" class =\"progress_"+mes_state+"\"  height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
																buf.append("<div style=\"width:"+value1+"% !important;display:block;z-index:25000;height:6px\" class =\"bar12_"+mes_state+"\"  height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
																		//buf.append("<div width=\"100%\" style=\"border:0px solid yellow;display:block;z-index:25000;height:6px\"></div>");
																buf.append("</div>");
															//buf.append("</td>");
														//buf.append("</tr>");
													buf.append("</div>");
								}
								else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
								{
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value2 = (fillColorValue*100)/columnWidth;

													buf.append("<div onClick=\"javascript:goToDetails('"+measuresLink+"');\" class=\"prog_border mouse\">");
														//buf.append("<tr`>");
															//buf.append("<td align=\"left\" width=\"100%\" height=\"6\" //class=\"prog_line\">");
																//buf.append("<div style=\"width:"+value2+"% !important;display:block;z-index:25000;height:6px\" class =\"progress_"+mes_state+"\"  height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
																buf.append("<div style=\"width:"+value2+"% !important;display:block;z-index:25000;height:6px\" class =\"bar12_"+mes_state+"\"  height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
																		//buf.append("<div width=\"100%\" style=\"border:0px solid yellow;display:block;z-index:25000;height:6px\"></div>");
																buf.append("</div>");
															//buf.append("</td>");
														//buf.append("</tr>");
													buf.append("</div>");
								}
							}
												buf.append("</td>");

							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								if(isDDDTestColumn || isLocationColumn)
								{
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
													buf.append("<td style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap;\"  >"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
													buf.append("<td style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap;\"  >"+Value+"</td>");
									}
									else
									{
										if(isLocationColumn)
										{
											if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
											{
														buf.append("<td style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap;\"  data-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><div style=\"width:120px;text-align:left;overflow:hidden;text-overflow:ellipsis;white-space:nowrap\">"+Value+"</div></td>");
											}
											else
											{
														//buf.append("<td style=\"text-align:right;padding-left:3px;width:42px;white-space:nowrap;\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><div style=\"width:120px;text-align:left;overflow:hidden;text-overflow:ellipsis;white-space:nowrap\">"+Value+"</div></td>");
														buf.append("<td style=\"text-align:center;width:42px;white-space:nowrap;\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><div style=\"width:120px;text-align:left;overflow:hidden;text-overflow:ellipsis;white-space:nowrap\">"+Value+"</div></td>");
											}

										}
										else
										{
											if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
											{
														buf.append("<td style=\"text-align:left;padding-left:3px;width:42px;text-overflow:ellipsis;white-space:nowrap;\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><div style=\"width:120px;text-align:left;overflow:hidden;text-overflow:ellipsis;white-space:nowrap\">"+Value+"</div></td>");
											}
											else
											{
														buf.append("<td style=\"text-align:right;padding-left:3px;width:42px;text-overflow:ellipsis;white-space:nowrap;\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><div style=\"width:120px;text-align:left;overflow:hidden;text-overflow:ellipsis;white-space:nowrap\">"+Value+"</div></td>");
											}
										}
									}
								}
								else
								{
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
													buf.append("<td class=\"mouse\" style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap;\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
													buf.append("<td class=\"mouse\" style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap;\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\">"+Value+"</td>");
									}
									else
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
													buf.append("<td class=\"mouse\" style=\"text-align:left;padding-left:3px;width:42px;white-space:nowrap;\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\" ><table border='0'><tr style='background:none !important'><td><img class=\"stateSymbol_"+mes_state+"\" src=\"/final/images/clear.png\" border=\"0\" style=\"vertical-align:bottom\"/></td><td>"+Value+"</td></tr></table></td>");
										}
										else
										{
													//buf.append("<td class=\"mouse\" style=\"text-align:right;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap;\" onClick=\"javascript:goToDetails('"+measuresLink+"');\">"+Value+"</td>");
													buf.append("<td class=\"mouse\" style=\"text-align:center;width:42px;white-space:nowrap;\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" data-qtip=\""+Value+"\" data-qclass=\"yellowTip\"><table border='0'><tr style='background:none !important'><td><img class=\"stateSymbol_"+mes_state+"\" src=\"/final/images/clear.png\" border=\"0\" style=\"vertical-align:bottom\"/></td><td style=\"white-space:nowrap;\">"+Value+"</td></tr></table></td>");
										}
									}
								}
							}
							else
							{
								if(isDDDTestColumn || isLocationColumn)
								{
									buf.append("<td style=\"text-align:center;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap;\">"+Value+"</td>");
								}
								else
								{
									boolean usage =true;
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
										if(Value.trim().equalsIgnoreCase("-"))
										{
											buf.append("<td style=\"text-align:center;width:42px;white-space:nowrap;\">"+Value+"</td>");
										}
										else
										{
											buf.append("<td style=\"text-align:center;width:42px;padding-right:30px;white-space:nowrap;\">"+Value+"</td>");
										}
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
										if(Value.trim().equalsIgnoreCase("-"))
										{
											buf.append("<td style=\"text-align:center;width:42px;white-space:nowrap;\">"+Value+"</td>");
										}
										else
										{
											buf.append("<td style=\"text-align:center;width:42px;padding-right:30px;white-space:nowrap;\">"+Value+"</td>");
										}
									}
									else
									{
										if(Value.trim().equalsIgnoreCase("-"))
										{
											buf.append("<td style=\"text-align:center;width:42px;white-space:nowrap;\">"+Value+"</td>");
										}
										else
										{
											buf.append("<td style=\"text-align:right;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap;\">"+Value+"</td>");
										}
									}
								}
							}
											buf.append("</tr>");
										buf.append("</table>");
									buf.append("</td>");
						}
						p++;
					}
				}
				else
				{
					int p=0;
					while(p<measureList.size())
					{
						String keyForList=(String)measureList.get(p);
						StringTokenizer valTokens = new StringTokenizer(keyForList,":");
						int tokCount = valTokens.countTokens();
						boolean isDDDTestColumn = false;
						boolean isLocationColumn = false;

						if(tokCount==5)
							isDDDTestColumn = true;
						else if(tokCount==2)
							isLocationColumn = true;

						buf.append("<td  style=\"padding-top:4px;border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-last\" >");
						if(isDDDTestColumn || isLocationColumn)
						{
							buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"left\">");
						}
						else
						{
							buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"right\">");
						}
								buf.append("<tr style=\"background:none !important\">");
									//buf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:20px\"></td>");

									if(isDDDTestColumn || isLocationColumn)
									{
										buf.append("<td style=\"text-align:center;padding-left:23px;padding-right:38px;width:42px;white-space:nowrap;\">-</td>");
									}
									else
									{
										buf.append("<td style=\"text-align:right;padding-left:3px;padding-right:38px;width:42px;white-space:nowrap;\">-</td>");
									}
							buf.append("</tr>");
						buf.append("</table>");
						buf.append("</td>");

						//buf.append("<td style=\"font-size:11px;text-align:right;width:20px;padding-right:10px;!important\" align=\"right\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\">-</td>"); 
						/*buf.append("<td  style=\"padding-top:4px;border:none\" align=\"center\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\" >");
							buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"right\">");
								buf.append("<tr style=\"background:none !important\">");
									//buf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
									//buf.append("</td>");
									//buf.append("<td style=\"text-align:right;padding-right:15px;width:20px;\">");
									buf.append("<td style=\"text-align:right;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap;\">");
									buf.append("-</td>");
								buf.append("</tr>");
							buf.append("</table>");
						buf.append("</td>");*/
						p++;
					}
				}
				buf.append("</tr>");
				isDataAvailable = true;
			}
								buf.append("</tbody>");
							buf.append("</table>");
						buf.append("</div>");
					buf.append("</td>");
				buf.append("</tr>");
			buf.append("</table>");
			if(desktopsSize==0)
			{
				buf.append("<table border=\"0\" width=\"100%\" height=\"90%\" bordercolor=\"green\">");
					buf.append("<tr style=\"background:none\">");
						buf.append("<td align=\"center\" width=\"100%\" height=\"100%\" class=\"commonErrorMsgText\" >");
							buf.append("<img src = \"/final/images/spacer.gif\" class=\"iconExclamation\" lign = \"center\" border = \"0\"  vspace = \"10\"/>");
							buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No records available for this combination of parameters"));
						buf.append("</td>");
					buf.append("</tr>");
				buf.append("</table>");
				isDataAvailable = false;
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
				jsonRoot.put("header_display",header_display);
			}
			int pageLimit = 0;
			try
			{
				pageLimit = Integer.parseInt(priority);
			}
			catch(Exception e)
			{
				pageLimit = vdiDesktopsListTotalCount;
			}
			if(vdiDesktopsListTotalCount>pageLimit)
			{
				int pages = vdiDesktopsListTotalCount/pageLimit;
				if(vdiDesktopsListTotalCount%pageLimit!=0)
					pages +=1;

				buf.append("<form id=\"pagination\" name=\"pagination\">");
					buf.append("<table border=\"0\" style=\"margin:5px 0 0 7px;padding:3px\" class=\"uxPageText\">");
						buf.append("<tr>");
						if(pageNo>1)
						{
							buf.append("<td>");
								//buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage("+1+");return false;\" name=\"First\" id=\"First\"><< First</button>");
								buf.append("<img data-qtip=\"First Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+1+","+pages+");return false;\" class=\"uxpagingtoolbar-first\"/>");
							buf.append("</td>");

							buf.append("<td style=\"padding-right:10px\">");
								//buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage("+(pageNo-1)+");return false;\" name=\"Previous\" id=\"Previous\">< Previous</button>");
									buf.append("<img data-qtip=\"Previous Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+(pageNo-1)+","+pages+");return false;\" class=\"uxpagingtoolbar-prev\"/>");
							buf.append("</td>");					
						}
						buf.append("<td style=\"padding-right:3px\">");
							buf.append("Page");
						buf.append("</td>");
						buf.append("<td>");
						int currPage = pageNo;
						if(currPage==0)currPage++;
							buf.append("<input style=\"width:35px;margin-right:2px\" class=\"uxTextbox\" type=\"text\" name=\"pageNo\" id=\"pageNo\" value=\""+currPage+"\" onKeyDown=\"javascript:if((event.keyCode=='13') || (event.keyCode=='32')){goToPage(this.form.pageNo.value,"+pages+");return false;}else{return true;}\">");
						buf.append("</td>");
						buf.append("<td style=\"display:none;padding-right:15px\">");
							buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage(this.form.pageNo.value,"+pages+");return false;\" name=\"Go\" id=\"Go\">Go</button>");
						buf.append("</td>");
						buf.append("<td style=\"padding-right:3px;padding-top:0px\">");
							buf.append("of "+pages);
						buf.append("</td>");					

						/*for(int pageCount=1;pageCount<=pages;pageCount++)
						{
							if(pageNo==pageCount)
								buf.append("<td class=\"uxPageCount\" >");
							else
								buf.append("<td >");
								
								buf.append("<a href=\"javascript:void(0);\" onClick=\"javascript:goToPage("+pageCount+");\">"+pageCount+"</a>");
							buf.append("</td>");
						}*/

						if(pageNo!=pages)
						{	
							if(pageNo==0)
								pageNo = 1;

							buf.append("<td style=\"padding-left:10px\">");
								//buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage("+(pageNo+1)+");return false;\" name=\"First\" id=\"First\">Next ></button>");
								buf.append("<img data-qtip=\"Next Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+(pageNo+1)+","+pages+");return false;\" class=\"uxpagingtoolbar-next\"/>");
							buf.append("</td>");						
							if(vdiDesktopsListTotalCount>pageLimit)
							{							
								buf.append("<td>");
									//buf.append("<button class=\"uxButton\" onClick=\"javascript:goToPage("+pages+");return false;\" name=\"Last\" id=\"Last\">Last >></button>");
									buf.append("<img data-qtip=\"Last Page\" data-qclass=\"yellowTip\" src=\"/final/images/clear.png\" onClick=\"javascript:goToPage("+pages+","+pages+");return false;\" class=\"uxpagingtoolbar-last\"/>");
								buf.append("</td>");
							}						
						}

						buf.append("</tr>");
					buf.append("</table>");
				buf.append("</form>");
			}
			jsonRoot.put("GRID_DATA",buf.toString());
			jsonRoot.put("FIlTER",fil);
			jsonRoot.put("isDataAvail",isDataAvailable);
			if(enableBackButton!=null && !enableBackButton.equalsIgnoreCase("null") && enableBackButton.trim().length()>0)
				jsonRoot.put("enableBackButton",enableBackButton); 
		}
	}
	else
	{
		int col_span=measureList.size();
				buf.append("<table border=\"0\" width=\"100%\" height=\"100%\" bordercolor=\"green\">");
					buf.append("<tr style=\"background:none\">");
						buf.append("<td align=\"center\" width=\"100%\" colspan=\""+col_span+"\" height=\"100%\" class=\"commonErrorMsgText\" >");
							buf.append("<img src = \"/final/images/spacer.gif\" class=\"iconExclamation\" lign = \"center\" border = \"0\"  vspace = \"10\"/>");
							buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found"));
						buf.append("</td>");
					buf.append("</tr>");
				buf.append("</table>");
		jsonRoot.put("GRID_DATA",buf.toString());
		Hashtable tmpInfoSession = (Hashtable)session.getAttribute("tmpInfoSession");
		if(tmpInfoSession != null && tmpInfoSession.size() > 0)
		{
			Iterator it = tmpInfoSession.entrySet().iterator();
			while(it.hasNext()){
				Entry en = (Entry)it.next();
				Set set = (HashSet)en.getValue();
				ArrayList list = new ArrayList(set);
				if(list != null && list.size() > 0)
					fil.add((String)en.getKey());
			}
		}
		jsonRoot.put("FIlTER",fil);
		isDataAvailable = false;
		jsonRoot.put("isDataAvail",isDataAvailable);
		if(!isDataAvailable)
		{
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
			jsonRoot.put("header_display",header_display);
		}
	}
	String mngrIProc = new IniFile(new com.eg.EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String htmlFileName = mngrIProc + "/final/monitor/endUserDashboardDataPrint.jsp;jsessionid="+session.getId()+"?";
	int pdfPageWidth = 1100; 
	measuresCount= measuresCount + 2;

	if(measuresCount > 7 && measuresCount <= 10)
	{
		pdfPageWidth = 1600;
	}
	else if(measuresCount > 10 && measuresCount <= 20)
	{
		pdfPageWidth = 2400;
	}
	else if(measuresCount > 20)
	{
		pdfPageWidth = 3600;
	}
	session.setAttribute("UED_PDF_URL",htmlFileName);
	if(isEndUserOverview || isFromUEDSort)
		session.setAttribute("REPORT_NAME","UserExperienceOverview");
	else
		session.setAttribute("REPORT_NAME","UserExperienceDashboard");
	session.setAttribute("REPORT_LAYOUT","Landscape");
	session.setAttribute("PAGE_WIDTH_PDF",pdfPageWidth);
	//session.setAttribute("title","User Experience Dashboard");
	session.setAttribute("title","User Experience Overview");
	session.setAttribute("frmPage","UsrExpDash");
	if(isDataManagerLogin)
	{
		if(request.getQueryString()!=null)
		{
			String qry=request.getQueryString();
			qry=com.egurkha.util.StringUtils.replace(qry, "\\", "\\\\");
			session.setAttribute("monitorLastSession","/final/monitor/endUserDashboard.jsp?access=allusers&"+qry);
		}
		else
			session.setAttribute("monitorLastSession","/final/monitor/endUserDashboard.jsp?access=allusers");
	}
	
	response.getWriter().write(jsonRoot.toString());
}
catch(Throwable th)
{
	th.printStackTrace();
}

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
