package org.apache.jsp.monitor.qinsight;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.egurkha.UserRegistry;
import com.egurkha.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.egurkha.User;
import com.egurkha.monitor.EgQInsightView;
import com.egurkha.util.HtmlUtils;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.json.*;
import com.egurkha.util.StringUtils;
import com.eg.EgMappingInfo;

public final class EgQICopyServerMetricsJSON_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/qinsight/EgTrackerJSON.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("application/json; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");


	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	User u_ser = null;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin=null;
	if(session!=null)
	{
		 u_ser = UserRegistry.getInstance().getUser(session.getId());
		if(u_ser!=null)
		{
			id_u = u_ser.isIdDeletedWhileLoggedIn();
			if(id_u == false)
			{
				u_rs =  u_ser.getLoginID();
				if(!User.isDefaultUser(u_rs))
				{
					ErUserData er = u_ser.getReporterData();
					u_v_till = er.getUserValidtill();
					l_accessed = session.getLastAccessedTime();
				}
			}
		}
	}
	if(session == null || u_ser == null)
    {
        throw new Exception("<customerror>user-session-invalid</customerror>");
    }
    else if(id_u== true)
    {
        throw new Exception("<customerror>user-deleted</customerror>");
    }
    else if (u_v_till < l_accessed)
    {
        throw new Exception("<customerror>user-timedout</customerror>");
    }
	else
	{
		session.setAttribute("Page_IdentifierQI", request.getRequestURI());
	}
	if (u_ser!=null)
	{
		String trackerUserLang = u_ser.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
	}
	String  script_src="script_item_"+trackerLanguage+".js";


	JSONObject rootJSON = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String s_insightName = request.getParameter("view_name");
	if(s_insightName != null)
	{
		 s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"'","~#~");
		 s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"&","|amp|");
	}
	int tierPos = Integer.parseInt(request.getParameter("tier_position")) - 1 ;
	int serverPos = Integer.parseInt(request.getParameter("server_position")) - 1;

	User user = UserRegistry.getInstance().getUser(session.getId());
	EgQInsightView insightView = user.getQInsightView(s_insightName);
	int noOfServers = insightView.getNoOfServersPerTier();
	int noOfMetrics = insightView.getNoOfMetricsPerServer();
	String monHomePage=user.getMonitorHomePage();
	String s_tierName = insightView.getTierName(tierPos);
	String s_serverName = insightView.getServerName(tierPos,serverPos);

	com.egurkha.ini.IniUI uiObj = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = uiObj.getDefaultLanguage();

	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);


	Vector v_availMetrics = new Vector();
	Vector v_servers = new Vector();

	for(int i=0;i<noOfMetrics;i++)
	{
	if(insightView.isMetricUsed(tierPos,serverPos,i))
		v_availMetrics.add(insightView.getMetricName(tierPos,serverPos,i));
	}

	JSONObject availMetricsObj = new JSONObject();
	JSONObject availServersObj = new JSONObject();
	JSONArray availMetricsArray =new JSONArray();
	JSONArray availServersArray =new JSONArray();
    String str="";
	for(int j=0;j<v_availMetrics.size();j++)
	{
		str=(String)v_availMetrics.get(j);
		str=com.egurkha.util.StringUtils.replace(str,"~#~","'");
		availMetricsObj.put("displayField",str);
		availMetricsObj.put("valueField",(String)v_availMetrics.get(j));
		availMetricsArray.add(availMetricsObj);
	}

	for(int i=0;i<noOfServers;i++)
	{
	if(serverPos!=i && insightView.isServerUsed(tierPos,i))
		v_servers.add(insightView.getServerName(tierPos,i));
	}
   
	for(int j=0;j<v_servers.size();j++)
	{ 
		str=(String)v_servers.get(j);
		str=com.egurkha.util.StringUtils.replace(str,"~#~","'");
		availServersObj.put("displayField",str);
		availServersObj.put("valueField",(String)v_servers.get(j));
		availServersArray.add(availServersObj);
	}
    s_tierName=com.egurkha.util.StringUtils.replace(s_tierName,"~#~","'");
	rootJSON.put("tierName",s_tierName);
	s_serverName=com.egurkha.util.StringUtils.replace(s_serverName,"~#~","'");
	rootJSON.put("serverName",s_serverName);
	rootJSON.put("availMetricsArray",availMetricsArray);
	rootJSON.put("availServersArray",availServersArray);

	screenLabels.put("monitor.quickinsight.Tier name",mappingInfo.getTextDescription("monitor.quickinsight.Tier name"));
	screenLabels.put("monitor.quickinsight.Server name",mappingInfo.getTextDescription("monitor.quickinsight.Server name"));
	screenLabels.put("monitor.quickinsight.Available metrics",mappingInfo.getTextDescription("monitor.quickinsight.Available metrics"));
	screenLabels.put("monitor.quickinsight.Available servers",mappingInfo.getTextDescription("monitor.quickinsight.Available servers"));
	screenLabels.put("monitor.common.Update",mappingInfo.getTextDescription("monitor.common.Update"));
	rootJSON.put("screenLabels",screenLabels);

	out.println(rootJSON.toString());

	if(monHomePage!=null && monHomePage.trim().length()>0 && monHomePage.equals("Quick Insight"))
	{
		if(request.getQueryString()!=null)
		{
			session.setAttribute("monitorLastSession","/final/monitor/qinsight/EgQInsightHome.jsp?currentLoadingPage=EgQICopyServerMetrics&"+request.getQueryString());
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/qinsight/EgQInsightHome.jsp?currentLoadingPage=EgQICopyServerMetrics");
		}
	}

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
