package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.supermanager.*;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import com.egurkha.util.StringUtils;
import com.egurkha.util.DateUtil;
import java.sql.*;
import com.eg.EgDbInfo;
import egurkha.EgDbAdapterUI;
import com.eg.EgDbAdapterTypeUI;
import net.sf.json.*;

public final class sqlProcessJSON_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	public String forHTML(String resultStr)
	{
		while(resultStr.indexOf(">")  > 0){
			resultStr = resultStr.replace(">","&gt;");
		}
		while(resultStr.indexOf("\"") > 0){
			resultStr = resultStr.replace("\"","&quot;");
		}
		while(resultStr.indexOf("<")  > 0){
			resultStr = resultStr.replace("<","&lt;");
		}
		return resultStr;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgMonitorTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("application/json;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*******************************************************************************
*	File name		: sqlProcess.jsp
*	Purpose			: To show the MS-SQL & Sybase sys processes along with its details
*	Version			: eG 5.3.
*	Creation Date	: 15/03/2011
*	Modifed			: 15/07/2011	- Modified to Support Sybase sysprocess
*	Modifed			: 10/08/2011	- To Provide Support for Oracle Sessions & Oracle User connections
******************************************************************************/


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String mgrDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	boolean isMobileCall=false;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;	
	String fromMobile=request.getParameter("fromMobile");
	String isFromMenu=request.getParameter("isFromMenu");
	String dateFormatForDatePicker ="";

	User u_ser = null;
	EgMappingInfo mappingInfo = null;
	String trackerLanguage = trackerUI.getDefaultLanguage();
	/**
			 Operation - Mobile check
			 Purpose - Support for accessing the manager via mobile.
			 Author - Praveen 8/4/2014
	**/
	if (fromMobile!=null&&fromMobile.equals("yes"))
	{
		String uname=request.getParameter("uname");
		isMobileCall=true;
		try
		{
			ErUserData userData = new ErUserData(uname,false);
			if(userData!=null)
			{
				u_ser=userData.usr;
				if(u_ser==null)
				{
					u_ser = userData.getUser(uname);
				}
				if(u_ser!=null)
				{
					String userLang = u_ser.getLanguage();
					if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
					{
						trackerLanguage=userLang;
					}
					mappingInfo = new EgMappingInfo(trackerLanguage);
				}
			}
		}
		catch(Throwable t)
		{
			t.printStackTrace();
		}
	} // Ends here
	else
	{
		if(session.getAttribute("sessionId_SM") != null)
		{
			from_sm = true;
			sessionId_sm = (String)session.getAttribute("sessionId_SM");
		}
		if(session!=null)
		{
			if(from_sm)
			{
				u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
			}
			else
			{
				u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
			}
			if(u_ser!=null)
			{
				id_u = u_ser.isIdDeletedWhileLoggedIn();
				if(id_u == false)
				{
					u_rs =  u_ser.getLoginID();
					if(!User.isDefaultUser(u_rs))
					{
						ErUserData er = u_ser.getReporterData();
						u_v_till = er.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
		}
		if ( session != null || u_ser != null )
		{
			String smartValue=request.getParameter("smart");
			String page_help=request.getRequestURI();
			if(isFromMenu != null && isFromMenu.trim().length() > 0 && smartValue==null || (smartValue!=null && smartValue.trim().length()==0) )
			{
				if(!(page_help.endsWith("EgPrintGraph.jsp") || page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")))
					session.setAttribute("Page_IdentifierM", request.getRequestURI());
			}
		}

		if (u_ser!=null)
		{
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
			String trackerUserLang = u_ser.getLanguage();
			if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
			{
				trackerLanguage=trackerUserLang;
			}
		}
		mappingInfo = new EgMappingInfo(trackerLanguage);
		if(u_ser != null)
		{
			dateFormatForDatePicker = (String)u_ser.getUserDateFormat();
		}
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}

		if(session == null || u_ser == null)
		{
			throw new Exception("<customerror>user-session-invalid</customerror>");
		}
		else if(id_u== true)
		{
			throw new Exception("<customerror>user-deleted</customerror>");
		}
		else if (u_v_till < l_accessed)
		{
			throw new Exception("<customerror>user-timedout</customerror>");
		}
	}

//@ page errorPage = "EgProbsM.jsp" 
      egurkha.TransactionBean trans = null;
      synchronized (_jspx_page_context) {
        trans = (egurkha.TransactionBean) _jspx_page_context.getAttribute("trans", PageContext.PAGE_SCOPE);
        if (trans == null){
          trans = new egurkha.TransactionBean();
          _jspx_page_context.setAttribute("trans", trans, PageContext.PAGE_SCOPE);
        }
      }

try
{
	JSONObject rootJson = new JSONObject();
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	String data = request.getParameter("details");
	String measureTime = request.getParameter("time"); 
	String measure = request.getParameter("measure"); 
	String testname = request.getParameter("test"); 
	String measureName = null;
	String isTable="";
	isTable = isFirefox ? "Auto" : "Fixed";
	if( data.equals("None") )
	{
		rootJson.put("DATA","false");
		rootJson.put("MSG",mappingInfo.getTextDescription("monitor.layermodel.No details for this measure")+"!!");
	}
	else if(measure!=null && measure.length() > 0)
	{
		JSONArray tableArr = new JSONArray();
		JSONObject tableObj = new JSONObject();
		ArrayList displayList = StringUtils.egTokenizer(data,"#~#");
		boolean isMsSqlSysTest = false;
		boolean isMsSqlConnTest = false;
		boolean isSybSysTest = false;
		boolean isOraSessionTest = false;
		boolean isOraConnectionsTest = false;
		int dispSize = displayList.size();
		if(testname!=null && testname.length() > 0)
		{
			if(testname.equals("MsSqlSysProcsTest"))
				isMsSqlSysTest = true;
			else if(testname.equals("MsSqlConnsTest"))
				isMsSqlConnTest = true; 
			else if(testname.equals("SybSysProcessTest"))
				isSybSysTest = true;
			else if(testname.equals("OraSessionTest"))
				isOraSessionTest = true;
			else if(testname.equals("OraConnectionsTest"))
				isOraConnectionsTest = true;
		}

		int index = 0;
		String Spid = null;
		String User = null;
		String DB = null;
		String Host = null;
		String Program = null;
		String Login = null;
		String LastBatch = null;
		String Waittime= null;
		String Waittype = null;
		String SpidBlocking = null;
		String Trans = null;
		String Phy = null;
		String Mem = null;
		String Idletime = null;
		String LastCmd = null;
		String status = null;
		String cpu =  null;
		String blockedTime = null;
		String Serial = null;
		String OsUser = null;
		String Terminal = null;
		String Module = null;
		String LastCall = null;

		if(isMsSqlSysTest || isMsSqlConnTest)
		{
			Spid = (String)displayList.get(index++);
			if(isMsSqlSysTest){
				User = (String)displayList.get(index++);
			}
			DB = (String)displayList.get(index++);
			Host = (String)displayList.get(index++);
			Program = (String)displayList.get(index++);
			Login = (String)displayList.get(index++);
			LastBatch = (String)displayList.get(index++);
			Waittime= (String)displayList.get(index++);
			Waittype = (String)displayList.get(index++);
			SpidBlocking = (String)displayList.get(index++);
			Trans = (String)displayList.get(index++);
			Phy = (String)displayList.get(index++);
			Mem = (String)displayList.get(index++);
			Idletime = (String)displayList.get(index++);
			LastCmd = (String)displayList.get(index++);
		}
		else if(isSybSysTest)
		{
			Spid = (String)displayList.get(index++);
			status = (String)displayList.get(index++);
			User = (String)displayList.get(index++);
			DB = (String)displayList.get(index++);
			Host = (String)displayList.get(index++);
			Program = (String)displayList.get(index++);
			SpidBlocking = (String)displayList.get(index++);
			blockedTime = (String)displayList.get(index++);
			cpu	= (String)displayList.get(index++);
			Phy = (String)displayList.get(index++);
			Mem = (String)displayList.get(index++);
			LastCmd = (String)displayList.get(index++);
		}
		else if(isOraSessionTest || isOraConnectionsTest)
		{
			Spid = (String)displayList.get(index++);
			Serial = (String)displayList.get(index++);
			if(isOraSessionTest)
				User = (String)displayList.get(index++);
			OsUser = (String)displayList.get(index++);
			Host = (String)displayList.get(index++);
			Terminal = (String)displayList.get(index++);
			Program = (String)displayList.get(index++);
			Module = (String)displayList.get(index++);
			LastCall = (String)displayList.get(index++);
			SpidBlocking = (String)displayList.get(index++);
			LastCmd = (String)displayList.get(index++);
		}

		boolean isLink = false;
		StringBuffer resultBuffer = new StringBuffer();
		//out.println("measure :"+ measure);
		int blockingValue = 0;
		if(SpidBlocking!=null && SpidBlocking.length() > 0)
		{
			try
			{
				blockingValue = Integer.parseInt(SpidBlocking);
			}
			catch(Exception e)
			{
				blockingValue = 0;
			}
		}

		if(blockingValue > 0)
		{
			isLink = true;
		}

		if(isLink)
		{
			IniFile UIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini", false);
			String currentDateFormat = UIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
			String date = measureTime.substring(0,measureTime.indexOf(" "));
			date = DateUtil.changeDateFormat(date,currentDateFormat,"MM/dd/yyyy");
			String time = measureTime.substring(measureTime.indexOf(" ")+1);
			if(time!=null && time.endsWith(".0"))
				time = time.substring(0,time.lastIndexOf("."));
			String dbMeasureTime = date+" "+time;

			StringBuffer sb = new StringBuffer();
			StringBuffer adapterTypeBuffer = new StringBuffer();

			if(EgDbInfo.checkDBType().equals("EgMsSqlAdapter"))
			{
				adapterTypeBuffer.append(" where MSMT_TIME = CONVERT (datetime, '");
				adapterTypeBuffer.append(dbMeasureTime);
				adapterTypeBuffer.append("', 103)"); 
			}
			else
			{
				adapterTypeBuffer.append(" where MSMT_TIME = TO_DATE('");
				adapterTypeBuffer.append(dbMeasureTime);
				adapterTypeBuffer.append("','MM/DD/YYYY HH24:MI:SS')");
			}

			if(isMsSqlSysTest || isMsSqlConnTest)
			{
				sb.append("select SEQ_NO, MSMT_TIME, MEASURE,SPID,");
				if(isMsSqlSysTest){
					sb.append("USER_NAME,");
				}
				sb.append(" DB_NAME, HOST_NAME, PROGRAM_NAME, LOGIN_TIME, LAST_EXE_TIME, WAIT_TIME, WAIT_TYPE, BLOCKING_SPID, OPEN_TRANS,PHYSICAL_IO,MEM_USAGE,IDLE_TIME,COMMAND from ");
				if(isMsSqlConnTest)
					sb.append(" MsSqlConnsTest_DDD");
				else
					sb.append(" MsSqlSysProcsTest_DDD");
				sb.append(adapterTypeBuffer.toString());
				sb.append(" and spid = '"+SpidBlocking+"'");
				sb.append(" ORDER BY SEQ_NO ASC");
			}
			else if(isSybSysTest)
			{
				sb.append("select SEQ_NO, MSMT_TIME, MEASURE,SPID,STATUS,USER_NAME,DB_NAME,HOST_NAME,PROGRAM_NAME,BLOCKING_SPID,TIME_BLOCKED,CPU,PHYSICAL_IO,MEM_USAGE,COMMAND from ");
				sb.append(" SybSysProcessTest_DDD ");
				sb.append(adapterTypeBuffer.toString());
				sb.append(" and spid = '"+SpidBlocking+"'");
				sb.append(" ORDER BY SEQ_NO ASC");
			}
			else if(isOraSessionTest || isOraConnectionsTest)
			{
				sb.append("SELECT SEQ_NO, MSMT_TIME, MEASURE , SID ,SERIAL ,");
				if(isOraSessionTest)
					sb.append(" USER_NAME, ");
				sb.append("OS_USER, MACHINE_NAME , TERMINAL_NAME, PROGRAM_NAME , MODULE , LAST_CALL, BLOCKING_SPID , COMMAND FROM ");
				if(isOraSessionTest)
					sb.append(" OraSessionTest_DDD ");
				else
					sb.append(" OraConnectionsTest_DDD ");
				sb.append(adapterTypeBuffer.toString());
				sb.append(" and SID = '"+SpidBlocking+"'");
				sb.append(" ORDER BY SEQ_NO ASC");
			}
			String query = sb.toString();
			//System.out.println("query (Sql Process):"+query);

			EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
			try
			{
				String s_status = egDb.setConnection();
				if(s_status.equals("CONNECTED"))
				{
					ResultSet rs = egDb.dbselect(query);
					ResultSetMetaData md = rs.getMetaData();
					int columns = md.getColumnCount();

					int segNo = -1;
					boolean isEnd = false;
					//if(isMsSqlSysTest || isMsSqlConnTest || isSybSysTest )
					//{
						while(rs.next())
						{
							int row = rs.getRow();
							if(row == 1)
							{
								for(int i=1;i<=columns;i++)
								{
									String colName = md.getColumnName(i);
									if(colName.equalsIgnoreCase("SEQ_NO"))
									{
										segNo= rs.getInt(colName);
									}
									else if(colName.equalsIgnoreCase("Measure"))
									{
										measureName = (String)rs.getObject(colName);
									}
									else if(colName.equalsIgnoreCase("command"))
									{
										String command = (String)rs.getObject(colName);
										if(command!=null && command.endsWith("~#~"))
										{
											command = command.substring(0,command.lastIndexOf("~#~"));
											resultBuffer.append(command);
										}
										else
										{
											resultBuffer.append(command);
											isEnd = true;
										}
									}
									else if(i>3)
									{
										String resultData = rs.getObject(colName).toString();
										resultBuffer.append(resultData);
										resultBuffer.append("#~#");
									}
								}
							}
							else
							{
								int nextSegNo = rs.getInt("SEQ_NO");
								String nextMeasure  = (String)rs.getObject("Measure");
								if(nextSegNo == (segNo+1) && nextMeasure.equals(measureName))
								{
									String command = (String)rs.getObject("command");
									if(command!=null && command.endsWith("~#~"))
									{
										command = command.substring(0,command.lastIndexOf("~#~"));
										resultBuffer.append(command);
										segNo = nextSegNo;
									}
									else
									{
										resultBuffer.append(command);
										isEnd = true;
									}
								}
								else
								{
									isEnd = true;
								}
							}
							if(isEnd)
								break;
						}
					//}
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception Occured.......in SqlProcess.jsp :"+e.getMessage());
				//e.printStackTrace();
				resultBuffer = new StringBuffer();
			}
			finally
			{
				egDb.releaseConnection(false);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
		}
		String headStr = "monitor.layermodel.Spid";
		if(isOraSessionTest || isOraConnectionsTest)
			headStr = "monitor.layermodel.SID";

		tableObj.put("COLUMN_0", mappingInfo.getTextDescription(headStr));
		tableObj.put("COLUMN_1", Spid);
		tableArr.add(tableObj);
		if(isLink && resultBuffer.length() > 0)
		{
			String resultStr = forHTML(resultBuffer.toString());
			if(measureName==null) measureName = "Blocked_processes";
		}
		tableObj = new JSONObject();
		tableObj.put("COLUMN_0", mappingInfo.getTextDescription("monitor.layermodel.blocked by"));
		tableObj.put("COLUMN_1", SpidBlocking);
		tableArr.add(tableObj);
		Hashtable result = new Hashtable();
		ArrayList headingList = new ArrayList();
		if(isMsSqlSysTest || isMsSqlConnTest )
		{
			if(isMsSqlSysTest)
			{
				headingList.add("User"); result.put("User",User);
			}
			headingList.add("DB");					result.put("DB",DB);
			headingList.add("Host");				result.put("Host",Host);
			headingList.add("Program Name");		result.put("Program Name",Program);
			headingList.add("Login time");			result.put("Login time",Login);
			headingList.add("Last Execution time");	result.put("Last Execution time",LastBatch);
			headingList.add("Waittime(msecs)");		result.put("Waittime(msecs)",Waittime);
			headingList.add("Waittype");			result.put("Waittype",Waittype);
			headingList.add("Trans nesting level");	result.put("Trans nesting level",Trans);
			headingList.add("Physical io");			result.put("Physical io",Phy);
			headingList.add("Mem usage(pages)");	result.put("Mem usage(pages)",Mem);
			headingList.add("Idle time(min)");		result.put("Idle time(min)",Idletime);
		}
		else if(isSybSysTest)
		{
			headingList.add("Status");			result.put("Status",status);
			headingList.add("User");			result.put("User",User);
			headingList.add("DB");				result.put("DB",DB);
			headingList.add("Host");			result.put("Host",Host);
			headingList.add("Program Name");	result.put("Program Name",Program);
			if(!blockedTime.equals("-"))
			{
				headingList.add("Blocked time");	result.put("Blocked time",blockedTime);
			}
			headingList.add("Cpu(ticks)");		result.put("Cpu(ticks)",cpu);
			headingList.add("Physical io");		result.put("Physical io",Phy);
			headingList.add("Mem usage(pages)");result.put("Mem usage(pages)",Mem);
		}
		else if(isOraSessionTest || isOraConnectionsTest)
		{
			headingList.add("Serial#");			result.put("Serial#",Serial);
			if(isOraSessionTest){
				headingList.add("User");		result.put("User",User);
			}
			headingList.add("OS User");			result.put("OS User",OsUser);
			headingList.add("Host");			result.put("Host",Host);
			headingList.add("Terminal Name");	result.put("Terminal Name",Terminal);
			headingList.add("Program");			result.put("Program",Program);
			headingList.add("Module");			result.put("Module",Module);
			headingList.add("Last call(Sec)");		result.put("Last call(Sec)",LastCall);
		}

		for(int k=0;k<headingList.size();k++)
		{
			String headString = (String) headingList.get(k);
			String displayString = (String)result.get(headString);
			headString = "monitor.layermodel."+headString;
			tableObj = new JSONObject();
			tableObj.put("COLUMN_0", mappingInfo.getTextDescription(headString));
			tableObj.put("COLUMN_1", displayString);
			tableArr.add(tableObj);
		}

		rootJson.put("TABLE_VALUES", tableArr);

		JSONObject lastCommandObj = new JSONObject();
		lastCommandObj.put("TEXT", mappingInfo.getTextDescription("monitor.layermodel.LastCommand"));
		lastCommandObj.put("VALUE", LastCmd);

		rootJson.put("COMMAND", lastCommandObj);
	}
	out.println(rootJson.toString());
//	System.out.println(rootJson.toString());
}
catch ( Throwable t )
{
	System.out.println("Exception in sqlProcessJSON "+t);
	t.printStackTrace();
}

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
