package org.apache.jsp.portal.PortalLogin.data;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.io.*;
import java.util.*;
import java.text.*;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import egurkha.ServiceBean;
import egurkha.UserBean;
import com.eg.EgConfigFilesSync;
import com.eg.EgDbAdapterTypeUI;
import egurkha.EgDbAdapterUI;
import com.egurkha.User;
import com.egurkha.admin.AddUser;
import com.egurkha.admin.ComponentAdd;
import com.egurkha.admin.ExternalAgent;
import com.egurkha.admin.UserAssociateComponent;
import java.sql.*;
import com.eg.EgCrypt;
import net.sf.json.*;
import java.security.SecureRandom;
import com.egurkha.util.StringUtils;
import com.egurkha.util.TimeZoneUtil;
import java.util.TimeZone;

public final class EgLogonp_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	public String userValidation(String email)
	{
		UserBean user = new UserBean(true);
		boolean flag_monuser = user.checkMonitorUser(); 
		if (!flag_monuser)
		{
			return "MonUserErr";
		}
		String str_conn = "";
		String str_query = "";
		Vector all_Users = new Vector();
		ResultSet rs_uname = null;
		EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
		str_conn = egDb.setConnection();
		String str_utype = "";
		if (str_conn.equals("CONNECTED"))
		{
			try
			{
				str_query = "SELECT user_id FROM user_info";

				rs_uname = egDb.SelectExec(str_query);
				if (rs_uname != null)
				{
					while(rs_uname.next())
					{
						String str_uname=rs_uname.getString("user_id");
						boolean isdefuser = User.isDefaultUser(str_uname);
						if (!isdefuser)
						{
							all_Users.add(str_uname);
						}
					}
					try
					{
						rs_uname.close();
					}
					catch (Exception rr)
					{}
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			finally
			{
				try
				{
					egDb.releaseConnection(false);
				}
				catch(Exception e2)
				{
					egDb.releaseConnection(true);
				}
			}
		}
		EgDbAdapterTypeUI.releaseObject(egDb);
		if (all_Users.contains(email))
		{
			return "UserExist";
		}
		else
		{
			return "Success";
		}
	}

	public String getRandomNumber()
	{
		String AB = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		SecureRandom rnd = new SecureRandom();
		int len = 6;
		StringBuilder sb = new StringBuilder(len);
		for(int i = 0; i < len; i++)
		{
			sb.append(AB.charAt(rnd.nextInt(AB.length())));
		}
		return sb.toString();
	}

	public synchronized void logToTempFile(String msg)
	{
		PrintWriter logWriter;
		String log;
		String strlog = EgInstallInfo.getInstallDir()+"/manager/logs/ls_trial_log";
		File ff = new File(strlog);
		if (ff.exists() && ff.length() >= 1000000)
		{
			EgInstallInfo.fileRename(strlog,strlog+".1");
		}
		try
		{
			logWriter = new PrintWriter(new FileWriter(strlog,true));
		}
		catch(Exception e)
		{
			System.out.println("Cannot open log file ");
			return;
		}
		log = new String(msg);
		logWriter.println(log);
		logWriter.close();
	}

	public String getTimeZoneOffset(TimeZone tz) 
	{
		long  hours = (tz.getRawOffset())/(60*60*1000);
		long minutes = (tz.getRawOffset())/(60*1000) % 60;
		minutes = Math.abs(minutes);
		String result = "";
		DecimalFormat df = new DecimalFormat("00");
		String mins = df.format(minutes);
		if (hours > 0) 
		{
			result ="(UTC+"+ hours+":"+mins+")";
		} 
		else 
		{
			result ="(UTC"+ hours+":"+mins+")";
		}
		return result;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


	String from = request.getParameter("from");
	String comeFrom = request.getParameter("comeFrom");
	String result = "failure";

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	
	if (comeFrom != null && comeFrom.equalsIgnoreCase("register"))
	{
		String fname = request.getParameter("fname");
		String lname = request.getParameter("lname");
		String email = request.getParameter("emailid");
		String password = request.getParameter("password");
		String company = request.getParameter("company");
		String timeZone = request.getParameter("timeZone");
		String phoneNo = request.getParameter("phoneNo");
		String simulator = request.getParameter("simulator");
		IniFile clsIni_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_ls_portal.ini",true);
		String defaultLS = clsIni_write.getValue("LS_TRIAL_SETTINGS","defaultLogonSimulator");

		AddUser adduser = new AddUser();
		String userStatus = userValidation(email);
		boolean userResult = false;
		if (userStatus.equalsIgnoreCase("success"))
		{
			if (from != null && from.equalsIgnoreCase("twofalogin"))
			{
				Hashtable userdata = new Hashtable();
				userdata.put("utype","MonitorWithLimitedAdminNoConfig");
				userdata.put("uname",email);
				userdata.put("upass",password);
				userdata.put("uvalidtill","12/12/9999");
				userdata.put("tomailid",email);
				userdata.put("reportertimeline","1 week");

				userResult = adduser.createUser(userdata,"Add");
				result = "success";
			}
			else
			{
				result = "success";
			}

			if (userResult == true)
			{
				adduser.setTimeZone(email,timeZone+"$@$MMM dd, yyyy");
				
				String domain = email.substring(email.indexOf('@'),email.length());
				String domainUsersCount = clsIni_write.getValue("DOMAIN_USERS_COUNT",domain);
				if (domainUsersCount == null || domainUsersCount.trim().length() <= 0)
				{
					String allowedDomainUsers = clsIni_write.getValue("LS_TRIAL_SETTINGS","allowedDomainUsers");
					clsIni_write.setValue("DOMAIN_USERS_COUNT",domain,allowedDomainUsers);
				}
				clsIni_write.setValue("LS_TRIAL_USER_MAP",email," ");
				clsIni_write.setValue("LS_TRIAL_USER_DETAILS",email,"No$@$"+fname+"#@#"+lname+"#@#"+company+"#@#"+phoneNo+"#@#"+EgCrypt.encrypt(password)+"#@#"+timeZone);
				clsIni_write.saveFile();
			}
			
			if (defaultLS!=null)
			{

				if (defaultLS.equalsIgnoreCase("all"))
				{
					defaultLS = simulator;
				}

				String randomNumber = getRandomNumber();
				boolean check = false;
				Vector randomNo = clsIni_write.getAllValues("USER_RN_MAP");

				if (randomNo != null && !randomNo.isEmpty())
				{
					while (!check)
					{
						boolean flag = randomNo.contains(randomNumber);
						if (flag)
						{
							randomNumber = getRandomNumber();
						}
						else
						{
							check = true;
							break;
						}
					}
				}
				
				String citfarm = "LogonSimulator_"+randomNumber;
				String sessionID = "1234567890";

				ComponentAdd addcomp = new ComponentAdd(email,citfarm,sessionID);
				ExternalAgent extagent = new ExternalAgent();
				UserAssociateComponent addcomptouser = new UserAssociateComponent(email,citfarm,sessionID);
				
				String extAgentStatus = extagent.extAgentValidation(citfarm,citfarm,"yes");
				
				Hashtable compdata = new Hashtable();
				compdata.put("componenttype",defaultLS);
				compdata.put("hostip",citfarm);
				compdata.put("componentname",citfarm);
				compdata.put("externalagent",citfarm);
				String compStatus = addcomp.compValidation(compdata);


				if (extAgentStatus != null && extAgentStatus.equalsIgnoreCase("success"))
				{
					if (compStatus != null && compStatus.equalsIgnoreCase("eG_CLI_0030"))
					{
						if (from != null && from.equalsIgnoreCase("twofalogin"))
						{
							if (defaultLS.equalsIgnoreCase("Citrix_XcLogon_Emulation"))
							{
								adduser.setMonitorHomePage(email,"Citrix logon simulator dashboard");
							}
							else if (defaultLS.equalsIgnoreCase("Hrzn_Logon_Emulation"))
							{
								adduser.setMonitorHomePage(email,"VMware Horizon logon simulator dashboard");
							}

							String extAgentResult = extagent.add(citfarm,citfarm,"yes");
							
							ServiceBean serbean = new ServiceBean();
							serbean.stopDiscovery();

							String compResult = addcomp.add(compdata);
							
							serbean.startDiscovery("1",true);

							Hashtable usercompdata = new Hashtable();
							usercompdata.put("userid",email);
							usercompdata.put("componenttype",defaultLS);
							usercompdata.put("components",citfarm);
							String userCompStatus = addcomptouser.AssociateComponent(usercompdata);
							
							clsIni_write.setValue("LS_TRIAL_USER_MAP",email,("No"+"$"+defaultLS+"#"+citfarm+"#"+"No"));
							clsIni_write.setValue("USER_RN_MAP",email,randomNumber);
							clsIni_write.saveFile();

							IniFile mgrHost =  new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
							String mgrUrl = mgrHost.getValue("MISC_ARGS","MailHomeUrl");
							String ssl = "";
							String schema = mgrUrl.substring(0,mgrUrl.indexOf("://"));
							if (schema.equalsIgnoreCase("http"))
							{
								ssl = "n";
							}
							else if (schema.equalsIgnoreCase("https"))
							{
								ssl = "y";
							}
							String url = mgrUrl.substring(mgrUrl.indexOf("://")+3,mgrUrl.length());
							String server = "";
							String port = "";
							if (url.indexOf(":") != -1)
							{
								StringTokenizer st = new StringTokenizer(url,":");
								server = st.nextToken();
								port = st.nextToken();
							}
							else
							{
								server = url;
								if (ssl.equalsIgnoreCase("n"))
								{
									port = "80";
								}
								else
								{
									port = "443";
								}
							}
							
							server = StringUtils.replace(server,"\\.","^.");
							String citfarmname = StringUtils.replace(citfarm,"\\.","^.");
							citfarmname = StringUtils.replace(citfarmname,"-","^-");
							BufferedReader br = null;
							BufferedWriter bw = null;
							try
							{
								if (ssl!=null && ssl.equalsIgnoreCase("n"))
								{
									br = new BufferedReader(new FileReader(EgInstallInfo.getInstallDir()+"\\manager\\agents\\LogonSimulator\\eGAgent_Install_NonSSL.bat"));
								}
								else
								{
									br = new BufferedReader(new FileReader(EgInstallInfo.getInstallDir()+"\\manager\\agents\\LogonSimulator\\eGAgent_Install_SSL.bat"));
								}
								
								bw = new BufferedWriter(new FileWriter(EgInstallInfo.getInstallDir()+"\\manager\\agents\\LogonSimulator\\Users\\eGAgent_"+email+".bat"));
								String line;
								while ((line = br.readLine()) != null)
								{
									if (line.contains("$MANAGER_IP"))
									{
										line = line.replace("$MANAGER_IP", server);
									}
									else if (line.contains("$MANAGER_PORT"))
									{
										line = line.replace("$MANAGER_PORT", port);
									}
									else if (line.contains("$AGENT_NICK_NAME"))
									{
										line = line.replace("$AGENT_NICK_NAME", citfarmname);
									}
									bw.write(line+"\n");
								}
							}
							catch (IOException e)
							{
							}
							finally
							{
								try
								{
									if (br != null)
									{
										br.close();
									}
									if (bw != null)
									{
										bw.close();
									}
								}
								catch(IOException ioe)
								{
								}
							}

							result = "success";
						}
						else
						{
							result = "success";
						}
					}
					else if (compStatus.equalsIgnoreCase("eG_CLI_0036"))
					{
						rootJson.put("success","comp");
						logToTempFile("[LS] ["+email+"] ["+citfarm+"] You are exceeding the total number of applications permitted by your license");
						screenLabels.put("compErr","The user could not be registered. Please contact the eG administrator.");
					}
					else if (compStatus.equalsIgnoreCase("eG_CLI_0035"))
					{
						rootJson.put("success","comp");
						logToTempFile("[LS] ["+email+"] ["+citfarm+"] You are exceeding the total number of agents permitted by your license");
						screenLabels.put("compErr","The user could not be registered. Please contact the eG administrator.");
					}
					else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0336"))
					{
						rootJson.put("success","comp");
						logToTempFile("[LS] ["+email+"] ["+citfarm+"] You are exceeding the number of Total/Basic license");
						screenLabels.put("compErr","The user could not be registered. Please contact the eG administrator.");
					}
					else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0337"))
					{
						rootJson.put("success","comp");
						logToTempFile("[LS] ["+email+"] ["+citfarm+"] You are exceeding the number of Premium license");
						screenLabels.put("compErr","The user could not be registered. Please contact the eG administrator.");
					}
					else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0338"))
					{
						rootJson.put("success","comp");
						logToTempFile("[LS] ["+email+"] ["+citfarm+"] You are exceeding the number of User based license for named user");
						screenLabels.put("compErr","The user could not be registered. Please contact the eG administrator.");
					}
					else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0339"))
					{
						rootJson.put("success","comp");
						logToTempFile("[LS] ["+email+"] ["+citfarm+"] You are exceeding the number of User based license for concurrent user");
						screenLabels.put("compErr","The user could not be registered. Please contact the eG administrator.");
					}
				}
				else if (extAgentStatus.equalsIgnoreCase("eG_CLI_0016"))
				{
					rootJson.put("success","extagent");
					logToTempFile("[LS] ["+email+"] ["+citfarm+"] The number of external agents permissible by the license has exceeded");
					screenLabels.put("extAgentErr","The user could not be registered. Please contact the eG administrator.");
				}
				else if (extAgentStatus.equalsIgnoreCase("eG_CLI_0124"))
				{
					rootJson.put("success","extagent");
					logToTempFile("[LS] ["+email+"] ["+citfarm+"] The client emulation feature is not enabled in license");
					screenLabels.put("extAgentErr","The user could not be registered. Please contact the eG administrator.");
				}
			}
		}
		else if (userStatus.equalsIgnoreCase("MonUserErr"))
		{
			rootJson.put("success","user");
			logToTempFile("[LS] ["+email+"] The number of monitor users permissible by the license has exceeded");
			screenLabels.put("userErr","The user could not be registered. Please contact the eG administrator.");
		}
		else if (userStatus.equalsIgnoreCase("UserExist"))
		{
			rootJson.put("success","user");
			logToTempFile("[LS] ["+email+"] The user ID already exists");
			screenLabels.put("userErr","The mail ID already exists. Please enter a new mail ID");
		}

		if (result.equalsIgnoreCase("success"))
		{
			rootJson.put("success","true");
			rootJson.put("enc",EgCrypt.encrypt(password));
			String autoLogin = clsIni_write.getValue("LS_TRIAL_SETTINGS","autoLoginAfterReg");
			String twoFA = clsIni_write.getValue("LS_TRIAL_SETTINGS","enable2FAForReg");
			rootJson.put("autoLogin",autoLogin);
			rootJson.put("2FA",twoFA);
			rootJson.put("defaultLS",defaultLS);
		}

		EgConfigFilesSync.releaseInstance(clsIni_write);
	}
	else if (comeFrom != null && comeFrom.equalsIgnoreCase("login"))
	{
		String username = request.getParameter("username");
		IniFile userIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ls_portal.ini");
		String userVal = userIni.getValue("LS_TRIAL_USER_MAP",username);
		ArrayList al = new ArrayList();
		ArrayList al1 = new ArrayList();
		ArrayList al2 = new ArrayList();
		ArrayList al3 = new ArrayList();
		ArrayList comp = new ArrayList();
		String agentDownload = "";
		String configure = "";
		String compType = "";
		if (userVal!=null && userVal.trim().length() > 0)
		{
			if (userVal.indexOf("|") != -1)
			{
				StringTokenizer st = new StringTokenizer(userVal,"|");
				while(st.hasMoreTokens())
				{
					String tok = st.nextToken();
					al.add(tok);
				}
				for (int i = 0 ; i<al.size() ; i++)
				{
					String tok1 = (String)al.get(i);
					StringTokenizer st1 = new StringTokenizer(tok1,"#");
					while(st1.hasMoreTokens())
					{
						String tok2 = st1.nextToken();
						al1.add(tok2);
					}
					compType = (String)al1.get(0);
					if (compType.indexOf('$') != -1)
					{
						compType = compType.substring(compType.indexOf('$')+1,compType.length());
					}
					comp.add(compType);
					configure = (String)al1.get(2);
					if (configure.equalsIgnoreCase("no"))
					{
						break;
					}
					al1 = new ArrayList();
				}
				if (configure.equalsIgnoreCase("yes"))
				{
					compType = (String)comp.get(0);
				}
			}
			else
			{
				StringTokenizer st = new StringTokenizer(userVal,"#");
				while(st.hasMoreTokens())
				{
					String tok = st.nextToken();
					al2.add(tok);
				}
				compType = (String)al2.get(0);
				compType = compType.substring(compType.indexOf('$')+1,compType.length());
				configure = (String)al2.get(2);
			}
			StringTokenizer stoken = new StringTokenizer(userVal,"$");
			while(stoken.hasMoreTokens())
			{
				String tok = stoken.nextToken();
				al3.add(tok);
			}
			agentDownload = (String)al3.get(0);
			if (configure != null && configure.equalsIgnoreCase("No"))
			{
				rootJson.put("tab","configure");
			}
			else if (agentDownload != null && agentDownload.equalsIgnoreCase("No"))
			{
				rootJson.put("tab","agentDownload");
			}
			else if (agentDownload.equalsIgnoreCase("yes") && configure.equalsIgnoreCase("yes"))
			{
				rootJson.put("tab","monitor");
			}
		}
		else
		{
			rootJson.put("tab","comp");
		}
		rootJson.put("compType",compType);
	}
	else if (comeFrom != null && comeFrom.equalsIgnoreCase("logincheck"))
	{
		String username = request.getParameter("username");
		IniFile userCheckIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ls_portal.ini");
		String [] regUsers = userCheckIni.getVariables("LS_TRIAL_USER_DETAILS");
		ArrayList al = new ArrayList();
		String [] blockedemail = userCheckIni.getVariables("Blocked_Users");
		ArrayList blockedemailList = blockedemail==null?new ArrayList():new ArrayList(Arrays.asList(blockedemail));
		if (blockedemailList.contains(username))
		{
			rootJson.put("userCheck","error");
		}
		else
		{
			for (int i=0; i<regUsers.length ; i++)
			{
				al.add(regUsers[i].toLowerCase());
			}
			if (al.contains(username.toLowerCase()))
			{
				rootJson.put("userCheck","success");
			}
			else
			{
				rootJson.put("userCheck","failure");
			}
		}
		
		String twoFA = userCheckIni.getValue("LS_TRIAL_SETTINGS","enable2FAForLogin");
		rootJson.put("2FA",twoFA);
	}
	else if (comeFrom != null && comeFrom.equalsIgnoreCase("emailValidation"))
	{
		String emailid = request.getParameter("emailid");
		String id = emailid.substring(0,emailid.indexOf('@'));
		if (id.length() >= 3)
		{
			if (emailid.indexOf("junk") != -1 || emailid.indexOf("crap") != -1 ||
				emailid.indexOf("xxx") != -1 || emailid.indexOf("abc") != -1 ||
				emailid.indexOf("xyz") != -1)
			{
				rootJson.put("validEmail",false);
			}
			else
			{
				emailid = emailid.substring(emailid.indexOf('@'),emailid.length());
				IniFile emailCheckIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_maildomains.ini");
				String [] excmail = emailCheckIni.getVariables("Excluded_Mail_Domains");
				ArrayList excMailID = new ArrayList();
				for (int i=0; i<excmail.length ; i++)
				{
					excMailID.add(excmail[i].toLowerCase());
				}
				if (excMailID.contains(emailid.toLowerCase()))
				{
					rootJson.put("validEmail",false);
				}
				else
				{
					rootJson.put("validEmail",true);
					IniFile domainCheckIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ls_portal.ini");
					String domainAllowedCount = domainCheckIni.getValue("DOMAIN_USERS_COUNT",emailid);
					if (domainAllowedCount != null && domainAllowedCount.trim().length() > 0)
					{
						int domainAllowed = Integer.parseInt(domainAllowedCount);
						String [] email = domainCheckIni.getVariables("LS_TRIAL_USER_DETAILS");
						int mailCount = 0;
						if (email != null)
						{
							for (int i=0; i<email.length ; i++)
							{
								if (email[i].indexOf(emailid) != -1)
								{
									mailCount++;
								}
							}
							if (mailCount < domainAllowed)
							{
								rootJson.put("domainAllowed",true);
							}
							else
							{
								logToTempFile("[LS] ["+request.getParameter("emailid")+"] The number of users with this domain is exceeded.");
								rootJson.put("domainAllowed",false);
							}
						}
					}
					else
					{
						rootJson.put("domainAllowed",true);
					}
				}
			}
		}
	}
	else if (comeFrom != null && comeFrom.equalsIgnoreCase("getTimeZoneAndSimulator"))
	{
		JSONArray timeZoneArr = new JSONArray();
		TimeZone tz =TimeZone.getDefault();
		TimeZoneUtil tzu = new TimeZoneUtil();
		String[] timeZoneIDs = tz.getAvailableIDs();
		JSONObject tmpZoneObj = new JSONObject();
		if (timeZoneIDs!=null && timeZoneIDs.length>0)
		{
			ArrayList al = new ArrayList();
			for(int i=0;i<timeZoneIDs.length;i++)
			{
				if (timeZoneIDs[i].indexOf("/") != -1 && timeZoneIDs[i].indexOf("SystemV") == -1 && timeZoneIDs[i].indexOf("Etc/") == -1)
				{
					al.add(TimeZone.getTimeZone(timeZoneIDs[i]));
				}
			}
			Collections.sort(al,new Comparator() {
				public int compare(Object s1, Object s2) {
					return ((TimeZone)s1).getRawOffset() - ((TimeZone)s2).getRawOffset();
				}
			});
			for (int j=0;j<al.size();j++) 
			{
				TimeZone instance = (TimeZone)al.get(j);
				tmpZoneObj.put("displayField",getTimeZoneOffset(instance)+" "+(instance.getID()).replace("_"," "));
				tmpZoneObj.put("valueField",instance.getID());
				timeZoneArr.add(tmpZoneObj);
			}
			rootJson.put("timeZone",timeZoneArr);
		}

		JSONArray simArr = new JSONArray();
		JSONObject simObj = new JSONObject();
		IniFile lsIni = new IniFile (EgInstallInfo.getInstallDir()+"/manager/config/eg_ls_portal.ini");
		String simulator [] = lsIni.getVariables("Environment");
		for (int i=0; i<simulator.length ; i++)
		{
			simObj.put("displayField",simulator[i]);
			simObj.put("valueField",lsIni.getValue("Environment",simulator[i]));
			simArr.add(simObj);
		}
		rootJson.put("simulator",simArr);
	}
	else if (comeFrom != null && comeFrom.equalsIgnoreCase("mailSentSuccess"))
	{
		String username = request.getParameter("email");
		IniFile clsIni_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_ls_portal.ini",true);
		String userDetails = clsIni_write.getValue("LS_TRIAL_USER_DETAILS",username);
		String finalVal = "";
		ArrayList userDetail = new ArrayList(StringUtils.egTokenizer(userDetails,"$@$"));
		finalVal = "Yes$@$"+(String)userDetail.get(1);
		clsIni_write.setValue("LS_TRIAL_USER_DETAILS",username,finalVal);
		clsIni_write.saveFile();
		EgConfigFilesSync.releaseInstance(clsIni_write);
		rootJson.put("MailStatus","Success");
	}

	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
