package org.apache.jsp.reporter;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.*;
import java.io.*;
import java.sql.*;
import egurkha.*;
import egurkha.reporter.*;
import com.egurkha.*;
import com.egurkha.ini.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgDiscInfo;
import com.eg.EgDiscInfoHelper;
import com.eg.EgMappingInfo;
import com.eg.EgTablesInfo;
import com.eg.EgURLDecoder;
import com.eg.EgURLEncoder;
import com.eg.LangInfo;
import egurkha.reporter.ErReportUtil;
import egurkha.reporter.ErUtils;
import com.egurkha.monitor.EgServiceMappingBean;
import com.egurkha.monitor.EgComponentUserMappingBean;
import com.egurkha.util.DateTimeTokenizer;
import com.egurkha.util.DateUtil;
import com.egurkha.util.StringUtils;
import egurkha.reporter.ErAlarmHistoryHelper;
import com.egurkha.util.StringUtils;
import net.sf.json.*;
import java.text.*;

public final class ErAlarmHistoryResultsJSON_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/reporter/ErReporterTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/**************************************************************************************************
* File name			: ErAlarmHistoryResultsJSON.jsp
* Purpose			: Genarates History of Alarm Report Results
* Version			: 1.0
* Creation			: 9th June 2011
* Last Modified		:
* Author			: Sathya Kala Veeraraj
**************************************************************************************************/


//	response.setHeader("Cache-Control","no-store");
//	response.setHeader("Pragma","no-cache");
//	response.setDateHeader ("Expires", -1);
	
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	String imageName = null;
	IniUI egui = IniUI.getInstance();
	imageName = egui.getReporterHomeLogo();
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	ErUserData UBean = null;
	String reporter_Skin = null;

	boolean id_u = false;
	boolean isLastTimeLine = false;
	String urs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	UserRegistry registry= null;
	User thisuser=null;
	String throughSchedule = request.getParameter("throughSchedule");
	if(throughSchedule == null) {
		throughSchedule = "";
	}
	String usr_Id_proc = request.getParameter("er_userid");
	String usr_Id = request.getParameter("eruserid");
	String userID = request.getParameter("userID");
	if(session!=null)
	{
		 UBean = (ErUserData) session.getAttribute("UBean");
		 if(throughSchedule.equalsIgnoreCase("true")) {
			 try
			 {
			if(UBean == null) {
				if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id,false);
					usr_Id_proc = usr_Id;
				}
				else if(userID != null){
					UBean = new ErUserData(userID,false);
					usr_Id_proc = userID;
				}
				else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id_proc,false);
				}
				else{
					UBean = new ErUserData(usr_Id_proc,false);
				}

			}
			}
			catch(Throwable t)
			{
			t.printStackTrace();
			}
		}
		if(UBean != null)
		{
			registry = UserRegistry.getInstance();
			thisuser= registry.getUser(session.getId(),true);
			if(thisuser!=null)
			{
				id_u = thisuser.isIdDeletedWhileLoggedIn();
				if(id_u==false )
				{
					urs = thisuser.getLoginID();
					if(!User.isDefaultUser(urs))
					{
						u_v_till = UBean.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
			if(thisuser == null && usr_Id_proc!= null ) {
				try {
					thisuser = UBean.getUser(usr_Id_proc);
					registry.setUser(session.getId(), thisuser, false);
					System.out.println("Setting user object. user reporter skin : " + thisuser.getReporterSkin());
				} catch(Exception ex) {
					System.out.println("Setting user object failed");
					ex.printStackTrace();
				}
			}
		}
	}
	if(session == null || thisuser == null)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");		
	}
	else if(id_u== true)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-deleted</customerror>");
	}
	else if (u_v_till < l_accessed)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}

	if(session!=null && UBean != null && thisuser!=null)
	{
		//session.putValue("Page_IdentifierR",request.getRequestURI());	
		String pageName = request.getRequestURI();
		if(!pageName.endsWith("ErMeasureData.jsp") && !pageName.endsWith("ErMeasure.jsp") && !pageName.endsWith("ErPrintReport.jsp") && !pageName.endsWith("ErPrintDataReport.jsp") && !pageName.endsWith("ErComparisonData.jsp") && !pageName.endsWith("ErMacroData.jsp") && !pageName.endsWith("ErCtxUserGraph.jsp") && !pageName.endsWith("ErMacroPrint.jsp") && !pageName.endsWith("ErHomePrint.jsp"))
		{
			//session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
		}
	}
	

	if (thisuser!=null)
	{
		String trackerUserLang = thisuser.getLanguage();
		thisuser.setUserLanguageAndSkins();
		reporter_Skin  = thisuser.getReporterSkin();

		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
	}
	String  script_src="script_item_"+trackerLanguage+".js";

	//Added by Sakthivel - 26/03/2008
	String uiFileTemp = "eg_ui.ini";
	String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
	//Variable to be used in javascript code
	String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(thisuser!=null)
	{
		currentDateFormatForJS = thisuser.getUserDateFormat();
	}
	String strUserDateFormat =currentDateFormatForJS;
	if(currentDateFormatForJS.indexOf("MMM") >= 0)
	{
		for(int i=0; i < currentDateFormatForJS.length();i++)
		{
			if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
			{
				currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
			}
		}
	}
	egurkha.reporter.ErBackgroundReportGenerator erbgreport = new egurkha.reporter.ErBackgroundReportGenerator();
	String strArray[] =erbgreport.getSelection(urs);
	String strforeground = strArray[0];
	String strbackground =  strArray[1];
	String bgString="'";

      com.egurkha.monitor.EgDiagnosisBean dd = null;
      synchronized (_jspx_page_context) {
        dd = (com.egurkha.monitor.EgDiagnosisBean) _jspx_page_context.getAttribute("dd", PageContext.PAGE_SCOPE);
        if (dd == null){
          dd = new com.egurkha.monitor.EgDiagnosisBean();
          _jspx_page_context.setAttribute("dd", dd, PageContext.PAGE_SCOPE);
        }
      }
      com.egurkha.monitor.EgServiceMappingBean esmb = null;
      synchronized (_jspx_page_context) {
        esmb = (com.egurkha.monitor.EgServiceMappingBean) _jspx_page_context.getAttribute("esmb", PageContext.PAGE_SCOPE);
        if (esmb == null){
          esmb = new com.egurkha.monitor.EgServiceMappingBean();
          _jspx_page_context.setAttribute("esmb", esmb, PageContext.PAGE_SCOPE);
        }
      }

	try
	{
//	System.out.println("QueryString---sysDash----->"+ErUtils.prepareQueryString(request.getParameterMap()));
	response.setContentType("application/json");

	JSONObject rootJSON = new JSONObject();
	JSONObject screenLableJSON = new JSONObject();
	JSONObject hiddenfieldsJSON=new JSONObject();
	JSONObject loopJsonObj = new JSONObject();
	//TreeMap linksMap = new TreeMap();
	String cmpType="";
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ui.ini");
	String stateIcons = uiIni.getValue("STATE_ICONS","Default");
	String optClassName = "";
	if ( stateIcons != null && stateIcons.equalsIgnoreCase("no") )
	{
		optClassName = "_optional";
	}

//Request parameter

		String showUserValue         = request.getParameter("showuser");
		String s_event               = request.getParameter("v_event");
		String subevent              = request.getParameter("subevent");
		String selectedsubzone       = request.getParameter("includeSubZone");
		String selectedCompType      = request.getParameter("compTypeList");
		String selectedCompName      = request.getParameter("compNameList");
		String s_state               = request.getParameter("state");
		String unknownState               = request.getParameter("unknownState");
		String selectedArrangeOption = request.getParameter("arrangeAlarms");
		String searchBy = request.getParameter("searchBy");
		String infosearch            = request.getParameter("infosearch");
		String compsearch            = request.getParameter("compsearch");
		String noRecPerPage          = request.getParameter("eventsPerPage");
		String printGraph            = request.getParameter("printGraph");
		String view                  = request.getParameter("er_view");
		String startdate             = request.getParameter("startdate");
		String enddate               = request.getParameter("enddate");
		String starthr               = request.getParameter("starthr");
		String endhr                 = request.getParameter("endhr");
		String startmin              = request.getParameter("startmin");
		String endmin                = request.getParameter("endmin");
		String s_user_id             = request.getParameter("userID");
		String inidate               = request.getParameter("inidate");
		String er_usertimeline       = request.getParameter("er_usertimeline");
		String er_timeline           = request.getParameter("er_timeline");
		String limitforbg            = request.getParameter("limitforbg");
		String getMaxDaysInMonth     = request.getParameter("getMaxDaysInMonth");
		String strPageNo             = request.getParameter("pageno");
		String language              = thisuser.getLanguage();
		String req_heading           = request.getParameter("heading");
		String hasVMs				 = request.getParameter("hasVMs");
		String searchByUser				 = request.getParameter("searchByUser");


		String er_RmDispName		= request.getParameter("er_RmDispName");
	
		ArrayList aListColumnNames = new ArrayList();
		ArrayList userColumnNames = new ArrayList();

		boolean hasOnlyVM = false;
		hasVMs=(hasVMs!=null)?hasVMs:"false";
		if(thisuser.isOnlyVMAssigned() && !thisuser.isVMAssigned())
		{
			hasOnlyVM = true;
		}

		String [] arr_choosenComponent=request.getParameterValues("compNameList");
		List choosenComponents=new LinkedList();
		if(printGraph==null && arr_choosenComponent!=null)
		{
		choosenComponents=Arrays.asList(arr_choosenComponent);
		}
		else
		{
				if((List)session.getAttribute("component")!=null)
					choosenComponents=(List)(List)session.getAttribute("component");
		
		}
		if(req_heading==null)
		{
			req_heading = s_event;
			if (s_event == null || s_event.equals("null")) {
				req_heading = "Components";
			}
			else if(s_event != null && s_event.equalsIgnoreCase("Component"))
			{
				req_heading = s_event+"s";
			}
			if (subevent == null || subevent.equals("null")) {
				subevent = null;
			}
			if (subevent != null) {
				if(subevent.equalsIgnoreCase("Component"))
					req_heading = subevent+"s";
				else
					req_heading += " : " + subevent;
			}
		}

		String showUsers = "";
		String currentDateFormat = "";
		String str_fontStyleDblSingl = "";
		String th_title="";
		String colForTest="";
		String colForDesc="";
		String colForSttime="",colForcname="",colForservice="";
		String th_description="";
		boolean ddEnabled = com.eg.EgMemInfo.ddEnabled;
		if(unknownState !=null && unknownState.equals("UNKNOWN"))
		{
			th_title="History of Unknowns for ";
			th_description = "reporter.common.Measure";
			colForDesc="19%";colForTest="18%";colForSttime="17%";colForservice="11%";
		}
		else
		{
			if(er_RmDispName!=null && !er_RmDispName.equals("null"))
			{
				th_title="History of Alerts for ";
				th_description = "reporter.common.Alert Description";
			}
			else
			{
				th_title="History of Alarms for ";
				th_description = "reporter.common.Description";
			}
			colForDesc="45%";colForTest="15%";colForSttime="15%";colForservice="8%" ;
		}
//UI Skin

		String skinColor = thisuser.getReporterSkin();

//Common Link URL parameters

		String param_pass = "&startdate="+startdate+"&er_usertimeline="+er_usertimeline+"&enddate="+enddate+"&inidate="+inidate+"&getMaxDaysInMonth="+getMaxDaysInMonth+"&er_timeline="+er_timeline+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+startmin+"&endmin="+endmin+"&userID="+s_user_id+"&uid="+s_user_id+"&v_event="+s_event+"&subevent="+subevent+"&includeSubZone="+selectedsubzone+"&compTypeList="+selectedCompType+"&showuser="+showUserValue+"&heading="+req_heading+"&hasVMs="+hasVMs;

//Other than Submit page, All records displayed without Pagination

		if((printGraph!=null && printGraph.equalsIgnoreCase("yes"))|| (view != null && view.equalsIgnoreCase("PRINT")))
			noRecPerPage = "All";


			String eventForPageUserSelected=noRecPerPage;
			noRecPerPage = "All";//for fix for ext js grid on client side

//Class Initialization

		EgComponentUserMappingBean ecumb = new EgComponentUserMappingBean();
		ErAlarmHistoryHelper helper      = new ErAlarmHistoryHelper();
		com.eg.EgDbInfo db_Info          = new com.eg.EgDbInfo("manager");
		EgDateInfo egDate                = new EgDateInfo();
		//EgDiscInfoHelper discInfoHelper  = new EgDiscInfoHelper();
		ErUtils erUtils                  = new ErUtils();
		ErInfo erInfo                    = new ErInfo();
		ErReqData erd                    = new ErReqData(request);
		LangInfo langinfo                = new LangInfo(thisuser.getLoginID());
		EgMappingInfo mappingInfo        = new EgMappingInfo(language);
		IniFile egUI                     = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
		IniFile egFormat                     = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_format.ini");
		EgUserRole userRole              = thisuser.getUserRole();
		User selectedUser                = null;
		List a_userVMs = thisuser.getOnlyVMs();

//Collection Objects

		// For Service component mapping
		Hashtable resultServiceNamesForComp = (Hashtable)esmb.getServiceNamesForComponentMap();
		Hashtable resultUserCompMap         = (Hashtable)ecumb.getUserNamesForComponentMap();
		List siteNames                      = new LinkedList();
		List userCompList                   = new LinkedList();
		List a_list                         = null;

		int maxPage = 10,totalNoOfRecPerPage = 12;
		int pageNo = 1;
		int total_num_page = 1,start_index_page = 0,end_index_page = 0;
		int startPage = 1, endpage = maxPage;

		boolean hasAllComponentAccess = userRole.hasAllComponentAccess();

//Fetch - ini Entry values

		showUsers = egUI.getValue("ALARM_HISTORY","Show_Users");
		currentDateFormat = strUserDateFormat;

//User Selected from UI. if 'User=All' then 'showUserValue=-1'

		if(showUserValue!=null)
			showUserValue = EgURLDecoder.decode(showUserValue,"UTF-8");
		showUserValue = (showUserValue==null || showUserValue.trim().length()==0 || showUserValue.equals("null") || showUserValue.equals(""))?"":showUserValue;

		if(showUserValue!=null && showUserValue.trim().length()>0 && !showUserValue.equalsIgnoreCase("-1"))
		{
			ErUserData userData = new ErUserData(showUserValue,false);
			if(userData!=null)
			{
				selectedUser = userData.usr;
				if(selectedUser==null)
					selectedUser = userData.getUser(showUserValue);
			}
		}

//User with No Full Component Access

		if(!hasAllComponentAccess)
		{
			userCompList = thisuser.getServers(false);
			List userCompList1 = thisuser.getServers(true);
			if(userCompList!=null && userCompList.size()>0)
			{
				List userCompList_host = new LinkedList();
				for(int r=0; r<userCompList.size(); r++)
				{
					String s = (String) userCompList.get(r);
					if(s!=null && !s.endsWith(":NULL"))
					{
						StringTokenizer st = new StringTokenizer(s,":");
						String ctype = st.nextToken();
						String cname = st.nextToken();
						if(ctype!=null && cname!=null && ctype.trim().length()>0 && cname.trim().length()>0)
							userCompList_host.add(ctype+":"+cname+":NULL");
					}
				}
				if(userCompList_host!=null && userCompList_host.size()>0)
					userCompList.addAll(userCompList_host);
			}
		}

//Service Names

		siteNames.addAll(thisuser.getSites());
		siteNames.addAll(thisuser.getServices());

//Pagination - Current Page Number

		if(strPageNo!=null && !strPageNo.equals("") && !strPageNo.equalsIgnoreCase("null"))
		{
			try
			{
				pageNo = Integer.parseInt(strPageNo);
			}catch(Exception e)
			{
				pageNo = 1;
			}
		}
//Session attribute
		if(session.getAttribute("NO_OF_ALARMS")!=null && !session.getAttribute("NO_OF_ALARMS").equals(""))
			a_list = (List)session.getAttribute("NO_OF_ALARMS");

//Pagination Calculation - Total Pages
                    int allTotalRecord=0;
		if(a_list!=null && a_list.size()>0)
		{
			int totalRecord = a_list.size();
			allTotalRecord  =totalRecord;
			try {
				if(noRecPerPage.equalsIgnoreCase("All"))
					totalNoOfRecPerPage = totalRecord;
				else
					totalNoOfRecPerPage = Integer.parseInt(noRecPerPage);
			}catch(Exception e)
			{
					totalNoOfRecPerPage = 12;
			}
			total_num_page = (totalRecord/totalNoOfRecPerPage);
			if((totalRecord%totalNoOfRecPerPage)>0)
				total_num_page = total_num_page+1;
		}

		if(pageNo>total_num_page)
			pageNo = total_num_page;
		else if(pageNo<=0)
			pageNo = 1;

		int interIndex = maxPage/2;

		if(pageNo>1)
		{
			int temp = pageNo+1;
			
			for(int kk=0;kk<=interIndex;kk++)
				--temp;
			if(temp>0)
				startPage = temp;
			else
				startPage = 1;

			if(pageNo>interIndex)
				endpage = pageNo+ (maxPage - (pageNo+1 - startPage));
			else
				endpage = pageNo+(maxPage-pageNo);

			if(endpage >total_num_page)
				endpage = total_num_page;

			if((endpage-startPage)!=(maxPage-1))
				startPage = total_num_page-(maxPage-1) ;
		}

//DoubleByte - Other Language Support

		if((db_Info.doubleByteEnabled || !language.equals("en_US")) && view!=null)
			str_fontStyleDblSingl = "multi_font";
		else
			str_fontStyleDblSingl = "";




			JSONArray componentArray = new JSONArray();
			if(choosenComponents!=null)
			{
				for(int j=0;choosenComponents.size()>j;j++)
				{
					componentArray.add(choosenComponents.get(j));


				}
			}
			if("All".equals(eventForPageUserSelected))
                eventForPageUserSelected = allTotalRecord+"";
			hiddenfieldsJSON.put("compTypeList",selectedCompType);
			hiddenfieldsJSON.put("compNameList",componentArray);
			hiddenfieldsJSON.put("state",s_state);
			hiddenfieldsJSON.put("unknownState",unknownState);
			hiddenfieldsJSON.put("eventsPerPage",noRecPerPage);
			rootJSON.put("eventsPerPage",eventForPageUserSelected);
			hiddenfieldsJSON.put("arrangeAlarms",selectedArrangeOption);
			hiddenfieldsJSON.put("searchBy",searchBy);
			hiddenfieldsJSON.put("isSubmit",request.getParameter("isSubmit"));
			hiddenfieldsJSON.put("timeselect",request.getParameter("timeselect"));
			hiddenfieldsJSON.put("showuser",showUserValue);
			hiddenfieldsJSON.put("v_event",s_event);
			hiddenfieldsJSON.put("selectedsubzone",selectedsubzone);
			hiddenfieldsJSON.put("startdate",startdate);
			hiddenfieldsJSON.put("enddate",enddate);
			hiddenfieldsJSON.put("starthr",starthr);
			hiddenfieldsJSON.put("startmin",startmin);
			hiddenfieldsJSON.put("endmin",endmin);
			hiddenfieldsJSON.put("s_user_id",userID);
			hiddenfieldsJSON.put("inidate",inidate);
			hiddenfieldsJSON.put("er_usertimeline",er_usertimeline);
			hiddenfieldsJSON.put("limitforbg",limitforbg);
			hiddenfieldsJSON.put("getMaxDaysInMonth",getMaxDaysInMonth);
			hiddenfieldsJSON.put("heading",req_heading);
			hiddenfieldsJSON.put("hasVMs",hasVMs);
			hiddenfieldsJSON.put("searchByUser",searchByUser);
			
			if(unknownState !=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
			{
				int pageWidthProces = 1250;
				if(hasAllComponentAccess && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
				{
					pageWidthProces = 1300;
				}
				hiddenfieldsJSON.put("pageWidthProces",pageWidthProces);
			}



				if(a_list!=null && a_list.size()>0)
				{
//Pagination Calculation - Start & End Page Index
					int tempEndIndex = totalNoOfRecPerPage;
					if(pageNo>1)
					{
						start_index_page = ((pageNo-1) * tempEndIndex );
					}

					if(a_list.size() < totalNoOfRecPerPage)
					{
						end_index_page = a_list.size();
					}
					else
					{
						end_index_page = start_index_page + tempEndIndex ;
						if(end_index_page >= a_list.size() )
							end_index_page = a_list.size();
					}
					int diff = end_index_page-start_index_page;
		

					String str_colspan = "8";
					if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
					{
						str_colspan = "9";
		

					}
					else
					{
  		

					}
		

					
					if(printGraph==null && view == null)
					{
						if(str_colspan.equals("9"))
							str_colspan = "11";
						else if (str_colspan.equals("8"))
							str_colspan = "10";
						if(unknownState !=null && !unknownState.equals("UNKNOWN"))
						{
		

						}
						else
						{
						

						}
					}
		

					if(req_heading != null)
						req_heading = com.eg.EgURLDecoder.decode(req_heading,"UTF-8");
					String heading = th_title+req_heading;
					if(printGraph==null && view == null)
					{
						rootJSON.put("gridTitle",heading);
		

					}
					else
					{
		

					}
		

					JSONObject columnDetails =  new JSONObject();
					ArrayList columnNamesForIndex= new ArrayList();

					if(printGraph==null && view == null)
					{
						aListColumnNames.add("C0");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Component Type"));
						columnDetails.put("severity",mappingInfo.getTextDescription("reporter.common.severity"));
						columnDetails.put("compType",mappingInfo.getTextDescription("reporter.common.Component Type"));
						columnNamesForIndex.add("severity");
						columnNamesForIndex.add("compType");
						//columnDetails.put("reporter.common.Comp Type",mappingInfo.getTextDescription("reporter.common.Comp Type");
		

						if(selectedCompType!=null && selectedCompType.equals("Virtual_Machine") || hasOnlyVM)
						{
							aListColumnNames.add("C1");
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Virtual Machine"));
							//columnDetails.put("virtual_machine",mappingInfo.getTextDescription("reporter.common.Virtual Machine"));
							columnDetails.put("compName",mappingInfo.getTextDescription("reporter.common.Virtual Machine"));
							columnNamesForIndex.add("compName");

							//columnDetails.put("reporter.common.Virtual Machine",mappingInfo.getTextDescription("reporter.common.Virtual Machine");

		

						}
						else if (selectedCompType!=null && selectedCompType.equals("All") && hasVMs!=null && hasVMs.equals("true"))
						{
							aListColumnNames.add("C2");
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Component Name / VM"));
							//columnDetails.put("VMandComp",mappingInfo.getTextDescription("reporter.common.Comp Name / VM"));
							columnDetails.put("compName",mappingInfo.getTextDescription("reporter.common.Component Name / VM"));
							columnNamesForIndex.add("compName");
							//columnDetails.put("reporter.common.Comp Name / VM",mappingInfo.getTextDescription("reporter.common.Comp Name / VM");

		

						}
						else
						{
							aListColumnNames.add("C3");
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Component Name"));
							columnDetails.put("compName",mappingInfo.getTextDescription("reporter.common.Component Name"));
							columnNamesForIndex.add("compName");

							//columnDetails.put("reporter.common.Comp Name",mappingInfo.getTextDescription("reporter.common.Comp Name");

		

						}
						aListColumnNames.add("C4");
						aListColumnNames.add("C5");
						aListColumnNames.add("C6");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.SERVICE")+""+mappingInfo.getTextDescription("reporter.common.(S)"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Test"));
						userColumnNames.add(mappingInfo.getTextDescription(th_description));

						columnDetails.put("SERVICE",mappingInfo.getTextDescription("reporter.common.SERVICE")+""+mappingInfo.getTextDescription("reporter.common.(S)"));

						columnDetails.put("test",mappingInfo.getTextDescription("reporter.common.Test"));
						columnNamesForIndex.add("service");
						columnNamesForIndex.add("test");


						if(unknownState !=null && unknownState.equals("UNKNOWN"))
						{
							columnDetails.put("measureOrDesc",mappingInfo.getTextDescription(th_description));
							columnNamesForIndex.add("measureOrDesc");

						}
						else
						{
							columnDetails.put("measureOrDesc",mappingInfo.getTextDescription(th_description));
							columnNamesForIndex.add("measureOrDesc");

						}
		

					}
					else//print no need for json convertion
					{
					
					}

					if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
					{
						aListColumnNames.add("C7");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.User")+""+mappingInfo.getTextDescription("reporter.common.(s)"));
						columnDetails.put("user",mappingInfo.getTextDescription("reporter.common.User")+""+mappingInfo.getTextDescription("reporter.common.(s)"));
						columnNamesForIndex.add("user");

		

					}
						aListColumnNames.add("C8");
						aListColumnNames.add("C9");
						if(unknownState !=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
						{
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Alarm Start Time"));
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Alarm Duration"));
							columnDetails.put("starttime",mappingInfo.getTextDescription("reporter.common.Alarm Start Time"));
							columnDetails.put("duration",mappingInfo.getTextDescription("reporter.common.Alarm Duration"));
						}
						else
						{
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Start Time"));
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Duration"));
							columnDetails.put("starttime",mappingInfo.getTextDescription("reporter.common.Start Time"));
							columnDetails.put("duration",mappingInfo.getTextDescription("reporter.common.Duration"));
						}
						columnNamesForIndex.add("starttime");
						columnNamesForIndex.add("duration");
					if(unknownState !=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
					{
						aListColumnNames.add("C10");
						aListColumnNames.add("C11");
						aListColumnNames.add("C12");
						aListColumnNames.add("C13");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Status"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Time"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Acknowledged by"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Response time"));
						columnDetails.put("ack_status",mappingInfo.getTextDescription("reporter.common.Status"));
						columnDetails.put("ack_time",mappingInfo.getTextDescription("reporter.common.Time"));
						columnDetails.put("ack_user",mappingInfo.getTextDescription("reporter.common.Acknowledged by"));
						columnDetails.put("reponsetime",mappingInfo.getTextDescription("reporter.common.Response time"));
						columnNamesForIndex.add("ack_status");
						columnNamesForIndex.add("ack_time");
						columnNamesForIndex.add("ack_user");
						columnNamesForIndex.add("reponsetime");
					}

					if(printGraph==null && view == null && unknownState !=null && !unknownState.equals("UNKNOWN"))
					{
						columnDetails.put("graph",mappingInfo.getTextDescription("reporter.common.Graph"));
						columnDetails.put("dd",mappingInfo.getTextDescription("reporter.common.DD"));
						columnNamesForIndex.add("graph");
						columnNamesForIndex.add("dd");


					}
					if(printGraph==null && view == null && unknownState !=null && unknownState.equals("UNKNOWN"))
					{
						columnDetails.put("graph",mappingInfo.getTextDescription("reporter.common.Graph"));
						columnNamesForIndex.add("graph");

					}

				rootJSON.put("gridColumnNames",columnDetails);
//Encoding
					er_timeline       = (er_timeline==null)?er_timeline:EgURLEncoder.encode(er_timeline,"UTF-8");
					er_usertimeline   = (er_usertimeline==null)?er_usertimeline:EgURLEncoder.encode(er_usertimeline,"UTF-8");
					limitforbg        = (limitforbg==null)?limitforbg:EgURLEncoder.encode(limitforbg,"UTF-8");
					inidate           = (inidate==null)?inidate:EgURLEncoder.encode(inidate,"UTF-8");
					startdate         = (startdate==null)?startdate:EgURLEncoder.encode(startdate,"UTF-8");
					enddate           = (enddate==null)?enddate:EgURLEncoder.encode(enddate,"UTF-8");
					starthr           = (starthr==null)?starthr:EgURLEncoder.encode(starthr,"UTF-8");
					endhr             = (endhr==null)?endhr:EgURLEncoder.encode(endhr,"UTF-8");
					startmin          = (startmin==null)?startmin:EgURLEncoder.encode(startmin,"UTF-8");
					endmin            = (endmin==null)?endmin:EgURLEncoder.encode(endmin,"UTF-8");
					s_user_id         = (s_user_id==null)?s_user_id:EgURLEncoder.encode(s_user_id,"UTF-8");
					getMaxDaysInMonth = (getMaxDaysInMonth==null)?getMaxDaysInMonth:EgURLEncoder.encode(getMaxDaysInMonth,"UTF-8");

					if(choosenComponents!=null)
					{
						List temp_choosenComponents=new LinkedList(choosenComponents);
						choosenComponents=new LinkedList();
						
						//replacing special character
						for(int n=0;temp_choosenComponents.size()>n;n++)
						{
						String tmpcomp=(String)temp_choosenComponents.get(n);
						if(tmpcomp.indexOf("|plus|")>-1)
						{
						tmpcomp=StringUtils.replace(tmpcomp,"|plus|","+");
						}
						if(tmpcomp.indexOf("|amp|")>-1)
						{
							tmpcomp=StringUtils.replace(tmpcomp,"|amp|","&");
						}
						if (tmpcomp.indexOf("|pct|")>-1)
						{
							tmpcomp=StringUtils.replace(tmpcomp,"|pct|","%");
						}
						if (tmpcomp.indexOf("|hash|")>-1)
						{
							tmpcomp=StringUtils.replace(tmpcomp,"|hash|","#");
						}
						choosenComponents.add(tmpcomp);
						}
						//end
					}

					

					JSONArray alarmArray =  new JSONArray();
					Vector vecDefaultDDEnabledCompType =  egFormat.getVariables("Default_DDEnabled",true);
					Vector vecDefaultDDWithoutInfos =  egFormat.getVariables("Tests_For_DDWithoutInfos",true);
					egurkha.TestBean testBean = new egurkha.TestBean();
					com.eg.EgSpecsInfo specsInfo = new com.eg.EgSpecsInfo("manager");
					com.eg.EgAgentInfo agentInfo = new com.eg.EgAgentInfo("manager");
					com.eg.EgFormatInfo formatInfo = new com.eg.EgFormatInfo("manager");
					for(int a=start_index_page;a<end_index_page;a++)
					{
//session values
						String[] check = (String[])a_list.get(a);
						/*for(int i=0;i<check.length;i++)
							out.println("<BR> i = "+i+" check--- "+check[i]);*/
						String site = check[1];
						String component = check[2];
						String comp_with_port = component;

						String compTypeName = check[3];
						String compotype = check[3];
						String strType = compotype;

						String desc = check[4];
						String tests = check[5];
						String measure= check[6];

 						String svrty="";
						String s_time="";
						String	e_time="";
						long timeDiff =0l;
						String str_compType = "";
						String str_service = "";
						String display_Str           = "";
						String ack_status = "Yet to be acknowledged";
						String ack_time = "-";
						String ack_user = "-";
						long responseTime = 0;
						boolean size_check = false;
						if(unknownState!=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
						{
							svrty = check[8];
							s_time = (String)check[9];
 							timeDiff = Long.parseLong((String)check[10]);
							if((String)check[12]!=null)
							{
								ack_status = (String)check[12];
								if(ack_status.equalsIgnoreCase("Acknowledgement"))
									ack_status = "Acknowledged";
								if(ack_status.equalsIgnoreCase("Unacknowledgement"))
									ack_status = "Unacknowledged";
							}
							if((String)check[13]!=null)
								ack_time = (String)check[13];
							if((String)check[14]!=null)
								ack_user = (String)check[14];
							if((String)check[15]!=null)
								responseTime =Long.parseLong((String)check[15]);
						}
						else if(unknownState!=null && !unknownState.equals("UNKNOWN"))
						{
 							svrty = check[8];
							//System.out.println("svrty--->"+svrty);
							s_time = (String)check[9];
 							timeDiff = Long.parseLong((String)check[10]);
 							if(check!=null && check.length>12)
							{
								str_compType = check[11];
								str_service = check[12];
  								size_check = true;
							}
						}
						else
						{
 							svrty = "UNKNOWN";
							s_time = (String)check[8];
  							timeDiff = Long.parseLong((String)check[9]);

 								if(check!=null && check.length>10)
								{
									str_compType = check[10];
									str_service = check[11];
									size_check = true;
								}
						}
						svrty += optClassName;

						String parameter             = "";
						String operation_App_Url     = "";
						String executive_Service_Url = "";
						String service               = "";
						String comp_info             = "";
						String duration              = "Current";
						String s_sttime              = s_time;
						String graph_Url             = "";
						String comp                  = null;
						String tmp_tests             = tests;
						String display_measure       = measure;
						String displayUsers          = "",
								displayUsersInTitle  = "";
						boolean defaultLoop=true;
						String select_vm="";
						String infoForGraph="";
						String modifiedDescForVM="";
						String strTempCompType=compTypeName;
						String responseTimeStr = "-";
						if(hasVMs!=null && hasVMs.equals("true"))
						{
							if(selectedCompType!=null && (selectedCompType.equals("All") || selectedCompType.equals("Virtual_Machine")))
							{
								boolean vmSelected=false;
								for(int ii=0;choosenComponents.size()>ii;ii++)
									if(a_userVMs.contains(choosenComponents.get(ii))){
										vmSelected=true;
								}
								if(vmSelected)
								{
									modifiedDescForVM=desc;
									if(modifiedDescForVM.indexOf("{")>-1 && modifiedDescForVM.indexOf("}")>-1)
									{
										String vm_info=modifiedDescForVM.substring(modifiedDescForVM.indexOf("{")+1,modifiedDescForVM.indexOf("}"));
										infoForGraph=vm_info;
										if(vm_info.indexOf(":")>-1)
											vm_info=vm_info.substring(0,vm_info.indexOf(":"));
										if(choosenComponents.contains(vm_info))
										{
											defaultLoop=false;
											select_vm=vm_info;
											comp_info="VM";
											if(modifiedDescForVM.indexOf(vm_info+":")>-1)
												modifiedDescForVM=StringUtils.replace(modifiedDescForVM,vm_info+":","");
											else
												modifiedDescForVM=StringUtils.replace(modifiedDescForVM,vm_info,"");
											if(modifiedDescForVM.endsWith("{}"))
												modifiedDescForVM=modifiedDescForVM.substring(0,modifiedDescForVM.indexOf("{"));
											if(service.equalsIgnoreCase("NULL") || service.equalsIgnoreCase("NONE"))
											{
												service="-";
											}
											if(display_Str.equals("NULL") || display_Str.equals(""))
												display_Str = "-";
										}
									}
								}
								else
								{
									defaultLoop=true;
								}
							}
							else
							{
								defaultLoop=true;
							}
						}
						if(defaultLoop)
						{
							if(!component.toUpperCase().endsWith(":NULL"))
							{
								component=component;
							}
							else if(component.toUpperCase().endsWith(":NULL"))
							{
								component=component.substring(0,component.indexOf(":"));
							}

							if(service.equalsIgnoreCase("NULL") || service.equalsIgnoreCase("NONE"))
							{
								service="-";
							}
	//if 'Sort by!=Start Time' then 'size_check=true'.
							if(!size_check)
							{
								//to get real type for hostsystem.
								String port = comp_with_port.substring(comp_with_port.indexOf(":")+1);
								String str_comp = comp_with_port.substring(0,comp_with_port.indexOf(":"));
								if(port.equalsIgnoreCase("NULL") && str_comp!=null && !str_comp.equals(""))
								{
									if(!"All".equalsIgnoreCase(selectedCompType))
									{
										strTempCompType=selectedCompType;
									}else
									{
										EgDiscInfo egDisc = new EgDiscInfo("manager");
										List list = egDisc.getServerTypesForNick(str_comp);
										if(list.size()>0){
											strTempCompType = list.get(0).toString();
										}
									}
								}


								comp_info = mappingInfo.getComponentTypeDescription(strTempCompType);
								//discInfoHelper.getCompTypeForHostSystem(strType,comp_with_port,tests,hasAllComponentAccess,mappingInfo,userCompList);

								display_Str = esmb.getServiceNamesForComponent(resultServiceNamesForComp,strType,comp_with_port,service,siteNames,hasAllComponentAccess);
							}
							else
							{
								comp_info = str_compType;
								display_Str = str_service;
							}

						if(display_Str.equals("NULL") || display_Str.equals(""))
							display_Str = "-";
						else
							display_Str = display_Str.trim();

						if(desc.indexOf("{")>-1 && desc.indexOf("}")>-1)
						{
							infoForGraph=desc.substring(desc.indexOf("{")+1,desc.indexOf("}"));
						}

						}

	 					if(searchByUser !=null && !searchByUser.equals("") && searchBy.trim().equalsIgnoreCase("Service"))
						{
							if(display_Str.indexOf(searchByUser)==-1)
								continue;
						}

						s_sttime = DateUtil.changeDateFormat(s_sttime,"MM/dd/yy HH:mm","MM/dd/yyyy HH:mm");
						String strDDstartTime = s_sttime;
						s_sttime = s_sttime.substring(0,16);

						String s_starttime = s_sttime.substring(0,10);
						String sthrmin = s_sttime.substring(10,16);
						String strgaphstarttime = s_sttime;
						strgaphstarttime=DateUtil.changeDateFormat(strgaphstarttime,"MM/dd/yyyy HH:mm","dd/MM/yyyy HH:mm");
						s_sttime = DateUtil.changeDateFormat(s_starttime,"MM/dd/yy",currentDateFormat)+" "+sthrmin;
						EgTimeZoneConverter converterStart = new EgTimeZoneConverter(s_sttime,thisuser);
					if(ack_time!=null && !ack_time.equals("-"))
					{
						Timestamp timeStmp = Timestamp.valueOf(ack_time);
						long ack_timeVal = timeStmp.getTime();
						 java.util.Date ack_timeDate = new  java.util.Date(ack_timeVal);
						SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" HH:mm:ss");
						ack_time = formatter.format(ack_timeDate);
					}
						SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
						Calendar calendar = Calendar.getInstance();
						if(timeDiff>0)
							duration = DateTimeTokenizer.getTimeDifference(timeDiff);
					if(responseTime>0)
						responseTimeStr = DateTimeTokenizer.getTimeDifference(responseTime);
						String strDDendDate = "";
						String strDDstartDateHr = "";
						String strDDendDateHr = "";
						String strDDStartDateMin = "";
						String strDDendDateMin = "";
						try{
						if (timeDiff < 0)
						{
							calendar.setTime(new java.util.Date(new EgDateInfo().egetUTCDate(false)));
						}
						else
						{
							java.util.Date startDate_1 = new java.util.Date(strDDstartTime);
							long endTimelong = 0;
							if(timeDiff<3600)
								endTimelong = startDate_1.getTime()+3600*1000;
							else
								endTimelong = startDate_1.getTime()+timeDiff*1000;
							java.util.Date enddate_d = new java.util.Date(endTimelong);
							calendar.setTime(enddate_d);
						}
						String strDDendTime = sdf.format(calendar.getTime());
						if(strDDendTime!=null && strDDendTime.indexOf(" ")>-1)
						{
							strDDendDate = strDDendTime.substring(0,strDDendTime.indexOf(" "));
							String stDDendhrmin = strDDendTime.substring(strDDendTime.indexOf(" ")+1);
							strDDendDate=DateUtil.changeDateFormat(strDDendDate,"dd/MM/yyyy",currentDateFormat);
							if(stDDendhrmin!=null && stDDendhrmin.indexOf(":")>-1)
							{
								StringTokenizer stToken = new StringTokenizer(stDDendhrmin,":");
								strDDendDateHr = stToken.nextToken();
								if(stToken.hasMoreTokens())
									strDDendDateMin = stToken.nextToken();
							}
						}
							if(sthrmin!=null && sthrmin.indexOf(":")>-1)
							{
								StringTokenizer stToken = new StringTokenizer(sthrmin,":");
								strDDstartDateHr = stToken.nextToken();
								if(stToken.hasMoreTokens())
									strDDStartDateMin = stToken.nextToken();
							}
						}catch(Exception e){}
 						String disp_measure = mappingInfo.getMeasureDescription(tests,measure);
						tests = mappingInfo.getTestDescription(tests);
						//tests = StringUtils.split(tests,14);
						//component = StringUtils.split(component,20);
						compotype = mappingInfo.getComponentTypeDescription(compotype);
						//compotype = StringUtils.split(compotype,20);

						if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
						{
							List disp_user_list = null;
							if(printGraph==null && view == null)
							{
								disp_user_list = helper.getUserAssociatedWithSpecifiedComp(resultUserCompMap,strType,comp_with_port,"submit");
							}
							else
							{
								disp_user_list = helper.getUserAssociatedWithSpecifiedComp(resultUserCompMap,strType,comp_with_port,"print");
							}
							if(disp_user_list!=null && disp_user_list.size()>0)
							{
								displayUsers = (String)disp_user_list.get(0);
								if(displayUsers!=null && !displayUsers.equals("-"))
									displayUsersInTitle = (String)disp_user_list.get(1);
							}
						}

//Setting Links URL for Submit Results.
//This loop is not executed other than Submit page.
//Not Executed for Print,Mail,Save,Pdf,Schedule.
						if(printGraph==null && view == null)
						{
//Corresponding Component Type of Host System
							if(compTypeName!=null && compTypeName.equalsIgnoreCase("Host_system") && comp_with_port!=null && !comp_with_port.equals(""))
							{
								compTypeName=strTempCompType;
								/*String port = comp_with_port.substring(comp_with_port.indexOf(":")+1);
								String str_comp = comp_with_port.substring(0,comp_with_port.indexOf(":"));
								if(port.equalsIgnoreCase("NULL") && str_comp!=null && !str_comp.equals(""))
								{
									EgDiscInfo egDisc = new EgDiscInfo("manager");
									List list = egDisc.getServerTypesForNick(str_comp);
									if(list.size()>0){
										compTypeName = list.get(0).toString();
									}
								}*/
							}
							if(comp_with_port!=null && compTypeName!=null)
								comp = comp_with_port+":"+compTypeName;
//Encoding
							String s_compTypeName = (compTypeName==null)?compTypeName:EgURLEncoder.encode(compTypeName,"UTF-8");
							String s_comp         = (comp==null)?comp:EgURLEncoder.encode(comp,"UTF-8");
							String str_analysis = request.getParameter("eventfor");
//to select the service link which is get selected
							String display_service = display_Str;
							if(display_service!=null && !display_service.equals("-") && display_service.indexOf(",")>-1)
							{
								StringTokenizer str = new StringTokenizer(display_service,",");
								if(str_analysis!=null && str_analysis.equalsIgnoreCase("Service"))
								{
									String str_selectedService = request.getParameter("event_select");
									while(str.hasMoreTokens())
									{
										String services = str.nextToken();
										 if(str_selectedService!=null && services.equalsIgnoreCase(str_selectedService))
											display_service = services;
									}
								}else
								{
									if(str.hasMoreTokens())
									{
										display_service = str.nextToken();
									}
								}
							}

							String s_display_Str  = (display_Str==null)?display_Str:EgURLEncoder.encode(display_service,"UTF-8");
//Setting Links URL
							parameter = "&startdate="+startdate+"&enddate="+enddate+"&er_timeline="+er_timeline+"&isSubmit=true&enableBack=true&backServletName=/servlet/com.eg.ErAlarmHistoryC?&er_mode=3D&";

							String tmp = "";
							if(s_event!=null && s_event.equalsIgnoreCase("Component"))
								tmp = "Components";
							else
								tmp = s_event;
							
							if(defaultLoop)
							{
								operation_App_Url = "../reporter/ErReporterMenu.jsp?er_reportType=operation&call=json&isSubmit=true&er_rtype=Application&er_bgreportfrom=Operation_Application&trendenable=true&er_gtype=Measure&reporttype=operation&us_id="+s_user_id+"&er_comptype="+s_compTypeName+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+startmin+"&endmin="+endmin+"&userID="+s_user_id+"&uid="+s_user_id+"&er_component="+comp+"&fromFavSch=true&er_trenddata=No&er_option="+tmp+"&er_subzone="+selectedsubzone+"&er_group="+subevent+parameter;
							}
							else
							{
								
						
								operation_App_Url="../servlet/com.eg.ErEsxVMServerReportC?er_usertimeline=-1&call=json&isSubmit=true&ervm_disp=No&trendenable=true&er_reportgenration=foreground&forwardto=ErEsxGuestVMReport&er_trgttype=Virtual_Machine_Details&er_check=Virtualization&vmStrData=&er_mode=3D&er_ViewName=ErEsxGuestVMReport.jsp&er_type=Yes&fromSchedule=null&schedule_id=null&isSubmit=true&isVmReport=null&er_bgreportfrom=Virtualization_VM_Virtual_Resource&savereport=save&er_trenddata=No&detailtime=-1&servletName=com.eg.ErEsxVMServerReportC&er_timeline="+er_timeline+"&er_measure=All&er_rtype=Virtualization&reqfrom=vmGuest&enableBack=true&backServletName=/servlet/com.eg.ErAlarmHistoryC?&minto=00&minfrom=00&timeto=24&timefrom=00";
								operation_App_Url+="&userID="+s_user_id+"&er_comptype="+s_compTypeName+"&er_excwe=No&er_excweekend=No&er_component="+s_comp+"&select_vm="+EgURLEncoder.encode(select_vm,"UTF-8");
								operation_App_Url+="&er_stdate="+startdate+"&er_enddate=" +enddate+ "&er_sthr=" + starthr + "&er_endhr=" + endhr + "&startmin="+ startmin + "&endmin=" + endmin;
								operation_App_Url+="&startdate=" +startdate+ "&enddate=" + enddate+ "&starthr=" + starthr + "&endhr=" + endhr;
								operation_App_Url+="&st_date="+startdate+"&en_date="+enddate+"&isOnlyVMAssigned=true";
							}
//out.println("operation_App_Url = "+operation_App_Url);

							executive_Service_Url = "../servlet/com.eg.ErControllerServlet?er_trenddata=Yes&call=json&isSubmit=true&reporttype=executive&er_selection="+s_display_Str+"&font=CODE2000&forwardto=ErMacro&starthr=0&eruserid="+s_user_id+"&er_trgttype=Service&er_ViewName=ErMacro.jsp&servletName=com.eg.ErControllerServlet&endmin=&er_view=GRAPH&endhr=0&startmin=&er_rtype=Macro&er_bgreportfrom=Executive_Service&"+parameter;

							measure = db_Info.getColumnForMeasure(tmp_tests,measure);
							String strAlertstrHr=starthr;
							String strAlertstrMin=startmin;
							String strAlertEndHr=endhr;
							String strAlertendMin=endmin;
							if(strgaphstarttime!=null && strgaphstarttime.indexOf(" ")>-1)
							{
								strAlertstrHr=strgaphstarttime.substring(strgaphstarttime.indexOf(" ")+" ".length());
								strAlertstrHr.trim();
								strgaphstarttime = strgaphstarttime.substring(0,strgaphstarttime.indexOf(" "));
								if(strAlertstrHr!=null && strAlertstrHr.indexOf(":")>-1)
								{
									strAlertstrMin = strAlertstrHr.substring(strAlertstrHr.indexOf(":")+1);
									strAlertstrHr = strAlertstrHr.substring(0,strAlertstrHr.indexOf(":"));
								}
								strgaphstarttime = DateUtil.changeDateFormat(strgaphstarttime,"dd/MM/yyyy",currentDateFormat);
								strgaphstarttime = EgURLEncoder.encode(strgaphstarttime,"UTF-8");
							}

							graph_Url = "option=graph&er_trgttype=Server+Report+&er_rtype=Snapshot&er_gtype=intrasnap&startdate="+strgaphstarttime+"&enddate="+strDDendDate+"&starthr="+strAlertstrHr+"&endhr="+strDDendDateHr+"&startmin="+strAlertstrMin+"&endmin="+strDDendDateMin+"&er_timeline=Any&er_test="+tmp_tests+"&er_disp_meas="+display_measure+"&er_measure="+measure+"&er_component="+s_comp+"&er_sid=&er_site=&inidate="+inidate+"&&userID="+s_user_id+"&er_trenddata=No&drilldownenabled=Yes&showLegend=true";
							graph_Url+="&er_info_list="+EgURLEncoder.encode(infoForGraph,"UTF-8")+"&select_vm="+EgURLEncoder.encode(infoForGraph,"UTF-8");
							
							if(!defaultLoop)
								graph_Url+="&isOnlyVMAssigned=true";
							else
								graph_Url+="&isFromAlarmHistory=true";

						}
		

						int jk=0;
						JSONObject alaramDetails = new JSONObject();
						alaramDetails.put(columnNamesForIndex.get(jk),svrty);
						jk++;
						if(printGraph==null && view == null)
						{
//Main Page Results part
							int displayLength=18;
							/*if(component!=null && component.length()>20)
							{
								component = component.substring(0,18)+"...";
							}*/
							alaramDetails.put(columnNamesForIndex.get(jk),comp_info);
							jk++;


						String strDispComponentTemp = component;
						if(!defaultLoop)
						{
							strDispComponentTemp=select_vm;
						}
						//else
						//{
							//alaramDetails.put("compName",component);
						//}
							alaramDetails.put(columnNamesForIndex.get(jk),strDispComponentTemp+"~"+operation_App_Url);
							jk++;

							if(display_Str!=null && !display_Str.equals("-"))
							{
								alaramDetails.put(columnNamesForIndex.get(jk),display_Str+"~"+executive_Service_Url);
								jk++;
	
							}
							else
							{
							alaramDetails.put(columnNamesForIndex.get(jk),display_Str);
							jk++;
	
							}
							alaramDetails.put(columnNamesForIndex.get(jk),tests);
							jk++;
		
			String DispDesc = desc;
			if(!defaultLoop)
				DispDesc=modifiedDescForVM;
			if(!unknownState.equals("UNKNOWN"))
			{
				alaramDetails.put(columnNamesForIndex.get(jk),DispDesc);
				jk++;
		

			}
			else
			{
				alaramDetails.put(columnNamesForIndex.get(jk),disp_measure);
				jk++;
			
			}
							if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
							{
								alaramDetails.put(columnNamesForIndex.get(jk),displayUsers);
								jk++;

							}
								alaramDetails.put(columnNamesForIndex.get(jk),converterStart.getDateTime());
								jk++;
								alaramDetails.put(columnNamesForIndex.get(jk),duration);
								jk++;
			if(unknownState!=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
			{
				alaramDetails.put(columnNamesForIndex.get(jk),ack_status);
				jk++;
				alaramDetails.put(columnNamesForIndex.get(jk),ack_time);
				jk++;
				alaramDetails.put(columnNamesForIndex.get(jk),ack_user);
				jk++;
				alaramDetails.put(columnNamesForIndex.get(jk),responseTimeStr);
				jk++;
			}
								alaramDetails.put(columnNamesForIndex.get(jk),graph_Url);
								jk++;

							//String ddEnableForCompType = egFormat.getValue("Default_DDEnabled", compTypeName);
							boolean isddEnabled = false;
							if(vecDefaultDDEnabledCompType!=null && vecDefaultDDEnabledCompType.contains(compTypeName));
								isddEnabled	= true;

							String tmp_comp = "";


							boolean isAgentlessServer = agentInfo.isAgentlessServer(component, compTypeName, true);
							boolean isTestExternal = specsInfo.isTestExternal(tmp_tests.trim());
							boolean isDdEnableTestMeas = formatInfo.isDdEnabled(tmp_tests.trim(),display_measure.trim());

							String ddEnable ="No";
							if (ddEnabled && isDdEnableTestMeas && (!isAgentlessServer || isTestExternal || isddEnabled))
							{
								ddEnable = "Yes";
							}

							String port = "";
							if(comp_with_port!=null && comp_with_port.indexOf(":")>-1)
								port = comp_with_port.substring(comp_with_port.indexOf(":")+1);

							String info = "";
							if(desc!=null && desc.indexOf("{")>-1)
								info = "*"+desc.substring(desc.indexOf("{")+1,desc.indexOf("}"));
							else
								info = "*";

							EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
							String layer = tablesInfo.getRelevantLayer(compTypeName, tmp_tests.trim(), display_measure.trim());

							if(component!=null && component.indexOf(":")>-1)
							{
								component=component.substring(0,component.indexOf(":"));
							}
							if(port!=null && port.indexOf(":")>-1)
							{
								info=port.substring(port.indexOf(":")+1)+info;
								port=port.substring(0,port.indexOf(":"));
							}
							//String dd_url = "/final/monitor/EventsGraph.jsp?pageToShow=diagnosis&url=EgDiagnosis.jsp?site="+site+"&host="+com.eg.EgURLEncoder.encode(component,"UTF-8")+"&port="+port+"&test="+tmp_tests+"&info="+info+"&from=0&measure="+display_measure+"&firsttime=true&comeFrom=Reporter&newWindow=true&flag=1&starttime="+startdate+"&endtime="+enddate+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+startmin+"&timeline="+er_timeline+"&endmin="+endmin+"&msmt_host="+com.eg.EgURLEncoder.encode(check[7],"UTF-8")+"&inidate="+inidate+"&layer="+layer+"&comptype="+compTypeName+"&popup=true&newWindow=true";   ///Reporter inside of view
							
						String dd_url = "/final/monitor/componentMeasureTabSet.jsp?type="+EgURLEncoder.encode(compTypeName,"UTF-8")+"&site="+site+"&host="+EgURLEncoder.encode(component,"UTF-8")+"&port="+port+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&state="+s_state+"&messy="+measure+"&msmt_host="+EgURLEncoder.encode(check[7],"UTF-8")+"&userID="+EgURLEncoder.encode(urs,"UTF-8")+"&test="+ tmp_tests+"&comptype="+compTypeName+"&measureDisp="+display_measure+"&starttime="+strgaphstarttime+"&endtime="+strDDendDate+"&starthr="+strDDstartDateHr+"&endhr="+strDDendDateHr+"&startmin="+strDDStartDateMin+"&endmin="+strDDendDateMin+"&from=measurespage&dd=yes&clicked=dd&newWindow=true&fromReporterHis=true&popup=true&fromPage=eveHist";

							
						
							//String dLink = "/final/monitor/EgDiagnosis.jsp?site="+site+"&host="+EgURLEncoder.encode(component,"UTF-8")+"&port="+port+"&test="+tmp_tests+"&isPopUp=true&comptype="+compTypeName+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(check[7],"UTF-8")+"&measure="+display_measure+"&from=0&firsttime=true&flag=1";
							
						
							//linksMap.put(tmp_tests+"#"+measure+"#"+info+"#"+check[7]+"compddlink", dLink);

							if(!defaultLoop)//murali
								dd_url+="&isVM=true";
							StringBuffer key = new StringBuffer(32);
							key.append(tmp_tests.trim());
							key.append(":");
							key.append(display_measure.trim());
							String tm = key.toString();
							//String disInfo = egFormat.getValue("Tests_For_DDWithoutInfos",tm);
							//if(disInfo!=null && disInfo.equalsIgnoreCase("Yes"))
							if(vecDefaultDDWithoutInfos!=null && vecDefaultDDWithoutInfos.contains(tm))
							{
								info = "+";
							}
							else
							{
								if(info!=null)
								{
									if(info.indexOf("+")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"+","|plus|");
									}
									if(info.indexOf("&")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"&","|amp|");
									}
									if(info.indexOf("%")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"%","|pct|");
									}
									if(info.indexOf("#")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"#","|hash|");
									}
									if(info.indexOf("*")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"*","+");
									}
								}
							}
							if(unknownState!=null &&  !unknownState.equals("UNKNOWN"))
							{
								if(ddEnable!=null && !ddEnable.equals("") && ddEnable.equalsIgnoreCase("Yes"))
								{
									alaramDetails.put(columnNamesForIndex.get(jk),dd_url);
										jk++;
							}
							else
							{
										alaramDetails.put(columnNamesForIndex.get(jk),"-");
										jk++;

		

							}
						}
						alarmArray.add(alaramDetails);
					}

					}

					rootJSON.put("alarmGridValues",alarmArray);
					String startDate = startdate + " " + starthr + ":" + startmin;
					String endDate = enddate + " " + endhr + ":" + endmin;

					HashMap tmp_map = new HashMap();
					tmp_map.put("startDate",startDate);
					tmp_map.put("endDate",endDate);
					tmp_map.put("showUsers",showUsers);
					tmp_map.put("selectedUser",selectedUser);
					tmp_map.put("hasAllComponentAccess",new Boolean(hasAllComponentAccess));
					tmp_map.put("mappingInfo",mappingInfo);
					tmp_map.put("currentDateFormat",currentDateFormat);
					tmp_map.put("siteNames",siteNames);
					tmp_map.put("userCompList",userCompList);
					tmp_map.put("resultUserCompMap",resultUserCompMap);
					tmp_map.put("hasVMs",hasVMs);
					tmp_map.put("selectedCompType",selectedCompType);
					tmp_map.put("a_userVMs",a_userVMs);
					tmp_map.put("unknownState",unknownState);
					tmp_map.put("searchByUser",searchByUser);
					tmp_map.put("searchBy",searchBy);
					tmp_map.put("resultServiceNamesForComp",resultServiceNamesForComp);
					tmp_map.put("choosenComponents",choosenComponents);
					tmp_map.put("aListColumnNames",aListColumnNames);
					tmp_map.put("userColumnNames",userColumnNames);
					tmp_map.put("a_list",a_list);
					tmp_map.put("MainTitle",(String)session.getAttribute("MainTitle"));
					tmp_map.put("SubTitle",(String)session.getAttribute("SubTitle"));
					tmp_map.put("reporttype",(String)session.getAttribute("reporttype"));
					tmp_map.put("subReportType",(String)session.getAttribute("subReportType"));
					tmp_map.put("thisLanguage",language);
					session.setAttribute("tmp_map",tmp_map);
				}
	rootJSON.put("hiddenfields",hiddenfieldsJSON);
	//session.setAttribute("Tablinks", linksMap);
	Enumeration  it = session.getAttributeNames(); 
	while (it.hasMoreElements()) { 
		String name = (String)it.nextElement(); 
		String value = session.getAttribute(name).toString(); 
		//System.out.println( "Session Names==== " + name);
		//System.out.println( "Session value==== " + value);
	}
	//System.out.println("rootJSON----alarmhistory result-->"+rootJSON);
	out.println(rootJSON.toString());
	}catch(Throwable yy)
	{
		yy.printStackTrace();
	}

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
