package org.apache.jsp.reporter;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.*;
import java.io.*;
import java.sql.*;
import egurkha.*;
import egurkha.reporter.*;
import com.egurkha.*;
import com.egurkha.ini.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.IniFile;
import com.eg.EgDateInfo;
import com.eg.EgInstallInfo;
import com.eg.EgServicesInfo;
import com.eg.EgMappingInfo;
import com.egurkha.util.DateUtil;
import com.egurkha.util.StringUtils;
import com.egurkha.util.DateUtil;
import com.egurkha.util.DateTimeTokenizer;
import com.eg.EgReportInfo;
import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgDbInfo;
import com.eg.EgDisableInfo;
import com.eg.EgGroupInfo;
import com.eg.EgMappingInfo;
import com.eg.EgName;
import com.eg.EgTablesInfo;
import com.eg.EgTestInfo;
import com.eg.EgDiscInfo;
import com.eg.EgTopoInfo;
import com.eg.MappingNameSorter;
import java.text.SimpleDateFormat;

public final class ErInfrastructureHealthReportPrint_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

private static final String BLANK_SPACE = " ";
	private static final String COMA = ",";
	private static final String COLON = ":";
	private static final String PIE = "|";
	private static final String BSLASH = "/";
	private static final String UTF_8 = "UTF-8";
	private static final String NODATAFOUND = "NO_DATA_FOUND";
	private static final String CRITERIAONLY = "CRITERIA_ONLY_FLAG";
	private static final String VMNODATA = "DATA_FOR_VM";
	private static final String MANAGER = "manager";
	private static final String INFRASTRUCTURE_HEALTH_REPORT = "INFRASTRUCTURE_HEALTH_REPORT";
	private static final String HEALTHREPORT_MEASURE_MAPPING = "HEALTHREPORT_MEASURE_MAPPING";
	private static final String SORTABLE = "<div style='float:left;padding:2px 2px 0px 2px;'><img src='/final/images/Light/sortable_white.png' class='png'/></div>";
	private static final String SORTED_UP = " <div style='float:left;padding:0px 2px 2px 2px;'><img src='/final/images/Light/sorted_up.png' class='png'/></div>";
	private static final String SORTED_DOWN = "<div style='float:left;padding:0px 2px 2px 2px;'><img src='/final/images/Light/sorted_down.png' class='png'/></div>";

	public String[] getUserComponent(String[] strTempcomponent,Vector v_userComponent)
	{
		java.util.ArrayList aList = new java.util.ArrayList();
		String[] returnArr = null;
		if(strTempcomponent == null || v_userComponent == null)
			return null;
		for(int t=0; t<strTempcomponent.length; t++)
		{
			String componentName = strTempcomponent[t];
			String strTempCompName = componentName;
			if(componentName!=null && componentName.indexOf(":")>-1){
				strTempCompName = componentName.substring(componentName.indexOf(":")+1)+":"+componentName.substring(0,componentName.indexOf(":"));
			}
			if(v_userComponent!=null && v_userComponent.contains(strTempCompName))
			{
				aList.add(componentName);
			}
		}
		if(aList!=null && aList.size()>0)
		{
			returnArr = new String[aList.size()];
			for(int i=0;i<aList.size();i++)
			{
				returnArr[i]=(String)aList.get(i);
			}
		}
		return returnArr;
	}
	public ArrayList getAllServerGroups()
	{
		ArrayList grp = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects = iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				grp.add(Subjects[i]);
			}
			Collections.sort(grp,String.CASE_INSENSITIVE_ORDER);
			grp.add("OTHERS");
			//if (isICEnabled())
			//{
			//	grp.add("USER-DEFINED_SERVERS");
			//}
			grp.remove("AGGREGATES");
			return grp;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return new ArrayList();
		}
	}
	public ArrayList getCategorizedComponents(String compGroup)
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();

			String [] variables = iniFile.getVariables(compGroup);
			for (int j = 0;j<variables.length;j++)
			{
				comGroups.add(variables[j]);
			}
		}
		catch (Exception e)
		{
			return new ArrayList();
		}
		return comGroups;
	}

	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					initial = initial + sub;
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}
	public int getComponentTypeCount(List aListCompType ,Map keyValueMap)
	{
		int returnval=1;
		if(aListCompType == null || aListCompType.size()==0)
			return returnval;
		if(keyValueMap == null || keyValueMap.size()==0)
			return returnval;
		int comptypesize = aListCompType.size();
		EgReportInfo reportInfo = new EgReportInfo("manager");
		com.eg.EgSpecsInfo specsInfo = new com.eg.EgSpecsInfo("manager");
		EgTablesInfo tablesInfo = new EgTablesInfo("manager");
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		com.eg.IniFile dbaseUI = new com.eg.IniFile(s_iniFile_dir + "eg_dbase.ini");
		for(int i=0;i<aListCompType.size();i++)
		{
			String componentType = (String)aListCompType.get(i);
			List keysList = (ArrayList) keyValueMap.get(componentType);
			//
			boolean showComp = false;
			for(int k=0; k<keysList.size(); k++)
			{
				String tempKey = (String) keysList.get(k);
				String tempKeys = tempKey;
				if (tempKey.indexOf("#$#") > -1)
					tempKeys = tempKey.substring(0,tempKey.indexOf("#$#"));
				String tempDisp = reportInfo.getValue("HEALTHREPORT_MEASURE_MAPPING",tempKeys);
				if(tempDisp == null || tempDisp.length()==0)
				{
					ArrayList aListLayerTest = tablesInfo.getTestsForLayer (tempKeys,componentType);
					for (int m=0; m<aListLayerTest.size();m++ )
					{
						if(tempDisp == null || tempDisp.length() ==0)
							tempDisp = (String) aListLayerTest.get(m);
						else
							tempDisp +=","+(String) aListLayerTest.get(m);
					}
				}
				StringTokenizer ts = new StringTokenizer(tempDisp,",");
				while(ts.hasMoreTokens())
				{
					String tempTest = ts.nextToken();
					if(tempTest.indexOf("#$#") != -1)
						tempTest =tempTest.substring(tempTest.indexOf("#$#")+3);
					if (tempTest.indexOf(":") > -1)
					{
						tempTest = tempTest.substring(0,tempTest.indexOf(":"));
					}
					if (!StringUtils.isNull(dbaseUI.getValue("DYN_TABLES",tempTest.trim())) && specsInfo.isTestRelevantForServer(componentType,tempTest))
					{
						showComp=true;
					}
				}
			}
			//
			if(!showComp)
				comptypesize = comptypesize-1;
		}
		return comptypesize;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/reporter/ErTracker.jsp");
  }

  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.release();
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("<!DOCTYPE html>\n\n");

/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


//	response.setHeader("Cache-Control","no-store");
//	response.setHeader("Pragma","no-cache");
//	response.setDateHeader ("Expires", -1);
	
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	String imageName = null;
	IniUI egui = IniUI.getInstance();
	imageName = egui.getReporterHomeLogo();
	String productionMode = egui.getValue("UI_MIGRATION","SenchaProductionMode");
	String reportLastAccessedURL = (String)session.getAttribute("reportLastAccessedURL");

	//added for ajax timeout
	 IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_report.ini");
	 long maxTimelineDiff_ms =ErHighchartUtils.getTimeLimitForHighChart();
	 String maxTimelineINI = iniFile.getValue("CHART_TYPE","Timeline");
	 String Yaxis = iniFile.getValue("CHART_TYPE","YaxisBasedOnData");
	 if(Yaxis!=null && Yaxis.equals(""))
		Yaxis = "True";
	 String BarAndPieChartType = iniFile.getValue("CHART_TYPE","BarAndPieChartType");
	 if(BarAndPieChartType==null || BarAndPieChartType.length()==0 )
		 BarAndPieChartType = "highchart";
	 //..hide the sharing option in favorite window
	 boolean hideSharing=false;
	 String hideSharingStr=(String)iniFile.getValue("favorite","hideSharing");
	 if(hideSharingStr != null && !hideSharingStr.equals("") && hideSharingStr.equalsIgnoreCase("yes"))
	 {
		hideSharing=true;
	 }//..

	 String ajaxTimeout=iniFile.getValue("MISC","AjaxTimeout");
	 String isNeedReportMenuDeleteIcon=iniFile.getValue("MISC","ReportMenuDeleteIcon");
	 if(ajaxTimeout==null || ajaxTimeout.length()==0)
	 {
		ajaxTimeout="600000";
	 }
	 try{
		 Long.parseLong(ajaxTimeout);
	 }catch(Exception e){
		 ajaxTimeout="600000";
	 }


      out.write("<script language=\"JavaScript1.2\">\n\n/** To Disable Right Click */\n\tvar message=\"\";\n\tfunction clickIE()\n\t{\n\t\tif(document.all)\n\t\t{\n\t\t\t(message);return false;\n\t\t}\n\t}\n\t\n\tfunction clickNS(e)\n\t{\n\t\tif(document.layers||(document.getElementById&&!document.all))\n\t\t{\n\t\t\tif(e.which==2||e.which==3)\n\t\t\t{\n\t\t\t\t(message);return false;\n\t\t\t}\n\t\t}\n\t\n\t}\n\t\n\tif('");
      out.print(RightClikMode);
      out.write("'=='production')\n\t{\n\t\tif (document.layers)\n\t\t{\n\t\t\tdocument.captureEvents(Event.MOUSEDOWN);document.onmousedown=clickNS;\n\t\t}\n\t\telse\n\t\t{\n\t\t\tdocument.onmouseup=clickNS;document.oncontextmenu=clickIE;\n\t\t}\n\t\tdocument.oncontextmenu=new Function(\"return false\")\n\t}\n    \n\t\n\t\t\t\tvar alltables = document.getElementsByTagName(\"body\");\n\t\t\t\tif ('");
      out.print(SelectionMode);
      out.write("' == 'production') {\n\t\t\t\t\twindow.onload = function() {\n\t\t\t\t\t\tfunction disableSelection(element) {\n\t\t\t\t\t\t\telement.onselectstart = function() {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\telement.unselectable = \"on\";\n\t\t\t\t\t\t\telement.style.MozUserSelect = \"none\";\n\t\t\t\t\t\t\telement.style.cursor = \"default\";\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (var i = 0; i < alltables.length; i++) {\n\n\t\t\t\t\t\t\tdisableSelection(alltables[i]); //disable text selection within all tables on the page\n\t\t\t\t\t\t}\n\n\t\t\t\t\t}\n\t\t\t\t}\n\t\n\n\nfunction callWindow(opt)\n{\n\t\t\t\tvar topWindow = window;\n\t\t\t//\tconsole.log(topWindow);\n\t\t\t//\tconsole.log(topWindow.location.pathname);\n\t\t\t//\tconsole.log(topWindow.parent);\n\t\t\t\twhile(topWindow.parent!=topWindow ||  topWindow.opener!=null)\n\t\t\t\t{\n\t\t\t\t\tmainWindow = topWindow;\n\t\t\t\t\ttopWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);\n\t\t\t\t}\n\t\t\t//\tconsole.log(topWindow.location.pathname);\n\t\t\t\tif(topWindow.location.pathname!=\"/\")\n\t\t\t\t\tmainWindow=topWindow;\n\t\t\t\tvar requestFrom = '");
      out.print(request.getParameter("reqFrom"));
      out.write("';\n\t\t\t\tif (requestFrom != null && requestFrom == 'clsTrial')\n\t\t\t\t{\n\t\t\t\t\tmainWindow.location.href=\"/final/servlet/com.egurkha.Logout?reqFrom=clsTrial&errmsg=\"+opt;\n\t\t\t\t}\n\t\t\t\telse\n\t\t\t\t{\n\t\t\t\t\tmainWindow.location.href=\"/final/servlet/com.egurkha.Logout?errmsg=\"+opt;\n\t\t\t\t}\n\t\t\t\tmainWindow.focus();\n}\n</script>\n");

		com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		String trackerLanguage = trackerUI.getDefaultLanguage();
		ErUserData UBean = null;
		String reporter_Skin = null;

		boolean id_u = false;
		String urs = null;
		long u_v_till = 0L;
		long l_accessed = 0L;
		UserRegistry registry= null;
		User thisuser=null;
		String throughSchedule = request.getParameter("throughSchedule");
		if(throughSchedule == null) {
			throughSchedule = "";
		}
		String usr_Id_proc = request.getParameter("er_userid");
		String usr_Id = request.getParameter("eruserid");
		String userID = request.getParameter("userID");
		if(session!=null)
		{
			 UBean = (ErUserData) session.getAttribute("UBean");
			 if(throughSchedule.equalsIgnoreCase("true")) {
				 try
				 {
				if(UBean == null) {
					if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null")){
						UBean = new ErUserData(usr_Id,false);
						usr_Id_proc = usr_Id;
					}
					else if(userID != null){
						UBean = new ErUserData(userID,false);
						usr_Id_proc = userID;
					}
					else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null")){
						UBean = new ErUserData(usr_Id_proc,false);
					}
					else{
						UBean = new ErUserData(usr_Id_proc,false);
					}

				}
				}
				catch(Throwable t)
				{
				t.printStackTrace();
				}
			}
			if(UBean != null)
			{
			    registry = UserRegistry.getInstance();
				thisuser= registry.getUser(session.getId(),true);
				if(thisuser!=null)
				{
					id_u = thisuser.isIdDeletedWhileLoggedIn();
					if(id_u==false )
					{
						urs = thisuser.getLoginID();
						if(!User.isDefaultUser(urs))
						{
							u_v_till = UBean.getUserValidtill();
							l_accessed = session.getLastAccessedTime();
						}
					}
				}
				if(thisuser == null && usr_Id_proc!= null ) {
					try {
						thisuser = UBean.getUser(usr_Id_proc);
						registry.setUser(session.getId(), thisuser, false);
						System.out.println("Setting user object. user reporter skin : " + thisuser.getReporterSkin());
					} catch(Exception ex) {
						System.out.println("Setting user object failed");
						ex.printStackTrace();
					}
				}
			}
		}
		if((session==null || UBean == null || thisuser==null) && !throughSchedule.equalsIgnoreCase("true"))
		{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(1);\n\t\t</script>\n");

		return;
		}
		else if(id_u== true && !throughSchedule.equalsIgnoreCase("true"))
		{

      out.write("<script language=\"JavaScript\">\n\t\t\t\tcallWindow(2);\n\t\t\t</script>\n");

			return;
		}
		else if (u_v_till < l_accessed && !throughSchedule.equalsIgnoreCase("true"))
		{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(3);\n\t\t\t</script>\n");

			return;
		}
		else
		{
			//session.putValue("Page_IdentifierR",request.getRequestURI());	
			String pageName = request.getRequestURI();
			if(!pageName.endsWith("ErMeasureData.jsp") && !pageName.endsWith("ErMeasure.jsp") && !pageName.endsWith("ErPrintReport.jsp") && !pageName.endsWith("ErPrintDataReport.jsp") && !pageName.endsWith("ErComparisonData.jsp") && !pageName.endsWith("ErMacroData.jsp") && !pageName.endsWith("ErCtxUserGraph.jsp") && !pageName.endsWith("ErMacroPrint.jsp") && !pageName.endsWith("ErHomePrint.jsp"))
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
		}
		if (thisuser!=null)
		{
			String trackerUserLang = thisuser.getLanguage();
			thisuser.setUserLanguageAndSkins();
			reporter_Skin  = thisuser.getReporterSkin();
			
			if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
			{
				trackerLanguage=trackerUserLang;
			}
		}
		String  script_src="script_item_"+trackerLanguage+".js";

		//Added by Sakthivel - 26/03/2008
		String uiFileTemp = "eg_ui.ini";
		String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
		//Variable to be used in javascript code
		String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String mgrDateFormat = currentDateFormatForJS;
		String strUserDateFormat =currentDateFormatForJS;
		if(thisuser!=null)
		{
			strUserDateFormat = thisuser.getUserDateFormat();
		}
		if(strUserDateFormat!=null && strUserDateFormat.length()>0)
			mgrDateFormat = strUserDateFormat;
		if(currentDateFormatForJS.indexOf("MMM") >= 0)
		{
			for(int i=0; i < currentDateFormatForJS.length();i++)
			{
				if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
				{
					currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
				}
			}
		}
 		egurkha.reporter.ErBackgroundReportGenerator erbgreport = new egurkha.reporter.ErBackgroundReportGenerator();
		String strArray[] =erbgreport.getSelection(urs);
		String strforeground = strArray[0];
		String strbackground =  strArray[1];
		String bgString="'";
		EgMappingInfo trackerMappingInfo = new EgMappingInfo(trackerLanguage);
		EgDateInfo _tdateInfo = new EgDateInfo();

		/* changes for different time zones -->time line charts(highcharts)
		by karthikeyan*/
		Calendar calr = Calendar.getInstance();
		java.util.Date local_datee = new java.util.Date(_tdateInfo.egetUTCDate());
		calr.setTime(local_datee);
		calr.setTimeZone(_tdateInfo.getRealTimeZone());
		String tempp = (calr.get(calr.MONTH)+1) + "/" + calr.get(calr.DAY_OF_MONTH) + "/" +calr.get(calr.YEAR);
		String mgr_timee = calr.get(calr.HOUR_OF_DAY)+":"+calr.get(calr.MINUTE)+":"+calr.get(calr.SECOND);
		String trac_currentDateFormatt = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String dispDatee = DateUtil.changeDateFormat(tempp,"MM/dd/yyyy",trac_currentDateFormatt);
		EgTimeZoneConverter tracker_timeZoneConverterr = new EgTimeZoneConverter(dispDatee+" "+mgr_timee,thisuser);
		TimeZone tz = tracker_timeZoneConverterr.getTimeZone();
		String timezoneOffsetValue ="";
		Calendar cal3 = GregorianCalendar.getInstance(tz);
		int offsetInMillis = tz.getOffset(cal3.getTimeInMillis());
		int offsetmin = 0;
		if(offsetInMillis<0)
			offsetmin =(Math.abs(offsetInMillis)/1000)/60;
		else
			offsetmin = (offsetInMillis/1000)/60;
		String offset = String.valueOf(offsetmin);

			if(tz.getRawOffset()>=0)
				timezoneOffsetValue="-"+offset;
			else
				timezoneOffsetValue="+"+offset;
				
		//
		

		String  strer_modeInTracker=(String)request.getParameter("er_mode");
		if(strer_modeInTracker==null || strer_modeInTracker.equals("") || strer_modeInTracker.equalsIgnoreCase("null") )
		{
			if(egui.use3DGraphs(IniUI.REPORTER))
				strer_modeInTracker="3D";
			else
				strer_modeInTracker = "2D";
		}
		String strSkin="light";
		if(thisuser!=null)
		{
			strSkin=thisuser.getReporterSkin();
			egui.set_userLogo(thisuser.getUserLogo());
			egui.set_loginID(thisuser.getLoginID());
			imageName = egui.getReporterHomeLogo();
		}
		if(egui.isHKTThemeEnabled())
		{
			imageName = egui.getHKTReporterLogo();
		}
		int currYearPrint = 0;
		Calendar calFooter = Calendar.getInstance();
		currYearPrint = calFooter.get(calFooter.YEAR);
		String strPrintFooterText = "Powered by eG Enterprise </br>"+currYearPrint+" eG Innovations inc. All Rights Reserved.";


      out.write("<script>\n\tvar moduleEntry='reporter';\n\tvar strSkin='");
      out.print(strSkin);
      out.write("'\n\tvar setyaxismin='");
      out.print(Yaxis);
      out.write("'\n\tvar er_modeInTracker='");
      out.print(strer_modeInTracker);
      out.write("'\n\tvar timezoneOffsetValue='");
      out.print(timezoneOffsetValue);
      out.write("'\n\tvar requestPageURL='");
      out.print(request.getRequestURI());
      out.write("';\n\tvar maxTimelineINI='");
      out.print(maxTimelineINI);
      out.write("';\n\tvar maxTimelineDiff_ms='");
      out.print(maxTimelineDiff_ms);
      out.write("';\n\tvar submitValue='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Run Report"));
      out.write("';\n\tvar dateFormatForTimeline = '");
      out.print(strUserDateFormat);
      out.write("';\n\tvar ajaxTimeout = parseInt('");
      out.print(ajaxTimeout);
      out.write("'); // added for ajax request timeout\n\tvar settings='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.More Options"));
      out.write("';\n\tvar toolData='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Data"));
      out.write("';\n\tvar toolCSV='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.CSV"));
      out.write("';\n\tvar toolSave ='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.Save as PDF"));
      out.write("';\n\tvar toolMail='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.Mail"));
      out.write("';\n\tvar toolPrint='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.Print"));
      out.write("';\n\tvar timelineLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Timeline"));
      out.write("';\n\tvar hrLbl='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.Hour"));
      out.write("';\n\tvar minsLbl='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.Mins"));
      out.write("';\n\tvar Tolbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.To"));
      out.write("';\n\tvar fromLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.history.From"));
      out.write("';\n\tvar graphLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.summary.Graph"));
      out.write("';\n\tvar reportLastAccessedURL='");
      out.print(reportLastAccessedURL);
      out.write("';\n\tvar isSettingsEnabled = false;\n\tvar isNeedtoTrigerUpbutton = true;\n\tvar delayTime = 500;\n\tvar gridPageSize = 30;\t//30 records per page in grid\n\tvar isOnlyVMAssigned='");
      out.print(thisuser.isOnlyVMAssigned());
      out.write("';\n \tdocument.onkeydown = fkey;\n\tvar highChartPieWidth=300;\n\tvar highChartPieHeight=250;\n\tvar noMatch ='<center>--- No match found ---</center>';\n\tvar noComponentMatch ='<center>--- No Component (s) found ---</center>';\n\tvar noComponentTypeMatch ='<center>--- No Component Type (s) found ---</center>';\n\tvar noTestMatch ='<center>--- No Test (s) found ---</center>';\n\tvar noMeasureMatch='<center>--- No Measure (s) found ---</center>';\n\tvar noCriteriaMatch='<center>--- No Criteria (s) found ---</center>';\n\tvar noInfoMatch ='<center>--- No Info (s) found ---</center>';\n\tvar noApplicationMatch ='<center>--- No Application (s) found ---</center>';\n\tvar noUserMatch ='<center>--- No User (s) found ---</center>';\n\tvar noSegmentMatch ='<center>--- No Segment (s) found ---</center>';\n\tvar noServiceMatch ='<center>--- No Service (s) found ---</center>';\n\tvar noZoneMatch ='<center>--- No Zone (s) found ---</center>';\n\tvar noMetricsMatch ='<center>--- No Metrics (s) found ---</center>';\n\tvar noLayerMatch ='<center>--- No Layer (s) found ---</center>';\n");
      out.write("\tvar noDescriptorsMatch ='<center>--- No Descriptor (s) found ---</center>';\n\tvar noServerMatch ='<center>--- No Server (s) found ---</center>';\n\tvar noVirtualMachinesMatch ='<center>--- No Virtual Machines (s) found ---</center>';\n\tvar hideSharing=");
      out.print(hideSharing);
      out.write(";\n\n\t\n\tfunction fkey(e){\n\t\te = e || window.event;\t\t  \n\t\tif (e.which == 116 || e.keyCode == 82 && e.ctrlKey) { //116 = F5\n\t\t\twindow.parent.refreshEgIndexPage();\n\t\t\treturn false;\n\t\t}\n\t}\n\tfunction registerAjaxEvents()\n\t{\t\n  \t\tExt.Ajax.on('beforerequest', function(conn, response, opts) { \n\t\t\tExt.get(document.body).mask('Loading...');\t\n\t\t});\n\t\tExt.Ajax.on('requestcomplete', function(conn, response, opts) { \n\t\t\tExt.get(document.body).unmask();\t\n\t\t});\n\t\tExt.Ajax.on('requestexception', function(conn, response, opts) { \n\t\t\tExt.get(document.body).unmask(); \n\t\t\tconsole.log('server-side failure with status code ' + response.status);\n\t\t\tif (response.timedout) \n  \t\t\t\tdoCheckLogOut(); \n \t\t\t/*else if (response.status==413 || response.status==414)  \n\t\t\t\tconsole.log('Request URI is Too Long ' + response.status); */\n\t\t\telse if(response.status==503 || response.status==500)\n\t\t\t\tdoCheckLogOut();\n\t\t});\n\t}\n\tfunction registerAjaxExceptionEvent()\n\t{\n\t\tExt.Ajax.on('requestexception', function(conn, response, opts) { \n\t\t\tExt.get(document.body).unmask(); \n");
      out.write("\t\t\tconsole.log('server-side failure with status code ' + response.status);\n\t\t\tif (response.timedout) \n  \t\t\t\tdoCheckLogOut();\n\t\t\telse if(response.status==503 || response.status==500)\n\t\t\t\tdoCheckLogOut();\n\t\t});\n\t}\n\tfunction doCheckLogOut(){\n\t\t");

			if((session==null || UBean == null || thisuser==null) && !throughSchedule.equalsIgnoreCase("true"))
			{
		
      out.write("\t\n\t\t\t\tcallWindow(1);\n\t\t");
		
			}
			else if(id_u== true && !throughSchedule.equalsIgnoreCase("true"))
			{
		
      out.write("\t\n\t\t\t\tcallWindow(2);\n\t\t");

			}
			else if (u_v_till < l_accessed && !throughSchedule.equalsIgnoreCase("true"))
			{
		
      out.write("\t\n\t\t\t\tcallWindow(1);\n\t\t");

			}
			else 
			{
		
      out.write("\t\n  \t\t\t\tcallWindow(1);\n \t\t");

			}
		
      out.write("\t\n\t}\n\tfunction checkSpecialCharacters(data)\n\t{\n\t\tvar flag=false;\n\t\t  var iChars = \"!@#$%^*()+=-[]\\';,./{}|:\\\"<>?~\";\n\t\t   for (var i = 0; i < data.length; i++) {\n\t\t\tif (iChars.indexOf(data.charAt(i)) != -1 && !flag) {\n\t\t\t\tflag=true;\n\t\t\t}\n\t\t  }\n\t\t return flag;\n\t}\n\tfunction multiSelectAllvalidation(combo,allValue)\n\t{\n\t\tvar flag=true;\n\t\t//For descriptor all and individual desc selection validation\n\t\tvar hasAll=false;\n\t\tif(combo!=null && combo!='undefined' && combo.length>0){\n\t\t\tfor(var k=0;combo.length>k;k++)\n\t\t\t{\n\t\t\t\tif(combo[k]==allValue)\n\t\t\t\t\thasAll=true;\n\t\t\t\t\n\t\t\t}\n\t\t\t\n\t\t}\n\t\tif(hasAll && combo.length>1)\n\t\t{\t\t\t\n\t\t\tflag=false;\n\t\t}\n\t\treturn flag;\n\t}\n</script>");

	String er_RmDispName = request.getParameter("er_RmDispName");
	try {

		EgTimeZoneConverter timeZoneConverterStart = null;
		EgTimeZoneConverter timeZoneConverterEnd = null;
		String startDateForDisplay = null;
		String startHourForDisplay = null;
		String endDateForDisplay = null;
		String endHourForDisplay = null;
		String startMinForDisplay = null;
		String endMinForDisplay = null;
		
		User userName=UserRegistry.getInstance().getUser(session.getId());

		Map resultMap = (HashMap) session.getAttribute(INFRASTRUCTURE_HEALTH_REPORT);
		EgReportInfo reportInfo = new EgReportInfo(MANAGER);
		IniUI ui = IniUI.getInstance();
		String thisLanguage = ui.getDefaultLanguage();
		ErUtils erUtils = new ErUtils();
		ErReportHelper erh = new ErReportHelper();
		if(urs==null)
			urs = (String) request.getParameter("er_userid");
		UBean = new ErUserData(urs, false);
		ErUserData erdata = new ErUserData(UBean.getUserId(), false);
		EgTopoInfo topoInfo = new EgTopoInfo(MANAGER);
		User this_user = UserRegistry.getInstance().getUser(session.getId());
		EgGroupInfo gpinfo = new EgGroupInfo();
		EgTestInfo tokInfo = new EgTestInfo(MANAGER);
		EgDateInfo egDt = new EgDateInfo();
		EgTablesInfo tablesInfo = new EgTablesInfo(MANAGER);
		String userid = UBean.getUserId();
		String language = thisuser.getLanguage();
		EgMappingInfo intlmap = new EgMappingInfo(language);
		ErComponentsUtils compUtil = new ErComponentsUtils(language);
		EgDiscInfo diskInfo = new EgDiscInfo(MANAGER);
		EgDbInfo dbInfo = new EgDbInfo(MANAGER);
		ErEsxVMutils erEsxUtils = new ErEsxVMutils();
		EgDisableInfo disableinfo = new EgDisableInfo("manager");
		com.eg.EgSpecsInfo specsInfo = new com.eg.EgSpecsInfo("manager");
		egurkha.TestBean testBean = new egurkha.TestBean();
		ErUtils utils = new ErUtils();
		ErComponentsUtils compUtils=new ErComponentsUtils(thisuser.getLoginID());

		String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES", "ManagerUrl");
		String er_option = request.getParameter("er_option");
		String sel_component[] = request.getParameterValues("er_component");
		String s_comptype[] = request.getParameterValues("er_comptype");
		String er_site = request.getParameter("er_site");
		String reqFromSchedule = request.getParameter("fromSchedule");
		String bggroundStr = (String) request.getAttribute("bggroundStr");
		String status = (String) request.getAttribute("status");
		String isSubmit = request.getParameter("isSubmit");
		String er_timeline = request.getParameter("er_timeline");
		String s_st_time = request.getParameter("startdate");
		String s_en_time = request.getParameter("enddate");
		String s_st_hr = request.getParameter("starthr");
		String s_en_hr = request.getParameter("endhr");
		String strmin = request.getParameter("startmin");
		String enmin = request.getParameter("endmin");
		String timefrom = request.getParameter("timefrom");
		String minfrom = request.getParameter("minfrom");
		String timeto = request.getParameter("timeto");
		String minto = request.getParameter("minto");
		String s_inidate = request.getParameter("inidate");
		String er_excwe = request.getParameter("er_excwe");
		String er_includeZones = request.getParameter("er_includeZone");
		if(er_includeZones==null)
			er_includeZones = (String) request.getParameter("er_includezones");
		boolean includeZone = false;
		if (er_includeZones != null && er_includeZones.equalsIgnoreCase("yes"))
			includeZone = true;
		String divStatus = request.getParameter("divStatus");
		String schedule_id = request.getParameter("schedule_id");
		String er_criteria = request.getParameter("er_criteria");
		String pdfPrint = request.getParameter("pdfprint");
		String sample = request.getParameter("sample");
		String er_healthSummary = request.getParameter("er_healthSummary");
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
		String currentDateFormat =strUserDateFormat;

		com.eg.IniFile dbaseUI = new com.eg.IniFile(s_iniFile_dir + "eg_dbase.ini");
		String confirmation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
		String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS", "EnableBackgroundReport");
		String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
		String dispCsvStartDate = s_st_time + " " + s_st_hr + COLON+ strmin;
		String dispCsvEndDate = s_en_time + " " + s_en_hr + COLON+ enmin;
		String criticalColor = reportInfo.getValue(INFRASTRUCTURE_HEALTH_REPORT, "CriticalColor");
		String normalColor = reportInfo.getValue(INFRASTRUCTURE_HEALTH_REPORT, "NormalColor");
		String majorColor = reportInfo.getValue(INFRASTRUCTURE_HEALTH_REPORT, "MajorColor");

		List listCompTypes = reportInfo.getComponent(INFRASTRUCTURE_HEALTH_REPORT, false);
		Vector v_component = new Vector();
		Vector temp_component = new Vector();
		Vector v_comptype = new Vector();
		Vector v_componentName = new Vector();
		Vector v_options = new Vector();
		Vector v_segment = new Vector();
		Vector v_service = new Vector();
		Vector v_zones = new Vector();
		Vector v_comp_popup = new Vector();
		Vector v_comp_popup_disp = new Vector();
		List selected_compTypes = new ArrayList();
		List compList = new ArrayList();
		List utilizationList = new ArrayList();
		Vector v_time = new Vector();
		if (s_comptype != null&& !request.getParameter("er_comptype").equals("-1"))
			selected_compTypes = Arrays.asList(s_comptype);
		if (sel_component != null)
			compList = Arrays.asList(sel_component);
		String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort();
		boolean noDataFound = false;
		boolean noDataForVM = true;
		boolean isBackgroundProcess = false;
		boolean criteriaOnleFalg = false;
		if (resultMap != null && isSubmit != null&& isSubmit.equalsIgnoreCase("true")) {
			Boolean noData = ((Boolean) resultMap.get(NODATAFOUND));
			if (noData != null)
				noDataFound = noData.booleanValue();
			noData = ((Boolean) resultMap.get(VMNODATA));
			if (noData != null)
				noDataForVM = noData.booleanValue();
			noData = ((Boolean) resultMap.get(CRITERIAONLY));
			if (noData != null)
				criteriaOnleFalg = noData.booleanValue();
		}
		String fontStyleDblSingl = "";
		if ((dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US"))&& !(pdfPrint != null
					&& pdfPrint.equalsIgnoreCase("yes") || (sample != null && !sample.equalsIgnoreCase("yes")))) {
			fontStyleDblSingl = "multi_font";
		} else {
			fontStyleDblSingl = "";
		}
		int unhealthyBound2 = 90;
		int unhealthyBound1 = 100;
		String tempHealthValue = reportInfo.getValue(INFRASTRUCTURE_HEALTH_REPORT,"UnhealthyBound2");
		try {
			unhealthyBound2 = Integer.parseInt(tempHealthValue);
		} catch (Exception e) {
			unhealthyBound2 = 90;
		}
		tempHealthValue = reportInfo.getValue(INFRASTRUCTURE_HEALTH_REPORT,"UnhealthyBound1");
		try {
			unhealthyBound1 = Integer.parseInt(tempHealthValue);
		} catch (Exception e) {
			unhealthyBound1 = 80;
		}
	
      out.write("<html>\n<head>\n");

	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{

      out.write("<title>&nbsp; ");
      if (_jspx_meth_egui_005fintnl_005f0(_jspx_page_context))
        return;
      out.write("\n\t\t&nbsp; &nbsp; ");
      if (_jspx_meth_egui_005fintnl_005f1(_jspx_page_context))
        return;
      out.write(" &nbsp;</title>\n");

	}
	else
	{

      out.write("<title>&nbsp; ");
      if (_jspx_meth_egui_005fintnl_005f2(_jspx_page_context))
        return;
      out.write("\n\t\t&nbsp; &nbsp;</title>\n");

	}

      out.write("<meta name=\"Author\" content=\"\">\n<meta  charset=\"UTF-8\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/final/reporter/styles/printpagestyle.css\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/final/styles/eGLightThemeIcons.css\" />\n<style>\n\n@media print {body {-webkit-print-color-adjust: exact;}}\n\nbody{font-family:'LucidaGrandeRegular';font-size:11px;line-height:1.5em;color:#2a292a;}\nheader{font-family:'LucidaGrandeRegular';font-size:15px;}\n\n.formLabel {font-family:'LucidaGrandeRegular';font-size:12px;line-height:14px;}\n.formValue {font-family:'LucidaGrandeBold';font-size:12px;line-height:14px;}\n\nb{font-family:'LucidaGrandeBold';font-size:11px;}\n\n.printTable{border: 1px solid #c3c3c3; border-collapse: collapse;}\n.printTable tr .tdClass{border: 1px solid #c3c3c3;}\n\n.printTableHeader{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:left;background-color:#cdcdcd;padding:4px;}\n.printTableHeader2{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#dcdcdc;padding:4px;}\n");
      out.write("\n.problmduarion_body{border-radius:5px;margin:5px;border-radius:5px;margin:0 5px 5px 5px;border:1px solid #c3c3c3;padding:10px;background:#f5f5f5;font-family:\"LucidaGrandeRegular\";font-size:11px;color:#1e1e1e}\n.recomm_footerline{line-height:100%}\n\n</style>\n\n<style type=\"text/css\" media=\"print\">\n#printbt{ display:none}\n</style>\n\n<style>\n@page {size : landscape; margin : 0in }\n@page :footer {content: none, \"Macro Home\" decimal(pageno), none;}\n\n/*\n.tableBorderHtml{border:1px solid #d9d9d9;border-collapse:collapse;}\n.theadBorderHtml{border:1px solid #959595;background:#828282;color:#fff;font:bold 13px \"Lucida Grande\",\"Lucida Sans Unicode\",\"Lucida Sans\",\"DejaVu Sans\",\"Bitstream Vera Sans\",\"Liberation Sans\",Verdana,\"Verdana Ref\",sans-serif!important}\n.tableTrBgEven{background-color:#f4f4f4}\n.tableTrBgEven th{padding:4px}\n.tableTrBgEven td{font-size:13px}\n\n.tableTrBgOdd{background-color:#fff}\n.tableTrBgOdd td,.tableTrBgOdd td span{font-size:13px}\n.tdBorderHtml{border:1px solid #d9d9d9;height:23px}\n.tdborder{padding:4px;border:1px solid #d9d9d9;}\n");
      out.write(".problemwindow_hd{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",\"Lucida Sans\",\"DejaVu Sans\",\"Bitstream Vera Sans\",\"Liberation Sans\",Verdana,\"Verdana Ref\",sans-serif;font-size:14px;color:#1e1e1e;font-weight:bold;padding:10px 10px 5px 10px;background:#fff}\n.border_bottomtable{margin-left:12px;width:990px;border-bottom:1px solid #c3c3c3;margin-bottom:8px;margin-top:2px}\n\n.fontsize13{font:bold 13px \"Lucida Grande\",\"Lucida Sans Unicode\",\"Lucida Sans\",\"DejaVu Sans\",\"Bitstream Vera Sans\",\"Liberation Sans\",Verdana,\"Verdana Ref\",sans-serif!important}\n.fontsize12{font:bold 13px \"Lucida Grande\",\"Lucida Sans Unicode\",\"Lucida Sans\",\"DejaVu Sans\",\"Bitstream Vera Sans\",\"Liberation Sans\",Verdana,\"Verdana Ref\",sans-serif!important}\n#newimg{page-break-inside:avoid}.newimg{page-break-inside:avoid}\n*/\n</style>\n</head>\n<body  style=\"padding:10px;background-color:#ffffff\">\n\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"table-layout:fixed;\">\n\t<tr>\n\t\t<td width=\"100%\" align=\"center\" height=\"100%\" valign=\"top\">\n");

			if (pdfPrint == null || !pdfPrint.equalsIgnoreCase("yes"))
	{

      out.write("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\" align=\"center\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td style=\"padding:5px 10px 10px 10px\"><img src='");
      out.print(imageName);
      out.write("' border=\"0\" /></td>\n\t\t\t\t</tr>\n\t\t\t</table>\n");

	}

      out.write("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\"  style=\"border-bottom:1px solid #999;\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td style=\"padding:2px\">\n");

	if (!StringUtils.isNull(er_RmDispName))
	{

      out.write("<div style=\"float:left;font-size:20px;\" ><header>");
      out.print( er_RmDispName );
      out.write("</header></div>\n");

	}
	else
	{

      out.write("<div style=\"float:left\" > <header>");
      if (_jspx_meth_egui_005fintnl_005f3(_jspx_page_context))
        return;
      out.write("</header></div>\n");

	}
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{

      out.write("<div style=\"float:right\"><img class=\"iconPrinter mouse\" src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" border=\"0\" onClick=\"javascript:window.print()\" alt='");
      if (_jspx_meth_egui_005fintnl_005f4(_jspx_page_context))
        return;
      out.write("' title='");
      if (_jspx_meth_egui_005fintnl_005f5(_jspx_page_context))
        return;
      out.write("'/></div>\n");

	}

      out.write("</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\n\t\t\t<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-bottom:1px solid #ccc;\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td align=\"left\" width=\"50%\">\n\t\t\t\t\t\t<div style=\"float:left;padding:4px;\">\n\t\t\t\t\t\t\t<div style=\"float:left\" class=\"formLabel\">");
      if (_jspx_meth_egui_005fintnl_005f6(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t<div style=\"float:left;width:10px\" align=\"center\" >:</div>\n\t\t\t\t\t\t\t<div style=\"float:left;\" class=\"formValue\">");
      out.print( er_option );
      out.write("</div>\n\t\t\t\t\t\t</div>\n");

	if (!er_option.equalsIgnoreCase("Component"))
	{

      out.write("<div style=\"float:left;clear:both;padding:4px;\">\n\t\t\t\t\t\t\t<div style=\"float:left\" class=\"formLabel\">");
      out.print(er_option);
      out.write("</div>\n\t\t\t\t\t\t\t<div style=\"float:left;width:10px\" align=\"center\" >:</div>\n\t\t\t\t\t\t\t<div style=\"float:left;\" class=\"formValue\">");
      out.print(er_site);
      out.write("</div>\n\t\t\t\t\t\t</div>\n");

		if(er_option.equalsIgnoreCase("Zone"))
		{

      out.write("<div style=\"float:left;padding:4px;\">\n\t\t\t\t\t\t\t<div style=\"float:left\" class=\"formLabel\">");
      if (_jspx_meth_egui_005fintnl_005f7(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t<div style=\"float:left;width:10px\" align=\"center\" >:</div>\n\t\t\t\t\t\t\t<div style=\"float:left;\" class=\"formValue\">");
      out.print(er_includeZones);
      out.write("</div>\n\t\t\t\t\t\t</div>\n");

		}
	}
	String healthSummayDisp = "Serverwise Summary";
	if (er_healthSummary.equalsIgnoreCase("At Tier Level"))
		healthSummayDisp = "TierWise Summary";

      out.write("<div style=\"float:left;clear:both;padding:4px;\">\n\t\t\t\t\t\t\t<div style=\"float:left\" class=\"formLabel\">");
      if (_jspx_meth_egui_005fintnl_005f8(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t<div style=\"float:left;width:10px\" align=\"center\" >:</div>\n\t\t\t\t\t\t\t<div style=\"float:left;\" class=\"formValue\"> ");
      out.print( healthSummayDisp );
      out.write("</div>\n\t\t\t\t\t\t</div>\n\n\t\t\t\t\t\t<div style=\"float:left;clear:both;padding:4px;\">\n\t\t\t\t\t\t\t<div style=\"float:left\" class=\"formLabel\">");
      if (_jspx_meth_egui_005fintnl_005f9(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t<div style=\"float:left;width:10px\" align=\"center\" >:</div>\n\t\t\t\t\t\t\t<div style=\"float:left;\" class=\"formValue\">");
      out.print( er_excwe );
      out.write("</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</td>\n");

	String dispStart = "";
	String dispEnd = "";
	//dispStart = s_st_time + " " + s_st_hr + COLON + strmin + " hrs";
	//dispEnd = s_en_time + " " + s_en_hr + COLON + enmin + " hrs";

	dispStart = s_st_time + " " + s_st_hr + COLON + strmin ;
	dispEnd = s_en_time + " " + s_en_hr + COLON + enmin ;
	//Time zone Conversion
		
		timeZoneConverterStart = new EgTimeZoneConverter(dispStart ,userName);
		startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
		startHourForDisplay = timeZoneConverterStart.getHour();
		startMinForDisplay = timeZoneConverterStart.getMinute();

		timeZoneConverterEnd = new EgTimeZoneConverter(dispEnd ,userName);
		endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
		endHourForDisplay = timeZoneConverterEnd.getHour();
		endMinForDisplay = timeZoneConverterEnd.getMinute();

		String pdfStartDate=startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
		String pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;

		Vector dvec = new Vector();
		String stimefmt =	pdfStartDate+ " hrs";
		String etimefmt =	pdfEndDate+ " hrs";

      out.write("<td align=\"right\" >\n\t\t\t\t\t\t<div style=\"float:right;padding:4px;\">\n\t\t\t\t\t\t\t<div style=\"float:left\" class=\"formLabel\">");
      if (_jspx_meth_egui_005fintnl_005f10(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t<div style=\"float:left;width:10px\" align=\"center\" >:</div>\n\t\t\t\t\t\t\t<div style=\"float:left;\" class=\"formValue\">");
      out.print(stimefmt);
      out.write("</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div style=\"clear:both;float:right;padding:4px;\">\n\t\t\t\t\t\t\t<div style=\"float:left\" class=\"formLabel\">");
      if (_jspx_meth_egui_005fintnl_005f11(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t<div style=\"float:left;width:10px\" align=\"center\">:</div>\n\t\t\t\t\t\t\t<div style=\"float:left;\" class=\"formValue\">");
      out.print(etimefmt);
      out.write("</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div style=\"clear:both;float:right;padding:4px;\">\n\t\t\t\t\t\t\t<div style=\"float:left\" class=\"formLabel\">");
      if (_jspx_meth_egui_005fintnl_005f12(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t<div style=\"float:left;width:10px\" align=\"center\">:</div>\n\t\t\t\t\t\t\t<div style=\"float:left;\" class=\"formValue\">");
      out.print( timefrom );
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(minfrom );
      out.write("&nbsp;&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f13(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print( timeto );
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(minto );
      out.write("</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table><br/>\n\n<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\">\n");

				String defaultGroup = reportInfo.getValue("HEALTHREPORT_MEASUREGROUP_MAPPING", "Default");
				String avoidDefaultGroup = reportInfo.getValue("INFRASTRUCTURE_HEALTH_REPORT", "HealthReportAvoidDefault");
				
				List avoidDefaultGroupingList = new ArrayList();
				if(avoidDefaultGroup != null && avoidDefaultGroup.length()>0)
				{
					StringTokenizer st_dault = new StringTokenizer(avoidDefaultGroup, ",");
					while (st_dault.hasMoreTokens()) {
						avoidDefaultGroupingList.add(st_dault.nextToken());
					}
				}
				List aListDefaultGroupingList = new ArrayList();
				if(defaultGroup != null && defaultGroup.length()>0)
				{
					StringTokenizer st_dault = new StringTokenizer(defaultGroup, ",");
					while (st_dault.hasMoreTokens()) {
						aListDefaultGroupingList.add(st_dault.nextToken());
					}
				}
				List groupList = (ArrayList) getAllServerGroups();
				List selectionList = new ArrayList();
				if (er_healthSummary != null && (er_healthSummary.equalsIgnoreCase("At Tier Level") ||											er_healthSummary.equalsIgnoreCase("Component_type")))
				{
					ArrayList tierList = reportInfo.getVariables("HEALTHREPORT_TIERS");
					Map tierComponentMap = new HashMap();
					Map keyValueMap = new HashMap();
					ArrayList aListTierCompType = new ArrayList();
					String avoidDefaultFlag=null;
					int maxSize = 0;
					for(int i=0; i<tierList.size();i++){
						String key = (String) tierList.get(i);
						String value = reportInfo.getValue("HEALTHREPORT_TIERS",key);
						List compTypeList = new ArrayList();
						StringTokenizer st = new StringTokenizer(value,",");
						while(st.hasMoreTokens()){
						String comp = st.nextToken();
							//
							if(avoidDefaultGroupingList.contains(comp))
							{
								avoidDefaultFlag="true";
							}
							else
							{
								avoidDefaultFlag="false";
							}
							//
							if(!selected_compTypes.contains(comp))
							{
								continue;
							} else
							{
								if(!aListTierCompType.contains(comp))
									aListTierCompType.add(comp);
								compTypeList.add(comp);
								String groupingValue = reportInfo.getValue("HEALTHREPORT_MEASUREGROUP_MAPPING",comp);
								List valueList = new ArrayList();
								//
								if(aListDefaultGroupingList!=null && aListDefaultGroupingList.size()>0 && avoidDefaultFlag.equals("false"))
									valueList.addAll(aListDefaultGroupingList);
								//
								StringTokenizer stk = null;
								if(groupingValue == null || groupingValue.length() ==0)
								{
									ArrayList aListLayer = tablesInfo.getLayersForComponent(comp);
									if(aListLayer!=null && aListLayer.size()>0)
									{
										for (int ii=0;ii<aListLayer.size();ii++ )
										{
											String strLayer = (String)aListLayer.get(ii);
											if(!(strLayer.equalsIgnoreCase("HOST")  || strLayer.equalsIgnoreCase("NETWORK") || strLayer.equalsIgnoreCase("TCP") || strLayer.equalsIgnoreCase("APP_PROCESSES") || strLayer.equalsIgnoreCase("HARDWARE")))
											{
												valueList.add(strLayer);
											}
										}
									}
								}else{
									stk = new StringTokenizer(groupingValue,",");
									while(stk.hasMoreTokens()){
										valueList.add(stk.nextToken());
									}
								}
								//if(aListDefaultGroupingList!=null && aListDefaultGroupingList.size()>0)
									//valueList.addAll(aListDefaultGroupingList);
								if(maxSize < valueList.size())
									maxSize = valueList.size();
								keyValueMap.put(comp,valueList);
							}
						}
						tierComponentMap.put(key,compTypeList);
					}
					for(int s=0;s<selected_compTypes.size();s++)
					{
						String strComp = (String)selected_compTypes.get(s);
						if(!aListTierCompType.contains(strComp))
						{
							String groupingValue = reportInfo.getValue("HEALTHREPORT_MEASUREGROUP_MAPPING","Default");
							String comptypeGroupingValue = reportInfo.getValue("HEALTHREPORT_MEASUREGROUP_MAPPING",strComp);
							if(avoidDefaultGroupingList.contains(strComp))
							{
								avoidDefaultFlag="true";
							}
							else
							{
								avoidDefaultFlag="false";
							}
							if(comptypeGroupingValue!=null && comptypeGroupingValue.length()>0)
							{
								comptypeGroupingValue=groupingValue+","+comptypeGroupingValue;
							}
							else{

								if(avoidDefaultFlag.equals("false"))
								{
									comptypeGroupingValue=groupingValue;
								}
								ArrayList aListLayer = tablesInfo.getLayersForComponent(strComp);
								if(aListLayer!=null && aListLayer.size()>0)
								{
									for (int ii=0;ii<aListLayer.size();ii++ )
									{
										String strLayer = (String)aListLayer.get(ii);
										if(!(strLayer.equalsIgnoreCase("HOST")  || strLayer.equalsIgnoreCase("NETWORK") || strLayer.equalsIgnoreCase("TCP") || strLayer.equalsIgnoreCase("APP_PROCESSES") || strLayer.equalsIgnoreCase("HARDWARE")))
										{
											if(comptypeGroupingValue==null ||comptypeGroupingValue.length()==0)
												comptypeGroupingValue=strLayer;
											else
												comptypeGroupingValue+=","+strLayer;
										}
									}
								}
							}
							List valueList = new ArrayList();
							StringTokenizer stk = new StringTokenizer(comptypeGroupingValue,",");
							boolean validCriteria = false;
							while(stk.hasMoreTokens()){
								String testStr = stk.nextToken();
								String groupStr = reportInfo.getValue("HEALTHREPORT_MEASURE_MAPPING",testStr);
								if (groupStr.indexOf("#$#") > -1)
								{
									groupStr = groupStr.substring(groupStr.indexOf("#$#")+3);
								}
								if(groupStr == null || groupStr.length()==0)
								{
									ArrayList aListLayerTest = tablesInfo.getTestsForLayer (testStr,strComp);
									for (int m=0; m<aListLayerTest.size();m++ )
									{
										if(groupStr == null || groupStr.length() ==0)
											groupStr = (String) aListLayerTest.get(m);
										else
											groupStr +=","+(String) aListLayerTest.get(m);
									}
								} 
								StringTokenizer groupTokenizer = new StringTokenizer(groupStr,",");
								while(groupTokenizer.hasMoreTokens())
								{
									String test = groupTokenizer.nextToken();
									if (test.indexOf(":") > -1)
										test = test.substring(0,test.indexOf(":"));
									if(specsInfo.isTestRelevantForServer(strComp,test))
										validCriteria = true;
								}
								if (validCriteria)
									valueList.add(testStr);
							}
							//
							if(valueList!=null && valueList.size()>0)
							{
								if(maxSize < valueList.size())
									maxSize = valueList.size();
								keyValueMap.put(strComp,valueList);
								String layerlevel=intlmap.getTextDescription(com.eg.eGComponentCategory.getInstance().getCategoryforCompType(strComp));
								if(layerlevel.indexOf("#")>-1)
									layerlevel=layerlevel.substring(0,layerlevel.indexOf("#"));
								ArrayList defaultCompTypeList = (ArrayList)tierComponentMap.get(layerlevel);
								if(defaultCompTypeList!=null)
									defaultCompTypeList.add(strComp);
								else
								{
									defaultCompTypeList = new ArrayList();
									defaultCompTypeList.add(strComp);
									tierComponentMap.put(layerlevel,defaultCompTypeList);
								}
							}
							//
							/*if(valueList!=null && valueList.size()>0)
							{
								if(maxSize < valueList.size())
									maxSize = valueList.size();
								keyValueMap.put(strComp,valueList);
								String strGname = "";
								for (int g=0; g<groupList.size(); g++)
								{
									String groupName = (String) groupList.get(g);
									List componentTypeList = (ArrayList) getCategorizedComponents(groupName);
									if (componentTypeList.contains(strComp)){
										strGname = getCapitalizedCategory(groupName);
										break;
									}
								}
								ArrayList defaultCompTypeList = (ArrayList)tierComponentMap.get(strGname);
								if(defaultCompTypeList!=null)
									defaultCompTypeList.add(strComp);
								else
								{
									defaultCompTypeList = new ArrayList();
									defaultCompTypeList.add(strComp);
								tierComponentMap.put(strGname,defaultCompTypeList);
								}
							}*/
						}
					}
			
      out.write("<tr>\n\t\t<td colspan=\"\" align=\"left\" style=\"padding-left:4px;width:70%;border-right-width:0px;border-left-width:0px\" class=\"printTableHeader\">");
      if (_jspx_meth_egui_005fintnl_005f14(_jspx_page_context))
        return;
      out.write("</td>\n\t\t<td align=\"right\" class=\"printTableHeader\"> \n\t\t\t<table align=\"right\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td><div style=\"background-color: ");
      out.print( normalColor );
      out.write(";margin-top:3px;width:25px;height:10px;\"></div>&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f15(_jspx_page_context))
        return;
      out.write("&nbsp;&nbsp;</td>\n\t\t\t\t\t<td><div style=\"background-color: ");
      out.print( majorColor );
      out.write(";margin-top:3px;width:25px;height:10px;\"></div>&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f16(_jspx_page_context))
        return;
      out.write("&nbsp;&nbsp;</td>\n\t\t\t\t\t<td><div style=\"background-color: ");
      out.print( criticalColor );
      out.write(";margin-top:3px;width:25px;height:10px;\"></div>&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f17(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td colspan=\"2\">\n\t\t\t<table width=\"100%\" cellpadding=\"0\" cellspacing=\"2\" border=\"0\" class=\"printTable\" >\n\t\t\t\t<tr>\n");

				if(er_healthSummary.equalsIgnoreCase("At Tier Level") )
				{

      out.write("<td class=\"printTableHeader2\">");
      if (_jspx_meth_egui_005fintnl_005f18(_jspx_page_context))
        return;
      out.write("</td>\n");

				}

      out.write("<td class=\"printTableHeader2\">");
      if (_jspx_meth_egui_005fintnl_005f19(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t\t<td align=\"left\" class=\"printTableHeader2\">");
      if (_jspx_meth_egui_005fintnl_005f20(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t</tr> \n\t\t\t");

				Object keys[] = tierComponentMap.keySet().toArray();
				boolean showTier = false;
				boolean isNextLine = false;
				boolean showComponentType = false;
				boolean closeTable = false;
				for(int i=0; i<keys.length; i++)
				{
					String key = (String)keys[i];
					List compTypeList = (ArrayList) tierComponentMap.get(key);
					if (compTypeList.size() > 0){
						showTier = true;
					boolean componentFlag = compTypeList.size() == 1 ? true : false;
					int comptypesize = getComponentTypeCount(compTypeList,keyValueMap);
					for(int j=0; j<compTypeList.size(); j++){
						showComponentType = true;
						String componentType = (String) compTypeList.get(j);
							if (j != 0)
								isNextLine = true;
					
      out.write("<!-- <tr>\n\t\t\t\t\t\t\t\t\t\t<td height=\"100%\">\n\t\t\t\t\t\t\t\t\t\t\t<table cellpadding=\"0\" cellspacing=\"4\" width=\"100%\" height=\"100%\" border=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t<tr> -->\n\t\t\t\t\t\t\t\t\t\t\t\t\t<!-- <td class=\"tdborder\" align=\"center\" > ");
      out.print( key );
      out.write("</td> -->\n\t\t\t\t\t\t\t\t\t\t\t\t<!-- </tr>\n\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t<td height=\"100%\">\n\t\t\t\t\t\t\t\t\t\t\t<table cellpadding=\"0\" cellspacing=\"4\" width=\"100%\" height=\"100%\" border=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t<tr> -->\n\t\t\t\t\t\t\t\t\t\t\t\t\t<!-- <td class=\"tdborder\" align=\"center\" >");
      out.print(intlmap.getComponentTypeDescription(componentType));
      out.write("</td> -->\n\t\t\t\t\t\t\t\t\t\t\t\t<!-- </tr>\n\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t</td> -->\n\t\t\t\t\t\t\t\t\t\t<!-- <td>\n\t\t\t\t\t\t\t\t\t\t\t<table cellpadding=\"0\" cellspacing=\"4\" width=\"100%\" border=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t<tr> -->\n\t\t\t\t\t");

						List keysList = (ArrayList) keyValueMap.get(componentType);
						int columnCount = 0;
						int colspan=1;
						int size = keysList.size();
						//int colspan=1;
						boolean isColspanFlag = false;
						if(maxSize >= (size*4)){
							isColspanFlag = true;
							colspan = 4;
						} else if(maxSize >= (size*3)){
							isColspanFlag = true;
							colspan = 3;
						} else if(maxSize >= (size*2)){
							isColspanFlag = true;
							colspan = 2;
						}
						//int columnCount = 0;
						for(int k=0; k<keysList.size(); k++){
							String color = normalColor;
							String tempKey = (String) keysList.get(k);
							String displayName = tempKey;
							String tempKeys = tempKey;
							if (tempKey.indexOf("#$#") > -1)
								tempKeys = tempKey.substring(0,tempKey.indexOf("#$#"));
							String tempDisp = reportInfo.getValue("HEALTHREPORT_MEASURE_MAPPING",tempKeys);
							if(tempDisp == null || tempDisp.length()==0)
							{
								ArrayList aListLayerTest = tablesInfo.getTestsForLayer (tempKeys,componentType);
								for (int m=0; m<aListLayerTest.size();m++ )
								{
									if(tempDisp == null || tempDisp.length() ==0)
										tempDisp = (String) aListLayerTest.get(m);
									else
										tempDisp +=","+(String) aListLayerTest.get(m);
								}
								displayName = intlmap.getLayerDescription(tempKeys);
							}
							StringTokenizer ts = new StringTokenizer(tempDisp,",");
							boolean isShowKeyElement = false;
							while(ts.hasMoreTokens())
							{
								String tempTest = ts.nextToken();
								if(tempTest.indexOf("#$#") != -1)
									tempTest =tempTest.substring(tempTest.indexOf("#$#")+3);
								if (tempTest.indexOf(":") > -1)
								{
									tempTest = tempTest.substring(0,tempTest.indexOf(":"));
								}
								if (!StringUtils.isNull(dbaseUI.getValue("DYN_TABLES",tempTest.trim())) && specsInfo.isTestRelevantForServer(componentType,tempTest))
									isShowKeyElement = true;
							}
							if (tempKey.indexOf("#$#") != -1){
								displayName = tempKey.substring(tempKey.indexOf("#$#")+3);
								tempKey = tempKey.substring(0,tempKey.indexOf("#$#"));
							} else {
								if(tempDisp.indexOf("#$#") != -1)
									displayName =tempDisp.substring(0,tempDisp.indexOf("#$#"));
							}
							String health = "100";
							List componentList = erEsxUtils.getEsxElements(thisuser,componentType,er_option,true,"");
							if(!er_option.equalsIgnoreCase("Component"))
							{
								if(er_option!=null && er_site!=null && !er_site.equalsIgnoreCase("-1") )
								{
									ArrayList arr_relativeCompTypes = new ArrayList();
									arr_relativeCompTypes.add(componentType);
									componentList=erEsxUtils.getChosenGroupComponents(arr_relativeCompTypes,er_site,er_option,thisuser.getLoginID(),er_includeZones,new String[0]);
								}
							}
							if(er_option.equalsIgnoreCase("Service") || er_option.equalsIgnoreCase("Segment") || (er_option.equalsIgnoreCase("Zone") && er_site.equalsIgnoreCase("--Default--" )))
							{
								ArrayList arr_tmp=new ArrayList(componentList);
								componentList=new ArrayList();
								componentList.addAll(compUtils.getTypeModifyComponents(new Vector(arr_tmp),2));	
							}
							int healthCount = 0;
							double healthValue = 0;
							for(int l=0; l<componentList.size(); l++)
							{
								String tempComp = (String) componentList.get(l);
								tempComp = tempComp.substring(tempComp.indexOf(":")+1);
								String resultKey = componentType +"|" + tempComp +"|" + tempKey;
								if(resultMap.containsKey(resultKey)){
									healthCount++;
									Double dHealth = (Double) resultMap.get(resultKey);
									healthValue += dHealth.doubleValue();
								} else {
									healthValue += 100;
									healthCount ++;
								}
							}
							if (healthCount > 0)
								healthValue = healthValue/healthCount;
							else 
								healthValue = 100;
							health = erUtils.round(healthValue,2);
							healthValue = Double.parseDouble(health);
							if(healthValue <= unhealthyBound2)
								color = criticalColor;
							else if(healthValue < unhealthyBound1)
								color = majorColor;
							if (!color.equalsIgnoreCase(normalColor))
								selectionList.add(tempKey+"||"+displayName+"$"+componentType);
							if(k == keysList.size()-1)
								colspan = maxSize - columnCount;
							if (isShowKeyElement)
							{
								if (showTier){

      out.write("<tr>\n");

				if(er_healthSummary.equalsIgnoreCase("At Tier Level") )
				{
	//
					String layerlevel=intlmap.getTextDescription(com.eg.eGComponentCategory.getInstance().getCategoryforCompType(componentType));
					if(layerlevel.indexOf("#")>-1)
						layerlevel=layerlevel.substring(0,layerlevel.indexOf("#"));
		//
	
      out.write("<td class=\"tdClass\" align=\"center\" rowspan=\"");
      out.print(comptypesize);
      out.write("\">\n\t\t\t\t\t\t\t<!-- <table border=\"0\" cellpadding=\"4\" cellspacing=\"4\" width=\"100%\" height=\"100%\" >\n\t\t\t\t\t\t\t\t<tr width=\"100%\">\n\t\t\t\t\t\t\t\t\t<td class=\"tdborder\" align=\"center\" rowspan=\"");
      out.print(compTypeList.size() );
      out.write("\" > -->\n\t\t\t\t\t\t\t\t\t\t ");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f21 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f21.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f21.setParent(null);
      // /reporter/ErInfrastructureHealthReportPrint.jsp(979,11) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f21.setText(layerlevel);
      int _jspx_eval_egui_005fintnl_005f21 = _jspx_th_egui_005fintnl_005f21.doStartTag();
      if (_jspx_th_egui_005fintnl_005f21.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f21);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f21);
      out.write("<!-- </td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table> -->\n\t\t\t\t\t\t</td>\n");

								}
									showTier = false;
								} else {
									if (isNextLine)
									{
										isNextLine = false;
									
      out.write("<tr>\n\t\t\t\t\t\t\t\t\t");

									}
								}
								if (showComponentType){
									showComponentType = false;
										isNextLine = false;
									closeTable = true;
									
      out.write("<!-- <td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\" cellpadding=\"4\" cellspacing=\"4\" width=\"100%\" height=\"100%\" >\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr width=\"100%\"> -->\n\t\t\t\t\t<td class=\"tdClass mouse\" align=\"center\" onclick = \"javascript:ComponentTypeOnClick('");
      out.print( componentType );
      out.write("');\">");
      out.print(intlmap.getComponentTypeDescription(componentType));
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<!-- </tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</td> -->\n\t\t\t\t\t<td class=\"tdClass\" style=\"padding:0px\">\n\t\t\t\t\t\t<table border=\"0\" cellpadding=\"5\" cellspacing=\"2\" width=\"100%\" height=\"100%\" >\n\t\t\t\t\t\t\t<tr width=\"100%\">\n\t\t\t\t\t\t\t\t");

								}
					
      out.write("<td align=\"center\" class=\" \" style=\"background-color: ");
      out.print( color );
      out.write(";\" >\n\t\t\t\t\t\t\t\t\t<div style=\"background-color: ");
      out.print( color );
      out.write(";float:left;padding:0px;left:0px;top:0px;border:0px solid red;height:100%;width:100%;\" align=\"center\" >\n\t\t\t\t\t\t\t\t\t\t<table width=\"100%\" align=\"center\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\">");
      out.print( displayName );
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\">");
      out.print( health );
      out.write("%</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t");

							}
								columnCount += colspan;
							}
							if (closeTable){
							closeTable = false;
					
					
      out.write("</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t\t\t");

							}
						}
					
      out.write("<!-- </tr>\n\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr> -->\n\t\t\t\t\t");

					}
				}
				
      out.write("</table>\n\t\t</td>\n\t</tr>\n\t\t\t\t");

				} else {
							ArrayList tierList = reportInfo.getVariables("HEALTHREPORT_TIERS");
							Vector v_userComponent = UBean.getAllUserComponents(3);
							Map tierComponentMap = new HashMap();
							Map keyValueMap = new HashMap();
							ArrayList aListTierCompType = new ArrayList();
							String avoidDefaultFlag=null;
							int maxSize = 0;
							for(int i=0; i<tierList.size();i++){
								String key = (String) tierList.get(i);
								String value = reportInfo.getValue("HEALTHREPORT_TIERS",key);
								List compTypeList = new ArrayList();
								StringTokenizer st = new StringTokenizer(value,",");
								while(st.hasMoreTokens()){
									String comp = st.nextToken();
									if(avoidDefaultGroupingList.contains(comp))
									{
										avoidDefaultFlag="true";
									}
									else
									{
										avoidDefaultFlag="false";
									}
									if(!selected_compTypes.contains(comp)){
										continue;
									} else {
										compTypeList.add(comp);
										if(!aListTierCompType.contains(comp))
											aListTierCompType.add(comp);
										String groupingValue = reportInfo.getValue("HEALTHREPORT_MEASUREGROUP_MAPPING",comp);
										List valueList = new ArrayList();
										if(aListDefaultGroupingList!=null && aListDefaultGroupingList.size()>0 && avoidDefaultFlag.equals("false"))
											valueList.addAll(aListDefaultGroupingList);
										StringTokenizer stk = null;
										if(groupingValue == null || groupingValue.length() ==0)
										{
											ArrayList aListLayer = tablesInfo.getLayersForComponent(comp);
											if(aListLayer!=null && aListLayer.size()>0)
											{
												for (int ii=0;ii<aListLayer.size();ii++ )
												{
													String strLayer = (String)aListLayer.get(ii);
													if(!(strLayer.equalsIgnoreCase("HOST")  || strLayer.equalsIgnoreCase("NETWORK") || strLayer.equalsIgnoreCase("TCP") || strLayer.equalsIgnoreCase("APP_PROCESSES") || strLayer.equalsIgnoreCase("HARDWARE")))
													{
														valueList.add(strLayer);
													}
												}
											}
										}else{
											stk = new StringTokenizer(groupingValue,",");
											while(stk.hasMoreTokens()){
												valueList.add(stk.nextToken());
											}
										}
										//if(aListDefaultGroupingList!=null && aListDefaultGroupingList.size()>0)
											//valueList.addAll(aListDefaultGroupingList);
										if(maxSize < valueList.size())
											maxSize = valueList.size();
										keyValueMap.put(comp,valueList);
									}
								}
								tierComponentMap.put(key,compTypeList);
							}
							//List defaultCompTypeList = new ArrayList();
							Map rowspanMap = new HashMap();
							for(int s=0;s<selected_compTypes.size();s++)
							{
								String strComp = (String)selected_compTypes.get(s);
								if(!aListTierCompType.contains(strComp))
								{
									String[] strTempcomponent = diskInfo.getAllServersOfType(strComp);
									String[] component = getUserComponent(strTempcomponent,v_userComponent);
									if(component == null || component.length ==0)
										continue;
									List valueList = new ArrayList();
									int rowspanCount = 0;
									for(int t=0; t<component.length; t++)
									{
										String componentName = component[t];
										boolean validComponent = false;
										String groupingValue = reportInfo.getValue("HEALTHREPORT_MEASUREGROUP_MAPPING","Default");
										String comptypeGroupingValue = reportInfo.getValue("HEALTHREPORT_MEASUREGROUP_MAPPING",strComp);
										if(avoidDefaultGroupingList.contains(strComp))
										{
											avoidDefaultFlag="true";
										}
										else
										{
											avoidDefaultFlag="false";
										}
										if(comptypeGroupingValue!=null && comptypeGroupingValue.length()>0 && avoidDefaultFlag.equals("false"))
										{
											comptypeGroupingValue=groupingValue+","+comptypeGroupingValue;
										}
										else{

												if(avoidDefaultFlag.equals("false"))
												{
													comptypeGroupingValue=groupingValue;
												}
												ArrayList aListLayer = tablesInfo.getLayersForComponent(strComp);
												if(aListLayer!=null && aListLayer.size()>0)
												{
													for (int ii=0;ii<aListLayer.size();ii++ )
													{
														String strLayer = (String)aListLayer.get(ii);
														if(!(strLayer.equalsIgnoreCase("HOST")  || strLayer.equalsIgnoreCase("NETWORK") || strLayer.equalsIgnoreCase("TCP") || strLayer.equalsIgnoreCase("APP_PROCESSES") || strLayer.equalsIgnoreCase("HARDWARE")))
														{
															if(comptypeGroupingValue==null ||comptypeGroupingValue.length()==0)
																comptypeGroupingValue=strLayer;
															else
																comptypeGroupingValue+=","+strLayer;
														}
													}
												}
											}
										//List valueList = new ArrayList();
										StringTokenizer stk = new StringTokenizer(comptypeGroupingValue,",");
										while(stk.hasMoreTokens()){
											boolean validCriteria = false;
											String testStr = stk.nextToken();
											String groupStr = reportInfo.getValue("HEALTHREPORT_MEASURE_MAPPING",testStr);
											if(groupStr == null || groupStr.length()==0)
											{
												ArrayList aListLayerTest = tablesInfo.getTestsForLayer (testStr,strComp);
												for (int m=0; m<aListLayerTest.size();m++ )
												{
													if(groupStr == null || groupStr.length() ==0)
														groupStr = (String) aListLayerTest.get(m);
													else
														groupStr +=","+(String) aListLayerTest.get(m);
												}
											}
											if (groupStr.indexOf("#$#") > -1)
											{
												groupStr = groupStr.substring(groupStr.indexOf("#$#")+3);
											}
											StringTokenizer groupTokenizer = new StringTokenizer(groupStr,",");
											while(groupTokenizer.hasMoreTokens())
											{
												String test = groupTokenizer.nextToken();
												if (test.indexOf(":") > -1)
													test = test.substring(0,test.indexOf(":"));
												if(specsInfo.isTestRelevantForServer(strComp,test) && !disableinfo.isTestDisabled(strComp,componentName,test)){
													validCriteria = true;
													validComponent = true;
												}
											}
											if (validCriteria && !valueList.contains(testStr))
												valueList.add(testStr);
										}
										if (validComponent)
											rowspanCount++;
									}
																//
							if(valueList!=null && valueList.size()>0)
							{
								if(maxSize < valueList.size())
									maxSize = valueList.size();
								keyValueMap.put(strComp,valueList);
								ArrayList defaultCompTypeList = (ArrayList)tierComponentMap.get("Default");
								if(defaultCompTypeList!=null)
									defaultCompTypeList.add(strComp);
								else
								{
									defaultCompTypeList = new ArrayList();
									defaultCompTypeList.add(strComp);
									tierComponentMap.put("Default",defaultCompTypeList);
								}
							}
							//
									/*if(valueList!=null && valueList.size()>0)
									{
										if(maxSize < valueList.size())
											maxSize = valueList.size();
										keyValueMap.put(strComp,valueList);
										String strGname = "";
										for (int g=0; g<groupList.size(); g++)
										{
											String groupName = (String) groupList.get(g);
											List componentTypeList = (ArrayList) getCategorizedComponents(groupName);
											if (componentTypeList.contains(strComp)){
												strGname = getCapitalizedCategory(groupName);
												break;
											}
										}
										ArrayList defaultCompTypeList = (ArrayList)tierComponentMap.get(strGname);
										if(defaultCompTypeList!=null)
											defaultCompTypeList.add(strComp);
										else
										{
											defaultCompTypeList = new ArrayList();
											defaultCompTypeList.add(strComp);
											tierComponentMap.put(strGname,defaultCompTypeList);
										}
									}*/
									rowspanMap.put(strComp,String.valueOf(rowspanCount));
								}
							}
							//if(defaultCompTypeList!=null && defaultCompTypeList.size()>0)
								//tierComponentMap.put("Default",defaultCompTypeList);
							
      out.write("<tr>\n\t\t<th align=\"left\"  align=\"left\" style=\"padding-left:4px;width:70%;border-right-width:0px;border-left-width:0px\" class=\"printTableHeader\">");
      if (_jspx_meth_egui_005fintnl_005f22(_jspx_page_context))
        return;
      out.write("</th>\n\t\t<td  class=\"printTableHeader\" align=\"right\"> \n\t\t\t<table align=\"right\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td><div style=\"background-color: ");
      out.print( normalColor );
      out.write(";width:25px;height:10px;\"></div>&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f23(_jspx_page_context))
        return;
      out.write("&nbsp;&nbsp;</td>\n\t\t\t\t\t<td><div style=\"background-color: ");
      out.print( majorColor );
      out.write(";width:25px;height:10px;\"></div>&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f24(_jspx_page_context))
        return;
      out.write("&nbsp;&nbsp;</td>\n\t\t\t\t\t<td><div style=\"background-color: ");
      out.print( criticalColor );
      out.write(";width:25px;height:10px;\"></div>&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f25(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td colspan=\"2\" >\n\t\t\t<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" class=\"printTable\">\n\t\t\t\t<tr>\n\t\t\t\t\t<!--  <td class=\"printTableHeader2\">");
      if (_jspx_meth_egui_005fintnl_005f26(_jspx_page_context))
        return;
      out.write("</td>-->\n\t\t\t\t\t<td class=\"printTableHeader2\">");
      if (_jspx_meth_egui_005fintnl_005f27(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t\t<td class=\"printTableHeader2\">");
      if (_jspx_meth_egui_005fintnl_005f28(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t\t<td align=\"left\" class=\"printTableHeader2\">");
      if (_jspx_meth_egui_005fintnl_005f29(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t</tr> \n\t\t\t\t\t\t\t");

							Object keys[] = tierComponentMap.keySet().toArray();
							int divCount = 1;
							boolean nextLine = false;
							boolean clostTable = false;
							for(int i=0; i<keys.length; i++)
							{
								String key = (String)keys[i];
								List compTypeList = (ArrayList) tierComponentMap.get(key);
								boolean componentFlag = compTypeList.size() == 1 ? true : false;
								for(int j=0; j<compTypeList.size(); j++){
									boolean showComponentType = true;
									String componentType = (String) compTypeList.get(j);
									String[] strTempcomponent = diskInfo.getAllServersOfType(componentType);
									String[] component = getUserComponent(strTempcomponent,v_userComponent);
									if(component == null || component.length ==0)
										continue;
					

									boolean showComponents = false;
									for(int k=0; k<component.length; k++){
										String componentStr = component[k];
										componentStr = componentStr.substring(componentStr.indexOf(":")+1);
										if(k != 0){
											nextLine = true;
					
      out.write("<!-- <tr> -->\n\t\t\t\t\t");

										}
										if(k==0)
										{
					
      out.write("<tr> \n\t\t\t\t\t");



										}
										showComponents = true;
					
      out.write("<!-- <td height=\"100%\" class=\"tdborder\" align=\"center\">\n\t\t\t\t\t\t\t\t\t\t\t<!-- <table cellpadding=\"4\" cellspacing=\"4\" width=\"100%\" height=\"100%\" border=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td > ");
      out.print(componentStr.substring(0,componentStr.indexOf(":")) );
      out.write("<!-- </td>\n\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t\t<table width=\"100%\" cellpadding=\"0\" cellspacing=\"4\" border=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t<tr> -->\n\t\t\t\t\t");

										List keysList = (ArrayList) keyValueMap.get(componentType);
										int size = keysList.size();
										int colspan=1;
										boolean isColspanFlag = false;
										if(maxSize >= (size*4)){
											isColspanFlag = true;
											colspan = 4;
										} else if(maxSize >= (size*3)){
											isColspanFlag = true;
											colspan = 3;
										} else if(maxSize >= (size*2)){
											isColspanFlag = true;
											colspan = 2;
										}
										int columnCount = 0;
										for(int l=0; l<keysList.size(); l++){
											String color = normalColor;
											String tempKey = (String) keysList.get(l);
											String displayName = tempKey;
											String tempKeys = tempKey;
											if (tempKey.indexOf("#$#") > -1)
												tempKeys = tempKey.substring(0,tempKey.indexOf("#$#"));
											String tempDisp = reportInfo.getValue("HEALTHREPORT_MEASURE_MAPPING",tempKeys);
											if(tempDisp == null || tempDisp.length()==0)
											{
												ArrayList aListLayerTest = tablesInfo.getTestsForLayer (tempKeys,componentType);
												for (int m=0; m<aListLayerTest.size();m++ )
												{
													if(tempDisp == null || tempDisp.length() ==0)
														tempDisp = (String) aListLayerTest.get(m);
													else
														tempDisp +=","+(String) aListLayerTest.get(m);
												}
												displayName = intlmap.getLayerDescription(tempKeys);
											} 
											StringTokenizer ts = new StringTokenizer(tempDisp,",");
											boolean isShowKeyElement = false;
											while(ts.hasMoreTokens())
											{
												String tempTest = ts.nextToken();
												if(tempTest.indexOf("#$#") != -1)
													tempTest =tempTest.substring(tempTest.indexOf("#$#")+3);
												if (tempTest.indexOf(":") > -1)
												{
													tempTest = tempTest.substring(0,tempTest.indexOf(":"));
												}
												if (!StringUtils.isNull(dbaseUI.getValue("DYN_TABLES",tempTest))&& specsInfo.isTestRelevantForServer(componentType,tempTest) && !disableinfo.isTestDisabled(componentType,componentStr,tempTest))
													isShowKeyElement = true;
											}
											if (tempKey.indexOf("#$#") != -1){
												displayName = tempKey.substring(tempKey.indexOf("#$#")+3);
												tempKey = tempKey.substring(0,tempKey.indexOf("#$#"));
											} else {
												if(tempDisp.indexOf("#$#") != -1)
													displayName =tempDisp.substring(0,tempDisp.indexOf("#$#"));
											}
											String health = "100";
											String resultKey = componentStr +"|" + tempKey;
											if(resultMap.containsKey(resultKey)){
												Double dHealth = (Double) resultMap.get(resultKey);
												double healthValue = dHealth.doubleValue();
												health = erUtils.round(healthValue,2);
												healthValue = Double.parseDouble(health);
												if(healthValue <= unhealthyBound2)
													color = criticalColor;
												else if(healthValue < unhealthyBound1)
													color = majorColor;
											}
											int colSpan = 1;
											if(l == keysList.size()-1)
												colspan = maxSize - columnCount;
											if (isShowKeyElement) {
												if(!color.equals(normalColor))
													selectionList.add(tempKey+"||"+displayName+"$"+componentType+"$"+componentStr);
												if (nextLine){
													nextLine = false;
													
      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t");

												}
												if (showComponentType){
													showComponentType = false;
													String rowspan = (String)rowspanMap.get(componentType);
													if (rowspan == null)
														rowspan = String.valueOf(component.length);

      out.write("<!--<td rowspan=\"");
      out.print(rowspan );
      out.write("\" class=\"tdClass\"  align=\"center\">");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f30 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f30.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f30.setParent(null);
      // /reporter/ErInfrastructureHealthReportPrint.jsp(1415,69) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f30.setText( key );
      int _jspx_eval_egui_005fintnl_005f30 = _jspx_th_egui_005fintnl_005f30.doStartTag();
      if (_jspx_th_egui_005fintnl_005f30.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f30);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f30);
      out.write("</td>-->\n\t\t\t\t\t<td  rowspan=\"");
      out.print( rowspan );
      out.write("\" class=\"tdClass\"  align=\"center\">");
      out.print(intlmap.getComponentTypeDescription(componentType));
      out.write("</td>\n\t\t\t\t\t\t\t\t");

												}
												if (showComponents){
													showComponents = false;
													clostTable = true;
									
      out.write("<td class=\"tdClass\" align=\"center\">");
      out.print(componentStr.substring(0,componentStr.indexOf(":")) );
      out.write("</td>\n\t\t\t\t\t<td width=\"100%\" height=\"100%\" class=\"tdClass\">\n\t\t\t\t\t\t<table border=\"0\" cellpadding=\"5\" cellspacing=\"1\" width=\"100%\" height=\"100%\" >\n\t\t\t\t\t\t\t<tr width=\"100%\">\n\t\t\t\t\t\t\t\t\t");

												}
												
      out.write("<td class=\" \"  style=\"background-color: ");
      out.print( color );
      out.write(";\">\n\t\t\t\t\t\t\t\t\t<div style=\"background-color: ");
      out.print( color );
      out.write(";float:left;padding:0px;border:0px solid red;height:100%;width:100%;\">\n\t\t\t\t\t\t\t\t\t\t<table width=\"100%\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\">");
      out.print( displayName );
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\">");
      out.print( health );
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t");

											}
										columnCount += colspan;
										}
										if (clostTable) {
										clostTable = false;
								
      out.write("</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t");

										}
									}
								}
							}
								
      out.write("</table>\n\t\t</td>\n\t</tr>\n\t\t\t\t\t");

					}
						
      out.write("<!-- </table>\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr> -->\n\t\t\t\t\t");

						//}
					if(selectionList!=null && selectionList.size()>0)
		{
					
      out.write("</table><br/>&nbsp;\n<table class=\"printTable\" width=\"100%\" cellspacing =\"0\" cellpadding=\"0\" align=\"center\" >\n\t<tr>\n\t\t<td class=\"printTableHeader\" height=\"26\" align=\"left\">&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f31(_jspx_page_context))
        return;
      out.write("</td>\n\t</tr>\n\t<tr>\n\t\t<td style=\"padding:10px\">\n\t\t\t<table width=\"100%\" cellspacing =\"0\" cellpadding=\"0\" >\n\t\t\t\t\t");

						for(int s=0; s<selectionList.size(); s++)
						{
							String tempStr = (String) selectionList.get(s);
							String er_component = "";
							String componentType = "";
							String criteria = "";
							StringTokenizer st = new StringTokenizer(tempStr,"$");
							String dispalyString = "";
							while(st.hasMoreTokens())
							{
								criteria = st.nextToken();
								componentType = st.nextToken();
								dispalyString += intlmap.getComponentTypeDescription(componentType);
								if (st.hasMoreTokens())
								{
									er_component = st.nextToken();
									String dispStr = er_component;
									if(dispStr.endsWith(":NULL"))
									{
										dispStr=dispStr.substring(0,dispStr.lastIndexOf(":"));
									}
									dispalyString += " - " + dispStr;
								}
								dispalyString += " - " + criteria.substring(criteria.indexOf("||")+2);
								criteria = criteria.substring(0,criteria.indexOf("||"));
							}
			
      out.write("<tr>\n\t\t\t\t\t<td >&nbsp;</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td colspan=\"2\">\n\t\t\t\t\t\t<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\" class=\"printTable\">\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td class=\"printTableHeader2\" align=\"left\">");
      if (_jspx_meth_egui_005fintnl_005f32(_jspx_page_context))
        return;
      out.write("&nbsp;<i>&nbsp;-&nbsp;");
      out.print( dispalyString );
      out.write("</i> </td> \n\t\t\t\t\t\t\t</tr>\n\t\t\t");

				String testMeasurestr = reportInfo.getValue(
			HEALTHREPORT_MEASURE_MAPPING, criteria);
			if(testMeasurestr == null || testMeasurestr.length()==0)
			{
				ArrayList aListLayerTest = tablesInfo.getTestsForLayer (criteria,componentType);
				for (int m=0; m<aListLayerTest.size();m++ )
				{
					if(testMeasurestr == null || testMeasurestr.length() ==0)
						testMeasurestr = (String) aListLayerTest.get(m);
					else
						testMeasurestr +=","+(String) aListLayerTest.get(m);
				}
			}
			 st = new StringTokenizer(testMeasurestr, ",");
						while (st.hasMoreTokens()) {
							tempStr = st.nextToken();
							String test = tempStr;//.substring(0, tempStr.indexOf(COLON));
							if(test.indexOf(COLON) > -1)
								test = test.substring(0, test.indexOf(COLON));
							String measure = null;
							if(tempStr.indexOf(COLON) > -1)
								measure = tempStr.substring(tempStr.indexOf(COLON)+1);
							if(measure != null && measure.indexOf("*") == -1)
							{
								if(measure.indexOf("#$#") != -1){
									measure = measure.substring(0,measure.indexOf("#$#"));
								}
							} else {
								measure = null;
							}
							if(test.indexOf("#$#") != -1){
								test = test.substring(test.indexOf("#$#")+3);
							}
							String key = componentType + PIE + criteria + PIE + test ;

							if(er_healthSummary != null && er_healthSummary.equalsIgnoreCase("At Server Level"))
								key = er_component + PIE + criteria + PIE + test ;

							String[] tempMeasure;
							if(measure != null){
								tempMeasure = new String[]{measure};
							} else {
								tempMeasure = dbInfo.getMeasurementsForTest(test);
							}
								String originalKey  =key;
								for(int l=0; l<tempMeasure.length; l++)
								{
									measure = tempMeasure[l];
									key = originalKey + PIE + measure;
									Long measureAlertDuration = (Long)resultMap.get(key);
									long alertDuration = 0;
									if (measureAlertDuration != null)
										alertDuration = measureAlertDuration.longValue();
									String measureCountKey = key + "|Count";
									int measureCount = 0;
									String infosKey = key + "|INFO"; 
									String infoKey = key + "|INFOTIMES";
									List infoList = (ArrayList) resultMap.get(infoKey);
									if(infoList!=null)
									measureCount = infoList.size();
									// added for DD data start here
									boolean isTestExternal = specsInfo.isTestExternal(test.trim());
									boolean isDdEnableTestMeas = testBean.isDdEnabled(test.trim(),measure.trim());
									String ddEnable ="No";
									
							// added for DD data ends here
									String tempInfoCount = reportInfo.getValue("INFRASTRUCTURE_HEALTH_REPORT","ChartInfoCount");
									int TotalInfoCount = 0;
									try {
										TotalInfoCount = Integer.parseInt(tempInfoCount);
									} catch(Exception e) {
										TotalInfoCount = 5;
									}
									if (!resultMap.containsKey(key) || measureCount == 0) {
										continue;
									} else {
										Long tempValue = (Long) resultMap.get(key);
										long value = tempValue.longValue();
										value = (value / 1000) / 60;
										long hr = value / 60;
										long days = 0;
										if (hr >= 24){
											days = hr/24;
											hr = hr % 24;
										}
					
      out.write("<tr>\n\t\t\t\t\t\t\t\t<td  valign=\"top\" class=\"tdborder\" style=\"padding:4px;\">\n\t\t\t\t\t\t\t\t\t<table width=\"100%\" valign=\"top\">\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td class=\"formValue\" colspan=\"2\" align=\"left\">\n\t\t\t\t\t\t\t\t\t\t\t");

												if(componentType!=null && componentType.endsWith("_ex"))
												{
													out.println(tablesInfo.getMeasureAlert(test+":"+measure,"+",thisLanguage));
												}
												else
												{
													out.println(intlmap.getMeasureAlert(test+":"+measure));
												}
												
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\t\t\t<!-- <pd4ml:page.break/> -->\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<pd4ml:page.header areaHeight=\"8\" />\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t");

											if(measureCount >= 1){ 
												long hour = 0;
												long min = 0;
												long sec = 0;
												long day = 0;
												if (alertDuration > 0){
													alertDuration = alertDuration / 1000;
													sec = alertDuration % 60;
													alertDuration = alertDuration / 60;
													min = alertDuration % 60;
													alertDuration = alertDuration / 60;
													hour = alertDuration % 24;
													day = alertDuration / 24;
													alertDuration = alertDuration % 24;
												}
	
      out.write("<td class=\"problmduarion_body\"> \n\t\t\t\t\t\t\t\t\t\t\t\t<table  width=\"100%\" valign=\"top\" cellpadding=\"0\" cellspacing=\"0\" >\n\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\" align=\"left\" class=\"formLabel\">");
      if (_jspx_meth_egui_005fintnl_005f33(_jspx_page_context))
        return;
      out.write("&nbsp;<b>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");

																	if (day > 0 ){
																
      out.print( day );
      out.write("day\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");

																	}
																	if (hour > 0) {
																
      out.print( hour );
      out.write("h\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");

																	}
																	if (min > 0){
																
      out.print( min );
      out.write("m\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");

																	} 
																	if (sec > 0){
																
      out.print( sec );
      out.write("s\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");

																	}
																
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t");
 } 
      out.write("<td class=\"formLabel\" colspan=\"2\"> ");
      if (_jspx_meth_egui_005fintnl_005f34(_jspx_page_context))
        return;
      out.write(" - <b>");
      out.print( intlmap.getTestDescription(test) );
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td class=\"formLabel\" colspan=\"2\"> ");
      if (_jspx_meth_egui_005fintnl_005f35(_jspx_page_context))
        return;
      out.write(" - <b>");
      out.print( intlmap.getMeasureDescription(test,measure) );
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">&nbsp;</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\" class=\"formValue\" align=\"left\">");
      if (_jspx_meth_egui_005fintnl_005f36(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t<!-- <pd4ml:page.break/> -->\n\t\t\t\t\t\t\t\t\t\t\t<pd4ml:page.header areaHeight=\"8\" />\n\t\t\t\t\t\t\t\t");

									TreeMap tmap = new TreeMap();
									Map infoMap = new TreeMap();
									if(infoList != null && infoList.size() > 0) {
										int infoSize = infoList.size();
										List dummyList = new ArrayList();
										// for getting the top 3 component with its info having alerts starts here
										Collections.sort(infoList);
										int count = 0;
										String prevInfo = "";
										List tempList = new ArrayList();
										List tempInfoList = new ArrayList();
										for(int i=0; i<infoSize; i++)
										{
											String currentInfo = (String)infoList.get(i);
											currentInfo = currentInfo.substring(0,currentInfo.indexOf("|$|"));
											if (!tempInfoList.contains(currentInfo))
												tempInfoList.add(currentInfo);
											if(prevInfo.equals(""))
												prevInfo = currentInfo;
											if(prevInfo.equals(currentInfo))
												count ++;
											else {
												if(infoMap.containsKey(new Integer(count)))
														tempList = (ArrayList) infoMap.get(new Integer(count));
												else 
													tempList = new ArrayList();
													tempList.add(prevInfo);
													infoMap.put(new Integer(count),tempList);
													tmap.put(new Integer(count),prevInfo);
													prevInfo = currentInfo;
													count = 1;
											}
										}
											if(infoMap.containsKey(new Integer(count)))
													tempList = (ArrayList) infoMap.get(new Integer(count));
											tempList.add(prevInfo);
											infoMap.put(count,tempList);
										resultMap.put(test+":"+measure+":"+"InfoList",infoMap);
										Set infoSet = infoMap.keySet();
										infoList = new ArrayList();
										infoList.addAll(infoSet);
										resultMap.put(test+":"+measure+":"+"InfoCount",infoList);
										
									
      out.write("<tr class=\"newimg\">\n\t\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">\n\t\t\t\t\t\t\t\t\t\t\t\t<table width=\"100%\"  class=\"printTable\"  cellpadding=\"3\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td class=\"printTableHeader2\"> Component Type</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td class=\"printTableHeader2\"> Component</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td class=\"printTableHeader2\" > Test </td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td class=\"printTableHeader2\" > Descriptor </td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td class=\"printTableHeader2\" >  Total Duration </td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t");

										Map infoDetailsMap = new TreeMap();
										for(int i=infoList.size()-1; i>=0; i--)
										{
											Integer tempCount = (Integer) infoList.get(i);
											int occurenceCount = tempCount.intValue();
											String occurenceCountStr = "1";
											if (occurenceCount > 1)
												occurenceCountStr = String.valueOf(occurenceCount);
											List valueList = (ArrayList) infoMap.get(tempCount);

											for(int j=0; j<valueList.size(); j++)
											{
												String tempInfo = (String) valueList.get(j);
												tempInfo = tempInfo.substring(tempInfo.indexOf("|")+1);
												String infoStr = tempInfo;
												if(!dummyList.contains(infoStr)){
													dummyList.add(infoStr);
												} else 
													continue;
												String component = er_component;
												if(er_healthSummary != null && !er_healthSummary.equalsIgnoreCase("At Server Level")){
													component = infoStr.substring(0,infoStr.indexOf("$"));
													infoStr = infoStr.substring(infoStr.indexOf("$")+1);
												}
												//prakash for kpi health
												else
												{
													if(infoStr!=null && infoStr.indexOf("$") > -1)
													{
														component = infoStr.substring(0,infoStr.indexOf("$"));
														infoStr = infoStr.substring(infoStr.indexOf("$")+1);
													}
												}
												//
												String infoDurationKey = key + PIE + infoStr;
												if(!infoStr.equals("+"))
													infoStr = infoStr.substring(infoStr.indexOf("+")+1);
													if(infoStr.equals("+"))
														infoStr = "-";
													Long infoAlertDuration = (Long) resultMap.get(infoDurationKey);
												if (infoAlertDuration != null){
												if(component.indexOf("NULL") > -1)
													component = component.substring(0,component.indexOf("NULL")-1)+ component.substring(component.indexOf("NULL")+4);
													alertDuration = 0;
													if (infoAlertDuration != null)
														alertDuration = infoAlertDuration.longValue();
													long hour = 0;
													long min = 0;
													long sec = 0;
													long day = 0;
													if (alertDuration > 0){
														alertDuration = alertDuration / 1000;
														sec = alertDuration % 60;
														alertDuration = alertDuration / 60;
														min = alertDuration % 60;
														alertDuration = alertDuration / 60;
														hour = alertDuration % 24;
														day = alertDuration / 24;
														alertDuration = alertDuration % 24;

													}
													String time = "";
													
													if (day > 0 )
														time = day +"day ";
													if (hour > 0)
														time+=hour +"h ";
													if (min > 0)
														time+=min +"m ";
													if (sec > 0)
														time+=sec+"s";
													String detailedString = intlmap.getComponentTypeDescription(componentType) + "$$" +component +"$$"+intlmap.getTestDescription( test)+"$$"+infoStr+"$$"+time;
													
													List detailList;
													if (infoDetailsMap.containsKey(infoAlertDuration))
														detailList = (ArrayList)infoDetailsMap.get(infoAlertDuration);
													else
														detailList = new ArrayList();
													detailList.add(detailedString);
													infoDetailsMap.put(infoAlertDuration,detailList);
												}
											}
										}
										int infoCount = 0;
										Set timeSet = infoDetailsMap.keySet();
										List timeList = new ArrayList(timeSet);
										for (int i=timeList.size()-1; i>=0; i--){
											Long measureDuration = (Long)timeList.get(i);
											List detailList = (ArrayList) infoDetailsMap.get(measureDuration);
											for(int j=0; j<detailList.size(); j++)
											{
													String values = (String)detailList.get(j);
													StringTokenizer str = new StringTokenizer(values,"$$");
													if (infoCount > TotalInfoCount)
														break;
													int detailCount =0;
											
      out.write("<tr align=\"center\">\n\t\t\t\t\t\t\t\t\t\t\t");

												String prevStr = "";
												while(str.hasMoreTokens())
												{
													String tempStr1 = str.nextToken();
													if (str.hasMoreTokens()) {
														if (detailCount == 4){
											
      out.write("<td class=\"tdborder mouse\" onCLick=\"javascript:openChildWindow('");
      out.print( test );
      out.print( measure );
      out.write('\'');
      out.write(',');
      out.write('\'');
      out.print( test );
      out.write('\'');
      out.write(',');
      out.write('\'');
      out.print( measure);
      out.write('\'');
      out.write(',');
      out.write('\'');
      out.print(er_component);
      out.write('\'');
      out.write(',');
      out.write('\'');
      out.print(er_healthSummary);
      out.write('\'');
      out.write(',');
      out.write('\'');
      out.print(prevStr);
      out.write("');\"><font color=\"blue\"> ");
      out.print(tempStr1 );
      out.write("</font> </td>\n\t\t\t\t\t\t\t\t\t\t\t");

														} else {
															prevStr = tempStr1;
											
      out.write("<td class=\"tdborder\" >");
      out.print(tempStr1 );
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t");

														}
													} else if (ddEnable!=null && !ddEnable.equals("") && ddEnable.equalsIgnoreCase("Yes")){
											
													} else {
											
      out.write("<td class=\"tdborder \"  >");
      out.print(tempStr1 );
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t");

													}
													detailCount++;
												}
											
      out.write("</tr>\n\t\t\t\t\t\t\t\t\t\t\t");

												infoCount++;
											}
										}
								
      out.write("</table>\n\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t");

									
										infoList = new ArrayList();
										infoList.addAll(tempInfoList);
									}
								
      out.write("</table>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t");

							String servlet1 = "/final/servlet/com.eg.ErInfrastructureHealthReportC;jsessionid=" + session.getId() + "?isChartRequest=true&er_width=650&er_height=300&er_test="+test+"&er_measure="+measure+"&er_healthSummary="+com.eg.EgURLEncoder.encode(er_healthSummary,
										UTF_8) +"&er_component="+er_component+"&er_comptype="+componentType+"&minto="+minto+"&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&startdate="+com.eg.EgURLEncoder.encode(s_st_time,
										UTF_8)+"&enddate="+com.eg.EgURLEncoder.encode(s_en_time,
										UTF_8)+"&s_st_hr="+s_st_hr+"&s_en_hr="+s_en_hr+"&strmin="+strmin+"&enmin="+enmin+"&fromPrint=true";
						
      out.write("<!-- <pd4ml:page.break/> -->\n\t\t\t\t\t\t\t\t\t<pd4ml:page.header areaHeight=\"8\" />\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<table  border=\"0\" width=\"100%\" class=\"newimg\">\n\t\t\t\t\t\t\t\t\t\t");

											if(infoList.size() > 0){
										
      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\" class=\"fontsize11 cellbglight\" style=\"padding:4px\">");
      if (_jspx_meth_egui_005fintnl_005f37(_jspx_page_context))
        return;
      out.write("&nbsp;<b>");
      out.print(intlmap.getMeasureDescription(test,measure) );
      out.write("</b>&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f38(_jspx_page_context))
        return;
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr class=\"newimg\">\n\t\t\t\t\t\t\t\t\t\t\t<td class=\"newimg\">\n\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\"  class=\"newimg\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<!-- <pd4ml:page.break/> -->\n\t\t\t\t\t\t\t\t\t\t\t\t\t<pd4ml:page.header areaHeight=\"8\" />\n\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"left\"><img src=\"");
      out.print( strManagerURL + servlet1 );
      out.write("\"/></td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td >\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<table class=\"newimg\" width=\"100%\" style=\"border:0px solid red\" >\n\t\t\t\t\t\t\t\t\t\t");

											IniUI iniui=IniUI.getInstance();
											int maxSize = infoList.size()< TotalInfoCount ?infoList.size():TotalInfoCount;
											HashMap map=(HashMap)iniui.getReporterGraphParams();
											StringTokenizer stc = new StringTokenizer((String)map.get("samplecolors"),",");
											String[] colorstrArray = new String[stc.countTokens()];
											for(int k=0;k<colorstrArray.length;k++)
											{
												String strstc = stc.nextToken().trim();
												colorstrArray[k]=strstc;
											}
											int colorCount = 0;
											for(int i=0; i<maxSize; i++)
											{
												String st_key = colorstrArray[colorCount];
												String infoStr = (String) infoList.get(i);
												String component = "";
												if(infoStr.indexOf("$") != -1){
													component = infoStr.substring(0,infoStr.indexOf("$"));
													infoStr = infoStr.substring(infoStr.indexOf("$")+2);
													if(component.indexOf("NULL") != -1)
														component = component.substring(0,component.indexOf("NULL")-1) ;//;+ 
													if (!infoStr.equals(""))
														component += " - " + infoStr;
												} else {
													component = infoStr.substring(1);
												}
												colorCount++;
												if(colorCount > colorstrArray.length-1)
													colorCount = 0;
												st_key = st_key.substring(1,st_key.length());
										
      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td style=\"padding-top: 3px;\" class=\"fontsize11 newimg\" ><img src=\"/final/servlet/com.eg.ErImageDrawC?req=");
      out.print(st_key);
      out.write("\"/></td><td class=\"newimg\" style=\"padding-left: 4px;\"> ");
      out.print(component);
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t");

											}
										
      out.write("</table>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>&nbsp;</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t");
 
													String measureInterpretation = utils.findMeasureInterpretation(test,measure);
													if (!StringUtils.isNull(measureInterpretation) && measureInterpretation.length()>0 && !measureInterpretation.trim().equalsIgnoreCase("&nbsp;")){
												
      out.write("<tr class=\"newimg\"> \n\t\t\t\t\t\t\t\t\t\t\t<td class=\"newimg\">\n\t\t\t\t\t\t\t\t\t\t\t\t<table width=\"100%\" class=\"tdborder\" class=\"newimg\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<tr class=\"tableTrBgOdd\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td class=\"recomm_footerline\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div style=\"border: 1px solid #c3c3c3;background: #f4f4f4;\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div style=\"margin: 10px 10px 0px 10px;\"><b>");
      if (_jspx_meth_egui_005fintnl_005f39(_jspx_page_context))
        return;
      out.write("</b></div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div style=\"padding:10px;line-height: 18px;\"><table><tr>");
      out.print(measureInterpretation );
      out.write("</tr></table></div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t");
 
													}
												} 
      out.write("</table>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t");

									}
							}
						}
					
      out.write("</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t");

		}
		}
						
      out.write("</table>\n\t\t</td>\n\t</tr>\n</table>\n</body>\n</html>\n\n\n");

} catch(Exception e){
	e.printStackTrace();
}

      out.write("<script>\n//window.print();\n");

	if (!StringUtils.isNull(er_RmDispName)){
		//For Setting the PDf File Name
		er_RmDispName = er_RmDispName.replace(" ","_");
		HashMap paramVal =new HashMap();
		paramVal.put("fileName",er_RmDispName);
		session.setAttribute("parameters", paramVal);
	} else {
		HashMap paramVal = new HashMap();
		paramVal.put("fileName", "infrastructure_health_report");
		session.setAttribute("parameters", paramVal);
	}

      out.write("</script>");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }

  private boolean _jspx_meth_egui_005fintnl_005f0(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f0 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f0.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f0.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(369,16) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f0.setText("reporter.common.Reporter");
    int _jspx_eval_egui_005fintnl_005f0 = _jspx_th_egui_005fintnl_005f0.doStartTag();
    if (_jspx_th_egui_005fintnl_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f0);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f0);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f1(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f1 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f1.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f1.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(370,16) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f1.setText("reporter.common.Print");
    int _jspx_eval_egui_005fintnl_005f1 = _jspx_th_egui_005fintnl_005f1.doStartTag();
    if (_jspx_th_egui_005fintnl_005f1.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f1);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f1);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f2(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f2 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f2.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f2.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(376,16) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f2.setText("reporter.common.Reporter");
    int _jspx_eval_egui_005fintnl_005f2 = _jspx_th_egui_005fintnl_005f2.doStartTag();
    if (_jspx_th_egui_005fintnl_005f2.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f2);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f2);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f3(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f3 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f3.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f3.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(466,36) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f3.setText("reporter.common.INFRASTRUCTURE HEALTH REPORT ");
    int _jspx_eval_egui_005fintnl_005f3 = _jspx_th_egui_005fintnl_005f3.doStartTag();
    if (_jspx_th_egui_005fintnl_005f3.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f3);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f3);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f4(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f4 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f4.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f4.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(472,199) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f4.setText("reporter.common.PRINT");
    int _jspx_eval_egui_005fintnl_005f4 = _jspx_th_egui_005fintnl_005f4.doStartTag();
    if (_jspx_th_egui_005fintnl_005f4.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f4);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f4);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f5(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f5 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f5.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f5.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(472,250) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f5.setText("reporter.common.PRINT");
    int _jspx_eval_egui_005fintnl_005f5 = _jspx_th_egui_005fintnl_005f5.doStartTag();
    if (_jspx_th_egui_005fintnl_005f5.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f5);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f5);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f6(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f6 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f6.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f6.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(484,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f6.setText("reporter.common.Analyzed by");
    int _jspx_eval_egui_005fintnl_005f6 = _jspx_th_egui_005fintnl_005f6.doStartTag();
    if (_jspx_th_egui_005fintnl_005f6.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f6);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f6);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f7(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f7 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f7.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f7.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(502,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f7.setText("reporter.common.Include Zone");
    int _jspx_eval_egui_005fintnl_005f7 = _jspx_th_egui_005fintnl_005f7.doStartTag();
    if (_jspx_th_egui_005fintnl_005f7.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f7);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f7);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f8(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f8 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f8.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f8.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(514,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f8.setText("reporter.common.Summary Type");
    int _jspx_eval_egui_005fintnl_005f8 = _jspx_th_egui_005fintnl_005f8.doStartTag();
    if (_jspx_th_egui_005fintnl_005f8.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f8);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f8);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f9(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f9 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f9.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f9.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(520,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f9.setText("reporter.common.Exclude Weekends");
    int _jspx_eval_egui_005fintnl_005f9 = _jspx_th_egui_005fintnl_005f9.doStartTag();
    if (_jspx_th_egui_005fintnl_005f9.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f9);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f9);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f10(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f10 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f10.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f10.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(554,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f10.setText("reporter.common.Start Date");
    int _jspx_eval_egui_005fintnl_005f10 = _jspx_th_egui_005fintnl_005f10.doStartTag();
    if (_jspx_th_egui_005fintnl_005f10.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f10);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f10);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f11(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f11 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f11.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f11.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(559,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f11.setText("reporter.common.EndDate");
    int _jspx_eval_egui_005fintnl_005f11 = _jspx_th_egui_005fintnl_005f11.doStartTag();
    if (_jspx_th_egui_005fintnl_005f11.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f11);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f11);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f12(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f12 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f12.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f12.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(564,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f12.setText("reporter.common.Time Period");
    int _jspx_eval_egui_005fintnl_005f12 = _jspx_th_egui_005fintnl_005f12.doStartTag();
    if (_jspx_th_egui_005fintnl_005f12.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f12);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f12);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f13(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f13 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f13.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f13.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(566,93) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f13.setText("reporter.common.to ");
    int _jspx_eval_egui_005fintnl_005f13 = _jspx_th_egui_005fintnl_005f13.doStartTag();
    if (_jspx_th_egui_005fintnl_005f13.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f13);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f13);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f14(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f14 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f14.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f14.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(790,135) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f14.setText("reporter.common.Infrastructure Health Summary");
    int _jspx_eval_egui_005fintnl_005f14 = _jspx_th_egui_005fintnl_005f14.doStartTag();
    if (_jspx_th_egui_005fintnl_005f14.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f14);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f14);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f15(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f15 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f15.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f15.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(794,110) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f15.setText("reporter.common.OK");
    int _jspx_eval_egui_005fintnl_005f15 = _jspx_th_egui_005fintnl_005f15.doStartTag();
    if (_jspx_th_egui_005fintnl_005f15.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f15);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f15);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f16(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f16 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f16.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f16.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(795,109) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f16.setText("reporter.common.Caution");
    int _jspx_eval_egui_005fintnl_005f16 = _jspx_th_egui_005fintnl_005f16.doStartTag();
    if (_jspx_th_egui_005fintnl_005f16.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f16);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f16);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f17(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f17 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f17.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f17.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(796,112) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f17.setText("reporter.common.Needs Attention");
    int _jspx_eval_egui_005fintnl_005f17 = _jspx_th_egui_005fintnl_005f17.doStartTag();
    if (_jspx_th_egui_005fintnl_005f17.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f17);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f17);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f18(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f18 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f18.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f18.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(809,35) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f18.setText("reporter.common.Infrastructure Tiers");
    int _jspx_eval_egui_005fintnl_005f18 = _jspx_th_egui_005fintnl_005f18.doStartTag();
    if (_jspx_th_egui_005fintnl_005f18.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f18);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f18);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f19(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f19 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f19.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f19.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(813,35) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f19.setText("reporter.common.Server Type");
    int _jspx_eval_egui_005fintnl_005f19 = _jspx_th_egui_005fintnl_005f19.doStartTag();
    if (_jspx_th_egui_005fintnl_005f19.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f19);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f19);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f20(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f20 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f20.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f20.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(814,48) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f20.setText("reporter.common.Health of Key Performance Indicators (%)");
    int _jspx_eval_egui_005fintnl_005f20 = _jspx_th_egui_005fintnl_005f20.doStartTag();
    if (_jspx_th_egui_005fintnl_005f20.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f20);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f20);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f22(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f22 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f22.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f22.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1258,138) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f22.setText("reporter.common.Infrastructure Health Summary");
    int _jspx_eval_egui_005fintnl_005f22 = _jspx_th_egui_005fintnl_005f22.doStartTag();
    if (_jspx_th_egui_005fintnl_005f22.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f22);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f22);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f23(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f23 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f23.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f23.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1262,95) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f23.setText("reporter.common.OK");
    int _jspx_eval_egui_005fintnl_005f23 = _jspx_th_egui_005fintnl_005f23.doStartTag();
    if (_jspx_th_egui_005fintnl_005f23.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f23);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f23);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f24(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f24 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f24.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f24.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1263,94) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f24.setText("reporter.common.Caution");
    int _jspx_eval_egui_005fintnl_005f24 = _jspx_th_egui_005fintnl_005f24.doStartTag();
    if (_jspx_th_egui_005fintnl_005f24.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f24);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f24);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f25(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f25 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f25.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f25.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1264,97) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f25.setText("reporter.common.Needs Attention");
    int _jspx_eval_egui_005fintnl_005f25 = _jspx_th_egui_005fintnl_005f25.doStartTag();
    if (_jspx_th_egui_005fintnl_005f25.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f25);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f25);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f26(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f26 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f26.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f26.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1273,41) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f26.setText("reporter.common.Infrastructure Tiers");
    int _jspx_eval_egui_005fintnl_005f26 = _jspx_th_egui_005fintnl_005f26.doStartTag();
    if (_jspx_th_egui_005fintnl_005f26.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f26);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f26);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f27(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f27 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f27.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f27.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1274,35) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f27.setText("reporter.common.Server Type");
    int _jspx_eval_egui_005fintnl_005f27 = _jspx_th_egui_005fintnl_005f27.doStartTag();
    if (_jspx_th_egui_005fintnl_005f27.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f27);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f27);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f28(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f28 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f28.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f28.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1275,35) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f28.setText("reporter.common.Components");
    int _jspx_eval_egui_005fintnl_005f28 = _jspx_th_egui_005fintnl_005f28.doStartTag();
    if (_jspx_th_egui_005fintnl_005f28.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f28);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f28);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f29(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f29 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f29.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f29.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1276,48) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f29.setText("reporter.common.Health of Key Performance Indicators (%)");
    int _jspx_eval_egui_005fintnl_005f29 = _jspx_th_egui_005fintnl_005f29.doStartTag();
    if (_jspx_th_egui_005fintnl_005f29.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f29);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f29);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f31(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f31 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f31.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f31.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1478,62) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f31.setText("reporter.common.Problems affecting the health");
    int _jspx_eval_egui_005fintnl_005f31 = _jspx_th_egui_005fintnl_005f31.doStartTag();
    if (_jspx_th_egui_005fintnl_005f31.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f31);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f31);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f32(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f32 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f32.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f32.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1519,51) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f32.setText("reporter.common.Problems affecting the health of ");
    int _jspx_eval_egui_005fintnl_005f32 = _jspx_th_egui_005fintnl_005f32.doStartTag();
    if (_jspx_th_egui_005fintnl_005f32.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f32);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f32);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f33(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f33 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f33.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f33.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1647,61) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f33.setText("reporter.common.Total Problem Duration :");
    int _jspx_eval_egui_005fintnl_005f33 = _jspx_th_egui_005fintnl_005f33.doStartTag();
    if (_jspx_th_egui_005fintnl_005f33.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f33);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f33);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f34(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f34 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f34.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f34.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1674,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f34.setText("Test");
    int _jspx_eval_egui_005fintnl_005f34 = _jspx_th_egui_005fintnl_005f34.doStartTag();
    if (_jspx_th_egui_005fintnl_005f34.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f34);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f34);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f35(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f35 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f35.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f35.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1676,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f35.setText("Measure");
    int _jspx_eval_egui_005fintnl_005f35 = _jspx_th_egui_005fintnl_005f35.doStartTag();
    if (_jspx_th_egui_005fintnl_005f35.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f35);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f35);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f36(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f36 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f36.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f36.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1687,58) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f36.setText("Affected Components ");
    int _jspx_eval_egui_005fintnl_005f36 = _jspx_th_egui_005fintnl_005f36.doStartTag();
    if (_jspx_th_egui_005fintnl_005f36.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f36);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f36);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f37(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f37 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f37.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f37.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1906,81) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f37.setText("reporter.common.Chart showing the values of");
    int _jspx_eval_egui_005fintnl_005f37 = _jspx_th_egui_005fintnl_005f37.doStartTag();
    if (_jspx_th_egui_005fintnl_005f37.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f37);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f37);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f38(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f38 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f38.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f38.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1906,213) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f38.setText("during the problem time");
    int _jspx_eval_egui_005fintnl_005f38 = _jspx_th_egui_005fintnl_005f38.doStartTag();
    if (_jspx_th_egui_005fintnl_005f38.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f38);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f38);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f39(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f39 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f39.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f39.setParent(null);
    // /reporter/ErInfrastructureHealthReportPrint.jsp(1975,60) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f39.setText("Recommendation");
    int _jspx_eval_egui_005fintnl_005f39 = _jspx_th_egui_005fintnl_005f39.doStartTag();
    if (_jspx_th_egui_005fintnl_005f39.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f39);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f39);
    return false;
  }
}
