package org.apache.jsp.reporter;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.List;
import java.util.ArrayList;
import java.util.*;
import java.io.*;
import java.sql.*;
import egurkha.*;
import egurkha.reporter.*;
import com.egurkha.*;
import com.egurkha.ini.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.egurkha.util.StringUtils;
import com.egurkha.util.DateUtil;
import com.egurkha.util.DateTimeTokenizer;
import com.eg.EgReportInfo;
import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgDbInfo;
import com.eg.EgGroupInfo;
import com.eg.EgMappingInfo;
import com.eg.EgName;
import com.eg.EgTablesInfo;
import com.eg.EgTestInfo;
import com.eg.EgTopoInfo;
import com.eg.MappingNameSorter;
import com.eg.EgName;
import egurkha.reporter.ErVMRightSizingVO;
import net.sf.json.*;
import java.util.*;
import java.text.*;
import com.eg.EgReportInfo;
import com.eg.EgDateInfo;
import com.egurkha.util.*;

public final class ErVMRightSizingReportJSON_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	private static final String BLANK_SPACE = " ";
	private static final String COMA = ",";
	private static final String COLON = ":";
	private static final String PIE = "|";
	private static final String BSLASH = "/";
	private static final String UTF_8 = "UTF-8";
	private static final String NODATAFOUND = "NO_DATA_FOUND";
	private static final String CRITERIAONLY = "CRITERIA_ONLY_FLAG";
	private static final String VMNODATA = "DATA_FOR_VM";
	private static final String GPUDATA = "DATA_FOR_GPU";
	private static final String MANAGER = "manager";
	private static final String VM_RIGHT_SIZING_REPORT = "VM_RIGHT_SIZING_REPORT";
	private static final String SORTABLE = "<div style='float:left;padding:2px 2px 0px 2px;'><img src='/final/images/sortable_white.png' class='png'/></div>";
	private static final String SORTED_UP = " <div style='float:left;padding:0px 2px 2px 2px;'><img src='/final/images/sorted_up.png' class='png'/></div>";
	private static final String SORTED_DOWN = "<div style='float:left;padding:0px 2px 2px 2px;'><img src='/final/images/sorted_down.png' class='png'/></div>";

 
	public JSONArray getLastCalenJson(List weekList) {
		JSONArray tmpJsonArr=new JSONArray();
		JSONObject timelineJSON = new JSONObject();	
		String tmpTimeLine = null;
		String viewField=null;			
		for(int x=0;x<weekList.size();x++){
			tmpTimeLine = (String)weekList.get(x);	
			int spaceCount = 0;	
			for(int y=0; y<tmpTimeLine.length();y++){				
				char ch = tmpTimeLine.charAt(y);
				if(ch== ' '){
				   spaceCount++; 
				}
			}
			if(spaceCount > 1){
				//Last 2 weeks    weeks_last 2
				String countStr = tmpTimeLine.substring(tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = tmpTimeLine.substring(tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.length());
				String last = tmpTimeLine.substring(0, tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr +" "+ end + "_" + last;				
			}else{
				viewField = "1 "+tmpTimeLine.substring(tmpTimeLine.lastIndexOf(" ")+1, tmpTimeLine.length())  + "_" + tmpTimeLine.substring(0, tmpTimeLine.indexOf(" "));				
			}			
			timelineJSON.put("displayField",tmpTimeLine);
			timelineJSON.put("valueField", viewField.toLowerCase());
			tmpJsonArr.add( timelineJSON );		
		}		
		return tmpJsonArr;
   } 


	public List<String> getLastWeekMonthList(String currentDateFormat, User user, String timeLine, boolean isZoneType){
		EgDateInfo egDt = new EgDateInfo();
		List<String> lastWeekList = new ArrayList<String>();
		String startDate = null;
		String endDate = null;
		int count = Integer.parseInt(timeLine.substring(0, timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)));
		String unit = timeLine.substring(timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,timeLine.length());
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
		java.util.Date today = egDt.egetRealDate();
		String currentDateTime = sdf.format(today);
		String currentDate = currentDateTime.substring(0, currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
		String currentHr = currentDateTime.substring(currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, currentDateTime.indexOf(":"));
		String currentMin = currentDateTime.substring(currentDateTime.indexOf(":")+1,currentDateTime.lastIndexOf(":"));
		String time = " "+currentHr+":"+currentMin;
		String curFormatDate  = DateUtil.changeDateFormat(currentDate, "MM/dd/yyyy", currentDateFormat);		
		String userFormat = user.getUserDateFormat();
		try{
			java.util.Date realDate = null;
			if(!isZoneType){
				EgTimeZoneConverter tmZoneConverter = new EgTimeZoneConverter(curFormatDate+time,user);				
				realDate = new SimpleDateFormat(userFormat).parse(tmZoneConverter.getDateTime());
				sdf = new SimpleDateFormat(userFormat);
			}else{
				realDate = new SimpleDateFormat(userFormat).parse(curFormatDate);
			}
					
			Calendar c = Calendar.getInstance();
			c.setTime(realDate);
			if(unit.startsWith("we")){
				int weekCount = count;
				int i = c.get(Calendar.DAY_OF_WEEK) - c.getFirstDayOfWeek() * weekCount;
				int startDayCount = 7 * weekCount + (1 * (weekCount - 1));
				int lastDayCount = 6 * weekCount + (1 * (weekCount - 1));
				c.add(Calendar.DATE, - i - startDayCount);
				startDate = sdf.format(c.getTime());
				c.add(Calendar.DATE, lastDayCount);	
				endDate = sdf.format(c.getTime());
				if(isZoneType){
					startDate = startDate.substring(0, startDate.indexOf(DateTimeTokenizer.BLANK_SPACE));
					endDate = endDate.substring(0, endDate.indexOf(DateTimeTokenizer.BLANK_SPACE));					
				}															
			}else if(unit.startsWith("mo")){
				int monthCount = count;
				c.add(Calendar.MONTH, -monthCount);
				c.set(Calendar.DATE, 1);
				startDate = sdf.format(c.getTime());				
				
				Calendar c1 = Calendar.getInstance();
				c1.setTime(realDate);
				c1.add(Calendar.MONTH, -1);
				c1.set(Calendar.DAY_OF_MONTH, c1.getActualMaximum(Calendar.DAY_OF_MONTH));
				endDate = sdf.format(c1.getTime());
				if(isZoneType){
					startDate = startDate.substring(0, startDate.indexOf(DateTimeTokenizer.BLANK_SPACE));
					endDate = endDate.substring(0, endDate.indexOf(DateTimeTokenizer.BLANK_SPACE));	
				}
			}else{}
			lastWeekList.add(startDate);
			lastWeekList.add(endDate);
		}catch(Exception e){
			e.printStackTrace();
		}
		return lastWeekList;
	}


	public synchronized Vector getFilteredSitesBeasedOnComponents(String er_option,String er_includeZones,List supportableCompTypesList,List userSitesList,ErUserData UBean,EgGroupInfo gpinfo,EgTopoInfo topoInfo, EgCrawler crawlerBean)
	{
		//System.out.println("supportableCompTypesList	---------------	"+supportableCompTypesList);
 		Vector siteList = new Vector();
		if(er_option!=null && er_option.equals("Zone"))
		{
			List v_comps = UBean.getAllUserComponents(3);
			for (int i = 0; i < userSitesList.size(); i++)
			{
				String zoneName=(String) userSitesList.get(i);
				if(zoneName!=null && !zoneName.equals("--Default--"))
				{
					List v_temp = gpinfo.getAllComponentsUnderZone(zoneName, er_includeZones.equalsIgnoreCase("yes"));
					
					List supportableCompList = new ArrayList();
					List removeList = new ArrayList();
					for (int k = 0; k < v_temp.size(); k++) 
					{
						String tempStr = (String) v_temp.get(k);
						String ctype=tempStr.substring(0, tempStr.indexOf(COLON));
						tempStr = tempStr.substring(tempStr.indexOf(COLON) + 1) + COLON + ctype;
						if (supportableCompTypesList.contains(ctype)) 
						{
							supportableCompList.add(tempStr);
						}
						removeList.add(tempStr);
					}
					if(supportableCompList.size()>0)
					{
						siteList.add(zoneName);
					}
					v_comps.removeAll(removeList);
				}
				v_comps.retainAll(supportableCompTypesList);
				if(v_comps.size()>0)
				{
					siteList.add("--Default--");
				}
			}
		}
		else if(er_option!=null && er_option.equals("Segment"))
		{
 			for (int i = 0; i < userSitesList.size(); i++)
			{
				String segmentName=(String) userSitesList.get(i);
				List v_temp = topoInfo.getAssociatesForSegment(segmentName, 2);
				List supportableCompList = new ArrayList();
				for (int k = 0; k < v_temp.size(); k++) 
				{
					String tempStr = (String) v_temp.get(k);
					String ctype=tempStr.substring(0, tempStr.indexOf(COLON));
					tempStr = tempStr.substring(tempStr.indexOf(COLON) + 1) + COLON + ctype;
					if (supportableCompTypesList.contains(ctype)) 
					{
						supportableCompList.add(tempStr);
					}
				}
				if(supportableCompList.size()>0)
				{
					siteList.add(segmentName);
				}
			}
		}
		else if(er_option!=null && er_option.equals("Service"))
		{
 			for (int i = 0; i < userSitesList.size(); i++)
			{
				String serviceName=(String) userSitesList.get(i);
				List v_temp =crawlerBean.getAssociates(serviceName);
				List supportableCompList = new ArrayList();
				for (int k = 0; k < v_temp.size(); k++) 
				{
					String tempStr = (String) v_temp.get(k);
					String ctype=tempStr.substring(0, tempStr.indexOf(COLON));
					tempStr = tempStr.substring(tempStr.indexOf(COLON) + 1) + COLON + ctype;
					if (supportableCompTypesList.contains(ctype)) 
					{
						supportableCompList.add(tempStr);
					}
				}
				if(supportableCompList.size()>0)
				{
					siteList.add(serviceName);
				}
			}
		}
		//System.out.println("siteList	---------------	"+siteList);
		return siteList;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/reporter/ErReporterTracker.jsp");
    _jspx_dependants.add("/reporter/ErTimeFormatJSON.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


//	response.setHeader("Cache-Control","no-store");
//	response.setHeader("Pragma","no-cache");
//	response.setDateHeader ("Expires", -1);
	
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	String imageName = null;
	IniUI egui = IniUI.getInstance();
	imageName = egui.getReporterHomeLogo();
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	ErUserData UBean = null;
	String reporter_Skin = null;

	boolean id_u = false;
	boolean isLastTimeLine = false;
	String urs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	UserRegistry registry= null;
	User thisuser=null;
	String throughSchedule = request.getParameter("throughSchedule");
	if(throughSchedule == null) {
		throughSchedule = "";
	}
	String usr_Id_proc = request.getParameter("er_userid");
	String usr_Id = request.getParameter("eruserid");
	String userID = request.getParameter("userID");
	if(session!=null)
	{
		 UBean = (ErUserData) session.getAttribute("UBean");
		 if(throughSchedule.equalsIgnoreCase("true")) {
			 try
			 {
			if(UBean == null) {
				if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id,false);
					usr_Id_proc = usr_Id;
				}
				else if(userID != null){
					UBean = new ErUserData(userID,false);
					usr_Id_proc = userID;
				}
				else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id_proc,false);
				}
				else{
					UBean = new ErUserData(usr_Id_proc,false);
				}

			}
			}
			catch(Throwable t)
			{
			t.printStackTrace();
			}
		}
		if(UBean != null)
		{
			registry = UserRegistry.getInstance();
			thisuser= registry.getUser(session.getId(),true);
			if(thisuser!=null)
			{
				id_u = thisuser.isIdDeletedWhileLoggedIn();
				if(id_u==false )
				{
					urs = thisuser.getLoginID();
					if(!User.isDefaultUser(urs))
					{
						u_v_till = UBean.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
			if(thisuser == null && usr_Id_proc!= null ) {
				try {
					thisuser = UBean.getUser(usr_Id_proc);
					registry.setUser(session.getId(), thisuser, false);
					System.out.println("Setting user object. user reporter skin : " + thisuser.getReporterSkin());
				} catch(Exception ex) {
					System.out.println("Setting user object failed");
					ex.printStackTrace();
				}
			}
		}
	}
	if(session == null || thisuser == null)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");		
	}
	else if(id_u== true)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-deleted</customerror>");
	}
	else if (u_v_till < l_accessed)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}

	if(session!=null && UBean != null && thisuser!=null)
	{
		//session.putValue("Page_IdentifierR",request.getRequestURI());	
		String pageName = request.getRequestURI();
		if(!pageName.endsWith("ErMeasureData.jsp") && !pageName.endsWith("ErMeasure.jsp") && !pageName.endsWith("ErPrintReport.jsp") && !pageName.endsWith("ErPrintDataReport.jsp") && !pageName.endsWith("ErComparisonData.jsp") && !pageName.endsWith("ErMacroData.jsp") && !pageName.endsWith("ErCtxUserGraph.jsp") && !pageName.endsWith("ErMacroPrint.jsp") && !pageName.endsWith("ErHomePrint.jsp"))
		{
			//session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
		}
	}
	

	if (thisuser!=null)
	{
		String trackerUserLang = thisuser.getLanguage();
		thisuser.setUserLanguageAndSkins();
		reporter_Skin  = thisuser.getReporterSkin();

		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
	}
	String  script_src="script_item_"+trackerLanguage+".js";

	//Added by Sakthivel - 26/03/2008
	String uiFileTemp = "eg_ui.ini";
	String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
	//Variable to be used in javascript code
	String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(thisuser!=null)
	{
		currentDateFormatForJS = thisuser.getUserDateFormat();
	}
	String strUserDateFormat =currentDateFormatForJS;
	if(currentDateFormatForJS.indexOf("MMM") >= 0)
	{
		for(int i=0; i < currentDateFormatForJS.length();i++)
		{
			if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
			{
				currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
			}
		}
	}
	egurkha.reporter.ErBackgroundReportGenerator erbgreport = new egurkha.reporter.ErBackgroundReportGenerator();
	String strArray[] =erbgreport.getSelection(urs);
	String strforeground = strArray[0];
	String strbackground =  strArray[1];
	String bgString="'";



    try 
	{
        JSONObject rightSizingJson = new JSONObject();
        JSONObject displayLabels = new JSONObject();
        JSONObject urlFields = new JSONObject();
        JSONObject validationFields = new JSONObject();
        JSONObject timeZone = new JSONObject();
        JSONObject hiddenFields = new JSONObject();
        JSONObject idFields = new JSONObject();
        JSONObject selectedFields = new JSONObject();
        JSONObject dynamicFields = new JSONObject();
		JSONObject selectionDetails = new JSONObject();
        JSONObject grid = new JSONObject();

        EgReportInfo reportInfo = new EgReportInfo(MANAGER);
        IniUI ui = IniUI.getInstance();
        String thisLanguage = ui.getDefaultLanguage();
        ErUtils erUtils = new ErUtils();
        ErReportHelper erh = new ErReportHelper();
        UBean = new ErUserData(urs, false);
        ErUserData erdata = new ErUserData(UBean.getUserId(), false);
        EgTopoInfo topoInfo = new EgTopoInfo(MANAGER);
        User this_user = UserRegistry.getInstance().getUser(session.getId());
        EgGroupInfo gpinfo = new EgGroupInfo();
        EgTestInfo tokInfo = new EgTestInfo(MANAGER);
        EgDateInfo egDt = new EgDateInfo();
        EgTablesInfo tablesInfo = new EgTablesInfo(MANAGER);
        String userid = UBean.getUserId();
        EgMappingInfo intlmap = new EgMappingInfo(thisuser.getLanguage());
		MappingNameSorter sorter = new MappingNameSorter(thisuser.getLanguage());
        ErComponentsUtils compUtil = new ErComponentsUtils(thisuser.getLoginID());

        Map resultMap = (Map) session.getAttribute(VM_RIGHT_SIZING_REPORT);

        String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES", "ManagerUrl");
        String er_option = request.getParameter("er_option");
        String sel_component[] = request.getParameterValues("er_component");
        String s_comptype = request.getParameter("er_comptype");
        String er_site = request.getParameter("er_site");
        String reqFromSchedule = request.getParameter("fromSchedule");
        String bggroundStr = (String) request.getAttribute("bggroundStr");
        String status = (String) request.getAttribute("status");
        String isSubmit = request.getParameter("isSubmit");
        String er_timeline = request.getParameter("er_timeline");
        String s_st_time = request.getParameter("startdate");
        String s_en_time = request.getParameter("enddate");
        String s_st_hr = request.getParameter("starthr");
        String s_en_hr = request.getParameter("endhr");
        String strmin = request.getParameter("startmin");
        String enmin = request.getParameter("endmin");
        String s_inidate = request.getParameter("inidate");
        String er_includeZones = request.getParameter("er_includezones");
        String divStatus = request.getParameter("divStatus");
        String schedule_id = request.getParameter("schedule_id");
        String er_criteria = request.getParameter("er_criteria");
        String er_criteriaInfo = request.getParameter("er_criteriaInfo");
        String er_criteriaonly = request.getParameter("er_criteriaOnly");
        String sortingCount = request.getParameter("sortingCount");
        String sortingOrder = request.getParameter("sortingOrder");
        String sortingOption = request.getParameter("sortingOption");
		String fromScheduleModify = request.getParameter("fromScheduleModify");
		String fromFavoriteModify = request.getParameter("fromFavoriteModify");
		String favorite_id = request.getParameter("id");
		String er_favorite = request.getParameter("er_favorite");
		String dynamicRangeValue = request.getParameter("dynamicRangeValue");
		String dynamicBufferRangeValue = request.getParameter("dynamicBufferRangeValue");
		String srcForImg = "";
        if (divStatus == null)
		{
            divStatus = "none";
        }
        if (divStatus.equals("none"))
		{
            srcForImg = "../images/moreoption.png";
        }
		else if (divStatus.equals("block")) 
		{
            srcForImg = "../images/lessoption.png";
        }
        if (er_timeline == null) 
		{
            er_timeline = "1 day";
        }
        String uiFile = "eg_ui.ini";
        String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
        com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
        String currentDateFormat = strUserDateFormat;

        String confirmation = reportInfo.getValue("BACKGROUND_PROCESS", "NeedConfirmation");
        String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS", "EnableBackgroundReport");
        String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS", "MinDurationForReport");
        String dispCsvStartDate = s_st_time + " " + s_st_hr + COLON + strmin;
        String dispCsvEndDate = s_en_time + " " + s_en_hr + COLON + enmin;
        String criticalColor = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "CriticalColor");
        String normalColor = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "NormalColor");

        List listCompTypes = reportInfo.getComponent(VM_RIGHT_SIZING_REPORT, false);
        Vector v_component = new Vector();
        Vector temp_component = new Vector();
        Vector v_comptype = new Vector();
        Vector v_componentName = new Vector();
        Vector v_options = new Vector();
        Vector v_segment = new Vector();
        Vector v_service = new Vector();
        Vector v_zones = new Vector();
        Vector v_comp_popup = new Vector();
        Vector v_comp_popup_disp = new Vector();
        List compList = new ArrayList();
        List utilizationList = new ArrayList();
        List criteriaList = new ArrayList();
        Vector v_time = new Vector();
       /* utilizationList.add("Oversized VMs by CPU Usage");
        utilizationList.add("Undersized VMs by CPU Usage");
        utilizationList.add("Oversized VMs by Memory Usage");
        utilizationList.add("Undersized VMs by Memory Usage");
        utilizationList.add("VMs by GPU Pass Through");
        utilizationList.add("VMs by GPU Shared");*/
        criteriaList.add("CPU Usage");
        criteriaList.add("Memory Usage");
        criteriaList.add("GPU Usage");
        utilizationList.add("Oversized VMs");
        utilizationList.add("Undersized VMs");

        if (er_criteria == null) 
		{
            er_criteria = "Oversized VMs";
        }
        if (er_criteriaInfo == null) 
		{
            er_criteriaInfo = "CPU Usage";
        }

        v_time.add("00");
        v_time.add("01");
        v_time.add("02");
        v_time.add("03");
        v_time.add("04");
        v_time.add("05");
        v_time.add("06");
        v_time.add("07");
        v_time.add("08");
        v_time.add("09");
        v_time.add("10");
        v_time.add("11");
        v_time.add("12");
        v_time.add("13");
        v_time.add("14");
        v_time.add("15");
        v_time.add("16");
        v_time.add("17");
        v_time.add("18");
        v_time.add("19");
        v_time.add("20");
        v_time.add("21");
        v_time.add("22");
        v_time.add("23");

        Vector v_min = new Vector();
        v_min.add("00");
        v_min.add("05");
        v_min.add("10");
        v_min.add("15");
        v_min.add("20");
        v_min.add("25");
        v_min.add("30");
        v_min.add("35");
        v_min.add("40");
        v_min.add("45");
        v_min.add("50");
        v_min.add("55");
        v_min.add("59");

        String timefrom = "";
        String minfrom = "";
        String timeto = "";
        String minto = "";
        String endDateTime = "";
        String startDateTime = "";
        long msecsPerHour = (long) 1000 * 60 * 60;
        String disable = "";
        String[] options = {"Any", "1 day", "2 days", "3 days", "4 days", "5 days", "6 days", "1 week", "2 weeks", "3 weeks", "1 month"};
        String dispDate = null;
        String comFormat = null;
        String timefrom1 = (erh.getTimeFrame("TIMEFRAME", "From") == null) ? "00:00" : erh.getTimeFrame("TIMEFRAME", "From");
        String timeto1 = (erh.getTimeFrame("TIMEFRAME", "To") == null) ? "23:59" : erh.getTimeFrame("TIMEFRAME", "To");
        timefrom1 = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "startTime");
        timeto1 = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "endTime");
        StringTokenizer st;
        if (timefrom1 != null) 
		{
            st = new StringTokenizer(timefrom1, ":");
            if (st.hasMoreTokens()) 
			{
                timefrom = st.nextToken();
                minfrom = st.nextToken();
            }
        }
        if (timeto1 != null) 
		{
            st = new StringTokenizer(timeto1, ":");
            if (st.hasMoreTokens()) {
                timeto = st.nextToken();
                minto = st.nextToken();
            }
        }
        String timefrom2 = request.getParameter("timefrom");
        String minfrom2 = request.getParameter("minfrom");
        String timeto2 = request.getParameter("timeto");
        String minto2 = request.getParameter("minto");
        String stmin = "00";

        if (timefrom2 != null) 
		{
            timefrom = timefrom2;
        }
        if (minfrom2 != null) 
		{
            minfrom = minfrom2;
        }
        if (timeto2 != null) 
		{
            timeto = timeto2;
        }
        if (minto2 != null) 
		{
            minto = minto2;
        }

        if (sel_component != null) 
		{
            compList = Arrays.asList(sel_component);
        }
        boolean noDataFound = false;
        boolean noDataForVM = true;
        boolean dataForGPU = false;
        boolean isBackgroundProcess = false;
        boolean criteriaOnleFalg = false;
        if (resultMap != null && isSubmit != null && isSubmit.equalsIgnoreCase("true")) 
		{
            Boolean noData = ((Boolean) resultMap.get(NODATAFOUND));
            if (noData != null) 
			{
                noDataFound = noData.booleanValue();
            }
            noData = ((Boolean) resultMap.get(VMNODATA));
            if (noData != null) 
			{
                noDataForVM = noData.booleanValue();
            }
            noData = ((Boolean) resultMap.get(CRITERIAONLY));
            if (noData != null) 
			{
                criteriaOnleFalg = noData.booleanValue();
            }
            noData = ((Boolean) resultMap.get(GPUDATA));
            if (noData != null) 
			{
                dataForGPU = noData.booleanValue();
            }
        }
        v_options.add("Zone");
        v_options.add("Segment");
        v_options.add("Service");
        v_options.add("Component");

        if (er_option == null) 
		{
            er_option = (String) v_options.get(3);
        }

		rightSizingJson.put("er_option",er_option);
        //Back Button - Start
        HashMap backreqMap = (HashMap) session.getAttribute("backQuery");
        String backQnumber = request.getParameter("backQnumber");
        String servlet2 = request.getParameter("backServletName");

        ErHelperUtils erhelputils = null;
        if (servlet2 != null && !servlet2.equals("")) 
		{
            erhelputils = new ErHelperUtils(backreqMap, backQnumber, servlet2);
        }
		else
		{
            erhelputils = new ErHelperUtils(backreqMap, backQnumber);
        }
        boolean enableBack = erhelputils.isBackButtonEnable();

        String backButtonEnable = request.getParameter("back");
        if (backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True")) 
		{
            status = (String) request.getParameter("status");
            request.setAttribute("chartData", null);
            request.setAttribute("pdfData", null);
            bggroundStr = (String) request.getParameter("bggroundStr");
        }
		//Back Button - End
		// Added for CSV
        List list = new LinkedList(); //added for list data
        Vector v_measure_csv = new Vector(); //user column Name
        List list_data = new LinkedList(); //column data
        Hashtable h_tabrc = new Hashtable(); //subtable data
        Hashtable h_tab = new Hashtable();
        String s_title = "";
        // for component type 
        EgCrawler crawlerBean = new EgCrawler(new IniFile(s_iniFile_dir + "eg_topology.ini"));
        if (!StringUtils.isNull(er_option) && er_option.equals("Service")) 
		{
            v_service = erdata.getSites();
            Collections.sort(v_service, String.CASE_INSENSITIVE_ORDER);
            if (er_site != null && !er_site.equals("-1")) 
			{
                v_component = crawlerBean.getAssociates(er_site);
				Vector tempComponent = new Vector();
				tempComponent.addAll(v_component);
				v_component = new Vector();
				for (int i = 0; i < tempComponent.size(); i++) 
				{
					String loopComponent = (String) tempComponent.get(i);
					String loopType = loopComponent.substring(0, loopComponent.indexOf(":"));
					loopComponent = loopComponent.substring(loopComponent.indexOf(COLON) + 1) + COLON + loopType;
					if (listCompTypes.contains(loopType)) 
					{
						v_component.add(loopComponent);
					}
				}
				for (int i = 0; i < v_component.size(); i++) 
				{
					String loopComponent = (String) v_component.get(i);
					String loopType = loopComponent.substring(loopComponent.lastIndexOf(":") + 1);
					if (listCompTypes.contains(loopType) && !v_comptype.contains(loopType))
					{
						v_comptype.add(loopType);
					}
				}
				if (er_site != null && !er_site.equals("-1") && v_comptype != null && !v_comptype.isEmpty() && (s_comptype == null || s_comptype.equals("-1"))) 
				{
					Vector tempVector = compUtil.getIntnlSupportCompType(v_comptype, "#");
					Collections.sort(tempVector, String.CASE_INSENSITIVE_ORDER);
					String s = (String) tempVector.get(0);
					ArrayList aListData = tokInfo.egTokenizer(s, "#");
					String CompTypeDisp = (String) aListData.get(0);
					String CompTypeValue = (String) aListData.get(1);
					s_comptype = CompTypeValue;
				}
            }
			else
			{
				v_service=getFilteredSitesBeasedOnComponents(er_option,er_includeZones,listCompTypes,v_service,UBean,gpinfo,topoInfo, crawlerBean); 
			}
        } 
		else if (!StringUtils.isNull(er_option) && er_option.equals("Segment")) 
		{
            v_segment = erdata.getSegments();
            Collections.sort(v_segment, String.CASE_INSENSITIVE_ORDER);
            if (er_site != null && !er_site.equals("-1")) 
			{
                v_component = topoInfo.getAssociatesForSegment(er_site, 2);
                if (v_component == null) 
				{
                    v_component = new Vector();
                }
                Vector tempComponent = new Vector();
                tempComponent.addAll(v_component);
                v_component = new Vector();
                for (int i = 0; i < tempComponent.size(); i++) 
				{
                    String loopComponent = (String) tempComponent.get(i);
                    String loopType = loopComponent.substring(0, loopComponent.indexOf(COLON));
                    loopComponent = loopComponent.substring(loopComponent.indexOf(COLON) + 1) + COLON + loopType;
                    if (listCompTypes.contains(loopType)) 
					{
                        v_component.add(loopComponent);
                    }
                }
                for (int i = 0; i < v_component.size(); i++) 
				{
                    String loopComponent = (String) v_component.get(i);
                    String loopType = loopComponent.substring(loopComponent.lastIndexOf(COLON) + 1);
                    if (listCompTypes.contains(loopType) && !v_comptype.contains(loopType)) 
					{
                        v_comptype.add(loopType);
                    }
                }
                if (!er_site.equals("-1") && !v_comptype.isEmpty() && (s_comptype == null || s_comptype.equals("-1"))) 
				{
                    s_comptype = (String) v_comptype.get(0);
                    Vector tempVector = compUtil.getIntnlSupportCompType(v_comptype, "#");
                    Collections.sort(tempVector, String.CASE_INSENSITIVE_ORDER);
                    String s = (String) tempVector.get(0);
                    ArrayList aListData = tokInfo.egTokenizer(s, "#");
                    String CompTypeDisp = (String) aListData.get(0);
                    String CompTypeValue = (String) aListData.get(1);
                    s_comptype = CompTypeValue;
                }
            }
			else
			{
				v_segment=getFilteredSitesBeasedOnComponents(er_option,er_includeZones,listCompTypes,v_segment,UBean,gpinfo,topoInfo, crawlerBean); 
			}
        } 
		else if (!StringUtils.isNull(er_option) && er_option.equals("Zone"))
		{
			if (er_includeZones == null) 
			{
				er_includeZones = "yes";
			}
			v_zones.add("--Default--");
			if (this_user.getZones() != null) 
			{
				v_zones.addAll(this_user.getZones());
			}
            Collections.sort(v_zones, String.CASE_INSENSITIVE_ORDER);
            if (er_site != null && !er_site.equals("-1")) 
			{
                if (er_site.equalsIgnoreCase("--Default--")) 
				{
                    v_component = UBean.getAllUserComponents(3);
                    for (int i = 0; i < v_zones.size(); i++)
					{
                        List v_temp = gpinfo.getAllComponentsUnderZone((String) v_zones.get(i), er_includeZones.equalsIgnoreCase("yes"));
                        Vector tempVector = new Vector();
                        for (int k = 0; k < v_temp.size(); k++) 
						{
                            String tempStr = (String) v_temp.get(k);
                            tempStr = tempStr.substring(tempStr.indexOf(COLON) + 1) + COLON + tempStr.substring(0, tempStr.indexOf(COLON));
                            tempVector.add(tempStr);
                        }
                        v_component.removeAll(tempVector);
                    }
                } 
				else 
				{
                    v_component.addAll(gpinfo.getAllComponentsUnderZone(er_site, er_includeZones.equalsIgnoreCase("yes")));
                    Vector tempComponent = new Vector();
                    tempComponent.addAll(v_component);
                    v_component = new Vector();
                    for (int j = 0; j < tempComponent.size(); j++) 
					{
                        String tempStr = (String) tempComponent.get(j);
                        tempStr = tempStr.substring(tempStr.indexOf(COLON) + 1) + COLON + tempStr.substring(0, tempStr.indexOf(COLON));
                        v_component.add(tempStr);
                    }
                }
				for (int i = 0; i < v_component.size(); i++) 
				{
                    String loopComponent = (String) v_component.get(i);
                    String loopType = loopComponent.substring(loopComponent.lastIndexOf(COLON) + 1);
                    if (listCompTypes.contains(loopType) && !v_comptype.contains(loopType)) 
					{
                        v_comptype.add(loopType);
                    }
                }
				if(v_comptype!=null && v_comptype.size()==0)
				{
				  v_component = new Vector();
				}
				if ((s_comptype == null || s_comptype.equals("-1")) && !v_comptype.isEmpty()) 
				{
					Collections.sort(v_comptype, String.CASE_INSENSITIVE_ORDER);
					s_comptype = (String) v_comptype.get(0);
					Vector tempVector = compUtil.getIntnlSupportCompType(v_comptype, "#");
					Collections.sort(tempVector, String.CASE_INSENSITIVE_ORDER);
					String s = (String) tempVector.get(0);
					ArrayList aListData = tokInfo.egTokenizer(s, "#");
					String CompTypeDisp = (String) aListData.get(0);
					String CompTypeValue = (String) aListData.get(1);
					s_comptype = CompTypeValue;
				}
				Vector tempComponent = new Vector();
				tempComponent.addAll(v_component);
				for (int i = 0; i < tempComponent.size(); i++) {
					String loopComponent = (String) tempComponent.get(i);
					String loopType = loopComponent.substring(loopComponent.lastIndexOf(":") + 1);
					if (!listCompTypes.contains(loopType) && !s_comptype.equals(loopType)) 
					{
						v_component.remove(loopComponent);
					}
				}
				//System.out.println("v_component	---------------	"+v_component);
			}
			else
			{
				v_zones=getFilteredSitesBeasedOnComponents(er_option,er_includeZones,listCompTypes,v_zones,UBean,gpinfo,topoInfo,crawlerBean); 				
			}
        }
		else
		{
            temp_component = UBean.getAllUserComponents(3);
            List compTypes = this_user.getAllServerType();
            if (compTypes.size() > 0) 
			{
                Vector tempComptype = new Vector();
                tempComptype.addAll(compTypes);
                tempComptype.remove("Host_system");
                for (int i = 0; i < tempComptype.size(); i++) 
				{
                    String tempStr = (String) tempComptype.get(i);
                    if (listCompTypes.contains(tempStr)) 
					{
                        v_comptype.add(tempStr);
                    }
                }

                if (!v_comptype.isEmpty() && s_comptype == null) 
				{
                    s_comptype = (String) v_comptype.get(0);
                    Vector tempVector = compUtil.getIntnlSupportCompType(v_comptype, "#");
                    Collections.sort(tempVector, String.CASE_INSENSITIVE_ORDER);
                    String s = (String) tempVector.get(0);
                    ArrayList aListData = tokInfo.egTokenizer(s, "#");
                    String CompTypeDisp = (String) aListData.get(0);
                    String CompTypeValue = (String) aListData.get(1);
                    s_comptype = CompTypeValue;
                }
            }
        }

        if (s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable") && (v_comptype.contains(s_comptype))) 
		{
            if (!s_comptype.equals("Host_system")) {
                List removeList = new ArrayList();
                for (int i = 0; i < temp_component.size(); i++) 
				{
                    String v_comp = (String) temp_component.get(i);
                    if (-1 == v_comp.indexOf(s_comptype)) 
					{
                        removeList.add(v_comp);
                    }
                }
                temp_component.removeAll(removeList);
            }
            for (int i = 0; i < temp_component.size(); i++) 
			{
                String tempComp = (String) temp_component.get(i);
                String componentName = tempComp.substring(0, tempComp.indexOf(":"));
                if (!v_componentName.contains(componentName))
				{
                    v_componentName.add(componentName);
                    v_component.add(tempComp);
                }
            }

        }
        // for removing aggregates starts
        List rList = new ArrayList();
        for (int j = 0; j < v_comptype.size(); j++) 
		{
            String tempStr = (String) v_comptype.get(j);
            if (tempStr.startsWith("Agg_")) 
			{
                rList.add(tempStr);
            }
        }
        v_comptype.removeAll(rList);//removing Aggregate component types
        rList = new ArrayList();
        for (int i = 0; i < v_component.size(); i++) 
		{
            String v_comp = (String) v_component.get(i);
            String temp = v_comp.substring(v_comp.lastIndexOf(":") + 1);
            if (!(temp.equals(s_comptype)) || temp.startsWith("Agg_"))
			{
				rList.add(v_comp);
            }
        }
        v_component.removeAll(rList);//removing Aggregate components
        // for removing aggregates ends
        if (er_timeline != null && !er_timeline.equals("Any")) 
		{
            int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
            if (blankSpaceIndex > 0) 
			{
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
                java.util.Date today = egDt.egetRealDate();
                endDateTime = sdf.format(today);

                long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
                String unit = er_timeline.substring(blankSpaceIndex + 1).toLowerCase();
                if (unit.startsWith("h")) 
				{	//hours
                    value *= 3600;
                } 
				else if (unit.startsWith("d")) 
				{	//days
                    value *= (24 * 3600);
                }
				else if (unit.startsWith("w")) 
				{	//weeks
                    value *= (7 * 24 * 3600);
                } 
				else if (unit.startsWith("mo")) 
				{	//months
                    java.util.Date dt_temp = egDt.egetRealDate();
                    Calendar cal_temp = new GregorianCalendar();
                    cal_temp.setTime(dt_temp);
                    cal_temp.add(Calendar.HOUR_OF_DAY, 0);
                    java.util.Date dt_temp1 = cal_temp.getTime();
                    long l_temp = dt_temp1.getTime();
                    int totalDays = 24 * (erUtils.getMaxDaysInMonth());
                    startDateTime = egDt.egetDate(l_temp - (long) ((value * totalDays * msecsPerHour)));
                    startDateTime = DateUtil.changeDateFormat(startDateTime, "dd/MM/yyyy HH:mm", "MM/dd/yyyy HH:mm");
                }
                if (unit != null && !unit.startsWith("mo")) 
				{
                    java.util.Date start = new java.util.Date();
                    java.util.Date startTmp = new java.util.Date(endDateTime);
                    start.setTime(startTmp.getTime() - (value * 1000));
                    startDateTime = sdf.format(start);
                }
            }
            if ((startDateTime != null) && (endDateTime != null)) 
			{
                s_inidate = "MM/dd/yyyy";
                try 
				{
                    int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE) + 1, startDateTime.indexOf(COLON)));
                    strmin = startDateTime.substring(startDateTime.indexOf(COLON) + 1);
                    int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE) + 1, endDateTime.indexOf(COLON)));
                    enmin = endDateTime.substring(endDateTime.indexOf(COLON) + 1);
                    s_en_time = endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
                    s_st_time = startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
                    s_st_hr = String.valueOf(shr);
                    s_en_hr = String.valueOf(en_hr);
                }
				catch (Exception e) 
				{
                    System.out.println("Eception caught :" + e);
                    e.printStackTrace();
                }
            }
        }
        if (er_timeline != null && !er_timeline.equals("Any")) 
		{
            disable = "disabled";
        }
        if (er_timeline != null && er_timeline.equals("Any")) 
		{
            String StrDate = "";
            try 
			{
                java.text.SimpleDateFormat df = new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
                StrDate = df.format(new java.util.Date());
            }
			catch (Exception ee) 
			{
                System.out.println("Exception is" + ee);
            }
            String SDate = StrDate.substring(0, StrDate.indexOf(" "));
            String shour = StrDate.substring(StrDate.indexOf(" "), StrDate.lastIndexOf(""));
            shour = shour.substring(0, 3);
            if (s_st_time == null) 
			{
                s_st_time = SDate;
                s_inidate = "MM/dd/yyyy";
            }
            if (s_en_time == null) 
			{
                s_en_time = SDate;
            }
            if (s_st_hr == null) 
			{
                shour = shour.trim();
                int starthr = Integer.parseInt(shour);
                starthr = starthr - 1;
                s_st_hr = String.valueOf(starthr);
            }
            if (s_en_hr == null) 
			{
                shour = shour.trim();
                s_en_hr = shour;
            }
        }
       //------------hiddenFields-----------
       // hiddenFields.put("starthr", s_st_hr);
       // hiddenFields.put("startdate", request.getParameter("startdate"));
       // hiddenFields.put("enddate", request.getParameter("enddate"));
       // hiddenFields.put("endhr", s_en_hr);
       // hiddenFields.put("startmin", strmin);
       // hiddenFields.put("endmin", enmin);
        hiddenFields.put("bgenabled", strbgrepportName);
        hiddenFields.put("eruserid", userid);
        hiddenFields.put("limitforbg", limitforbg);
        hiddenFields.put("fromSchedule", reqFromSchedule);
       // hiddenFields.put("divStatus", divStatus);
        hiddenFields.put("schedule_id", schedule_id);
        hiddenFields.put("er_rtype", "Virtual Machine");
        hiddenFields.put("er_trgttype", "VM Right Sizing");
        hiddenFields.put("isFavorite", "false");
        hiddenFields.put("isSchedule", "false");
        hiddenFields.put("er_ViewName", "ErVMRightSizingReport.jsp");
        hiddenFields.put("forwardto", "ErVMRightSizingReportJSON");
        hiddenFields.put("er_bgreportfrom", "VM_Right_Sizing");
        hiddenFields.put("savereport", "save");
        hiddenFields.put("inidate", currentDateFormat);
        hiddenFields.put("getMaxDaysInMonth", erUtils.getMaxDaysInMonth());
        // rightSizingJson.put("hiddenFields",hiddenFields);
		hiddenFields.put("savereport","save");
		if(fromScheduleModify!=null)
			hiddenFields.put("fromScheduleModify",fromScheduleModify);
		else
			hiddenFields.put("fromScheduleModify","null");
		if(fromFavoriteModify!=null)
			hiddenFields.put("fromFavoriteModify",fromFavoriteModify);
		else
			hiddenFields.put("fromFavoriteModify","null");
		hiddenFields.put("favorite_id", favorite_id);
		hiddenFields.put("er_favorite", er_favorite);


		displayLabels.put("reportTitle", intlmap.getTextDescription("reporter.common.VM RIGHT SIZING REPORT"));
		String strWidth = "90%";
		if (backreqMap == null || backreqMap != null && backreqMap.size() == 0) 
		{
			strWidth = "100%";
		}
		String fromFavSch = request.getParameter("fromFavSch");
		if (backreqMap != null && backreqMap.size() > 0 && enableBack && request.getParameter("enableBack") != null && request.getParameter("enableBack").equalsIgnoreCase("true") || (fromFavSch != null && fromFavSch.equalsIgnoreCase("true"))) 
		{
			
			rightSizingJson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
		}
		//--------------not applicable combo---------
	   /* JSONArray notApplicableArray = new JSONArray();
		JSONObject notApplicableObject = new JSONObject();
		notApplicableObject.put("displayField", intlmap.getTextDescription("reporter.common.Not Applicable"));
		notApplicableObject.put("valueField", "-1");
		notApplicableArray.add(notApplicableObject);
		rightSizingJson.put("notApplicableCombo", notApplicableArray);	  */

		//--------------analyze by combo-------------
		JSONArray analyzeByArray = new JSONArray();
		JSONObject analyzeByObject;
		displayLabels.put("analyzeByComboLabel", intlmap.getTextDescription("reporter.common.Analyze by"));
		idFields.put("analyzeByComboId", "er_option");

		String selected = "";
		for (int i = 0; i < v_options.size(); i++)
		{
			analyzeByObject = new JSONObject();
			String tempStr = (String) v_options.get(i);
			analyzeByObject.put("displayField", tempStr);
			analyzeByObject.put("valueField", tempStr);
			analyzeByArray.add(analyzeByObject);
			if (er_option.equals(tempStr)) 
			{
				selectedFields.put("analyzeByComboSelected", er_option);
				 selectionDetails.put(intlmap.getTextDescription("reporter.common.Analyze by"),intlmap.getTextDescription("reporter.common."+er_option));
				selected = "selected";
			}
			else 
			{
				selected = "";
			}
		}
		rightSizingJson.put("analyzeByCombo", analyzeByArray);

		if (!er_option.equals("Component")) 
		{
			if (er_option.equals("Segment")) 
			{
				//-----------------segemnt combo------------------------
				JSONArray segmentArray = new JSONArray();
				JSONObject segmentObject;
				idFields.put("segmentComboId", "er_site");
				displayLabels.put("segmentComboLabel", intlmap.getTextDescription("reporter.common.Segment"));

				if (v_segment.size() > 0) 
				{
					segmentObject = new JSONObject();
					segmentObject.put("displayField", intlmap.getTextDescription("reporter.common.Please select a Segment"));
					segmentObject.put("valueField", "-1");
					segmentArray.add(segmentObject);
					for (int i = 0; i < v_segment.size(); i++) 
					{
						String tempStr = (String) v_segment.get(i);
						segmentObject = new JSONObject();
						segmentObject.put("displayField", tempStr);
						segmentObject.put("valueField", tempStr);
						segmentArray.add(segmentObject);
						if (tempStr.equalsIgnoreCase(er_site)) 
						{
							selectedFields.put("segmentComboSelected", er_site);
							selectionDetails.put(intlmap.getTextDescription("reporter.common.Segment"),intlmap.getTextDescription("reporter.common."+er_site));
						} 
					}
				}
				else
				{
					segmentObject = new JSONObject();
					segmentObject.put("displayField", intlmap.getTextDescription("reporter.common.Not Apllicable"));
					segmentObject.put("valueField", "-1");
					segmentArray.add(segmentObject);
				}
				 rightSizingJson.put("segmentCombo", segmentArray);
			} 
			else if (er_option.equals("Service")) 
			{
				//-----------------service combo----------------------	

				JSONArray serviceArray = new JSONArray();
				JSONObject serviceObject;
				idFields.put("serviceComboId", "er_site");
				displayLabels.put("serviceComboLabel", intlmap.getTextDescription("reporter.common.Service"));

				if (v_service.size() > 0) 
				{
					serviceObject = new JSONObject();
					serviceObject.put("displayField", intlmap.getTextDescription("reporter.common.Please select a Service"));
					serviceObject.put("valueField", "-1");
					serviceArray.add(serviceObject);


					for (int i = 0; i < v_service.size(); i++) 
					{
						String tempStr = (String) v_service.get(i);
						serviceObject = new JSONObject();
						serviceObject.put("displayField", tempStr);
						serviceObject.put("valueField", tempStr);
						serviceArray.add(serviceObject);
						if (tempStr.equalsIgnoreCase(er_site)) 
						{
							selectedFields.put("serviceComboSelected", er_site);
							selectionDetails.put(intlmap.getTextDescription("reporter.common.Service"),intlmap.getTextDescription("reporter.common."+er_site));
						} 
					}
					rightSizingJson.put("serviceCombo", serviceArray);
				}
			} 
			else if (er_option.equals("Zone")) 
			{
				//--------------subzone combo----------
				JSONArray subZoneArray = new JSONArray();
				JSONObject subZoneObject;//=new JSONObject();
				idFields.put("subZoneComboId", "er_includezones");
				displayLabels.put("subZoneComboLabel", intlmap.getTextDescription("reporter.common.Include Subzone"));
				subZoneObject = new JSONObject();
				subZoneObject.put("displayField", intlmap.getTextDescription("reporter.common.No"));
				subZoneObject.put("valueField", "no");
				subZoneArray.add(subZoneObject);
				subZoneObject = new JSONObject();
				subZoneObject.put("displayField", intlmap.getTextDescription("reporter.common.Yes"));
				subZoneObject.put("valueField", "yes");
				subZoneArray.add(subZoneObject);
				rightSizingJson.put("subZoneCombo", subZoneArray);

				//-------------zone combo----------
				JSONArray zoneArray = new JSONArray();
				JSONObject zoneObject;//=new JSONObject();
				idFields.put("zoneComboId", "er_site");
				displayLabels.put("zoneComboLabel", intlmap.getTextDescription("reporter.common.Zone"));

				if (v_zones.size() > 0) 
				{
					zoneObject = new JSONObject();
					zoneObject.put("displayField", intlmap.getTextDescription("reporter.common.Please select a Zone"));
					zoneObject.put("valueField", "-1");
					zoneArray.add(zoneObject);

					for (int i = 0; i < v_zones.size(); i++) 
					{

						String tempStr = (String) v_zones.get(i);
						zoneObject = new JSONObject();
						zoneObject.put("displayField", tempStr);
						zoneObject.put("valueField", tempStr);
						zoneArray.add(zoneObject);
						if (tempStr.equalsIgnoreCase(er_site)) 
						{
							selectedFields.put("zoneComboSelected", er_site);
							selectionDetails.put(intlmap.getTextDescription("reporter.common.Zone"),intlmap.getTextDescription("reporter.common."+er_site));
						} 
					}
					rightSizingJson.put("zoneCombo", zoneArray);
				} 
				if (er_includeZones.equals("yes")) 
				{
					selectedFields.put("subZoneComboSelected", "yes");
				}
				else 
				{
					selectedFields.put("subZoneComboSelected", "no");
				}
			}
		}
		v_comptype = compUtil.getIntnlSupportCompType(v_comptype, "#");

		JSONArray componentTypeArray = new JSONArray();
		JSONObject componentTypeObject;//=new JSONObject();
		idFields.put("componentTypeComboId", "er_comptype");
		displayLabels.put("componentTypeComboLabel", intlmap.getTextDescription("reporter.common.Component Type"));

		if (v_comptype.size() > 0) 
		{
			selected = "";
			for (int i = 0; i < v_comptype.size(); i++) 
			{
				String s = (String) v_comptype.get(i);
				ArrayList aListData = tokInfo.egTokenizer(s, "#");
				String CompTypeDisp = (String) aListData.get(0);
				String CompTypeValue = (String) aListData.get(1);
				componentTypeObject = new JSONObject();
				componentTypeObject.put("displayField", CompTypeDisp);
				componentTypeObject.put("valueField", CompTypeValue);
				componentTypeArray.add(componentTypeObject);
				if (!StringUtils.isNull(CompTypeValue) && CompTypeValue.equalsIgnoreCase(s_comptype)) 
				{
					selectedFields.put("componentTypeComboSelected", CompTypeValue);
					rightSizingJson.put("selectionDetailstitle",intlmap.getTextDescription("reporter.common.Selection Details for")+" "+intlmap.getComponentTypeDescription(CompTypeValue));

					//selectionDetails.put(intlmap.getTextDescription("reporter.common.Component Type"),intlmap.getTextDescription("reporter.common."+CompTypeValue));
				} 
			}
		} 
		else
		{
			componentTypeObject = new JSONObject();
			componentTypeObject.put("displayField", intlmap.getTextDescription("reporter.common.Not Applicable"));
			componentTypeObject.put("valueField", "-1");
			componentTypeArray.add(componentTypeObject);
		}
		rightSizingJson.put("componentTypeCombo", componentTypeArray);

		JSONArray componentArray = new JSONArray();
		JSONObject componentObject;//=new JSONObject();
		idFields.put("componentComboId", "er_component");
		displayLabels.put("componentComboLabel", intlmap.getTextDescription("reporter.common.Component"));

		if (v_component.size() > 0) 
		{
			ArrayList sortedNameList1 = new ArrayList();
			sortedNameList1 = sorter.getSortedCompTypeList(v_component);
			for(int n=0;n<sortedNameList1.size();n++)
			{
				EgName nameObj =(EgName) sortedNameList1.get(n);
				String dispValue = nameObj.getLocalName();
				String sCompType = nameObj.getActualName();
				String tempStr = (String) v_component.get(n);
				String tempDisplay = sCompType.substring(0, sCompType.indexOf(":"));
				v_comp_popup.add(sCompType);
				v_comp_popup_disp.add(tempDisplay);
				componentObject = new JSONObject();
				componentObject.put("displayField", tempDisplay);
				componentObject.put("valueField", sCompType);
				componentArray.add(componentObject); 
			}
			if(compList!=null && compList.size()>0)
			{
				StringBuffer sb=new StringBuffer();
				for(int i=0;i<compList.size();i++)
				{
					sb.append(compList.get(i)).append(",");
				}
				if(sb.length()>0)
				{
					sb.deleteCharAt(sb.length()-1);
					selectedFields.put("componentComboSelected", sb.toString());
				}
			}
		} 
		else
		{
			componentObject = new JSONObject();
			componentObject.put("displayField", intlmap.getTextDescription("reporter.common.Not Applicable"));
			componentObject.put("valueField", "-1");
			componentArray.add(componentObject);   
			selectedFields.put("componentComboSelected", "-1");
		}
		rightSizingJson.put("componentCombo", componentArray);

		for (int n = 0; n < v_comp_popup.size(); n++) 
		{
			String s = (String) v_comp_popup.get(n);
			String ss = (String) v_comp_popup_disp.get(n);
		}
		//----------------------criterion- combo------------------
		JSONArray criterionArray = new JSONArray();
		JSONArray criterionInfoArray = new JSONArray();
		JSONObject criterionObject;//=new JSONObject();
		idFields.put("criterionComboId", "er_criteria");
		idFields.put("criterionInfoComboId", "er_criteriaInfo");
		displayLabels.put("criterionComboLabel", intlmap.getTextDescription("reporter.common.Criteria"));
		displayLabels.put("criterionInfoComboLabel", intlmap.getTextDescription("reporter.common.Metric"));

		for (int i = 0; i < utilizationList.size(); i++) 
		{
			String tempStr = (String) utilizationList.get(i);
			criterionObject = new JSONObject();
			criterionObject.put("displayField", tempStr);
			criterionObject.put("valueField", tempStr);
			criterionArray.add(criterionObject);
			selected = "";
			if (tempStr.equalsIgnoreCase(er_criteria)) 
			{
				selected = "selected";
				selectionDetails.put(intlmap.getTextDescription("reporter.common.Criteria"),intlmap.getTextDescription("reporter.common."+tempStr));
				 selectedFields.put("criterionComboSelected", tempStr);
			}
		}
		for (int i = 0; i < criteriaList.size(); i++) 
		{
			String tempStr = (String) criteriaList.get(i);
			criterionObject = new JSONObject();
			criterionObject.put("displayField", tempStr);
			criterionObject.put("valueField", tempStr);
			criterionInfoArray.add(criterionObject);
			selected = "";
			if (tempStr.equalsIgnoreCase(er_criteriaInfo)) 
			{
				selected = "selected";
				selectionDetails.put(intlmap.getTextDescription("reporter.common.Metric"),intlmap.getTextDescription("reporter.common."+tempStr));
				 selectedFields.put("criterionInfoComboSelected", tempStr);
			}
		}
		rightSizingJson.put("criterionCombo", criterionArray);
		rightSizingJson.put("criterionInfoCombo", criterionInfoArray);

		JSONArray vmArray = new JSONArray();
		JSONObject vmObject;//=new JSONObject();
		idFields.put("vmComboId", "er_criteriaOnly");
		displayLabels.put("vmComboLabel", intlmap.getTextDescription("reporter.common.Show Matching VMs Only"));

		vmObject = new JSONObject();
		vmObject.put("displayField", intlmap.getTextDescription("reporter.common.No"));
		vmObject.put("valueField", "no");
		vmArray.add(vmObject);
		vmObject = new JSONObject();
		vmObject.put("displayField", intlmap.getTextDescription("reporter.common.Yes"));
		vmObject.put("valueField", "yes");
		vmArray.add(vmObject);
		rightSizingJson.put("vmCombo", vmArray);

		if (er_criteriaonly != null && er_criteriaonly.equalsIgnoreCase("yes")) 
		{
			selectedFields.put("vmComboSelected", "yes");
		}
		else
		{
			selectedFields.put("vmComboSelected", "no");
		}


/*******************************************************************************
* File name : ErTimeFormat.jsp
* Purpose   : Time Control to be used thorugh out Reporter.
* Version   : Reporter 4.0
*******************************************************************************/


	JSONArray timelineComboArray=new JSONArray();
	JSONArray timelineHourComboArray=new JSONArray();
	String startDateJSON="";
	String endDateJSON="";
	String startHourJSON="";
	String endHourJSON="";
	String selectedGraphMode="";
	String startDateForHighchart=null;
	String endDateForHighchart=null;
	String chartTypeForUI=null;
	
	User userName = UserRegistry.getInstance().getUser(session.getId());
	ErReportHelper er_rpthelper = new ErReportHelper();
	EgReportInfo rptInfo = new EgReportInfo("manager");
	EgMappingInfo mappingObj = new EgMappingInfo(thisuser.getLanguage());
	String reqOption = request.getParameter("option");
	String deftimeline = rptInfo.getDefaultTimeLine("MISC","MaxTimeline");
	List alist = Arrays.asList(options);
	String loginName = userName.getLoginID();
	int len;
	String strUsrTimeline = er_rpthelper.getUserTimeline(loginName);
	//String[] lstWeeksArr = new String[]{"Last week", "Last 2 weeks", "Last 3 weeks", "Last 4 weeks", "Last month"};	
	String[] lstWeeksArr = new String[]{"Last week", "Last month"};	
	if(strUsrTimeline != null && !strUsrTimeline.equalsIgnoreCase("-1"))
	{
		len = alist.indexOf(strUsrTimeline)+1;
	}
	else
	{
		len = options.length;
	}
		
	if (reqOption!=null && reqOption.equalsIgnoreCase("Citrix"))
	{
		if(deftimeline !=null && !deftimeline.equals("-1"))
		{
			if(len > alist.indexOf(deftimeline)+1)
			{
				len=alist.indexOf(deftimeline)+1;
			}
			if (len >0)
				strUsrTimeline = (String)alist.get(len-1);
			else
				strUsrTimeline = (String)alist.get(len);
		}

	}
	if(len == 0)
		len = options.length;
	String grophmodeon = request.getParameter("grophmodeon");
	String r_type = request.getParameter("er_type");
	String reporttype = request.getParameter("reporttype");
	String er_rtype = request.getParameter("er_rtype");
	String er_rtype_proc = request.getParameter("er_rtype_proc");
	String timeformat_trend = request.getParameter("er_trenddata");
	if (timeformat_trend == null || timeformat_trend ==" " )
		timeformat_trend = "No";

	if (reporttype==null || reporttype.equalsIgnoreCase("null"))
	{
		if (er_rtype!=null && er_rtype.equalsIgnoreCase("macro"))
		{
			reporttype="executive";
		} else if (er_rtype!=null && ( er_rtype.equalsIgnoreCase("application") || er_rtype.equalsIgnoreCase("network") 
		|| er_rtype.equalsIgnoreCase("site") || er_rtype.equalsIgnoreCase("system") ||  er_rtype.equalsIgnoreCase("Event") ) )
		{
			reporttype="operation";
		}

	}

	String colum="";
	if(reporttype!=null &&reporttype.equalsIgnoreCase("executive"))
		colum="9";
	else
		colum="6";
	String er_gtype=request.getParameter("er_gtype");

	java.util.Date start = egDt.egetRealDate();
	String startMin = Integer.toString(start.getMinutes());
	String endMin = Integer.toString(start.getMinutes());
	String strsmin_11=request.getParameter("startmin");
	String etrsmin_11=request.getParameter("endmin");
	if(strsmin_11 != null && strsmin_11.length()>0)
		startMin = strsmin_11;
	if(etrsmin_11 != null && etrsmin_11.length()>0)
		endMin = etrsmin_11;

	EgTimeZoneConverter timeZoneConverterStart = null;
	EgTimeZoneConverter timeZoneConverterEnd = null;
	String startDateForDisplay = null;
	String startHourForDisplay = null;
	String endDateForDisplay = null;
	String endHourForDisplay = null;
	String startMinForDisplay = null;
	String endMinForDisplay = null;
	for(int e_ctr=0; e_ctr<len; e_ctr++)
	{
		String s_timeline=options[e_ctr];
		if(s_timeline.equalsIgnoreCase("Any"))
		{
			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",mappingObj.getTextDescription("reporter.common."+s_timeline));
			timelineJSON.put("valueField", s_timeline);
			timelineComboArray.add( timelineJSON );
		}else if(s_timeline.contains("Last")){
			String displayField=null;
			String viewField=null;
			displayField = s_timeline;
			int spaceNum = 0;
			for(int i=0; i<s_timeline.length();i++){
				char ch = s_timeline.charAt(i);
				if(ch== ' '){
				   spaceNum++; 
				}
			}
			if(spaceNum > 2){
				String countStr = s_timeline.substring(s_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = s_timeline.substring(s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,s_timeline.length());
				String last = s_timeline.substring(0, s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr + end + "_" + last;				
			}else{
				viewField = "1 "+s_timeline.substring(s_timeline.lastIndexOf(" ")+1, s_timeline.length())  + "_" + s_timeline.substring(0, s_timeline.indexOf(" "));				
			}
			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",displayField);
			timelineJSON.put("valueField", viewField.toLowerCase());
			timelineComboArray.add( timelineJSON );			
		}
		else
		{
			String numstr = s_timeline.substring(0,s_timeline.indexOf(" "));
			String strextra = s_timeline.substring(s_timeline.indexOf(" ")+1);

			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",numstr+" "+ mappingObj.getTextDescription("reporter.common."+strextra));
			timelineJSON.put("valueField", s_timeline);
			timelineComboArray.add( timelineJSON );
		}

		/*if(er_timeline!=null && er_timeline.equals((String)options[e_ctr]))
		{
			if(er_timeline.equalsIgnoreCase("Any"))
			{
				String strer_timeline="reporter.common."+er_timeline;

			}
			else
			{
				String numstr = er_timeline.substring(0,er_timeline.indexOf(" "));
				String strextra = er_timeline.substring(er_timeline.indexOf(" ")+1);
				String str_strextra="reporter.common."+strextra;
			}
		}
		else
		{
			if(options[e_ctr].equalsIgnoreCase("Any"))
			{
				String  str_options="reporter.common."+options[e_ctr];
			}
			else
			{
				String numstr = options[e_ctr].substring(0,options[e_ctr].indexOf(" "));
				String strextra = options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);
				//FIX FOR SUPPORT TOMCAT 6.0
				String str_extra= "reporter.common."+strextra;
			}
		}*/
	} 

	List lastDataList = new ArrayList();
	JSONArray lastDataJSON = null;
	int lastWeekCount = 1;		
	if(isLastTimeLine){
		if(strUsrTimeline.equals("-1")){
			for(int i=0;i<lstWeeksArr.length;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 week")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("2 weeks")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("3 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("4 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 month")){
			lastWeekCount = 2;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);			
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}		
		}	
	}
	
	String isVmReport = request.getParameter("isVmReport");
	if(er_timeline!=null && !er_timeline.equals("Any"))
	{
		/*if (isVmReport != null && isVmReport.equals("Yes"))
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		}
		else*/
	
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			
			
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat); 
	}
	else
	{
	
		if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
		{
			comFormat = currentDateFormat;
		}
		else
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		}
		dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		
		
		//dispDate = s_st_time;
	}
	if (timeformat_trend!=null && timeformat_trend.equals("Yes")&& er_timeline!=null && !er_timeline.equals("Any")) {
		
		s_st_hr="00";
		startMin="00";
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			//User Zone Start //User Zone Start time
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			startDateForDisplay = userTimeZoneList.get(0);
			startHourForDisplay = "00";
			startMinForDisplay = "00";
			
			timeZoneConverterStart = new EgTimeZoneConverter(startDateForDisplay + " "+ startHourForDisplay + ":" + startMinForDisplay, userName, true);
			startDateJSON = (String) timeZoneConverterStart.getDate(false);
			startHourJSON = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();

			startDateForHighchart = startDateJSON + " " + startHourJSON + ":" + startMin;	
		}else{
			timeZoneConverterStart = new EgTimeZoneConverter(dispDate + " "+ s_st_hr + ":" + startMin, userName,true); 
			startDateForHighchart=dispDate + " "+ s_st_hr + ":" + startMin; 
			
			startDateForDisplay = dispDate;
			startHourForDisplay = s_st_hr;
			startMinForDisplay = startMin;

			dispDate=(String) timeZoneConverterStart.getDate(false);
			s_st_time=dispDate;
			startDateJSON=dispDate;
			s_st_hr = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();
		}
		
	} else { 
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			//User Zone Start time
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			startDateForDisplay = userTimeZoneList.get(0);
			startHourForDisplay = "00";
			startMinForDisplay = "00";
			
			timeZoneConverterStart = new EgTimeZoneConverter(startDateForDisplay + " "+ startHourForDisplay + ":" + startMinForDisplay, userName, true);
			startDateJSON = (String) timeZoneConverterStart.getDate(false);
			startHourJSON = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();

			startDateForHighchart = startDateJSON + " " + startHourJSON + ":" + startMin;			
		}else{
			timeZoneConverterStart = new EgTimeZoneConverter(dispDate + " "+ s_st_hr + ":" + startMin, userName);
	 
			startDateForHighchart=dispDate + " "+ s_st_hr + ":" +startMin; 
			startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
			startHourForDisplay = timeZoneConverterStart.getHour();
			s_st_hr = s_st_hr.trim();
			startMinForDisplay = timeZoneConverterStart.getMinute();
			startDateJSON=dispDate;			
		}
		
	}
 	/*if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
	}
	else
	{
		dispDate = s_st_time;
	}*/
	
 

	for(int s_ctr=0; s_ctr<24; s_ctr++)
	{
		s_st_hr = s_st_hr.trim();
		if(!er_timeline.endsWith("last"))
			startHourJSON=s_st_hr;
		JSONObject timelineHourJSON = new JSONObject();
		timelineHourJSON.put("displayField",String.valueOf(s_ctr));
		timelineHourJSON.put("valueField",String.valueOf(s_ctr));
		timelineHourComboArray.add( timelineHourJSON );
	}

	
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if (isVmReport != null && isVmReport.equals("Yes"))
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			//comFormat = currentDateFormat;
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
		else
		{
			if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
			{
				comFormat = currentDateFormat;
			}
			else
			{
				if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
			}
			//comFormat = currentDateFormat;
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
	}
	else
	{
		if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
		{
			comFormat = currentDateFormat;
		}
		else
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		}
		//comFormat = currentDateFormat;
		dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat); 
	}

	if (timeformat_trend!=null && timeformat_trend.equals("Yes") && er_timeline!=null && !er_timeline.equals("Any")) {
		s_en_hr="00";
		endMin="00";
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			
			endDateForDisplay = userTimeZoneList.get(1);			
			endHourForDisplay = "23";			
			endMinForDisplay = "59";
										
			timeZoneConverterEnd = new EgTimeZoneConverter(endDateForDisplay + " "+ endHourForDisplay + ":" + endMinForDisplay, userName, true);
	
			endDateJSON=(String) timeZoneConverterEnd.getDate(false);
			endHourJSON=timeZoneConverterEnd.getHour();
			endMin = timeZoneConverterEnd.getMinute(); 
			endDateForHighchart=endDateJSON + " "+ endHourJSON + ":" + endMin;
			System.out.println("1Manager Start Time-->"+startDateForHighchart);
			System.out.println("1Manager Start Hour-->"+startHourJSON);
			System.out.println("1Manager End Time--->"+endDateForHighchart);		

		}else{
			timeZoneConverterEnd = new EgTimeZoneConverter(dispDate + " " + s_en_hr + ":" + endMin, userName,true);
		
		endDateForHighchart=dispDate + " "+ s_en_hr + ":" + endMin;

			endDateForDisplay = dispDate;
			endHourForDisplay = s_en_hr;
			endMinForDisplay = endMin;
				
			dispDate=(String) timeZoneConverterEnd.getDate(false);
			s_en_time=dispDate;
			endDateJSON=dispDate;
			s_en_hr = timeZoneConverterEnd.getHour();
			endHourJSON=s_en_hr;
			endMin = timeZoneConverterEnd.getMinute(); 
		}		
		
	} else {
		if(er_timeline.endsWith("last")){			
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			
			endDateForDisplay = userTimeZoneList.get(1);			
			endHourForDisplay = "23";			
			endMinForDisplay = "59";
										
			timeZoneConverterEnd = new EgTimeZoneConverter(endDateForDisplay + " "+ endHourForDisplay + ":" + endMinForDisplay, userName, true);
	
			endDateJSON=(String) timeZoneConverterEnd.getDate(false);
			endHourJSON=timeZoneConverterEnd.getHour();
			endMin = timeZoneConverterEnd.getMinute(); 
			endDateForHighchart=endDateJSON + " "+ endHourJSON + ":" + endMin;
			/*System.out.println("2Manager Start Time-->"+startDateForHighchart);
			System.out.println("2Manager Start Hour-->"+startHourJSON);
			System.out.println("2Manager End Time--->"+endDateForHighchart);*/
			System.out.println("2Manager-Last Start Date-->"+startDateJSON+"  Start Hour-->"+startHourJSON+"  Start Min-->"+startMin);
		}else{
			timeZoneConverterEnd = new EgTimeZoneConverter(dispDate + " "+ s_en_hr + ":" + endMin, userName);

			endDateForHighchart=dispDate + " "+ s_en_hr + ":" + endMin;
			endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
			endHourForDisplay = timeZoneConverterEnd.getHour(); 
			endHourJSON=s_en_hr;
			s_en_hr = s_en_hr.trim();
			endMinForDisplay = timeZoneConverterEnd.getMinute();
			endDateJSON=dispDate;
			System.out.println("2Manager Start Date-->"+startDateJSON+"  Start Hour-->"+startHourJSON+"  Start Min-->"+startMin);
		}
	}

	//for(int e_ctr=0; e_ctr<24; e_ctr++)
	//{
		//s_en_hr=s_en_hr.trim();
		//endHourJSON=s_en_hr;
	//}
	if(request.getParameter("er_type")!=null && !(request.getParameter("er_type")).equalsIgnoreCase("Comparison"))
	{
		if(request.getParameter("er_type").equals("Yes") || request.getParameter("er_type").equals("Vmgstatus"))
		{
		
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D")){
				selectedGraphMode="2D";
			}
			if(mode.equals("3D")){
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
		}
	}
	else if(request.getParameter("er_type_proc")!=null)
	{
		if(request.getParameter("er_type_proc").equals("Yes"))// || request.getParameter("er_type_proc").equals("Vmgstatus"))
		{
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D")){
				selectedGraphMode="2D";
			}
			if(mode.equals("3D")){
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
		}
	}
	else if(request.getParameter("er_rtype")!=null && request.getParameter("er_rtype").equalsIgnoreCase("AlarmHistory"))
	{
		
	}
	else if(reporttype!=null && (reporttype.equalsIgnoreCase("executive")|| reporttype.equalsIgnoreCase("operation")||reporttype.equalsIgnoreCase("TopN")) || (grophmodeon!=null && grophmodeon.equalsIgnoreCase("yes")) ||er_gtype!=null && er_gtype.equalsIgnoreCase("Comparison"))
	{
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D"))
			{
				selectedGraphMode="2D";
			}
			if(mode.equals("3D"))
			{
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
	}


		hiddenFields.put("userTimeline", strUsrTimeline);

		timeZone.put("timelineCombo", timelineComboArray);
		timeZone.put("timelineHourCombo", timelineHourComboArray);
		timeZone.put("selectedTimeline", er_timeline);
		timeZone.put("startDate", startDateJSON);
		timeZone.put("endDate", endDateJSON);
		timeZone.put("startHour", startHourJSON);
		timeZone.put("endHour", endHourJSON);
		timeZone.put("startmin", strmin);
		timeZone.put("endmin", enmin);
		//timeZone.put("selectedGraphMode",selectedGraphMode);

		timeZone.put("startDateForDisplay", startDateForDisplay);
		timeZone.put("startHourForDisplay", startHourForDisplay);
		timeZone.put("startMinForDisplay", startMinForDisplay);
		timeZone.put("endDateForDisplay", endDateForDisplay);
		timeZone.put("endHourForDisplay", endHourForDisplay);
		timeZone.put("endMinForDisplay", endMinForDisplay);

		// Added for csv 
		list.add(intlmap.getTextDescription("reporter.common.VM RIGHT SIZING REPORT "));
		// Added for CSV ends
		String er_foreground = "";
		String er_background = "";
		String er_reportGeneration = request.getParameter("er_reportgenration");
		if (!StringUtils.isNull(er_reportGeneration) && er_reportGeneration.equalsIgnoreCase("background")) 
		{
			er_background = "selected";
			er_foreground = "";
			selectedFields.put("reportGeneration","background");
			//selectedFields.put("reportGeneration","background");
		} 
		else
		{
			er_background = "";
			er_foreground = "selected";
			selectedFields.put("reportGeneration","foreground");
			//selectionDetais.put("reportGeneration","background");
		}
		//----------------- reportGeneration----------------------
		JSONArray reportGenerationArray = new JSONArray();
		JSONObject reportGenerationObject;
		idFields.put("reportGenerationComboId", "er_reportgenration");
		displayLabels.put("reportGenerationComboLabel", intlmap.getTextDescription("reporter.common.Report Generation"));

		reportGenerationObject = new JSONObject();
		reportGenerationObject.put("displayField", strbackground);
		reportGenerationObject.put("valueField", "background");
		reportGenerationArray.add(reportGenerationObject);
		reportGenerationObject = new JSONObject();
		reportGenerationObject.put("displayField", strforeground);
		reportGenerationObject.put("valueField", "foreground");
		reportGenerationArray.add(reportGenerationObject);
		rightSizingJson.put("reportGenerationCombo", reportGenerationArray);

		idFields.put("reportNameTextBoxId", "bg_reportname");
		displayLabels.put("reportNameTextBoxLabel", intlmap.getTextDescription("reporter.common.Report Name"));


		if (strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes")) 
		{
			displayLabels.put("backgroundReportStatus",status);
		}
		if (bggroundStr != null && !bggroundStr.equals("")) 
		{
			isBackgroundProcess = true;

			if ((status != null && status.equalsIgnoreCase("duplicate")) || bggroundStr != null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished")) 
			{
			}
			String bgroundResponseTxt=erbgreport.getlangsupportedString(bggroundStr,bgString,urs);
			displayLabels.put("bgroundResponseTxt",bgroundResponseTxt);
			urlFields.put("bgroundReportsURL","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom=VM_Right_Sizing&userID="+urs+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
		}
			displayLabels.put("backgroundAnchor", intlmap.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));

		if (resultMap != null && isSubmit != null && isSubmit.equalsIgnoreCase("true") && (bggroundStr == null || bggroundStr.equals("")) && dataForGPU) 
		{
			 // Added for csv 
			list.add(intlmap.getTextDescription("reporter.common.VM RIGHT SIZING REPORT "));
			Vector v_date = new Vector();
			v_date.add("\"" + intlmap.getTextDescription("reporter.common.Start Date") + " : " + DateUtil.changeDateFormat(dispCsvStartDate, "MM/dd/yyyy HH:mm:ss", currentDateFormat + " HH:mm:ss") + "\"");
			v_date.add("\"" + intlmap.getTextDescription("reporter.common.End Date") + " : " + DateUtil.changeDateFormat(dispCsvEndDate, "MM/dd/yyyy HH:mm:ss", currentDateFormat + " HH:mm:ss") + "\"");
			list.add(v_date);
			list.add(intlmap.getTextDescription("reporter.common.VM Right Sizing Report") + " - " + intlmap.getComponentTypeDescription(s_comptype) + " - " + intlmap.getComponentTypeDescription(er_criteria));
			// Added for CSV ends
			String test = "VmgGPUTest";
			List measureList = new ArrayList();
			String tempMeasure = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, test);
			st = new StringTokenizer(tempMeasure, ",");
			EgDbInfo dbInfo = new EgDbInfo("manager");
			while (st.hasMoreTokens()) 
			{
				String tempStr = st.nextToken();
				String columnName = dbInfo.getColumnForMeasure(test,tempStr, false);
				if (columnName == null || columnName.equals(""))
				{
					columnName = tempStr;
				}
				measureList.add(tempStr);
				//measureList.add(columnName);
			}
			JSONObject gridTitle = new JSONObject();
			JSONArray gridColumn = new JSONArray();
			JSONArray gridColumnAry = new JSONArray();
			JSONObject vmState = new JSONObject();
			gridTitle.put("gridTitle", intlmap.getTextDescription("reporter.common.VM Right Sizing Report") + " - " + intlmap.getComponentTypeDescription(s_comptype) + " - " + er_criteria);
			grid.put("gridTitle", gridTitle);
			gridColumn.add(intlmap.getTextDescription("reporter.common.Host"));
			gridColumn.add(intlmap.getTextDescription("reporter.common.VM Name"));
			gridColumn.add(intlmap.getTextDescription("reporter.common.Card Name"));
			for(int i=0;i<measureList.size();i++)
			{
				String measureVal = (String)measureList.get(i);
				String measureUnit = tablesInfo.getUnitForMeasure(test, measureVal);
				String GPUText = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, measureVal.toUpperCase());
				if(measureUnit!=null && measureUnit.length()>0)
					measureUnit=" (" + measureUnit + ")";
				else
					measureUnit="";
			
				JSONArray subColumn = new JSONArray();
				if(!measureVal.equalsIgnoreCase("Encoder") && !measureVal.equalsIgnoreCase("Decoder"))
					subColumn.add(intlmap.getTextDescription("reporter.common.Max")+ measureUnit );
				subColumn.add(intlmap.getTextDescription("reporter.common.Avg")+  measureUnit);
				JSONObject gpuMesObj = new JSONObject();
				
				gpuMesObj.put(GPUText,subColumn);
				gridColumn.add(gpuMesObj);
			}
			gridColumn.add(intlmap.getTextDescription("reporter.common.Remarks"));
			List mapKeySet = (ArrayList)resultMap.get("KEYSET");
			JSONArray gridDataArray = new JSONArray();
			if(mapKeySet!=null && mapKeySet.size()>0)
			{
				if((dynamicRangeValue==null || dynamicRangeValue.length()==0) && er_criteria.contains("Undersized") )
					dynamicRangeValue = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "GpuOversizedAvg");
				else if(dynamicRangeValue==null || dynamicRangeValue.length()==0)
					dynamicRangeValue = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "GpuUndersizedAvg");
				
				if(dynamicBufferRangeValue==null || dynamicBufferRangeValue.length()==0)
					dynamicBufferRangeValue = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "GpuBufferMaxVal");

				double GpuUndersizedMax=Double.parseDouble(reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "GpuUndersizedMax"));
				double GpuUndersizedAvg=Double.parseDouble(dynamicRangeValue);
				double GpuOversizedAvg=Double.parseDouble(dynamicRangeValue);
				double GpuBufferMaxVal=Double.parseDouble(dynamicBufferRangeValue);
				for(int i=0;i<mapKeySet.size();i++)
				{
					String dbKey = (String)mapKeySet.get(i);
					JSONObject gridInfoObj = new JSONObject();	
					gridInfoObj.put(gridColumn.get(0),dbKey.substring(0,dbKey.indexOf("#")));
					gridInfoObj.put(gridColumn.get(1),dbKey.substring(dbKey.indexOf("#")+1,dbKey.indexOf(":")));
					gridInfoObj.put(gridColumn.get(2),dbKey.substring(dbKey.indexOf(":")+1,dbKey.length()));
					String criteriaFlag="No";
					String criteriaText = "-";

					Map measureMap = null;
					for(int ii=0;ii<measureList.size();ii++)
					{
						String measureVal = (String)measureList.get(ii);
						measureMap = (HashMap)resultMap.get(measureVal.toUpperCase());
						String measureUnit = tablesInfo.getUnitForMeasure(test, measureVal);
						if(measureUnit!=null && measureUnit.length()>0)
							measureUnit=" ("+measureUnit+")";
						String GPUText = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, measureVal.toUpperCase());
						if(measureMap!=null && measureMap.size()>0)
						{
							List measureInfolst = (ArrayList)measureMap.get(dbKey);
							if(measureInfolst!=null && measureInfolst.size()>0)
							{
								String maxValStr = (String)measureInfolst.get(0);
								String avgValStr = (String)measureInfolst.get(1);
								double maxVal =  Double.parseDouble(maxValStr);
								double avgVal =  Double.parseDouble(avgValStr);

								if (measureVal.equalsIgnoreCase("GPU_USAGE") ) 
								{
									if(er_criteria.contains("Undersized"))
									{
										if(avgVal > GpuOversizedAvg)
										{
											avgValStr+="#yes";
											criteriaFlag="Yes";
											criteriaText="GPU Utilization is high. Consider configuring VM in Pass through mode";
										}
										else
										{
											avgValStr+="#no";
										}
									}
									else
									{
										if(maxVal < GpuUndersizedMax)
										{
											criteriaFlag="Yes";
											criteriaText="GPU Utilization is low. Consider configuring VM in Shared mode";
											maxValStr+="#yes";
											avgValStr+="#no";
										}
										else if(avgVal < GpuUndersizedAvg)
										{
											criteriaFlag="Yes";
											criteriaText="GPU Utilization is low. Consider configuring VM in Shared mode";
											maxValStr+="#no";
											avgValStr+="#yes";
										}
										else
										{
											maxValStr+="#no";
											avgValStr+="#no";
										}
									}
								}
								else if (measureVal.equalsIgnoreCase("FB_MEM_UTIL") && er_criteria.contains("Undersized")) 
								{
									if(avgVal > GpuBufferMaxVal)
									{
										avgValStr+="#yes";
										criteriaFlag="Yes";
										if(criteriaText.equals("-"))
											criteriaText="Frame Buffers Utilization is high. Consider changing the vGPU profile";
									}
									else
									{
										avgValStr+="#no";
									}
								}
								if(!measureVal.equalsIgnoreCase("Encoder") && !measureVal.equalsIgnoreCase("Decoder"))
									gridInfoObj.put(GPUText +"Max"+measureUnit,maxValStr);
								gridInfoObj.put(GPUText +"Avg"+measureUnit,avgValStr);
							}
							else
							{
								if(!measureVal.equalsIgnoreCase("Encoder") && !measureVal.equalsIgnoreCase("Decoder"))
									gridInfoObj.put(GPUText +"Max"+measureUnit,"-");
								gridInfoObj.put(GPUText +"Avg"+measureUnit,"-");
							}
						}
						else
						{
							if(!measureVal.equalsIgnoreCase("Encoder") && !measureVal.equalsIgnoreCase("Decoder"))
								gridInfoObj.put(GPUText +"Max"+measureUnit,"-");
							gridInfoObj.put(GPUText +"Avg"+measureUnit,"-");
						}
						
						gridInfoObj.put(intlmap.getTextDescription("reporter.common.Remarks"),criteriaText);
					}
					if(er_criteriaonly.equalsIgnoreCase("yes") && criteriaFlag.equalsIgnoreCase("yes"))
						gridDataArray.add(gridInfoObj);
					else if(er_criteriaonly.equalsIgnoreCase("no"))
						gridDataArray.add(gridInfoObj);
				}
				if(gridDataArray.size()>0)
					grid.put("gridData", gridDataArray);
			}
			grid.put("gridColumn", gridColumn);
			if (er_criteria.contains("Undersized")) 
			{
				vmState.put("normalColor", normalColor);
				vmState.put("criticalColor", criticalColor);
				vmState.put("normalValue", intlmap.getTextDescription("reporter.common.VM is not Undersized"));
				vmState.put("criticalValue", intlmap.getTextDescription("reporter.common.VM is Undersized"));
			} 
			else 
			{
				vmState.put("normalColor", normalColor);
				vmState.put("criticalColor", criticalColor);
				vmState.put("normalValue", intlmap.getTextDescription("reporter.common.VM is not Oversized"));
				vmState.put("criticalValue", intlmap.getTextDescription("reporter.common.VM is Oversized"));
			}
			grid.put("vmState", vmState);
			System.out.println("vengat final grid data "+grid);
		}
		else if (resultMap != null && isSubmit != null && isSubmit.equalsIgnoreCase("true") && (bggroundStr == null || bggroundStr.equals("")) && !dataForGPU) 
		{
			// Added for csv 
			list.add(intlmap.getTextDescription("reporter.common.VM RIGHT SIZING REPORT "));
			Vector v_date = new Vector();
			v_date.add("\"" + intlmap.getTextDescription("reporter.common.Start Date") + " : " + DateUtil.changeDateFormat(dispCsvStartDate, "MM/dd/yyyy HH:mm:ss", currentDateFormat + " HH:mm:ss") + "\"");
			v_date.add("\"" + intlmap.getTextDescription("reporter.common.End Date") + " : " + DateUtil.changeDateFormat(dispCsvEndDate, "MM/dd/yyyy HH:mm:ss", currentDateFormat + " HH:mm:ss") + "\"");
			list.add(v_date);
			list.add(intlmap.getTextDescription("reporter.common.VM Right Sizing Report") + " - " + intlmap.getComponentTypeDescription(s_comptype) + " - " + intlmap.getComponentTypeDescription(er_criteria));
			// Added for CSV ends
			String testString = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, s_comptype);

			String appendStr="";
			if(er_criteriaInfo.indexOf("Memory Usage")>-1 )
			{
				// Memomory usgae 2nd test is not need for VmEsx_i_server and VmVdi_i_server
				if(s_comptype.equalsIgnoreCase("VmEsx_i_server")||s_comptype.equalsIgnoreCase("VmVdi_i_server"))
				{
					testString=testString.substring(0,testString.indexOf(","));
				}
				appendStr="_memory";
			}
			List testList = new ArrayList();
			List measureList = new ArrayList();
			st = new StringTokenizer(testString, ",");
			while (st.hasMoreTokens()) 
			{
				String tempStr = st.nextToken();
				String measureString = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, tempStr+appendStr);
				StringTokenizer stk = new StringTokenizer(measureString, ",");
				while (stk.hasMoreTokens()) 
				{
					String temp = stk.nextToken();
					measureList.add(temp);
				}
				testList.add(tempStr);
			}
			if(er_criteriaInfo.indexOf("Memory Usage")>-1 && (s_comptype.equalsIgnoreCase("VmEsx_i_server")|| s_comptype.equalsIgnoreCase("VmVdi_i_server")))
			{
				measureList.remove(measureList.size()-1);
			}
			int columnCount = 6;

			if (!er_option.equalsIgnoreCase("Component")) 
			{
			}

			JSONObject gridTitle = new JSONObject();
			JSONArray gridColumn = new JSONArray();
			JSONObject vmState = new JSONObject();
			ArrayList mappingColumnNames = new ArrayList();
			if (!noDataForVM && ((er_criteriaonly.equalsIgnoreCase("yes") && criteriaOnleFalg) || (er_criteriaonly.equalsIgnoreCase("no")))) 
			{
				if (s_comptype != null && ((!s_comptype.equalsIgnoreCase("VmEsx_i_server")&&!s_comptype.equalsIgnoreCase("VmVdi_i_server")) || er_criteriaInfo.indexOf("Memory Usage")>-1)) 
				{
					gridTitle.put("gridTitle", intlmap.getTextDescription("reporter.common.VM Right Sizing Report") + " - " + intlmap.getComponentTypeDescription(s_comptype) + " - " + er_criteria);

				}
				else
				{
					columnCount = 7;
					gridTitle.put("gridTitle", intlmap.getTextDescription("reporter.common.VM Right Sizing Report") + " - " + intlmap.getComponentTypeDescription(s_comptype) + " - " + er_criteria);

				}
				grid.put("gridTitle", gridTitle);
				String vmimg = "";

				gridColumn.add(intlmap.getTextDescription("reporter.common.Host"));
				gridColumn.add(intlmap.getTextDescription("reporter.common.VM"));
				List orderedList = (ArrayList) resultMap.get("ORDERED_LIST");
				if (sortingOption == null || (sortingOption != null && sortingOption.equalsIgnoreCase("Host"))) 
				{
					vmimg = SORTED_UP;
					if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
					{
						vmimg = SORTED_DOWN;
					}
				}
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.Host"));
				vmimg = "";
				if (sortingOption != null && sortingOption.equalsIgnoreCase("VM")) 
				{
					vmimg = SORTED_DOWN;
					if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
					{
						vmimg = SORTED_UP;
					}
				}
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.VM"));
				String test = (String) testList.get(0);
				String measure = (String) measureList.get(0);
				String measureUnit = tablesInfo.getUnitForMeasure(test, measure);
				String unit_configMemory = "";
				if(er_criteriaInfo.indexOf("Memory Usage")>-1)
				  unit_configMemory = tablesInfo.getUnitForMeasure(test, (String) measureList.get(1));
				if(unit_configMemory!=null && unit_configMemory.length()>0)
					unit_configMemory=" ("+unit_configMemory+")";

				vmimg = "";
				if (sortingOption != null && sortingCount != null && sortingOption.equalsIgnoreCase("Measure") && sortingCount.equals("1")) 
				{
					vmimg = SORTED_DOWN;
					if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
					{
						vmimg = SORTED_UP;
					}
				}

				String cpuUsageText = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "CPUUsageText");
				if(er_criteriaInfo.indexOf("Memory Usage")>-1)
					cpuUsageText = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "MemoryUsageText");
				v_measure_csv.add(cpuUsageText + "(" + measureUnit + ")");
				v_measure_csv.add("");
				v_measure_csv.add("");
				
				JSONArray subColumn = new JSONArray();
				subColumn.add(intlmap.getTextDescription("reporter.common.Min"));
				subColumn.add(intlmap.getTextDescription("reporter.common.Max"));
				subColumn.add(intlmap.getTextDescription("reporter.common.Avg"));
				JSONObject cpuUsageObj = new JSONObject();
				cpuUsageObj.put(cpuUsageText + " (" + measureUnit + ")",subColumn);
				gridColumn.add(cpuUsageObj);
				mappingColumnNames.add(cpuUsageText + " (" + measureUnit + ")"+intlmap.getTextDescription("reporter.common.Min"));
				mappingColumnNames.add(cpuUsageText + " (" + measureUnit + ")"+intlmap.getTextDescription("reporter.common.Max"));
				mappingColumnNames.add(cpuUsageText + " (" + measureUnit + ")"+intlmap.getTextDescription("reporter.common.Avg"));

				int count = 0;
				if (s_comptype != null && (s_comptype.equalsIgnoreCase("VmEsx_i_server")|| s_comptype.equalsIgnoreCase("VmVdi_i_server") )&& er_criteriaInfo.indexOf("Memory Usage")==-1) 
				{
					//test = (String) testList.get(0);
					measure = (String) measureList.get(1);
					measureUnit = tablesInfo.getUnitForMeasure(test, measure);
					count++;
					vmimg = "";
					if (sortingOption != null && sortingCount != null && sortingOption.equalsIgnoreCase("Measure") && sortingCount.equals("4")) 
					{
						vmimg = SORTED_DOWN;
						if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
						{
							vmimg = SORTED_UP;
						}
					}
					v_measure_csv.add(intlmap.getTextDescription("reporter.common.Avg Ready time") + "(" + measureUnit + ")");
					gridColumn.add(intlmap.getTextDescription("reporter.common.Avg Ready time") + "(" + measureUnit + ")");
					mappingColumnNames.add(intlmap.getTextDescription("reporter.common.Avg Ready time") + "(" + measureUnit + ")");
				}
				measure = (String) measureList.get(1);
				if (measureList.size() > 2) 
				{
					measure = (String) measureList.get(2);
				}
				count = count + 4;
				vmimg = "";
				if (sortingOption != null && sortingCount != null && sortingOption.equalsIgnoreCase("Measure") && sortingCount.equals(Integer.toString(count))) 
				{
					vmimg = SORTED_DOWN;
					if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
					{
						vmimg = SORTED_UP;
					}
				}
				if(er_criteriaInfo.indexOf("Memory Usage")==-1)
				{
					gridColumn.add(intlmap.getTextDescription("reporter.common.Number of vCPUs"));
					mappingColumnNames.add(intlmap.getTextDescription("reporter.common.Number of vCPUs"));
					v_measure_csv.add(intlmap.getTextDescription("reporter.common.Number of vCPUs"));
				}
				else
				{
					gridColumn.add(intlmap.getTextDescription("reporter.common.Configured Memory"+unit_configMemory));
					mappingColumnNames.add(intlmap.getTextDescription("reporter.common.Configured Memory"+unit_configMemory));
					v_measure_csv.add(intlmap.getTextDescription("reporter.common.Configured Memory"+unit_configMemory));
				}
				count++;
				if (er_criteria.contains("Undersized")) 
				{
					vmimg = "";
					if (sortingOption != null && sortingCount != null && sortingOption.equalsIgnoreCase("Criteria") && sortingCount.equals(Integer.toString(count))) 
					{
						vmimg = SORTED_UP;
						if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) {
							vmimg = SORTED_DOWN;
						}
					}
					gridColumn.add(intlmap.getTextDescription("reporter.common.Is VM Undersized?"));
					mappingColumnNames.add(intlmap.getTextDescription("reporter.common.Is VM Undersized?"));
					v_measure_csv.add(intlmap.getTextDescription("reporter.common.Is VM Undersized?"));

				}
				else 
				{
					vmimg = "";
					if (sortingOption != null && sortingCount != null && sortingOption.equalsIgnoreCase("Criteria") && sortingCount.equals(Integer.toString(count))) 
					{
						vmimg = SORTED_UP;
						if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
						{
							vmimg = SORTED_DOWN;
						}
					}
					gridColumn.add(intlmap.getTextDescription("reporter.common.Is VM Oversized?"));
					mappingColumnNames.add(intlmap.getTextDescription("reporter.common.Is VM Oversized?"));
					v_measure_csv.add(intlmap.getTextDescription("reporter.common.Is VM Oversized?"));
				}
				gridColumn.add(intlmap.getTextDescription("reporter.common.Remarks"));
				mappingColumnNames.add(intlmap.getTextDescription("reporter.common.Remarks"));
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.Remarks"));
				grid.put("gridColumn", gridColumn);
				list_data.add("");
				list_data.add("");
				vmimg = "";
				if (sortingOption != null && sortingCount != null && sortingOption.equalsIgnoreCase("Measure") && sortingCount.equals("1")) 
				{
					vmimg = SORTED_DOWN;
					if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
					{
						vmimg = SORTED_UP;
					}
				}
				list_data.add(intlmap.getTextDescription("reporter.common.Min"));
				vmimg = "";
				if (sortingOption != null && sortingCount != null && sortingOption.equalsIgnoreCase("Measure") && sortingCount.equals("2")) 
				{
					vmimg = SORTED_DOWN;
					if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
					{
						vmimg = SORTED_UP;
					}
				}
				list_data.add(intlmap.getTextDescription("reporter.common.Max"));
				vmimg = "";
				if (sortingOption != null && sortingCount != null && sortingOption.equalsIgnoreCase("Measure") && sortingCount.equals("3")) 
				{
					vmimg = SORTED_DOWN;
					if (sortingOrder != null && sortingOrder.equalsIgnoreCase("ascending")) 
					{
						vmimg = SORTED_UP;
					}
				}
				list_data.add(intlmap.getTextDescription("reporter.common.Avg"));
				list_data.add("");
				list_data.add("");
				list_data.add("");
				if (s_comptype != null && (s_comptype.equalsIgnoreCase("VmEsx_i_server")||s_comptype.equalsIgnoreCase("VmVdi_i_server")) && er_criteriaInfo.indexOf("Memory Usage")==-1) 
				{
					list_data.add("");
				}
				JSONObject gridDataObj;
				JSONArray gridDataArray = new JSONArray();
				boolean rowsAvailable = false;
				for (int i = 0; i < orderedList.size(); i++) 
				{
					ErVMRightSizingVO vo = (ErVMRightSizingVO) orderedList.get(i);
					String comp = vo.getHost();
					String info = vo.getInfo();
					info = info.substring(info.indexOf("+") + 1);
					list_data.add(comp);
					list_data.add(info);
					gridDataObj = new JSONObject();
					gridDataObj.put(intlmap.getTextDescription("reporter.common.Host"), comp);
					gridDataObj.put(intlmap.getTextDescription("reporter.common.VM"), info);
					List valueList = (ArrayList) vo.getMeasureList();
					for (int k = 0; k < columnCount; k++) 
					{
						String value = "-";
						if (k <= valueList.size() - 1) 
						{
							value = (String) valueList.get(k);
							gridDataObj.put(mappingColumnNames.get(k), value);
						}
						if (value.indexOf("-") > -1) 
						{
							value = "-";
							gridDataObj.put(mappingColumnNames.get(k), value);
						}
						if (k == columnCount - 2) 
						{
							String color = "";
							String title = "";
							if (value.equalsIgnoreCase("Yes")) 
							{
								color = criticalColor;
								if (er_criteria.contains("Undersized")) 
								{
									title = "Undersized";
								} else {
									title = "Oversized";
								}
							} 
							else if (value.equalsIgnoreCase("No")) 
							{
								color = normalColor;
								if (er_criteria.contains("Undersized")) 
								{
									title = "Not Undersized";
								}
								else 
								{
									title = "Not Oversized";
								}
							}
						} 
						list_data.add(value);
					}
					gridDataArray.add(gridDataObj);
					grid.put("gridData", gridDataArray);
					//rightSizingJson.put("grid",grid);
				}
				if (er_criteria.contains("Undersized")) 
				{
					vmState.put("normalColor", normalColor);
					vmState.put("criticalColor", criticalColor);
					vmState.put("normalValue", intlmap.getTextDescription("reporter.common.VM is not undersized"));
					vmState.put("criticalValue", intlmap.getTextDescription("reporter.common.VM is undersized"));

				} 
				else 
				{
					vmState.put("normalColor", normalColor);
					vmState.put("criticalColor", criticalColor);
					vmState.put("normalValue", intlmap.getTextDescription("reporter.common.VM is not oversized"));
					vmState.put("criticalValue", intlmap.getTextDescription("reporter.common.VM is oversized"));
				}
				grid.put("vmState", vmState);
				//rightSizingJson.put("grid",grid);
			}
			else if (er_criteriaonly.equalsIgnoreCase("yes")) 
			{
				JSONObject noVMs = new JSONObject();;

				if (er_criteria.contains("Oversized")) 
				{
					noVMs.put("noVMs", intlmap.getTextDescription("reporter.common.No VMs are oversized for the current selection"));

				}
				else 
				{
					noVMs.put("noVMs", intlmap.getTextDescription("reporter.common.No VMs are undersized for the current selection"));
				}
				grid.put("noVMsFound", noVMs);
			}
			/*  selectionDetails.put(intlmap.getTextDescription("reporter.common.Analysis By"),intlmap.getTextDescription("reporter.common."+er_option));			 
			  selectionDetails.put(intlmap.getTextDescription("reporter.common.Criterion"),intlmap.getTextDescription("reporter.common."+er_site));
			  selectionDetails.put(intlmap.getTextDescription("reporter.common.Component Type"),intlmap.getTextDescription("reporter.common."+s_comptype));
			  selectionDetails.put(intlmap.getTextDescription("reporter.common.Component"),intlmap.getTextDescription("reporter.common."+compList));
			  selectionDetails.put(intlmap.getTextDescription("reporter.common.Criterion"),intlmap.getTextDescription("reporter.common."+er_criteria));
			  selectionDetails.put(intlmap.getTextDescription("reporter.common.Component Type"),intlmap.getTextDescription("reporter.common."+er_criteriaonly));
					*/  
			String st_dateTime="";
			String en_dateTime="";
			//String comFormat = null;
			EgTimeZoneConverter converterStart=null;
			EgTimeZoneConverter converterEnd=null;

			if(s_st_time!=null)
			{
				if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
				{
					comFormat = currentDateFormat;
					s_st_time = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",comFormat);
				}
				converterStart = new EgTimeZoneConverter(s_st_time+" "+s_st_hr+":"+strmin,thisuser);
				st_dateTime = converterStart.getDateTime();
			}
			if(s_en_time!=null)
			{
				if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
				{
					comFormat = currentDateFormat;
					s_en_time = DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy",comFormat);
				}
				converterEnd = new EgTimeZoneConverter(s_en_time+" "+s_en_hr+":"+enmin,thisuser);
				en_dateTime = converterEnd.getDateTime();
			}
			String dispStartDate=st_dateTime;
			String dispEndDate=en_dateTime;
			String timfrom=timefrom2+":"+minfrom2;
			String timto=timeto2+":"+minto2;

			selectionDetails.put(intlmap.getTextDescription("reporter.common.Time Period"),"<span class='font_bold'> </span>  "+ timfrom+"<span class='font_bold'>   "+intlmap.getTextDescription("reporter.common.to")+" </span>  "+timto);

			selectionDetails.put(intlmap.getTextDescription("reporter.common.Timeline"),"<span class='font_bold'> </span>  "+st_dateTime+" hrs <span class='font_bold'> "+intlmap.getTextDescription("reporter.common.to")+" </span>  "+en_dateTime+" hrs");

			rightSizingJson.put("selectionDetails",selectionDetails);
		}

		if (er_criteriaonly != null && !er_criteriaonly.equalsIgnoreCase("yes") && resultMap != null && isSubmit != null && isSubmit.equalsIgnoreCase("true") && (noDataFound || noDataForVM) && !dataForGPU) 
		{
			JSONObject noMeasures = new JSONObject();
			noMeasures.put("noMeasures", intlmap.getTextDescription("reporter.common.No measures available for the current selection"));
			grid.put("noMeasuresFound", noMeasures);
		}
		if (grid.size() > 0) 
		{
			rightSizingJson.put("grid", grid);
		}
		// added for csv starts
		h_tabrc.put(v_measure_csv, list_data);
		h_tab.put(s_title, h_tabrc);
		list.add(h_tab);
		list_data.add("\n");
		v_measure_csv = new Vector();
		list_data = new LinkedList();
		h_tabrc = new Hashtable();
		h_tab = new Hashtable();
		if (list != null && !list.isEmpty()) 
		{
			session.setAttribute("list", list);
		}
		// for csv ends here
		//for mail starts
		String strEncodeer_timeline = er_timeline;
		if (er_timeline != null) 
		{
			strEncodeer_timeline = com.eg.EgURLEncoder.encode(er_timeline, UTF_8);
		}
		s_st_time = request.getParameter("startdate");
		s_en_time = request.getParameter("enddate");
		if (s_st_time != null && s_en_time != null && s_inidate != null) 
		{
			s_st_time = com.eg.EgURLEncoder.encode(s_st_time, UTF_8);
			s_en_time = com.eg.EgURLEncoder.encode(s_en_time, UTF_8);
			s_inidate = com.eg.EgURLEncoder.encode(s_inidate, UTF_8);
		}
		String dataProcess = mngrIProc+"/final/reporter/ErVMRightSizingReportPrint.jsp;jsessionid=" + session.getId() + "?er_comptype=" + s_comptype + "&startdate=" + s_st_time + "&enddate=" + s_en_time + "&timefrom=" + timefrom2 + "&minfrom=" + minfrom2 + "&timeto=" + timeto2 + "&minto=" + minto2 + "&starthr=" + s_st_hr + "&endhr=" + s_en_hr + "&er_timeline=" + strEncodeer_timeline + "&startmin=" + strmin + "&endmin=" + enmin + "&inidate=" + s_inidate + "&pageWidthProces=400";
		String dataProcess1 = "../reporter/ErVMRightSizingReportPrint.jsp;jsessionid=" + session.getId() + "?er_comptype=" + s_comptype + "&startdate=" + s_st_time + "&enddate=" + s_en_time + "&timefrom=" + timefrom2 + "&minfrom=" + minfrom2 + "&timeto=" + timeto2 + "&minto=" + minto2 + "&starthr=" + s_st_hr + "&endhr=" + s_en_hr + "&er_timeline=" + strEncodeer_timeline + "&startmin=" + strmin + "&endmin=" + enmin + "&inidate=" + s_inidate + "&pageWidthProces=400";
		session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/ErVMRightSizingReportPrint.jsp");
		if (sel_component != null) 
		{
			for (int j = 0; j < sel_component.length; j++) 
			{
				dataProcess += "&er_component=" + com.eg.EgURLEncoder.encode(sel_component[j], UTF_8);
			}
		}
		if (er_criteria != null) 
		{
			dataProcess += "&er_criteria=" + com.eg.EgURLEncoder.encode(er_criteria, UTF_8);
		}
		if (er_criteriaInfo != null) 
		{
			dataProcess += "&er_criteriaInfo=" + com.eg.EgURLEncoder.encode(er_criteriaInfo, UTF_8);
		}
		if (er_criteriaonly != null) 
		{
			dataProcess += "&er_criteriaOnly=" + com.eg.EgURLEncoder.encode(er_criteriaonly, UTF_8);
		}
		session.setAttribute("MAIL_URL", dataProcess);

		//for mail ends
		JSONObject queryStringObj = new JSONObject();

		String queryString = (String) ErUtils.prepareQueryString(request.getParameterMap());
		queryStringObj.put("query", queryString);
		String qString = "";
		String qStringBackUrl = "";
		if (queryString != null) 
		{
			StringTokenizer strtok = new StringTokenizer(queryString, "&");
			while (strtok.hasMoreTokens()) 
			{
				String parameter = strtok.nextToken();
				int ind = parameter.indexOf("=");
				if (ind < 0) 
				{
					continue;
				}
				String reqparam = parameter.substring(0, ind);
				String value = parameter.substring(ind + 1);
				if (reqparam != null) 
				{
					if (reqparam.equals("er_site")) 
					{
						value = com.eg.EgURLEncoder.encode(value, UTF_8);
					}
					else if (reqparam.equals("startdate")) 
					{
						value = com.eg.EgURLEncoder.encode(value, UTF_8);
					}
					else if (reqparam.equals("enddate")) 
					{
						value = com.eg.EgURLEncoder.encode(value, UTF_8);
					}
					else if (reqparam.equals("inidate")) 
					{
						value = com.eg.EgURLEncoder.encode(value, UTF_8);
					}
					qString += reqparam + "=" + value + "&";
				}
			}
			if (request.getParameter("isSubmit") != null) 
			{
				session.setAttribute("reportLastAccessedURL", "/final/reporter/ErVMRightSizingReport.jsp?isSubmit=true&" + qString);
			} 
			else 
			{
				session.setAttribute("reportLastAccessedURL", "/final/reporter/ErVMRightSizingReport.jsp?" + qString);
			}
		}// redirecting reporter same page ends
		
		//Back Button - Start
		ArrayList listbackvar = new ArrayList();
		if (request.getParameter("isSubmit") != null)
		{
			listbackvar.add("ErVMRightSizingReport.jsp");
			listbackvar.add("status=" + status + "&bggroundStr=" + bggroundStr + "&" + queryString);
			session.setAttribute("favSchBackDisplay", "Yes");
		}
		else 
		{
			listbackvar.add("ErVMRightSizingReport.jsp");
			listbackvar.add(queryString);
			session.setAttribute("favSchBackDisplay", "No");
		}
		String backadded = erhelputils.getBackID();
		backreqMap = erhelputils.setBackQueryMap(backreqMap, backadded, listbackvar);
		session.setAttribute("backQuery", backreqMap);
			//Back Button - End
		
		//displayLabel.put("reporter.commom.Component Type", intlmap.getTextDescription("reporter.commom.Component Type"));
		//displayLabels.put("reporter.common.Analysis By", intlmap.getTextDescription("reporter.common.Analysis By"));
		//displayLabels.put("reporter.common.Component", intlmap.getTextDescription("reporter.common.Component"));
		//displayLabels.put("reporter.common.Zone", intlmap.getTextDescription("reporter.common.Zone"));
		//displayLabels.put("reporter.common.Include subZone", intlmap.getTextDescription("reporter.common.Include subZone"));
		displayLabels.put("reporter.common.Time period", intlmap.getTextDescription("reporter.common.Time period"));
		displayLabels.put("reporter.common.From", intlmap.getTextDescription("reporter.common.From"));
		displayLabels.put("reporter.common.Hrs", intlmap.getTextDescription("reporter.common.Hrs"));
		displayLabels.put("reporter.common.Mins", intlmap.getTextDescription("reporter.common.Mins"));
		//displayLabels.put("reporter.common.Exclude weekends", intlmap.getTextDescription("reporter.common.Exclude weekends"));
		displayLabels.put("reporter.common.Yes", intlmap.getTextDescription("reporter.common.Yes"));
		displayLabels.put("reporter.common.No", intlmap.getTextDescription("reporter.common.No"));
	   // displayLabels.put("reporter.common.Sort by", intlmap.getTextDescription("reporter.common.Sort by"));
		displayLabels.put("reporter.common.Timeline", intlmap.getTextDescription("reporter.common.Timeline"));
		displayLabels.put("reporter.common.Hr", intlmap.getTextDescription("reporter.common.Hr"));
		//displayLabels.put("reporter.common.ExcludeDays", "("+intlmap.getTextDescription("reporter.common.Excludes")+" "+Days+")");
		//rootJsonObject.put("displayFields", displayLabels);	

		String saveUrl="/final/reporter/ErHtmlToSavePdf.jsp";
	
		urlFields.put("printUrl",dataProcess1);
		urlFields.put("saveUrl",saveUrl);
		/*if(sel_component!=null) 
		{
			List<String> wordList = Arrays.asList(sel_component); 
			for(String obj:wordList)
		 System.out.println("s_comptype==="+obj);
		}*/
	    timeZone.put("hrsFrom", "00");
	    timeZone.put("minsFrom", "00");
	    timeZone.put("hrsTo", "24");
		timeZone.put("minsTo", "00");

		// vengat getting default value
		String UndersizedMax = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "UndersizedMax");
		String UndersizedMin = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "UndersizedMin");
		String GpuUndersizedAvg = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "GpuUndersizedAvg");
		String GpuOversizedAvg = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "GpuOversizedAvg");
		String GpuBufferMaxVal = reportInfo.getValue(VM_RIGHT_SIZING_REPORT, "GpuBufferMaxVal");

		dynamicFields.put("min",UndersizedMin);
		dynamicFields.put("max",UndersizedMax);
		dynamicFields.put("GpuUndersizedAvg",GpuUndersizedAvg);
		dynamicFields.put("GpuOversizedAvg",GpuOversizedAvg);
		dynamicFields.put("GpuBufferMaxVal",GpuBufferMaxVal);
        //end
		rightSizingJson.put("hiddenFields", hiddenFields);
        rightSizingJson.put("displayFields", displayLabels);
        rightSizingJson.put("selectedFields", selectedFields);
        rightSizingJson.put("dynamicFields", dynamicFields);
		rightSizingJson.put("urlFields", urlFields);
        rightSizingJson.put("idFields", idFields);
        rightSizingJson.put("timeZone", timeZone);
        rightSizingJson.put("queryString", queryStringObj);
        out.println(rightSizingJson.toString());
    } 
	catch (Exception e) 
	{
        e.printStackTrace();
    }

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
