#!/bin/sh
IFS=$'\n'
for name in `/usr/bin/vmware-cmd -l`
do
	vmname=`/usr/bin/vmware-cmd $name getconfig displayname`
	vmname=`echo $vmname |cut -d"=" -f2`
	vmname=${vmname## }
	vmname=${vmname%%}
	state=`/usr/bin/vmware-cmd $name getstate`
	state=`echo $state |cut -d"=" -f2 | tr -d ' '`
	if [ "$state" = "on" ]
	then 
	 guestip=`/usr/bin/vmware-cmd $name getguestinfo ip`
	 guestip=`echo $guestip |cut -d"=" -f2`
	 guestip=${guestip## }
	 guestip=${guestip%% }
	 state="VM_EXECUTION_STATE_ON"
	else
	 guestip=""
	 state="VM_EXECUTION_STATE_OFF"
	fi
	os=`/usr/bin/vmware-cmd $name getconfig guestOS`
	os=`echo $os |cut -d"=" -f2`
	os=${os## }
	os=${os%% }
	if [ ! -z "$vmname" ]
	then
		echo "Machine Name:$vmname#IP Address:$guestip#OS:$os#State:$state"
	fi
done

