On Error Resume Next
Function FindOSType()
    'Defining Variables
    Dim objWMI, objItem, colItems
    Dim OSVersion, OSName, ProductType
            ComputerName = "."
    'Get the WMI object and query results
    Set objWMI = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & ComputerName & "\root\cimv2")
    Set colItems = objWMI.ExecQuery("Select * from Win32_OperatingSystem",,48)

    'Get the OS version number (first two) and OS product type (server or desktop) 
    For Each objItem in colItems
                OSVersion = Left(objItem.Version,3)
        ProductType = objItem.ProductType
    Next
            
            if CInt(OSVersion) >= 6 then
                        OSName = "Windows Vista"
            else
                        OSName = "N/A"
            end if   
            
    'Return the OS name
    FindOSType = OSName
    
    'Clear the memory
    Set colItems = Nothing
    Set objWMI = Nothing
End Function

Function GetRealtimeProtectionStatus(WSC_SECURITY_PRODUCT_STATE)
            if WSC_SECURITY_PRODUCT_STATE = "00" then
                        GetRealtimeProtectionStatus = "OFF"
            elseif WSC_SECURITY_PRODUCT_STATE = "01" then
                        GetRealtimeProtectionStatus = "EXPIRED"
            elseif WSC_SECURITY_PRODUCT_STATE = "10" then
                        GetRealtimeProtectionStatus = "ON"
            elseif WSC_SECURITY_PRODUCT_STATE = "11" then
                        GetRealtimeProtectionStatus = "SNOOZED" 
            else
                        GetRealtimeProtectionStatus = "UNKNOWN"           
            end if   
End Function

Function GetDefinitionStatus(WSC_SECURITY_SIGNATURE_STATUS)
            if WSC_SECURITY_SIGNATURE_STATUS = "00" then
                        GetDefinitionStatus = "UP_TO_DATE"
            elseif WSC_SECURITY_SIGNATURE_STATUS = "10" then
                        GetDefinitionStatus = "OUT_OF_DATE"
            else
                        GetDefinitionStatus = "UNKNOWN"  
            end if   
End Function


Function PrintStatus(Product,PCode)
            Set oShell = CreateObject( "WScript.Shell" ) 
            comp=oShell.ExpandEnvironmentStrings("%ComputerName%") 
            productState = Product.productState
            HexState = Hex(productState)
            WSC_SECURITY_SIGNATURE_STATUS = Mid(HexState,4,2)
            WSC_SECURITY_PRODUCT_STATE = Mid(HexState,2,2)
            RealTimeProtectionStatus = GetRealtimeProtectionStatus(WSC_SECURITY_PRODUCT_STATE)
            DefinitionStatus = GetDefinitionStatus(WSC_SECURITY_SIGNATURE_STATUS)  
            if PCode = 4 then
                        Provider = "ANTIVIRUS"
    elseif PCode = 1 then
                        Provider = "FIREWALL"
            elseif PCode = 8 then
                        Provider = "ANTISPYWARE"
    else
                        Provider = "UNKNOWN"
            end if
            
            WScript.Echo "ComputerName             : " & comp
            WScript.Echo "Name                     : " & Product.displayName
            WScript.Echo "ProductType              : " & Provider
            WScript.Echo "ProductExecutable        : " & Product.pathToSignedProductExe
            WScript.Echo "SignedReportingExe       : " & Product.pathToSignedReportingExe
            WScript.Echo "DefinitionStatus         : " & DefinitionStatus
            WScript.Echo "RealTimeProtectionStatus : " & RealTimeProtectionStatus
            WScript.Echo "ProductState             : " & productState
            WScript.Echo 
End Function

OS = FindOSType
if OS <> "N/A" then
            WScript.Echo "Vista/Server 2008 OS or newer detected."
            WScript.Echo
            WScript.Echo 
            strComputer = "."
            Set oWMI = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\SecurityCenter2")
            Set FirewallProducts = oWMI.ExecQuery("Select * from FirewallProduct")
            Set AntispywareProducts = oWMI.ExecQuery("Select * from AntiSpywareProduct")
            Set AntiVirusProducts = oWMI.ExecQuery("Select * from AntiVirusProduct")
            
            
            For Each FirewallProduct in FirewallProducts
                        CodeValue = 1 
                        PrintStatus FirewallProduct, CodeValue
            Next
            
            For Each AntispywareProduct in AntispywareProducts
                        CodeValue = 8
                        PrintStatus AntispywareProduct, CodeValue
            Next
            
            For Each AntiVirusProduct in AntiVirusProducts
                        CodeValue = 4 
                        PrintStatus AntiVirusProduct, CodeValue
            Next
            
End If   


