/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.spi;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.joran.action.Action;
import com.eg.ch.qos.logback.core.joran.action.ImplicitAction;
import com.eg.ch.qos.logback.core.joran.event.BodyEvent;
import com.eg.ch.qos.logback.core.joran.event.EndEvent;
import com.eg.ch.qos.logback.core.joran.event.StartEvent;
import com.eg.ch.qos.logback.core.joran.spi.ActionException;
import com.eg.ch.qos.logback.core.joran.spi.CAI_WithLocatorSupport;
import com.eg.ch.qos.logback.core.joran.spi.ElementPath;
import com.eg.ch.qos.logback.core.joran.spi.EventPlayer;
import com.eg.ch.qos.logback.core.joran.spi.InterpretationContext;
import com.eg.ch.qos.logback.core.joran.spi.RuleStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private static List<Action> EMPTY_LIST = new Vector<Action>(0);
    private final RuleStore ruleStore;
    private final InterpretationContext interpretationContext;
    private final ArrayList<ImplicitAction> implicitActions;
    private final CAI_WithLocatorSupport cai;
    private ElementPath elementPath;
    Locator locator;
    EventPlayer eventPlayer;
    Stack<List<Action>> actionListStack;
    ElementPath skip = null;

    public Interpreter(Context context, RuleStore ruleStore, ElementPath elementPath) {
        this.cai = new CAI_WithLocatorSupport(context, this);
        this.ruleStore = ruleStore;
        this.interpretationContext = new InterpretationContext(context, this);
        this.implicitActions = new ArrayList(3);
        this.elementPath = elementPath;
        this.actionListStack = new Stack();
        this.eventPlayer = new EventPlayer(this);
    }

    public EventPlayer getEventPlayer() {
        return this.eventPlayer;
    }

    public void setInterpretationContextPropertiesMap(Map<String, String> map) {
        this.interpretationContext.setPropertiesMap(map);
    }

    public InterpretationContext getExecutionContext() {
        return this.getInterpretationContext();
    }

    public InterpretationContext getInterpretationContext() {
        return this.interpretationContext;
    }

    public void startDocument() {
    }

    public void startElement(StartEvent startEvent) {
        this.setDocumentLocator(startEvent.getLocator());
        this.startElement(startEvent.namespaceURI, startEvent.localName, startEvent.qName, startEvent.attributes);
    }

    private void startElement(String string, String string2, String string3, Attributes attributes) {
        String string4 = this.getTagName(string2, string3);
        this.elementPath.push(string4);
        if (this.skip != null) {
            this.pushEmptyActionList();
            return;
        }
        List<Action> list = this.getApplicableActionList(this.elementPath, attributes);
        if (list != null) {
            this.actionListStack.add(list);
            this.callBeginAction(list, string4, attributes);
        } else {
            this.pushEmptyActionList();
            String string5 = "no applicable action for [" + string4 + "], current ElementPath  is [" + this.elementPath + "]";
            this.cai.addError(string5);
        }
    }

    private void pushEmptyActionList() {
        this.actionListStack.add(EMPTY_LIST);
    }

    public void characters(BodyEvent bodyEvent) {
        this.setDocumentLocator(bodyEvent.locator);
        String string = bodyEvent.getText();
        List<Action> list = this.actionListStack.peek();
        if (string != null && (string = string.trim()).length() > 0) {
            this.callBodyAction(list, string);
        }
    }

    public void endElement(EndEvent endEvent) {
        this.setDocumentLocator(endEvent.locator);
        this.endElement(endEvent.namespaceURI, endEvent.localName, endEvent.qName);
    }

    private void endElement(String string, String string2, String string3) {
        List<Action> list = this.actionListStack.pop();
        if (this.skip != null) {
            if (this.skip.equals(this.elementPath)) {
                this.skip = null;
            }
        } else if (list != EMPTY_LIST) {
            this.callEndAction(list, this.getTagName(string2, string3));
        }
        this.elementPath.pop();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    String getTagName(String string, String string2) {
        String string3 = string;
        if (string3 == null || string3.length() < 1) {
            string3 = string2;
        }
        return string3;
    }

    public void addImplicitAction(ImplicitAction implicitAction) {
        this.implicitActions.add(implicitAction);
    }

    List<Action> lookupImplicitAction(ElementPath elementPath, Attributes attributes, InterpretationContext interpretationContext) {
        int n2 = this.implicitActions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ImplicitAction implicitAction = this.implicitActions.get(i2);
            if (!implicitAction.isApplicable(elementPath, attributes, interpretationContext)) continue;
            ArrayList<Action> arrayList = new ArrayList<Action>(1);
            arrayList.add(implicitAction);
            return arrayList;
        }
        return null;
    }

    List<Action> getApplicableActionList(ElementPath elementPath, Attributes attributes) {
        List<Action> list = this.ruleStore.matchActions(elementPath);
        if (list == null) {
            list = this.lookupImplicitAction(elementPath, attributes, this.interpretationContext);
        }
        return list;
    }

    void callBeginAction(List<Action> list, String string, Attributes attributes) {
        if (list == null) {
            return;
        }
        for (Action action : list) {
            try {
                action.begin(this.interpretationContext, string, attributes);
            }
            catch (ActionException actionException) {
                this.skip = this.elementPath.duplicate();
                this.cai.addError("ActionException in Action for tag [" + string + "]", actionException);
            }
            catch (RuntimeException runtimeException) {
                this.skip = this.elementPath.duplicate();
                this.cai.addError("RuntimeException in Action for tag [" + string + "]", runtimeException);
            }
        }
    }

    private void callBodyAction(List<Action> list, String string) {
        if (list == null) {
            return;
        }
        for (Action action : list) {
            try {
                action.body(this.interpretationContext, string);
            }
            catch (ActionException actionException) {
                this.cai.addError("Exception in end() methd for action [" + action + "]", actionException);
            }
        }
    }

    private void callEndAction(List<Action> list, String string) {
        if (list == null) {
            return;
        }
        for (Action action : list) {
            try {
                action.end(this.interpretationContext, string);
            }
            catch (ActionException actionException) {
                this.cai.addError("ActionException in Action for tag [" + string + "]", actionException);
            }
            catch (RuntimeException runtimeException) {
                this.cai.addError("RuntimeException in Action for tag [" + string + "]", runtimeException);
            }
        }
    }

    public RuleStore getRuleStore() {
        return this.ruleStore;
    }
}

