/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3.event;

import com.eg.org.apache.commons.lang3.reflect.MethodUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventUtils {
    public static <L> void addEventListener(Object object, Class<L> clazz, L l2) {
        try {
            MethodUtils.invokeMethod(object, "add" + clazz.getSimpleName(), l2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Class " + object.getClass().getName() + " does not have a public add" + clazz.getSimpleName() + " method which takes a parameter of type " + clazz.getName() + ".");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Class " + object.getClass().getName() + " does not have an accessible add" + clazz.getSimpleName() + " method which takes a parameter of type " + clazz.getName() + ".");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Unable to add listener.", invocationTargetException.getCause());
        }
    }

    public static <L> void bindEventsToMethod(Object object, String string, Object object2, Class<L> clazz, String ... stringArray) {
        L l2 = clazz.cast(Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new EventBindingInvocationHandler(object, string, stringArray)));
        EventUtils.addEventListener(object2, clazz, l2);
    }

    private static class EventBindingInvocationHandler
    implements InvocationHandler {
        private final Object target;
        private final String methodName;
        private final Set<String> eventTypes;

        EventBindingInvocationHandler(Object object, String string, String[] stringArray) {
            this.target = object;
            this.methodName = string;
            this.eventTypes = new HashSet<String>(Arrays.asList(stringArray));
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (this.eventTypes.isEmpty() || this.eventTypes.contains(method.getName())) {
                if (this.hasMatchingParametersMethod(method)) {
                    return MethodUtils.invokeMethod(this.target, this.methodName, objectArray);
                }
                return MethodUtils.invokeMethod(this.target, this.methodName);
            }
            return null;
        }

        private boolean hasMatchingParametersMethod(Method method) {
            return MethodUtils.getAccessibleMethod(this.target.getClass(), this.methodName, method.getParameterTypes()) != null;
        }
    }
}

