/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import java.io.File;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxTmpFile {
    private String fileName = null;
    private int refCount = 0;
    private String locale = null;

    IfxTmpFile(String string, IfxConnection ifxConnection) throws SQLException {
        this.setConnection(ifxConnection);
        try {
            File file = new File(string);
            this.fileName = file.getPath();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.locale);
        }
        this.refCount = 0;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected synchronized int incRefCount() {
        ++this.refCount;
        return this.refCount;
    }

    protected synchronized void close() {
        if (this.refCount == 0) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                File file = new File(this.fileName);
                file.delete();
            }
            catch (Exception exception) {}
        } else {
            --this.refCount;
        }
    }

    private void setConnection(IfxConnection ifxConnection) {
        if (ifxConnection != null) {
            this.locale = ifxConnection.getclLocale();
        }
    }
}

