/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.CallableStatement;
import com.thinweb.tds.ConnectionHelper;
import com.thinweb.tds.Constructors;
import com.thinweb.tds.DatabaseMetaData;
import com.thinweb.tds.PreparedStatement;
import com.thinweb.tds.ResultSet;
import com.thinweb.tds.SQLWarningChain;
import com.thinweb.tds.Statement;
import com.thinweb.tds.Tds;
import com.thinweb.tds.TdsException;
import com.thinweb.tds.TdsInstance;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class Connection
implements ConnectionHelper,
java.sql.Connection {
    String host = null;
    int serverType = -1;
    int port = -1;
    String database = null;
    Properties initialProps = null;
    public Vector tdsPool = null;
    DatabaseMetaData databaseMetaData = null;
    public Vector allStatements = null;
    boolean autoCommit = true;
    int transactionIsolationLevel = 2;
    boolean isClosed = false;
    private SQLWarningChain warningChain;
    boolean isReadOnly = false;
    Tds tds;
    String productVersion = null;
    boolean isClosing = false;
    String databaseOwner = null;

    public Connection(Properties properties) throws SQLException, TdsException {
        this.host = properties.getProperty("HOST");
        this.serverType = Integer.parseInt(properties.getProperty("SERVERTYPE"));
        this.port = Integer.parseInt(properties.getProperty("PORT"));
        this.database = properties.getProperty("DBNAME");
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("password");
        this.initialProps = properties;
        this.warningChain = new SQLWarningChain();
        this.isReadOnly = false;
        if (string == null || string2 == null) {
            throw new SQLException("Need a username and password");
        }
        if (this.tdsPool == null) {
            this.tdsPool = new Vector(20);
        }
        if (this.allStatements == null) {
            this.allStatements = new Vector(2);
        }
        try {
            Tds tds = this.allocateTds();
            this.freeTds(tds);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLException("Unknown host");
        }
        catch (IOException iOException) {
            throw new SQLException("Network error in Connection constructor- " + iOException.getMessage());
        }
    }

    private synchronized Tds allocateTds() throws SQLException, UnknownHostException, TdsException, IOException {
        Tds tds;
        int n = this.findAnAvailableTds();
        if (n == -1) {
            tds = null;
            try {
                tds = new Tds(this, this.initialProps, this.sqlStatementForSettings());
            }
            catch (SQLException sQLException) {
                throw new SQLException(sQLException.getMessage() + "\n" + this.tdsPool.size() + " connection are in use by this program");
            }
            TdsInstance tdsInstance = new TdsInstance(tds);
            this.tdsPool.addElement(tdsInstance);
            n = this.findAnAvailableTds();
        }
        if (n == -1) {
            throw new TdsException("Internal Error.  Couldn't get tds instance");
        }
        if (((TdsInstance)this.tdsPool.elementAt((int)n)).inUse) {
            throw new TdsException("Internal Error.  tds " + n + " is already allocated");
        }
        ((TdsInstance)this.tdsPool.elementAt((int)n)).inUse = true;
        tds = ((TdsInstance)this.tdsPool.elementAt((int)n)).tds;
        tds.changeSettings(null, this.sqlStatementForSettings());
        return tds;
    }

    public void clearWarnings() throws SQLException {
        this.warningChain.clearWarnings();
    }

    public void close() throws SQLException {
        this.isClosing = true;
        int n = 0;
        while (n < this.allStatements.size()) {
            Statement statement = (Statement)this.allStatements.elementAt(n);
            statement.close();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.tdsPool.size()) {
            try {
                ((TdsInstance)this.tdsPool.elementAt((int)n2)).tds.close();
            }
            catch (Exception exception) {
                throw new SQLException("Error closing socket" + exception.getMessage());
            }
            ++n2;
        }
        this.clearWarnings();
        this.isClosed = true;
    }

    public void commit() throws SQLException {
        this.commitOrRollback(true);
    }

    private void commitOrRollback(boolean bl) throws SQLException {
        SQLException sQLException = null;
        int n = 0;
        while (n < this.allStatements.size()) {
            Statement statement = (Statement)this.allStatements.elementAt(n);
            try {
                if (bl) {
                    statement.commit();
                } else {
                    statement.rollback();
                }
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            catch (IOException iOException) {
                sQLException = new SQLException(iOException.getMessage());
            }
            catch (TdsException tdsException) {
                sQLException = new SQLException(tdsException.getMessage());
            }
            ++n;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    private int findAnAvailableTds() {
        int n = this.tdsPool.size() - 1;
        while (n >= 0 && ((TdsInstance)this.tdsPool.elementAt((int)n)).inUse) {
            --n;
        }
        return n;
    }

    private void freeTds(Tds tds) throws TdsException {
        int n = -1;
        while (++n < this.tdsPool.size() && tds != ((TdsInstance)this.tdsPool.elementAt((int)n)).tds) {
        }
        if (n >= this.tdsPool.size()) {
            throw new TdsException("Tried to free a tds that wasn't in use");
        }
        this.tdsPool.removeElementAt(n);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        return this.database;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getProductVersion() throws SQLException {
        if (this.productVersion != null) {
            return this.productVersion;
        }
        String string = this.getDatabase();
        this.setCatalog("master");
        Statement statement = (Statement)this.createStatement();
        ResultSet resultSet = null;
        resultSet = (ResultSet)statement.executeQuery("exec xp_msver ProductVersion");
        resultSet.next();
        this.setCatalog(string);
        statement.close();
        return resultSet.getString(4);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolationLevel;
    }

    public String getUrl() {
        if (this.serverType != 2) {
            return "jdbc:twtds:sqlserver://" + this.host + ":" + this.port + "/" + this.database;
        }
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.warningChain != null) {
            return this.warningChain.getWarnings();
        }
        return null;
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void markAsClosed(Statement statement) throws TdsException {
        if (!this.allStatements.removeElement(statement)) {
            throw new TdsException("Statement was not known by the connection");
        }
    }

    public String nativeSQL(String string) throws SQLException {
        return null;
    }

    protected void NotImplemented() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void relinquish(Tds tds) throws TdsException {
        this.freeTds(tds);
    }

    public void rollback() throws SQLException {
        this.commitOrRollback(false);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        String string = null;
        this.autoCommit = bl;
        string = this.sqlStatementToSetCommit();
        int n = 0;
        while (n < this.allStatements.size()) {
            Statement statement = (Statement)this.allStatements.elementAt(n);
            statement.execute(string);
            ++n;
        }
    }

    public void setCatalog(String string) throws SQLException {
        ((Hashtable)this.initialProps).put("DBNAME", string);
        this.tds.changeDB(string);
        this.tds.database = string;
        this.database = string;
    }

    public void setProductVersion(String string) {
        this.productVersion = string;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.isReadOnly = bl;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolationLevel = n;
        String string = this.sqlStatementToSetTransactionIsolationLevel();
        int n2 = 0;
        while (n2 < this.allStatements.size()) {
            Statement statement = (Statement)this.allStatements.elementAt(n2);
            statement.execute(string);
            ++n2;
        }
    }

    protected String sqlStatementForSettings() throws SQLException {
        return this.sqlStatementToInitialize() + " " + this.sqlStatementToSetTransactionIsolationLevel() + " " + this.sqlStatementToSetCommit();
    }

    protected String sqlStatementToInitialize() {
        return this.serverType != 2 ? "" : "set quoted_identifier on set textsize 50000";
    }

    protected String sqlStatementToSetCommit() {
        String string = this.serverType == 2 ? (this.autoCommit ? "set CHAINED off " : "set CHAINED on ") : (this.autoCommit ? "set implicit_transactions off " : "set implicit_transactions on ");
        return string;
    }

    protected String sqlStatementToSetTransactionIsolationLevel() throws SQLException {
        String string;
        block13: {
            block12: {
                string = "set transaction isolation level ";
                if (this.serverType != 2) break block12;
                switch (this.transactionIsolationLevel) {
                    case 1: {
                        throw new SQLException("Bad transaction level");
                    }
                    case 2: {
                        string = string + "1";
                        break block13;
                    }
                    case 4: {
                        throw new SQLException("Bad transaction level");
                    }
                    case 8: {
                        string = string + "3";
                        break block13;
                    }
                    default: {
                        throw new SQLException("Bad transaction level");
                    }
                }
            }
            switch (this.transactionIsolationLevel) {
                case 1: {
                    string = string + " read uncommitted ";
                    break;
                }
                case 2: {
                    string = string + " read committed ";
                    break;
                }
                case 4: {
                    string = string + " repeatable read ";
                    break;
                }
                case 8: {
                    string = string + " serializable ";
                }
                default: {
                    throw new SQLException("Bad transaction level");
                }
            }
        }
        return string;
    }

    public java.sql.Statement createStatement() throws SQLException {
        Tds tds = null;
        try {
            this.tds = tds = this.allocateTds();
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        Statement statement = new Statement(this, tds);
        this.allStatements.addElement(statement);
        return statement;
    }

    public java.sql.Statement createStatement(int n, int n2) throws SQLException {
        Statement statement = (Statement)this.createStatement();
        statement.setResultSetType(n);
        statement.setResultSetConcurrency(n2);
        return statement;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new DatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    public void markAsClosed(java.sql.Statement statement) throws TdsException {
        if (!this.allStatements.removeElement(statement)) {
            throw new TdsException("Statement was not known by the connection");
        }
    }

    public boolean isClosingConn() {
        return this.isClosing;
    }

    public Map getTypeMap() throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.NotImplemented();
    }

    public java.sql.CallableStatement prepareCall(String string) throws SQLException {
        Tds tds = null;
        try {
            tds = this.allocateTds();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        CallableStatement callableStatement = Constructors.newCallableStatement(this, tds, Tds.toNativeSql(string, this.tds.getServerType()));
        this.allStatements.addElement(callableStatement);
        try {
            this.databaseMetaData = (DatabaseMetaData)this.getMetaData();
            this.setProductVersion(this.databaseMetaData.getDatabaseProductVersion());
        }
        catch (Exception exception) {
            throw new SQLException("Error retrieving database version info: " + exception.getMessage());
        }
        return callableStatement;
    }

    public java.sql.CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement = (CallableStatement)this.prepareCall(string);
        callableStatement.setResultSetType(n);
        callableStatement.setResultSetConcurrency(n2);
        return callableStatement;
    }

    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        Tds tds = null;
        try {
            tds = this.allocateTds();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        PreparedStatement preparedStatement = Constructors.newPreparedStatement(this, tds, string);
        this.allStatements.addElement(preparedStatement);
        try {
            this.databaseMetaData = (DatabaseMetaData)this.getMetaData();
            this.setProductVersion(this.databaseMetaData.getDatabaseProductVersion());
        }
        catch (Exception exception) {
            throw new SQLException("Error retrieving database version info: " + exception.getMessage());
        }
        return preparedStatement;
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        Statement statement = (Statement)((Object)this.prepareStatement(string));
        this.databaseMetaData = (DatabaseMetaData)this.getMetaData();
        this.setProductVersion(this.databaseMetaData.getDatabaseProductVersion());
        statement.setResultSetType(n);
        statement.setResultSetConcurrency(n2);
        return (PreparedStatement)statement;
    }
}

