/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.JDBCResourceMBean;
import org.jboss.management.j2ee.StateManagement;

public class JDBCResource
extends J2EEResource
implements JDBCResourceMBean {
    private static Logger log = Logger.getLogger((Class)JDBCResource.class);
    private StateManagement mState;
    private ObjectName mService;
    private List mDataSources = new ArrayList();

    public static ObjectName create(MBeanServer mbeanServer, String resName) {
        ObjectName lServer = null;
        try {
            lServer = mbeanServer.queryNames(new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
        }
        catch (Exception e) {
            log.error((Object)"Could not find parent J2EEServer", (Throwable)e);
            return null;
        }
        try {
            JDBCResource jdbcRes = new JDBCResource(resName, lServer);
            ObjectName jsr77Name = jdbcRes.getObjectName();
            mbeanServer.registerMBean(jdbcRes, jsr77Name);
            log.debug((Object)("Created JSR-77 JDBC Manager: " + resName));
            return jsr77Name;
        }
        catch (Exception e) {
            log.error((Object)"Could not create JSR-77 JDBC Manager", (Throwable)e);
            return null;
        }
    }

    public static void destroy(MBeanServer mbeanServer, String resName) {
        try {
            ObjectName lJDBCResource;
            String[] lDataSources;
            ObjectName lSearch = new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JDBCResource" + "," + "name=" + resName + "," + "*");
            Set<ObjectName> lNames = mbeanServer.queryNames(lSearch, null);
            if (!lNames.isEmpty() && (lDataSources = (String[])mbeanServer.getAttribute(lJDBCResource = lNames.iterator().next(), "jdbcDataSources")).length == 0) {
                mbeanServer.unregisterMBean(lJDBCResource);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not destroy JSR-77 JDBC Manager", (Throwable)e);
        }
    }

    public JDBCResource(String resName, ObjectName pServer) throws MalformedObjectNameException, InvalidParentException {
        super("JDBCResource", resName, pServer);
        this.mState = new StateManagement(this);
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public String getStateString() {
        return this.mState.getStateString();
    }

    public void mejbStart() {
        this.mState.setState(4);
        this.mState.setState(5);
    }

    public void mejbStartRecursive() {
        this.mState.setState(3);
        Iterator i = this.mDataSources.iterator();
        String lDataSource = null;
        while (i.hasNext()) {
            lDataSource = (String)i.next();
            try {
                this.getServer().invoke(JDBCResource.newObjectName(lDataSource), "mejbStart", new Object[0], new String[0]);
            }
            catch (JMException jme) {
                this.getLog().error((Object)("Could not start JSR-77 JDBC-DataSource: " + lDataSource), (Throwable)jme);
            }
        }
        this.mState.setState(2);
    }

    public void mejbStop() {
        this.mState.setState(3);
        Iterator i = this.mDataSources.iterator();
        while (i.hasNext()) {
            String lDataSource = (String)i.next();
            try {
                this.getServer().invoke(JDBCResource.newObjectName(lDataSource), "mejbStop", new Object[0], new String[0]);
            }
            catch (JMException jme) {
                this.getLog().error((Object)("Could not stop JSR-77 JDBC-DataSource: " + lDataSource), (Throwable)jme);
            }
        }
        this.mState.setState(2);
    }

    public void postCreation() {
        this.sendNotification("j2ee.object.deleted", "JDBC Resource Resource deleted");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.created", "JDBC Resource Resource created");
    }

    public String[] getjdbcDataSources() {
        return this.mDataSources.toArray(new String[this.mDataSources.size()]);
    }

    public String getjdbcDataSource(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mDataSources.size()) {
            return (String)this.mDataSources.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("JDBCDataSource".equals(lType)) {
            this.mDataSources.add(pChild.getCanonicalName());
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("JDBCDataSource".equals(lType)) {
            this.mDataSources.remove(pChild.getCanonicalName());
        }
    }

    public String toString() {
        return "JDBCResource { " + super.toString() + " } [ " + "Datasources: " + this.mDataSources + " ]";
    }
}

