/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.ServletMBean;
import org.jboss.management.j2ee.statistics.ServletStatsImpl;
import org.jboss.management.j2ee.statistics.TimeStatisticImpl;

public class Servlet
extends J2EEManagedObject
implements ServletMBean {
    private static Logger log = Logger.getLogger((Class)Servlet.class);
    private ObjectName servletServiceName;
    private ServletStatsImpl stats;

    public static ObjectName create(MBeanServer mbeanServer, ObjectName webModuleName, ObjectName webContainerName, ObjectName servletServiceName) {
        try {
            Servlet servlet = new Servlet(servletServiceName, webModuleName, webContainerName);
            ObjectName jsr77Name = servlet.getObjectName();
            mbeanServer.registerMBean(servlet, jsr77Name);
            log.debug((Object)("Created JSR-77 Servlet: " + jsr77Name));
            return jsr77Name;
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 Servlet: " + servletServiceName), (Throwable)e);
            return null;
        }
    }

    public static void destroy(MBeanServer mbeanServer, ObjectName jsr77Name) {
        try {
            mbeanServer.unregisterMBean(jsr77Name);
            log.debug((Object)("Destroyed JSR-77 Servlet: " + jsr77Name));
        }
        catch (InstanceNotFoundException ignore) {
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 Servlet: " + jsr77Name), (Throwable)e);
        }
    }

    public Servlet(ObjectName servletServiceName, ObjectName webModuleName, ObjectName webContainerName) throws MalformedObjectNameException, InvalidParentException {
        super("Servlet", servletServiceName.getKeyProperty("name"), webModuleName);
        this.servletServiceName = servletServiceName;
        this.stats = new ServletStatsImpl();
    }

    public Stats getstats() {
        try {
            TimeStatisticImpl serviceTime = (TimeStatisticImpl)this.stats.getServiceTime();
            Integer count = (Integer)this.server.getAttribute(this.servletServiceName, "requestCount");
            Long totalTime = (Long)this.server.getAttribute(this.servletServiceName, "processingTime");
            Long minTime = (Long)this.server.getAttribute(this.servletServiceName, "minTime");
            Long maxTime = (Long)this.server.getAttribute(this.servletServiceName, "maxTime");
            serviceTime.set(count.longValue(), minTime, maxTime, totalTime);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retrieve stats", (Throwable)e);
        }
        return this.stats;
    }

    public void resetStats() {
        this.stats.reset();
    }

    public String toString() {
        return "Servlet { " + super.toString() + " } []";
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("WebModule", lProperties.get("name"));
        lReturn.put("J2EEApplication", lProperties.get("J2EEApplication"));
        lReturn.put("J2EEServer", lProperties.get("J2EEServer"));
        return lReturn;
    }
}

