/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.SessionBean;
import org.jboss.management.j2ee.StatefulSessionBeanMBean;
import org.jboss.management.j2ee.statistics.RangeStatisticImpl;
import org.jboss.management.j2ee.statistics.StatefulSessionBeanStatsImpl;

public class StatefulSessionBean
extends SessionBean
implements StatefulSessionBeanMBean {
    private static Logger log = Logger.getLogger((Class)StatefulSessionBean.class);
    private StatefulSessionBeanStatsImpl stats = new StatefulSessionBeanStatsImpl();

    public StatefulSessionBean(String name, ObjectName ejbModuleName, ObjectName ejbContainerName) throws MalformedObjectNameException, InvalidParentException {
        this(name, ejbModuleName, ejbContainerName, null, null);
    }

    public StatefulSessionBean(String name, ObjectName ejbModuleName, ObjectName ejbContainerName, String jndiName, String localJndiName) throws MalformedObjectNameException, InvalidParentException {
        super("StatefulSessionBean", name, ejbModuleName, ejbContainerName, jndiName, localJndiName);
    }

    public Stats getstats() {
        try {
            this.updateCommonStats(this.stats);
            ObjectName poolName = this.getContainerPoolName();
            RangeStatisticImpl readyCount = (RangeStatisticImpl)this.stats.getMethodReadyCount();
            Integer poolSize = (Integer)this.server.getAttribute(poolName, "CurrentSize");
            readyCount.set(poolSize.longValue());
            ObjectName cacheName = this.getContainerCacheName();
            RangeStatisticImpl passiveCount = (RangeStatisticImpl)this.stats.getPassiveCount();
            Long passive = (Long)this.server.getAttribute(cacheName, "PassivatedCount");
            passiveCount.set(passive);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retrieve stats", (Throwable)e);
        }
        return this.stats;
    }

    public void resetStats() {
        this.stats.reset();
    }

    public String toString() {
        return "StatefulSessionBean { " + super.toString() + " } []";
    }
}

