/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import oracle.dms.http.Request;
import oracle.dms.spy.Spy;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Indentation;

public abstract class Reporter {
    public static final String TEXT_HTML = "text/html; charset=UTF-8";
    public static final String TEXT_PLAIN = "text/plain; charset=UTF-8";
    public static final String VERSION_1013 = "10.1.3";
    public static final int[] VERSION_NUMS_1013 = new int[]{10, 1, 3};
    public static final String VERSION_904 = "9.0.4";
    public static final int[] VERSION_NUMS_904 = new int[]{9, 0, 4};
    protected static final int DEFAULT_NUM_BADS = 7;
    protected static final int DEFAULT_NUM_SYS_TABLES = 5;
    protected static final byte RESET = 1;
    protected static final byte SET = 2;
    protected static final byte GET = 3;
    protected static final byte INCLUDE_NO_DESCENDANTS = 0;
    protected static final byte INCLUDE_ALL_DESCENDANTS = 1;
    protected static final byte INCLUDE_CHILDREN = 2;
    protected Request m_request = null;
    protected Indentation m_indent = new Indentation();
    protected boolean m_includeDescriptions = true;
    protected boolean m_includeUnits = true;
    protected boolean m_includeValues = true;
    protected boolean m_isOrdered = false;
    protected byte m_op = (byte)3;
    protected int m_id = 0;
    protected String m_name = null;
    protected static final Logger LOGGER = Logger.getLogger("oracle.dms.reporter");

    protected Reporter(Request request) {
        if (request == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ": request=" + request);
        }
        this.m_request = request;
        this.m_id = DMSUtil.getProcessID();
        this.m_name = Spy.getName();
        this.m_op = this.m_request.isOperation("reset") ? (byte)1 : (this.m_request.isOperation("set") ? (byte)2 : (byte)3);
    }

    public abstract void printResponse(PrintWriter var1);

    public String getContentType() {
        return TEXT_PLAIN;
    }

    public abstract void clear();

    protected void printBadParams(Collection collection, Collection collection2, PrintWriter printWriter) {
        Iterator iterator;
        if (!(collection != null && collection.size() != 0 || collection2 != null && collection2.size() != 0)) {
            return;
        }
        printWriter.print("<bad_parameters>\n");
        if (collection != null && collection.size() > 0) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                printWriter.print("<name>");
                printWriter.print(iterator.next());
                printWriter.print("</name>\n");
            }
        }
        if (collection2 != null && collection2.size() > 0) {
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                printWriter.print("<nountype>");
                printWriter.print(iterator.next());
                printWriter.print("</nountype>\n");
            }
        }
        printWriter.print("</bad_parameters>\n");
    }
}

