/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Date;
import oracle.dms.http.Request;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.Tracer;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.TreeletReporter;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class TransTraceReporter
extends TreeletReporter {
    public TransTraceReporter(Request request) {
        super(request);
    }

    void printHeading(PrintWriter printWriter) {
        printWriter.print("<?xml version='1.0'?>\n<!DOCTYPE transtrace>\n<transtrace version='");
        printWriter.print("9.0.4");
        printWriter.print("' id='");
        printWriter.print(this.m_id);
        printWriter.print("' host='");
        printWriter.print(DMSUtil.getLocalHostname());
        printWriter.print("' name='");
        printWriter.print(this.m_name);
        printWriter.print("' timestamp='");
        long l = System.currentTimeMillis();
        printWriter.print(l);
        printWriter.print(" (");
        printWriter.print(new Date(l));
        printWriter.print(")'>\n");
    }

    void printEnding(PrintWriter printWriter) {
        printWriter.print("</transtrace>\n");
    }

    void startPrintNounNode(NounTreeletNode nounTreeletNode, PrintWriter printWriter) {
        printWriter.print("<noun name='");
        printWriter.print(nounTreeletNode.getName());
        printWriter.print("' type='");
        printWriter.print(nounTreeletNode.getTable());
        printWriter.print("'>\n");
    }

    void printMetricNode(MetricTreeletNode metricTreeletNode, PrintWriter printWriter) {
        Sensor sensor = ((Metric)metricTreeletNode.m_mappedNode).getSensor();
        if (sensor instanceof Tracer) {
            printWriter.print("<trace ");
            printWriter.print(" name='");
            printWriter.print(sensor.getName());
            printWriter.print('\'');
            printWriter.print(">\n");
            printWriter.print(((Tracer)sensor).getTraceString());
            printWriter.print("</trace>\n");
        }
    }

    void endPrintNounNode(NounTreeletNode nounTreeletNode, PrintWriter printWriter) {
        printWriter.print("</noun>\n");
    }
}

