/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.ApplicationAdminCommandBase;
import java.util.List;

public class ApplicationStopCommand
extends ApplicationAdminCommandBase {
    private static final String TIMEOUT = "-timeout";
    private static final String FORCE = "-graceful";
    private int timeout = -1;
    private boolean graceful = true;
    private static final String STOP_CMD = "Application stop command";

    public ApplicationStopCommand(List args) throws AdminCommandException {
        super(args);
        if (args.isEmpty()) {
            this.timeout = 0;
            return;
        }
        while (!args.isEmpty()) {
            String arg;
            String command = (String)args.remove(0);
            if (command.equals(TIMEOUT)) {
                if (!args.isEmpty()) {
                    arg = (String)args.remove(0);
                    try {
                        this.timeout = Integer.valueOf(arg);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new AdminCommandException("Application stop command: " + arg + ", Invalid value for \"-timeout\" option. " + "Valid values are positive integer values", 14);
                    }
                }
                throw new AdminCommandException("Application stop command: Value missing for \"-timeout\" option", 11);
            }
            if (command.equals(FORCE)) {
                if (!args.isEmpty()) {
                    arg = (String)args.remove(0);
                    if (arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("false")) {
                        this.graceful = Boolean.valueOf(arg);
                        continue;
                    }
                    throw new AdminCommandException("Application stop command: " + arg + ", Invalid value for \"graceful\" option. Valid values are [true|false]");
                }
                throw new AdminCommandException("Application stop command: Value missing for \"-graceful\" option");
            }
            throw new AdminCommandException("Application stop command: Invalid option \"" + command + "\" \n" + "Command syntax: -application <application name> -stop [-timeout <time in seconds> | -graceful [true|false]]");
        }
    }

    protected void doIt() throws AdminCommandException {
        AdminCommandException ace = null;
        try {
            int result = this._admin.stopApplication(this._appName, this.timeout, this.graceful);
            switch (result) {
                case 0: {
                    ace = new AdminCommandException("Application: " + this._appName + " stopped successfully", 0);
                    break;
                }
                case 1: {
                    ace = new AdminCommandException("Application: " + this._appName + " was forcefully stopped, as graceful stop timed out", 39);
                }
            }
        }
        catch (Exception e) {
            ace = new AdminCommandException("Stop of Application: " + this._appName + " failed - \n" + e.getMessage(), 1);
        }
        throw ace;
    }

    public int getTimeoutValue() {
        return this.timeout;
    }

    public boolean getGracefulValue() {
        return this.graceful;
    }

    public String getApplicationName() {
        return this._appName;
    }
}

