/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.ApplicationAdminCommandBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CopyTableCommand
extends ApplicationAdminCommandBase {
    private Map _fromParams;
    private Map _toParams;

    public CopyTableCommand(List args) throws AdminCommandException {
        super(args);
        String fromTable = null;
        String toTable = null;
        String fromSource = null;
        String toSource = null;
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-copyTable subcommand");
            if (command.equals("-fromTable")) {
                fromTable = this.getNextArgument("origin table name");
                continue;
            }
            if (command.equals("-fromSource")) {
                fromSource = this.getNextArgument("origin source name ");
                continue;
            }
            if (command.equals("-toTable")) {
                toTable = this.getNextArgument("target table name");
                continue;
            }
            if (!command.equals("-toSource")) continue;
            toSource = this.getNextArgument("target source name");
        }
        this.checkArgIsNull(fromSource, "-fromSource");
        this.checkArgIsNull(fromTable, "-fromTable");
        if (toTable == null) {
            toTable = fromTable;
        }
        if (toSource == null) {
            toSource = fromSource;
        }
        if (toTable == fromTable && toSource == fromSource) {
            throw new AdminCommandException("Destination table and datasource cannot be the same as the origin datasource and table", 18);
        }
        this._fromParams = new HashMap();
        this._toParams = new HashMap();
        this._fromParams.put("<table-name>", fromTable);
        this._toParams.put("<table-name>", toTable);
        this._fromParams.put("<data-source>", fromSource);
        this._toParams.put("<data-source>", toSource);
    }

    protected void doIt() throws AdminCommandException {
        try {
            this._appAdmin.copyTable(this._fromParams, this._toParams);
        }
        catch (Exception e) {
            throw new AdminCommandException(e, "Error CopyTableCommand: " + e.getMessage(), 19);
        }
    }
}

