/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.ejb;

import com.evermind.ejb.EJBUser;
import com.evermind.ejb.EJBUserHome;
import com.evermind.ejb.EJBUserWrapper;
import com.evermind.security.AbstractUserManager;
import com.evermind.security.User;
import com.evermind.util.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EJBUserManager
extends AbstractUserManager {
    protected EJBHome home;
    protected Method findMethod;
    protected Method findAllMethod;
    protected Method findByCertificateMethod;
    protected Method createMethod;

    public void init(Properties properties) throws InstantiationException {
        try {
            InitialContext context = new InitialContext();
            String location = properties.getProperty("home");
            if (location == null) {
                throw new InstantiationException("No home specified");
            }
            try {
                this.home = (EJBHome)context.lookup(location);
                try {
                    this.findMethod = this.home.getClass().getMethod("findByUsername", String.class);
                    if (!EJBUser.class.isAssignableFrom(this.findMethod.getReturnType())) {
                        throw new InstantiationException("The specified EJB does not consist of EJBUser instances");
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (this.findMethod == null) {
                    try {
                        this.findMethod = this.home.getClass().getMethod("findByPrimaryKey", String.class);
                        if (!EJBUser.class.isAssignableFrom(this.findMethod.getReturnType())) {
                            throw new InstantiationException("The specified EJB does not consist of EJBUser instances");
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new InstantiationException("The home interface '" + this.home.getClass().getName() + "' must have a findByPrimaryKey(String username) or findByUsername(String username) method");
                    }
                }
                try {
                    this.findByCertificateMethod = this.home.getClass().getMethod("findByCertificate", String.class, BigInteger.class);
                    if (!EJBUser.class.isAssignableFrom(this.findMethod.getReturnType())) {
                        throw new InstantiationException("The specified EJB does not consist of EJBUser instances");
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                try {
                    this.createMethod = this.home.getClass().getMethod("create", String.class, String.class);
                    if (!EJBUser.class.isAssignableFrom(this.createMethod.getReturnType())) {
                        throw new InstantiationException("The specified EJB does not consist of EJBUser instances");
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new InstantiationException("The home interface '" + this.home.getClass().getName() + "' must have a create(String username, String password) method");
                }
            }
            catch (ClassCastException e) {
                throw new InstantiationException("Not a valid EJBUserHome at " + location);
            }
        }
        catch (NamingException e) {
            throw new InstantiationException("NamingException: " + e.getMessage());
        }
        String defaultGroupsString = properties.getProperty("defaultGroups");
        if (defaultGroupsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(defaultGroupsString, ", ");
            while (tokenizer.hasMoreElements()) {
                this.addDefaultGroup(tokenizer.nextToken());
            }
        }
    }

    public User createUser(String username, String password) {
        try {
            if (this.home instanceof EJBUserHome) {
                return new EJBUserWrapper(this, username, ((EJBUserHome)this.home).create(username, password));
            }
            return new EJBUserWrapper(this, username, (EJBUser)this.createMethod.invoke((Object)this.home, (Object[])new String[]{username, password}));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RemoteException) {
                throw new RuntimeException("RemoteException: " + e.getTargetException().getMessage());
            }
            throw new RuntimeException(e.getTargetException().getClass().getName() + ": " + e.getTargetException().getMessage());
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
        catch (CreateException e) {
            throw new IllegalArgumentException("Error creating user: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public User getUser(String username) {
        Object user;
        if (this.parent != null && (user = this.parent.getUser(username)) != null) {
            return user;
        }
        try {
            user = this.home instanceof EJBUserHome ? ((EJBUserHome)this.home).findByPrimaryKey(username) : (EJBUser)this.findMethod.invoke((Object)this.home, (Object[])new String[]{username});
            return new EJBUserWrapper(this, username, (EJBUser)user);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ObjectNotFoundException || e.getTargetException() instanceof FinderException) {
                return null;
            }
            if (e.getTargetException() instanceof RemoteException) {
                throw new RuntimeException("RemoteException: " + e.getTargetException().getMessage());
            }
            throw new RuntimeException(e.getTargetException().getClass().getName() + ": " + e.getTargetException().getMessage());
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
        catch (FinderException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public boolean remove(User user) {
        try {
            EJBUserWrapper wrapper = (EJBUserWrapper)user;
            try {
                wrapper.user.remove();
                return true;
            }
            catch (RemoteException e) {
                throw new RuntimeException("RemoteException: " + e.getMessage());
            }
            catch (RemoveException e) {
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public User getUser(String issuerDN, BigInteger serial) {
        try {
            EJBUser user;
            if (this.home instanceof EJBUserHome) {
                user = ((EJBUserHome)this.home).findByCertificate(issuerDN, serial);
            } else {
                if (this.findByCertificateMethod == null) {
                    return null;
                }
                user = (EJBUser)this.findByCertificateMethod.invoke((Object)this.home, issuerDN, serial);
            }
            if (user == null) {
                if (this.parent != null) {
                    return this.parent.getUser(issuerDN, serial);
                }
                return null;
            }
            return new EJBUserWrapper(this, null, user);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RemoteException) {
                throw new RuntimeException("RemoteException: " + e.getTargetException().getMessage());
            }
            throw new RuntimeException(e.getTargetException().getClass().getName() + ": " + e.getTargetException().getMessage());
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
        catch (FinderException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public User getUser(X509Certificate certificate) {
        return this.getUser(certificate.getIssuerDN().getName(), certificate.getSerialNumber());
    }

    public int getUserCount() {
        return this.getUserCollection().size();
    }

    private Collection getUserCollection() {
        if (this.findAllMethod == null) {
            try {
                this.findAllMethod = this.home.getClass().getMethod("findAll", ClassUtils.CLASS_NOARGS);
                if (this.findAllMethod.getReturnType() != Collection.class) {
                    throw new UnsupportedOperationException("The EJBHome's findAll method did not return a Collection");
                }
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("No findAll method found: " + e.getMessage());
            }
        }
        try {
            return (Collection)this.findAllMethod.invoke((Object)this.home, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Cannot access the findAll method: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error executing the findAll method: " + e.getTargetException());
        }
    }

    public List getUsers(int start, int length) {
        Collection users = this.getUserCollection();
        ArrayList<EJBUserWrapper> response = new ArrayList<EJBUserWrapper>();
        Iterator iterator = users.iterator();
        while (start > 0 && iterator.hasNext()) {
            iterator.next();
            --start;
        }
        while (length > 0 && iterator.hasNext()) {
            response.add(new EJBUserWrapper(this, null, (EJBUser)iterator.next()));
            --length;
        }
        return response;
    }
}

