/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EchoOutputStream
extends FilterOutputStream {
    protected OutputStream echoOut;
    private boolean debug;

    public EchoOutputStream(OutputStream out, OutputStream echoOut, boolean debug) {
        super(out);
        this.echoOut = echoOut;
        this.debug = debug;
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.debug) {
            System.out.println("out write: " + length);
            new Exception("out.write: " + length).printStackTrace();
        }
        this.out.write(data, offset, length);
        this.echoOut.write(data, offset, length);
    }

    public void write(int i) throws IOException {
        if (this.debug) {
            System.out.println("out single write");
        }
        this.out.write(i);
        this.echoOut.write(i);
    }

    public void close() throws IOException {
        if (this.debug) {
            System.out.println("out close()");
        }
        super.close();
    }

    public void flush() throws IOException {
        if (this.debug) {
            System.out.println("out flush()");
        }
        super.flush();
    }
}

