/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.util.ObjectFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class FileIterator
implements Iterator {
    protected File root;
    protected File[] currentDir;
    protected int pos;
    protected List recursiveFiles = new ArrayList();
    protected List recursivePos = new ArrayList();
    protected File currentFile;
    protected ObjectFilter filter;

    public FileIterator(File root, ObjectFilter filter) {
        this.root = root;
        this.filter = filter;
        this.currentDir = root.listFiles();
        this.nextEntry();
    }

    public boolean hasNext() {
        return this.currentFile != null;
    }

    public void remove() {
        if (this.currentFile == null) {
            throw new NoSuchElementException();
        }
        this.currentFile.delete();
        this.nextEntry();
    }

    public Object next() {
        if (this.currentFile == null) {
            throw new NoSuchElementException();
        }
        File file = this.currentFile;
        this.nextEntry();
        return file;
    }

    protected void nextEntry() {
        do {
            this.nextEntryCore();
        } while (this.currentFile != null && this.filter != null && !this.filter.implies(this.currentFile));
    }

    protected void nextEntryCore() {
        if (this.currentDir == null) {
            this.currentFile = null;
            return;
        }
        while (this.pos >= this.currentDir.length) {
            if (this.recursiveFiles.isEmpty()) {
                this.currentFile = null;
                return;
            }
            this.pos = (Integer)this.recursivePos.remove(this.recursivePos.size() - 1);
            this.currentDir = (File[])this.recursiveFiles.remove(this.recursiveFiles.size() - 1);
        }
        this.currentFile = this.currentDir[this.pos++];
        if (this.currentFile.isDirectory()) {
            this.recursivePos.add(new Integer(this.pos));
            this.recursiveFiles.add(this.currentDir);
            this.currentDir = this.currentFile.listFiles();
            this.pos = 0;
        }
    }
}

