/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.io.PostEntry;
import com.evermind.io.PostFileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class FilePostParser
implements Enumeration {
    private static final int POST_BUFFER_SIZE = 64000;
    InputStream in;
    byte[] buffer;
    int pos;
    int length;
    Object currentValue;
    String boundary;
    boolean eof;
    boolean valueFetched;
    String encoding;

    public static FilePostParser getParser(InputStream in, int length, String encoding) throws IOException {
        return new FilePostParser(in, length, encoding);
    }

    public FilePostParser(InputStream in, int length) throws IOException {
        this(in, length, null);
    }

    public FilePostParser(InputStream in, int length, String encoding) throws IOException {
        this.in = in;
        this.length = length;
        this.encoding = encoding;
        this.readBuffer();
        this.pos = 0;
        this.boundary = this.readAnyLine();
        this.readValue();
    }

    public boolean hasMoreElements() {
        if (this.currentValue == null) {
            return false;
        }
        if (this.valueFetched) {
            this.readValue();
        }
        return this.currentValue != null;
    }

    public Object nextElement() {
        if (this.valueFetched) {
            this.readValue();
        }
        this.valueFetched = true;
        return this.currentValue;
    }

    private void readValue() {
        try {
            String line;
            this.valueFetched = false;
            boolean file = false;
            String name = null;
            String filename = null;
            String contentType = null;
            if (this.currentValue instanceof PostFileInputStream) {
                PostFileInputStream stream = (PostFileInputStream)this.currentValue;
                while (stream.read() != -1) {
                }
                if (!"".equals(this.readLine())) {
                    this.currentValue = null;
                    return;
                }
            }
            while ((line = this.readLine()) != null && !line.equals("")) {
                if (line.toLowerCase().startsWith("content-disposition:")) {
                    int nameIndex = line.indexOf("name=\"");
                    name = line.substring(nameIndex + 6, line.indexOf(34, nameIndex + 6));
                    int filenameIndex = line.indexOf("filename=\"");
                    if (filenameIndex < 0) continue;
                    filename = line.substring(filenameIndex + 10, line.indexOf(34, filenameIndex + 10));
                    continue;
                }
                if (!line.toLowerCase().equals("content-type:")) continue;
                contentType = line.substring(13, line.length()).trim();
            }
            if (line == null) {
                this.currentValue = null;
                return;
            }
            if (filename != null) {
                this.currentValue = new PostFileInputStream(this, this.boundary, name, filename);
            } else {
                String valueLine;
                StringBuffer value = new StringBuffer();
                while ((valueLine = this.readLine()) != null && !valueLine.equals(this.boundary)) {
                    value.append(valueLine);
                    value.append("\r\n");
                }
                String valueString = value.length() >= 2 ? value.substring(0, value.length() - 2) : "";
                this.currentValue = new PostEntry(name, valueString);
                if (line.equals(this.boundary + "--")) {
                    this.eof = true;
                }
            }
        }
        catch (IOException e) {
            this.currentValue = null;
            return;
        }
    }

    private String readLine() throws IOException {
        if (this.eof) {
            return null;
        }
        String line = this.readAnyLine();
        if (!(this.boundary + "--").equals(line) && !"--".equals(line)) {
            return line;
        }
        return null;
    }

    private String readAnyLine() throws IOException {
        int pos = 0;
        int i = 0;
        while ((i = this.read()) != 13) {
            if (i == -1) {
                if (pos != 0) break;
                return null;
            }
            this.buffer[pos++] = (byte)i;
        }
        this.read();
        return this.encoding == null ? new String(this.buffer, 0, pos) : new String(this.buffer, 0, pos, this.encoding);
    }

    void readBuffer() throws IOException {
        this.buffer = this.length > 64000 ? new byte[64000] : new byte[this.length];
        int bytesRead = this.reliableRead(this.buffer, 0, this.buffer.length);
        this.length -= bytesRead;
        if (bytesRead != this.buffer.length) {
            this.length = 0;
            byte[] newBuffer = new byte[bytesRead];
            System.arraycopy(this.buffer, 0, newBuffer, 0, bytesRead);
        }
        this.pos -= this.buffer.length;
    }

    void nextPage(int boundaryLength) throws IOException {
        byte[] oldBuffer = this.buffer;
        this.buffer = this.length > 64000 ? new byte[64000] : new byte[this.length + boundaryLength];
        this.length -= this.buffer.length - boundaryLength;
        System.arraycopy(oldBuffer, oldBuffer.length - boundaryLength, this.buffer, 0, boundaryLength);
        int bytesRead = this.reliableRead(this.buffer, boundaryLength, this.buffer.length - boundaryLength);
        if (bytesRead != this.buffer.length - boundaryLength) {
            this.length = 0;
            byte[] newBuffer = new byte[bytesRead + boundaryLength];
            System.arraycopy(this.buffer, 0, newBuffer, boundaryLength, bytesRead);
        }
        this.pos -= oldBuffer.length - boundaryLength;
    }

    int read() throws IOException {
        if (this.pos >= this.buffer.length) {
            if (this.length == 0) {
                return -1;
            }
            this.readBuffer();
        }
        return this.buffer[this.pos++];
    }

    private int reliableRead(byte[] data, int offset, int length) throws IOException {
        int i;
        int bytesRead = 0;
        while ((i = this.in.read(data, offset, length)) >= 0 && length > 0) {
            bytesRead += i;
            offset += i;
            length -= i;
        }
        return bytesRead;
    }
}

