/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.io.LightPipedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class LightPipedInputStream
extends InputStream {
    LightPipedOutputStream out;
    private long timeout;

    LightPipedInputStream(LightPipedOutputStream out) {
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        LightPipedOutputStream lightPipedOutputStream = this.out;
        synchronized (lightPipedOutputStream) {
            while (this.out.startPos == this.out.commitedPos) {
                if (this.out.closed) {
                    this.out.notifyQueue();
                    throw new IOException("Stream was closed");
                }
                try {
                    if (this.timeout > 0L) {
                        this.out.waitForQueue(this.timeout);
                        if (this.out.startPos != this.out.commitedPos || this.out.closed) continue;
                        throw new InterruptedIOException("SO_TIMEOUT timeout");
                    }
                    this.out.waitForQueue();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted");
                }
            }
            int data = (char)this.out.buffer[this.out.startPos++] & 0xFF;
            if (this.out.startPos > 2048) {
                this.out.freeSpace();
            }
            this.out.notifyQueue();
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] data, int start, int length) throws IOException {
        LightPipedOutputStream lightPipedOutputStream = this.out;
        synchronized (lightPipedOutputStream) {
            while (this.out.startPos == this.out.commitedPos) {
                if (this.out.closed) {
                    this.out.notifyQueue();
                    throw new IOException("Stream was closed");
                }
                try {
                    if (this.timeout > 0L) {
                        this.out.waitForQueue(this.timeout);
                        if (this.out.startPos != this.out.commitedPos || this.out.closed) continue;
                        throw new InterruptedIOException("SO_TIMEOUT timeout");
                    }
                    this.out.waitForQueue();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted");
                }
            }
            int available = this.out.commitedPos - this.out.startPos;
            if (available > length) {
                available = length;
            }
            System.arraycopy(this.out.buffer, this.out.startPos, data, start, available);
            if (this.out.startPos > 2048) {
                this.out.freeSpace();
            }
            this.out.notifyQueue();
            return available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        LightPipedOutputStream lightPipedOutputStream = this.out;
        synchronized (lightPipedOutputStream) {
            return this.out.commitedPos - this.out.startPos;
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

