/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io.serialization;

import com.evermind.io.IOUtils;
import com.evermind.io.serialization.MoldedSerializationContext;
import com.evermind.io.serialization.MoldedSerializer;
import com.evermind.util.ByteString;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class MoldedObjectOutputStream
extends ObjectOutputStream {
    private OutputStream out;
    private MoldedSerializationContext context;
    private Object[] writtenObjects = new Object[4];
    private int writtenObjectsCount;
    private MoldedSerializer[] writtenTypes = new MoldedSerializer[4];
    private int writtenTypesCount;
    private Object[] argumentArray;
    private Object currentlyWriting;

    public MoldedObjectOutputStream(OutputStream out) throws IOException {
        this(out, new MoldedSerializationContext());
    }

    public MoldedObjectOutputStream(OutputStream out, MoldedSerializationContext context) throws IOException {
        this.out = out;
        this.context = context;
    }

    protected final void writeObjectOverride(Object object) throws IOException {
        if (object != null) {
            int count = this.writtenObjectsCount;
            Object[] objects = this.writtenObjects;
            for (int i = 0; i < count; ++i) {
                if (objects[i] != object) continue;
                this.write(112);
                this.writeInt(i);
                return;
            }
            if (count == objects.length) {
                Object[] newObjects = new Object[objects.length * 2];
                System.arraycopy(objects, 0, newObjects, 0, objects.length);
                this.writtenObjects = newObjects;
            }
            this.writtenObjects[count] = object;
            this.writtenObjectsCount = count + 1;
        }
        this.writeSimpleObject(object);
    }

    public void writeInt(int i) throws IOException {
        IOUtils.writeCompressedInt(this.out, i);
    }

    public void writeUncompressedInt(int i) throws IOException {
        this.out.write(i >>> 24);
        this.out.write(i >>> 16);
        this.out.write(i >>> 8);
        this.out.write(i);
    }

    public void writeFloat(float f) throws IOException {
        this.writeUncompressedInt(Float.floatToIntBits(f));
    }

    public void writeLong(long l) throws IOException {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeByte(byte b) throws IOException {
        this.write(b);
    }

    public void writeShort(short s) throws IOException {
        this.write((byte)s);
        this.write(s >>> 8);
    }

    public void writeChar(char c) throws IOException {
        this.write((byte)c);
        this.write(c >>> 8);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    public void writeUTF(String string) throws IOException {
    }

    public void writeByteString(ByteString string) throws IOException {
        this.writeInt(string.length);
        this.write(string.data, string.offset, string.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSimpleObject(Object object) throws IOException {
        MoldedSerializer serializer;
        Class<?> type;
        if (object instanceof Number) {
            type = object.getClass();
            if (type == Integer.class) {
                this.write(73);
                IOUtils.writeCompressedInt(this.out, (Integer)object);
                return;
            }
            if (type == Float.class) {
                this.write(70);
                this.writeFloat(((Float)object).floatValue());
                return;
            }
            if (type == Long.class) {
                this.write(74);
                this.writeLong((Long)object);
                return;
            }
            if (type == Double.class) {
                this.write(68);
                this.writeDouble((Double)object);
                return;
            }
            if (type == Byte.class) {
                this.write(66);
                this.writeByte((Byte)object);
                return;
            }
            if (type == Short.class) {
                this.write(83);
                this.writeShort((Short)object);
                return;
            }
        }
        if (object instanceof Character && object.getClass() == Character.class) {
            this.write(67);
            this.writeChar(((Character)object).charValue());
            return;
        }
        if (object instanceof Boolean && object.getClass() == Boolean.class) {
            this.write(90);
            this.writeBoolean((Boolean)object);
            return;
        }
        if (object instanceof String) {
            this.write(115);
            this.writeUTF((String)object);
            return;
        }
        if (object == null) {
            this.write(78);
            return;
        }
        if (object instanceof byte[]) {
            this.write(98);
            IOUtils.writeCompressedInt(this.out, ((byte[])object).length);
            this.write((byte[])object);
            return;
        }
        type = object.getClass();
        try {
            serializer = this.context.getSerializer(type);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Class not found: " + e.getMessage());
        }
        int index = this.getWrittenTypeIndex(serializer);
        if (index < 0) {
            this.write(76);
            this.writeClassName(type);
            this.addWrittenType(serializer);
        } else {
            this.write(108);
            this.writeInt(index);
        }
        Object previouslyWriting = this.currentlyWriting;
        this.currentlyWriting = object;
        try {
            serializer.write(this, object);
        }
        finally {
            this.currentlyWriting = previouslyWriting;
        }
    }

    public void writeClassName(Class type) throws IOException {
        this.writeByteString(new ByteString(type.getName()));
    }

    protected Object[] getArgumentArray() {
        if (this.argumentArray == null) {
            this.argumentArray = new Object[]{this};
        }
        return this.argumentArray;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] data) throws IOException {
        this.out.write(data);
    }

    public void write(byte[] data, int start, int length) throws IOException {
        this.out.write(data, start, length);
    }

    public int getWrittenTypeIndex(MoldedSerializer serializer) {
        int count = this.writtenTypesCount;
        MoldedSerializer[] serializers = this.writtenTypes;
        for (int i = 0; i < this.writtenTypesCount; ++i) {
            if (serializers[i] != serializer) continue;
            return i;
        }
        return -1;
    }

    public void addWrittenType(MoldedSerializer serializer) {
        int count = this.writtenTypesCount;
        MoldedSerializer[] types = this.writtenTypes;
        if (count == types.length) {
            MoldedSerializer[] newTypes = new MoldedSerializer[types.length * 2];
            System.arraycopy(types, 0, newTypes, 0, types.length);
            this.writtenTypes = newTypes;
        }
        this.writtenTypes[count] = serializer;
        this.writtenTypesCount = count + 1;
    }

    public void resetGraph() throws IOException {
        int count = this.writtenObjectsCount;
        if (count > 0) {
            Object[] graph = this.writtenObjects;
            for (int i = 0; i < count; ++i) {
                graph[i] = null;
            }
            this.writtenObjectsCount = 0;
            this.out.write(114);
        }
    }

    public void reset() throws IOException {
        this.resetGraph();
        this.out.write(82);
        this.writtenTypesCount = 0;
    }

    public void defaultWriteObject() throws IOException {
        MoldedSerializer serializer;
        Object object = this.currentlyWriting;
        try {
            serializer = this.context.getSerializer(object.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Class not found: " + e.getMessage());
        }
        serializer.writeDefault(this, object);
    }
}

