/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.file;

import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileContext;
import com.evermind.naming.file.SerializableFileContext;
import com.evermind.util.ObjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class FileNamingEnumeration
implements NamingEnumeration {
    protected File[] files;
    protected FileContext context;
    protected int pos;
    protected NameClassPair current;
    protected NamingException exception;

    public FileNamingEnumeration(File[] files, FileContext context) {
        this.files = files;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] != null) continue;
            throw new NullPointerException("File array entry was null");
        }
        this.context = context;
        this.current = this.getNameClassPair();
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public boolean hasMoreElements() {
        return this.current != null;
    }

    public void close() {
    }

    public Object nextElement() {
        if (this.current == null) {
            throw new NoSuchElementException(String.valueOf(this.pos - 1));
        }
        NameClassPair value = this.current;
        this.current = this.getNameClassPair();
        return value;
    }

    public NameClassPair getNameClassPair() {
        if (this.files == null || this.pos >= this.files.length) {
            return null;
        }
        try {
            File file = this.files[this.pos++];
            if (file.isDirectory()) {
                return new NameClassPair(file.getName(), "com.evermind.naming.file.FileContext");
            }
            if (this.context instanceof ContentFileContext) {
                return new NameClassPair(file.getName(), "[B");
            }
            if (this.context instanceof SerializableFileContext) {
                FileInputStream in = new FileInputStream(file);
                String className = ObjectUtils.getObject(in, ((SerializableFileContext)this.context).getClassLoader()).getClass().getName();
                in.close();
                return new NameClassPair(file.getName(), className);
            }
            return new NameClassPair(file.getName(), "java.io.File");
        }
        catch (ClassNotFoundException e) {
            this.exception = new NamingException("ClassNotFoundException: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            this.exception = new NamingException("IO Error: " + e.getMessage());
            return null;
        }
    }

    public Object next() throws NamingException {
        if (this.current == null && this.exception != null) {
            throw this.exception;
        }
        NameClassPair pair = this.current;
        this.current = this.getNameClassPair();
        return pair;
    }
}

