/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net;

import com.evermind.net.AccessRegion;
import com.evermind.net.AccessRegionSetMessages;
import com.evermind.net.HostAccessRegion;
import com.evermind.net.IPAccessRegion;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AccessRegionSet
extends AbstractList
implements XMLizable {
    AccessRegion[] regions;
    private boolean allowUnknown;

    public AccessRegionSet() {
        this.regions = new AccessRegion[0];
    }

    public AccessRegionSet(Collection collection) {
        this.regions = collection.toArray(new AccessRegion[collection.size()]);
    }

    public static Logger getCustomerFacingLogger() {
        return AccessRegionSetMessages.getLogger();
    }

    public void setAllowUnknown(boolean allow) {
        this.allowUnknown = allow;
    }

    public boolean allowUnknown() {
        return this.allowUnknown;
    }

    public boolean contains(Object object) {
        for (int i = 0; i < this.regions.length; ++i) {
            if (!this.regions[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean add(Object object) {
        AccessRegion region = (AccessRegion)object;
        int existingLocation = this.indexOf(object);
        if (existingLocation >= 0) {
            AccessRegion oldRegion = (AccessRegion)this.get(existingLocation);
            oldRegion.m_allow = region.m_allow;
            return false;
        }
        AccessRegion[] newRegions = new AccessRegion[this.regions.length + 1];
        System.arraycopy(this.regions, 0, newRegions, 0, this.regions.length);
        newRegions[this.regions.length] = region;
        this.regions = newRegions;
        return true;
    }

    public void add(int pos, Object object) {
        AccessRegion region = (AccessRegion)object;
        AccessRegion[] newRegions = new AccessRegion[this.regions.length + 1];
        System.arraycopy(this.regions, 0, newRegions, 0, pos);
        System.arraycopy(this.regions, pos, newRegions, pos + 1, this.regions.length - pos);
        newRegions[pos] = region;
        this.regions = newRegions;
    }

    public Object remove(int pos) {
        AccessRegion returnObject = this.regions[pos];
        AccessRegion[] newRegions = new AccessRegion[this.regions.length - 1];
        System.arraycopy(this.regions, 0, newRegions, 0, pos);
        System.arraycopy(this.regions, pos + 1, newRegions, pos, this.regions.length - (pos + 1));
        this.regions = newRegions;
        return returnObject;
    }

    public boolean allow(InetAddress address) {
        return this.allow(null, address);
    }

    public boolean allow(String service, InetAddress address) {
        boolean permitted = this.allowWorker(address);
        if (permitted) {
            AccessRegionSetMessages.accessGranted(service, address);
        } else {
            AccessRegionSetMessages.accessDenied(service, address);
        }
        return permitted;
    }

    private boolean allowWorker(InetAddress address) {
        if (null != address) {
            String hostname = null;
            boolean isLocalHost = AccessRegion.isLocalHost(address);
            int ip = IPAccessRegion.toInt(address);
            for (int i = 0; i < this.regions.length; ++i) {
                if (this.regions[i] instanceof HostAccessRegion) {
                    if (hostname == null) {
                        hostname = address.getHostName();
                    }
                    if (!this.regions[i].implies(hostname, isLocalHost)) continue;
                    return this.regions[i].m_allow;
                }
                if (!this.regions[i].implies(ip, isLocalHost)) continue;
                return this.regions[i].m_allow;
            }
        }
        return this.allowUnknown;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.regions.length; ++i) {
            if (!this.regions[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object get(int index) {
        if (index >= this.regions.length) {
            return null;
        }
        return this.regions[index];
    }

    public int size() {
        return this.regions.length;
    }

    public Object[] toArray() {
        return (AccessRegion[])this.regions.clone();
    }

    public Object[] toArray(Object[] targetArray) {
        if (targetArray.length < this.regions.length) {
            targetArray = (Object[])Array.newInstance(targetArray.getClass(), this.regions.length);
        }
        System.arraycopy(this.regions, 0, targetArray, 0, this.regions.length);
        return targetArray;
    }

    public static AccessRegionSet getSet(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        ArrayList<AccessRegion> regions = new ArrayList<AccessRegion>();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("host-access")) {
                    regions.add(new HostAccessRegion(node));
                    continue;
                }
                if (name.equals("ip-access")) {
                    regions.add(new IPAccessRegion(node));
                    continue;
                }
                throw new InstantiationException("Unknown access-mask subtag: " + name);
            }
        }
        AccessRegionSet ars = new AccessRegionSet(regions);
        ars.setAllowUnknown(!"deny".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "default")));
        return ars;
    }

    public void writeXML(PrintWriter out, String indention, String elementTagName) throws IOException {
        if (null == elementTagName) {
            elementTagName = "access-mask";
        }
        out.print(indention);
        out.print("<");
        out.print(elementTagName);
        out.print(" default=\"");
        out.print(this.allowUnknown ? "allow" : "deny");
        out.println("\">");
        if (this.regions != null) {
            XMLUtils.writeAll(Arrays.asList(this.regions), out, indention + "\t");
        }
        out.print(indention);
        out.print("</");
        out.print(elementTagName);
        out.println(">");
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        this.writeXML(out, indention, null);
    }
}

