/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.AbstractUserManager;
import com.evermind.security.Group;
import com.evermind.security.MemoryGroup;
import com.evermind.security.MemoryUser;
import com.evermind.security.User;
import com.evermind.security.UserAlreadyExistsException;
import java.util.HashMap;
import java.util.Map;

public class MemoryUserManager
extends AbstractUserManager {
    private Map users = new HashMap();
    private Map groups = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User createUser(String username, String password) throws UserAlreadyExistsException {
        Map map = this.users;
        synchronized (map) {
            return this.recordUser(new MemoryUser(username, password));
        }
    }

    protected User recordUser(User user) throws UserAlreadyExistsException {
        if (this.users.keySet().contains(user.getName())) {
            throw new UserAlreadyExistsException(user.getName());
        }
        this.users.put(user.getName(), user);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group createGroup(String groupname) {
        Map map = this.groups;
        synchronized (map) {
            Group group = (Group)this.groups.get(groupname);
            if (group == null) {
                group = new MemoryGroup(groupname);
                this.groups.put(groupname, group);
            }
            return group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String username) {
        Map map = this.users;
        synchronized (map) {
            return (User)this.users.get(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String groupname) {
        Map map = this.groups;
        synchronized (map) {
            return (Group)this.groups.get(groupname);
        }
    }
}

