/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.User;
import com.evermind.security.UserManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.security.OC4JSecurity;

public class SecuritySensitive {
    static final String CONTEXT_SYS = "system context";
    static final String CONTEXT_APP = "application context";
    static final Logger s_traceLogger = TraceLogger.getLogger(SecuritySensitive.class);
    private static SecuritySensitive global;
    private UserManager system_userManager;
    private boolean m_transitional;

    SecuritySensitive(UserManager userManager, boolean transitional) {
        this.system_userManager = userManager;
        this.m_transitional = transitional;
    }

    public static void setGlobal(UserManager userManager) {
        OC4JSecurity.assertIsSafe();
        global = userManager == null ? null : new SecuritySensitive(userManager, false);
    }

    public String decode(String obfuscated) throws SecurityException {
        OC4JSecurity.assertIsSafe();
        String cleartext = obfuscated == null ? null : (obfuscated.startsWith("->!") ? obfuscated.substring(3) : (obfuscated.startsWith("->") ? this.lookup(obfuscated.substring(2)) : obfuscated));
        return cleartext;
    }

    public static boolean isHidden(String passwd) {
        boolean isObfuscated = true;
        if (passwd.startsWith("->!")) {
            return false;
        }
        return passwd.startsWith("->");
    }

    public String decode(String obfuscated, String defaultValue) {
        try {
            return this.decode(obfuscated);
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static SecuritySensitive global() {
        return global;
    }

    String lookup(String userName) throws SecurityException {
        String cleartext = null;
        try {
            cleartext = this.lookup(CONTEXT_APP, this.getCurrentThreadState().getContextUserManager(), userName);
        }
        catch (Exception e) {
            this.lookupException(e, CONTEXT_APP, userName);
        }
        if (null == cleartext) {
            cleartext = this.lookup(CONTEXT_SYS, this.getSystemUserManager(), userName);
        }
        if (cleartext == null) {
            throw new SecurityException("password is not available for indirect password \"->" + userName + "\"");
        }
        return cleartext;
    }

    private void lookupException(Exception e, String locationContext, String userName) {
        if (s_traceLogger.isLoggable(Level.INFO)) {
            StringBuffer buf = new StringBuffer();
            if (null != e.getMessage()) {
                buf.append(e.getMessage()).append("; ");
            }
            buf.append("password is not available for indirect password via ").append(locationContext);
            buf.append(" (user: ").append(userName).append(")");
            s_traceLogger.log(Level.INFO, buf.toString());
        }
    }

    private String lookup(String locationContext, UserManager userManager, String userName) {
        if (null == userManager) {
            return null;
        }
        User user = userManager.getUser(userName);
        if (null == user) {
            if (s_traceLogger.isLoggable(Level.FINE)) {
                s_traceLogger.log(Level.FINE, "user {0} was not found by {1} UserManager", new Object[]{userName, locationContext});
            }
            return null;
        }
        return user.getPassword();
    }

    public UserManager getSystemUserManager() {
        return this.system_userManager;
    }

    CommonThreadState getCurrentThreadState() {
        return CommonThreadState.getCurrent();
    }
}

