/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.CountDown;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.ContextLocation;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationContext;
import com.evermind.server.ApplicationLifeCycleHelper;
import com.evermind.server.ApplicationPermissionCollection;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationState;
import com.evermind.server.ApplicationStateRunning;
import com.evermind.server.ApplicationStateStopped;
import com.evermind.server.ClusteredApplicationConfigProxy;
import com.evermind.server.ContextContainer;
import com.evermind.server.ExecutionContext;
import com.evermind.server.NamespaceAccessController;
import com.evermind.server.OC4JMonitorThread;
import com.evermind.server.OC4JServer;
import com.evermind.server.Refreshable;
import com.evermind.server.RestrictedApplicationMBeanImpl;
import com.evermind.server.ServerBase;
import com.evermind.server.ServerComponent;
import com.evermind.server.ServerMessages;
import com.evermind.server.ThreadState;
import com.evermind.server.UnSupportedMBeanOperationException;
import com.evermind.server.administration.ApplicationClientConnector;
import com.evermind.server.administration.ApplicationResourceFinder;
import com.evermind.server.administration.RemoteData;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.deployment.ApplicationClientServerArchive;
import com.evermind.server.deployment.ClientModule;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.JMXMBeanDescriptor;
import com.evermind.server.deployment.MailSessionInfo;
import com.evermind.server.deployment.ResourceProvider;
import com.evermind.server.deployment.ResourceProviderDescriptor;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleContainer;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.XMLHttpApplicationConfigContext;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.rmi.JndiNamespaceReplicationService;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.RMIServerContext;
import com.evermind.util.AttributeContainer;
import com.evermind.util.Destroyable;
import com.evermind.util.Logger;
import com.evermind.util.LoggerContext;
import com.evermind.util.LoggingDestroyable;
import com.evermind.util.OC4JProperties;
import com.evermind.util.OC4JProperty;
import com.evermind.util.ServerProperties;
import com.evermind.util.StringUtils;
import com.evermind.util.UserManagerUtils;
import com.evermind.xml.XMLUtils;
import com.oracle.bricks.Manager;
import com.oracle.bricks.SessionManagerFactory;
import com.oracle.bricks.j2ee.JGroupConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.logging.Level;
import javax.mail.Session;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ArrayUtils;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.connector.DeployedAdapter;
import oracle.j2ee.connector.ResourceAdapterWrapper;
import oracle.j2ee.resourceprovider.ResourceProviderDetail;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.config.ApplicationServerConfig;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.model.ModelMBeanProvider;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameUtil;
import oracle.oc4j.admin.management.callbackinterfaces.AppClientModuleCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEApplicationCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JavaMailResourceCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OC4JWebModuleCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.ResourceAdapterModuleCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.WebModuleCallBackIf;
import oracle.oc4j.admin.management.mbeans.AppClientModule;
import oracle.oc4j.admin.management.mbeans.ClusteredApplication;
import oracle.oc4j.admin.management.mbeans.J2EEApplication;
import oracle.oc4j.admin.management.mbeans.J2EEServer;
import oracle.oc4j.admin.management.mbeans.JavaMailResource;
import oracle.oc4j.admin.management.mbeans.OC4JWebModule;
import oracle.oc4j.admin.management.mbeans.ResourceAdapterModule;
import oracle.oc4j.admin.management.mbeans.SecurityProviderManager;
import oracle.oc4j.admin.management.shared.SharedLibraryImport;
import oracle.oc4j.admin.management.util.CollectionModificationEvent;
import oracle.oc4j.admin.management.util.CollectionModificationListener;
import oracle.oc4j.admin.management.util.NotifyingMap;
import oracle.oc4j.hooks.ApplicationProtocol;
import oracle.oc4j.loader.config.ConfigurationConsumer;
import oracle.oc4j.loader.config.ConfigurationException;
import oracle.oc4j.loader.config.ImportSharedLibraryType;
import oracle.oc4j.loader.config.ImportedSharedLibrariesType;
import oracle.oc4j.loader.config.xml.ImportSharedLibraryElement;
import oracle.oc4j.loader.config.xml.ImportedSharedLibrariesElement;
import oracle.oc4j.security.SecurityUtil;
import oracle.oc4j.security.acc.JaccWrapper;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceBaseConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import oracle.oc4j.sql.config.DataSourcesConfig;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.mbean.ConnectionPoolJDBCResource;
import oracle.oc4j.sql.mbean.ConnectionPoolJDBCResourceCallBack;
import oracle.oc4j.sql.mbean.ConnectionPoolJDBCResourceCallBackImpl;
import oracle.oc4j.sql.mbean.ManagedJDBCDataSource;
import oracle.oc4j.sql.mbean.ManagedJDBCDataSourceCallBackImpl;
import oracle.oc4j.sql.mbean.NativeJDBCDataSource;
import oracle.oc4j.sql.mbean.NativeJDBCDataSourceCallBack;
import oracle.oc4j.sql.mbean.NativeJDBCDataSourceCallBackImpl;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;
import oracle.oc4j.sql.spi.ResourceAdapterImpl;
import oracle.oc4j.transport.TransportManager;
import oracle.oc4j.util.FileUtils;
import oracle.security.jazn.jmx.SecurityProviderCallbackIf;
import oracle.security.jazn.oc4j.JAZNUserManager;

public class Application
extends ServerBase
implements ApplicationClientConnector,
LoggerContext,
J2EEApplicationCallBackIf,
ExecutionContext,
Refreshable {
    public static final String DeploymentMetricRulesDescriptorPath = "metric-rules.xml";
    private static java.util.logging.Logger m_logger = TraceLogger.getLogger(Application.class);
    private static DatabaseSchema defaultSchema;
    private static NounIntf j2eeNoun;
    private int userDelegationType;
    private String name;
    private Application parent;
    protected ApplicationConfig config;
    private ApplicationServer server;
    protected Collection configs;
    private NotifyingMap webApplicationConfigs;
    private boolean destroyed;
    protected List mailSessions;
    protected List children;
    private Object deployedJEMApplication;
    private List verifiedClientFriendJars;
    private ApplicationContext context;
    private UserManager userManager;
    private volatile int state_;
    private ApplicationConfigReference _applicationConfigReference;
    private Notifier _notifier;
    private final String webApplicationConfigsLock;
    private final Object namespaceAccessControllerLock = new Object();
    private NamespaceAccessController namespaceAccessController;
    private J2EEApplication j2eeApplicationMBean_ = null;
    private Set registeredSharedUserMBeans_ = null;
    private NounIntf appNoun;
    private boolean defaultApplication;
    private ApplicationState appState;
    private ArrayList appComponentList = new ArrayList();
    private final Object stateMgmtLock = new Object();
    private HashMap m_nativeDataSourceConfigs = new HashMap();
    private HashMap m_managedDataSourceConfigs = new HashMap();
    private ConnectorArchive m_dataSourceConnectorArchive = null;
    private boolean devtestMode = false;
    private EJBContainer mockEjbContainer;
    private int generationNumber = -1;
    private HashMap attributeTypeMap = null;
    private static final String TIMEOUT = "timeout";
    private static final String FORCE = "graceful";
    private int timeout = 30;
    private boolean graceful = true;
    private ApplicationProperties applicationProperties = new ApplicationProperties();
    public static final String MetricRulesDescriptorPath = "META-INF/metricservice/metric-rules.xml";
    private SynchronizedInt stopTimeout = new SynchronizedInt(5000);
    private static final int APPLICATION_CHANGED = 0;
    private static final int ARCHIVE_DESCRIPTORS_CHANGED = 1;
    private static final int NO_CHANGE = -1;
    private int refreshState = -1;

    public Application(ApplicationServer server, Application parent, ApplicationConfigReference applicationConfigReference) throws InstantiationException {
        this.server = server;
        this.parent = parent;
        this.context = ApplicationContext.createApplicationContext(this);
        this.webApplicationConfigsLock = new String("webApplicationConfigs lock");
        this._applicationConfigReference = applicationConfigReference;
        this.appState = new ApplicationStateStopped(this, null, 3);
        this.state_ = 3;
        if (parent != null) {
            m_logger.fine("Adding application to parent: " + parent.getName() + "'s list");
            parent.addChild(this);
        }
        if (server != null) {
            this.initRMIContext();
        }
    }

    private void initRMIContext() throws InstantiationException {
        RMIServer localRmiServer;
        String applicationName = this._applicationConfigReference != null && this._applicationConfigReference.isDefaultApplication() ? null : (this._applicationConfigReference != null ? this._applicationConfigReference.getName() : null);
        RMIServer rmiServer = this.server.getRMIServer();
        if (rmiServer != null) {
            this.setupRMIContext(rmiServer.getServerContext(applicationName, true), this);
        }
        if ((localRmiServer = this.server.getLocalRmiServer()) != null && localRmiServer.getServerContext(applicationName, true) != null) {
            localRmiServer.getServerContext(applicationName, true).setApplicationContext(this.context);
        }
    }

    private void setupRMIContext(RMIServerContext rmiContext, Application application) throws InstantiationException {
        try {
            if (rmiContext != null) {
                this.context.setRMIContext(rmiContext);
                rmiContext.setApplicationContext(this.context);
                this.server.getRMIServer().publishRemoteServers(rmiContext, new ApplicationResourceFinder(application), application);
            }
        }
        catch (NamingException e) {
            throw new InstantiationException("Error setting up the application RMI context:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceAccessController getNamespaceAccessController() {
        if (this.namespaceAccessController == null) {
            Object object = this.namespaceAccessControllerLock;
            synchronized (object) {
                if (this.namespaceAccessController == null) {
                    NamespaceAccessController nsac = this.config.getNamespaceAccessController();
                    nsac.setUserManager(this.getUserManager());
                    this.namespaceAccessController = nsac;
                }
            }
        }
        return this.namespaceAccessController;
    }

    public void setConfig(ApplicationConfig config) throws InstantiationException {
        this.setConfig(config, null, false);
    }

    public void setConfig(ApplicationConfig config, boolean ignoreStartFlag) throws InstantiationException {
        this.setConfig(config, null, ignoreStartFlag);
    }

    public void setConfig(ApplicationConfig config, Notifier notifier) throws InstantiationException {
        this.setConfig(config, notifier, false);
    }

    public synchronized void setConfig(ApplicationConfig config, Notifier notifier, boolean ignoreStartFlag) throws InstantiationException {
        Properties properties;
        String[] params = new String[]{config.getName()};
        ++this.generationNumber;
        if (this.config != null && this.state_ == 1) {
            if (notifier != null) {
                notifier.sendNotification("STOPPING_APPLICATION", params);
            } else {
                m_logger.warning("setConfig is being called on a running instance of application: " + config.getName() + ". Stopping it first");
            }
            this.doStop();
            if (notifier != null) {
                notifier.sendNotification("STOPPED_APPLICATION", params);
            } else {
                ServerMessages.infoApplicationStopped(this.name);
            }
        }
        if (notifier != null) {
            notifier.sendNotification("STARTING_APPLICATION", params);
        }
        ApplicationState currentState = this.appState;
        this.state_ = 0;
        this.appState = new ApplicationStateRunning(this, currentState.getSharedData());
        this.name = config.getName();
        super.setConfig(config);
        this.config = config;
        if (this.logger != null) {
            this.logger.setContext(this);
        }
        if ((properties = config.getProperties()) != null) {
            Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                OC4JProperty oc4jProperty = new OC4JProperty((String)entry.getKey(), (String)entry.getValue(), (String)entry.getValue(), "String", this.name, false);
                this.applicationProperties.setProperty(oc4jProperty);
            }
        }
        try {
            ApplicationProtocol.PRE_INIT_APPLICATION.fire(config, this);
            this.serverExtentionPreInitApplication();
            boolean oldValueForGlobalLookup = RMIContext.isGlobalJNDILookupEnabled();
            RMIContext.setGlobalJNDILookupEnabled(false);
            this.appState.initializeApplication(config, notifier);
            RMIContext.setGlobalJNDILookupEnabled(oldValueForGlobalLookup);
            if (this.userDelegationType == 2) {
                this.userManager = this.parent.getUserManager();
            }
            this.setDefaultMailSessionProperties(config);
            this.serverExtentionPostInitApplication();
            this.initHttp();
            this.initRoleMapping();
            this.flushPropDD(notifier);
            this.persistJACC();
            this.appState.recordApplicationStartTime();
            this.addClusteredApplicationMBean(notifier);
            if (!ignoreStartFlag && !this.isStarted()) {
                this.doStop();
                return;
            }
        }
        catch (Throwable t) {
            if (notifier != null) {
                notifier.sendNotification("FAILED_APPLICATION", params);
            }
            if (this.j2eeApplicationMBean_ != null) {
                this.j2eeApplicationMBean_.reportFailed(t);
            }
            m_logger.log(Level.WARNING, "Application: " + this.name + " is in failed state as initialization failed. \n" + t);
            this.stateCleanUp(false);
            this.state_ = 4;
            this.appState = new ApplicationStateStopped(this, null, 4);
            ApplicationProtocol.POST_INIT_APPLICATION.fire(config, this);
            InstantiationException ie = new InstantiationException("Application: " + this.name + " is in failed state as initialization failed");
            ie.initCause(t);
            throw ie;
        }
        if (notifier != null) {
            notifier.sendNotification("RUNNING_APPLICATION", params);
        }
        this.state_ = 1;
        ApplicationProtocol.POST_INIT_APPLICATION.fire(config, this);
        if (this.j2eeApplicationMBean_ != null) {
            this.j2eeApplicationMBean_.reportRunning();
        }
    }

    void setState(int state) {
        this.state_ = state;
    }

    public boolean isStarted() {
        return this._applicationConfigReference.getStart();
    }

    public boolean isDefaultApplication() {
        if (this._applicationConfigReference != null) {
            return this._applicationConfigReference.isDefaultApplication();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(ConnectorModule module, String moduleDeploymentPlan, Notifier notifier) throws InstantiationException {
        Application application = this;
        synchronized (application) {
            this.appState.addConnector(module, moduleDeploymentPlan, notifier);
        }
    }

    public TransportManager getTransportManager() {
        return TransportManager.getInstance(this._applicationConfigReference);
    }

    public String getNonJtaJNDIName(String _dsName) {
        return this.appState.getNonJtaJNDIName(_dsName);
    }

    public synchronized HttpApplication getHttpApplication(String name, String root, boolean share, long maxInactivityTime, boolean accessLog, HttpSite site, boolean forceLoad) throws InstantiationException {
        return this.appState.getHttpApplication(name, root, share, maxInactivityTime, accessLog, site, forceLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpApplicationConfig getHttpApplicationConfig(String name) throws InstantiationException {
        WebModule module = this.config.getWebApplication(name);
        if (module == null) {
            return null;
        }
        String string = this.webApplicationConfigsLock;
        synchronized (string) {
            HttpApplicationConfig hconfig;
            if (this.webApplicationConfigs == null) {
                this.webApplicationConfigs = new NotifyingMap();
                this.webApplicationConfigs.addCollectionModificationListener(new WebModuleCollectionModificationListener());
            }
            if ((hconfig = (HttpApplicationConfig)this.webApplicationConfigs.get(name)) == null) {
                hconfig = new XMLHttpApplicationConfigContext((EnterpriseArchive)this.config, name, this.config.getURL(), module.getPath(), this.server.getConfig().getDefaultHttpApplicationConfig(), null, this.userManager, -1L, true, false, module.isSynthetic(), module.getSyntheticDescriptor()).getConfiguration();
                ((HttpApplicationDescriptor)hconfig).setName(module.getName());
                this.webApplicationConfigs.put(name, hconfig);
            }
            return hconfig;
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void resetHttpApplications() throws InstantiationException {
        HttpServer httpServer = this.server.getHttpServer();
        List httpApplications = httpServer.getHttpApplicationsOf(this);
        Iterator iterator = httpApplications.iterator();
        while (iterator.hasNext()) {
            HttpApplication httpApplication = (HttpApplication)iterator.next();
            if (httpApplication == null) continue;
            httpApplication.reset();
        }
    }

    public ApplicationServer getServer() {
        return this.server;
    }

    public ClassLoader getParentClassLoader() {
        return this.appState.getParentClassLoader();
    }

    public String getClasspath() {
        return this.getClassPath();
    }

    public String getClassPath() {
        return ClassLoaderQuery.getClassPath((PolicyClassLoader)this.getBeansClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this.appState.getClassLoader();
    }

    public PolicyClassLoader getBeansClassLoader() {
        return this.appState.getBeansClassLoader();
    }

    public Principal getCallerPrincipal() {
        return this.server.getCallerPrincipal();
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void importStandaloneAdapter(PolicyClassLoader sharedLibLoader) throws ConfigurationException {
        if (this.children != null) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                Application app = (Application)iter.next();
                app.importStandaloneAdapter(sharedLibLoader);
            }
        }
        if (!this.isDefaultApplication() && this.isRunning()) {
            ImportedSharedLibrariesType importConfig = this.config.getImportedSharedLibraries();
            ConfigurationConsumer.addImportedSharedLibraries((PolicyClassLoader)this.getClassLoader(), this.config.getURL().getPath(), importConfig, new PolicyClassLoader[]{sharedLibLoader});
        }
    }

    public String toString() {
        return "application " + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(String reason) {
        if (this.destroyed) {
            return;
        }
        this.state_ = 2;
        if (ServerProperties.getApplicationServerDebug()) {
            m_logger.fine("Destroying application: " + this.getName());
        }
        ThreadState state = ThreadState.getCurrentState();
        ContextContainer previousContainer = state.contextContainer;
        try {
            int i;
            state.contextContainer = this;
            this.destroyed = true;
            m_logger.finest("Updating JAZN configuration");
            this.updateJAZNConfiguration();
            if (ApplicationServer.serverExtensionProviders != null) {
                for (i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                    ApplicationServer.serverExtensionProviders[i].preDestroyApplication((AttributeContainer)((Object)this.config), this);
                }
            }
            ApplicationProtocol.PRE_DESTROY_APPLICATION.fire(this.config, this);
            this.stateCleanUp(true);
            ApplicationProtocol.POST_DESTROY_APPLICATION.fire(this.config, this);
            if (ApplicationServer.serverExtensionProviders != null) {
                for (i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                    ApplicationServer.serverExtensionProviders[i].postDestroyApplication((AttributeContainer)((Object)this.config), this);
                }
            }
            if (this.logger != null) {
                this.logger.close();
                this.logger = null;
            }
            this.clearRMIContext();
            super.destroy(reason);
            this.flushWebAppConfigs();
            String string = this.webApplicationConfigsLock;
            synchronized (string) {
                this.webApplicationConfigs = null;
            }
            if (this.parent != null) {
                m_logger.finest("removing application " + this.name + " from parent " + this.parent.getName() + "'s list");
                this.parent.removeChild(this);
            }
            this.state_ = 3;
            this.j2eeApplicationMBean_ = null;
        }
        finally {
            state.setContextContainer(previousContainer);
        }
    }

    void resetSessionManager() {
        if (this.isConfiguredForClustering() && !Application.isGroupShared(this, this.server)) {
            String groupName = this.getConfig().getClusterConfig().getGroupName();
            Manager sManager = SessionManagerFactory.getManager(groupName);
            if (sManager != null) {
                if (sManager.isStarted()) {
                    sManager.stop();
                }
                SessionManagerFactory.removeManager(this.getConfig().getClusterConfig());
            }
            if (this.server.getRMIServer() != null && this.server.getRMIServer().getClusterManager() != null) {
                JndiNamespaceReplicationService replicationService = this.server.getRMIServer().getClusterManager();
                replicationService.unRegisterApplication(groupName, this);
            }
        }
        m_logger.fine("application " + this.name + " destroy complete");
    }

    private void clearRMIContext() {
        try {
            RMIServer localRmiServer;
            RMIServer rmiServer = this.server.getRMIServer();
            if (rmiServer != null) {
                rmiServer.closeContext(this.context.getRMIContext(), "application: " + this.name + " destroy invoked");
                rmiServer.unsetContext(this.name, false);
                this.context.unsetRMIContext();
            }
            if ((localRmiServer = this.server.getLocalRmiServer()) != null) {
                localRmiServer.unsetContext(this.name, false);
                this.context.unsetRMIContext();
            }
        }
        catch (NamingException e) {
            System.err.println("Error unbinding " + this.config + ": " + e.getMessage());
        }
    }

    private void updateJAZNConfiguration() {
        try {
            ApplicationConfigReference globalApp = this.getServer().getConfig().getSystemApplicationConfigReference();
            if (globalApp != null) {
                Vector loginModules;
                String globalAppName = globalApp.getName();
                ObjectName securityProviderName = ObjectNameFactory.create((String)("oc4j:j2eeType=Security,name=SecurityProvider,J2EEApplication=" + globalAppName + ",J2EEServer=" + "standalone"));
                MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
                if (oc4jMBeanServer.isRegistered(securityProviderName) && (loginModules = (Vector)oc4jMBeanServer.invoke(securityProviderName, "listLoginModules", new Object[]{this.config.getName()}, new String[]{"java.lang.String"})) != null) {
                    Object[] params = new Object[2];
                    String[] signature = new String[]{"java.lang.String", "java.lang.String"};
                    for (int n = 0; n < loginModules.size(); ++n) {
                        ArrayList loginModule = (ArrayList)loginModules.get(n);
                        params[0] = this.config.getName();
                        params[1] = loginModule.get(1);
                        oc4jMBeanServer.invoke(securityProviderName, "remLoginModule", params, signature);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public Application getParent() {
        return this.parent;
    }

    public EJBContainer getEJBContainer() {
        if (!this.devtestMode) {
            return this.appState.getEJBContainer();
        }
        return this.mockEjbContainer;
    }

    public DatabaseSchema getDatabaseSchema(String sourceLocation) throws InstantiationException {
        if (!(sourceLocation != null && sourceLocation.length() != 0 || (sourceLocation = this.getDefaultDataSourceJNDILocation()) != null && sourceLocation.length() != 0)) {
            if (this.parent != null) {
                return this.parent.getDatabaseSchema(sourceLocation);
            }
            throw new InstantiationException("No DataSource found at " + sourceLocation);
        }
        ManagedDataSourceConfig mdsc = this.getManagedDataSourceConfigForJNDILocation(sourceLocation);
        if (mdsc != null && mdsc.getDatabaseSchemaPath() != null) {
            return this.getConfig().getDatabaseSchema(mdsc.getDatabaseSchemaPath());
        }
        try {
            DataSourceConnectionContainer container = this.getDataSourceContainer(sourceLocation, -7);
            if (container.getDatabaseSchema() == null) {
                container.setDatabaseSchema(new DatabaseSchema(container, sourceLocation));
            }
            return container.getDatabaseSchema();
        }
        catch (RemoteException e) {
            m_logger.warning("Warning: Exception occurred getting database schema.  Exception: " + e);
        }
        catch (SQLException e) {
            m_logger.warning("Warning: Exception occurred getting database schema.  Exception: " + e);
        }
        catch (Exception e) {
            m_logger.warning("Warning: Exception occurred getting database schema.  Exception: " + e);
        }
        if (defaultSchema == null) {
            defaultSchema = new DatabaseSchema("Default");
        }
        return defaultSchema;
    }

    public DataSourceConnectionContainer getDataSourceContainer(String initialName, int isolationLevel) throws InstantiationException {
        return this.appState.getDataSourceContainer(initialName, isolationLevel);
    }

    public void removeDataSourceCache() {
        this.appState.removeDataSourceCache();
    }

    public final Application getApplication() {
        return this;
    }

    public Context getEnvironmentContext() throws NamingException {
        throw new NamingException("Cannot lookup java:comp/env attributes, not in a valid component");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushWebAppConfigs() {
        String string = this.webApplicationConfigsLock;
        synchronized (string) {
            if (this.webApplicationConfigs == null) {
                return;
            }
            Object[] keys = this.webApplicationConfigs.keySet().toArray();
            for (int n = 0; n < keys.length; ++n) {
                this.webApplicationConfigs.remove(keys[n]);
            }
            this.webApplicationConfigs = null;
        }
    }

    public static Object getInternalError(String message) {
        throw new InternalError(message);
    }

    public synchronized void addChild(Application application) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(application);
    }

    public synchronized void removeChild(Application application) {
        if (this.children == null) {
            return;
        }
        this.children.remove(application);
    }

    public PermissionCollection getPermissions(URL url) {
        ApplicationPermissionCollection permissions = new ApplicationPermissionCollection(this);
        if (url != null && url.getProtocol().equals("file")) {
            permissions.add(new FilePermission(new File(url.getFile()).getAbsolutePath(), "read"));
            permissions.add(new FilePermission(new File(url.getFile()).getAbsolutePath() + File.separator + "-", "read"));
        }
        return permissions;
    }

    public ProtectionDomain getProtectionDomain(URL url) {
        CodeSource source = new CodeSource(url, (Certificate[])null);
        return new ProtectionDomain(source, this.getPermissions(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteData getJar(String name, long requestedLastModified) throws IOException {
        long lastModified = 0L;
        Collection clients = this.config.getClients();
        boolean found = false;
        Iterator iterator = clients.iterator();
        while (iterator.hasNext()) {
            ClientModule module = (ClientModule)iterator.next();
            if (!module.getPath().equals(name)) continue;
            found = true;
            break;
        }
        try {
            if (name.length() == 0 || name.startsWith("/") || name.indexOf("..") >= 0 || name.startsWith(File.separator)) {
                throw new IllegalArgumentException("Illegal name: " + name);
            }
            Object object = null;
            if (((EnterpriseArchive)this.config).isSeparateDeploymentContext()) {
                try {
                    if (this.config.getDeploymentContext() instanceof LastModifiedContainer && requestedLastModified / 1000L == (lastModified = ((LastModifiedContainer)((Object)this.config.getDeploymentContext())).getLastModified(Application.getClientName(name))) / 1000L && requestedLastModified > 0L) {
                        return new RemoteData(null, requestedLastModified);
                    }
                    object = this.config.getDeploymentContext().lookup(Application.getClientName(name));
                }
                catch (NamingException e) {
                }
                catch (InstantiationException e) {
                    throw new IOException("Error accessing deployment directory: " + e.getMessage());
                }
            }
            if (object == null) {
                if (this.config.getContext() instanceof LastModifiedContainer && requestedLastModified / 1000L == (lastModified = ((LastModifiedContainer)((Object)this.config.getContext())).getLastModified(name)) / 1000L) {
                    return new RemoteData(null, requestedLastModified);
                }
                if (this.config.getContext() != null) {
                    object = this.config.getContext().lookup(name);
                }
            }
            if (!found) {
                Application application = this;
                synchronized (application) {
                    if (this.verifiedClientFriendJars == null) {
                        this.verifiedClientFriendJars = new ArrayList();
                    }
                    if (this.verifiedClientFriendJars.contains(name)) {
                        found = true;
                    } else {
                        Iterator modules = this.config.getClients().iterator();
                        while (modules.hasNext() && !found) {
                            try {
                                int index;
                                String classpath;
                                ClientModule module = (ClientModule)modules.next();
                                ContextLocation location = new ContextLocation();
                                location.context = ContextUtils.getContext(this.config.getContext(), module.getPath(), true);
                                if (location.context == null || (classpath = location.getManifestAttribute(Attributes.Name.CLASS_PATH)) == null || (index = classpath.indexOf(name)) < 0 || index != 0 && classpath.charAt(index - 1) != ' ' || index != classpath.length() - name.length() && classpath.charAt(index + name.length()) != ' ') continue;
                                found = true;
                                this.verifiedClientFriendJars.add(name);
                                break;
                            }
                            catch (Throwable t) {
                            }
                        }
                    }
                }
            }
            if (!found) {
                return null;
            }
            if (!(object instanceof byte[])) {
                throw new IllegalArgumentException("Only jars are downloadable, not directories");
            }
            byte[] data = (byte[])object;
            return new RemoteData(data, lastModified);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            return null;
        }
    }

    public RemoteData getClassData(String name, long requestLastModified) throws IOException {
        return this.appState.getClassData(name, requestLastModified);
    }

    public String serverEncode(String string) {
        string = StringUtils.replace(string, "com.evermind", "com.evermind[" + ApplicationServer.INFO + "]");
        return StringUtils.replace(string, "com.orionserver", "com.orionserver[" + ApplicationServer.INFO + "]");
    }

    public void printStackTrace(Throwable t, PrintWriter out) {
        ThreadState state = ThreadState.getCurrentState();
        if (state.applicationThread != null && state.applicationThread.httpHandler != null && state.applicationThread.httpHandler.request.getApplication() != null) {
            try {
                ByteArrayOutputStream textOut = new ByteArrayOutputStream();
                t.printStackTrace(new PrintWriter(textOut, true));
                textOut.close();
                String exceptionString = new String(textOut.toByteArray());
                exceptionString = this.serverEncode(exceptionString);
                exceptionString = state.applicationThread.httpHandler.request.getApplication().jspPageNameEncode(exceptionString, null);
                out.print(exceptionString);
                if (t instanceof SQLException && ((SQLException)t).getNextException() != null) {
                    out.print("chained SQL error is; ");
                    this.printStackTrace(((SQLException)t).getNextException(), out);
                }
            }
            catch (IOException e) {
                this.log("IO error writing stacktrace", e);
            }
        } else {
            t.printStackTrace(out);
        }
    }

    public Context getAssemblyContext() {
        return this.config.getContext();
    }

    private static String getClientName(String clientName) {
        if (clientName.indexOf(47) >= 0) {
            clientName = clientName.substring(clientName.lastIndexOf(47) + 1);
        }
        if (clientName.indexOf(File.separatorChar) >= 0) {
            clientName = clientName.substring(clientName.lastIndexOf(File.separatorChar) + 1);
        }
        return clientName;
    }

    public boolean isInitialized() {
        return this.appState.isInitialized();
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public Object getDeployedJEMApplication() {
        return this.deployedJEMApplication;
    }

    public void setDeployedJEMApplication(Object deployedjemapplication) {
        this.deployedJEMApplication = deployedjemapplication;
    }

    public String getProperCMTSourceName(String name) {
        return name;
    }

    public ResourceProvider getProvider(String name) {
        return this.appState.getProvider(name);
    }

    public static NounIntf getJ2eeNoun() {
        NounFactoryIntf nounFactory;
        if (j2eeNoun == null && (nounFactory = ApplicationServer.nounFactory()) != null) {
            j2eeNoun = nounFactory.create("/oc4j");
        }
        return j2eeNoun;
    }

    public static NounIntf getApplicationNoun(String appName) {
        NounFactoryIntf nounFactory = ApplicationServer.nounFactory();
        if (nounFactory != null) {
            return nounFactory.create(Application.getJ2eeNoun(), appName, "oc4j_ear");
        }
        return null;
    }

    public NounIntf getApplicationNoun() {
        return this.appNoun != null ? this.appNoun : (this.appNoun = Application.getApplicationNoun(this.getName()));
    }

    public DeployedAdapter getActiveDeployedAdapter(String name) {
        return this.appState.getActiveDeployedAdapter(name);
    }

    DeployedAdapter getDeployedAdapter(String name) {
        return this.appState.getResourceAdapter(name);
    }

    public ResourceAdapterWrapper lookupResourceAdapter(String name) throws NamingException {
        return this.appState.lookupResourceAdapter(name);
    }

    void initHttp() throws InstantiationException {
        this.configs = new ArrayList();
        Iterator iterator = this.getConfig().getWebApplications().iterator();
        while (iterator.hasNext()) {
            WebModule module = (WebModule)iterator.next();
            String[] params = new String[]{module.getPath().toString()};
            this.sendNotification("INITIALIZE_BEGINS", params);
            HttpApplicationConfig config = this.getHttpApplicationConfig(module.getName());
            this.configs.add(config);
            this.sendNotification("INITIALIZE_ENDS", params);
        }
    }

    void initRoleMapping() throws InstantiationException {
        if (this.config instanceof SecurityRoleContainer) {
            List roles = ((SecurityRoleContainer)((Object)this.config)).getSecurityRoles();
            this.initRoleMapping(roles);
        }
        if (null != this.configs) {
            Iterator iterator = this.configs.iterator();
            while (iterator.hasNext()) {
                HttpApplicationDescriptor webBundle = (HttpApplicationDescriptor)iterator.next();
                List roles = webBundle.getSecurityRoles();
                this.initRoleMapping(roles);
            }
        }
    }

    private void initRoleMapping(List roles) throws InstantiationException {
        if (null != roles) {
            Iterator iter2 = roles.iterator();
            while (iter2.hasNext()) {
                this.registerWithJACC((SecurityRole)iter2.next());
            }
        }
    }

    void registerWithJACC(SecurityRole securityRole) throws InstantiationException {
        if (JaccWrapper.isJaccEnabled()) {
            try {
                new JaccWrapper(this.getName()).addRoleMapping(securityRole);
            }
            catch (Exception e) {
                throw new InstantiationException(e.getMessage());
            }
        }
    }

    public void flushPropDD(Notifier notifier) throws InstantiationException {
        Iterator iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            HttpApplicationDescriptor webBundle = (HttpApplicationDescriptor)iterator.next();
            if (webBundle.getWebServicesDescriptor() != null || !webBundle.getServiceReferences().isEmpty()) continue;
            this.flushPropDD(webBundle, notifier);
        }
    }

    public void flushPropDD(HttpApplicationDescriptor webBundle, Notifier notifier) throws InstantiationException {
        try {
            String webAppDeployed;
            String string = webAppDeployed = webBundle.isSynthetic() ? null : webBundle.isDeployed();
            if (webAppDeployed != null) {
                webBundle.storeDeployment();
            }
        }
        catch (IOException e) {
            String msg = "Error storing web deployment descriptor for web app " + webBundle.getName() + " : " + e.getMessage();
            if (notifier != null) {
                String[] params = new String[]{webBundle.getName()};
                notifier.sendNotification("ERROR_STORING_WEB_APP_DEPLOYMENT_DESC", params, e);
            } else {
                System.err.println(msg);
            }
            throw new InstantiationException(msg);
        }
    }

    public ResourceProvider[] getResourceProviders() {
        return this.appState.getResourceProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookupResource(String name) throws NamingException, InstantiationException {
        int slashIndex = name.indexOf(47);
        if (slashIndex < 0) {
            throw new NameNotFoundException("No resource named '" + name + "'found");
        }
        String providerName = name.substring(0, slashIndex);
        String resourceName = name.substring(slashIndex + 1);
        Object resource = null;
        ThreadState state = ThreadState.getCurrentState();
        ContextContainer previousContainer = state.contextContainer;
        try {
            state.contextContainer = this;
            for (Application application = this; resource == null && application != null; application = application.getParent()) {
                ResourceProvider provider;
                try {
                    provider = application.getProvider(providerName);
                }
                catch (ApplicationStateStopped.ApplicationStoppedException e) {
                    InstantiationException excep = new InstantiationException("Could not get provider for " + providerName);
                    excep.initCause(e);
                    throw excep;
                }
                if (provider == null) continue;
                resource = provider.getResource(resourceName);
            }
        }
        finally {
            state.contextContainer = previousContainer;
        }
        if (resource == null) {
            throw new NameNotFoundException("No resource named '" + name + "'found");
        }
        return resource;
    }

    private final void removeTempHttpDirs() {
        Collection webapps = this.getConfig().getWebApplications();
        if (webapps == null || webapps != null && webapps.isEmpty()) {
            return;
        }
        Iterator iterator = webapps.iterator();
        String deploymentURL = ((EnterpriseArchive)this.getConfig()).getDeploymentURL().getFile();
        while (iterator.hasNext()) {
            WebModule module = (WebModule)iterator.next();
            String tempDir = deploymentURL + module.getName() + File.separator + "temp";
            File file = new File(tempDir);
            if (!file.exists()) continue;
            try {
                FileUtils.recursiveRemove(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Map getAttributes() {
        Map attributes = super.getAttributes();
        if (attributes.isEmpty()) {
            attributes.put("context", this.context);
        }
        return attributes;
    }

    private final void addClusteredApplicationMBean(Notifier notifier) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        ClusteredApplication mbean = new ClusteredApplication(new ClusteredApplicationConfigProxy(this), this.name);
        try {
            if (!oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    protected void removeUserApplicationMBeans() {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName userMBeanPattern = new ObjectName(this.name + ":*");
            Set<ObjectName> userMBeans = oc4jMBeanServer.queryNames(userMBeanPattern, null);
            Iterator<ObjectName> iter = userMBeans.iterator();
            while (iter.hasNext()) {
                try {
                    oc4jMBeanServer.unregisterMBean(iter.next());
                }
                catch (InstanceNotFoundException e) {
                }
                catch (MBeanRegistrationException re) {
                    re.printStackTrace();
                }
            }
            if (this.registeredSharedUserMBeans_ != null && this.registeredSharedUserMBeans_.size() > 0) {
                iter = this.registeredSharedUserMBeans_.iterator();
                while (iter.hasNext()) {
                    try {
                        oc4jMBeanServer.unregisterMBean(iter.next());
                    }
                    catch (InstanceNotFoundException e) {
                    }
                    catch (MBeanRegistrationException re) {
                        re.printStackTrace();
                    }
                }
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void addJ2EEApplicationMBean(Notifier notifier) {
        if (this.getGenerationNumber() > 0) {
            this.registerApplicationMBeans(notifier);
            return;
        }
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        J2EEApplicationCallBackIf callbackApplication = this.parent == null ? new RestrictedApplicationMBeanImpl(this) : this;
        J2EEApplication mbean = new J2EEApplication(callbackApplication, this.name);
        boolean wasReplaced = false;
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
                wasReplaced = true;
                this.j2eeApplicationMBean_ = null;
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
            this.j2eeApplicationMBean_ = mbean;
            this.registerSecurityProviderMBean();
            this.registerApplicationMBeans(notifier);
            if (wasReplaced) {
                J2EEServer.notifyApplicationReplaced(this.name);
            } else {
                J2EEServer.notifyApplicationAdded(this.name);
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public final synchronized String getdeploymentDescriptor() {
        EnterpriseArchive archive = (EnterpriseArchive)this.config;
        return archive.getdeploymentDescriptor();
    }

    public final synchronized String getproprietaryDeploymentDescriptor() {
        EnterpriseArchive archive = (EnterpriseArchive)this.config;
        return archive.getproprietaryDeploymentDescriptor();
    }

    public final ObjectName getparentApplication() {
        if (this.parent == null) {
            return null;
        }
        try {
            J2EEApplication mbean = new J2EEApplication(this.parent, this.parent.name);
            return mbean.getObjectName();
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public synchronized Set getUsers() {
        HashSet<oracle.oc4j.admin.management.shared.User> users = new HashSet<oracle.oc4j.admin.management.shared.User>();
        UserManager stop = this.config.getParentUserManager();
        for (UserManager userManager = this.config.getUserManager(); userManager != null && userManager != stop; userManager = userManager.getParent()) {
            int userCnt = userManager.getUserCount();
            List lst = userManager.getUsers(0, userCnt);
            Iterator iter = lst.iterator();
            while (iter.hasNext()) {
                User user = (User)iter.next();
                users.add(new oracle.oc4j.admin.management.shared.User(user.getName(), user.getDescription()));
            }
        }
        return users;
    }

    public void addUser(String username, String password, String description) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        UserManagerUtils.addUser(usrmngr, username, password, description);
    }

    public oracle.oc4j.admin.management.shared.WebModule[] getsyntheticWebModules() {
        HashSet<oracle.oc4j.admin.management.shared.WebModule> res = new HashSet<oracle.oc4j.admin.management.shared.WebModule>();
        ApplicationConfig conf = this.getConfig();
        Collection webModules = conf.getWebApplications();
        Iterator it = webModules.iterator();
        while (it.hasNext()) {
            WebModule webMod = (WebModule)it.next();
            if (!webMod.isSynthetic()) continue;
            oracle.oc4j.admin.management.shared.WebModule wmod = new oracle.oc4j.admin.management.shared.WebModule(conf.getName(), webMod.getName(), webMod.getContextRoot(), true);
            res.add(wmod);
        }
        oracle.oc4j.admin.management.shared.WebModule[] ret = new oracle.oc4j.admin.management.shared.WebModule[res.size()];
        it = res.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = (oracle.oc4j.admin.management.shared.WebModule)it.next();
        }
        return ret;
    }

    public void removeUser(String username) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        UserManagerUtils.removeUser(usrmngr, username);
    }

    public synchronized Set getGroupsForUser(String username) {
        return UserManagerUtils.getGroupsForUser(this.config, username);
    }

    public synchronized Set getGroups() {
        return UserManagerUtils.getGroups(this.config);
    }

    public void addGroup(String groupname, String description) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        UserManagerUtils.addGroup(usrmngr, groupname, description);
    }

    public void removeGroup(String groupname) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        UserManagerUtils.removeGroup(usrmngr, groupname);
    }

    public void addUserToGroup(String username, String groupname) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        UserManagerUtils.addUserToGroup(usrmngr, username, groupname);
    }

    public void removeUserFromGroup(String username, String groupname) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        UserManagerUtils.removeUserFromGroup(usrmngr, username, groupname);
    }

    public Set getPermissionsForGroup(String groupname) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        return UserManagerUtils.getPermissionsForGroup(usrmngr, groupname);
    }

    public void addPermissionToGroup(String permissionclass, String permissionname, String actions, String groupname) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        UserManagerUtils.addPermissionToGroup(usrmngr, permissionclass, permissionname, actions, groupname);
    }

    public void removePermissionFromGroup(String permissionclass, String permissionname, String actions, String groupname) {
        UserManager usrmngr = this.getUserManagerFromConfig();
        UserManagerUtils.removePermissionFromGroup(usrmngr, permissionclass, permissionname, actions, groupname);
    }

    public final void start() {
        try {
            this.doStart(true);
            this.setStart(true);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            ServerMessages.warningUnableToStartApplication(this.name, ie);
            if (this.config.getName().equals("system") || this.config.getName().equals("default")) {
                this.server.stop();
            }
            return;
        }
        HttpServer httpServer = ApplicationServer.getInstance().getHttpServer();
        if (httpServer != null) {
            httpServer.startHttpApplications(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doStart(boolean ignoreStartFlag) throws InstantiationException {
        Object object = this;
        synchronized (object) {
            if (this.state_ == 0 || this.state_ == 1) {
                m_logger.log(Level.FINE, "application: " + this.name + " is already running. Start is a no-op");
                return;
            }
            this.state_ = 0;
        }
        object = this.stateMgmtLock;
        synchronized (object) {
            if (this.parent != null) {
                if (this.parent.getstate() == 4) {
                    return;
                }
                if (this.parent.getstate() != 1 || this.parent.getstate() != 0) {
                    this.parent.start();
                    if (this.parent.getstate() == 4) {
                        m_logger.log(Level.WARNING, "could not start parent. Application: " + this.name + " not started");
                        return;
                    }
                }
            }
            this.setConfig(this.config, ignoreStartFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.stateMgmtLock;
        synchronized (object) {
            this.doStop();
            try {
                this.setStart(false);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public final void doStop() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopForceful() {
        m_logger.log(Level.FINEST, "Invoking stopForceful");
        this.setStopTimeout(10);
        if (this.destroyed) {
            return;
        }
        Application[] childListCopy = null;
        Application application = this;
        synchronized (application) {
            if (this.children != null) {
                childListCopy = this.children.toArray(new Application[this.children.size()]);
            }
        }
        if (childListCopy != null) {
            for (int i = 0; i < childListCopy.length; ++i) {
                Application childApplication = childListCopy[i];
                m_logger.log(Level.FINEST, "Invoking stopForceful on child application: " + childApplication.getName());
                childApplication.stopForceful();
            }
        }
        Application application2 = this;
        synchronized (application2) {
            this.stateCleanUp(false);
            this.appState = new ApplicationStateStopped(this, null, 3);
            this.state_ = 3;
        }
    }

    public void removeAppProperties() {
        ArrayList appProperties = ApplicationProperties.getProperties(this.name);
        if (appProperties != null) {
            for (int n = 0; n < appProperties.size(); ++n) {
                OC4JProperty oc4jProperty = (OC4JProperty)appProperties.get(n);
                this.applicationProperties.removeProperty(oc4jProperty.getName());
            }
        }
    }

    void setRMIContextClassLoader(ClassLoader classLoader) {
        RMIServerContext rmiContext = this.context.getRMIContext();
        if (rmiContext != null) {
            rmiContext.setClassLoader(classLoader);
        }
    }

    private void gatherApplicationComponents(List httpApplications, ApplicationState state) {
        List connectorArchiveList;
        Iterator iterator = httpApplications.iterator();
        while (iterator.hasNext()) {
            HttpApplication httpApplication = (HttpApplication)iterator.next();
            if (httpApplication == null) continue;
            if (this.appComponentList.isEmpty()) {
                this.appComponentList.add(httpApplication);
                continue;
            }
            for (int i = 0; i < this.appComponentList.size(); ++i) {
                Object obj = this.appComponentList.get(i);
                if (!(obj instanceof HttpApplication) || ((HttpApplication)obj).getName().equals(httpApplication.getName())) continue;
                this.appComponentList.add(httpApplication);
            }
        }
        if (this.appState.getEJBContainer() != null) {
            this.appComponentList.add(this.appState.getEJBContainer());
        }
        if ((connectorArchiveList = state.getActiveResourceAdapters()) != null) {
            this.appComponentList.addAll(connectorArchiveList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRecursive() {
        Object object = this.stateMgmtLock;
        synchronized (object) {
            this.start();
            Application application = this;
            synchronized (application) {
                if (this.state_ == 4) {
                    m_logger.log(Level.WARNING, "application: " + this.name + " failed to start. Will not start any children");
                    return;
                }
            }
            this.stopOrStartAllChildApplications(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void restart() {
        ApplicationProtocol.PRE_RESTART_APPLICATION.fire(this.config, this);
        Object object = this.stateMgmtLock;
        synchronized (object) {
            this.doStop();
            try {
                this.doStart(true);
                ApplicationProtocol.POST_RESTART_APPLICATION.fire(this.config, this);
            }
            catch (InstantiationException e) {
                m_logger.log(Level.WARNING, "Unable to restart application : " + this.name + "\n" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void restartRecursive() {
        Object object = this.stateMgmtLock;
        synchronized (object) {
            ApplicationProtocol.PRE_RESTART_APPLICATION.fire(this.config, this);
            this.doStop();
            this.startRecursive();
            ApplicationProtocol.POST_RESTART_APPLICATION.fire(this.config, this);
        }
    }

    public final long getstartTime() {
        return this.appState.getstartTime();
    }

    public final int getstate() {
        return this.state_;
    }

    public boolean isRunning() {
        return this.getstate() == 1;
    }

    private final void addWebModuleMBean(WebModuleCallBackIf cback, String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        oracle.oc4j.admin.management.mbeans.WebModule mbean = new oracle.oc4j.admin.management.mbeans.WebModule(cback, this.config.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private final void addOC4JWebModuleMBean(OC4JWebModuleCallBackIf cback, String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        OC4JWebModule mbean = new OC4JWebModule(cback, this.config.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private final void removeWebModuleMBean(String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        oracle.oc4j.admin.management.mbeans.WebModule mbean = new oracle.oc4j.admin.management.mbeans.WebModule(null, this.config.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
                ObjectName app = mbean.getObjectName();
                String webName = app.getKeyProperty("name");
                String j2eeServerName = app.getKeyProperty("J2EEServer");
                String j2eeAppName = app.getKeyProperty("WebModule");
                ObjectName childPattern = new ObjectName(app.getDomain() + ":J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName + ",WebModule=" + webName + " ,*");
                Set<ObjectName> childs = oc4jMBeanServer.queryNames(childPattern, null);
                Iterator<ObjectName> iter = childs.iterator();
                while (iter.hasNext()) {
                    try {
                        oc4jMBeanServer.unregisterMBean(iter.next());
                    }
                    catch (InstanceNotFoundException e) {}
                }
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private final void removeOC4JWebModuleMBean(String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        OC4JWebModule mbean = new OC4JWebModule(null, this.config.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
                ObjectName app = mbean.getObjectName();
                String webName = app.getKeyProperty("name");
                String j2eeServerName = app.getKeyProperty("J2EEServer");
                String j2eeAppName = app.getKeyProperty("OC4JWebModule");
                ObjectName childPattern = new ObjectName(app.getDomain() + ":J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName + ",OC4JWebModule=" + webName + " ,*");
                Set<ObjectName> childs = oc4jMBeanServer.queryNames(childPattern, null);
                Iterator<ObjectName> iter = childs.iterator();
                while (iter.hasNext()) {
                    try {
                        oc4jMBeanServer.unregisterMBean(iter.next());
                    }
                    catch (InstanceNotFoundException e) {}
                }
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private final void removeAppClientModuleMBean(String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        AppClientModule mbean = new AppClientModule(null, this.config.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private final void addAppClientModuleMBean(AppClientModuleCallBackIf cback, String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        AppClientModule mbean = new AppClientModule(cback, this.config.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                this.removeAppClientModuleMBean(name);
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    final void addAppClientModuleMBean(ClientModule client, ApplicationConfig config) {
        String path = client.getPath();
        path = XMLUtils.encode(path);
        ApplicationClientServerArchive archive = null;
        try {
            archive = config.getClientArchive(client.getPath(), this.appState.getClassLoader());
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        if (archive == null) {
            this.addAppClientModuleMBean(archive, this.getConfig().getName());
        } else {
            String nm = archive.getName();
            if (nm.endsWith(".jar")) {
                int end = path.lastIndexOf(46);
                nm = nm.substring(0, end);
            }
            nm = ObjectNameUtil.quote((String)nm);
            this.addAppClientModuleMBean(archive, nm);
        }
    }

    private final void addResourceAdapterModuleMBean(ResourceAdapterModuleCallBackIf cback, String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        ResourceAdapterModule mbean = new ResourceAdapterModule(cback, this.config.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                this.removeResourceAdapterModuleMBean(name);
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private final void removeResourceAdapterModuleMBean(String name) {
        Application.removeResourceAdapterModuleMBean(name, this.config.getName());
    }

    public static void removeResourceAdapterModuleMBean(String name, String appName) {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            ResourceAdapterModule mbean = new ResourceAdapterModule(null, appName, name);
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public List getAppComponentList() {
        return this.appComponentList;
    }

    final void removeAllResourceAdapterModuleMBeans() {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            String appName = this.config.getName();
            String j2eeServerName = "standalone";
            String domain = "oc4j";
            ObjectName childPattern = new ObjectName(domain + ":j2eeType=ResourceAdapterModule,J2EEApplication=" + appName + ",J2EEServer=" + j2eeServerName + ",*");
            Set<ObjectName> childs = oc4jMBeanServer.queryNames(childPattern, null);
            Iterator<ObjectName> iter = childs.iterator();
            while (iter.hasNext()) {
                oc4jMBeanServer.unregisterMBean(iter.next());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    final void addResourceAdapterModuleMBean(ConnectorModule module) {
        String name = module.getName();
        this.addResourceAdapterModuleMBean(module, name);
    }

    void addJavaMailResourceMBean(JavaMailResourceCallBackIf cback) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        String name = cback.getLocation();
        JavaMailResource mbean = new JavaMailResource(cback, name, this.getConfig().getName());
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                this.removeJavaMailResourceMBean(name);
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void removeJavaMailResourceMBean(String name) {
        try {
            JavaMailResource mbean = new JavaMailResource(null, name, this.getConfig().getName());
            ObjectName javaMailResMBean = mbean.getObjectName();
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            if (oc4jMBeanServer.isRegistered(javaMailResMBean)) {
                oc4jMBeanServer.unregisterMBean(javaMailResMBean);
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    final void removeAllJavaMailResourceMBeans() {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName childPattern = new ObjectName("oc4j:j2eeType=JavaMailResource,J2EEApplication=" + this.getConfig().getName() + ",J2EEServer=" + "standalone" + ",*");
            Set<ObjectName> childs = oc4jMBeanServer.queryNames(childPattern, null);
            Iterator<ObjectName> iter = childs.iterator();
            while (iter.hasNext()) {
                ObjectName objName = iter.next();
                if (!oc4jMBeanServer.isRegistered(objName)) continue;
                oc4jMBeanServer.unregisterMBean(objName);
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void registerSecurityProviderMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        UserManager usrmngr = this.config.getUserManager();
        if (usrmngr == null) {
            ServerMessages.warningUndefinedUserManagerPreventsMBeanRegistration(this);
            return;
        }
        if (!SecurityUtil.isJAZN(usrmngr)) {
            ServerMessages.warningWrongUserManagerPreventsMBeanRegistration(this);
            return;
        }
        try {
            usrmngr = SecurityUtil.toJAZN(usrmngr);
            Class<?> securityProviderClass = Class.forName(((JAZNUserManager)usrmngr).getJAZNConfig().getSecurityProviderClassName(), true, this.getParentClassLoader());
            Constructor<?> objCtr = securityProviderClass.getConstructor(JAZNUserManager.class);
            SecurityProviderCallbackIf securityProviderCallback = (SecurityProviderCallbackIf)objCtr.newInstance(usrmngr);
            SecurityProviderManager securityProviderMbean = new SecurityProviderManager(this.name, securityProviderCallback, this);
            if (oc4jMBeanServer.isRegistered(securityProviderMbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(securityProviderMbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(securityProviderMbean), securityProviderMbean.getObjectName());
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("j2ee.state.running");
            oc4jMBeanServer.addNotificationListener(this.j2eeApplicationMBean_.getObjectName(), securityProviderMbean, (NotificationFilter)filter, null);
        }
        catch (Throwable t) {
            System.out.println("Error while registering security provider MBean for application " + this.name);
            t.printStackTrace();
        }
    }

    public synchronized void addMailSession(String location, Properties properties) {
        MailSessionInfo mailSessInf = new MailSessionInfo(location, properties);
        try {
            this.config.addMailSession(mailSessInf);
            this.setMailSessions(this.config.getMailSessions());
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public synchronized void removeMailSession(String location) {
        try {
            this.config.removeMailSession(location);
            this.setMailSessions(this.config.getMailSessions());
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String getejbClassLoaderPath() {
        return this.appState.getejbClassLoaderPath();
    }

    public synchronized byte[] getiiopStubs() throws IOException {
        try {
            Context ctx = this.config.getDeploymentContext();
            byte[] clientJarBytes = (byte[])ctx.lookup("_iiopClient.jar");
            return clientJarBytes;
        }
        catch (NameNotFoundException e) {
            OC4JProperty generateIIOP = OC4JProperties.getOC4JProperty("generateIIOP");
            if (generateIIOP == null || !generateIIOP.getBooleanValue()) {
                throw new FileNotFoundException("GenerateIIOP property not enabled at server level. This property should be set to true for IIOP stubs to be generated");
            }
            throw new FileNotFoundException("IIOP client stubs jar file not found. Make sure IIOP is enabled (enableIIOP) for this application at deployment time. " + e.getMessage());
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void registerApplicationMBeans(Notifier notifier) {
        List mbeanDescriptors = this.getConfig().getJMXMBeans();
        this.registeredSharedUserMBeans_ = new HashSet();
        if (mbeanDescriptors != null) {
            Iterator iter = mbeanDescriptors.iterator();
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            while (iter.hasNext()) {
                JMXMBeanDescriptor descriptor = (JMXMBeanDescriptor)iter.next();
                if (descriptor.getObjectName() == null || descriptor.getClass() == null) continue;
                String objName = null;
                try {
                    Class<?> mbeanCl = Class.forName(descriptor.getClassName(), true, this.appState.getClassLoader());
                    Constructor<?> mbeanConst = mbeanCl.getConstructor(null);
                    Object mbean = mbeanConst.newInstance(null);
                    String appDomainName = this.getConfig().getName();
                    objName = descriptor.getObjectName();
                    ObjectName tmpObj = new ObjectName(objName);
                    int domainLessIndex = objName.indexOf(58);
                    if (!"default".equals(tmpObj.getDomain())) {
                        objName = appDomainName + objName.substring(domainLessIndex);
                    }
                    ObjectName objectName = new ObjectName(objName);
                    if (notifier != null) {
                        String[] params = new String[]{objName};
                        notifier.sendNotification("REGISTERING_APP_MBEAN", params);
                    }
                    if (mbean instanceof ModelMBeanProvider) {
                        mbean = ModelMBeanFactory.getModelMBean((ModelMBeanProvider)mbean);
                    }
                    if (oc4jMBeanServer.isRegistered(objectName)) {
                        oc4jMBeanServer.unregisterMBean(objectName);
                    }
                    oc4jMBeanServer.registerMBean(mbean, objectName);
                    if ("default".equals(objectName.getDomain())) {
                        this.registeredSharedUserMBeans_.add(objectName);
                    }
                    AttributeList validAttributes = new AttributeList();
                    AttributeList attributes = descriptor.getAttributes();
                    if (attributes == null || attributes.size() <= 0) continue;
                    Object[] attrArray = attributes.toArray();
                    for (int i = 0; i < attrArray.length; ++i) {
                        String type;
                        Attribute attr = (Attribute)attrArray[i];
                        String attrName = attr.getName();
                        Object attrValue = attr.getValue();
                        Object validAttrValue = this.createValidAttributeValue(attrValue, type = this.getAttributeType(oc4jMBeanServer, objectName, attrName));
                        if (validAttrValue == null) continue;
                        Attribute validAttr = new Attribute(attrName, validAttrValue);
                        validAttributes.add(validAttr);
                    }
                    oc4jMBeanServer.setAttributes(objectName, validAttributes);
                }
                catch (Throwable t) {
                    System.out.println("Error while registering MBean named: " + descriptor.getObjectName() + " whose implementation class is: " + descriptor.getClassName());
                    t.printStackTrace();
                    if (notifier == null) continue;
                    String[] params = new String[]{objName};
                    notifier.sendNotification("ERROR_REGISTERING_APP_MBEAN", params, t);
                }
            }
        }
    }

    private void initAttributeTypeMap() {
        if (this.attributeTypeMap == null) {
            this.attributeTypeMap = new HashMap();
            this.attributeTypeMap.put("javax.management.ObjectName", "javax.management.ObjectName");
            this.attributeTypeMap.put("java.lang.String", "java.lang.String");
            this.attributeTypeMap.put("java.lang.Integer", "java.lang.Integer");
            this.attributeTypeMap.put("int", "int");
            this.attributeTypeMap.put("java.lang.Long", "java.lang.Long");
            this.attributeTypeMap.put("long", "long");
            this.attributeTypeMap.put("java.lang.Short", "java.lang.Short");
            this.attributeTypeMap.put("short", "short");
            this.attributeTypeMap.put("java.lang.Float", "java.lang.Float");
            this.attributeTypeMap.put("float", "float");
            this.attributeTypeMap.put("java.lang.Double", "java.lang.Double");
            this.attributeTypeMap.put("double", "double");
            this.attributeTypeMap.put("java.lang.Character", "java.lang.Character");
            this.attributeTypeMap.put("char", "char");
            this.attributeTypeMap.put("java.lang.Boolean", "java.lang.Boolean");
            this.attributeTypeMap.put("boolean", "boolean");
            this.attributeTypeMap.put("java.lang.Byte", "java.lang.Byte");
            this.attributeTypeMap.put("byte", "byte");
            this.attributeTypeMap.put("java.util.Date", "java.util.Date");
        }
    }

    private boolean isValidAttributeType(String type) {
        this.initAttributeTypeMap();
        return type != null && this.attributeTypeMap.get(type) != null;
    }

    private Object getPrimitiveArrayElements(String primitiveClassCode, Object wrapperObjectArray) throws JMXRuntimeException {
        Object[] retObj = null;
        try {
            Object[] arrayElementMap = (Object[])wrapperObjectArray;
            if (primitiveClassCode.equals("J")) {
                long[] retlong = new long[arrayElementMap.length];
                for (int i = 0; i < arrayElementMap.length; ++i) {
                    retlong[i] = (Long)arrayElementMap[i];
                }
                retObj = retlong;
            } else if (primitiveClassCode.equals("Z")) {
                boolean[] retbool = new boolean[arrayElementMap.length];
                for (int i = 0; i < arrayElementMap.length; ++i) {
                    retbool[i] = (Boolean)arrayElementMap[i];
                }
                retObj = retbool;
            } else if (primitiveClassCode.equals("I")) {
                int[] retint = new int[arrayElementMap.length];
                for (int i = 0; i < arrayElementMap.length; ++i) {
                    retint[i] = (Integer)arrayElementMap[i];
                }
                retObj = retint;
            } else if (primitiveClassCode.equals("S")) {
                int[] retshort = new int[arrayElementMap.length];
                for (int i = 0; i < arrayElementMap.length; ++i) {
                    retshort[i] = ((Short)arrayElementMap[i]).shortValue();
                }
                retObj = retshort;
            } else if (primitiveClassCode.equals("F")) {
                float[] retfloat = new float[arrayElementMap.length];
                for (int i = 0; i < arrayElementMap.length; ++i) {
                    retfloat[i] = ((Float)arrayElementMap[i]).floatValue();
                }
                retObj = retfloat;
            } else if (primitiveClassCode.equals("B")) {
                byte[] retbyte = new byte[arrayElementMap.length];
                for (int i = 0; i < arrayElementMap.length; ++i) {
                    retbyte[i] = (Byte)arrayElementMap[i];
                }
                retObj = retbyte;
            } else if (primitiveClassCode.equals("D")) {
                double[] retdouble = new double[arrayElementMap.length];
                for (int i = 0; i < arrayElementMap.length; ++i) {
                    retdouble[i] = (Double)arrayElementMap[i];
                }
                retObj = retdouble;
            } else if (primitiveClassCode.equals("C")) {
                char[] retchar = new char[arrayElementMap.length];
                for (int i = 0; i < arrayElementMap.length; ++i) {
                    retchar[i] = ((Character)arrayElementMap[i]).charValue();
                }
                retObj = retchar;
            }
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, "Caught exception while parsing jmx-mbean subtag attribute");
        }
        return retObj;
    }

    private Object createValidAttributeValue(Object attrValue, String attrType) throws JMXRuntimeException {
        Object value;
        block31: {
            value = null;
            try {
                if (attrValue == null || attrType == null) break block31;
                if (attrValue instanceof String) {
                    if (attrType.equals("java.lang.String")) {
                        return attrValue;
                    }
                    if (!this.isValidAttributeType(attrType)) break block31;
                    String stringValue = (String)attrValue;
                    Class<?> attrClass = null;
                    try {
                        attrClass = Class.forName(attrType);
                    }
                    catch (ClassNotFoundException ex) {
                        // empty catch block
                    }
                    Class<?> stringClass = Class.forName("java.lang.String");
                    Constructor<?> constructorWithStringArg = null;
                    if (attrClass != null) {
                        constructorWithStringArg = attrClass.getConstructor(stringClass);
                    }
                    if (constructorWithStringArg != null) {
                        value = constructorWithStringArg.newInstance(stringValue);
                    } else if (attrType.equals("int")) {
                        value = new Integer(stringValue);
                    } else if (attrType.equals("double")) {
                        value = new Double(stringValue);
                    } else if (attrType.equals("float")) {
                        value = new Float(stringValue);
                    } else if (attrType.equals("boolean")) {
                        value = new Boolean(stringValue);
                    } else if (attrType.equals("long")) {
                        value = new Long(stringValue);
                    } else if (attrType.equals("char")) {
                        value = new Character(stringValue.trim().charAt(0));
                    } else if (attrType.equals("byte")) {
                        value = new Byte(stringValue);
                    } else if (attrType.equals("short")) {
                        value = new Short(stringValue);
                    }
                    break block31;
                }
                if (attrValue instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)attrValue;
                    if (attrType.startsWith("[")) {
                        String componentType;
                        if (attrType.length() < 3) {
                            value = this.getPrimitiveArrayElements(attrType.substring(1), arrayList.toArray());
                        } else if (attrType.startsWith("[L") && this.isValidAttributeType(componentType = attrType.substring(2, attrType.indexOf(";")))) {
                            Class<?> arrayClass = Class.forName(componentType);
                            Object arrayObject = Array.newInstance(arrayClass, new int[]{arrayList.size()});
                            for (int j = 0; j < arrayList.size(); ++j) {
                                Array.set(arrayObject, j, this.createValidAttributeValue(arrayList.get(j), componentType));
                            }
                            value = arrayObject;
                        }
                        break block31;
                    }
                    if (arrayList.size() == 1) {
                        return this.createValidAttributeValue(arrayList.get(0), attrType);
                    }
                    throw new JMXRuntimeException("Invalid value for jmx-mbean subtag attribute: expecting simple value");
                }
                throw new JMXRuntimeException("Invalid value for jmx-mbean subtag attribute");
            }
            catch (Exception e) {
                throw new JMXRuntimeException((Throwable)e, "Caught exception while parsing jmx-mbean subtag attribute");
            }
        }
        return value;
    }

    private String getAttributeType(MBeanServer mbeanServer, ObjectName objectName, String attributeName) throws JMXRuntimeException {
        if (mbeanServer != null && objectName != null && attributeName != null) {
            try {
                MBeanAttributeInfo[] attributes;
                MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
                if (mbeanInfo != null && (attributes = mbeanInfo.getAttributes()) != null && attributes.length > 0) {
                    for (int i = 0; i < attributes.length; ++i) {
                        if (!attributeName.equals(attributes[i].getName())) continue;
                        return attributes[i].getType();
                    }
                }
            }
            catch (Exception e) {
                throw new JMXRuntimeException((Throwable)e, "Caught exception while parsing jmx-mbean subtag attribute");
            }
        }
        return null;
    }

    public final synchronized String getarchivePath() {
        if (this.config == null) {
            throw new JMXRuntimeException("Application instance not configured");
        }
        URL archiveUrl = this.config.getArchiveURL();
        if (archiveUrl == null) {
            return null;
        }
        return archiveUrl.getPath();
    }

    public final synchronized String getapplicationRootDirectoryPath() {
        if (this.config == null) {
            throw new JMXRuntimeException("Application instance not configured");
        }
        URL rootUrl = this.config.getURL();
        if (rootUrl == null) {
            return null;
        }
        return rootUrl.getPath();
    }

    public synchronized String getdataSourcesDescriptor() throws IOException {
        if (this.config == null) {
            throw new JMXRuntimeException("Application instance not configured");
        }
        return this.config.getDataSourcesDescriptor();
    }

    public synchronized String listDataSources() throws IOException {
        if (this.config == null) {
            throw new JMXRuntimeException("Application instance not configured");
        }
        StringBuffer buf = new StringBuffer();
        DataSourcesConfig dsConfig = this.config.getDataSourcesConfig();
        buf.append("Native Data Sources\n");
        NativeDataSourceConfig[] ndsArray = dsConfig.getNativeDataSources();
        for (int i = 0; i < ndsArray.length; ++i) {
            buf.append(DataSourceConfigUtils.createNativeDataSourceConfigString(ndsArray[i]));
            buf.append("\n");
        }
        buf.append("Managed Data Sources\n");
        ManagedDataSourceConfig[] mdsArray = dsConfig.getManagedDataSources();
        for (int i = 0; i < mdsArray.length; ++i) {
            buf.append(DataSourceConfigUtils.createManagedDataSourceConfigString(mdsArray[i]));
            buf.append("\n");
        }
        return buf.toString();
    }

    public synchronized String listDataSourceConnectionPools() throws IOException {
        if (this.config == null) {
            throw new JMXRuntimeException("Application instance not configured");
        }
        StringBuffer buf = new StringBuffer();
        DataSourcesConfig dsConfig = this.config.getDataSourcesConfig();
        buf.append("Connection Pools\n");
        ConnectionPoolConfig[] cpArray = dsConfig.getConnectionPools();
        for (int i = 0; i < cpArray.length; ++i) {
            buf.append(DataSourceConfigUtils.createConnectionPoolConfigString(cpArray[i]));
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getcomponentClassification() {
        return this.config.getComponentClassification();
    }

    public synchronized String getmetricRulesDescriptor() {
        try {
            Context ctx = this.config.getDeploymentContext();
            if (ctx != null) {
                byte[] content = (byte[])ctx.lookup(DeploymentMetricRulesDescriptorPath);
                return new String(content);
            }
            return null;
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public final ApplicationConfigReference getApplicationConfigReference() {
        return this._applicationConfigReference;
    }

    public void setNotifier(Notifier notifier) {
        this._notifier = notifier;
    }

    Map getWebApplications() {
        return this.appState.getWebApplications();
    }

    public void setRoutingId(String routingId) {
        String oldId;
        if (routingId != null && routingId.equals("")) {
            routingId = null;
        }
        if ((oldId = this._applicationConfigReference.getRoutingId()) != null && !oldId.equals(routingId) || oldId == null && routingId != null) {
            this._applicationConfigReference.setRoutingId(routingId);
            if (OC4JServer.getOPMNEnabled()) {
                OC4JMonitorThread.changeAppRoutingId(this.name, routingId);
                OC4JMonitorThread.oc4jRuntimeConfigChanged();
            }
        }
    }

    public String getRoutingId() {
        return this._applicationConfigReference.getRoutingId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEJBModule(String jarName, byte[] data) throws InstantiationException {
        try {
            ApplicationProtocol.PRE_UPDATE_EJB_MODULE.fire(this, jarName, data);
            Object object = this.stateMgmtLock;
            synchronized (object) {
                this.doStop();
            }
            this.getEJBContainer().updateEJBModule(jarName, data);
        }
        finally {
            this.doStart(true);
            ApplicationProtocol.POST_UPDATE_EJB_MODULE.fire(this, jarName);
        }
    }

    public void addResourceProvider(ResourceProviderDescriptor resourceProviderDescriptor) throws InstantiationException {
        ((EnterpriseArchive)this.config).addResourceProvider(resourceProviderDescriptor);
        if (this.state_ == 1) {
            try {
                ((ApplicationStateRunning)this.appState).addResourceProvider(resourceProviderDescriptor);
            }
            catch (InstantiationException instantiationException) {
                ((EnterpriseArchive)this.config).removeResourceProvider(resourceProviderDescriptor.getName());
                throw instantiationException;
            }
        }
    }

    public void removeResourceProvider(String name) throws InstantiationException {
        if (!((EnterpriseArchive)this.config).removeResourceProvider(name)) {
            throw new InstantiationException("Unable to remove resource-provider with name " + name + " as it does not appear to exist");
        }
    }

    void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void sendNotification(String msgId, String[] params) {
        if (this._notifier != null) {
            this._notifier.sendNotification(msgId, params);
        }
    }

    private synchronized UserManager getUserManagerFromConfig() {
        UserManager usrmngr = this.config.getUserManager();
        if (usrmngr == null) {
            throw new UnsupportedOperationException("User Manager not defined for this application");
        }
        return usrmngr;
    }

    private void serverExtentionPreInitApplication() throws InstantiationException {
        if (ApplicationServer.serverExtensionProviders != null) {
            for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                ApplicationServer.serverExtensionProviders[i].preInitApplication((AttributeContainer)((Object)this.config), this);
            }
        }
    }

    private void serverExtentionPostInitApplication() throws InstantiationException {
        if (ApplicationServer.serverExtensionProviders != null) {
            for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                ApplicationServer.serverExtensionProviders[i].postInitApplication((AttributeContainer)((Object)this.config), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopOrStartAllChildApplications(int finalAppState) {
        Application[] childListCopy = null;
        ArrayList<Application> childrenToManage = null;
        int[] appStates = new int[]{0, 1, 2, 3, 4};
        Application application = this;
        synchronized (application) {
            if (this.children != null) {
                childListCopy = this.children.toArray(new Application[this.children.size()]);
            }
        }
        if (childListCopy != null) {
            int childrenToManageCnt;
            for (int i = 0; i < childListCopy.length; ++i) {
                Application childApplication = childListCopy[i];
                int childApplicationState = childApplication.getstate();
                if (childApplicationState == appStates[finalAppState - 1] || childApplicationState == appStates[finalAppState]) continue;
                if (childrenToManage == null) {
                    childrenToManage = new ArrayList<Application>();
                }
                m_logger.log(Level.FINE, "Adding childApplication: " + childApplication.getName() + " to the stop list");
                childrenToManage.add(childApplication);
            }
            if (childrenToManage != null && (childrenToManageCnt = childrenToManage.size()) > 0) {
                CountDown done = new CountDown(childrenToManageCnt);
                for (int i = 0; i < childrenToManageCnt; ++i) {
                    ApplicationLifeCycleHelper childToManage = new ApplicationLifeCycleHelper((Application)childrenToManage.get(i), finalAppState, done);
                    this.server.getThreadPool().launch(childToManage);
                }
                try {
                    done.acquire();
                }
                catch (InterruptedException e) {
                    m_logger.log(Level.FINE, "Interrupted while waiting for child applications to reach " + finalAppState);
                    return;
                }
            }
        }
    }

    private void persistJACC() throws InstantiationException {
        if (JaccWrapper.isJaccEnabled()) {
            try {
                new JaccWrapper(this.name).finishDeployment();
            }
            catch (Exception e) {
                m_logger.log(Level.WARNING, "Exception persisting jacc for " + this.name, e);
                throw new InstantiationException(e.toString());
            }
        }
    }

    private void stateCleanUp(boolean destroy) {
        EJBContainer ejbContainer;
        m_logger.fine("removing user application MBeans");
        this.removeUserApplicationMBeans();
        HttpServer httpServer = this.server.getHttpServer();
        if (httpServer != null) {
            if (this.name.equals("default")) {
                httpServer.invalidateHttpApplications(new HttpApplicationReference(this.name, null), destroy, true);
            } else {
                httpServer.invalidateHttpApplications(new HttpApplicationReference(this.name, null), destroy, false);
            }
            m_logger.fine("Invalidating HTTP applications that are part of application " + this.name);
        }
        if ((ejbContainer = this.appState.getEJBContainer()) != null) {
            m_logger.fine("destroying EJB container");
            ejbContainer.destroy();
        }
        this.appState.destroyActiveRunningStateObjects(this.logger);
        m_logger.fine("destroying aplication classloaders");
        this.appState.destroyClassLoaders();
        this.flushWebAppConfigs();
        TransportManager.getInstance().undeployApplication(this.name);
    }

    private void setDefaultMailSessionProperties(ApplicationConfig config) {
        MailSessionInfo mailSessionInfo = config.getDefaultMailSession(true);
        if (this.parent == null && mailSessionInfo != null) {
            Session defaultSession = Session.getDefaultInstance((Properties)this.config.getDefaultMailSession(true).getProperties(), null);
            Properties properties = defaultSession.getProperties();
            properties.putAll((Map<?, ?>)mailSessionInfo.getProperties());
        }
    }

    int getUserDelegationType() {
        return this.userDelegationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStart(boolean state) throws IOException, InstantiationException {
        ApplicationServerConfig conf;
        boolean currentState = this._applicationConfigReference.getStart();
        if (currentState == state) {
            return;
        }
        this._applicationConfigReference.setStart(state);
        ApplicationServerConfig applicationServerConfig = conf = this.server.getConfig();
        synchronized (applicationServerConfig) {
            conf.store();
        }
    }

    void setDefaultApplication(boolean defaultApplication) {
        this.defaultApplication = defaultApplication;
    }

    void setUserDelegationType(int userDelegationType) {
        this.userDelegationType = userDelegationType;
    }

    void setApplicationConfigReference(ApplicationConfigReference reference) {
        this._applicationConfigReference = reference;
    }

    public Map getWebApplicationConfigs() {
        return this.webApplicationConfigs;
    }

    ApplicationState getApplicationStateObj() {
        return this.appState;
    }

    void setApplicationStateObj(ApplicationState newState) {
        this.appState = newState;
    }

    protected ConnectorArchive getDataSourceConnectorArchive() {
        return this.m_dataSourceConnectorArchive;
    }

    public void setDataSourceConnectorArchive(ConnectorArchive archive) {
        this.m_dataSourceConnectorArchive = archive;
    }

    void setDevTestParameters(boolean mode, EJBContainer ejbContainer) {
        this.devtestMode = mode;
        this.mockEjbContainer = ejbContainer;
    }

    boolean isDevTestMode() {
        return this.devtestMode;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            return super.getName();
        }
        return this.name;
    }

    public synchronized SharedLibraryImport[] getSharedLibraryImports() {
        ArrayList<SharedLibraryImport> result = new ArrayList<SharedLibraryImport>();
        SharedLibraryImport[] parentImports = this.parent == null ? null : this.parent.getSharedLibraryImports();
        ImportedSharedLibrariesType sharedLibs = this.config.getImportedSharedLibraries();
        if (sharedLibs != null) {
            String[] removals = sharedLibs.getRemovals();
            for (int i = 0; i < removals.length; ++i) {
                Application.remove(removals[i], parentImports);
            }
            ImportSharedLibraryType[] imports = sharedLibs.getImports();
            for (int j = 0; j < imports.length; ++j) {
                ImportSharedLibraryType i = imports[j];
                SharedLibraryImport lib = new SharedLibraryImport(i.getName(), i.getMinVersion(), i.getMaxVersion(), false);
                result.add(lib);
                Application.remove(lib.getName(), parentImports);
            }
        }
        if (parentImports != null) {
            for (int i = 0; i < parentImports.length; ++i) {
                SharedLibraryImport parentImport = parentImports[i];
                if (parentImport == null) continue;
                parentImport.setInherited(true);
                result.add(parentImport);
            }
        }
        return (SharedLibraryImport[])ArrayUtils.toArray((Class)SharedLibraryImport.class, result, (boolean)true);
    }

    public synchronized void addImportSharedLibrary(String libraryName, String minVersion, String maxVersion) throws InstantiationException {
        ImportedSharedLibrariesType sharedLibs = null;
        ImportSharedLibraryElement sharedLibElem = null;
        InstantiationException ie = null;
        if (this.findIfSharedLibExists(libraryName, minVersion, maxVersion)) {
            try {
                if (this.config.getImportedSharedLibraries() == null) {
                    this.config.setImportedSharedLibraries(new ImportedSharedLibrariesElement());
                }
                if ((sharedLibs = this.config.getImportedSharedLibraries()).addImport(sharedLibElem = new ImportSharedLibraryElement(libraryName, minVersion, maxVersion))) {
                    this.config.storeInDeployment();
                } else {
                    ie = new InstantiationException("Shared library '" + libraryName + "' already exists for the application. Please remove the existing import with" + " <deleteImportSharedLibrary> option before importing the new shared library.");
                }
            }
            catch (Exception ex) {
                this.config.getImportedSharedLibraries().deleteImport(libraryName);
                InstantiationException iExec = new InstantiationException(ex.getMessage());
                iExec.initCause(ex);
                throw iExec;
            }
            if (ie != null) {
                throw ie;
            }
        }
    }

    private boolean findIfSharedLibExists(String libraryName, String minVersion, String maxVersion) throws InstantiationException {
        PolicyClassLoader sharedLib;
        boolean foundSharedLib;
        block12: {
            foundSharedLib = false;
            sharedLib = null;
            try {
                sharedLib = ClassLoaderQuery.findSharedPublicLoader((String)libraryName, (String)minVersion, (String)maxVersion);
            }
            catch (NumberFormatException ex) {
                if (ex == null) break block12;
                InstantiationException versionEx = new InstantiationException("Invalid min/max version specified.");
                versionEx.initCause(ex);
                throw versionEx;
            }
        }
        if (sharedLib == null) {
            String message = null;
            if (minVersion == null && maxVersion != null && maxVersion.length() > 0) {
                message = "No shared library '" + libraryName + "' exists with maximum version " + maxVersion;
            } else if (minVersion != null && minVersion.length() > 0 && maxVersion == null) {
                message = "No shared library '" + libraryName + "' exists with minimum version " + minVersion;
            } else if (minVersion != null && minVersion.length() > 0 && maxVersion != null && maxVersion.length() > 0) {
                message = "No shared library '" + libraryName + "' exists between version range [" + minVersion + "," + maxVersion + "]";
            } else if (minVersion == null || maxVersion == null) {
                message = "No shared library with name '" + libraryName + "' exists";
            }
            if (message != null) {
                throw new InstantiationException(message);
            }
        }
        if (sharedLib != null) {
            foundSharedLib = true;
        }
        return foundSharedLib;
    }

    public synchronized void deleteImportSharedLibrary(String libraryName) throws InstantiationException {
        ImportedSharedLibrariesType sharedLibs = null;
        ImportSharedLibraryType sharedLibElem = null;
        InstantiationException ie = null;
        try {
            sharedLibs = this.config.getImportedSharedLibraries();
            if (sharedLibs != null && sharedLibs.hasImport(libraryName)) {
                sharedLibElem = sharedLibs.deleteImport(libraryName);
                this.config.storeInDeployment();
            } else {
                ie = new InstantiationException("Shared library '" + libraryName + "' is not imported by the application.");
            }
        }
        catch (Exception ex) {
            this.config.getImportedSharedLibraries().addImport(sharedLibElem);
            InstantiationException iExec = new InstantiationException(ex.getMessage());
            iExec.initCause(ex);
            throw iExec;
        }
        if (ie != null) {
            throw ie;
        }
    }

    public synchronized void addRemoveInheritedSharedLibrary(String libraryName) throws InstantiationException {
        ImportedSharedLibrariesType sharedLibs = null;
        InstantiationException ie = null;
        if (this.findIfSharedLibExists(libraryName, null, null)) {
            try {
                if (this.config.getImportedSharedLibraries() == null) {
                    this.config.setImportedSharedLibraries(new ImportedSharedLibrariesElement());
                }
                if ((sharedLibs = this.config.getImportedSharedLibraries()).addRemoval(libraryName)) {
                    this.config.storeInDeployment();
                } else {
                    ie = new InstantiationException("<remove-inherited> shared library element '" + libraryName + "' already exists for the application. Please remove the existing element with" + " <deleteRemoveInheritedSharedLibrary> option before adding the <remove-inherited> " + "element.");
                }
            }
            catch (Exception ex) {
                this.config.getImportedSharedLibraries().deleteRemove(libraryName);
                InstantiationException iExec = new InstantiationException(ex.getMessage());
                iExec.initCause(ex);
                throw iExec;
            }
            if (ie != null) {
                throw ie;
            }
        }
    }

    public synchronized void deleteRemoveInheritedSharedLibrary(String libraryName) throws InstantiationException {
        ImportedSharedLibrariesType sharedLibs = null;
        InstantiationException ie = null;
        try {
            sharedLibs = this.config.getImportedSharedLibraries();
            if (sharedLibs != null && sharedLibs.hasRemoval(libraryName)) {
                sharedLibs.deleteRemove(libraryName);
                this.config.storeInDeployment();
            } else {
                ie = new InstantiationException("<remove-inherited> shared library element '" + libraryName + "' is not present in the application.");
            }
        }
        catch (Exception ex) {
            this.config.getImportedSharedLibraries().addRemoval(libraryName);
            InstantiationException iExec = new InstantiationException(ex.getMessage());
            iExec.initCause(ex);
            throw iExec;
        }
        if (ie != null) {
            throw ie;
        }
    }

    private static void remove(String name, SharedLibraryImport[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                SharedLibraryImport sl = list[i];
                if (sl == null || !sl.getName().equals(name)) continue;
                list[i] = null;
                break;
            }
        }
    }

    public synchronized void createNativeDataSource(String dataSourceName, String user, String password, String jndiLocation, Integer loginTimeout, String dataSourceClass, String url, PropertyConfig[] properties) throws DataSourceConfigException, DataSourceException, MBeanException {
        try {
            this.appState.initNativeDataSource(new NativeDataSourceConfig(user, password, dataSourceClass, jndiLocation, dataSourceName, url, loginTimeout, properties), true);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToCreateDataSourceMessage("native data source"), e);
        }
    }

    public void removeNativeDataSource(String dataSourceName) throws DataSourceException, MBeanException {
        try {
            this.appState.removeNativeDataSource(dataSourceName);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToRemoveDataSourceMessage("native data source"), e);
        }
    }

    public synchronized void copyNativeDataSource(String dataSourceToCopy, String newJndiLocation, String newDataSourceName) throws DataSourceConfigException, DataSourceException, MBeanException {
        try {
            this.appState.copyNativeDataSource(dataSourceToCopy, newJndiLocation, newDataSourceName);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToCopyDataSourceMessage("native data source"), e);
        }
    }

    public synchronized void createDataSourceConnectionPool(String name, String factoryClass, String user, String password, String url) throws DataSourceConfigException, DataSourceException, MBeanException, ResourceException {
        ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig(factoryClass, user, password, url, 0, null, null, null, null, null);
        try {
            this.appState.initDataSourceConnectionPool(new ConnectionPoolConfig(connectionFactoryConfig, name), true);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToCreateDataSourceMessage("data source connection pool"), e);
        }
    }

    public void copyDataSourceConnectionPool(String connectionPoolToCopy, String newName, String newFactoryClass) throws DataSourceException, DataSourceConfigException, MBeanException, ResourceException {
        try {
            this.appState.copyDataSourceConnectionPool(connectionPoolToCopy, newName, newFactoryClass);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToCopyDataSourceMessage("data source connection pool"), e);
        }
    }

    public void removeDataSourceConnectionPool(String name) throws DataSourceException, MBeanException {
        try {
            this.appState.removeDataSourceConnectionPool(name);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToRemoveDataSourceMessage("data source connection pool"), e);
        }
    }

    public synchronized void createManagedDataSource(String dataSourceName, String user, String password, String jndiLocation, Integer loginTimeout, String connectionPoolName, String txLevel, String dbSchema, boolean manageLocalTransactions) throws DataSourceConfigException, DataSourceException {
        ManagedDataSourceConfig config = new ManagedDataSourceConfig(user, password, connectionPoolName, jndiLocation, dataSourceName, txLevel, loginTimeout, dbSchema, manageLocalTransactions);
        try {
            this.appState.initManagedDataSource(config, true);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToCreateDataSourceMessage("managed data source"), e);
        }
    }

    public void removeManagedDataSource(String dataSourceName) throws DataSourceException, MBeanException {
        try {
            this.appState.removeManagedDataSource(dataSourceName);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToRemoveDataSourceMessage("managed data source"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedDataSourceAndConnectionPool(String dataSourceName) throws DataSourceException, MBeanException {
        Application application = this;
        synchronized (application) {
            ManagedDataSourceConfig mdsConfig = (ManagedDataSourceConfig)this.getManagedDataSourceConfigs().get(dataSourceName);
            if (mdsConfig != null) {
                String poolName = mdsConfig.getConnectionPoolName();
                this.appState.removeManagedDataSource(dataSourceName);
                ResourceAdapterImpl resourceAdapter = (ResourceAdapterImpl)this.getDataSourceConnectorArchive().getResourceAdapter();
                DataSourceConnectionPool dscp = resourceAdapter.getDataSourceConnectionPool(poolName);
                if (dscp != null && resourceAdapter.getNumConnectionFactories(poolName) == 0) {
                    this.appState.removeDataSourceConnectionPool(poolName);
                }
            }
        }
    }

    public void copyManagedDataSource(String dataSourceToCopy, String newJndiLocation, String newDataSourceName) throws DataSourceConfigException, DataSourceException {
        try {
            this.appState.copyManagedDataSource(dataSourceToCopy, newJndiLocation, newDataSourceName);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToCopyDataSourceMessage("managed data source"), e);
        }
    }

    public HashMap getNativeDataSourceConfigs() {
        return this.m_nativeDataSourceConfigs;
    }

    public HashMap getManagedDataSourceConfigs() {
        return this.m_managedDataSourceConfigs;
    }

    private DataSourceBaseConfig getDataSourceConfigForJNDILocation(HashMap dataSourceConfigs, String jndiLocation) {
        Iterator iterator = dataSourceConfigs.values().iterator();
        while (iterator.hasNext()) {
            DataSourceBaseConfig dsConfig = (DataSourceBaseConfig)iterator.next();
            if (!dsConfig.getJndiName().equals(jndiLocation)) continue;
            return dsConfig;
        }
        return null;
    }

    public NativeDataSourceConfig getNativeDataSourceConfigForJNDILocation(String jndiLocation) {
        return (NativeDataSourceConfig)this.getDataSourceConfigForJNDILocation(this.m_nativeDataSourceConfigs, jndiLocation);
    }

    public ManagedDataSourceConfig getManagedDataSourceConfigForJNDILocation(String jndiLocation) {
        return (ManagedDataSourceConfig)this.getDataSourceConfigForJNDILocation(this.m_managedDataSourceConfigs, jndiLocation);
    }

    public DataSourceConnectionPool getDataSourceConnectionPool(String name) {
        return this.appState.getDataSourceConnectionPool(name);
    }

    public void renameManagedDataSource(String dataSourceName, String newName) throws DataSourceConfigException, DataSourceException {
        try {
            this.appState.renameManagedDataSource(dataSourceName, newName);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToRenameDataSourceMessage("managed data source"), e);
        }
    }

    public void renameNativeDataSource(String dataSourceName, String newName) throws DataSourceConfigException, DataSourceException {
        try {
            this.appState.renameNativeDataSource(dataSourceName, newName);
        }
        catch (ApplicationStateStopped.ApplicationStoppedException e) {
            throw new DataSourceException(ServerMessages.getUnableToRenameDataSourceMessage("native data source"), e);
        }
    }

    protected void addDataSourceConnectionPoolMBean(DataSourceConnectionPool connectionPool) throws MBeanException {
        String connectionPoolName = connectionPool.getName();
        try {
            ConnectionPoolJDBCResourceCallBackImpl callBack = new ConnectionPoolJDBCResourceCallBackImpl(this, connectionPool);
            ConnectionPoolJDBCResource mbean = new ConnectionPoolJDBCResource(connectionPoolName, (ConnectionPoolJDBCResourceCallBack)callBack);
            mbean.registerMBean();
        }
        catch (MBeanException exception) {
            ServerMessages.severeDSRegisterMBeanException("data source connection pool", connectionPoolName, exception.getMessage());
            throw exception;
        }
    }

    public void removeNativeDataSourceMBean(DataSource dataSource, NativeDataSourceConfig nativeDataSourceConfig) throws MBeanException {
        NativeJDBCDataSourceCallBackImpl callBack = new NativeJDBCDataSourceCallBackImpl(dataSource, nativeDataSourceConfig, this);
        NativeJDBCDataSource mbean = new NativeJDBCDataSource(nativeDataSourceConfig.getName(), (NativeJDBCDataSourceCallBack)callBack);
        mbean.unregisterMBean();
    }

    public void removeDataSourceConnectionPoolMBean(DataSourceConnectionPool connectionPool) throws MBeanException {
        String connectionPoolName = connectionPool.getName();
        try {
            ConnectionPoolJDBCResourceCallBackImpl callBack = new ConnectionPoolJDBCResourceCallBackImpl(this, connectionPool);
            ConnectionPoolJDBCResource mbean = new ConnectionPoolJDBCResource(connectionPoolName, (ConnectionPoolJDBCResourceCallBack)callBack);
            mbean.unregisterMBean();
        }
        catch (MBeanException exception) {
            ServerMessages.severeDSUnRegisterMBeanException("data source connection pool", connectionPoolName, exception.getMessage());
            throw exception;
        }
    }

    void addManagedDataSourceMBean(ManagedConnectionFactoryImpl mcf, ManagedDataSourceConfig mdsc) throws MBeanException {
        ManagedDataSource managedDataSource = mcf.getManagedDataSource();
        try {
            ManagedJDBCDataSourceCallBackImpl callBack = new ManagedJDBCDataSourceCallBackImpl(managedDataSource, mdsc, this);
            ManagedJDBCDataSource mbean = new ManagedJDBCDataSource(mcf.getDataSourceConnectionPool().getName(), managedDataSource.getDataSourceName(), callBack);
            mbean.registerMBean();
        }
        catch (MBeanException exception) {
            ServerMessages.severeDSRegisterMBeanException("managed data source", managedDataSource.getDataSourceName(), exception.getMessage());
            throw exception;
        }
    }

    public void removeManagedDataSourceMBean(String name) throws MBeanException, DataSourceException {
        ManagedConnectionFactoryImpl mcf = this.getManagedConnectionFactory(name);
        if (mcf == null) {
            String msg = ServerMessages.warningDSUnRegisterMBeanNoConnectionFactory(name);
            throw new DataSourceException(msg);
        }
        ManagedDataSource managedDataSource = mcf.getManagedDataSource();
        try {
            ManagedJDBCDataSourceCallBackImpl callBack = new ManagedJDBCDataSourceCallBackImpl(managedDataSource, mcf.getManagedDataSourceConfig(), this);
            ManagedJDBCDataSource mbean = new ManagedJDBCDataSource(mcf.getDataSourceConnectionPool().getName(), managedDataSource.getDataSourceName(), callBack);
            mbean.unregisterMBean();
        }
        catch (MBeanException exception) {
            ServerMessages.severeDSUnRegisterMBeanException("managed data source", managedDataSource.getDataSourceName(), exception.getMessage());
            throw exception;
        }
    }

    private ManagedConnectionFactoryImpl getManagedConnectionFactory(String name) {
        ManagedConnectionFactoryImpl mcf = null;
        ConnectorArchive dataSourcesConnectorArchive = this.getDataSourceConnectorArchive();
        if (dataSourcesConnectorArchive != null) {
            HashMap connectionManagers = dataSourcesConnectorArchive.getConnectionManagers();
            Iterator iter = connectionManagers.values().iterator();
            while (iter.hasNext()) {
                ApplicationConnectionManager connectionManager = (ApplicationConnectionManager)iter.next();
                mcf = (ManagedConnectionFactoryImpl)connectionManager.getMcf();
                if (!name.equals(mcf.getManagedDataSourceConfig().getName())) continue;
                return mcf;
            }
        }
        return null;
    }

    void addNativeDataSourceMBean(DataSource nativeDataSource, NativeDataSourceConfig config) throws MBeanException {
        NativeJDBCDataSourceCallBackImpl callBack = new NativeJDBCDataSourceCallBackImpl(nativeDataSource, config, this);
        NativeJDBCDataSource mbean = new NativeJDBCDataSource(config.getName(), (NativeJDBCDataSourceCallBack)callBack);
        mbean.registerMBean();
    }

    public String getDefaultDataSourceJNDILocation() {
        String location = this.config.getDefaultDataSource();
        return location == null ? "" : location;
    }

    public void persistDataSourceConfig() throws IOException {
        try {
            this.config.storeDataSources();
        }
        catch (IOException ioe) {
            ServerMessages.warningPersistDataSourceException(ioe.getMessage());
            throw ioe;
        }
    }

    public void setMailSessions(List mailSessions) throws InstantiationException {
        int i;
        if (this.mailSessions != null && !this.mailSessions.isEmpty()) {
            for (i = 0; i < this.mailSessions.size(); ++i) {
                try {
                    String location = ((MailSessionInfo)this.mailSessions.get(i)).getLocation();
                    if (location == null) continue;
                    this.context.unbind(location);
                    continue;
                }
                catch (NamingException e) {
                    // empty catch block
                }
            }
        }
        this.removeAllJavaMailResourceMBeans();
        this.mailSessions = mailSessions;
        if (this.mailSessions != null && !this.mailSessions.isEmpty()) {
            try {
                for (i = 0; i < this.mailSessions.size(); ++i) {
                    MailSessionInfo info = (MailSessionInfo)this.mailSessions.get(i);
                    if (info.getLocation() == null) continue;
                    this.context.rebind(info.getLocation(), info.getSession(), 0);
                    this.addJavaMailResourceMBean(info);
                }
            }
            catch (NamingException e) {
                throw new InstantiationException("Error binding mail-sessions: " + e.getMessage());
            }
        }
    }

    public void undeployCleanUp() throws DeployerException {
        if (this.getEJBContainer() != null) {
            this.getEJBContainer().undeployCleanup(this.config.getURL().getFile());
        }
    }

    public void destroyContextObject(String name) {
        try {
            ApplicationContext ctx = this.getContext();
            Object instance = ctx.lookup(name);
            ctx.destroy(name);
            if (instance instanceof LoggingDestroyable) {
                ((LoggingDestroyable)instance).destroy(this.getLogger());
            } else if (instance instanceof Destroyable) {
                ((Destroyable)instance).destroy();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hasChanged(List componentsToRefresh) {
        Application application = this;
        synchronized (application) {
            if (this.state_ == 2 || this.state_ == 3) {
                return;
            }
        }
        if (this.config.isUpdated()) {
            this.refreshState = 0;
            componentsToRefresh.add(this);
            return;
        }
        if (this.config.isArchiveUpdated()) {
            this.refreshState = 1;
            componentsToRefresh.add(this);
            return;
        }
        HttpServer httpServer = this.server.getHttpServer();
        if (httpServer != null) {
            List httpApplicationsList = httpServer.getHttpApplicationsOf(this);
            Iterator iterator = httpApplicationsList.iterator();
            while (iterator.hasNext()) {
                HttpApplication httpApplication = (HttpApplication)iterator.next();
                httpApplication.hasChanged(componentsToRefresh);
            }
        }
    }

    public void refresh() {
        switch (this.refreshState) {
            case 0: {
                this.refreshApplication();
                break;
            }
            case 1: {
                this.refreshApplicationWithArchiveChanges();
            }
        }
    }

    private void refreshApplication() {
        try {
            this.config.update();
            this.restartRecursive();
        }
        catch (InstantiationException e) {
            m_logger.log(Level.WARNING, "Error updating application: " + this.name + ": " + e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshApplicationWithArchiveChanges() {
        try {
            Object object = this.stateMgmtLock;
            synchronized (object) {
                this.doStop();
                FileUtils.autoUnpack(this.config.getArchiveURL(), true, this.logger);
                Context applicationContext = this.config.getContext();
                if (applicationContext instanceof MemoryArchiveContext && !((MemoryArchiveContext)applicationContext).isUpToDate()) {
                    ((MemoryArchiveContext)applicationContext).unload();
                }
                this.config.update();
                this.startRecursive();
            }
        }
        catch (InstantiationException e) {
            System.err.println("Error updating application: " + this.name + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWebApplicationConfigs(HttpApplicationDescriptor changedDescriptor) {
        String string = this.webApplicationConfigsLock;
        synchronized (string) {
            Iterator iterator = this.webApplicationConfigs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                HttpApplicationConfig descriptor = (HttpApplicationConfig)entry.getValue();
                if (descriptor != changedDescriptor) continue;
                iterator.remove();
                Application application = this;
                synchronized (application) {
                    if (this.appState.getWebApplications() != null) {
                        this.appState.getWebApplications().remove(entry.getKey().toString());
                    }
                }
            }
        }
    }

    Object getStateMgmtLock() {
        return this.stateMgmtLock;
    }

    public boolean getIIOPEnabled() {
        return this.getApplicationConfigReference().isIiopEnabled();
    }

    public void stop(Map params) {
        if (params == null) {
            this.stop();
            return;
        }
        int timeout = this.getStopTimeout(params);
        boolean graceful = this.getStopMode(params);
        m_logger.log(Level.FINEST, "In validateAndStopApp method. About to stop application: " + this.name + "with parameters - " + "timeout: " + timeout + " -graceful: " + graceful);
        try {
            this.stop(timeout, graceful);
        }
        catch (InstantiationException e) {
            m_logger.log(Level.SEVERE, "Unable to stop application. \n" + e);
            throw new RuntimeException("Unable to stop application: " + this.name, e);
        }
        m_logger.log(Level.FINEST, "In validateAndStopApp method. Successfully stopped application: " + this.name);
    }

    private int getStopTimeout(Map params) {
        if (params.containsKey(TIMEOUT)) {
            return Integer.parseInt((String)params.get(TIMEOUT));
        }
        return 0;
    }

    private boolean getStopMode(Map params) {
        if (params.containsKey(FORCE)) {
            return Boolean.valueOf((String)params.get(FORCE));
        }
        return true;
    }

    private void stop(int timeout, boolean graceful) throws InstantiationException {
        int state_ = this.getstate();
        if (state_ == 2 || state_ == 3) {
            throw new InstantiationException("Application: " + this.name + " is either STOPPING or is already STOPPED.");
        }
        this.setStopTimeout(timeout * 1000);
        if (!graceful) {
            m_logger.log(Level.FINEST, "Force flag is true. Terminating!");
            try {
                this.stopForceful();
            }
            catch (Exception e) {
                m_logger.log(Level.FINEST, "Exception while terminating: " + e);
                InstantiationException pe = new InstantiationException("Exception while stopping application: " + this.name);
                pe.initCause(e);
                throw pe;
            }
            return;
        }
        if (timeout == 0) {
            this.stop();
            return;
        }
        PerformTask task = new PerformTask(this);
        TimedCallable tc = new TimedCallable(task, timeout * 1000);
        try {
            tc.call();
        }
        catch (Exception e) {
            m_logger.log(Level.FINE, "Task not complete. Forcefully stopping app");
            try {
                this.stopForceful();
            }
            catch (Exception ex) {
                m_logger.log(Level.FINE, "Exception while terminating app forcefully: " + ex);
            }
        }
    }

    private void setStopTimeout(int timeout) {
        this.stopTimeout = new SynchronizedInt(timeout);
    }

    public int getStopTimeout() {
        return this.stopTimeout.get();
    }

    public void persistConfigChange(boolean persistAppConfig, boolean persistRoutingId, boolean persistUserManager, boolean persistDataSources) throws IOException, InstantiationException {
        if (persistAppConfig) {
            ((ServerComponent)((Object)this.config)).storeDeployment();
        }
        if (persistRoutingId) {
            ApplicationServerConfig conf = this.server.getConfig();
            conf.store();
        }
        if (persistUserManager) {
            UserManager usrmngr = this.getUserManagerFromConfig();
            usrmngr.store();
        }
        if (persistDataSources) {
            this.persistDataSourceConfig();
        }
    }

    public boolean isConfiguredForClustering() {
        JGroupConfig jConfig = this.getConfig().getClusterConfig();
        return jConfig != null;
    }

    int getGenerationNumber() {
        return this.generationNumber;
    }

    static boolean isGroupShared(Application appl, ApplicationServer appServer) {
        JGroupConfig clusterConfig = appl.getConfig().getClusterConfig();
        if (clusterConfig == null) {
            return false;
        }
        String groupName = clusterConfig.getGroupName();
        Iterator itr = appServer.getActiveApplications().iterator();
        while (itr.hasNext()) {
            JGroupConfig jConfig;
            Application app = (Application)itr.next();
            if (appl == app || (jConfig = app.getConfig().getClusterConfig()) == null || !groupName.equals(jConfig.getGroupName())) continue;
            return true;
        }
        return false;
    }

    public void addORMITunnelingRoutingInfo() {
        if ("system".equals(this.getName())) {
            return;
        }
        Collection ejbModules = this.getConfig().getEJBPackages();
        if (OC4JServer.getOPMNEnabled() && ejbModules != null && ejbModules.size() != 0) {
            String rootCtx = null;
            rootCtx = "default".equals(this.getName()) ? "/.rmiTunnel" : "/" + this.getName() + ".rmiTunnel";
            OC4JMonitorThread.addRoutingInfo(this.getRoutingId(), this.getName(), rootCtx, true);
        }
    }

    public PersistenceUnitManager getPersistenceUnitManager() {
        return this.appState.getPersistenceUnitManager();
    }

    public Properties getProperties() {
        return this.config.getProperties();
    }

    public ResourceProviderDetail[] getresourceProviders() {
        List list = this.config.getResourceProviders();
        ResourceProviderDetail[] resourceProviders = new ResourceProviderDetail[list.size()];
        Iterator iterator = list.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ResourceProviderDescriptor resourceProviderDescriptor = (ResourceProviderDescriptor)iterator.next();
            resourceProviders[i++] = new ResourceProviderDetail(resourceProviderDescriptor.getClassName(), resourceProviderDescriptor.getName(), resourceProviderDescriptor.getDescription(), resourceProviderDescriptor.getProperties());
        }
        return resourceProviders;
    }

    public void setProperty(String name, String value) throws UnSupportedMBeanOperationException {
        this.config.setProperty(name, value);
        OC4JProperty oc4jProperty = new OC4JProperty(name, value, value, "String", this.name, false);
        this.applicationProperties.setProperty(oc4jProperty);
    }

    public String getProperty(String name) {
        return this.config.getProperty(name);
    }

    public void removeProperty(String name) throws UnSupportedMBeanOperationException {
        this.config.removeProperty(name);
        this.applicationProperties.removeProperty(name);
    }

    public boolean isFirstInitialization() {
        return this.config.applicationExplodedFirstTime();
    }

    public synchronized List getChildren() {
        return this.children;
    }

    public synchronized void reregisterWithParent(String parentName) throws InstantiationException {
        this.parent = this.server.getApplication(parentName);
        if (this.parent != null) {
            m_logger.fine("Adding application to parent: " + this.parent.getName() + "'s list");
            this.parent.addChild(this);
        }
    }

    private class ApplicationProperties
    extends OC4JProperties {
        private ApplicationProperties() {
        }

        public void setProperty(OC4JProperty property) {
            OC4JProperties.setOC4JProperty(property.getName(), property);
        }

        public void removeProperty(String propertyName) {
            OC4JProperties.properties.remove(propertyName);
            System.getProperties().remove(propertyName);
        }
    }

    class WebModuleCollectionModificationListener
    implements CollectionModificationListener {
        WebModuleCollectionModificationListener() {
        }

        public final void notifyRemove(CollectionModificationEvent event) {
            String name = (String)event.getKey();
            Application.this.removeWebModuleMBean(name);
            Application.this.removeOC4JWebModuleMBean(name);
        }

        public final void notifyAdd(CollectionModificationEvent event) {
            String name = (String)event.getKey();
            WebModuleCallBackIf callBackIf = (WebModuleCallBackIf)event.getValue();
            if (!callBackIf.isSynthetic()) {
                Application.this.addWebModuleMBean(callBackIf, name);
                Application.this.addOC4JWebModuleMBean((OC4JWebModuleCallBackIf)event.getValue(), name);
            }
        }
    }

    private static class PerformTask
    implements Callable {
        private Application app = null;

        public PerformTask(Application app) {
            this.app = app;
        }

        public Object call() throws Exception {
            this.app.stop();
            return null;
        }
    }
}

