/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.OC4JRestarter;
import com.evermind.server.ThreadState;
import java.lang.reflect.Method;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.oc4j.admin.config.ApplicationServerConfig;

public class ApplicationServerShutdownHandler
implements Runnable {
    protected ApplicationServer server;
    protected boolean restart;
    protected Thread shutdownHook;
    protected String reason;
    protected boolean force;
    private ThreadState launcherThreadState = null;

    public ApplicationServerShutdownHandler(ApplicationServer server, String reason) {
        this.server = server;
        this.reason = reason;
    }

    public ApplicationServerShutdownHandler(ApplicationServer server, boolean restart, boolean force, String reason) {
        this(server, restart, force, reason, null);
    }

    public ApplicationServerShutdownHandler(ApplicationServer server, boolean restart, boolean force, String reason, ThreadState threadState) {
        this.server = server;
        this.restart = restart;
        this.force = force;
        this.reason = reason;
        this.launcherThreadState = threadState;
        if (this.server == null) {
            throw new NullPointerException("server was null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean secure = this.server.securityManager.secure;
        int verbosity = this.server.getVerbosityLevel();
        ApplicationServerConfig config = this.server.getConfig();
        PolicyClassLoader oc4jLoader = ClassLoaderQuery.getMainLoader();
        boolean launchEventChecker = this.server.enableMonitorEventChecker();
        while (this.launcherThreadState != null && this.launcherThreadState.getContextContainer() != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                System.out.println("ApplicationServerShutdownHandler - Caught InterruptedException" + e);
                break;
            }
        }
        if (this.restart) {
            ApplicationServer e = this.server;
            synchronized (e) {
                try {
                    config.update();
                }
                catch (InstantiationException e2) {
                    System.err.println("[SEVERE] Error while updating server configuration. Check recent changes made to configuration files. OC4J server cannot be restarted.\n" + e2);
                    this.restart = false;
                }
            }
        }
        this.server.destroy(this.reason);
        if (ApplicationServer.ENABLE_JCACHE && !this.restart) {
            try {
                Class<?> cacheClass = Class.forName("oracle.ias.cache.Cache");
                Method cacheClose = cacheClass.getMethod("close", null);
                cacheClose.invoke(cacheClass, null);
            }
            catch (ClassNotFoundException ne) {
            }
            catch (Exception e) {
                this.server.log("Unable to shutdown JAVACACHE", e);
            }
        }
        if (this.force) {
            System.exit(0);
        }
        if (this.restart) {
            OC4JRestarter launcher = new OC4JRestarter(secure, verbosity, launchEventChecker, config);
            Thread.currentThread().setContextClassLoader((ClassLoader)oc4jLoader);
            ApplicationServerThread thread = new ApplicationServerThread(null, (Runnable)launcher, "OC4J Restarter", 0L);
            thread.setContextClassLoader((ClassLoader)oc4jLoader);
            thread.start();
        }
    }
}

